/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;

public interface IInputMethod
extends IInterface {
    public void attachToken(IBinder var1) throws RemoteException;

    public void bindInput(InputBinding var1) throws RemoteException;

    public void createSession(IInputMethodCallback var1) throws RemoteException;

    public void hideSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void restartInput(IInputContext var1, EditorInfo var2) throws RemoteException;

    public void revokeSession(IInputMethodSession var1) throws RemoteException;

    public void setSessionEnabled(IInputMethodSession var1, boolean var2) throws RemoteException;

    public void showSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void startInput(IInputContext var1, EditorInfo var2) throws RemoteException;

    public void unbindInput() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethod {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethod";
        static final int TRANSACTION_attachToken = 1;
        static final int TRANSACTION_bindInput = 2;
        static final int TRANSACTION_createSession = 6;
        static final int TRANSACTION_hideSoftInput = 10;
        static final int TRANSACTION_restartInput = 5;
        static final int TRANSACTION_revokeSession = 8;
        static final int TRANSACTION_setSessionEnabled = 7;
        static final int TRANSACTION_showSoftInput = 9;
        static final int TRANSACTION_startInput = 4;
        static final int TRANSACTION_unbindInput = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IInputMethod asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethod) {
                IInputMethod iInputMethod = (IInputMethod)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            void var8_26;
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    this.attachToken(iBinder);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputBinding inputBinding = parcel.readInt() != 0 ? InputBinding.CREATOR.createFromParcel(parcel) : null;
                    this.bindInput(inputBinding);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unbindInput();
                    return true;
                }
                case 4: {
                    void var8_14;
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        EditorInfo editorInfo = EditorInfo.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var8_15 = null;
                    }
                    this.startInput(iInputContext, (EditorInfo)var8_14);
                    return true;
                }
                case 5: {
                    void var8_17;
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        EditorInfo editorInfo = EditorInfo.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var8_18 = null;
                    }
                    this.restartInput(iInputContext, (EditorInfo)var8_17);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodCallback iInputMethodCallback = IInputMethodCallback.Stub.asInterface(parcel.readStrongBinder());
                    this.createSession(iInputMethodCallback);
                    return true;
                }
                case 7: {
                    void var8_20;
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodSession iInputMethodSession = IInputMethodSession.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Object var8_19 = null;
                    } else {
                        Object var8_21 = null;
                    }
                    this.setSessionEnabled(iInputMethodSession, (boolean)var8_20);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodSession iInputMethodSession = IInputMethodSession.Stub.asInterface(parcel.readStrongBinder());
                    this.revokeSession(iInputMethodSession);
                    return true;
                }
                case 9: {
                    void var8_23;
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var8_24 = null;
                    }
                    this.showSoftInput(n3, (ResultReceiver)var8_23);
                    return true;
                }
                case 10: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n4 = parcel.readInt();
            if (parcel.readInt() != 0) {
                ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(parcel);
            } else {
                Object var8_27 = null;
            }
            this.hideSoftInput(n4, (ResultReceiver)var8_26);
            return true;
        }

        private static class Proxy
        implements IInputMethod {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void attachToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void bindInput(InputBinding inputBinding) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputBinding != null) {
                        parcel.writeInt(1);
                        inputBinding.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createSession(IInputMethodCallback iInputMethodCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodCallback != null ? iInputMethodCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(6, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void hideSoftInput(int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void restartInput(IInputContext iInputContext, EditorInfo editorInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl = this.mRemote.transact(5, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void revokeSession(IInputMethodSession iInputMethodSession) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodSession != null ? iInputMethodSession.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(8, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodSession != null ? iInputMethodSession.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl2 = this.mRemote.transact(7, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showSoftInput(int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startInput(IInputContext iInputContext, EditorInfo editorInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

