/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.InputBindResult;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodManager
extends IInterface {
    public void addClient(IInputMethodClient var1, IInputContext var2, int var3, int var4) throws RemoteException;

    public void finishInput(IInputMethodClient var1) throws RemoteException;

    public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException;

    public List<InputMethodInfo> getInputMethodList() throws RemoteException;

    public void hideMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean hideSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public void removeClient(IInputMethodClient var1) throws RemoteException;

    public void setInputMethod(IBinder var1, String var2) throws RemoteException;

    public boolean setInputMethodEnabled(String var1, boolean var2) throws RemoteException;

    public void showInputMethodPickerFromClient(IInputMethodClient var1) throws RemoteException;

    public void showMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean showSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public InputBindResult startInput(IInputMethodClient var1, IInputContext var2, EditorInfo var3, boolean var4, boolean var5) throws RemoteException;

    public void updateStatusIcon(IBinder var1, String var2, int var3) throws RemoteException;

    public void windowGainedFocus(IInputMethodClient var1, IBinder var2, boolean var3, boolean var4, int var5, boolean var6, int var7) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodManager {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethodManager";
        static final int TRANSACTION_addClient = 3;
        static final int TRANSACTION_finishInput = 6;
        static final int TRANSACTION_getEnabledInputMethodList = 2;
        static final int TRANSACTION_getInputMethodList = 1;
        static final int TRANSACTION_hideMySoftInput = 12;
        static final int TRANSACTION_hideSoftInput = 8;
        static final int TRANSACTION_removeClient = 4;
        static final int TRANSACTION_setInputMethod = 11;
        static final int TRANSACTION_setInputMethodEnabled = 15;
        static final int TRANSACTION_showInputMethodPickerFromClient = 10;
        static final int TRANSACTION_showMySoftInput = 13;
        static final int TRANSACTION_showSoftInput = 7;
        static final int TRANSACTION_startInput = 5;
        static final int TRANSACTION_updateStatusIcon = 14;
        static final int TRANSACTION_windowGainedFocus = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IInputMethodManager asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethodManager) {
                IInputMethodManager iInputMethodManager = (IInputMethodManager)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            IInputContext iInputContext;
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getEnabledInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IInputContext iInputContext2 = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    this.addClient(iInputMethodClient, iInputContext2, n3, n4);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    this.removeClient(iInputMethodClient);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    InputBindResult inputBindResult = this.startInput(iInputMethodClient, iInputContext, editorInfo, bl, bl2);
                    parcel2.writeNoException();
                    if (inputBindResult != null) {
                        parcel2.writeInt(1);
                        inputBindResult.writeToParcel(parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    this.finishInput(iInputMethodClient);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n5 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.showSoftInput(iInputMethodClient, n5, resultReceiver);
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n7 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.hideSoftInput(iInputMethodClient, n7, resultReceiver);
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 9: {
                    EditorInfo editorInfo;
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IBinder iBinder = parcel.readStrongBinder();
                    if (parcel.readInt() != 0) {
                        Object var15_27 = null;
                    } else {
                        boolean bl = false;
                    }
                    boolean bl = parcel.readInt() != 0;
                    int n9 = parcel.readInt();
                    boolean bl3 = parcel.readInt() != 0;
                    int n10 = parcel.readInt();
                    this.windowGainedFocus(iInputMethodClient, iBinder, (boolean)editorInfo, bl, n9, bl3, n10);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    this.showInputMethodPickerFromClient(iInputMethodClient);
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string2 = parcel.readString();
                    this.setInputMethod(iBinder, string2);
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    int n11 = parcel.readInt();
                    this.hideMySoftInput(iBinder, n11);
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    int n12 = parcel.readInt();
                    this.showMySoftInput(iBinder, n12);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string3 = parcel.readString();
                    int n13 = parcel.readInt();
                    this.updateStatusIcon(iBinder, string3, n13);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            String string4 = parcel.readString();
            if (parcel.readInt() != 0) {
                Object var14_22 = null;
            } else {
                boolean bl = false;
            }
            boolean bl = this.setInputMethodEnabled(string4, (boolean)iInputContext);
            parcel2.writeNoException();
            int n14 = bl ? 1 : 0;
            parcel2.writeInt(n14);
            return true;
        }

        private static class Proxy
        implements IInputMethodManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addClient(IInputMethodClient iInputMethodClient, IInputContext iInputContext, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    iBinder = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishInput(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<InputMethodInfo> arrayList;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<InputMethodInfo> creator = InputMethodInfo.CREATOR;
                    ArrayList<InputMethodInfo> arrayList2 = arrayList = parcel2.createTypedArrayList(creator);
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public List<InputMethodInfo> getInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<InputMethodInfo> arrayList;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<InputMethodInfo> creator = InputMethodInfo.CREATOR;
                    ArrayList<InputMethodInfo> arrayList2 = arrayList = parcel2.createTypedArrayList(creator);
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void hideMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hideSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl2 = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    bl = n2 != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setInputMethod(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setInputMethodEnabled(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl3 = n2 != 0;
                    return bl3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showInputMethodPickerFromClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void showMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean showSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl2 = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    bl = n2 != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputBindResult startInput(IInputMethodClient iInputMethodClient, IInputContext iInputContext, EditorInfo editorInfo, boolean bl, boolean bl2) throws RemoteException {
                InputBindResult inputBindResult;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    iBinder = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    iBinder = bl2 ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl3 = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    inputBindResult = parcel2.readInt() != 0 ? InputBindResult.CREATOR.createFromParcel(parcel2) : null;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return inputBindResult;
            }

            @Override
            public void updateStatusIcon(IBinder iBinder, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void windowGainedFocus(IInputMethodClient iInputMethodClient, IBinder iBinder, boolean bl, boolean bl2, int n, boolean bl3, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder2 = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeStrongBinder(iBinder);
                    iBinder2 = bl ? null : null;
                    parcel.writeInt((int)iBinder2);
                    iBinder2 = bl2 ? null : null;
                    parcel.writeInt((int)iBinder2);
                    parcel.writeInt(n);
                    iBinder2 = bl3 ? null : null;
                    parcel.writeInt((int)iBinder2);
                    parcel.writeInt(n2);
                    boolean bl4 = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

