/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import com.android.internal.view.IInputMethodCallback;

public interface IInputMethodSession
extends IInterface {
    public void appPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void dispatchKeyEvent(int var1, KeyEvent var2, IInputMethodCallback var3) throws RemoteException;

    public void dispatchTrackballEvent(int var1, MotionEvent var2, IInputMethodCallback var3) throws RemoteException;

    public void displayCompletions(CompletionInfo[] var1) throws RemoteException;

    public void finishInput() throws RemoteException;

    public void finishSession() throws RemoteException;

    public void toggleSoftInput(int var1, int var2) throws RemoteException;

    public void updateCursor(Rect var1) throws RemoteException;

    public void updateExtractedText(int var1, ExtractedText var2) throws RemoteException;

    public void updateSelection(int var1, int var2, int var3, int var4, int var5, int var6) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodSession {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethodSession";
        static final int TRANSACTION_appPrivateCommand = 8;
        static final int TRANSACTION_dispatchKeyEvent = 6;
        static final int TRANSACTION_dispatchTrackballEvent = 7;
        static final int TRANSACTION_displayCompletions = 5;
        static final int TRANSACTION_finishInput = 1;
        static final int TRANSACTION_finishSession = 10;
        static final int TRANSACTION_toggleSoftInput = 9;
        static final int TRANSACTION_updateCursor = 4;
        static final int TRANSACTION_updateExtractedText = 2;
        static final int TRANSACTION_updateSelection = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IInputMethodSession asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethodSession) {
                IInputMethodSession iInputMethodSession = (IInputMethodSession)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishInput();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    ExtractedText extractedText = parcel.readInt() != 0 ? ExtractedText.CREATOR.createFromParcel(parcel) : null;
                    this.updateExtractedText(n3, extractedText);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    int n9 = parcel.readInt();
                    this.updateSelection(n4, n5, n6, n7, n8, n9);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    this.updateCursor(rect);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable.Creator<CompletionInfo> creator = CompletionInfo.CREATOR;
                    CompletionInfo[] completionInfoArray = parcel.createTypedArray(creator);
                    this.displayCompletions(completionInfoArray);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = parcel.readInt();
                    KeyEvent keyEvent = parcel.readInt() != 0 ? KeyEvent.CREATOR.createFromParcel(parcel) : null;
                    IInputMethodCallback iInputMethodCallback = IInputMethodCallback.Stub.asInterface(parcel.readStrongBinder());
                    this.dispatchKeyEvent(n10, keyEvent, iInputMethodCallback);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = parcel.readInt();
                    MotionEvent motionEvent = parcel.readInt() != 0 ? MotionEvent.CREATOR.createFromParcel(parcel) : null;
                    IInputMethodCallback iInputMethodCallback = IInputMethodCallback.Stub.asInterface(parcel.readStrongBinder());
                    this.dispatchTrackballEvent(n11, motionEvent, iInputMethodCallback);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.appPrivateCommand(string2, bundle);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = parcel.readInt();
                    int n13 = parcel.readInt();
                    this.toggleSoftInput(n12, n13);
                    return true;
                }
                case 10: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.finishSession();
            return true;
        }

        private static class Proxy
        implements IInputMethodSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void appPrivateCommand(String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void dispatchKeyEvent(int n, KeyEvent keyEvent, IInputMethodCallback iInputMethodCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (keyEvent != null) {
                        parcel.writeInt(1);
                        keyEvent.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iInputMethodCallback != null ? iInputMethodCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(6, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void dispatchTrackballEvent(int n, MotionEvent motionEvent, IInputMethodCallback iInputMethodCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (motionEvent != null) {
                        parcel.writeInt(1);
                        motionEvent.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iInputMethodCallback != null ? iInputMethodCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(7, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void displayCompletions(CompletionInfo[] completionInfoArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedArray(completionInfoArray, 0);
                    boolean bl = this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void finishInput() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void finishSession() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void toggleSoftInput(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateCursor(Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateExtractedText(int n, ExtractedText extractedText) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (extractedText != null) {
                        parcel.writeInt(1);
                        extractedText.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    parcel.writeInt(n6);
                    boolean bl = this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

