/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;

public class InputConnectionWrapper
implements InputConnection {
    private static final int MAX_WAIT_TIME_MILLIS = 2000;
    private final IInputContext mIInputContext;

    public InputConnectionWrapper(IInputContext iInputContext) {
        this.mIInputContext = iInputContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean clearMetaKeyStates(int n) {
        try {
            this.mIInputContext.clearMetaKeyStates(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        try {
            this.mIInputContext.commitCompletion(completionInfo);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        try {
            this.mIInputContext.commitText(charSequence, n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        try {
            this.mIInputContext.deleteSurroundingText(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishComposingText() {
        try {
            this.mIInputContext.finishComposingText();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCursorCapsMode(int n) {
        InputContextCallback inputContextCallback;
        int n2 = 0;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            IInputContext iInputContext = this.mIInputContext;
            int n3 = inputContextCallback.mSeq;
            iInputContext.getCursorCapsMode(n, n3, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                if (inputContextCallback.mHaveValue) {
                    n2 = inputContextCallback.mCursorCapsMode;
                }
            }
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        {
            inputContextCallback.dispose();
            return n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        InputContextCallback inputContextCallback;
        ExtractedText extractedText = null;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            IInputContext iInputContext = this.mIInputContext;
            int n2 = inputContextCallback.mSeq;
            iInputContext.getExtractedText(extractedTextRequest, n, n2, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                if (inputContextCallback.mHaveValue) {
                    extractedText = inputContextCallback.mExtractedText;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return extractedText;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getSelectedText(int n) {
        InputContextCallback inputContextCallback;
        CharSequence charSequence = null;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            IInputContext iInputContext = this.mIInputContext;
            int n2 = inputContextCallback.mSeq;
            iInputContext.getSelectedText(n, n2, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                if (inputContextCallback.mHaveValue) {
                    charSequence = inputContextCallback.mSelectedText;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        InputContextCallback inputContextCallback;
        CharSequence charSequence = null;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            IInputContext iInputContext = this.mIInputContext;
            int n3 = inputContextCallback.mSeq;
            iInputContext.getTextAfterCursor(n, n2, n3, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                if (inputContextCallback.mHaveValue) {
                    charSequence = inputContextCallback.mTextAfterCursor;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        InputContextCallback inputContextCallback;
        CharSequence charSequence = null;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            IInputContext iInputContext = this.mIInputContext;
            int n3 = inputContextCallback.mSeq;
            iInputContext.getTextBeforeCursor(n, n2, n3, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                if (inputContextCallback.mHaveValue) {
                    charSequence = inputContextCallback.mTextBeforeCursor;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performContextMenuAction(int n) {
        try {
            this.mIInputContext.performContextMenuAction(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performEditorAction(int n) {
        try {
            this.mIInputContext.performEditorAction(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        try {
            this.mIInputContext.performPrivateCommand(string2, bundle);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean reportFullscreenMode(boolean bl) {
        try {
            this.mIInputContext.reportFullscreenMode(bl);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        try {
            this.mIInputContext.sendKeyEvent(keyEvent);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setComposingRegion(int n, int n2) {
        try {
            this.mIInputContext.setComposingRegion(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        try {
            this.mIInputContext.setComposingText(charSequence, n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSelection(int n, int n2) {
        try {
            this.mIInputContext.setSelection(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    static class InputContextCallback
    extends IInputContextCallback.Stub {
        private static final String TAG = "InputConnectionWrapper.ICC";
        private static InputContextCallback sInstance = new InputContextCallback();
        private static int sSequenceNumber = 1;
        public int mCursorCapsMode;
        public ExtractedText mExtractedText;
        public boolean mHaveValue;
        public CharSequence mSelectedText;
        public int mSeq;
        public CharSequence mTextAfterCursor;
        public CharSequence mTextBeforeCursor;

        InputContextCallback() {
        }

        private void dispose() {
            synchronized (InputContextCallback.class) {
                if (sInstance == null) {
                    this.mTextAfterCursor = null;
                    this.mTextBeforeCursor = null;
                    this.mExtractedText = null;
                    sInstance = this;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static InputContextCallback getInstance() {
            synchronized (InputContextCallback.class) {
                InputContextCallback inputContextCallback;
                if (sInstance != null) {
                    inputContextCallback = sInstance;
                    sInstance = null;
                    inputContextCallback.mHaveValue = false;
                } else {
                    inputContextCallback = new InputContextCallback();
                }
                int n = sSequenceNumber;
                sSequenceNumber = n + 1;
                inputContextCallback.mSeq = n;
                return inputContextCallback;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCursorCapsMode(int n, int n2) {
            synchronized (this) {
                int n3 = this.mSeq;
                if (n2 != n3) {
                    this.mCursorCapsMode = n;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Got out-of-sequence callback ").append(n2).append(" (expected ");
                    int n4 = this.mSeq;
                    String string2 = stringBuilder.append(n4).append(") in setCursorCapsMode, ignoring.").toString();
                    int n5 = Log.i(TAG, string2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setExtractedText(ExtractedText extractedText, int n) {
            synchronized (this) {
                int n2 = this.mSeq;
                if (n != n2) {
                    this.mExtractedText = extractedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Got out-of-sequence callback ").append(n).append(" (expected ");
                    int n3 = this.mSeq;
                    String string2 = stringBuilder.append(n3).append(") in setExtractedText, ignoring.").toString();
                    int n4 = Log.i(TAG, string2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setSelectedText(CharSequence charSequence, int n) {
            synchronized (this) {
                int n2 = this.mSeq;
                if (n != n2) {
                    this.mSelectedText = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Got out-of-sequence callback ").append(n).append(" (expected ");
                    int n3 = this.mSeq;
                    String string2 = stringBuilder.append(n3).append(") in setSelectedText, ignoring.").toString();
                    int n4 = Log.i(TAG, string2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setTextAfterCursor(CharSequence charSequence, int n) {
            synchronized (this) {
                int n2 = this.mSeq;
                if (n != n2) {
                    this.mTextAfterCursor = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Got out-of-sequence callback ").append(n).append(" (expected ");
                    int n3 = this.mSeq;
                    String string2 = stringBuilder.append(n3).append(") in setTextAfterCursor, ignoring.").toString();
                    int n4 = Log.i(TAG, string2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setTextBeforeCursor(CharSequence charSequence, int n) {
            synchronized (this) {
                int n2 = this.mSeq;
                if (n != n2) {
                    this.mTextBeforeCursor = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Got out-of-sequence callback ").append(n).append(" (expected ");
                    int n3 = this.mSeq;
                    String string2 = stringBuilder.append(n3).append(") in setTextBeforeCursor, ignoring.").toString();
                    int n4 = Log.i(TAG, string2);
                }
                return;
            }
        }

        void waitForResultLocked() {
            long l = SystemClock.uptimeMillis() + 2000L;
            while (!this.mHaveValue) {
                long l2 = SystemClock.uptimeMillis();
                long l3 = l - l2;
                if (l3 <= 0L) {
                    int n = Log.w(TAG, "Timed out waiting on IInputContextCallback");
                    return;
                }
                try {
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }
}

