/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public final class ExpandedMenuView
extends ListView
implements MenuBuilder.ItemInvoker,
MenuView,
AdapterView.OnItemClickListener {
    private int mAnimations;
    private MenuBuilder mMenu;

    public ExpandedMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int[] nArray = R.styleable.MenuView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        this.mAnimations = n = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        this.setOnItemClickListener(this);
    }

    @Override
    public int getWindowAnimations() {
        return this.mAnimations;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder, int n) {
        this.mMenu = menuBuilder;
        Class<? extends Object> clazz = menuBuilder.getClass();
        MenuBuilder.MenuAdapter menuAdapter = new MenuBuilder.MenuAdapter(menuBuilder, n);
        this.setAdapter(menuAdapter);
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setChildrenDrawingCacheEnabled(false);
    }

    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.getAdapter().getItem(n);
        boolean bl = this.invokeItem(menuItemImpl);
    }

    @Override
    protected boolean recycleOnMeasure() {
        return false;
    }

    @Override
    public void updateChildren(boolean bl) {
        Adapter adapter = this.getAdapter();
        if (adapter == null) {
            return;
        }
        if (bl) {
            ((BaseAdapter)adapter).notifyDataSetInvalidated();
            return;
        }
        ((BaseAdapter)adapter).notifyDataSetChanged();
    }
}

