/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewDebug;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public final class IconMenuItemView
extends TextView
implements MenuView.ItemView {
    private static final int NO_ALPHA = 255;
    private static String sPrependShortcutLabel;
    private float mDisabledAlpha;
    private Drawable mIcon;
    private IconMenuView mIconMenuView;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private Rect mPositionIconAvailable;
    private Rect mPositionIconOutput;
    private String mShortcutCaption;
    private boolean mShortcutCaptionMode;
    private int mTextAppearance;
    private Context mTextAppearanceContext;

    public IconMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        int n2;
        float f;
        Rect rect;
        Rect rect2;
        this.mPositionIconAvailable = rect2 = new Rect();
        this.mPositionIconOutput = rect = new Rect();
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = this.getResources().getString(17040067);
        }
        int[] nArray = R.styleable.MenuView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mDisabledAlpha = f = typedArray.getFloat(6, 0.8f);
        this.mTextAppearance = n2 = typedArray.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        typedArray.recycle();
    }

    private void positionIcon() {
        if (this.mIcon == null) {
            return;
        }
        Rect rect = this.mPositionIconOutput;
        int n = this.getLineBounds(0, rect);
        Rect rect2 = this.mPositionIconAvailable;
        int n2 = this.getWidth();
        int n3 = rect.top;
        rect2.set(0, 0, n2, n3);
        int n4 = this.mIcon.getIntrinsicWidth();
        int n5 = this.mIcon.getIntrinsicHeight();
        Rect rect3 = this.mPositionIconAvailable;
        Rect rect4 = this.mPositionIconOutput;
        Gravity.apply(19, n4, n5, rect3, rect4);
        Drawable drawable2 = this.mIcon;
        Rect rect5 = this.mPositionIconOutput;
        drawable2.setBounds(rect5);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mItemData == null) {
            return;
        }
        if (this.mIcon == null) {
            return;
        }
        boolean bl = !this.mItemData.isEnabled() && (this.isPressed() || !this.isFocused());
        Drawable drawable2 = this.mIcon;
        int n = bl ? (int)(this.mDisabledAlpha * 255.0f) : 255;
        drawable2.setAlpha(n);
    }

    @Override
    @ViewDebug.CapturedViewProperty(retrieveReturn=true)
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    IconMenuView.LayoutParams getTextAppropriateLayoutParams() {
        int n;
        IconMenuView.LayoutParams layoutParams = (IconMenuView.LayoutParams)this.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new IconMenuView.LayoutParams(-1, -1);
        }
        CharSequence charSequence = this.getText();
        TextPaint textPaint = this.getPaint();
        layoutParams.desiredWidth = n = (int)Layout.getDesiredWidth(charSequence, textPaint);
        return layoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        CharSequence charSequence = menuItemImpl.getTitleForItemView(this);
        Drawable drawable2 = menuItemImpl.getIcon();
        this.initialize(charSequence, drawable2);
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        boolean bl = menuItemImpl.isEnabled();
        this.setEnabled(bl);
    }

    void initialize(CharSequence charSequence, Drawable drawable2) {
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mTextAppearance != -1) {
            Context context = this.mTextAppearanceContext;
            int n = this.mTextAppearance;
            this.setTextAppearance(context, n);
        }
        this.setTitle(charSequence);
        this.setIcon(drawable2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.positionIcon();
    }

    @Override
    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        IconMenuView.LayoutParams layoutParams = this.getTextAppropriateLayoutParams();
        this.setLayoutParams(layoutParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performClick() {
        if (super.performClick()) {
            return true;
        }
        if (this.mItemInvoker == null) return false;
        MenuBuilder.ItemInvoker itemInvoker = this.mItemInvoker;
        MenuItemImpl menuItemImpl = this.mItemData;
        if (!itemInvoker.invokeItem(menuItemImpl)) return false;
        this.playSoundEffect(0);
        return true;
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCaptionMode(boolean bl) {
        if (this.mItemData == null) {
            return;
        }
        boolean bl2 = bl && this.mItemData.shouldShowShortcut();
        this.mShortcutCaptionMode = bl2;
        CharSequence charSequence = this.mItemData.getTitleForItemView(this);
        if (this.mShortcutCaptionMode) {
            if (this.mShortcutCaption == null) {
                String string2;
                this.mShortcutCaption = string2 = this.mItemData.getShortcutLabel();
            }
            charSequence = this.mShortcutCaption;
        }
        this.setText(charSequence);
    }

    @Override
    public void setCheckable(boolean bl) {
    }

    @Override
    public void setChecked(boolean bl) {
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null) {
            int n = drawable2.getIntrinsicWidth();
            int n2 = drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, n, n2);
            this.setCompoundDrawables(null, drawable2, null, null);
            this.setGravity(81);
            this.requestLayout();
            return;
        }
        this.setCompoundDrawables(null, null, null, null);
        this.setGravity(17);
    }

    void setIconMenuView(IconMenuView iconMenuView) {
        this.mIconMenuView = iconMenuView;
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @Override
    public void setShortcut(boolean bl, char c) {
        if (!this.mShortcutCaptionMode) {
            return;
        }
        this.mShortcutCaption = null;
        this.setCaptionMode(true);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        if (this.mShortcutCaptionMode) {
            this.setCaptionMode(true);
            return;
        }
        if (charSequence == null) {
            return;
        }
        this.setText(charSequence);
    }

    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mIconMenuView == null) {
            return;
        }
        this.mIconMenuView.markStaleChildren();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }
}

