/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import java.util.ArrayList;

public final class IconMenuView
extends ViewGroup
implements MenuBuilder.ItemInvoker,
MenuView,
Runnable {
    private static final int ITEM_CAPTION_CYCLE_DELAY = 1000;
    private int mAnimations;
    private boolean mHasStaleChildren;
    private Drawable mHorizontalDivider;
    private int mHorizontalDividerHeight;
    private ArrayList<Rect> mHorizontalDividerRects;
    private Drawable mItemBackground;
    private boolean mLastChildrenCaptionMode;
    private int[] mLayout;
    private int mLayoutNumRows;
    private int mMaxItems;
    private int mMaxItemsPerRow;
    private int mMaxRows;
    private MenuBuilder mMenu;
    private boolean mMenuBeingLongpressed = false;
    private Drawable mMoreIcon;
    private IconMenuItemView mMoreItemView;
    private int mNumActualItemsShown;
    private int mRowHeight;
    private Drawable mVerticalDivider;
    private ArrayList<Rect> mVerticalDividerRects;
    private int mVerticalDividerWidth;

    public IconMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        Drawable drawable5;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = R.styleable.IconMenuView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        this.mRowHeight = n5 = typedArray.getDimensionPixelSize(0, 64);
        this.mMaxRows = n4 = typedArray.getInt(1, 2);
        this.mMaxItems = n3 = typedArray.getInt(4, 6);
        this.mMaxItemsPerRow = n2 = typedArray.getInt(2, 3);
        this.mMoreIcon = drawable5 = typedArray.getDrawable(3);
        typedArray.recycle();
        int[] nArray2 = R.styleable.MenuView;
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, nArray2, 0, 0);
        this.mItemBackground = drawable4 = typedArray2.getDrawable(5);
        this.mHorizontalDivider = drawable3 = typedArray2.getDrawable(2);
        ArrayList arrayList = new ArrayList();
        this.mHorizontalDividerRects = arrayList;
        this.mVerticalDivider = drawable2 = typedArray2.getDrawable(3);
        ArrayList arrayList2 = new ArrayList();
        this.mVerticalDividerRects = arrayList2;
        this.mAnimations = n = typedArray2.getResourceId(0, 0);
        typedArray2.recycle();
        if (this.mHorizontalDivider != null) {
            int n6;
            this.mHorizontalDividerHeight = n6 = this.mHorizontalDivider.getIntrinsicHeight();
            if (this.mHorizontalDividerHeight == -1) {
                this.mHorizontalDividerHeight = 1;
            }
        }
        if (this.mVerticalDivider != null) {
            int n7;
            this.mVerticalDividerWidth = n7 = this.mVerticalDivider.getIntrinsicWidth();
            if (this.mVerticalDividerWidth == -1) {
                this.mVerticalDividerWidth = 1;
            }
        }
        int[] nArray3 = new int[this.mMaxRows];
        this.mLayout = nArray3;
        this.setWillNotDraw(false);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
    }

    private void addItemView(IconMenuItemView iconMenuItemView) {
        iconMenuItemView.setIconMenuView(this);
        Drawable.ConstantState constantState = this.mItemBackground.getConstantState();
        Resources resources = this.getContext().getResources();
        Drawable drawable2 = constantState.newDrawable(resources);
        iconMenuItemView.setBackgroundDrawable(drawable2);
        iconMenuItemView.setItemInvoker(this);
        LayoutParams layoutParams = iconMenuItemView.getTextAppropriateLayoutParams();
        this.addView((View)iconMenuItemView, layoutParams);
    }

    private void calculateItemFittingMetadata(int n) {
        int n2 = this.mMaxItemsPerRow;
        int n3 = this.getChildCount();
        int n4 = 0;
        block0: while (n4 < n3) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(n4).getLayoutParams();
            layoutParams.maxNumItemsOnRow = 1;
            int n5 = n2;
            while (true) {
                block7: {
                    block6: {
                        if (n5 <= 0) break block6;
                        int n6 = layoutParams.desiredWidth;
                        int n7 = n / n5;
                        if (n6 >= n7) break block7;
                        layoutParams.maxNumItemsOnRow = n5;
                    }
                    ++n4;
                    continue block0;
                }
                n5 += -1;
            }
            break;
        }
        return;
    }

    private IconMenuItemView createMoreItemView() {
        IconMenuItemView iconMenuItemView = (IconMenuItemView)this.mMenu.getMenuType(0).getInflater().inflate(17367080, null);
        CharSequence charSequence = this.getContext().getResources().getText(17040066);
        Drawable drawable2 = this.mMoreIcon;
        iconMenuItemView.initialize(charSequence, drawable2);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                MenuBuilder.Callback callback = IconMenuView.this.mMenu.getCallback();
                if (callback == null) {
                    return;
                }
                MenuBuilder menuBuilder = IconMenuView.this.mMenu;
                callback.onMenuModeChange(menuBuilder);
            }
        };
        iconMenuItemView.setOnClickListener(onClickListener);
        return iconMenuItemView;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doItemsFit() {
        block6: {
            var1_1 = 0;
            var2_2 = this.mLayout;
            var3_3 = this.mLayoutNumRows;
            block0: for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                var5_5 = var2_2[var4_4];
                if (var5_5 == 1) {
                    ++var1_1;
lbl8:
                    // 2 sources

                    continue block0;
                }
                var7_7 = var1_1;
                for (var6_6 = var5_5; var6_6 > 0; var6_6 += -1) {
                    var1_1 = var7_7 + 1;
                    if (((LayoutParams)this.getChildAt((int)var7_7).getLayoutParams()).maxNumItemsOnRow < var5_5) {
                        var8_8 = false;
lbl15:
                        // 2 sources

                        return var8_8;
                    }
                    var7_7 = var1_1;
                }
                break block6;
            }
            var8_8 = true;
            ** while (true)
        }
        var1_1 = var7_7;
        ** while (true)
    }

    private void layoutItems(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            this.mLayoutNumRows = 0;
            return;
        }
        float f = n2;
        float f2 = this.mMaxItemsPerRow;
        int n3 = (int)Math.ceil(f / f2);
        int n4 = this.mMaxRows;
        int n5 = Math.min(n3, n4);
        int n6;
        while (n5 <= (n6 = this.mMaxRows)) {
            this.layoutItemsUsingGravity(n5, n2);
            if (n5 >= n2) {
                return;
            }
            if (this.doItemsFit()) {
                return;
            }
            ++n5;
        }
        return;
    }

    private void layoutItemsUsingGravity(int n, int n2) {
        int n3 = n2 / n;
        int n4 = n2 % n;
        int n5 = n - n4;
        int[] nArray = this.mLayout;
        for (int i = 0; i < n; ++i) {
            int n6;
            nArray[i] = n3;
            if (i < n5) continue;
            nArray[i] = n6 = nArray[i] + 1;
        }
        this.mLayoutNumRows = n;
    }

    private void positionChildren(int n, int n2) {
        if (this.mHorizontalDivider != null) {
            this.mHorizontalDividerRects.clear();
        }
        if (this.mVerticalDivider != null) {
            this.mVerticalDividerRects.clear();
        }
        int n3 = this.mLayoutNumRows;
        int n4 = n3 - 1;
        int[] nArray = this.mLayout;
        int n5 = 0;
        LayoutParams layoutParams = null;
        float f = 0.0f;
        int n6 = this.mHorizontalDividerHeight;
        int n7 = n3 - 1;
        int n8 = n6 * n7;
        float f2 = n2 - n8;
        float f3 = n3;
        float f4 = f2 / f3;
        int n9 = 0;
        int n10;
        int n11;
        while ((n11 = ++n9) < (n10 = n3)) {
            Rect rect;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            float f5 = 0.0f;
            int n17 = this.mVerticalDividerWidth;
            int n18 = nArray[n9] - 1;
            int n19 = n17 * n18;
            float f6 = n - n19;
            float f7 = nArray[n9];
            float f8 = f6 / f7;
            int n20 = 0;
            while ((n16 = ++n20) < (n15 = (n14 = nArray[n9]))) {
                int n21;
                int n22;
                int n23;
                int n24;
                IconMenuView iconMenuView = this;
                int n25 = n5++;
                View view = iconMenuView.getChildAt(n25);
                int n26 = View.MeasureSpec.makeMeasureSpec((int)f8, 0x40000000);
                int n27 = View.MeasureSpec.makeMeasureSpec((int)f4, 0x40000000);
                View view2 = view;
                int n28 = n26;
                int n29 = n27;
                view2.measure(n28, n29);
                layoutParams = (LayoutParams)view.getLayoutParams();
                layoutParams.left = n24 = (int)f5;
                layoutParams.right = n23 = (int)(f5 + f8);
                layoutParams.top = n22 = (int)f;
                layoutParams.bottom = n21 = (int)(f + f4);
                float f9 = f5 + f8;
                if (this.mVerticalDivider != null) {
                    ArrayList<Rect> arrayList = this.mVerticalDividerRects;
                    int n30 = (int)f9;
                    int n31 = (int)f;
                    int n32 = (int)((float)this.mVerticalDividerWidth + f9);
                    int n33 = (int)(f + f4);
                    Rect rect2 = new Rect(n30, n31, n32, n33);
                    boolean bl = arrayList.add(rect2);
                }
                float f10 = this.mVerticalDividerWidth;
                f5 = f9 + f10;
            }
            if (layoutParams != null) {
                int n34;
                layoutParams.right = n34 = n;
            }
            f += f4;
            if (this.mHorizontalDivider == null || (n13 = n9) >= (n12 = n4)) continue;
            ArrayList<Rect> arrayList = this.mHorizontalDividerRects;
            int n35 = (int)f;
            int n36 = (int)((float)this.mHorizontalDividerHeight + f);
            Rect rect3 = rect;
            int n37 = 0;
            int n38 = n35;
            int n39 = n;
            int n40 = n36;
            rect3(n37, n38, n39, n40);
            boolean bl = arrayList.add(rect);
            float f11 = this.mHorizontalDividerHeight;
            float f12 = f + f11;
        }
        return;
    }

    private void setChildrenCaptionMode(boolean bl) {
        this.mLastChildrenCaptionMode = bl;
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            ((IconMenuItemView)this.getChildAt(n)).setCaptionMode(bl);
            n += -1;
        }
        return;
    }

    private void setCycleShortcutCaptionMode(boolean bl) {
        if (!bl) {
            boolean bl2 = this.removeCallbacks(this);
            this.setChildrenCaptionMode(false);
            this.mMenuBeingLongpressed = false;
            return;
        }
        this.setChildrenCaptionMode(true);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 82) return super.dispatchKeyEvent(keyEvent);
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            boolean bl = this.removeCallbacks(this);
            long l = ViewConfiguration.getLongPressTimeout();
            boolean bl2 = this.postDelayed(this, l);
            return super.dispatchKeyEvent(keyEvent);
        }
        if (keyEvent.getAction() != 1) return super.dispatchKeyEvent(keyEvent);
        if (this.mMenuBeingLongpressed) {
            this.setCycleShortcutCaptionMode(false);
            return true;
        }
        boolean bl = this.removeCallbacks(this);
        return super.dispatchKeyEvent(keyEvent);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    public int[] getLayout() {
        return this.mLayout;
    }

    public int getLayoutNumRows() {
        return this.mLayoutNumRows;
    }

    int getNumActualItemsShown() {
        return this.mNumActualItemsShown;
    }

    @Override
    public int getWindowAnimations() {
        return this.mAnimations;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder, int n) {
        this.mMenu = menuBuilder;
        this.updateChildren(true);
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    void markStaleChildren() {
        if (this.mHasStaleChildren) {
            return;
        }
        this.mHasStaleChildren = true;
        this.requestLayout();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        boolean bl = this.requestFocus();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.setCycleShortcutCaptionMode(false);
        super.onDetachedFromWindow();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        Drawable drawable2;
        int n;
        ArrayList<Rect> arrayList;
        Drawable drawable3 = this.mHorizontalDivider;
        if (drawable3 != null) {
            arrayList = this.mHorizontalDividerRects;
            for (n = arrayList.size() - 1; n >= 0; n += -1) {
                Rect rect = arrayList.get(n);
                drawable3.setBounds(rect);
                drawable3.draw(canvas);
            }
        }
        if ((drawable2 = this.mVerticalDivider) == null) {
            return;
        }
        arrayList = this.mVerticalDividerRects;
        n = arrayList.size() - 1;
        while (n >= 0) {
            Rect rect = arrayList.get(n);
            drawable2.setBounds(rect);
            drawable2.draw(canvas);
            n += -1;
        }
        return;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount() - 1;
        while (n5 >= 0) {
            View view = this.getChildAt(n5);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = layoutParams.left;
            int n7 = layoutParams.top;
            int n8 = layoutParams.right;
            int n9 = layoutParams.bottom;
            view.layout(n6, n7, n8, n9);
            n5 += -1;
        }
        return;
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.mHasStaleChildren) {
            this.mHasStaleChildren = false;
            this.updateChildren(false);
        }
        int n3 = IconMenuView.resolveSize(Integer.MAX_VALUE, n);
        this.calculateItemFittingMetadata(n3);
        this.layoutItems(n3);
        int n4 = this.mLayoutNumRows;
        int n5 = this.mRowHeight;
        int n6 = this.mHorizontalDividerHeight;
        int n7 = (n5 + n6) * n4;
        int n8 = this.mHorizontalDividerHeight;
        int n9 = IconMenuView.resolveSize(n7 - n8, n2);
        this.setMeasuredDimension(n3, n9);
        if (n4 <= 0) {
            return;
        }
        int n10 = this.mMeasuredWidth;
        int n11 = this.mMeasuredHeight;
        this.positionChildren(n10, n11);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        int n = savedState.focusedPosition;
        int n2 = this.getChildCount();
        if (n >= n2) {
            return;
        }
        int n3 = savedState.focusedPosition;
        View view = this.getChildAt(n3);
        if (view == null) {
            return;
        }
        boolean bl = view.requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        View view = this.getFocusedChild();
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            if (this.getChildAt(n) == view) {
                return new SavedState(parcelable, n);
            }
            n += -1;
        }
        return new SavedState(parcelable, -1);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        if (!bl) {
            this.setCycleShortcutCaptionMode(false);
        }
        super.onWindowFocusChanged(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (this.mMenuBeingLongpressed) {
            boolean bl = !this.mLastChildrenCaptionMode;
            this.setChildrenCaptionMode(bl);
        } else {
            this.mMenuBeingLongpressed = true;
            this.setCycleShortcutCaptionMode(true);
        }
        boolean bl = this.postDelayed(this, 1000L);
    }

    @Override
    public void updateChildren(boolean bl) {
        this.removeAllViews();
        ArrayList<MenuItemImpl> arrayList = this.mMenu.getVisibleItems();
        int n = arrayList.size();
        int n2 = this.mMaxItems;
        int n3 = Math.min(n2 - 1, n);
        for (int i = 0; i < n3; ++i) {
            IconMenuItemView iconMenuItemView = (IconMenuItemView)arrayList.get(i).getItemView(0, this);
            this.addItemView(iconMenuItemView);
        }
        if (n > n2) {
            int n4;
            if (this.mMoreItemView == null) {
                IconMenuItemView iconMenuItemView;
                this.mMoreItemView = iconMenuItemView = this.createMoreItemView();
            }
            IconMenuItemView iconMenuItemView = this.mMoreItemView;
            this.addItemView(iconMenuItemView);
            this.mNumActualItemsShown = n4 = n2 - 1;
            return;
        }
        if (n != n2) {
            return;
        }
        int n5 = n2 - 1;
        IconMenuItemView iconMenuItemView = (IconMenuItemView)arrayList.get(n5).getItemView(0, this);
        this.addItemView(iconMenuItemView);
        this.mNumActualItemsShown = n2;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        int bottom;
        int desiredWidth;
        int left;
        int maxNumItemsOnRow;
        int right;
        int top;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int focusedPosition;

        private SavedState(Parcel parcel) {
            super(parcel);
            int n;
            this.focusedPosition = n = parcel.readInt();
        }

        public SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.focusedPosition = n;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.focusedPosition;
            parcel.writeInt(n2);
        }
    }
}

