/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ListMenuItemView
extends LinearLayout
implements MenuView.ItemView {
    private Drawable mBackground;
    private CheckBox mCheckBox;
    private ImageView mIconView;
    private MenuItemImpl mItemData;
    private int mMenuType;
    private RadioButton mRadioButton;
    private TextView mShortcutView;
    private int mTextAppearance;
    private Context mTextAppearanceContext;
    private TextView mTitleView;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        int n2;
        Drawable drawable2;
        int[] nArray = R.styleable.MenuView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mBackground = drawable2 = typedArray.getDrawable(5);
        this.mTextAppearance = n2 = typedArray.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        typedArray.recycle();
    }

    private void insertCheckBox() {
        CheckBox checkBox;
        MenuItemImpl menuItemImpl = this.mItemData;
        int n = this.mMenuType;
        CheckBox checkBox2 = this.mCheckBox = (checkBox = (CheckBox)menuItemImpl.getLayoutInflater(n).inflate(17367101, (ViewGroup)this, false));
        this.addView(checkBox2);
    }

    private void insertIconView() {
        ImageView imageView;
        MenuItemImpl menuItemImpl = this.mItemData;
        int n = this.mMenuType;
        ImageView imageView2 = this.mIconView = (imageView = (ImageView)menuItemImpl.getLayoutInflater(n).inflate(17367102, (ViewGroup)this, false));
        this.addView((View)imageView2, 0);
    }

    private void insertRadioButton() {
        RadioButton radioButton;
        MenuItemImpl menuItemImpl = this.mItemData;
        int n = this.mMenuType;
        RadioButton radioButton2 = this.mRadioButton = (radioButton = (RadioButton)menuItemImpl.getLayoutInflater(n).inflate(17367104, (ViewGroup)this, false));
        this.addView(radioButton2);
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        this.mMenuType = n;
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        CharSequence charSequence = menuItemImpl.getTitleForItemView(this);
        this.setTitle(charSequence);
        boolean bl = menuItemImpl.isCheckable();
        this.setCheckable(bl);
        boolean bl2 = menuItemImpl.shouldShowShortcut();
        char c = menuItemImpl.getShortcut();
        this.setShortcut(bl2, c);
        Drawable drawable2 = menuItemImpl.getIcon();
        this.setIcon(drawable2);
        boolean bl3 = menuItemImpl.isEnabled();
        this.setEnabled(bl3);
    }

    @Override
    protected void onFinishInflate() {
        TextView textView;
        TextView textView2;
        super.onFinishInflate();
        Drawable drawable2 = this.mBackground;
        this.setBackgroundDrawable(drawable2);
        this.mTitleView = textView2 = (TextView)this.findViewById(16908310);
        if (this.mTextAppearance != -1) {
            TextView textView3 = this.mTitleView;
            Context context = this.mTextAppearanceContext;
            int n = this.mTextAppearance;
            textView3.setTextAppearance(context, n);
        }
        this.mShortcutView = textView = (TextView)this.findViewById(16908783);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCheckable(boolean bl) {
        CompoundButton compoundButton;
        CompoundButton compoundButton2;
        if (!bl && this.mRadioButton == null && this.mCheckBox == null) {
            return;
        }
        if (this.mRadioButton == null) {
            this.insertRadioButton();
        }
        if (this.mCheckBox == null) {
            this.insertCheckBox();
        }
        if (this.mItemData.isExclusiveCheckable()) {
            compoundButton2 = this.mRadioButton;
            compoundButton = this.mCheckBox;
        } else {
            compoundButton2 = this.mCheckBox;
            compoundButton = this.mRadioButton;
        }
        if (!bl) {
            this.mCheckBox.setVisibility(8);
            this.mRadioButton.setVisibility(8);
            return;
        }
        boolean bl2 = this.mItemData.isChecked();
        compoundButton2.setChecked(bl2);
        int n = bl ? 0 : 8;
        if (compoundButton2.getVisibility() != n) {
            compoundButton2.setVisibility(n);
        }
        if (compoundButton.getVisibility() == 8) {
            return;
        }
        compoundButton.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setChecked(boolean bl) {
        CompoundButton compoundButton;
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
        }
        compoundButton.setChecked(bl);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        MenuItemImpl menuItemImpl = this.mItemData;
        int n = this.mMenuType;
        if (!menuItemImpl.shouldShowIcon(n)) {
            return;
        }
        if (this.mIconView == null && drawable2 == null) {
            return;
        }
        if (this.mIconView == null) {
            this.insertIconView();
        }
        if (drawable2 != null) {
            this.mIconView.setImageDrawable(drawable2);
            if (this.mIconView.getVisibility() == 0) {
                return;
            }
            this.mIconView.setVisibility(0);
            return;
        }
        this.mIconView.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setShortcut(boolean bl, char c) {
        int n = bl && this.mItemData.shouldShowShortcut() ? 0 : 8;
        if (n == 0) {
            TextView textView = this.mShortcutView;
            String string2 = this.mItemData.getShortcutLabel();
            textView.setText(string2);
        }
        if (this.mShortcutView.getVisibility() != n) {
            return;
        }
        this.mShortcutView.setVisibility(n);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        if (charSequence != null) {
            this.mTitleView.setText(charSequence);
            if (this.mTitleView.getVisibility() == 0) {
                return;
            }
            this.mTitleView.setVisibility(0);
            return;
        }
        if (this.mTitleView.getVisibility() == 8) {
            return;
        }
        this.mTitleView.setVisibility(8);
    }

    @Override
    public boolean showsIcon() {
        return false;
    }
}

