/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MenuBuilder
implements Menu {
    static final int[] ITEM_LAYOUT_RES_FOR_TYPE;
    static final int[] LAYOUT_RES_FOR_TYPE;
    private static final String LOGTAG = "MenuBuilder";
    public static final int NUM_TYPES = 3;
    static final int[] THEME_RES_FOR_TYPE;
    public static final int TYPE_DIALOG = 2;
    public static final int TYPE_EXPANDED = 1;
    public static final int TYPE_ICON = 0;
    private static final String VIEWS_TAG = "android:views";
    private static final int[] sCategoryToOrder;
    private Callback mCallback;
    private final Context mContext;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    private SparseArray<Parcelable> mFrozenViewStates;
    Drawable mHeaderIcon;
    CharSequence mHeaderTitle;
    View mHeaderView;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mItems;
    private MenuType[] mMenuTypes;
    private boolean mOptionalIconsVisible = false;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mQwertyMode;
    private final Resources mResources;
    private boolean mShortcutsVisible;
    private ArrayList<MenuItemImpl> mVisibleItems;

    static {
        THEME_RES_FOR_TYPE = new int[]{16973990, 16973991, 0};
        LAYOUT_RES_FOR_TYPE = new int[]{17367081, 17367076, 0};
        ITEM_LAYOUT_RES_FOR_TYPE = new int[]{17367080, 17367103, 17367103};
        sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuBuilder(Context context) {
        Resources resources;
        MenuType[] menuTypeArray = new MenuType[3];
        this.mMenuTypes = menuTypeArray;
        this.mContext = context;
        this.mResources = resources = context.getResources();
        ArrayList arrayList = new ArrayList();
        this.mItems = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mVisibleItems = arrayList2;
        this.mIsVisibleItemsStale = true;
        boolean bl = this.mResources.getConfiguration().keyboard != 1;
        this.mShortcutsVisible = bl;
    }

    private MenuItem addInternal(int n, int n2, int n3, CharSequence charSequence) {
        int n4 = MenuBuilder.getOrdering(n3);
        MenuBuilder menuBuilder = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        CharSequence charSequence2 = charSequence;
        MenuItemImpl menuItemImpl = new MenuItemImpl(menuBuilder, n5, n6, n7, n4, charSequence2);
        if (this.mCurrentMenuInfo != null) {
            ContextMenu.ContextMenuInfo contextMenuInfo = this.mCurrentMenuInfo;
            menuItemImpl.setMenuInfo(contextMenuInfo);
        }
        ArrayList<MenuItemImpl> arrayList = this.mItems;
        int n8 = MenuBuilder.findInsertIndex(this.mItems, n4);
        arrayList.add(n8, menuItemImpl);
        this.onItemsChanged(false);
        return menuItemImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findInsertIndex(ArrayList<MenuItemImpl> arrayList, int n) {
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            if (arrayList.get(n2).getOrdering() <= n) {
                return n2 + 1;
            }
            n2 += -1;
        }
        return 0;
    }

    private int getNumIconMenuItemsShown() {
        ViewGroup viewGroup = null;
        if (!this.mMenuTypes[0].hasMenuView() && this.mMenuTypes[1].hasMenuView()) {
            viewGroup = (ViewGroup)((View)((Object)this.mMenuTypes[1].getMenuView(null))).getParent();
        }
        return ((IconMenuView)this.getMenuView(0, viewGroup)).getNumActualItemsShown();
    }

    private static int getOrdering(int n) {
        int n2;
        int n3 = (0xFFFF0000 & n) >> 16;
        if (n3 < 0 || n3 >= (n2 = sCategoryToOrder.length)) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        int n4 = sCategoryToOrder[n3] << 16;
        int n5 = 0xFFFF & n;
        return n4 | n5;
    }

    private void onItemsChanged(boolean bl) {
        if (this.mPreventDispatchingItemsChanged) {
            return;
        }
        if (!this.mIsVisibleItemsStale) {
            this.mIsVisibleItemsStale = true;
        }
        MenuType[] menuTypeArray = this.mMenuTypes;
        int n = 0;
        while (n < 3) {
            if (menuTypeArray[n] != null && menuTypeArray[n].hasMenuView()) {
                ((MenuView)menuTypeArray[n].mMenuView.get()).updateChildren(bl);
            }
            ++n;
        }
        return;
    }

    private void refreshShortcuts(boolean bl, boolean bl2) {
        int n = this.mItems.size() - 1;
        while (n >= 0) {
            MenuItemImpl menuItemImpl = this.mItems.get(n);
            if (menuItemImpl.hasSubMenu()) {
                ((MenuBuilder)((Object)menuItemImpl.getSubMenu())).refreshShortcuts(bl, bl2);
            }
            menuItemImpl.refreshShortcutOnItemViews(bl, bl2);
            n += -1;
        }
        return;
    }

    private void removeItemAtInt(int n, boolean bl) {
        if (n < 0) {
            return;
        }
        int n2 = this.mItems.size();
        if (n >= n2) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mItems.remove(n);
        if (!bl) {
            return;
        }
        this.onItemsChanged(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHeaderInternal(int n, CharSequence charSequence, int n2, Drawable drawable2, View view) {
        Resources resources = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (n > 0) {
                CharSequence charSequence2;
                this.mHeaderTitle = charSequence2 = resources.getText(n);
            } else if (charSequence != null) {
                this.mHeaderTitle = charSequence;
            }
            if (n2 > 0) {
                Drawable drawable3;
                this.mHeaderIcon = drawable3 = resources.getDrawable(n2);
            } else if (drawable2 != null) {
                this.mHeaderIcon = drawable2;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    @Override
    public MenuItem add(int n) {
        String string2 = this.mResources.getString(n);
        return this.addInternal(0, 0, 0, string2);
    }

    @Override
    public MenuItem add(int n, int n2, int n3, int n4) {
        String string2 = this.mResources.getString(n4);
        return this.addInternal(n, n2, n3, string2);
    }

    @Override
    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        return this.addInternal(n, n2, n3, charSequence);
    }

    @Override
    public MenuItem add(CharSequence charSequence) {
        return this.addInternal(0, 0, 0, charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        int n5;
        Intent intent2;
        Intent[] intentArray2;
        ComponentName componentName2;
        PackageManager packageManager = this.mContext.getPackageManager();
        PackageManager packageManager2 = packageManager;
        List<ResolveInfo> list = packageManager2.queryIntentActivityOptions(componentName2 = componentName, intentArray2 = intentArray, intent2 = intent, n5 = 0);
        int n6 = list != null ? list.size() : 0;
        if ((n4 & 1) == 0) {
            this.removeGroup(n);
        }
        int n7 = 0;
        while (n7 < n6) {
            Intent intent3;
            ResolveInfo resolveInfo = list.get(n7);
            if (resolveInfo.specificIndex < 0) {
                intent3 = intent;
            } else {
                int n8 = resolveInfo.specificIndex;
                intent3 = intentArray[n8];
            }
            Intent intent4 = new Intent(intent3);
            String string2 = resolveInfo.activityInfo.applicationInfo.packageName;
            String string3 = resolveInfo.activityInfo.name;
            ComponentName componentName3 = new ComponentName(string2, string3);
            Intent intent5 = intent4.setComponent(componentName3);
            CharSequence charSequence = resolveInfo.loadLabel(packageManager);
            MenuBuilder menuBuilder = this;
            int n9 = n;
            int n10 = n2;
            int n11 = n3;
            CharSequence charSequence2 = charSequence;
            MenuItem menuItem = menuBuilder.add(n9, n10, n11, charSequence2);
            Drawable drawable2 = resolveInfo.loadIcon(packageManager);
            MenuItem menuItem2 = menuItem.setIcon(drawable2).setIntent(intent4);
            if (menuItemArray != null && resolveInfo.specificIndex >= 0) {
                int n12 = resolveInfo.specificIndex;
                menuItemArray[n12] = menuItem2;
            }
            ++n7;
        }
        return n6;
    }

    @Override
    public SubMenu addSubMenu(int n) {
        String string2 = this.mResources.getString(n);
        return this.addSubMenu(0, 0, 0, string2);
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        String string2 = this.mResources.getString(n4);
        return this.addSubMenu(n, n2, n3, string2);
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.addInternal(n, n2, n3, charSequence);
        Context context = this.mContext;
        SubMenuBuilder subMenuBuilder = new SubMenuBuilder(context, this, menuItemImpl);
        menuItemImpl.setSubMenu(subMenuBuilder);
        return subMenuBuilder;
    }

    @Override
    public SubMenu addSubMenu(CharSequence charSequence) {
        return this.addSubMenu(0, 0, 0, charSequence);
    }

    @Override
    public void clear() {
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.onItemsChanged(true);
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    public void clearMenuViews() {
        for (int i = 2; i >= 0; i += -1) {
            if (this.mMenuTypes[i] == null) continue;
            WeakReference weakReference = MenuType.access$202(this.mMenuTypes[i], null);
        }
        int n = this.mItems.size() - 1;
        while (n >= 0) {
            MenuItemImpl menuItemImpl = this.mItems.get(n);
            if (menuItemImpl.hasSubMenu()) {
                ((SubMenuBuilder)menuItemImpl.getSubMenu()).clearMenuViews();
            }
            menuItemImpl.clearItemViews();
            n += -1;
        }
        return;
    }

    @Override
    public void close() {
        this.close(true);
    }

    final void close(boolean bl) {
        Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.onCloseMenu(this, bl);
    }

    public int findGroupIndex(int n) {
        return this.findGroupIndex(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findGroupIndex(int n, int n2) {
        int n3 = this.size();
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n2;
        while (n4 < n3) {
            if (this.mItems.get(n4).getGroupId() != n) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem findItem(int n) {
        void var5_7;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            MenuItem menuItem;
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getItemId() != n) {
                MenuItemImpl menuItemImpl2 = menuItemImpl;
                return var5_7;
            }
            if (!menuItemImpl.hasSubMenu() || (menuItem = menuItemImpl.getSubMenu().findItem(n)) == null) continue;
            MenuItem menuItem2 = menuItem;
            return var5_7;
        }
        return var5_7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findItemIndex(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            if (this.mItems.get(n3).getItemId() != n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    MenuItemImpl findItemWithShortcutForKey(int n, KeyEvent keyEvent) {
        MenuItemImpl menuItemImpl;
        char c;
        List<MenuItemImpl> list = this.findItemsWithShortcutForKey(n, keyEvent);
        if (list == null) {
            return null;
        }
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        boolean bl = keyEvent.getKeyData(keyData);
        if (list.size() == 1) {
            return list.get(0);
        }
        boolean bl2 = this.isQwertyMode();
        Iterator<MenuItemImpl> iterator = list.iterator();
        do {
            char c2;
            char c3;
            if (!iterator.hasNext()) {
                return null;
            }
            menuItemImpl = iterator.next();
            c = bl2 ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
            if (c != (c3 = keyData.meta[0])) {
                if ((n2 & 2) == 0) return menuItemImpl;
            }
            if (c == (c2 = keyData.meta[2])) continue;
            if ((n2 & 2) != 0) return menuItemImpl;
        } while (!bl2 || c != '\b' || n != 67);
        return menuItemImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    List<MenuItemImpl> findItemsWithShortcutForKey(int n, KeyEvent keyEvent) {
        boolean bl = this.isQwertyMode();
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (!keyEvent.getKeyData(keyData) && n != 67) {
            return null;
        }
        Vector<MenuItemImpl> vector = new Vector<MenuItemImpl>();
        int n3 = this.mItems.size();
        int n4 = 0;
        while (n4 < n3) {
            char c;
            char c2;
            MenuItemImpl menuItemImpl = this.mItems.get(n4);
            if (menuItemImpl.hasSubMenu()) {
                List<MenuItemImpl> list = ((MenuBuilder)((Object)menuItemImpl.getSubMenu())).findItemsWithShortcutForKey(n, keyEvent);
                boolean bl2 = vector.addAll(list);
            }
            char c3 = bl ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
            if ((n2 & 5) == 0 && c3 != null && (c3 == (c2 = keyData.meta[0]) || c3 == (c = keyData.meta[2]) || bl && c3 == '\b' && n == 67) && menuItemImpl.isEnabled()) {
                boolean bl3 = vector.add(menuItemImpl);
            }
            ++n4;
        }
        return vector;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    @Override
    public MenuItem getItem(int n) {
        return this.mItems.get(n);
    }

    public MenuAdapter getMenuAdapter(int n) {
        return new MenuAdapter(n);
    }

    MenuType getMenuType(int n) {
        if (this.mMenuTypes[n] == null) {
            MenuType menuType;
            MenuType[] menuTypeArray = this.mMenuTypes;
            menuTypeArray[n] = menuType = new MenuType(n);
        }
        return this.mMenuTypes[n];
    }

    public View getMenuView(int n, ViewGroup viewGroup) {
        if (!(n != 1 || this.mMenuTypes[0] != null && this.mMenuTypes[0].hasMenuView())) {
            MenuView menuView = this.getMenuType(0).getMenuView(viewGroup);
        }
        return (View)((Object)this.getMenuType(n).getMenuView(viewGroup));
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int n = this.mItems.size();
        for (int i = 0; i < n; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (!menuItemImpl.isVisible()) continue;
            boolean bl = this.mVisibleItems.add(menuItemImpl);
        }
        this.mIsVisibleItemsStale = false;
        return this.mVisibleItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasVisibleItems() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.mItems.get(n2).isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        if (this.findItemWithShortcutForKey(n, keyEvent) == null) return false;
        return true;
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    void onItemVisibleChanged(MenuItemImpl menuItemImpl) {
        this.onItemsChanged(false);
    }

    @Override
    public boolean performIdentifierAction(int n, int n2) {
        MenuItem menuItem = this.findItem(n);
        return this.performItemAction(menuItem, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performItemAction(MenuItem menuItem, int n) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)menuItem;
        if (menuItemImpl == null) return false;
        if (!menuItemImpl.isEnabled()) {
            return false;
        }
        boolean bl = menuItemImpl.invoke();
        if (menuItem.hasSubMenu()) {
            this.close(false);
            if (this.mCallback == null) return bl;
            Callback callback = this.mCallback;
            SubMenuBuilder subMenuBuilder = (SubMenuBuilder)menuItem.getSubMenu();
            if (callback.onSubMenuSelected(subMenuBuilder)) return true;
            if (!bl) return false;
            return true;
        }
        if ((n & 1) != 0) return bl;
        this.close(true);
        return bl;
    }

    @Override
    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        MenuItemImpl menuItemImpl = this.findItemWithShortcutForKey(n, keyEvent);
        boolean bl = false;
        if (menuItemImpl != null) {
            bl = this.performItemAction(menuItemImpl, n2);
        }
        if ((n2 & 2) != 0) {
            this.close(true);
        }
        return bl;
    }

    @Override
    public void removeGroup(int n) {
        int n2 = this.findGroupIndex(n);
        if (n2 < 0) {
            return;
        }
        int n3 = this.mItems.size() - n2;
        int n4 = 0;
        while (true) {
            int n5 = n4 + 1;
            if (n4 >= n3 || this.mItems.get(n2).getGroupId() == n) break;
            this.removeItemAtInt(n2, false);
            n4 = n5;
        }
        this.onItemsChanged(false);
    }

    @Override
    public void removeItem(int n) {
        int n2 = this.findItemIndex(n);
        this.removeItemAtInt(n2, true);
    }

    public void removeItemAt(int n) {
        this.removeItemAtInt(n, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreHierarchyState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = bundle.getSparseParcelableArray(VIEWS_TAG);
        this.mFrozenViewStates = sparseArray;
        MenuType[] menuTypeArray = this.mMenuTypes;
        int n = 2;
        while (n >= 0) {
            if (menuTypeArray[n] != null && menuTypeArray[n].hasMenuView()) {
                ((View)((Object)menuTypeArray[n].getMenuView(null))).restoreHierarchyState(sparseArray);
            }
            n += -1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveHierarchyState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = new SparseArray<Parcelable>();
        MenuType[] menuTypeArray = this.mMenuTypes;
        int n = 2;
        while (true) {
            if (n < 0) {
                bundle.putSparseParcelableArray(VIEWS_TAG, sparseArray);
                return;
            }
            if (menuTypeArray[n] != null && menuTypeArray[n].hasMenuView()) {
                ((View)((Object)menuTypeArray[n].getMenuView(null))).saveHierarchyState(sparseArray);
            }
            n += -1;
        }
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mCurrentMenuInfo = contextMenuInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setExclusiveItemChecked(MenuItem menuItem) {
        int n = menuItem.getGroupId();
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() != n && menuItemImpl.isExclusiveCheckable() && menuItemImpl.isCheckable()) {
                boolean bl = menuItemImpl == menuItem;
                menuItemImpl.setCheckedInt(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() != n) {
                menuItemImpl.setExclusiveCheckable(bl2);
                MenuItem menuItem = menuItemImpl.setCheckable(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() != n) {
                MenuItem menuItem = menuItemImpl.setEnabled(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupVisible(int n, boolean bl) {
        int n2 = this.mItems.size();
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getGroupId() == n || !menuItemImpl.setVisibleInt(bl)) continue;
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        this.onItemsChanged(false);
    }

    protected MenuBuilder setHeaderIconInt(int n) {
        MenuBuilder menuBuilder = this;
        int n2 = n;
        Drawable drawable2 = null;
        View view = null;
        menuBuilder.setHeaderInternal(0, null, n2, drawable2, view);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable drawable2) {
        MenuBuilder menuBuilder = this;
        int n = 0;
        Drawable drawable3 = drawable2;
        View view = null;
        menuBuilder.setHeaderInternal(0, null, n, drawable3, view);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(int n) {
        MenuBuilder menuBuilder = this;
        int n2 = n;
        Drawable drawable2 = null;
        View view = null;
        menuBuilder.setHeaderInternal(n2, null, 0, drawable2, view);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence charSequence) {
        MenuBuilder menuBuilder = this;
        CharSequence charSequence2 = charSequence;
        int n = 0;
        View view = null;
        menuBuilder.setHeaderInternal(0, charSequence2, n, null, view);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        MenuBuilder menuBuilder = this;
        int n = 0;
        Drawable drawable2 = null;
        View view2 = view;
        menuBuilder.setHeaderInternal(0, null, n, drawable2, view2);
        return this;
    }

    void setOptionalIconsVisible(boolean bl) {
        this.mOptionalIconsVisible = bl;
    }

    @Override
    public void setQwertyMode(boolean bl) {
        this.mQwertyMode = bl;
        boolean bl2 = this.isShortcutsVisible();
        this.refreshShortcuts(bl2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setShortcutsVisible(boolean bl) {
        if (this.mShortcutsVisible != bl) {
            return;
        }
        boolean bl2 = this.mResources.getConfiguration().keyboard != 1 && bl;
        boolean bl3 = this.mShortcutsVisible = bl2;
        boolean bl4 = this.isQwertyMode();
        this.refreshShortcuts(bl3, bl4);
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    public class MenuAdapter
    extends BaseAdapter {
        private int mMenuType;

        public MenuAdapter(int n) {
            this.mMenuType = n;
        }

        @Override
        public int getCount() {
            int n = MenuBuilder.this.getVisibleItems().size();
            int n2 = this.getOffset();
            return n - n2;
        }

        @Override
        public MenuItemImpl getItem(int n) {
            ArrayList<MenuItemImpl> arrayList = MenuBuilder.this.getVisibleItems();
            int n2 = this.getOffset() + n;
            return arrayList.get(n2);
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getOffset() {
            if (this.mMenuType != 1) return 0;
            return MenuBuilder.this.getNumIconMenuItemsShown();
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            MenuItemImpl menuItemImpl = this.getItem(n);
            int n2 = this.mMenuType;
            return menuItemImpl.getItemView(n2, viewGroup);
        }
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }

    public static interface Callback {
        public void onCloseMenu(MenuBuilder var1, boolean var2);

        public void onCloseSubMenu(SubMenuBuilder var1);

        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);

        public boolean onSubMenuSelected(SubMenuBuilder var1);
    }

    class MenuType {
        private LayoutInflater mInflater;
        private int mMenuType;
        private WeakReference<MenuView> mMenuView;

        MenuType(int n) {
            this.mMenuType = n;
        }

        static /* synthetic */ WeakReference access$202(MenuType menuType, WeakReference weakReference) {
            menuType.mMenuView = weakReference;
            return weakReference;
        }

        LayoutInflater getInflater() {
            if (this.mInflater == null) {
                LayoutInflater layoutInflater;
                Context context = MenuBuilder.this.mContext;
                int[] nArray = THEME_RES_FOR_TYPE;
                int n = this.mMenuType;
                int n2 = nArray[n];
                this.mInflater = layoutInflater = (LayoutInflater)((Context)new ContextThemeWrapper(context, n2)).getSystemService("layout_inflater");
            }
            return this.mInflater;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        MenuView getMenuView(ViewGroup viewGroup) {
            int[] nArray = LAYOUT_RES_FOR_TYPE;
            int n = this.mMenuType;
            if (nArray[n] == 0) {
                return null;
            }
            synchronized (this) {
                MenuView menuView = this.mMenuView != null ? (MenuView)this.mMenuView.get() : null;
                if (menuView != null) return menuView;
                LayoutInflater layoutInflater = this.getInflater();
                int[] nArray2 = LAYOUT_RES_FOR_TYPE;
                int n2 = this.mMenuType;
                int n3 = nArray2[n2];
                menuView = (MenuView)((Object)layoutInflater.inflate(n3, viewGroup, false));
                MenuBuilder menuBuilder = MenuBuilder.this;
                int n4 = this.mMenuType;
                menuView.initialize(menuBuilder, n4);
                WeakReference<MenuView> weakReference = new WeakReference<MenuView>(menuView);
                this.mMenuView = weakReference;
                if (MenuBuilder.this.mFrozenViewStates == null) return menuView;
                View view = (View)((Object)menuView);
                SparseArray sparseArray = MenuBuilder.this.mFrozenViewStates;
                view.restoreHierarchyState(sparseArray);
                SparseArray sparseArray2 = MenuBuilder.this.mFrozenViewStates;
                int n5 = view.getId();
                sparseArray2.remove(n5);
                return menuView;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean hasMenuView() {
            if (this.mMenuView == null) return false;
            if (this.mMenuView.get() == null) return false;
            return true;
        }
    }
}

