/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;

public class MenuDialogHelper
implements DialogInterface.OnKeyListener,
DialogInterface.OnClickListener {
    private ListAdapter mAdapter;
    private AlertDialog mDialog;
    private MenuBuilder mMenu;

    public MenuDialogHelper(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    public void dismiss() {
        if (this.mDialog == null) {
            return;
        }
        this.mDialog.dismiss();
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        MenuBuilder menuBuilder = this.mMenu;
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.mAdapter.getItem(n);
        boolean bl = menuBuilder.performItemAction(menuItemImpl, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKey(DialogInterface dialogInterface, int n, KeyEvent keyEvent) {
        if (n != 82) {
            if (n != 4) return this.mMenu.performShortcut(n, keyEvent, 0);
        }
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            Window window = this.mDialog.getWindow();
            if (window == null) return this.mMenu.performShortcut(n, keyEvent, 0);
            View view = window.getDecorView();
            if (view == null) return this.mMenu.performShortcut(n, keyEvent, 0);
            KeyEvent.DispatcherState dispatcherState = view.getKeyDispatcherState();
            if (dispatcherState == null) return this.mMenu.performShortcut(n, keyEvent, 0);
            dispatcherState.startTracking(keyEvent, this);
            return true;
        }
        if (keyEvent.getAction() != 1) return this.mMenu.performShortcut(n, keyEvent, 0);
        if (keyEvent.isCanceled()) return this.mMenu.performShortcut(n, keyEvent, 0);
        Window window = this.mDialog.getWindow();
        if (window == null) return this.mMenu.performShortcut(n, keyEvent, 0);
        View view = window.getDecorView();
        if (view == null) return this.mMenu.performShortcut(n, keyEvent, 0);
        KeyEvent.DispatcherState dispatcherState = view.getKeyDispatcherState();
        if (dispatcherState == null) return this.mMenu.performShortcut(n, keyEvent, 0);
        if (!dispatcherState.isTracking(keyEvent)) return this.mMenu.performShortcut(n, keyEvent, 0);
        this.mMenu.close(true);
        dialogInterface.dismiss();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show(IBinder iBinder) {
        int n;
        AlertDialog alertDialog;
        MenuBuilder menuBuilder = this.mMenu;
        MenuBuilder.MenuAdapter menuAdapter = menuBuilder.getMenuAdapter(2);
        this.mAdapter = menuAdapter;
        Context context = menuBuilder.getContext();
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        ListAdapter listAdapter = this.mAdapter;
        AlertDialog.Builder builder2 = builder.setAdapter(listAdapter, this);
        View view = menuBuilder.getHeaderView();
        if (view != null) {
            AlertDialog.Builder builder3 = builder2.setCustomTitle(view);
        } else {
            Drawable drawable2 = menuBuilder.getHeaderIcon();
            AlertDialog.Builder builder4 = builder2.setIcon(drawable2);
            CharSequence charSequence = menuBuilder.getHeaderTitle();
            AlertDialog.Builder builder5 = builder4.setTitle(charSequence);
        }
        AlertDialog.Builder builder6 = builder2.setOnKeyListener(this);
        AlertDialog.Builder builder7 = builder2.setRecycleOnMeasureEnabled(false);
        this.mDialog = alertDialog = builder2.create();
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.type = 1003;
        if (iBinder != null) {
            layoutParams.token = iBinder;
        }
        layoutParams.flags = n = layoutParams.flags | 0x20000;
        this.mDialog.show();
    }
}

