/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;

public final class MenuItemImpl
implements MenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    static final int NO_ICON = 0;
    private static final String TAG = "MenuItemImpl";
    private static String sDeleteShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sPrependShortcutLabel;
    private static String sSpaceShortcutLabel;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;
    private final int mGroup;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private final int mId;
    private Intent mIntent;
    private Runnable mItemCallback;
    private WeakReference<MenuView.ItemView>[] mItemViews;
    private MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private char mShortcutNumericChar;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;

    MenuItemImpl(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence) {
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = menuBuilder.getContext().getResources().getString(17040067);
            sEnterShortcutLabel = menuBuilder.getContext().getResources().getString(17040069);
            sDeleteShortcutLabel = menuBuilder.getContext().getResources().getString(17040070);
            sSpaceShortcutLabel = menuBuilder.getContext().getResources().getString(17040068);
        }
        WeakReference[] weakReferenceArray = new WeakReference[3];
        this.mItemViews = weakReferenceArray;
        this.mMenu = menuBuilder;
        this.mId = n2;
        this.mGroup = n;
        this.mCategoryOrder = n3;
        this.mOrdering = n4;
        this.mTitle = charSequence;
    }

    private MenuView.ItemView createItemView(int n, ViewGroup viewGroup) {
        LayoutInflater layoutInflater = this.getLayoutInflater(n);
        int n2 = MenuBuilder.ITEM_LAYOUT_RES_FOR_TYPE[n];
        MenuView.ItemView itemView = (MenuView.ItemView)((Object)layoutInflater.inflate(n2, viewGroup, false));
        itemView.initialize(this, n);
        return itemView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasItemView(int n) {
        if (this.mItemViews[n] == null) return false;
        if (this.mItemViews[n].get() == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean haveAnyOpenedIconCapableItemViews() {
        int n = 2;
        while (n >= 0) {
            if (this.hasItemView(n) && ((MenuView.ItemView)this.mItemViews[n].get()).showsIcon()) {
                return true;
            }
            n += -1;
        }
        return false;
    }

    private void refreshShortcutOnItemViews() {
        boolean bl = this.mMenu.isShortcutsVisible();
        boolean bl2 = this.mMenu.isQwertyMode();
        this.refreshShortcutOnItemViews(bl, bl2);
    }

    private void setIconOnViews(Drawable drawable2) {
        int n = 2;
        while (n >= 0) {
            if (this.hasItemView(n) && ((MenuView.ItemView)this.mItemViews[n].get()).showsIcon()) {
                ((MenuView.ItemView)this.mItemViews[n].get()).setIcon(drawable2);
            }
            n += -1;
        }
        return;
    }

    void clearItemViews() {
        int n = this.mItemViews.length - 1;
        while (n >= 0) {
            this.mItemViews[n] = null;
            n += -1;
        }
        return;
    }

    @Override
    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    @Override
    public int getGroupId() {
        return this.mGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId == 0) return null;
        Resources resources = this.mMenu.getResources();
        int n = this.mIconResId;
        return resources.getDrawable(n);
    }

    @Override
    public Intent getIntent() {
        return this.mIntent;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    View getItemView(int n, ViewGroup viewGroup) {
        if (!this.hasItemView(n)) {
            WeakReference<MenuView.ItemView>[] weakReferenceArray = this.mItemViews;
            MenuView.ItemView itemView = this.createItemView(n, viewGroup);
            WeakReference<MenuView.ItemView> weakReference = new WeakReference<MenuView.ItemView>(itemView);
            weakReferenceArray[n] = weakReference;
        }
        return (View)this.mItemViews[n].get();
    }

    public LayoutInflater getLayoutInflater(int n) {
        return this.mMenu.getMenuType(n).getInflater();
    }

    @Override
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    @Override
    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    @Override
    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    char getShortcut() {
        if (!this.mMenu.isQwertyMode()) return this.mShortcutNumericChar;
        return this.mShortcutAlphabeticChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getShortcutLabel() {
        char c = this.getShortcut();
        if (c == null) {
            return "";
        }
        String string2 = sPrependShortcutLabel;
        StringBuilder stringBuilder = new StringBuilder(string2);
        switch (c) {
            default: {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
                return stringBuilder.toString();
            }
            case '\n': {
                String string3 = sEnterShortcutLabel;
                StringBuilder stringBuilder3 = stringBuilder.append(string3);
                return stringBuilder.toString();
            }
            case '\b': {
                String string4 = sDeleteShortcutLabel;
                StringBuilder stringBuilder4 = stringBuilder.append(string4);
                return stringBuilder.toString();
            }
            case ' ': 
        }
        String string5 = sSpaceShortcutLabel;
        StringBuilder stringBuilder5 = stringBuilder.append(string5);
        return stringBuilder.toString();
    }

    @Override
    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getTitleCondensed() {
        if (this.mTitleCondensed == null) return this.mTitle;
        return this.mTitleCondensed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        if (itemView == null) return this.getTitle();
        if (!itemView.prefersCondensedTitle()) return this.getTitle();
        return this.getTitleCondensed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSubMenu() {
        if (this.mSubMenu == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke() {
        MenuBuilder menuBuilder;
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        MenuBuilder.Callback callback = this.mMenu.getCallback();
        if (callback != null && callback.onMenuItemSelected(menuBuilder = this.mMenu.getRootMenu(), this)) {
            return true;
        }
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return true;
        }
        if (this.mIntent == null) return false;
        try {
            Context context = this.mMenu.getContext();
            Intent intent = this.mIntent;
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            int n = Log.e(TAG, "Can't find activity to handle intent; ignoring", activityNotFoundException);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCheckable() {
        if ((this.mFlags & 1) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isChecked() {
        if ((this.mFlags & 2) != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled() {
        if ((this.mFlags & 0x10) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExclusiveCheckable() {
        if ((this.mFlags & 4) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isVisible() {
        if ((this.mFlags & 8) != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void refreshShortcutOnItemViews(boolean bl, boolean bl2) {
        char c = bl2 ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
        boolean bl3 = bl && c != null;
        int n = 2;
        while (n >= 0) {
            if (this.hasItemView(n)) {
                ((MenuView.ItemView)this.mItemViews[n].get()).setShortcut(bl3, c);
            }
            n += -1;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setAlphabeticShortcut(char c) {
        char c2;
        if (this.mShortcutAlphabeticChar != c) {
            return this;
        }
        this.mShortcutAlphabeticChar = c2 = Character.toLowerCase(c);
        this.refreshShortcutOnItemViews();
        return this;
    }

    public MenuItem setCallback(Runnable runnable) {
        this.mItemCallback = runnable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setCheckable(boolean bl) {
        int n = this.mFlags;
        int n2 = this.mFlags & 0xFFFFFFFE;
        int n3 = bl ? 1 : 0;
        int n4 = n2 | n3;
        this.mFlags = n4;
        int n5 = this.mFlags;
        if (n != n5) {
            for (int i = 2; i >= 0; i += -1) {
                if (!this.hasItemView(i)) continue;
                ((MenuView.ItemView)this.mItemViews[i].get()).setCheckable(bl);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setChecked(boolean bl) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
            return this;
        }
        this.setCheckedInt(bl);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCheckedInt(boolean bl) {
        int n = this.mFlags;
        int n2 = this.mFlags & 0xFFFFFFFD;
        int n3 = bl ? 2 : 0;
        int n4 = n2 | n3;
        this.mFlags = n4;
        int n5 = this.mFlags;
        if (n != n5) {
            return;
        }
        int n6 = 2;
        while (n6 >= 0) {
            if (this.hasItemView(n6)) {
                ((MenuView.ItemView)this.mItemViews[n6].get()).setChecked(bl);
            }
            n6 += -1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setEnabled(boolean bl) {
        int n;
        int n2;
        this.mFlags = bl ? (n2 = this.mFlags | 0x10) : (n = this.mFlags & 0xFFFFFFEF);
        int n3 = 2;
        while (n3 >= 0) {
            if (this.hasItemView(n3)) {
                ((MenuView.ItemView)this.mItemViews[n3].get()).setEnabled(bl);
            }
            n3 += -1;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExclusiveCheckable(boolean bl) {
        int n;
        int n2 = this.mFlags & 0xFFFFFFFB;
        int n3 = bl ? 4 : 0;
        this.mFlags = n = n2 | n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setIcon(int n) {
        this.mIconDrawable = null;
        this.mIconResId = n;
        if (this.haveAnyOpenedIconCapableItemViews()) {
            Drawable drawable2 = n != 0 ? this.mMenu.getResources().getDrawable(n) : null;
            this.setIconOnViews(drawable2);
        }
        return this;
    }

    @Override
    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.setIconOnViews(drawable2);
        return this;
    }

    @Override
    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setNumericShortcut(char c) {
        if (this.mShortcutNumericChar != c) {
            return this;
        }
        this.mShortcutNumericChar = c;
        this.refreshShortcutOnItemViews();
        return this;
    }

    @Override
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    @Override
    public MenuItem setShortcut(char c, char c2) {
        char c3;
        this.mShortcutNumericChar = c;
        this.mShortcutAlphabeticChar = c3 = Character.toLowerCase(c2);
        this.refreshShortcutOnItemViews();
        return this;
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        if (this.mMenu != null && this.mMenu instanceof SubMenu) {
            throw new UnsupportedOperationException("Attempt to add a sub-menu to a sub-menu.");
        }
        this.mSubMenu = subMenuBuilder;
        CharSequence charSequence = this.getTitle();
        SubMenu subMenu = subMenuBuilder.setHeaderTitle(charSequence);
    }

    @Override
    public MenuItem setTitle(int n) {
        String string2 = this.mMenu.getContext().getString(n);
        return this.setTitle(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        for (int i = 2; i >= 0; i += -1) {
            MenuView.ItemView itemView;
            if (!this.hasItemView(i) || (itemView = (MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle() && this.mTitleCondensed != null) continue;
            itemView.setTitle(charSequence);
        }
        if (this.mSubMenu != null) {
            SubMenu subMenu = this.mSubMenu.setHeaderTitle(charSequence);
        }
        return this;
    }

    @Override
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
            charSequence = this.mTitle;
        }
        for (int i = 2; i >= 0; i += -1) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle()) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setTitle(charSequence);
        }
        return this;
    }

    @Override
    public MenuItem setVisible(boolean bl) {
        if (this.setVisibleInt(bl)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setVisibleInt(boolean bl) {
        int n = this.mFlags;
        int n2 = this.mFlags & 0xFFFFFFF7;
        int n3 = bl ? 0 : 8;
        int n4 = n2 | n3;
        this.mFlags = n4;
        int n5 = this.mFlags;
        if (n == n5) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldShowIcon(int n) {
        if (n == 0) return true;
        if (!this.mMenu.getOptionalIconsVisible()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean shouldShowShortcut() {
        if (!this.mMenu.isShortcutsVisible()) return false;
        if (this.getShortcut() == null) return false;
        return true;
    }

    public String toString() {
        return ((Object)this.mTitle).toString();
    }
}

