/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class ContactHeaderWidget
extends FrameLayout
implements View.OnClickListener {
    protected static final int CONTACT_LOOKUP_ID_COLUMN_INDEX = 0;
    protected static final String[] CONTACT_LOOKUP_PROJECTION;
    protected static final int EMAIL_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int EMAIL_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] EMAIL_LOOKUP_PROJECTION;
    protected static final int PHONE_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int PHONE_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] PHONE_LOOKUP_PROJECTION;
    private static final String TAG = "ContactHeaderWidget";
    private static final int TOKEN_CONTACT_INFO = 0;
    private static final int TOKEN_EMAIL_LOOKUP = 2;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_PHOTO_QUERY = 3;
    private View mAggregateBadge;
    protected Uri mContactUri;
    protected ContentResolver mContentResolver;
    private TextView mDisplayNameView;
    protected String[] mExcludeMimes = null;
    private ContactHeaderListener mListener;
    private int mNoPhotoResource;
    private TextView mPhoneticNameView;
    private QuickContactBadge mPhotoView;
    private ImageView mPresenceView;
    private QueryHandler mQueryHandler;
    private CheckBox mStarredView;
    private TextView mStatusAttributionView;
    private TextView mStatusView;

    static {
        String[] stringArray = new String[]{"_id", "lookup"};
        PHONE_LOOKUP_PROJECTION = stringArray;
        String[] stringArray2 = new String[]{"contact_id", "lookup"};
        EMAIL_LOOKUP_PROJECTION = stringArray2;
        String[] stringArray3 = new String[]{"_id"};
        CONTACT_LOOKUP_PROJECTION = stringArray3;
    }

    public ContactHeaderWidget(Context context) {
        this(context, null);
    }

    public ContactHeaderWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContactHeaderWidget(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TextView textView;
        TextView textView2;
        ImageView imageView;
        QuickContactBadge quickContactBadge;
        CheckBox checkBox;
        TextView textView3;
        View view;
        TextView textView4;
        ContentResolver contentResolver;
        this.mContentResolver = contentResolver = this.mContext.getContentResolver();
        View view2 = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367070, (ViewGroup)this);
        this.mDisplayNameView = textView4 = (TextView)this.findViewById(16908695);
        this.mAggregateBadge = view = this.findViewById(16908694);
        this.mPhoneticNameView = textView3 = (TextView)this.findViewById(16908696);
        this.mStarredView = checkBox = (CheckBox)this.findViewById(16908700);
        this.mStarredView.setOnClickListener(this);
        this.mPhotoView = quickContactBadge = (QuickContactBadge)this.findViewById(16908693);
        this.mPresenceView = imageView = (ImageView)this.findViewById(16908699);
        this.mStatusView = textView2 = (TextView)this.findViewById(16908697);
        this.mStatusAttributionView = textView = (TextView)this.findViewById(16908698);
        int n2 = (int)SystemClock.elapsedRealtime() & 0xF;
        this.mNoPhotoResource = n2 < 9 ? 17301905 : (n2 < 14 ? 17301906 : 17301907);
        this.resetAsyncQueryHandler();
    }

    static /* synthetic */ QueryHandler access$000(ContactHeaderWidget contactHeaderWidget) {
        return contactHeaderWidget.mQueryHandler;
    }

    static /* synthetic */ Bitmap access$100(ContactHeaderWidget contactHeaderWidget, BitmapFactory.Options options) {
        return contactHeaderWidget.loadPlaceholderPhoto(options);
    }

    static /* synthetic */ QuickContactBadge access$200(ContactHeaderWidget contactHeaderWidget) {
        return contactHeaderWidget.mPhotoView;
    }

    static /* synthetic */ void access$300(ContactHeaderWidget contactHeaderWidget, Uri uri, boolean bl) {
        contactHeaderWidget.bindFromContactUriInternal(uri, bl);
    }

    private void bindFromContactUriInternal(Uri uri, boolean bl) {
        this.mContactUri = uri;
        this.startContactQuery(uri, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bitmap loadPlaceholderPhoto(BitmapFactory.Options options) {
        if (this.mNoPhotoResource == 0) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = this.mNoPhotoResource;
        return BitmapFactory.decodeResource(resources, n, options);
    }

    private void performDisplayNameClick() {
        if (this.mListener == null) {
            return;
        }
        ContactHeaderListener contactHeaderListener = this.mListener;
        TextView textView = this.mDisplayNameView;
        contactHeaderListener.onDisplayNameClick(textView);
    }

    private void performPhotoClick() {
        if (this.mListener == null) {
            return;
        }
        ContactHeaderListener contactHeaderListener = this.mListener;
        QuickContactBadge quickContactBadge = this.mPhotoView;
        contactHeaderListener.onPhotoClick(quickContactBadge);
    }

    private void resetAsyncQueryHandler() {
        QueryHandler queryHandler;
        ContentResolver contentResolver = this.mContentResolver;
        this.mQueryHandler = queryHandler = new QueryHandler(contentResolver);
    }

    private void startContactQuery(Uri uri, boolean bl) {
        if (bl) {
            this.resetAsyncQueryHandler();
        }
        QueryHandler queryHandler = this.mQueryHandler;
        String[] stringArray = ContactQuery.COLUMNS;
        Uri uri2 = uri;
        Uri uri3 = uri;
        String[] stringArray2 = null;
        String string2 = null;
        queryHandler.startQuery(0, uri2, uri3, stringArray, null, stringArray2, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void bindContactInfo(Cursor cursor) {
        CharSequence charSequence;
        int n;
        Cursor cursor2;
        String string2;
        Cursor cursor3 = cursor;
        int n2 = 3;
        String string3 = cursor3.getString(n2);
        Cursor cursor4 = cursor;
        int n3 = 4;
        String string4 = cursor4.getString(n3);
        ContactHeaderWidget contactHeaderWidget = this;
        String string5 = string3;
        String string6 = string4;
        contactHeaderWidget.setDisplayName(string5, string6);
        Cursor cursor5 = cursor;
        int n4 = 5;
        boolean bl = cursor5.getInt(n4) != 0;
        CheckBox checkBox = this.mStarredView;
        boolean bl2 = bl;
        checkBox.setChecked(bl2);
        Cursor cursor6 = cursor;
        int n5 = 6;
        if (!cursor6.isNull(n5)) {
            Cursor cursor7 = cursor;
            int n6 = 6;
            int n7 = cursor7.getInt(n6);
            ImageView imageView = this.mPresenceView;
            int n8 = ContactsContract.StatusUpdates.getPresenceIconResourceId(n7);
            imageView.setImageResource(n8);
            this.mPresenceView.setVisibility(0);
        } else {
            this.mPresenceView.setVisibility(8);
        }
        if (TextUtils.isEmpty(string2 = (cursor2 = cursor).getString(n = 7))) {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
            return;
        }
        TextView textView = this.mStatusView;
        String string7 = string2;
        textView.setText(string7);
        this.mStatusView.setVisibility(0);
        CharSequence charSequence2 = null;
        Cursor cursor8 = cursor;
        int n9 = 8;
        if (!cursor8.isNull(n9)) {
            Cursor cursor9 = cursor;
            int n10 = 8;
            long l = cursor9.getLong(n10);
            long l2 = System.currentTimeMillis();
            charSequence2 = DateUtils.getRelativeTimeSpanString(l, l2, 60000L, 262144);
        }
        Object object = null;
        Cursor cursor10 = cursor;
        int n11 = 10;
        if (!cursor10.isNull(n11)) {
            Object object2;
            Object object3;
            Cursor cursor11 = cursor;
            int n12 = 9;
            String string8 = cursor11.getString(n12);
            Cursor cursor12 = cursor;
            int n13 = 10;
            int n14 = cursor12.getInt(n13);
            if (TextUtils.isEmpty(string8)) {
                object3 = this.getResources();
            } else {
                PackageManager packageManager = this.getContext().getPackageManager();
                try {
                    PackageManager packageManager2 = packageManager;
                    String string9 = string8;
                    object3 = object2 = packageManager2.getResourcesForApplication(string9);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Contact status update resource package not found: ");
                    String string10 = string8;
                    String string11 = stringBuilder.append(string10).toString();
                    int n15 = Log.w(TAG, string11);
                    object3 = null;
                }
            }
            if (object3 != null) {
                try {
                    Resources resources = object3;
                    int n16 = n14;
                    object = object2 = resources.getString(n16);
                }
                catch (Resources.NotFoundException notFoundException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Contact status update resource not found: ");
                    String string12 = string8;
                    String string13 = stringBuilder.append(string12).append("@").append(n14).toString();
                    int n17 = Log.w(TAG, string13);
                }
            }
        }
        if (charSequence2 != null && object != null) {
            Context context = this.getContext();
            Object[] objectArray = new Object[]{charSequence2, object};
            charSequence = context.getString(17039994, objectArray);
        } else if (charSequence2 == null && object != null) {
            Context context = this.getContext();
            Object[] objectArray = new Object[]{object};
            charSequence = context.getString(17039993, objectArray);
        } else {
            charSequence = charSequence2 != null ? charSequence2 : null;
        }
        if (charSequence != null) {
            this.mStatusAttributionView.setText(charSequence);
            this.mStatusAttributionView.setVisibility(0);
            return;
        }
        this.mStatusAttributionView.setVisibility(8);
    }

    public void bindFromContactLookupUri(Uri uri) {
        this.bindFromContactUriInternal(uri, true);
    }

    public void bindFromEmail(String string2) {
        this.resetAsyncQueryHandler();
        QueryHandler queryHandler = this.mQueryHandler;
        Uri uri = ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI;
        String string3 = Uri.encode(string2);
        Uri uri2 = Uri.withAppendedPath(uri, string3);
        String[] stringArray = EMAIL_LOOKUP_PROJECTION;
        String string4 = string2;
        String[] stringArray2 = null;
        String string5 = null;
        queryHandler.startQuery(2, string4, uri2, stringArray, null, stringArray2, string5);
    }

    public void bindFromPhoneNumber(String string2) {
        this.resetAsyncQueryHandler();
        QueryHandler queryHandler = this.mQueryHandler;
        Uri uri = ContactsContract.PhoneLookup.CONTENT_FILTER_URI;
        String string3 = Uri.encode(string2);
        Uri uri2 = Uri.withAppendedPath(uri, string3);
        String[] stringArray = PHONE_LOOKUP_PROJECTION;
        String string4 = string2;
        String[] stringArray2 = null;
        String string5 = null;
        queryHandler.startQuery(1, string4, uri2, stringArray, null, stringArray2, string5);
    }

    public void enableClickListeners() {
        this.mDisplayNameView.setOnClickListener(this);
        this.mPhotoView.setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            default: {
                return;
            }
            case 16908700: {
                if (this.mContactUri == null) {
                    return;
                }
                ContentValues contentValues = new ContentValues(1);
                Boolean bl = this.mStarredView.isChecked();
                contentValues.put("starred", bl);
                ContentResolver contentResolver = this.mContentResolver;
                Uri uri = this.mContactUri;
                int n = contentResolver.update(uri, contentValues, null, null);
                return;
            }
            case 16908693: {
                this.performPhotoClick();
                return;
            }
            case 16908695: 
        }
        this.performDisplayNameClick();
    }

    public void setContactHeaderListener(ContactHeaderListener contactHeaderListener) {
        this.mListener = contactHeaderListener;
    }

    public void setContactUri(Uri uri) {
        this.setContactUri(uri, true);
    }

    public void setContactUri(Uri uri, boolean bl) {
        this.mContactUri = uri;
        if (!bl) {
            return;
        }
        this.mPhotoView.assignContactUri(uri);
    }

    public void setDisplayName(CharSequence charSequence, CharSequence charSequence2) {
        this.mDisplayNameView.setText(charSequence);
        if (!TextUtils.isEmpty(charSequence2)) {
            this.mPhoneticNameView.setText(charSequence2);
            this.mPhoneticNameView.setVisibility(0);
            return;
        }
        this.mPhoneticNameView.setVisibility(8);
    }

    public void setExcludeMimes(String[] stringArray) {
        this.mExcludeMimes = stringArray;
        this.mPhotoView.setExcludeMimes(stringArray);
    }

    public void setPhoto(Bitmap bitmap) {
        this.mPhotoView.setImageBitmap(bitmap);
    }

    public void setPresence(int n) {
        ImageView imageView = this.mPresenceView;
        int n2 = ContactsContract.StatusUpdates.getPresenceIconResourceId(n);
        imageView.setImageResource(n2);
    }

    public void setSelectedContactsAppTabIndex(int n) {
        this.mPhotoView.setSelectedContactsAppTabIndex(n);
    }

    public void setSocialSnippet(CharSequence charSequence) {
        if (charSequence == null) {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
            return;
        }
        this.mStatusView.setText(charSequence);
        this.mStatusView.setVisibility(0);
    }

    public void setStared(boolean bl) {
        this.mStarredView.setChecked(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showAggregateBadge(boolean bl) {
        View view = this.mAggregateBadge;
        int n = bl ? 0 : 8;
        view.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showStar(boolean bl) {
        CheckBox checkBox = this.mStarredView;
        int n = bl ? 0 : 8;
        checkBox.setVisibility(n);
    }

    protected void startPhotoQuery(long l, Uri uri, boolean bl) {
        if (bl) {
            this.resetAsyncQueryHandler();
        }
        QueryHandler queryHandler = this.mQueryHandler;
        Uri uri2 = ContentUris.withAppendedId(ContactsContract.Data.CONTENT_URI, l);
        String[] stringArray = PhotoQuery.COLUMNS;
        Uri uri3 = uri;
        String[] stringArray2 = null;
        String string2 = null;
        queryHandler.startQuery(3, uri3, uri2, stringArray, null, stringArray2, string2);
    }

    public void wipeClean() {
        this.resetAsyncQueryHandler();
        this.setDisplayName(null, null);
        Bitmap bitmap = this.loadPlaceholderPhoto(null);
        this.setPhoto(bitmap);
        this.setSocialSnippet(null);
        this.setPresence(0);
        this.mContactUri = null;
        this.mExcludeMimes = null;
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver contentResolver) {
            super(contentResolver);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void onQueryComplete(int var1_1, Object var2_2, Cursor var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 240->741)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static interface PhotoQuery {
        public static final String[] COLUMNS;
        public static final int PHOTO;

        static {
            String[] stringArray = new String[]{"data15"};
            COLUMNS = stringArray;
        }
    }

    private static interface ContactQuery {
        public static final String[] COLUMNS;
        public static final int CONTACT_PRESENCE_STATUS = 6;
        public static final int CONTACT_STATUS = 7;
        public static final int CONTACT_STATUS_LABEL = 10;
        public static final int CONTACT_STATUS_RES_PACKAGE = 9;
        public static final int CONTACT_STATUS_TIMESTAMP = 8;
        public static final int DISPLAY_NAME = 3;
        public static final int LOOKUP_KEY = 1;
        public static final int PHONETIC_NAME = 4;
        public static final int PHOTO_ID = 2;
        public static final int STARRED = 5;
        public static final int _ID;

        static {
            String[] stringArray = new String[]{"_id", "lookup", "photo_id", "display_name", "phonetic_name", "starred", "contact_presence", "contact_status", "contact_status_ts", "contact_status_res_package", "contact_status_label"};
            COLUMNS = stringArray;
        }
    }

    public static interface ContactHeaderListener {
        public void onDisplayNameClick(View var1);

        public void onPhotoClick(View var1);
    }
}

