/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DigitalClock
extends LinearLayout {
    private static final String M12 = "h:mm";
    private static final String M24 = "kk:mm";
    private AmPm mAmPm;
    private int mAttached = 0;
    private Calendar mCalendar;
    private String mFormat;
    private ContentObserver mFormatChangeObserver;
    private final Handler mHandler;
    private BroadcastReceiver mIntentReceiver;
    private TextView mTimeDisplay;

    public DigitalClock(Context context) {
        this(context, null);
    }

    public DigitalClock(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Handler handler;
        this.mHandler = handler = new Handler();
    }

    static /* synthetic */ Calendar access$002(DigitalClock digitalClock, Calendar calendar) {
        digitalClock.mCalendar = calendar;
        return calendar;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDateFormat() {
        String string2 = DateFormat.is24HourFormat(this.getContext()) ? M24 : M12;
        this.mFormat = string2;
        AmPm amPm = this.mAmPm;
        boolean bl = this.mFormat.equals(M12);
        amPm.setShowAmPm(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTime() {
        Calendar calendar = this.mCalendar;
        long l = System.currentTimeMillis();
        calendar.setTimeInMillis(l);
        String string2 = this.mFormat;
        Calendar calendar2 = this.mCalendar;
        CharSequence charSequence = DateFormat.format((CharSequence)string2, calendar2);
        this.mTimeDisplay.setText(charSequence);
        AmPm amPm = this.mAmPm;
        boolean bl = this.mCalendar.get(9) == 0;
        amPm.setIsMorning(bl);
    }

    @Override
    protected void onAttachedToWindow() {
        int n;
        super.onAttachedToWindow();
        this.mAttached = n = this.mAttached + 1;
        if (this.mIntentReceiver == null) {
            TimeChangedReceiver timeChangedReceiver = new TimeChangedReceiver(this);
            this.mIntentReceiver = timeChangedReceiver;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_TICK");
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            Context context = this.mContext;
            BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
            Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        }
        if (this.mFormatChangeObserver == null) {
            FormatChangeObserver formatChangeObserver = new FormatChangeObserver(this);
            this.mFormatChangeObserver = formatChangeObserver;
            ContentResolver contentResolver = this.mContext.getContentResolver();
            Uri uri = Settings.System.CONTENT_URI;
            ContentObserver contentObserver = this.mFormatChangeObserver;
            contentResolver.registerContentObserver(uri, true, contentObserver);
        }
        this.updateTime();
    }

    @Override
    protected void onDetachedFromWindow() {
        int n;
        super.onDetachedFromWindow();
        this.mAttached = n = this.mAttached - 1;
        if (this.mIntentReceiver != null) {
            Context context = this.mContext;
            BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
            context.unregisterReceiver(broadcastReceiver);
        }
        if (this.mFormatChangeObserver != null) {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            ContentObserver contentObserver = this.mFormatChangeObserver;
            contentResolver.unregisterContentObserver(contentObserver);
        }
        this.mFormatChangeObserver = null;
        this.mIntentReceiver = null;
    }

    @Override
    protected void onFinishInflate() {
        Calendar calendar;
        AmPm amPm;
        TextView textView;
        super.onFinishInflate();
        TextView textView2 = this.mTimeDisplay = (textView = (TextView)this.findViewById(16908765));
        Typeface typeface = Typeface.createFromFile("/system/fonts/Clockopia.ttf");
        textView2.setTypeface(typeface);
        Typeface typeface2 = Typeface.createFromFile("/system/fonts/DroidSans-Bold.ttf");
        this.mAmPm = amPm = new AmPm(this, typeface2);
        this.mCalendar = calendar = Calendar.getInstance();
        this.setDateFormat();
    }

    void updateTime(Calendar calendar) {
        this.mCalendar = calendar;
        this.updateTime();
    }

    private static class FormatChangeObserver
    extends ContentObserver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public FormatChangeObserver(DigitalClock digitalClock) {
            Context context;
            Handler handler = new Handler();
            super(handler);
            WeakReference<DigitalClock> weakReference = new WeakReference<DigitalClock>(digitalClock);
            this.mClock = weakReference;
            this.mContext = context = digitalClock.getContext();
        }

        @Override
        public void onChange(boolean bl) {
            DigitalClock digitalClock = (DigitalClock)this.mClock.get();
            if (digitalClock != null) {
                digitalClock.setDateFormat();
                digitalClock.updateTime();
                return;
            }
            try {
                this.mContext.getContentResolver().unregisterContentObserver(this);
                return;
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
    }

    static class AmPm {
        private TextView mAmPm;
        private String mAmString;
        private String mPmString;

        AmPm(View view, Typeface typeface) {
            String string2;
            String string3;
            TextView textView;
            this.mAmPm = textView = (TextView)view.findViewById(16908766);
            if (typeface != null) {
                this.mAmPm.setTypeface(typeface);
            }
            String[] stringArray = new DateFormatSymbols().getAmPmStrings();
            this.mAmString = string3 = stringArray[0];
            this.mPmString = string2 = stringArray[1];
        }

        /*
         * Enabled aggressive block sorting
         */
        void setIsMorning(boolean bl) {
            TextView textView = this.mAmPm;
            String string2 = bl ? this.mAmString : this.mPmString;
            textView.setText(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setShowAmPm(boolean bl) {
            TextView textView = this.mAmPm;
            int n = bl ? 0 : 8;
            textView.setVisibility(n);
        }
    }

    private static class TimeChangedReceiver
    extends BroadcastReceiver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public TimeChangedReceiver(DigitalClock digitalClock) {
            Context context;
            WeakReference<DigitalClock> weakReference = new WeakReference<DigitalClock>(digitalClock);
            this.mClock = weakReference;
            this.mContext = context = digitalClock.getContext();
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            final boolean bl = intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED");
            final DigitalClock digitalClock = (DigitalClock)this.mClock.get();
            if (digitalClock != null) {
                Handler handler = digitalClock.mHandler;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            DigitalClock digitalClock2 = digitalClock;
                            Calendar calendar = Calendar.getInstance();
                            Calendar calendar2 = DigitalClock.access$002(digitalClock2, calendar);
                        }
                        digitalClock.updateTime();
                    }
                };
                boolean bl2 = handler.post(runnable);
                return;
            }
            try {
                this.mContext.unregisterReceiver(this);
                return;
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
    }
}

