/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.ArrowKeyMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import java.io.InputStream;
import java.util.ArrayList;

public class EditStyledText
extends EditText {
    private static final boolean DBG = false;
    public static final int DEFAULT_BACKGROUND_COLOR = 0xFFFFFF;
    public static final int HINT_MSG_COPY_BUF_BLANK = 1;
    public static final int HINT_MSG_NULL = 0;
    public static final int HINT_MSG_PUSH_COMPETE = 4;
    public static final int HINT_MSG_SELECT_END = 3;
    public static final int HINT_MSG_SELECT_START = 2;
    private static final String LOG_TAG = "EditStyledText";
    public static final int MODE_ALIGN = 6;
    public static final int MODE_COLOR = 4;
    public static final int MODE_COPY = 1;
    public static final int MODE_CUT = 7;
    public static final int MODE_NOTHING = 0;
    public static final int MODE_PASTE = 2;
    public static final int MODE_SELECT = 5;
    public static final int MODE_SIZE = 3;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_SELECT_FIX = 3;
    public static final int STATE_SELECT_OFF = 0;
    public static final int STATE_SELECT_ON = 1;
    private int mBackgroundColor;
    private StyledTextConverter mConverter;
    private Drawable mDefaultBackground;
    private StyledTextDialog mDialog;
    private EditStyledTextNotifier mESTInterface;
    private EditorManager mManager;

    public EditStyledText(Context context) {
        super(context);
        this.init();
    }

    public EditStyledText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public EditStyledText(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    static /* synthetic */ int access$902(EditStyledText editStyledText, int n) {
        editStyledText.mBackgroundColor = n;
        return n;
    }

    private void init() {
        StyledTextDialog styledTextDialog;
        StyledTextConverter styledTextConverter;
        EditorManager editorManager;
        Drawable drawable2;
        boolean bl = this.requestFocus();
        this.mDefaultBackground = drawable2 = this.getBackground();
        this.mBackgroundColor = 0xFFFFFF;
        this.mManager = editorManager = new EditorManager(this);
        this.mConverter = styledTextConverter = new StyledTextConverter(this);
        this.mDialog = styledTextDialog = new StyledTextDialog(this);
        EditorManager editorManager2 = this.mManager;
        StyledTextArrowKeyMethod styledTextArrowKeyMethod = new StyledTextArrowKeyMethod(editorManager2);
        this.setMovementMethod(styledTextArrowKeyMethod);
        this.mManager.blockSoftKey();
        this.mManager.unblockSoftKey();
    }

    private void notifyStateChanged(int n, int n2) {
        if (this.mESTInterface == null) {
            return;
        }
        this.mESTInterface.notifyStateChanged(n, n2);
    }

    private void onShowAlignAlert() {
        this.mDialog.onShowAlignAlertDialog();
    }

    private void onShowBackgroundColorAlert() {
        this.mDialog.onShowBackgroundColorAlertDialog();
    }

    private void onShowForegroundColorAlert() {
        this.mDialog.onShowForegroundColorAlertDialog();
    }

    private void onShowSizeAlert() {
        this.mDialog.onShowSizeAlertDialog();
    }

    private void setHintMessage(int n) {
        if (this.mESTInterface == null) {
            return;
        }
        this.mESTInterface.notifyHintMsg(n);
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getEditMode() {
        return this.mManager.getEditMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getForeGroundColor(int n) {
        int n2;
        if (n < 0 || n > (n2 = this.getText().length())) {
            int n3 = Log.e(LOG_TAG, "---getForeGroundColor: Illigal position.");
            return 0xFFFFFF;
        }
        ForegroundColorSpan[] foregroundColorSpanArray = this.getText().getSpans(n, n, ForegroundColorSpan.class);
        if (foregroundColorSpanArray.length <= 0) return 0xFFFFFF;
        return foregroundColorSpanArray[0].getForegroundColor();
    }

    public String getHtml() {
        return this.mConverter.getHtml();
    }

    public String getHtml(ArrayList<Uri> arrayList) {
        StyledTextConverter styledTextConverter = this.mConverter;
        Editable editable = this.getText();
        styledTextConverter.getUriArray(arrayList, editable);
        return this.mConverter.getHtml();
    }

    @Override
    public Bundle getInputExtras(boolean bl) {
        Bundle bundle = super.getInputExtras(bl);
        if (bundle != null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("allowEmoji", true);
        return bundle;
    }

    public int getSelectState() {
        return this.mManager.getSelectState();
    }

    public boolean isEditting() {
        return this.mManager.isEditting();
    }

    public boolean isSoftKeyBlocked() {
        return this.mManager.isSoftKeyBlocked();
    }

    public boolean isStyledText() {
        return this.mManager.isStyledText();
    }

    public void onClearStyles() {
        this.mManager.onClearStyles();
    }

    public void onEndEdit() {
        this.mManager.onEndEdit();
    }

    public void onFixSelectedItem() {
        this.mManager.onFixSelectedItem();
    }

    public void onInsertHorizontalLine() {
        this.mManager.onInsertHorizontalLine();
    }

    public void onInsertImage(int n) {
        this.mManager.onInsertImage(n);
    }

    public void onInsertImage(Uri uri) {
        this.mManager.onInsertImage(uri);
    }

    public void onStartAlign() {
        this.mManager.onStartAlign();
    }

    public void onStartBackgroundColor() {
        this.mManager.onStartBackgroundColor();
    }

    public void onStartColor() {
        this.mManager.onStartColor();
    }

    public void onStartCopy() {
        this.mManager.onStartCopy();
    }

    public void onStartCut() {
        this.mManager.onStartCut();
    }

    public void onStartEdit() {
        this.mManager.onStartEdit();
    }

    public void onStartPaste() {
        this.mManager.onStartPaste();
    }

    public void onStartSelect() {
        this.mManager.onStartSelect();
    }

    public void onStartSelectAll() {
        this.mManager.onStartSelectAll();
    }

    public void onStartSize() {
        this.mManager.onStartSize();
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mManager.isSoftKeyBlocked() && motionEvent.getAction() == 1) {
            this.cancelLongPress();
        }
        boolean bl = super.onTouchEvent(motionEvent);
        if (motionEvent.getAction() == 1) {
            this.mManager.onCursorMoved();
        }
        return bl;
    }

    public void setAlignAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray) {
        this.mDialog.setAlignAlertParams(charSequence, charSequenceArray);
    }

    public void setAlignment(Layout.Alignment alignment) {
        this.mManager.setAlignment(alignment);
    }

    @Override
    public void setBackgroundColor(int n) {
        super.setBackgroundColor(n);
        this.mBackgroundColor = n;
    }

    public void setBuilder(AlertDialog.Builder builder) {
        this.mDialog.setBuilder(builder);
    }

    public void setColorAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2) {
        this.mDialog.setColorAlertParams(charSequence, charSequenceArray, charSequenceArray2);
    }

    public void setHtml(String string2) {
        this.mConverter.SetHtml(string2);
    }

    public void setItemColor(int n) {
        this.mManager.setItemColor(n);
    }

    public void setItemSize(int n) {
        this.mManager.setItemSize(n);
    }

    public void setNotifier(EditStyledTextNotifier editStyledTextNotifier) {
        this.mESTInterface = editStyledTextNotifier;
    }

    public void setSizeAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2, CharSequence[] charSequenceArray3) {
        this.mDialog.setSizeAlertParams(charSequence, charSequenceArray, charSequenceArray2, charSequenceArray3);
    }

    public class HorizontalLineDrawable
    extends ShapeDrawable {
        private View mView;

        public HorizontalLineDrawable(int n, View view) {
            RectShape rectShape = new RectShape();
            super(rectShape);
            this.mView = view;
            this.renewColor(n);
            this.renewBounds(view);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ImageSpan getParentSpan() {
            int n;
            Editable editable;
            ImageSpan[] imageSpanArray;
            if (this.mView instanceof EditStyledText && (imageSpanArray = (editable = ((EditStyledText)this.mView).getText()).getSpans(0, n = editable.length(), ImageSpan.class)).length > 0) {
                for (ImageSpan imageSpan : imageSpanArray) {
                    if (imageSpan.getDrawable() != this) continue;
                    return imageSpan;
                }
            }
            int n2 = Log.e(EditStyledText.LOG_TAG, "---renewBounds: Couldn't find");
            return null;
        }

        private void renewBounds(View view) {
            int n = this.mView.getWidth();
            if (n > 20) {
                n += -20;
            }
            this.setBounds(0, 0, n, 2);
        }

        private void renewColor() {
            int n;
            if (!(this.mView instanceof View)) {
                return;
            }
            ImageSpan imageSpan = this.getParentSpan();
            Editable editable = ((EditStyledText)this.mView).getText();
            ForegroundColorSpan[] foregroundColorSpanArray = editable.getSpans(n = editable.getSpanStart(imageSpan), n, ForegroundColorSpan.class);
            if (foregroundColorSpanArray.length <= 0) {
                return;
            }
            int n2 = foregroundColorSpanArray.length - 1;
            int n3 = foregroundColorSpanArray[n2].getForegroundColor();
            this.renewColor(n3);
        }

        private void renewColor(int n) {
            this.getPaint().setColor(n);
        }

        @Override
        public void draw(Canvas canvas) {
            this.renewColor();
            View view = this.mView;
            this.renewBounds(view);
            super.draw(canvas);
        }
    }

    public class HorizontalLineSpan
    extends ImageSpan {
        public HorizontalLineSpan(int n, View view) {
            HorizontalLineDrawable horizontalLineDrawable = new HorizontalLineDrawable(n, view);
            super(horizontalLineDrawable);
        }
    }

    private class StyledTextArrowKeyMethod
    extends ArrowKeyMovementMethod {
        EditorManager mManager;

        StyledTextArrowKeyMethod(EditorManager editorManager) {
            this.mManager = editorManager;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean down(TextView textView, Spannable spannable) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Layout layout2 = textView.getLayout();
            int n6 = layout2.getLineForOffset(n5 = this.getEndPos(textView));
            if (n6 >= (n4 = layout2.getLineCount() - 1)) {
                return false;
            }
            int n7 = layout2.getParagraphDirection(n6);
            if (n7 != (n3 = layout2.getParagraphDirection(n2 = n6 + 1))) {
                float f = layout2.getPrimaryHorizontal(n5);
                int n8 = n6 + 1;
                n = layout2.getOffsetForHorizontal(n8, f);
            } else {
                int n9 = n6 + 1;
                n = layout2.getLineStart(n9);
            }
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean executeDown(TextView textView, Spannable spannable, int n) {
            boolean bl = false;
            switch (n) {
                case 19: {
                    boolean bl2 = this.up(textView, spannable);
                    return false | bl2;
                }
                case 20: {
                    boolean bl3 = this.down(textView, spannable);
                    return false | bl3;
                }
                case 21: {
                    boolean bl4 = this.left(textView, spannable);
                    return false | bl4;
                }
                case 22: {
                    boolean bl5 = this.right(textView, spannable);
                    return false | bl5;
                }
                case 23: {
                    this.mManager.onFixSelectedItem();
                    return true;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getEndPos(TextView textView) {
            int n;
            int n2 = textView.getSelectionStart();
            if (n2 == (n = this.mManager.getSelectionStart())) return textView.getSelectionStart();
            return textView.getSelectionEnd();
        }

        private boolean left(TextView textView, Spannable spannable) {
            Layout layout2 = textView.getLayout();
            int n = this.getEndPos(textView);
            int n2 = layout2.getOffsetToLeftOf(n);
            this.mManager.setSelectedEndPos(n2);
            this.mManager.onCursorMoved();
            return true;
        }

        private boolean right(TextView textView, Spannable spannable) {
            Layout layout2 = textView.getLayout();
            int n = this.getEndPos(textView);
            int n2 = layout2.getOffsetToRightOf(n);
            this.mManager.setSelectedEndPos(n2);
            this.mManager.onCursorMoved();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean up(TextView textView, Spannable spannable) {
            int n;
            int n2;
            int n3;
            int n4;
            Layout layout2 = textView.getLayout();
            int n5 = layout2.getLineForOffset(n4 = this.getEndPos(textView));
            if (n5 <= 0) {
                return false;
            }
            int n6 = layout2.getParagraphDirection(n5);
            if (n6 != (n3 = layout2.getParagraphDirection(n2 = n5 - 1))) {
                float f = layout2.getPrimaryHorizontal(n4);
                int n7 = n5 - 1;
                n = layout2.getOffsetForHorizontal(n7, f);
            } else {
                int n8 = n5 - 1;
                n = layout2.getLineStart(n8);
            }
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onKeyDown(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
            if (!this.mManager.isSoftKeyBlocked()) {
                return super.onKeyDown(textView, spannable, n, keyEvent);
            }
            if (!this.executeDown(textView, spannable, n)) return false;
            return true;
        }
    }

    private class StyledTextDialog {
        CharSequence[] mAlignNames;
        CharSequence mAlignTitle;
        AlertDialog.Builder mBuilder;
        CharSequence[] mColorInts;
        CharSequence[] mColorNames;
        CharSequence mColorTitle;
        EditStyledText mEST;
        CharSequence[] mSizeDisplayInts;
        CharSequence[] mSizeNames;
        CharSequence[] mSizeSendInts;
        CharSequence mSizeTitle;

        public StyledTextDialog(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkAlignAlertParams() {
            if (this.mBuilder == null) {
                int n = Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mAlignTitle != null) return true;
            int n = Log.e(EditStyledText.LOG_TAG, "--- align alert params are null.");
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkColorAlertParams() {
            if (this.mBuilder == null) {
                int n = Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mColorTitle == null || this.mColorNames == null || this.mColorInts == null) {
                int n = Log.e(EditStyledText.LOG_TAG, "--- color alert params are null.");
                return false;
            }
            int n = this.mColorNames.length;
            int n2 = this.mColorInts.length;
            if (n == n2) return true;
            int n3 = Log.e(EditStyledText.LOG_TAG, "--- the length of color alert params are different.");
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkSizeAlertParams() {
            if (this.mBuilder == null) {
                int n = Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mSizeTitle == null || this.mSizeNames == null || this.mSizeDisplayInts == null || this.mSizeSendInts == null) {
                int n = Log.e(EditStyledText.LOG_TAG, "--- size alert params are null.");
                return false;
            }
            int n = this.mSizeNames.length;
            int n2 = this.mSizeDisplayInts.length;
            if (n == n2) return true;
            int n3 = this.mSizeSendInts.length;
            int n4 = this.mSizeDisplayInts.length;
            if (n3 == n4) return true;
            int n5 = Log.e(EditStyledText.LOG_TAG, "--- the length of size alert params are different.");
            return false;
        }

        private void onShowAlignAlertDialog() {
            if (!this.checkAlignAlertParams()) {
                return;
            }
            AlertDialog.Builder builder = this.mBuilder;
            CharSequence charSequence = this.mAlignTitle;
            AlertDialog.Builder builder2 = builder.setTitle(charSequence);
            AlertDialog.Builder builder3 = this.mBuilder.setIcon(0);
            AlertDialog.Builder builder4 = this.mBuilder;
            CharSequence[] charSequenceArray = this.mAlignNames;
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    String string2 = "mBuilder.onclick:" + n;
                    int n2 = Log.d(EditStyledText.LOG_TAG, string2);
                    Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
                    switch (n) {
                        case 0: {
                            alignment = Layout.Alignment.ALIGN_NORMAL;
                            break;
                        }
                        case 1: {
                            alignment = Layout.Alignment.ALIGN_CENTER;
                            break;
                        }
                        case 2: {
                            alignment = Layout.Alignment.ALIGN_OPPOSITE;
                            break;
                        }
                    }
                    StyledTextDialog.this.mEST.setAlignment(alignment);
                }
            };
            AlertDialog.Builder builder5 = builder4.setItems(charSequenceArray, onClickListener);
            AlertDialog alertDialog = this.mBuilder.show();
        }

        private void onShowBackgroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            AlertDialog.Builder builder = this.mBuilder;
            CharSequence charSequence = this.mColorTitle;
            AlertDialog.Builder builder2 = builder.setTitle(charSequence);
            AlertDialog.Builder builder3 = this.mBuilder.setIcon(0);
            AlertDialog.Builder builder4 = this.mBuilder;
            CharSequence[] charSequenceArray = this.mColorNames;
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    String string2 = "mBuilder.onclick:" + n;
                    int n2 = Log.d("EETVM", string2);
                    int n3 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[n], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setBackgroundColor(n3);
                }
            };
            AlertDialog.Builder builder5 = builder4.setItems(charSequenceArray, onClickListener);
            AlertDialog alertDialog = this.mBuilder.show();
        }

        private void onShowForegroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            AlertDialog.Builder builder = this.mBuilder;
            CharSequence charSequence = this.mColorTitle;
            AlertDialog.Builder builder2 = builder.setTitle(charSequence);
            AlertDialog.Builder builder3 = this.mBuilder.setIcon(0);
            AlertDialog.Builder builder4 = this.mBuilder;
            CharSequence[] charSequenceArray = this.mColorNames;
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    String string2 = "mBuilder.onclick:" + n;
                    int n2 = Log.d("EETVM", string2);
                    int n3 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[n], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setItemColor(n3);
                }
            };
            AlertDialog.Builder builder5 = builder4.setItems(charSequenceArray, onClickListener);
            AlertDialog alertDialog = this.mBuilder.show();
        }

        private void onShowSizeAlertDialog() {
            if (!this.checkSizeAlertParams()) {
                return;
            }
            AlertDialog.Builder builder = this.mBuilder;
            CharSequence charSequence = this.mSizeTitle;
            AlertDialog.Builder builder2 = builder.setTitle(charSequence);
            AlertDialog.Builder builder3 = this.mBuilder.setIcon(0);
            AlertDialog.Builder builder4 = this.mBuilder;
            CharSequence[] charSequenceArray = this.mSizeNames;
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    String string2 = "mBuilder.onclick:" + n;
                    int n2 = Log.d(EditStyledText.LOG_TAG, string2);
                    int n3 = Integer.parseInt((String)StyledTextDialog.this.mSizeDisplayInts[n]);
                    StyledTextDialog.this.mEST.setItemSize(n3);
                }
            };
            AlertDialog.Builder builder5 = builder4.setItems(charSequenceArray, onClickListener);
            AlertDialog alertDialog = this.mBuilder.show();
        }

        public void setAlignAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray) {
            this.mAlignTitle = charSequence;
            this.mAlignNames = charSequenceArray;
        }

        public void setBuilder(AlertDialog.Builder builder) {
            this.mBuilder = builder;
        }

        public void setColorAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2) {
            this.mColorTitle = charSequence;
            this.mColorNames = charSequenceArray;
            this.mColorInts = charSequenceArray2;
        }

        public void setSizeAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2, CharSequence[] charSequenceArray3) {
            this.mSizeTitle = charSequence;
            this.mSizeNames = charSequenceArray;
            this.mSizeDisplayInts = charSequenceArray2;
            this.mSizeSendInts = charSequenceArray3;
        }
    }

    private class StyledTextConverter {
        private EditStyledText mEST;

        public StyledTextConverter(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        public void SetHtml(String string2) {
            Html.ImageGetter imageGetter = new Html.ImageGetter(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Drawable getDrawable(String string2) {
                    String string3 = "--- sethtml: src=" + string2;
                    int n = Log.d(EditStyledText.LOG_TAG, string3);
                    if (string2.startsWith("content://")) {
                        Uri uri = Uri.parse(string2);
                        try {
                            InputStream inputStream = StyledTextConverter.this.mEST.getContext().getContentResolver().openInputStream(uri);
                            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                            Resources resources = EditStyledText.this.getContext().getResources();
                            BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
                            int n2 = ((Drawable)bitmapDrawable).getIntrinsicWidth();
                            int n3 = ((Drawable)bitmapDrawable).getIntrinsicHeight();
                            bitmapDrawable.setBounds(0, 0, n2, n3);
                            inputStream.close();
                            return bitmapDrawable;
                        }
                        catch (Exception exception) {
                            String string4 = "--- set html: Failed to loaded content " + uri;
                            int n4 = Log.e(EditStyledText.LOG_TAG, string4, exception);
                            return null;
                        }
                    }
                    String string5 = "  unknown src=" + string2;
                    int n5 = Log.d(EditStyledText.LOG_TAG, string5);
                    return null;
                }
            };
            Spanned spanned = Html.fromHtml(string2, imageGetter, null);
            this.mEST.setText(spanned);
        }

        public String getHtml() {
            return Html.toHtml(this.mEST.getText());
        }

        public void getUriArray(ArrayList<Uri> arrayList, Editable editable) {
            arrayList.clear();
            int n = editable.length();
            int n2 = 0;
            int n3;
            while (n2 < (n3 = editable.length())) {
                int n4;
                int n5 = editable.nextSpanTransition(n2, n, ImageSpan.class);
                ImageSpan[] imageSpanArray = editable.getSpans(n2, n5, ImageSpan.class);
                for (int i = 0; i < (n4 = imageSpanArray.length); ++i) {
                    Uri uri = Uri.parse(imageSpanArray[i].getSource());
                    boolean bl = arrayList.add(uri);
                }
                n2 = n5;
            }
            return;
        }
    }

    private class EditorManager {
        private int mCurEnd = 0;
        private int mCurStart = 0;
        private EditStyledText mEST;
        private boolean mEditFlag = false;
        private int mMode = 0;
        private boolean mSoftKeyBlockFlag = false;
        private int mState = 0;

        EditorManager(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        private void blockSoftKey() {
            InputMethodManager inputMethodManager = (InputMethodManager)this.mEST.getContext().getSystemService("input_method");
            IBinder iBinder = this.mEST.getWindowToken();
            boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
            EditStyledText editStyledText = this.mEST;
            View.OnClickListener onClickListener = new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    int n = Log.d(EditStyledText.LOG_TAG, "--- ontrackballclick:");
                    EditorManager.this.onFixSelectedItem();
                }
            };
            editStyledText.setOnClickListener(onClickListener);
            this.mSoftKeyBlockFlag = true;
        }

        private void changeAlign(Layout.Alignment alignment) {
            AlignmentSpan.Standard standard = new AlignmentSpan.Standard(alignment);
            Editable editable = this.mEST.getText();
            int n = this.mCurStart;
            int n2 = this.findLineStart(editable, n);
            Editable editable2 = this.mEST.getText();
            int n3 = this.mCurEnd;
            int n4 = this.findLineEnd(editable2, n3);
            this.setStyledTextSpan(standard, n2, n4);
        }

        private void changeColorSelectedText(int n) {
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(n);
            int n2 = this.mCurStart;
            int n3 = this.mCurEnd;
            this.setStyledTextSpan(foregroundColorSpan, n2, n3);
        }

        private void changeSizeSelectedText(int n) {
            AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(n);
            int n2 = this.mCurStart;
            int n3 = this.mCurEnd;
            this.setStyledTextSpan(absoluteSizeSpan, n2, n3);
        }

        private void doNextHandle() {
            switch (this.mMode) {
                default: {
                    return;
                }
                case 1: {
                    this.handleCopy();
                    return;
                }
                case 7: {
                    this.handleCut();
                    return;
                }
                case 2: {
                    this.handlePaste();
                    return;
                }
                case 3: {
                    this.handleSize();
                    return;
                }
                case 4: {
                    this.handleColor();
                    return;
                }
                case 6: 
            }
            this.handleAlign();
        }

        private int findLineEnd(Editable editable, int n) {
            int n2 = n;
            int n3;
            int n4;
            while (n2 < (n4 = editable.length()) && (n2 <= 0 || editable.charAt(n3 = n2 - 1) != '\n')) {
                ++n2;
            }
            return n2;
        }

        private int findLineStart(Editable editable, int n) {
            int n2 = n;
            int n3;
            while (n2 > 0 && editable.charAt(n3 = n2 - 1) != '\n') {
                n2 += -1;
            }
            return n2;
        }

        private void handleAlign() {
            this.handleSetSpan(6);
        }

        private void handleCancel() {
            this.mMode = 0;
            this.mState = 0;
            this.mEditFlag = false;
            StringBuilder stringBuilder = new StringBuilder().append("--- handleCancel:");
            int n = this.mEST.getInputType();
            String string2 = stringBuilder.append(n).toString();
            int n2 = Log.d(EditStyledText.LOG_TAG, string2);
            this.unblockSoftKey();
            this.unsetSelect();
        }

        private void handleColor() {
            this.handleSetSpan(4);
        }

        private void handleComplete() {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mState == 2) {
                this.mState = 3;
            }
            this.doNextHandle();
        }

        private void handleCopy() {
            this.handleTextViewFunc(1, 0x1020021);
        }

        private void handleCut() {
            this.handleTextViewFunc(7, 0x1020020);
        }

        private void handlePaste() {
            if (!this.mEditFlag) {
                return;
            }
            boolean bl = this.mEST.onTextContextMenuItem(0x1020022);
        }

        private void handleResetEdit() {
            this.blockSoftKey();
            this.handleCancel();
            this.mEditFlag = true;
            this.mEST.setHintMessage(2);
        }

        private void handleSelect() {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mState == 0) {
                if (this.isTextSelected()) {
                    int n = Log.e(EditStyledText.LOG_TAG, "Selection is off, but selected");
                }
                this.setSelectStartPos();
                this.blockSoftKey();
                this.mEST.setHintMessage(3);
                return;
            }
            if (this.mState == 1) {
                if (this.isTextSelected()) {
                    int n = Log.e(EditStyledText.LOG_TAG, "Selection now start, but selected");
                }
                this.setSelectedEndPos();
                this.mEST.setHintMessage(4);
                this.doNextHandle();
                return;
            }
            if (this.mState != 2) {
                return;
            }
            if (!this.isTextSelected()) {
                int n = Log.e(EditStyledText.LOG_TAG, "Selection is done, but not selected");
            }
            this.setSelectedEndPos();
            this.doNextHandle();
        }

        private void handleSelectAll() {
            if (!this.mEditFlag) {
                return;
            }
            this.mEST.selectAll();
            this.mState = 2;
        }

        private void handleSetSpan(int n) {
            if (!this.mEditFlag) {
                int n2 = Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: Editing is not started.");
                return;
            }
            if (this.mMode == 0 || this.mMode == 5) {
                this.mMode = n;
                if (this.mState == 2) {
                    this.mState = 3;
                    this.handleSetSpan(n);
                    return;
                }
                this.handleSelect();
                return;
            }
            if (this.mMode != n) {
                this.handleCancel();
                this.mMode = n;
                this.handleSetSpan(n);
                return;
            }
            if (this.mState == 3) {
                this.mEST.setHintMessage(0);
                switch (n) {
                    default: {
                        int n3 = Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: invalid mode.");
                        return;
                    }
                    case 4: {
                        this.mEST.onShowForegroundColorAlert();
                        return;
                    }
                    case 3: {
                        this.mEST.onShowSizeAlert();
                        return;
                    }
                    case 6: 
                }
                this.mEST.onShowAlignAlert();
                return;
            }
            int n4 = Log.d(EditStyledText.LOG_TAG, "--- handleSetSpan: do nothing.");
        }

        private void handleSize() {
            this.handleSetSpan(3);
        }

        private void handleTextViewFunc(int n, int n2) {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mMode == 0 || this.mMode == 5) {
                this.mMode = n;
                if (this.mState == 2) {
                    this.mState = 3;
                    this.handleTextViewFunc(n, n2);
                    return;
                }
                this.handleSelect();
                return;
            }
            if (this.mMode != n) {
                this.handleCancel();
                this.mMode = n;
                this.handleTextViewFunc(n, n2);
                return;
            }
            if (this.mState != 3) {
                return;
            }
            boolean bl = this.mEST.onTextContextMenuItem(n2);
            this.handleResetEdit();
        }

        private void insertImageSpan(ImageSpan imageSpan) {
            if (imageSpan != null) {
                StringBuilder stringBuilder = new StringBuilder().append("--- insertimagespan:");
                int n = imageSpan.getDrawable().getIntrinsicHeight();
                StringBuilder stringBuilder2 = stringBuilder.append(n).append(",");
                int n2 = imageSpan.getDrawable().getIntrinsicWidth();
                String string2 = stringBuilder2.append(n2).toString();
                int n3 = Log.d(EditStyledText.LOG_TAG, string2);
                StringBuilder stringBuilder3 = new StringBuilder().append("--- insertimagespan:");
                Class<? extends Object> clazz = imageSpan.getDrawable().getClass();
                String string3 = stringBuilder3.append(clazz).toString();
                int n4 = Log.d(EditStyledText.LOG_TAG, string3);
                int n5 = this.mEST.getSelectionStart();
                Editable editable = this.mEST.getText().insert(n5, "\ufffc");
                Editable editable2 = this.mEST.getText();
                int n6 = n5 + 1;
                editable2.setSpan(imageSpan, n5, n6, 33);
                EditStyledText editStyledText = this.mEST;
                int n7 = this.mMode;
                int n8 = this.mState;
                editStyledText.notifyStateChanged(n7, n8);
                return;
            }
            int n = Log.e(EditStyledText.LOG_TAG, "--- insertImageSpan: null span was inserted");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isTextSelected() {
            int n = this.mCurStart;
            int n2 = this.mCurEnd;
            if (n == n2) return false;
            if (this.mState == 2) return true;
            if (this.mState != 3) return false;
            return true;
        }

        private void setSelectStartPos() {
            int n;
            this.mCurStart = n = this.mEST.getSelectionStart();
            this.mState = 1;
        }

        private void setSelectedEndPos() {
            int n;
            int n2 = this.mEST.getSelectionStart();
            if (n2 != (n = this.mCurStart)) {
                int n3 = this.mEST.getSelectionEnd();
                this.setSelectedEndPos(n3);
                return;
            }
            int n4 = this.mEST.getSelectionStart();
            this.setSelectedEndPos(n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setSelection() {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.mCurStart >= 0 && (n4 = this.mCurStart) <= (n3 = this.mEST.getText().length()) && this.mCurEnd >= 0 && (n2 = this.mCurEnd) <= (n = this.mEST.getText().length())) {
                int n5 = this.mCurStart;
                int n6 = this.mCurEnd;
                if (n5 < n6) {
                    EditStyledText editStyledText = this.mEST;
                    int n7 = this.mCurStart;
                    int n8 = this.mCurEnd;
                    editStyledText.setSelection(n7, n8);
                } else {
                    EditStyledText editStyledText = this.mEST;
                    int n9 = this.mCurEnd;
                    int n10 = this.mCurStart;
                    editStyledText.setSelection(n9, n10);
                }
                this.mState = 2;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Select is on, but cursor positions are illigal.:");
            int n11 = this.mEST.getText().length();
            StringBuilder stringBuilder2 = stringBuilder.append(n11).append(",");
            int n12 = this.mCurStart;
            StringBuilder stringBuilder3 = stringBuilder2.append(n12).append(",");
            int n13 = this.mCurEnd;
            String string2 = stringBuilder3.append(n13).toString();
            int n14 = Log.e(EditStyledText.LOG_TAG, string2);
        }

        private void setStyledTextSpan(Object object, int n, int n2) {
            if (n < n2) {
                this.mEST.getText().setSpan(object, n, n2, 33);
                return;
            }
            this.mEST.getText().setSpan(object, n2, n, 33);
        }

        private void unblockSoftKey() {
            this.mEST.setOnClickListener(null);
            this.mSoftKeyBlockFlag = false;
        }

        private void unsetSelect() {
            int n = this.mEST.getSelectionStart();
            this.mEST.setSelection(n, n);
            this.mState = 0;
        }

        public int getEditMode() {
            return this.mMode;
        }

        public int getSelectState() {
            return this.mState;
        }

        public int getSelectionEnd() {
            return this.mCurEnd;
        }

        public int getSelectionStart() {
            return this.mCurStart;
        }

        public boolean isEditting() {
            return this.mEditFlag;
        }

        public boolean isSoftKeyBlocked() {
            return this.mSoftKeyBlockFlag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isStyledText() {
            int n;
            int n2;
            Editable editable = this.mEST.getText();
            if (editable.getSpans(0, n2 = (n = editable.length()) - 1, ParagraphStyle.class).length > 0) return true;
            int n3 = n - 1;
            if (editable.getSpans(0, n3, QuoteSpan.class).length > 0) return true;
            int n4 = n - 1;
            if (editable.getSpans(0, n4, CharacterStyle.class).length > 0) return true;
            if (this.mEST.mBackgroundColor == 0xFFFFFF) return false;
            return true;
        }

        public void onClearStyles() {
            Editable editable = this.mEST.getText();
            int n = editable.length();
            for (Object object : editable.getSpans(0, n, Object.class)) {
                if (!(object instanceof ParagraphStyle) && !(object instanceof QuoteSpan) && !(object instanceof CharacterStyle)) continue;
                if (object instanceof ImageSpan) {
                    int n2 = editable.getSpanStart(object);
                    int n3 = editable.getSpanEnd(object);
                    Editable editable2 = editable.replace(n2, n3, "");
                }
                editable.removeSpan(object);
            }
            EditStyledText editStyledText = this.mEST;
            Drawable drawable2 = this.mEST.mDefaultBackground;
            editStyledText.setBackgroundDrawable(drawable2);
            int n4 = EditStyledText.access$902(this.mEST, 0xFFFFFF);
        }

        public void onCursorMoved() {
            if (this.mState != 1 && this.mState != 2) {
                return;
            }
            this.handleSelect();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onEndEdit() {
            this.handleCancel();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onFixSelectedItem() {
            this.handleComplete();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onInsertHorizontalLine() {
            EditStyledText editStyledText = EditStyledText.this;
            EditStyledText editStyledText2 = this.mEST;
            HorizontalLineSpan horizontalLineSpan = editStyledText.new HorizontalLineSpan(-16777216, editStyledText2);
            this.insertImageSpan(horizontalLineSpan);
            EditStyledText editStyledText3 = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText3.notifyStateChanged(n, n2);
        }

        public void onInsertImage(int n) {
            Context context = this.mEST.getContext();
            ImageSpan imageSpan = new ImageSpan(context, n);
            this.insertImageSpan(imageSpan);
            EditStyledText editStyledText = this.mEST;
            int n2 = this.mMode;
            int n3 = this.mState;
            editStyledText.notifyStateChanged(n2, n3);
        }

        public void onInsertImage(Uri uri) {
            Context context = this.mEST.getContext();
            ImageSpan imageSpan = new ImageSpan(context, uri);
            this.insertImageSpan(imageSpan);
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartAlign() {
            this.handleAlign();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartBackgroundColor() {
            this.mEST.onShowBackgroundColorAlert();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartColor() {
            this.handleColor();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartCopy() {
            this.handleCopy();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartCut() {
            this.handleCut();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartEdit() {
            int n = Log.d(EditStyledText.LOG_TAG, "--- onstartedit:");
            this.handleResetEdit();
            EditStyledText editStyledText = this.mEST;
            int n2 = this.mMode;
            int n3 = this.mState;
            editStyledText.notifyStateChanged(n2, n3);
        }

        public void onStartPaste() {
            this.handlePaste();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onStartSelect() {
            this.mMode = 5;
            if (this.mState == 0) {
                this.handleSelect();
            } else {
                this.unsetSelect();
                this.handleSelect();
            }
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartSelectAll() {
            this.handleSelectAll();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void onStartSize() {
            this.handleSize();
            EditStyledText editStyledText = this.mEST;
            int n = this.mMode;
            int n2 = this.mState;
            editStyledText.notifyStateChanged(n, n2);
        }

        public void setAlignment(Layout.Alignment alignment) {
            if (this.mState != 2 && this.mState != 3) {
                return;
            }
            this.changeAlign(alignment);
            this.handleResetEdit();
        }

        public void setItemColor(int n) {
            if (this.mState != 2 && this.mState != 3) {
                return;
            }
            this.changeColorSelectedText(n);
            this.handleResetEdit();
        }

        public void setItemSize(int n) {
            if (this.mState != 2 && this.mState != 3) {
                return;
            }
            this.changeSizeSelectedText(n);
            this.handleResetEdit();
        }

        public void setSelectedEndPos(int n) {
            this.mCurEnd = n;
            this.setSelection();
        }
    }

    public static interface EditStyledTextNotifier {
        public void notifyHintMsg(int var1);

        public void notifyStateChanged(int var1, int var2);
    }
}

