/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Bundle;
import android.text.Editable;
import android.text.method.KeyListener;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.widget.TextView;

public class EditableInputConnection
extends BaseInputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "EditableInputConnection";
    private final TextView mTextView;

    public EditableInputConnection(TextView textView) {
        super(textView, true);
        this.mTextView = textView;
    }

    @Override
    public boolean beginBatchEdit() {
        this.mTextView.beginBatchEdit();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean clearMetaKeyStates(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        KeyListener keyListener = this.mTextView.getKeyListener();
        if (keyListener == null) return true;
        try {
            TextView textView = this.mTextView;
            keyListener.clearMetaKeyState(textView, editable, n);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
        return true;
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCompletion(completionInfo);
        this.mTextView.endBatchEdit();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        if (this.mTextView == null) {
            return super.commitText(charSequence, n);
        }
        CharSequence charSequence2 = this.mTextView.getError();
        boolean bl = super.commitText(charSequence, n);
        CharSequence charSequence3 = this.mTextView.getError();
        if (charSequence3 == null) return bl;
        if (charSequence2 != charSequence3) return bl;
        this.mTextView.setError(null, null);
        return bl;
    }

    @Override
    public boolean endBatchEdit() {
        this.mTextView.endBatchEdit();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Editable getEditable() {
        TextView textView = this.mTextView;
        if (textView == null) return null;
        return textView.getEditableText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        if (this.mTextView == null) return null;
        ExtractedText extractedText = new ExtractedText();
        if (!this.mTextView.extractText(extractedTextRequest, extractedText)) return null;
        if ((n & 1) == 0) return extractedText;
        this.mTextView.setExtracting(extractedTextRequest);
        return extractedText;
    }

    @Override
    public boolean performContextMenuAction(int n) {
        this.mTextView.beginBatchEdit();
        boolean bl = this.mTextView.onTextContextMenuItem(n);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean performEditorAction(int n) {
        this.mTextView.onEditorAction(n);
        return true;
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        boolean bl = this.mTextView.onPrivateIMECommand(string2, bundle);
        return true;
    }
}

