/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.os.FileObserver;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.security.MessageDigest;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Button;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LockPatternUtils {
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    private static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    private static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    private static final String LOCK_PASSWORD_FILE = "password.key";
    private static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    private static final String LOCK_PATTERN_FILE = "gesture.key";
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 3;
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    private static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    private static final String SYSTEM_DIRECTORY = "/system/";
    private static final String TAG = "LockPatternUtils";
    private static final AtomicBoolean sHaveNonZeroPasswordFile;
    private static final AtomicBoolean sHaveNonZeroPatternFile;
    private static String sLockPasswordFilename;
    private static String sLockPatternFilename;
    private static FileObserver sPasswordObserver;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private DevicePolicyManager mDevicePolicyManager;

    static {
        sHaveNonZeroPatternFile = new AtomicBoolean(false);
        sHaveNonZeroPasswordFile = new AtomicBoolean(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternUtils(Context context) {
        ContentResolver contentResolver;
        this.mContext = context;
        this.mContentResolver = contentResolver = context.getContentResolver();
        if (sLockPatternFilename != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Environment.getDataDirectory().getAbsolutePath();
        String string3 = stringBuilder.append(string2).append(SYSTEM_DIRECTORY).toString();
        sLockPatternFilename = string3 + LOCK_PATTERN_FILE;
        sLockPasswordFilename = string3 + LOCK_PASSWORD_FILE;
        AtomicBoolean atomicBoolean = sHaveNonZeroPatternFile;
        String string4 = sLockPatternFilename;
        boolean bl = new File(string4).length() > 0L;
        atomicBoolean.set(bl);
        AtomicBoolean atomicBoolean2 = sHaveNonZeroPasswordFile;
        String string5 = sLockPasswordFilename;
        boolean bl2 = new File(string5).length() > 0L;
        atomicBoolean2.set(bl2);
        sPasswordObserver = new FileObserver(string3, 904){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onEvent(int n, String string2) {
                if (LockPatternUtils.LOCK_PATTERN_FILE.equals(string2)) {
                    int n2 = Log.d(LockPatternUtils.TAG, "lock pattern file changed");
                    AtomicBoolean atomicBoolean = sHaveNonZeroPatternFile;
                    String string3 = sLockPatternFilename;
                    boolean bl = new File(string3).length() > 0L;
                    atomicBoolean.set(bl);
                    return;
                }
                if (!LockPatternUtils.LOCK_PASSWORD_FILE.equals(string2)) {
                    return;
                }
                int n3 = Log.d(LockPatternUtils.TAG, "lock password file changed");
                AtomicBoolean atomicBoolean = sHaveNonZeroPasswordFile;
                String string4 = sLockPasswordFilename;
                boolean bl = new File(string4).length() > 0L;
                atomicBoolean.set(bl);
            }
        };
        sPasswordObserver.startWatching();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int computePasswordQuality(String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string2.charAt(i))) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 && bl) {
            return 327680;
        }
        if (bl2) {
            return 262144;
        }
        if (!bl) return 0;
        return 131072;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getBoolean(String string2) {
        int n = Settings.Secure.getInt(this.mContentResolver, string2, 0);
        if (1 == n) return false;
        return true;
    }

    private long getLong(String string2, long l) {
        return Settings.Secure.getLong(this.mContentResolver, string2, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSalt() {
        long l = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L);
        if (l != 0L) return Long.toHexString(l);
        try {
            l = SecureRandom.getInstance("SHA1PRNG").nextLong();
            this.setLong(LOCK_PASSWORD_SALT_KEY, l);
            int n = Log.v(TAG, "Initialized lock password salt");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Couldn't get SecureRandom number", noSuchAlgorithmException);
        }
        return Long.toHexString(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] patternToHash(List<LockPatternView.Cell> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byte by;
            LockPatternView.Cell cell = list.get(i);
            int n2 = cell.getRow() * 3;
            int n3 = cell.getColumn();
            byArray[i] = by = (byte)(n2 + n3);
        }
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA-1").digest(byArray);
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return byArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String patternToString(List<LockPatternView.Cell> list) {
        if (list == null) {
            return "";
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte by;
            LockPatternView.Cell cell = list.get(n2);
            int n3 = cell.getRow() * 3;
            int n4 = cell.getColumn();
            byArray[n2] = by = (byte)(n3 + n4);
            ++n2;
        }
        return new String(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBoolean(String string2, boolean bl) {
        ContentResolver contentResolver = this.mContentResolver;
        int n = bl ? 1 : 0;
        boolean bl2 = Settings.Secure.putInt(contentResolver, string2, n);
    }

    private void setLong(String string2, long l) {
        boolean bl = Settings.Secure.putLong(this.mContentResolver, string2, l);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        int n;
        ArrayList<LockPatternView.Cell> arrayList = Lists.newArrayList();
        byte[] byArray = string2.getBytes();
        for (int i = 0; i < (n = byArray.length); ++i) {
            byte by = byArray[i];
            int n2 = by / 3;
            int n3 = by % 3;
            LockPatternView.Cell cell = LockPatternView.Cell.of(n2, n3);
            boolean bl = arrayList.add(cell);
        }
        return arrayList;
    }

    private static String toHex(byte[] byArray) {
        int n;
        String string2 = "";
        for (int i = 0; i < (n = byArray.length); ++i) {
            StringBuilder stringBuilder = new StringBuilder().append(string2);
            int n2 = byArray[i] >> 4 & 0xF;
            char c = "0123456789ABCDEF".charAt(n2);
            String string3 = stringBuilder.append(c).toString();
            StringBuilder stringBuilder2 = new StringBuilder().append(string3);
            int n3 = byArray[i] & 0xF;
            char c2 = "0123456789ABCDEF".charAt(n3);
            string2 = stringBuilder2.append(c2).toString();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkPassword(String string2) {
        try {
            String string3 = sLockPasswordFilename;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            int n = byArray.length;
            int n2 = randomAccessFile.read(byArray, 0, n);
            randomAccessFile.close();
            if (n2 <= 0) {
                return true;
            }
            byte[] byArray2 = this.passwordToHash(string2);
            boolean bl = Arrays.equals(byArray, byArray2);
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkPattern(List<LockPatternView.Cell> list) {
        try {
            String string2 = sLockPatternFilename;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            int n = byArray.length;
            int n2 = randomAccessFile.read(byArray, 0, n);
            randomAccessFile.close();
            if (n2 <= 0) {
                return true;
            }
            byte[] byArray2 = LockPatternUtils.patternToHash(list);
            boolean bl = Arrays.equals(byArray, byArray2);
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void clearLock() {
        this.getDevicePolicyManager().setActivePasswordState(0, 0);
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong(PASSWORD_TYPE_KEY, 65536L);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getActivePasswordQuality() {
        int n = 0;
        switch (this.getKeyguardStoredPasswordQuality()) {
            case 65536: {
                if (!this.isLockPatternEnabled()) return n;
                return 65536;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) return n;
                return 131072;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) return n;
                return 262144;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) return n;
                return 327680;
            }
        }
        return n;
    }

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            DevicePolicyManager devicePolicyManager;
            this.mDevicePolicyManager = devicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                IllegalStateException illegalStateException = new IllegalStateException("Stack trace:");
                int n = Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", illegalStateException);
            }
        }
        return this.mDevicePolicyManager;
    }

    public int getKeyguardStoredPasswordQuality() {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLockoutAttemptDeadline() {
        long l;
        long l2 = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (l2 < (l = SystemClock.elapsedRealtime())) return 0L;
        long l3 = 30000L + l;
        if (l2 <= l3) return l2;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNextAlarm() {
        String string2 = Settings.System.getString(this.mContentResolver, "next_alarm_formatted");
        if (string2 == null) return null;
        if (!TextUtils.isEmpty(string2)) return string2;
        return null;
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null);
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLockPasswordEnabled() {
        long l = this.getLong(PASSWORD_TYPE_KEY, 0L);
        if (!this.savedPasswordExists()) return false;
        if (l == 262144L) return true;
        if (l == 131072L) return true;
        if (l != 327680L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLockPatternEnabled() {
        if (!this.getBoolean("lock_pattern_autolock")) return false;
        if (this.getLong(PASSWORD_TYPE_KEY, 65536L) != 65536L) return false;
        return true;
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY);
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSecure() {
        long l = this.getKeyguardStoredPasswordQuality();
        boolean bl = l == 65536L;
        boolean bl2 = l == 131072L || l == 262144L || l == 327680L;
        if (bl && this.isLockPatternEnabled()) {
            if (this.savedPatternExists()) return true;
        }
        if (!bl2) return false;
        if (!this.savedPasswordExists()) return false;
        return true;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.getBoolean("lock_pattern_tactile_feedback_enabled");
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern");
    }

    /*
     * Exception decompiling
     */
    public byte[] passwordToHash(String var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void reportFailedPasswordAttempt() {
        this.getDevicePolicyManager().reportFailedPasswordAttempt();
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resumeCall() {
        ITelephony iTelephony = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        if (iTelephony == null) return false;
        try {
            boolean bl = iTelephony.showCallScreen();
            if (!bl) return false;
            return true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPassword(String string2, int n) {
        DevicePolicyManager devicePolicyManager;
        block8: {
            byte[] byArray = this.passwordToHash(string2);
            try {
                String string3 = sLockPasswordFilename;
                RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rw");
                if (string2 == null) {
                    randomAccessFile.setLength(0L);
                } else {
                    int n2 = byArray.length;
                    randomAccessFile.write(byArray, 0, n2);
                }
                randomAccessFile.close();
                devicePolicyManager = this.getDevicePolicyManager();
                if (string2 == null) break block8;
                int n3 = LockPatternUtils.computePasswordQuality(string2);
                long l = n3;
                this.setLong(PASSWORD_TYPE_KEY, l);
                if (n3 != 0) {
                    int n4 = string2.length();
                    devicePolicyManager.setActivePasswordState(n3, n4);
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to save lock pattern to ");
                String string4 = sLockPasswordFilename;
                String string5 = stringBuilder.append(string4).toString();
                int n5 = Log.e(TAG, string5);
                return;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to save lock pattern to ");
                String string6 = sLockPasswordFilename;
                String string7 = stringBuilder.append(string6).toString();
                int n6 = Log.e(TAG, string7);
                return;
            }
            int n7 = 0;
            int n8 = 0;
            {
                devicePolicyManager.setActivePasswordState(n7, n8);
                return;
            }
        }
        int n9 = 0;
        int n10 = 0;
        {
            devicePolicyManager.setActivePasswordState(n9, n10);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPattern(List<LockPatternView.Cell> list) {
        DevicePolicyManager devicePolicyManager;
        byte[] byArray = LockPatternUtils.patternToHash(list);
        try {
            String string2 = sLockPatternFilename;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            if (list == null) {
                randomAccessFile.setLength(0L);
            } else {
                int n = byArray.length;
                randomAccessFile.write(byArray, 0, n);
            }
            randomAccessFile.close();
            devicePolicyManager = this.getDevicePolicyManager();
            if (list != null) {
                this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true);
                this.setLong(PASSWORD_TYPE_KEY, 65536L);
                int n = list.size();
                devicePolicyManager.setActivePasswordState(65536, n);
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to save lock pattern to ");
            String string3 = sLockPatternFilename;
            String string4 = stringBuilder.append(string3).toString();
            int n = Log.e(TAG, string4);
            return;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to save lock pattern to ");
            String string5 = sLockPatternFilename;
            String string6 = stringBuilder.append(string5).toString();
            int n = Log.e(TAG, string6);
            return;
        }
        int n = 0;
        int n2 = 0;
        {
            devicePolicyManager.setActivePasswordState(n, n2);
            return;
        }
    }

    public boolean savedPasswordExists() {
        return sHaveNonZeroPasswordFile.get();
    }

    public boolean savedPatternExists() {
        return sHaveNonZeroPatternFile.get();
    }

    public void setLockPatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_autolock", bl);
    }

    public long setLockoutAttemptDeadline() {
        long l = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, l);
        return l;
    }

    public void setPermanentlyLocked(boolean bl) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, bl);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        this.setBoolean("lock_pattern_tactile_feedback_enabled", bl);
    }

    public void setVisiblePatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_visible_pattern", bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateEmergencyCallButtonState(Button button) {
        int n;
        if (TelephonyManager.getDefault().getCallState() == 2) {
            n = 17040006;
            button.setCompoundDrawablesWithIntrinsicBounds(17301636, 0, 0, 0);
        } else {
            n = 17040005;
            button.setCompoundDrawablesWithIntrinsicBounds(17301910, 0, 0, 0);
        }
        button.setText(n);
    }
}

