/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.android.internal.R;
import com.android.internal.widget.LockPatternUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int ASPECT_LOCK_HEIGHT = 2;
    private static final int ASPECT_LOCK_WIDTH = 1;
    private static final int ASPECT_SQUARE = 0;
    private static final long[] DEFAULT_VIBE_PATTERN;
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final boolean PROFILE_DRAWING = false;
    static final int STATUS_BAR_HEIGHT = 25;
    private long mAnimatingPeriodStart;
    private int mAspect;
    private Bitmap mBitmapArrowGreenUp;
    private Bitmap mBitmapArrowRedUp;
    private Bitmap mBitmapBtnDefault;
    private Bitmap mBitmapBtnTouched;
    private Bitmap mBitmapCircleDefault;
    private Bitmap mBitmapCircleGreen;
    private Bitmap mBitmapCircleRed;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private final Path mCurrentPath;
    private float mDiameterFactor;
    private boolean mDrawingProfilingStarted = false;
    private float mHitFactor;
    private float mInProgressX;
    private float mInProgressY;
    private boolean mInStealthMode;
    private boolean mInputEnabled;
    private final Rect mInvalidate;
    private OnPatternListener mOnPatternListener;
    private Paint mPaint;
    private Paint mPathPaint;
    private ArrayList<Cell> mPattern;
    private DisplayMode mPatternDisplayMode;
    private boolean[][] mPatternDrawLookup;
    private boolean mPatternInProgress;
    private float mSquareHeight;
    private float mSquareWidth;
    private boolean mTactileFeedbackEnabled;
    private long[] mVibePattern;
    private Vibrator vibe;

    static {
        null[0] = 0L;
        null[1] = 1L;
        null[2] = 40L;
        null[3] = 41L;
        DEFAULT_VIBE_PATTERN = null;
    }

    public LockPatternView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int n2;
        Bitmap bitmap;
        Bitmap bitmap2;
        Bitmap bitmap3;
        Bitmap bitmap4;
        Bitmap bitmap5;
        Bitmap bitmap6;
        Bitmap bitmap7;
        Vibrator vibrator;
        Rect rect;
        Path path;
        DisplayMode displayMode;
        Paint paint;
        Paint paint2;
        this.mPaint = paint2 = new Paint();
        this.mPathPaint = paint = new Paint();
        ArrayList arrayList = new ArrayList(9);
        this.mPattern = arrayList;
        int[] nArray = new int[]{3, 3};
        boolean[][] blArray = (boolean[][])Array.newInstance(Boolean.TYPE, nArray);
        this.mPatternDrawLookup = blArray;
        this.mInProgressX = -1.0f;
        this.mInProgressY = -1.0f;
        this.mPatternDisplayMode = displayMode = DisplayMode.Correct;
        this.mInputEnabled = true;
        this.mInStealthMode = false;
        this.mTactileFeedbackEnabled = true;
        this.mPatternInProgress = false;
        this.mDiameterFactor = 0.5f;
        this.mHitFactor = 0.6f;
        this.mCurrentPath = path = new Path();
        this.mInvalidate = rect = new Rect();
        this.vibe = vibrator = new Vibrator();
        int[] nArray2 = R.styleable.LockPatternView;
        String string2 = context.obtainStyledAttributes(attributeSet, nArray2).getString(0);
        this.mAspect = "square".equals(string2) ? 0 : ("lock_width".equals(string2) ? 1 : ("lock_height".equals(string2) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mPathPaint.setColor(-1);
        this.mPathPaint.setAlpha(128);
        Paint paint3 = this.mPathPaint;
        Paint.Style style2 = Paint.Style.STROKE;
        paint3.setStyle(style2);
        Paint paint4 = this.mPathPaint;
        Paint.Join join = Paint.Join.ROUND;
        paint4.setStrokeJoin(join);
        Paint paint5 = this.mPathPaint;
        Paint.Cap cap = Paint.Cap.ROUND;
        paint5.setStrokeCap(cap);
        this.mBitmapBtnDefault = bitmap7 = this.getBitmapFor(17301708);
        this.mBitmapBtnTouched = bitmap6 = this.getBitmapFor(17301709);
        this.mBitmapCircleDefault = bitmap5 = this.getBitmapFor(17301978);
        this.mBitmapCircleGreen = bitmap4 = this.getBitmapFor(17301979);
        this.mBitmapCircleRed = bitmap3 = this.getBitmapFor(17301980);
        this.mBitmapArrowGreenUp = bitmap2 = this.getBitmapFor(17301976);
        this.mBitmapArrowRedUp = bitmap = this.getBitmapFor(17301977);
        this.mBitmapWidth = n2 = this.mBitmapBtnDefault.getWidth();
        this.mBitmapHeight = n = this.mBitmapBtnDefault.getHeight();
        long[] lArray = this.loadVibratePattern(0x1070011);
        this.mVibePattern = lArray;
    }

    private void addCellToPattern(Cell cell) {
        boolean[][] blArray = this.mPatternDrawLookup;
        int n = cell.getRow();
        boolean[] blArray2 = blArray[n];
        int n2 = cell.getColumn();
        blArray2[n2] = true;
        boolean bl = this.mPattern.add(cell);
        if (this.mOnPatternListener == null) {
            return;
        }
        OnPatternListener onPatternListener = this.mOnPatternListener;
        ArrayList<Cell> arrayList = this.mPattern;
        onPatternListener.onPatternCellAdded(arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cell checkForNewHit(float f, float f2) {
        int n = this.getRowHit(f2);
        if (n < 0) {
            return null;
        }
        int n2 = this.getColumnHit(f);
        if (n2 < 0) {
            return null;
        }
        if (this.mPatternDrawLookup[n][n2] == null) return Cell.of(n, n2);
        return null;
    }

    private void clearPatternDrawLookup() {
        int n = 0;
        while (n < 3) {
            for (int i = 0; i < 3; ++i) {
                this.mPatternDrawLookup[n][i] = false;
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cell detectAndAddHit(float f, float f2) {
        int n;
        int n2;
        boolean[][] blArray;
        boolean[] blArray2;
        Cell cell = this.checkForNewHit(f, f2);
        if (cell == null) {
            return null;
        }
        Cell cell2 = null;
        ArrayList<Cell> arrayList = this.mPattern;
        if (!arrayList.isEmpty()) {
            int n3;
            int n4 = arrayList.size() - 1;
            Cell cell3 = arrayList.get(n4);
            int n5 = cell.row;
            int n6 = cell3.row;
            int n7 = n5 - n6;
            int n8 = cell.column;
            int n9 = cell3.column;
            int n10 = n8 - n9;
            int n11 = cell3.row;
            int n12 = cell3.column;
            if (Math.abs(n7) == 2 && Math.abs(n10) != 1) {
                int n13 = cell3.row;
                n3 = n7 > 0 ? 1 : -1;
                n11 = n13 + n3;
            }
            if (Math.abs(n10) == 2 && Math.abs(n7) != 1) {
                int n14 = cell3.column;
                n3 = n10 > 0 ? 1 : -1;
                n12 = n14 + n3;
            }
            cell2 = Cell.of(n11, n12);
        }
        if (cell2 != null && (blArray2 = (blArray = this.mPatternDrawLookup)[n2 = cell2.row])[n = cell2.column] == null) {
            this.addCellToPattern(cell2);
        }
        this.addCellToPattern(cell);
        if (!this.mTactileFeedbackEnabled) return cell;
        Vibrator vibrator = this.vibe;
        long[] lArray = this.mVibePattern;
        vibrator.vibrate(lArray, -1);
        return cell;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawArrow(Canvas canvas, float f, float f2, Cell cell, Cell cell2) {
        DisplayMode displayMode = this.mPatternDisplayMode;
        DisplayMode displayMode2 = displayMode;
        DisplayMode displayMode3 = DisplayMode.Wrong;
        DisplayMode displayMode4 = displayMode3;
        boolean bl = displayMode2 != displayMode4;
        int n = cell2.row;
        int n2 = cell.row;
        int n3 = cell2.column;
        int n4 = cell.column;
        int n5 = (int)this.mSquareWidth;
        int n6 = this.mBitmapWidth;
        int n7 = (n5 - n6) / 2;
        int n8 = (int)this.mSquareHeight;
        int n9 = this.mBitmapHeight;
        int n10 = (n8 - n9) / 2;
        Bitmap bitmap = bl ? this.mBitmapArrowGreenUp : this.mBitmapArrowRedUp;
        Matrix matrix = new Matrix();
        int n11 = this.mBitmapCircleDefault.getWidth();
        int n12 = this.mBitmapCircleDefault.getHeight();
        double d = n - n2;
        double d2 = n3 - n4;
        float f3 = (float)Math.toDegrees((float)Math.atan2(d, d2)) + 90.0f;
        float f4 = (float)n7 + f;
        float f5 = (float)n10 + f2;
        Matrix matrix2 = matrix;
        float f6 = f4;
        float f7 = f5;
        matrix2.setTranslate(f6, f7);
        float f8 = (float)n11 / 2.0f;
        float f9 = (float)n12 / 2.0f;
        Matrix matrix3 = matrix;
        float f10 = f3;
        float f11 = f8;
        float f12 = f9;
        boolean bl2 = matrix3.preRotate(f10, f11, f12);
        int n13 = bitmap.getWidth();
        float f13 = (float)(n11 - n13) / 2.0f;
        Matrix matrix4 = matrix;
        float f14 = f13;
        float f15 = 0.0f;
        boolean bl3 = matrix4.preTranslate(f14, f15);
        Paint paint = this.mPaint;
        Canvas canvas2 = canvas;
        Bitmap bitmap2 = bitmap;
        Matrix matrix5 = matrix;
        Paint paint2 = paint;
        canvas2.drawBitmap(bitmap2, matrix5, paint2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCircle(Canvas canvas, int n, int n2, boolean bl) {
        Bitmap bitmap;
        Bitmap bitmap2;
        DisplayMode displayMode;
        DisplayMode displayMode2;
        if (!bl || this.mInStealthMode && (displayMode2 = this.mPatternDisplayMode) != (displayMode = DisplayMode.Wrong)) {
            bitmap2 = this.mBitmapCircleDefault;
            bitmap = this.mBitmapBtnDefault;
        } else if (this.mPatternInProgress) {
            bitmap2 = this.mBitmapCircleGreen;
            bitmap = this.mBitmapBtnTouched;
        } else {
            DisplayMode displayMode3 = this.mPatternDisplayMode;
            DisplayMode displayMode4 = DisplayMode.Wrong;
            if (displayMode3 == displayMode4) {
                bitmap2 = this.mBitmapCircleRed;
                bitmap = this.mBitmapBtnDefault;
            } else {
                DisplayMode displayMode5;
                DisplayMode displayMode6;
                DisplayMode displayMode7 = this.mPatternDisplayMode;
                DisplayMode displayMode8 = DisplayMode.Correct;
                if (displayMode7 != displayMode8 && (displayMode6 = this.mPatternDisplayMode) != (displayMode5 = DisplayMode.Animate)) {
                    StringBuilder stringBuilder = new StringBuilder().append("unknown display mode ");
                    DisplayMode displayMode9 = this.mPatternDisplayMode;
                    String string2 = stringBuilder.append((Object)displayMode9).toString();
                    throw new IllegalStateException(string2);
                }
                bitmap2 = this.mBitmapCircleGreen;
                bitmap = this.mBitmapBtnDefault;
            }
        }
        int n3 = this.mBitmapWidth;
        int n4 = this.mBitmapHeight;
        float f = this.mSquareWidth;
        float f2 = this.mSquareHeight;
        float f3 = n3;
        int n5 = (int)((f - f3) / 2.0f);
        float f4 = n4;
        int n6 = (int)((f2 - f4) / 2.0f);
        float f5 = n + n5;
        float f6 = n2 + n6;
        Paint paint = this.mPaint;
        canvas.drawBitmap(bitmap2, f5, f6, paint);
        float f7 = n + n5;
        float f8 = n2 + n6;
        Paint paint2 = this.mPaint;
        canvas.drawBitmap(bitmap, f7, f8, paint2);
    }

    private Bitmap getBitmapFor(int n) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), n);
    }

    private float getCenterXForColumn(int n) {
        float f = this.mPaddingLeft;
        float f2 = n;
        float f3 = this.mSquareWidth;
        float f4 = f2 * f3;
        float f5 = f + f4;
        float f6 = this.mSquareWidth / 2.0f;
        return f5 + f6;
    }

    private float getCenterYForRow(int n) {
        float f = this.mPaddingTop;
        float f2 = n;
        float f3 = this.mSquareHeight;
        float f4 = f2 * f3;
        float f5 = f + f4;
        float f6 = this.mSquareHeight / 2.0f;
        return f5 + f6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getColumnHit(float f) {
        float f2 = this.mSquareWidth;
        float f3 = this.mHitFactor;
        float f4 = f2 * f3;
        float f5 = this.mPaddingLeft;
        float f6 = (f2 - f4) / 2.0f;
        float f7 = f5 + f6;
        int n = 0;
        while (n < 3) {
            float f8;
            float f9 = (float)n * f2;
            float f10 = f7 + f9;
            if (f >= f10 && f <= (f8 = f10 + f4)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRowHit(float f) {
        float f2 = this.mSquareHeight;
        float f3 = this.mHitFactor;
        float f4 = f2 * f3;
        float f5 = this.mPaddingTop;
        float f6 = (f2 - f4) / 2.0f;
        float f7 = f5 + f6;
        int n = 0;
        while (n < 3) {
            float f8;
            float f9 = (float)n * f2;
            float f10 = f7 + f9;
            if (f >= f10 && f <= (f8 = f10 + f4)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] loadVibratePattern(int n) {
        void var4_7;
        int[] nArray = null;
        try {
            int[] nArray2;
            nArray = nArray2 = this.getResources().getIntArray(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            int n2 = Log.e("LockPatternView", "Vibrate pattern missing, using default", notFoundException);
        }
        if (nArray == null) {
            long[] lArray = DEFAULT_VIBE_PATTERN;
            return var4_7;
        }
        int n3 = nArray.length;
        int n4 = 0;
        while (true) {
            long l;
            int n5;
            if (n4 >= (n5 = nArray.length)) {
                int n6 = n3;
                return var4_7;
            }
            n3[n4] = l = (long)nArray[n4];
            ++n4;
        }
    }

    private void resetPattern() {
        DisplayMode displayMode;
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = displayMode = DisplayMode.Correct;
        this.invalidate();
    }

    public void clearPattern() {
        this.resetPattern();
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mTactileFeedbackEnabled;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void onDraw(Canvas var1_1) {
        block18: {
            block20: {
                block17: {
                    block16: {
                        block15: {
                            block19: {
                                var2_2 = this.mPattern;
                                var3_3 = var2_2.size();
                                var4_4 = this.mPatternDrawLookup;
                                var5_5 = this.mPatternDisplayMode;
                                var6_6 = DisplayMode.Animate;
                                if (var5_5 != var6_6) ** GOTO lbl56
                                var7_7 = (var3_3 + 1) * 700;
                                var8_8 = SystemClock.elapsedRealtime();
                                var10_9 = this.mAnimatingPeriodStart;
                                var12_10 = (int)(var8_8 - var10_9) % var7_7;
                                var13_11 = var12_10 / 700;
                                this.clearPatternDrawLookup();
                                var14_12 = 0;
                                while ((var15_13 = var14_12) < (var16_14 = var13_11)) {
                                    var17_15 = var2_2;
                                    var18_16 = var14_12++;
                                    var19_17 = var17_15.get(var18_16);
                                    var20_18 = var19_17.getRow();
                                    var21_19 = var4_4[var20_18];
                                    var22_20 = var19_17.getColumn();
                                    var21_19[var22_20] = true;
                                }
                                if (var13_11 <= 0 || (var23_21 = var13_11) >= (var24_22 = var3_3)) break block19;
                                var23_21 = 1;
lbl25:
                                // 2 sources

                                while (true) {
                                    if (var23_21 != 0) {
                                        var26_23 = (float)(var12_10 % 700) / 700.0f;
                                        var27_24 = var13_11 - 1;
                                        var28_25 = var2_2;
                                        var29_26 = var27_24;
                                        var30_27 = var28_25.get(var29_26);
                                        var31_28 = var30_27.column;
                                        var32_29 = this;
                                        var33_30 = var31_28;
                                        var34_31 = var32_29.getCenterXForColumn(var33_30);
                                        var35_32 = var30_27.row;
                                        var36_33 = this;
                                        var37_34 = var35_32;
                                        var38_35 = var36_33.getCenterYForRow(var37_34);
                                        var39_36 = var2_2;
                                        var40_37 = var13_11;
                                        var41_38 = var39_36.get(var40_37);
                                        var42_39 = var41_38.column;
                                        var43_40 = this;
                                        var44_41 = var42_39;
                                        var45_42 = var43_40.getCenterXForColumn(var44_41) - var34_31;
                                        var46_43 = var26_23 * var45_42;
                                        var47_44 = var41_38.row;
                                        var48_45 = this;
                                        var49_46 = var47_44;
                                        var50_47 = var48_45.getCenterYForRow(var49_46) - var38_35;
                                        var51_48 = var26_23 * var50_47;
                                        this.mInProgressX = var52_49 = var34_31 + var46_43;
                                        this.mInProgressY = var53_50 = var38_35 + var51_48;
                                    }
                                    this.invalidate();
lbl56:
                                    // 2 sources

                                    var54_51 = this.mSquareWidth;
                                    var55_52 = this.mSquareHeight;
                                    var56_53 = this.mDiameterFactor * var54_51 * 0.5f;
                                    var57_54 = this.mPathPaint;
                                    var58_55 = var56_53;
                                    var57_54.setStrokeWidth(var58_55);
                                    var59_56 = this.mCurrentPath;
                                    var59_56.rewind();
                                    if (this.mInStealthMode && (var60_57 = this.mPatternDisplayMode) != (var61_59 = DisplayMode.Wrong)) break block15;
                                    var60_58 = true;
lbl66:
                                    // 2 sources

                                    while (true) {
                                        if (!var60_58) ** GOTO lbl92
                                        var61_60 = false;
                                        var14_12 = 0;
lbl70:
                                        // 2 sources

                                        while (true) {
                                            var65_62 = var3_3;
                                            if ((var64_61 = ++var14_12) < var65_62) {
                                                var66_63 = var2_2;
                                                var67_64 = var14_12;
                                                var68_65 = var66_63.get(var67_64);
                                                var69_66 = var68_65.row;
                                                var70_67 = var4_4[var69_66];
                                                var71_68 = var68_65.column;
                                                if (var70_67[var71_68] != null) break block16;
                                            }
                                            if ((this.mPatternInProgress || (var72_83 = this.mPatternDisplayMode) == (var73_84 = DisplayMode.Animate)) && var61_60) {
                                                var74_85 = this.mInProgressX;
                                                var75_86 = this.mInProgressY;
                                                var76_87 = var59_56;
                                                var77_88 = var74_85;
                                                var78_89 = var75_86;
                                                var76_87.lineTo(var77_88, var78_89);
                                            }
                                            var79_90 = this.mPathPaint;
                                            var80_91 = var1_1;
                                            var81_92 = var59_56;
                                            var82_93 = var79_90;
                                            var80_91.drawPath(var81_92, var82_93);
lbl92:
                                            // 2 sources

                                            var83_94 = this.mPaddingTop;
                                            var84_95 = this.mPaddingLeft;
                                            var85_96 = 0;
                                            while ((var86_97 = ++var85_96) < (var87_98 = 3)) {
                                                var88_99 = var83_94;
                                                var89_100 = (float)var85_96 * var55_52;
                                                var90_101 = var88_99 + var89_100;
                                                var91_102 = 0;
                                                while ((var92_103 = ++var91_102) < (var93_104 = 3)) {
                                                    var94_105 = var84_95;
                                                    var95_106 = (float)var91_102 * var54_51;
                                                    var96_107 = (int)(var94_105 + var95_106);
                                                    var97_108 = (int)var90_101;
                                                    var98_109 = var4_4[var85_96][var91_102];
                                                    var99_110 = this;
                                                    var100_111 = var1_1;
                                                    var101_112 = var96_107;
                                                    var102_113 = var97_108;
                                                    var103_114 = var98_109;
                                                    var99_110.drawCircle(var100_111, var101_112, var102_113, var103_114);
                                                }
                                            }
                                            break block17;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            var23_21 = 0;
                            ** while (true)
                        }
                        var60_58 = false;
                        ** while (true)
                    }
                    var61_60 = true;
                    var104_69 = var68_65.column;
                    var105_70 = this;
                    var106_71 = var104_69;
                    var107_72 = var105_70.getCenterXForColumn(var106_71);
                    var108_73 = var68_65.row;
                    var109_74 = this;
                    var110_75 = var108_73;
                    var111_76 = var109_74.getCenterYForRow(var110_75);
                    if (var14_12 == 0) {
                        var112_77 = var59_56;
                        var113_78 = var107_72;
                        var114_79 = var111_76;
                        var112_77.moveTo(var113_78, var114_79);
lbl136:
                        // 2 sources

                        while (true) {
                            ** continue;
                            break;
                        }
                    }
                    var115_80 = var59_56;
                    var116_81 = var107_72;
                    var117_82 = var111_76;
                    var115_80.lineTo(var116_81, var117_82);
                    ** while (true)
                }
                if ((this.mPaint.getFlags() & 2) == 0) break block20;
                var118_115 = true;
lbl146:
                // 2 sources

                while (true) {
                    this.mPaint.setFilterBitmap(true);
                    if (!var60_58) ** GOTO lbl165
                    var85_96 = 0;
lbl150:
                    // 2 sources

                    while (true) {
                        var119_116 = var3_3 - 1;
                        var121_118 = var119_116;
                        if ((var120_117 = ++var85_96) < var121_118) {
                            var122_119 = var2_2;
                            var123_120 = var85_96;
                            var68_65 = var122_119.get(var123_120);
                            var124_121 = var85_96 + 1;
                            var125_122 = var2_2;
                            var126_123 = var124_121;
                            var127_124 = var125_122.get(var126_123);
                            var128_125 = var127_124.row;
                            var129_126 = var4_4[var128_125];
                            var130_127 = var127_124.column;
                            if (var129_126[var130_127] != null) break block18;
                        }
lbl165:
                        // 4 sources

                        var131_136 = this.mPaint;
                        var132_137 = var118_115;
                        var131_136.setFilterBitmap(var132_137);
                        return;
                    }
                    break;
                }
            }
            var118_115 = false;
            ** while (true)
        }
        var133_128 = var84_95;
        var134_129 = (float)var68_65.column * var54_51;
        var135_130 = var133_128 + var134_129;
        var136_131 = var83_94;
        var137_132 = (float)var68_65.row * var55_52;
        var138_133 = var136_131 + var137_132;
        var139_134 = this;
        var140_135 = var1_1;
        var139_134.drawArrow(var140_135, var135_130, var138_133, var68_65, var127_124);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getSize(n2);
        int n5 = n3;
        int n6 = n4;
        switch (this.mAspect) {
            case 0: {
                n5 = n6 = Math.min(n3, n4);
                break;
            }
            case 1: {
                n5 = n3;
                n6 = Math.min(n3, n4);
                break;
            }
            case 2: {
                n5 = Math.min(n3, n4);
                n6 = n4;
                break;
            }
        }
        this.setMeasuredDimension(n5, n6);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        DisplayMode displayMode;
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        DisplayMode displayMode2 = DisplayMode.Correct;
        List<Cell> list = LockPatternUtils.stringToPattern(savedState.getSerializedPattern());
        this.setPattern(displayMode2, list);
        DisplayMode[] displayModeArray = DisplayMode.values();
        int n = savedState.getDisplayMode();
        this.mPatternDisplayMode = displayMode = displayModeArray[n];
        this.mInputEnabled = bl3 = savedState.isInputEnabled();
        this.mInStealthMode = bl2 = savedState.isInStealthMode();
        this.mTactileFeedbackEnabled = bl = savedState.isTactileFeedbackEnabled();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        String string2 = LockPatternUtils.patternToString(this.mPattern);
        int n = this.mPatternDisplayMode.ordinal();
        boolean bl = this.mInputEnabled;
        boolean bl2 = this.mInStealthMode;
        boolean bl3 = this.mTactileFeedbackEnabled;
        return new SavedState(parcelable, string2, n, bl, bl2, bl3);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        int n5 = this.mPaddingLeft;
        int n6 = n - n5;
        int n7 = this.mPaddingRight;
        this.mSquareWidth = f2 = (float)(n6 - n7) / 3.0f;
        int n8 = this.mPaddingTop;
        int n9 = n2 - n8;
        int n10 = this.mPaddingBottom;
        this.mSquareHeight = f = (float)(n9 - n10) / 3.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            var2_2 = false;
lbl3:
            // 6 sources

            return var2_2;
        }
        var3_3 = var1_1.getX();
        var4_4 = var1_1.getY();
        switch (var1_1.getAction()) {
            default: {
                var2_2 = false;
                ** GOTO lbl3
            }
            case 0: {
                this.resetPattern();
                var5_5 = this;
                var6_6 = var3_3;
                var7_7 = var4_4;
                var8_8 = var5_5.detectAndAddHit(var6_6, var7_7);
                if (var8_8 == null || this.mOnPatternListener == null) ** GOTO lbl47
                this.mPatternInProgress = var9_10 = true;
                this.mPatternDisplayMode = var10_11 = DisplayMode.Correct;
                this.mOnPatternListener.onPatternStart();
lbl21:
                // 3 sources

                while (true) {
                    if (var8_8 != null) {
                        var11_12 = var8_8.column;
                        var12_13 = this;
                        var13_14 = var11_12;
                        var14_15 = var12_13.getCenterXForColumn(var13_14);
                        var15_16 = var8_8.row;
                        var16_17 = this;
                        var17_18 = var15_16;
                        var18_19 = var16_17.getCenterYForRow(var17_18);
                        var19_20 = this.mSquareWidth / 2.0f;
                        var20_21 = this.mSquareHeight / 2.0f;
                        var21_22 = (int)(var14_15 - var19_20);
                        var22_23 = (int)(var18_19 - var20_21);
                        var23_24 = (int)(var14_15 + var19_20);
                        var24_25 = (int)(var18_19 + var20_21);
                        var25_26 = this;
                        var26_27 = var21_22;
                        var27_28 = var22_23;
                        var28_29 = var23_24;
                        var29_30 = var24_25;
                        var25_26.invalidate(var26_27, var27_28, var28_29, var29_30);
                    }
                    this.mInProgressX = var30_31 = var3_3;
                    this.mInProgressY = var31_32 = var4_4;
                    var2_2 = true;
                    ** GOTO lbl3
                    break;
                }
lbl47:
                // 1 sources

                if (this.mOnPatternListener == null) ** GOTO lbl21
                this.mPatternInProgress = var32_33 = false;
                this.mOnPatternListener.onPatternCleared();
                ** continue;
            }
            case 1: {
                if (!this.mPattern.isEmpty() && this.mOnPatternListener != null) {
                    this.mPatternInProgress = var33_34 = false;
                    var34_35 = this.mOnPatternListener;
                    var35_36 = this.mPattern;
                    var34_35.onPatternDetected(var35_36);
                    this.invalidate();
                }
                var2_2 = true;
                ** GOTO lbl3
            }
            case 2: {
                var36_37 = this.mPattern.size();
                var37_38 = this;
                var38_39 = var3_3;
                var39_40 = var4_4;
                var8_9 = var37_38.detectAndAddHit(var38_39, var39_40);
                var40_41 = this.mPattern.size();
                if (var8_9 != null && this.mOnPatternListener != null && (var41_42 = var40_41) == (var42_43 = 1)) {
                    this.mPatternInProgress = var43_44 = true;
                    this.mOnPatternListener.onPatternStart();
                }
                if (!((var48_49 = (var45_46 = Math.abs(var3_3 - (var44_45 = this.mInProgressX))) + (var47_48 = Math.abs(var4_4 - (var46_47 = this.mInProgressY)))) > (var49_50 = this.mSquareWidth * 0.01f))) ** GOTO lbl175
                var50_51 = this.mInProgressX;
                var51_52 = this.mInProgressY;
                this.mInProgressX = var52_53 = var3_3;
                this.mInProgressY = var53_54 = var4_4;
                if (!this.mPatternInProgress || var40_41 <= 0) ** GOTO lbl204
                var54_55 = this.mPattern;
                var55_56 = this.mSquareWidth;
                var56_57 = this.mDiameterFactor;
                var57_58 = var55_56 * var56_57 * 0.5f;
                var58_59 = var40_41 - 1;
                var59_60 = var54_55;
                var60_61 = var58_59;
                var61_62 = var59_60.get(var60_61);
                var62_63 = var61_62.column;
                var63_64 = this;
                var64_65 = var62_63;
                var65_66 = var63_64.getCenterXForColumn(var64_65);
                var66_67 = var61_62.row;
                var67_68 = this;
                var68_69 = var66_67;
                var69_70 = var67_68.getCenterYForRow(var68_69);
                var70_71 = this.mInvalidate;
                if (!(var65_66 < var3_3)) ** GOTO lbl181
                var71_72 = var65_66;
                var72_73 = var3_3;
lbl96:
                // 2 sources

                while (var69_70 < var4_4) {
                    var73_74 = var69_70;
                    var74_75 = var4_4;
lbl99:
                    // 2 sources

                    while (true) {
                        var75_76 = (int)(var71_72 - var57_58);
                        var76_77 = (int)(var73_74 - var57_58);
                        var77_78 = (int)(var72_73 + var57_58);
                        var78_79 = (int)(var74_75 + var57_58);
                        var79_80 = var70_71;
                        var80_81 = var75_76;
                        var81_82 = var76_77;
                        var82_83 = var77_78;
                        var83_84 = var78_79;
                        var79_80.set(var80_81, var81_82, var82_83, var83_84);
                        if (!(var65_66 < var50_51)) ** GOTO lbl187
                        var84_85 = var65_66;
                        var85_86 = var50_51;
lbl113:
                        // 2 sources

                        while (var69_70 < var51_52) {
                            var86_87 = var69_70;
                            var87_88 = var51_52;
lbl116:
                            // 2 sources

                            while (true) {
                                var88_89 = (int)(var84_85 - var57_58);
                                var89_90 = (int)(var86_87 - var57_58);
                                var90_91 = (int)(var85_86 + var57_58);
                                var91_92 = (int)(var87_88 + var57_58);
                                var92_93 = var70_71;
                                var93_94 = var88_89;
                                var94_95 = var89_90;
                                var95_96 = var90_91;
                                var96_97 = var91_92;
                                var92_93.union(var93_94, var94_95, var95_96, var96_97);
                                if (var8_9 == null) ** GOTO lbl172
                                var97_98 = var8_9.column;
                                var98_99 = this;
                                var99_100 = var97_98;
                                var65_66 = var98_99.getCenterXForColumn(var99_100);
                                var100_101 = var8_9.row;
                                var101_102 = this;
                                var102_103 = var100_101;
                                var69_70 = var101_102.getCenterYForRow(var102_103);
                                var103_104 = var40_41;
                                var104_105 = 2;
                                if (var103_104 < var104_105) ** GOTO lbl199
                                var105_106 = var40_41 - 1;
                                var106_107 = var40_41 - var36_37;
                                var107_108 = var105_106 - var106_107;
                                var108_109 = var54_55;
                                var109_110 = var107_108;
                                var110_111 = var108_109.get(var109_110);
                                var111_112 = var110_111.column;
                                var112_113 = this;
                                var113_114 = var111_112;
                                var50_51 = var112_113.getCenterXForColumn(var113_114);
                                var114_115 = var110_111.row;
                                var115_116 = this;
                                var116_117 = var114_115;
                                var51_52 = var115_116.getCenterYForRow(var116_117);
                                if (!(var65_66 < var50_51)) ** GOTO lbl193
                                var84_85 = var65_66;
                                var85_86 = var50_51;
lbl156:
                                // 2 sources

                                while (var69_70 < var51_52) {
                                    var86_87 = var69_70;
                                    var87_88 = var51_52;
lbl159:
                                    // 3 sources

                                    while (true) {
                                        var117_118 = this.mSquareWidth / 2.0f;
                                        var118_119 = this.mSquareHeight / 2.0f;
                                        var119_120 = (int)(var84_85 - var117_118);
                                        var120_121 = (int)(var86_87 - var118_119);
                                        var121_122 = (int)(var85_86 + var117_118);
                                        var122_123 = (int)(var87_88 + var118_119);
                                        var123_124 = var70_71;
                                        var124_125 = var119_120;
                                        var125_126 = var120_121;
                                        var126_127 = var121_122;
                                        var127_128 = var122_123;
                                        var123_124.set(var124_125, var125_126, var126_127, var127_128);
lbl172:
                                        // 2 sources

                                        var128_129 = this;
                                        var129_130 = var70_71;
                                        var128_129.invalidate(var129_130);
lbl175:
                                        // 3 sources

                                        while (true) {
                                            var2_2 = true;
                                            ** GOTO lbl3
                                            break;
                                        }
                                        break;
                                    }
                                }
                                ** GOTO lbl196
                                break;
                            }
                        }
                        ** GOTO lbl190
                        break;
                    }
                }
                ** GOTO lbl184
lbl181:
                // 1 sources

                var71_72 = var3_3;
                var72_73 = var65_66;
                ** GOTO lbl96
lbl184:
                // 1 sources

                var73_74 = var4_4;
                var74_75 = var69_70;
                ** continue;
lbl187:
                // 1 sources

                var84_85 = var50_51;
                var85_86 = var65_66;
                ** GOTO lbl113
lbl190:
                // 1 sources

                var86_87 = var51_52;
                var87_88 = var69_70;
                ** continue;
lbl193:
                // 1 sources

                var84_85 = var50_51;
                var85_86 = var65_66;
                ** GOTO lbl156
lbl196:
                // 1 sources

                var86_87 = var51_52;
                var87_88 = var69_70;
                ** GOTO lbl159
lbl199:
                // 1 sources

                var85_86 = var65_66;
                var84_85 = var65_66;
                var87_88 = var69_70;
                var86_87 = var69_70;
                ** continue;
lbl204:
                // 1 sources

                this.invalidate();
                ** continue;
            }
            case 3: 
        }
        this.resetPattern();
        if (this.mOnPatternListener != null) {
            this.mPatternInProgress = var130_131 = false;
            this.mOnPatternListener.onPatternCleared();
        }
        var2_2 = true;
        ** while (true)
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        DisplayMode displayMode2 = DisplayMode.Animate;
        if (displayMode == displayMode2) {
            float f;
            float f2;
            long l;
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = l = SystemClock.elapsedRealtime();
            Cell cell = this.mPattern.get(0);
            int n = cell.getColumn();
            this.mInProgressX = f2 = this.getCenterXForColumn(n);
            int n2 = cell.getRow();
            this.mInProgressY = f = this.getCenterYForRow(n2);
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void setInStealthMode(boolean bl) {
        this.mInStealthMode = bl;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(DisplayMode displayMode, List<Cell> list) {
        this.mPattern.clear();
        boolean bl = this.mPattern.addAll(list);
        this.clearPatternDrawLookup();
        for (Cell cell : list) {
            boolean[][] blArray = this.mPatternDrawLookup;
            int n = cell.getRow();
            boolean[] blArray2 = blArray[n];
            int n2 = cell.getColumn();
            blArray2[n2] = true;
        }
        this.setDisplayMode(displayMode);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        this.mTactileFeedbackEnabled = bl;
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mDisplayMode;
        private final boolean mInStealthMode;
        private final boolean mInputEnabled;
        private final String mSerializedPattern;
        private final boolean mTactileFeedbackEnabled;

        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            String string2;
            this.mSerializedPattern = string2 = parcel.readString();
            this.mDisplayMode = n = parcel.readInt();
            this.mInputEnabled = bl3 = ((Boolean)parcel.readValue(null)).booleanValue();
            this.mInStealthMode = bl2 = ((Boolean)parcel.readValue(null)).booleanValue();
            this.mTactileFeedbackEnabled = bl = ((Boolean)parcel.readValue(null)).booleanValue();
        }

        private SavedState(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
            super(parcelable);
            this.mSerializedPattern = string2;
            this.mDisplayMode = n;
            this.mInputEnabled = bl;
            this.mInStealthMode = bl2;
            this.mTactileFeedbackEnabled = bl3;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            String string2 = this.mSerializedPattern;
            parcel.writeString(string2);
            int n2 = this.mDisplayMode;
            parcel.writeInt(n2);
            Boolean bl = this.mInputEnabled;
            parcel.writeValue(bl);
            Boolean bl2 = this.mInStealthMode;
            parcel.writeValue(bl2);
            Boolean bl3 = this.mTactileFeedbackEnabled;
            parcel.writeValue(bl3);
        }
    }

    public static interface OnPatternListener {
        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternCleared();

        public void onPatternDetected(List<Cell> var1);

        public void onPatternStart();
    }

    public static final class DisplayMode
    extends Enum<DisplayMode> {
        private static final /* synthetic */ DisplayMode[] $VALUES;
        public static final /* enum */ DisplayMode Animate;
        public static final /* enum */ DisplayMode Correct;
        public static final /* enum */ DisplayMode Wrong;

        static {
            Correct = new DisplayMode();
            Animate = new DisplayMode();
            Wrong = new DisplayMode();
            DisplayMode displayMode = Correct;
            DisplayMode displayMode2 = Animate;
            DisplayMode displayMode3 = Wrong;
            DisplayMode[] displayModeArray = new DisplayMode[]{displayMode, displayMode2, displayMode3};
            $VALUES = displayModeArray;
        }

        public static DisplayMode valueOf(String string2) {
            return Enum.valueOf(DisplayMode.class, string2);
        }

        public static DisplayMode[] values() {
            return (DisplayMode[])$VALUES.clone();
        }
    }

    public static class Cell {
        static Cell[][] sCells;
        int column;
        int row;

        static {
            int[] nArray = new int[]{3, 3};
            sCells = (Cell[][])Array.newInstance(Cell.class, nArray);
            int n = 0;
            while (n < 3) {
                for (int i = 0; i < 3; ++i) {
                    Cell cell;
                    Cell[] cellArray = sCells[n];
                    cellArray[i] = cell = new Cell(n, i);
                }
                ++n;
            }
            return;
        }

        private Cell(int n, int n2) {
            Cell.checkRange(n, n2);
            this.row = n;
            this.column = n2;
        }

        private static void checkRange(int n, int n2) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (n2 >= 0 && n2 <= 2) {
                return;
            }
            throw new IllegalArgumentException("column must be in range 0-2");
        }

        public static Cell of(int n, int n2) {
            synchronized (Cell.class) {
                Cell.checkRange(n, n2);
                Cell cell = sCells[n][n2];
                return cell;
            }
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("(row=");
            int n = this.row;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(",clmn=");
            int n2 = this.column;
            return stringBuilder2.append(n2).append(")").toString();
        }
    }
}

