/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import java.util.Locale;

public class PasswordEntryKeyboard
extends Keyboard {
    public static final int KEYCODE_SPACE = 32;
    private static final int SHIFT_LOCKED = 2;
    private static final int SHIFT_OFF = 0;
    private static final int SHIFT_ON = 1;
    private static final String TAG = "PasswordEntryKeyboard";
    static int sSpacebarVerticalCorrection;
    private Keyboard.Key mEnterKey;
    private int mExtensionResId;
    private Keyboard.Key mF1Key;
    private Locale mLocale;
    private Drawable mOldShiftIcon;
    private Drawable mOldShiftPreviewIcon;
    private Resources mRes;
    private Drawable mShiftIcon;
    private Keyboard.Key mShiftKey;
    private Drawable mShiftLockIcon;
    private Drawable mShiftLockPreviewIcon;
    private int mShiftState = 0;
    private Drawable mSpaceIcon;
    private Keyboard.Key mSpaceKey;

    public PasswordEntryKeyboard(Context context, int n) {
        this(context, n, 0);
    }

    public PasswordEntryKeyboard(Context context, int n, int n2) {
        super(context, n, n2);
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        Drawable drawable5;
        Resources resources;
        this.mRes = resources = context.getResources();
        this.mShiftIcon = drawable5 = resources.getDrawable(17302267);
        this.mShiftLockIcon = drawable4 = resources.getDrawable(17302268);
        Drawable drawable6 = this.mShiftLockPreviewIcon = (drawable3 = resources.getDrawable(17302252));
        int n3 = this.mShiftLockPreviewIcon.getIntrinsicWidth();
        int n4 = this.mShiftLockPreviewIcon.getIntrinsicHeight();
        drawable6.setBounds(0, 0, n3, n4);
        this.mSpaceIcon = drawable2 = resources.getDrawable(17302269);
        sSpacebarVerticalCorrection = resources.getDimensionPixelOffset(17104907);
    }

    public PasswordEntryKeyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        super(context, n, charSequence, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Keyboard.Key createKeyFromXml(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        Resources resources2 = resources;
        Keyboard.Row row2 = row;
        int n3 = n;
        int n4 = n2;
        XmlResourceParser xmlResourceParser2 = xmlResourceParser;
        LatinKey latinKey = new LatinKey(resources2, row2, n3, n4, xmlResourceParser2);
        int n5 = latinKey.codes[0];
        if (n5 >= 0 && n5 != 10 && (n5 < 32 || n5 > 127)) {
            latinKey.label = " ";
            latinKey.setEnabled(false);
        }
        switch (latinKey.codes[0]) {
            case 10: {
                this.mEnterKey = latinKey;
                return latinKey;
            }
            case -103: {
                this.mF1Key = latinKey;
                return latinKey;
            }
            case 32: {
                this.mSpaceKey = latinKey;
                return latinKey;
            }
        }
        return latinKey;
    }

    void enableShiftLock() {
        Drawable drawable2;
        Drawable drawable3;
        Keyboard.Key key;
        int n = this.getShiftKeyIndex();
        if (n < 0) {
            return;
        }
        this.mShiftKey = key = this.getKeys().get(n);
        if (this.mShiftKey instanceof LatinKey) {
            ((LatinKey)this.mShiftKey).enableShiftLock();
        }
        this.mOldShiftIcon = drawable3 = this.mShiftKey.icon;
        this.mOldShiftPreviewIcon = drawable2 = this.mShiftKey.iconPreview;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShifted() {
        if (this.mShiftKey == null) return super.isShifted();
        if (this.mShiftState == 0) return false;
        return true;
    }

    void setEnterKeyResources(Resources resources, int n, int n2, int n3) {
        CharSequence charSequence;
        Drawable drawable2;
        Drawable drawable3;
        if (this.mEnterKey == null) {
            return;
        }
        this.mEnterKey.popupCharacters = null;
        this.mEnterKey.popupResId = 0;
        this.mEnterKey.text = null;
        Keyboard.Key key = this.mEnterKey;
        key.iconPreview = drawable3 = resources.getDrawable(n);
        Keyboard.Key key2 = this.mEnterKey;
        key2.icon = drawable2 = resources.getDrawable(n2);
        Keyboard.Key key3 = this.mEnterKey;
        key3.label = charSequence = resources.getText(n3);
        if (this.mEnterKey.iconPreview == null) {
            return;
        }
        Drawable drawable4 = this.mEnterKey.iconPreview;
        int n4 = this.mEnterKey.iconPreview.getIntrinsicWidth();
        int n5 = this.mEnterKey.iconPreview.getIntrinsicHeight();
        drawable4.setBounds(0, 0, n4, n5);
    }

    void setShiftLocked(boolean bl) {
        Drawable drawable2;
        if (this.mShiftKey == null) {
            return;
        }
        if (bl) {
            Drawable drawable3;
            this.mShiftKey.on = true;
            Keyboard.Key key = this.mShiftKey;
            key.icon = drawable3 = this.mShiftLockIcon;
            this.mShiftState = 2;
            return;
        }
        this.mShiftKey.on = false;
        Keyboard.Key key = this.mShiftKey;
        key.icon = drawable2 = this.mShiftLockIcon;
        this.mShiftState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setShifted(boolean bl) {
        boolean bl2 = false;
        if (this.mShiftKey == null) {
            return super.setShifted(bl);
        }
        if (!bl) {
            Drawable drawable2;
            bl2 = this.mShiftState != 0;
            this.mShiftState = 0;
            this.mShiftKey.on = false;
            Keyboard.Key key = this.mShiftKey;
            key.icon = drawable2 = this.mOldShiftIcon;
            return bl2;
        } else {
            Drawable drawable3;
            if (this.mShiftState != 0) return bl2;
            bl2 = this.mShiftState == 0;
            this.mShiftState = 1;
            this.mShiftKey.on = false;
            Keyboard.Key key = this.mShiftKey;
            key.icon = drawable3 = this.mShiftIcon;
        }
        return bl2;
    }

    static class LatinKey
    extends Keyboard.Key {
        private boolean mEnabled = true;
        private boolean mShiftLockEnabled;

        public LatinKey(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            super(resources, row, n, n2, xmlResourceParser);
            if (this.popupCharacters == null) {
                return;
            }
            if (this.popupCharacters.length() != 0) {
                return;
            }
            this.popupResId = 0;
        }

        void enableShiftLock() {
            this.mShiftLockEnabled = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isInside(int n, int n2) {
            if (!this.mEnabled) {
                return false;
            }
            int n3 = this.codes[0];
            if (n3 == -1 || n3 == -1) {
                int n4 = this.height / 10;
                n2 -= n4;
                if (n3 == -1) {
                    int n5 = this.width / 6;
                    n += n5;
                }
                if (n3 != -1) return super.isInside(n, n2);
                int n6 = this.width / 6;
                n -= n6;
                return super.isInside(n, n2);
            }
            if (n3 != 32) return super.isInside(n, n2);
            int n7 = sSpacebarVerticalCorrection;
            n2 += n7;
            return super.isInside(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReleased(boolean bl) {
            if (!this.mShiftLockEnabled) {
                super.onReleased(bl);
                return;
            }
            boolean bl2 = !this.pressed;
            this.pressed = bl2;
        }

        void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }
    }
}

