/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.widget.PasswordEntryKeyboard;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener {
    public static final int KEYBOARD_MODE_ALPHA = 0;
    public static final int KEYBOARD_MODE_NUMERIC = 1;
    private static final int KEYBOARD_STATE_CAPSLOCK = 2;
    private static final int KEYBOARD_STATE_NORMAL = 0;
    private static final int KEYBOARD_STATE_SHIFTED = 1;
    private static final String TAG = "PasswordEntryKeyboardHelper";
    private Context mContext;
    private int mKeyboardMode = 0;
    private int mKeyboardState = 0;
    private KeyboardView mKeyboardView;
    private PasswordEntryKeyboard mNumericKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboardShifted;
    private PasswordEntryKeyboard mSymbolsKeyboard;
    private PasswordEntryKeyboard mSymbolsKeyboardShifted;
    private View mTargetView;
    private long[] mVibratePattern;
    private Vibrator mVibrator;

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view) {
        Vibrator vibrator;
        this.mContext = context;
        this.mTargetView = view;
        this.mKeyboardView = keyboardView;
        this.createKeyboards();
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mVibrator = vibrator = new Vibrator();
    }

    private void createKeyboards() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        PasswordEntryKeyboard passwordEntryKeyboard2;
        PasswordEntryKeyboard passwordEntryKeyboard3;
        PasswordEntryKeyboard passwordEntryKeyboard4;
        PasswordEntryKeyboard passwordEntryKeyboard5;
        Context context = this.mContext;
        this.mNumericKeyboard = passwordEntryKeyboard5 = new PasswordEntryKeyboard(context, 17498116);
        Context context2 = this.mContext;
        this.mQwertyKeyboard = passwordEntryKeyboard4 = new PasswordEntryKeyboard(context2, 17498118, 16908851);
        this.mQwertyKeyboard.enableShiftLock();
        Context context3 = this.mContext;
        this.mQwertyKeyboardShifted = passwordEntryKeyboard3 = new PasswordEntryKeyboard(context3, 17498119, 16908851);
        this.mQwertyKeyboardShifted.enableShiftLock();
        boolean bl = this.mQwertyKeyboardShifted.setShifted(true);
        Context context4 = this.mContext;
        this.mSymbolsKeyboard = passwordEntryKeyboard2 = new PasswordEntryKeyboard(context4, 17498120);
        this.mSymbolsKeyboard.enableShiftLock();
        Context context5 = this.mContext;
        this.mSymbolsKeyboardShifted = passwordEntryKeyboard = new PasswordEntryKeyboard(context5, 17498121);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        boolean bl2 = this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private void handleBackspace() {
        this.sendDownUpKeyEvents(67);
    }

    private void handleCharacter(int n, int[] nArray) {
        if (this.mKeyboardView.isShifted() && n != 32 && n != 10) {
            n = Character.toUpperCase(n);
        }
        this.sendKeyEventsToTarget(n);
    }

    private void handleClose() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleModeChange() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        Keyboard keyboard = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard passwordEntryKeyboard2 = null;
        PasswordEntryKeyboard passwordEntryKeyboard3 = this.mQwertyKeyboard;
        if (keyboard == passwordEntryKeyboard3 || keyboard == (passwordEntryKeyboard = this.mQwertyKeyboardShifted)) {
            passwordEntryKeyboard2 = this.mSymbolsKeyboard;
        } else {
            PasswordEntryKeyboard passwordEntryKeyboard4;
            PasswordEntryKeyboard passwordEntryKeyboard5 = this.mSymbolsKeyboard;
            if (keyboard == passwordEntryKeyboard5 || keyboard == (passwordEntryKeyboard4 = this.mSymbolsKeyboardShifted)) {
                passwordEntryKeyboard2 = this.mQwertyKeyboard;
            }
        }
        if (passwordEntryKeyboard2 == null) {
            return;
        }
        this.mKeyboardView.setKeyboard(passwordEntryKeyboard2);
        this.mKeyboardState = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleShift() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        if (this.mKeyboardView == null) {
            return;
        }
        Keyboard keyboard = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard passwordEntryKeyboard2 = null;
        PasswordEntryKeyboard passwordEntryKeyboard3 = this.mQwertyKeyboard;
        boolean bl = keyboard == passwordEntryKeyboard3 || keyboard == (passwordEntryKeyboard = this.mQwertyKeyboardShifted);
        if (this.mKeyboardState == 0) {
            int n = bl ? 1 : 2;
            this.mKeyboardState = n;
            passwordEntryKeyboard2 = bl ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 1) {
            this.mKeyboardState = 2;
            passwordEntryKeyboard2 = bl ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 2) {
            this.mKeyboardState = 0;
            passwordEntryKeyboard2 = bl ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
        }
        if (passwordEntryKeyboard2 == null) {
            return;
        }
        if (passwordEntryKeyboard2 != keyboard) {
            this.mKeyboardView.setKeyboard(passwordEntryKeyboard2);
        }
        boolean bl2 = this.mKeyboardState == 2;
        passwordEntryKeyboard2.setShiftLocked(bl2);
        KeyboardView keyboardView = this.mKeyboardView;
        boolean bl3 = this.mKeyboardState != 0;
        boolean bl4 = keyboardView.setShifted(bl3);
    }

    private void sendKeyEventsToTarget(int n) {
        Handler handler = this.mTargetView.getHandler();
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(3);
        char c = (char)n;
        char[] cArray = new char[]{c};
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(cArray);
        if (keyEventArray == null) {
            return;
        }
        int n2 = keyEventArray.length;
        int n3 = 0;
        while (n3 < n2) {
            KeyEvent keyEvent = keyEventArray[n3];
            int n4 = keyEvent.getFlags() | 2 | 4;
            KeyEvent keyEvent2 = KeyEvent.changeFlags(keyEvent, n4);
            Message message = handler.obtainMessage(1005, keyEvent2);
            boolean bl = handler.sendMessage(message);
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAlpha() {
        if (this.mKeyboardMode != 0) return false;
        return true;
    }

    @Override
    public void onKey(int n, int[] nArray) {
        if (n == -1) {
            this.handleBackspace();
            return;
        }
        if (n == -1) {
            this.handleShift();
            return;
        }
        if (n == -1) {
            this.handleClose();
            return;
        }
        if (n == -1 && this.mKeyboardView != null) {
            this.handleModeChange();
            return;
        }
        this.handleCharacter(n, nArray);
        if (this.mKeyboardState != 1) {
            return;
        }
        this.mKeyboardState = 2;
        this.handleShift();
    }

    @Override
    public void onPress(int n) {
        if (this.mVibratePattern == null) {
            return;
        }
        Vibrator vibrator = this.mVibrator;
        long[] lArray = this.mVibratePattern;
        vibrator.vibrate(lArray, -1);
    }

    @Override
    public void onRelease(int n) {
    }

    @Override
    public void onText(CharSequence charSequence) {
    }

    public void sendDownUpKeyEvents(int n) {
        long l = SystemClock.uptimeMillis();
        Handler handler = this.mTargetView.getHandler();
        long l2 = l;
        int n2 = n;
        KeyEvent keyEvent = new KeyEvent(l, l2, 0, n2, 0, 0, 0, 0, 6);
        Message message = handler.obtainMessage(1011, keyEvent);
        boolean bl = handler.sendMessage(message);
        long l3 = l;
        int n3 = n;
        KeyEvent keyEvent2 = new KeyEvent(l, l3, 1, n3, 0, 0, 0, 0, 6);
        Message message2 = handler.obtainMessage(1011, keyEvent2);
        boolean bl2 = handler.sendMessage(message2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setKeyboardMode(int n) {
        switch (n) {
            case 0: {
                KeyboardView keyboardView = this.mKeyboardView;
                PasswordEntryKeyboard passwordEntryKeyboard = this.mQwertyKeyboard;
                keyboardView.setKeyboard(passwordEntryKeyboard);
                this.mKeyboardState = 0;
                boolean bl = Settings.System.getInt(this.mContext.getContentResolver(), "show_password", 1) != 0;
                this.mKeyboardView.setPreviewEnabled(bl);
            }
            default: {
                break;
            }
            case 1: {
                KeyboardView keyboardView = this.mKeyboardView;
                PasswordEntryKeyboard passwordEntryKeyboard = this.mNumericKeyboard;
                keyboardView.setKeyboard(passwordEntryKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVibratePattern(int n) {
        int[] nArray;
        block5: {
            nArray = null;
            try {
                int[] nArray2;
                nArray = nArray2 = this.mContext.getResources().getIntArray(n);
            }
            catch (Resources.NotFoundException notFoundException) {
                if (n == 0) break block5;
                int n2 = Log.e(TAG, "Vibrate pattern missing", notFoundException);
            }
        }
        if (nArray == null) {
            this.mVibratePattern = null;
            return;
        }
        int n3 = nArray.length;
        this.mVibratePattern = (long[])n3;
        int n4 = 0;
        int n5;
        while (n4 < (n5 = nArray.length)) {
            long l;
            long[] lArray = this.mVibratePattern;
            lArray[n4] = l = (long)nArray[n4];
            ++n4;
        }
        return;
    }

    @Override
    public void swipeDown() {
    }

    @Override
    public void swipeLeft() {
    }

    @Override
    public void swipeRight() {
    }

    @Override
    public void swipeUp() {
    }
}

