/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.InputDevice;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;

public class PointerLocationView
extends View {
    private static final String TAG = "Pointer";
    private int mActivePointerId;
    private boolean mCurDown;
    private int mCurNumPointers;
    private int mHeaderBottom;
    private int mMaxNumPointers;
    private final Paint mPaint;
    private final Paint mPathPaint;
    private final ArrayList<PointerState> mPointers;
    private boolean mPrintCoords;
    private RectF mReusableOvalRect;
    private final Paint mTargetPaint;
    private final FasterStringBuilder mText;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint.FontMetricsInt mTextMetrics;
    private final Paint mTextPaint;
    private final ViewConfiguration mVC;
    private final VelocityTracker mVelocity;

    public PointerLocationView(Context context) {
        super(context);
        VelocityTracker velocityTracker;
        Paint paint;
        Paint paint2;
        Paint paint3;
        Paint paint4;
        Paint paint5;
        Paint paint6;
        ViewConfiguration viewConfiguration;
        RectF rectF;
        FasterStringBuilder fasterStringBuilder;
        Paint.FontMetricsInt fontMetricsInt;
        this.mTextMetrics = fontMetricsInt = new Paint.FontMetricsInt();
        ArrayList arrayList = new ArrayList();
        this.mPointers = arrayList;
        this.mText = fasterStringBuilder = new FasterStringBuilder();
        this.mPrintCoords = true;
        this.mReusableOvalRect = rectF = new RectF();
        this.setFocusable(true);
        this.mVC = viewConfiguration = ViewConfiguration.get(context);
        this.mTextPaint = paint6 = new Paint();
        this.mTextPaint.setAntiAlias(true);
        Paint paint7 = this.mTextPaint;
        float f = this.getResources().getDisplayMetrics().density;
        float f2 = 10.0f * f;
        paint7.setTextSize(f2);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = paint5 = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = paint4 = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = paint3 = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        Paint paint8 = this.mPaint;
        Paint.Style style2 = Paint.Style.STROKE;
        paint8.setStyle(style2);
        this.mPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = paint2 = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = paint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        Paint paint9 = this.mPaint;
        Paint.Style style3 = Paint.Style.STROKE;
        paint9.setStyle(style3);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState pointerState = new PointerState();
        boolean bl = this.mPointers.add(pointerState);
        this.mActivePointerId = 0;
        this.mVelocity = velocityTracker = VelocityTracker.obtain();
        this.logInputDeviceCapabilities();
    }

    private void drawOval(Canvas canvas, float f, float f2, float f3, float f4, float f5, Paint paint) {
        float f6;
        float f7;
        float f8;
        float f9;
        int n = canvas.save(1);
        float f10 = (float)((double)(180.0f * f5) / Math.PI);
        canvas.rotate(f10, f, f2);
        RectF rectF = this.mReusableOvalRect;
        float f11 = f4 / 2.0f;
        rectF.left = f9 = f - f11;
        RectF rectF2 = this.mReusableOvalRect;
        rectF2.right = f8 = f4 / 2.0f + f;
        RectF rectF3 = this.mReusableOvalRect;
        float f12 = f3 / 2.0f;
        rectF3.top = f7 = f2 - f12;
        RectF rectF4 = this.mReusableOvalRect;
        rectF4.bottom = f6 = f3 / 2.0f + f2;
        RectF rectF5 = this.mReusableOvalRect;
        canvas.drawOval(rectF5, paint);
        canvas.restore();
    }

    private void logInputDeviceCapabilities() {
        int[] nArray = InputDevice.getDeviceIds();
        int n = 0;
        int n2;
        while (n < (n2 = nArray.length)) {
            InputDevice inputDevice = InputDevice.getDevice(nArray[n]);
            if (inputDevice != null) {
                String string2 = inputDevice.toString();
                int n3 = Log.i(TAG, string2);
            }
            ++n;
        }
        return;
    }

    private void logPointerCoords(MotionEvent.PointerCoords pointerCoords, int n) {
        FasterStringBuilder fasterStringBuilder = this.mText.clear().append("Pointer ");
        int n2 = n + 1;
        FasterStringBuilder fasterStringBuilder2 = fasterStringBuilder.append(n2).append(": (");
        float f = pointerCoords.x;
        FasterStringBuilder fasterStringBuilder3 = fasterStringBuilder2.append(f, 3).append(", ");
        float f2 = pointerCoords.y;
        FasterStringBuilder fasterStringBuilder4 = fasterStringBuilder3.append(f2, 3).append(") Pressure=");
        float f3 = pointerCoords.pressure;
        FasterStringBuilder fasterStringBuilder5 = fasterStringBuilder4.append(f3, 3).append(" Size=");
        float f4 = pointerCoords.size;
        FasterStringBuilder fasterStringBuilder6 = fasterStringBuilder5.append(f4, 3).append(" TouchMajor=");
        float f5 = pointerCoords.touchMajor;
        FasterStringBuilder fasterStringBuilder7 = fasterStringBuilder6.append(f5, 3).append(" TouchMinor=");
        float f6 = pointerCoords.touchMinor;
        FasterStringBuilder fasterStringBuilder8 = fasterStringBuilder7.append(f6, 3).append(" ToolMajor=");
        float f7 = pointerCoords.toolMajor;
        FasterStringBuilder fasterStringBuilder9 = fasterStringBuilder8.append(f7, 3).append(" ToolMinor=");
        float f8 = pointerCoords.toolMinor;
        FasterStringBuilder fasterStringBuilder10 = fasterStringBuilder9.append(f8, 3).append(" Orientation=");
        float f9 = (float)((double)(pointerCoords.orientation * 180.0f) / Math.PI);
        String string2 = fasterStringBuilder10.append(f9, 1).append("deg").toString();
        int n3 = Log.i(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTouchEvent(MotionEvent motionEvent) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            PointerState pointerState;
            int n;
            int n2;
            int n3 = motionEvent.getAction();
            int n4 = this.mPointers.size();
            if (n3 == 0 || (n3 & 0xFF) == 5) {
                int n5;
                ArrayList<PointerState> arrayList2;
                n2 = (0xFF00 & n3) >> 8;
                if (n3 == 0) {
                    for (int i = 0; i < n4; ++i) {
                        PointerState pointerState2 = this.mPointers.get(i);
                        pointerState2.clearTrace();
                        boolean bl = PointerState.access$102(pointerState2, false);
                    }
                    this.mCurDown = true;
                    this.mMaxNumPointers = 0;
                    this.mVelocity.clear();
                }
                n = motionEvent.getPointerId(n2);
                while (n4 <= n) {
                    PointerState pointerState3 = new PointerState();
                    boolean bl = this.mPointers.add(pointerState3);
                    ++n4;
                }
                if (this.mActivePointerId < 0 || !(arrayList2 = this.mPointers).get(n5 = this.mActivePointerId).mCurDown) {
                    this.mActivePointerId = n;
                }
                boolean bl = PointerState.access$102(this.mPointers.get(n), true);
                if (this.mPrintCoords) {
                    FasterStringBuilder fasterStringBuilder = this.mText.clear().append("Pointer ");
                    int n6 = n + 1;
                    String string2 = fasterStringBuilder.append(n6).append(": DOWN").toString();
                    int n7 = Log.i(TAG, string2);
                }
            }
            int n8 = motionEvent.getPointerCount();
            int n9 = n3 != 1 && n3 != 3 ? 1 : 0;
            this.mCurDown = n9;
            n9 = this.mCurDown ? n8 : 0;
            this.mCurNumPointers = n9;
            int n10 = this.mMaxNumPointers;
            int n11 = this.mCurNumPointers;
            if (n10 < n11) {
                int n12;
                this.mMaxNumPointers = n12 = this.mCurNumPointers;
            }
            this.mVelocity.addMovement(motionEvent);
            this.mVelocity.computeCurrentVelocity(1);
            for (int i = 0; i < n8; ++i) {
                n = motionEvent.getPointerId(i);
                pointerState = this.mPointers.get(n);
                int n13 = motionEvent.getHistorySize();
                for (int j = 0; j < n13; ++j) {
                    MotionEvent.PointerCoords pointerCoords = pointerState.mCoords;
                    motionEvent.getHistoricalPointerCoords(i, j, pointerCoords);
                    if (this.mPrintCoords) {
                        MotionEvent.PointerCoords pointerCoords2 = pointerState.mCoords;
                        this.logPointerCoords(pointerCoords2, n);
                    }
                    float f = motionEvent.getHistoricalX(i, j);
                    float f2 = motionEvent.getHistoricalY(i, j);
                    pointerState.addTrace(f, f2);
                }
                MotionEvent.PointerCoords pointerCoords = pointerState.mCoords;
                motionEvent.getPointerCoords(i, pointerCoords);
                if (this.mPrintCoords) {
                    MotionEvent.PointerCoords pointerCoords3 = pointerState.mCoords;
                    this.logPointerCoords(pointerCoords3, n);
                }
                float f = ((PointerState)pointerState).mCoords.x;
                float f3 = ((PointerState)pointerState).mCoords.y;
                pointerState.addTrace(f, f3);
                float f4 = this.mVelocity.getXVelocity(n);
                float f5 = PointerState.access$502(pointerState, f4);
                float f6 = this.mVelocity.getYVelocity(n);
                float f7 = PointerState.access$602(pointerState, f6);
            }
            if (n3 == 1 || n3 == 3 || (n3 & 0xFF) == 6) {
                n2 = (0xFF00 & n3) >> 8;
                n = motionEvent.getPointerId(n2);
                pointerState = this.mPointers.get(n);
                boolean bl = PointerState.access$102(pointerState, false);
                if (this.mPrintCoords) {
                    FasterStringBuilder fasterStringBuilder = this.mText.clear().append("Pointer ");
                    int n14 = n + 1;
                    String string3 = fasterStringBuilder.append(n14).append(": UP").toString();
                    int n15 = Log.i(TAG, string3);
                }
                if (n3 == 1 || n3 == 3) {
                    this.mCurDown = false;
                } else {
                    if (this.mActivePointerId != n) {
                        int n16;
                        n9 = n2 == 0 ? 1 : 0;
                        this.mActivePointerId = n16 = motionEvent.getPointerId(n9);
                    }
                    pointerState.addTrace(Float.NaN, Float.NaN);
                }
            }
            this.postInvalidate();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onDraw(Canvas canvas) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            float f;
            float f2;
            int n;
            float f3;
            int n2;
            PointerState pointerState;
            int n3 = this.getWidth();
            int n4 = n3 / 7;
            int n5 = -this.mTextMetrics.ascent + 1;
            int n6 = this.mHeaderBottom;
            int n7 = this.mPointers.size();
            if (this.mActivePointerId >= 0) {
                ArrayList<PointerState> arrayList2 = this.mPointers;
                int n8 = this.mActivePointerId;
                pointerState = arrayList2.get(n8);
                float f4 = n4 - 1;
                float f5 = n6;
                Paint paint = this.mTextBackgroundPaint;
                canvas.drawRect(0.0f, 0.0f, f4, f5, paint);
                FasterStringBuilder fasterStringBuilder = this.mText.clear().append("P: ");
                int n9 = this.mCurNumPointers;
                FasterStringBuilder fasterStringBuilder2 = fasterStringBuilder.append(n9).append(" / ");
                int n10 = this.mMaxNumPointers;
                String string2 = fasterStringBuilder2.append(n10).toString();
                float f6 = n5;
                Paint paint2 = this.mTextPaint;
                Canvas canvas2 = canvas;
                String string3 = string2;
                float f7 = 1.0f;
                float f8 = f6;
                Paint paint3 = paint2;
                canvas2.drawText(string3, f7, f8, paint3);
                n2 = pointerState.mTraceCount;
                if (this.mCurDown && pointerState.mCurDown || n2 == 0) {
                    float f9 = n4;
                    float f10 = n4 * 2 - 1;
                    float f11 = n6;
                    Paint paint4 = this.mTextBackgroundPaint;
                    canvas.drawRect(f9, 0.0f, f10, f11, paint4);
                    FasterStringBuilder fasterStringBuilder3 = this.mText.clear().append("X: ");
                    float f12 = ((PointerState)pointerState).mCoords.x;
                    String string4 = fasterStringBuilder3.append(f12, 1).toString();
                    float f13 = n4 + 1;
                    float f14 = n5;
                    Paint paint5 = this.mTextPaint;
                    Canvas canvas3 = canvas;
                    String string5 = string4;
                    float f15 = f13;
                    float f16 = f14;
                    Paint paint6 = paint5;
                    canvas3.drawText(string5, f15, f16, paint6);
                    float f17 = n4 * 2;
                    float f18 = n4 * 3 - 1;
                    float f19 = n6;
                    Paint paint7 = this.mTextBackgroundPaint;
                    canvas.drawRect(f17, 0.0f, f18, f19, paint7);
                    FasterStringBuilder fasterStringBuilder4 = this.mText.clear().append("Y: ");
                    float f20 = ((PointerState)pointerState).mCoords.y;
                    String string6 = fasterStringBuilder4.append(f20, 1).toString();
                    float f21 = n4 * 2 + 1;
                    float f22 = n5;
                    Paint paint8 = this.mTextPaint;
                    Canvas canvas4 = canvas;
                    String string7 = string6;
                    float f23 = f21;
                    float f24 = f22;
                    Paint paint9 = paint8;
                    canvas4.drawText(string7, f23, f24, paint9);
                } else {
                    float f25;
                    float[] fArray = pointerState.mTraceX;
                    int n11 = n2 - 1;
                    float f26 = fArray[n11];
                    float f27 = pointerState.mTraceX[0];
                    float f28 = f26 - f27;
                    float[] fArray2 = pointerState.mTraceY;
                    int n12 = n2 - 1;
                    float f29 = fArray2[n12];
                    float f30 = pointerState.mTraceY[0];
                    float f31 = f29 - f30;
                    f3 = n4;
                    n = 0;
                    f2 = n4 * 2 - 1;
                    f = n6;
                    float f32 = Math.abs(f28);
                    Paint paint10 = f32 < (f25 = (float)this.mVC.getScaledTouchSlop()) ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                    canvas.drawRect(f3, n, f2, f, paint10);
                    FasterStringBuilder fasterStringBuilder5 = this.mText.clear().append("dX: ");
                    float f33 = f28;
                    int n13 = 1;
                    String string8 = fasterStringBuilder5.append(f33, n13).toString();
                    float f34 = n4 + 1;
                    float f35 = n5;
                    Paint paint11 = this.mTextPaint;
                    Canvas canvas5 = canvas;
                    String string9 = string8;
                    float f36 = f34;
                    float f37 = f35;
                    Paint paint12 = paint11;
                    canvas5.drawText(string9, f36, f37, paint12);
                    f3 = n4 * 2;
                    n = 0;
                    f2 = n4 * 3 - 1;
                    f = n6;
                    float f38 = Math.abs(f31);
                    float f39 = this.mVC.getScaledTouchSlop();
                    paint10 = f38 < f39 ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                    canvas.drawRect(f3, n, f2, f, paint10);
                    FasterStringBuilder fasterStringBuilder6 = this.mText.clear().append("dY: ");
                    float f40 = f31;
                    int n14 = 1;
                    String string10 = fasterStringBuilder6.append(f40, n14).toString();
                    float f41 = n4 * 2 + 1;
                    float f42 = n5;
                    Paint paint13 = this.mTextPaint;
                    Canvas canvas6 = canvas;
                    String string11 = string10;
                    float f43 = f41;
                    float f44 = f42;
                    Paint paint14 = paint13;
                    canvas6.drawText(string11, f43, f44, paint14);
                }
                float f45 = n4 * 3;
                float f46 = n4 * 4 - 1;
                float f47 = n6;
                Paint paint15 = this.mTextBackgroundPaint;
                canvas.drawRect(f45, 0.0f, f46, f47, paint15);
                FasterStringBuilder fasterStringBuilder7 = this.mText.clear().append("Xv: ");
                float f48 = pointerState.mXVelocity;
                String string12 = fasterStringBuilder7.append(f48, 3).toString();
                float f49 = n4 * 3 + 1;
                float f50 = n5;
                Paint paint16 = this.mTextPaint;
                Canvas canvas7 = canvas;
                String string13 = string12;
                float f51 = f49;
                float f52 = f50;
                Paint paint17 = paint16;
                canvas7.drawText(string13, f51, f52, paint17);
                float f53 = n4 * 4;
                float f54 = n4 * 5 - 1;
                float f55 = n6;
                Paint paint18 = this.mTextBackgroundPaint;
                canvas.drawRect(f53, 0.0f, f54, f55, paint18);
                FasterStringBuilder fasterStringBuilder8 = this.mText.clear().append("Yv: ");
                float f56 = pointerState.mYVelocity;
                String string14 = fasterStringBuilder8.append(f56, 3).toString();
                float f57 = n4 * 4 + 1;
                float f58 = n5;
                Paint paint19 = this.mTextPaint;
                Canvas canvas8 = canvas;
                String string15 = string14;
                float f59 = f57;
                float f60 = f58;
                Paint paint20 = paint19;
                canvas8.drawText(string15, f59, f60, paint20);
                float f61 = n4 * 5;
                float f62 = n4 * 6 - 1;
                float f63 = n6;
                Paint paint21 = this.mTextBackgroundPaint;
                canvas.drawRect(f61, 0.0f, f62, f63, paint21);
                float f64 = n4 * 5;
                float f65 = n4 * 5;
                float f66 = ((PointerState)pointerState).mCoords.pressure;
                float f67 = n4;
                float f68 = f66 * f67;
                float f69 = f65 + f68 - 1.0f;
                float f70 = n6;
                Paint paint22 = this.mTextLevelPaint;
                canvas.drawRect(f64, 0.0f, f69, f70, paint22);
                FasterStringBuilder fasterStringBuilder9 = this.mText.clear().append("Prs: ");
                float f71 = ((PointerState)pointerState).mCoords.pressure;
                String string16 = fasterStringBuilder9.append(f71, 2).toString();
                float f72 = n4 * 5 + 1;
                float f73 = n5;
                Paint paint23 = this.mTextPaint;
                Canvas canvas9 = canvas;
                String string17 = string16;
                float f74 = f72;
                float f75 = f73;
                Paint paint24 = paint23;
                canvas9.drawText(string17, f74, f75, paint24);
                float f76 = n4 * 6;
                float f77 = n3;
                float f78 = n6;
                Paint paint25 = this.mTextBackgroundPaint;
                canvas.drawRect(f76, 0.0f, f77, f78, paint25);
                float f79 = n4 * 6;
                float f80 = n4 * 6;
                float f81 = ((PointerState)pointerState).mCoords.size;
                float f82 = n4;
                float f83 = f81 * f82;
                float f84 = f80 + f83 - 1.0f;
                float f85 = n6;
                Paint paint26 = this.mTextLevelPaint;
                canvas.drawRect(f79, 0.0f, f84, f85, paint26);
                FasterStringBuilder fasterStringBuilder10 = this.mText.clear().append("Size: ");
                float f86 = ((PointerState)pointerState).mCoords.size;
                String string18 = fasterStringBuilder10.append(f86, 2).toString();
                float f87 = n4 * 6 + 1;
                float f88 = n5;
                Paint paint27 = this.mTextPaint;
                Canvas canvas10 = canvas;
                String string19 = string18;
                float f89 = f87;
                float f90 = f88;
                Paint paint28 = paint27;
                canvas10.drawText(string19, f89, f90, paint28);
            }
            int n15 = 0;
            int n16;
            int n17;
            while ((n17 = ++n15) < (n16 = n7)) {
                int n18;
                int n19;
                ArrayList<PointerState> arrayList3 = this.mPointers;
                int n20 = n15;
                pointerState = arrayList3.get(n20);
                n2 = pointerState.mTraceCount;
                f3 = 0.0f;
                n = 0;
                boolean bl = false;
                boolean bl2 = false;
                this.mPaint.setARGB(255, 128, 255, 255);
                int n21 = 0;
                while ((n19 = ++n21) < (n18 = n2)) {
                    f2 = pointerState.mTraceX[n21];
                    f = pointerState.mTraceY[n21];
                    if (Float.isNaN(f2)) {
                        bl = false;
                        continue;
                    }
                    if (bl) {
                        Paint paint = this.mPathPaint;
                        canvas.drawLine(f3, n, f2, f, paint);
                        Paint paint29 = this.mPaint;
                        Canvas canvas11 = canvas;
                        float f91 = f3;
                        int n22 = n;
                        Paint paint30 = paint29;
                        canvas11.drawPoint(f91, n22, paint30);
                        bl2 = true;
                    }
                    f3 = f2;
                    float f92 = f;
                    bl = true;
                }
                if (bl2) {
                    this.mPaint.setARGB(255, 255, 64, 128);
                    float f93 = pointerState.mXVelocity * 16.0f;
                    float f94 = pointerState.mYVelocity * 16.0f;
                    float f95 = f3 + f93;
                    int n23 = n + f94;
                    Paint paint = this.mPaint;
                    Canvas canvas12 = canvas;
                    float f96 = f3;
                    int n24 = n;
                    canvas12.drawLine(f96, n24, f95, n23, paint);
                }
                if (!this.mCurDown || !pointerState.mCurDown) continue;
                float f97 = ((PointerState)pointerState).mCoords.y;
                float f98 = this.getWidth();
                float f99 = ((PointerState)pointerState).mCoords.y;
                Paint paint = this.mTargetPaint;
                canvas.drawLine(0.0f, f97, f98, f99, paint);
                float f100 = ((PointerState)pointerState).mCoords.x;
                float f101 = ((PointerState)pointerState).mCoords.x;
                float f102 = this.getHeight();
                Paint paint31 = this.mTargetPaint;
                canvas.drawLine(f100, 0.0f, f101, f102, paint31);
                int n25 = (int)(((PointerState)pointerState).mCoords.pressure * 255.0f);
                Paint paint32 = this.mPaint;
                int n26 = 255 - n25;
                Paint paint33 = paint32;
                int n27 = 255;
                int n28 = n25;
                int n29 = 255;
                int n30 = n26;
                paint33.setARGB(n27, n28, n29, n30);
                float f103 = ((PointerState)pointerState).mCoords.x;
                float f104 = ((PointerState)pointerState).mCoords.y;
                Paint paint34 = this.mPaint;
                Canvas canvas13 = canvas;
                float f105 = f103;
                float f106 = f104;
                Paint paint35 = paint34;
                canvas13.drawPoint(f105, f106, paint35);
                Paint paint36 = this.mPaint;
                int n31 = 255 - n25;
                Paint paint37 = paint36;
                int n32 = 255;
                int n33 = n25;
                int n34 = n31;
                int n35 = 128;
                paint37.setARGB(n32, n33, n34, n35);
                float f107 = ((PointerState)pointerState).mCoords.x;
                float f108 = ((PointerState)pointerState).mCoords.y;
                float f109 = ((PointerState)pointerState).mCoords.touchMajor;
                float f110 = ((PointerState)pointerState).mCoords.touchMinor;
                float f111 = ((PointerState)pointerState).mCoords.orientation;
                Paint paint38 = this.mPaint;
                PointerLocationView pointerLocationView = this;
                Canvas canvas14 = canvas;
                pointerLocationView.drawOval(canvas14, f107, f108, f109, f110, f111, paint38);
                Paint paint39 = this.mPaint;
                int n36 = 255 - n25;
                Paint paint40 = paint39;
                int n37 = 255;
                int n38 = n25;
                int n39 = 128;
                int n40 = n36;
                paint40.setARGB(n37, n38, n39, n40);
                float f112 = ((PointerState)pointerState).mCoords.x;
                float f113 = ((PointerState)pointerState).mCoords.y;
                float f114 = ((PointerState)pointerState).mCoords.toolMajor;
                float f115 = ((PointerState)pointerState).mCoords.toolMinor;
                float f116 = ((PointerState)pointerState).mCoords.orientation;
                Paint paint41 = this.mPaint;
                PointerLocationView pointerLocationView2 = this;
                Canvas canvas15 = canvas;
                pointerLocationView2.drawOval(canvas15, f112, f113, f114, f115, f116, paint41);
            }
            return;
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        super.onMeasure(n, n2);
        Paint paint = this.mTextPaint;
        Paint.FontMetricsInt fontMetricsInt = this.mTextMetrics;
        int n4 = paint.getFontMetricsInt(fontMetricsInt);
        int n5 = -this.mTextMetrics.ascent;
        int n6 = this.mTextMetrics.descent;
        this.mHeaderBottom = n3 = n5 + n6 + 2;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.addTouchEvent(motionEvent);
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        String string2 = "Trackball: " + motionEvent;
        int n = Log.i(TAG, string2);
        return super.onTrackballEvent(motionEvent);
    }

    public void setPrintCoords(boolean bl) {
        this.mPrintCoords = bl;
    }

    private static final class FasterStringBuilder {
        private char[] mChars;
        private int mLength;

        public FasterStringBuilder() {
            char[] cArray = new char[64];
            this.mChars = cArray;
        }

        private int reserve(int n) {
            int n2 = this.mLength;
            int n3 = this.mLength + n;
            char[] cArray = this.mChars;
            int n4 = cArray.length;
            if (n3 > n4) {
                char[] cArray2 = new char[n4 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                this.mChars = cArray2;
            }
            return n2;
        }

        public FasterStringBuilder append(float f, int n) {
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                n2 *= 10;
            }
            double d = Math.rint((float)n2 * f);
            double d2 = n2;
            float f2 = (float)(d / d2);
            int n3 = (int)f2;
            FasterStringBuilder fasterStringBuilder = this.append(n3);
            if (n != 0) {
                FasterStringBuilder fasterStringBuilder2 = this.append(".");
                float f3 = Math.abs(f2);
                double d3 = f3;
                double d4 = Math.floor(f3);
                float f4 = (float)(d3 - d4);
                int n4 = (int)((float)n2 * f4);
                FasterStringBuilder fasterStringBuilder3 = this.append(n4, n);
            }
            return this;
        }

        public FasterStringBuilder append(int n) {
            return this.append(n, 0);
        }

        /*
         * Enabled aggressive block sorting
         */
        public FasterStringBuilder append(int n, int n2) {
            int n3;
            int n4;
            boolean bl = n < 0;
            if (bl && (n = -n) < 0) {
                FasterStringBuilder fasterStringBuilder = this.append("-2147483648");
                return this;
            }
            int n5 = this.reserve(11);
            char[] cArray = this.mChars;
            if (n == 0) {
                int n6;
                int n7 = n5 + 1;
                cArray[n5] = 48;
                this.mLength = n6 = this.mLength + 1;
                return this;
            }
            if (bl) {
                int n8 = n5 + 1;
                cArray[n5] = 45;
                n5 = n8;
            }
            int n9 = 10;
            int n10 = n5;
            for (n4 = 1000000000; n < n4; n4 /= 10) {
                if ((n9 += -1) >= n2) continue;
                int n11 = n10 + 1;
                cArray[n10] = 48;
                n10 = n11;
            }
            do {
                char c;
                int n12 = n10;
                int n13 = n / n4;
                int n14 = n13 * n4;
                n -= n14;
                n3 = n12 + 1;
                cArray[n12] = c = (char)(n13 + 48);
            } while ((n4 /= 10) != 0);
            this.mLength = n3;
            return this;
        }

        public FasterStringBuilder append(String string2) {
            int n;
            int n2 = string2.length();
            int n3 = this.reserve(n2);
            char[] cArray = this.mChars;
            string2.getChars(0, n2, cArray, n3);
            this.mLength = n = this.mLength + n2;
            return this;
        }

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public String toString() {
            char[] cArray = this.mChars;
            int n = this.mLength;
            return new String(cArray, 0, n);
        }
    }

    public static class PointerState {
        private MotionEvent.PointerCoords mCoords;
        private boolean mCurDown;
        private int mTraceCount;
        private float[] mTraceX;
        private float[] mTraceY;
        private float mXVelocity;
        private float mYVelocity;

        public PointerState() {
            MotionEvent.PointerCoords pointerCoords;
            float[] fArray = new float[32];
            this.mTraceX = fArray;
            float[] fArray2 = new float[32];
            this.mTraceY = fArray2;
            this.mCoords = pointerCoords = new MotionEvent.PointerCoords();
        }

        static /* synthetic */ boolean access$102(PointerState pointerState, boolean bl) {
            pointerState.mCurDown = bl;
            return bl;
        }

        static /* synthetic */ float access$502(PointerState pointerState, float f) {
            pointerState.mXVelocity = f;
            return f;
        }

        static /* synthetic */ float access$602(PointerState pointerState, float f) {
            pointerState.mYVelocity = f;
            return f;
        }

        public void addTrace(float f, float f2) {
            int n;
            int n2 = this.mTraceX.length;
            if (this.mTraceCount != n2) {
                int n3 = n2 * 2;
                float[] fArray = new float[n3];
                float[] fArray2 = this.mTraceX;
                int n4 = this.mTraceCount;
                System.arraycopy(fArray2, 0, fArray, 0, n4);
                this.mTraceX = fArray;
                float[] fArray3 = new float[n3];
                float[] fArray4 = this.mTraceY;
                int n5 = this.mTraceCount;
                System.arraycopy(fArray4, 0, fArray3, 0, n5);
                this.mTraceY = fArray3;
            }
            float[] fArray = this.mTraceX;
            int n6 = this.mTraceCount;
            fArray[n6] = f;
            float[] fArray5 = this.mTraceY;
            int n7 = this.mTraceCount;
            fArray5[n7] = f2;
            this.mTraceCount = n = this.mTraceCount + 1;
        }

        public void clearTrace() {
            this.mTraceCount = 0;
        }
    }
}

