/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.R;

public class RotarySelector
extends View {
    private static final int ARROW_SCRUNCH_DIP = 6;
    private static final boolean DBG = false;
    private static final int EDGE_PADDING_DIP = 9;
    private static final int EDGE_TRIGGER_DIP = 100;
    public static final int HORIZONTAL = 0;
    public static final int LEFT_HANDLE_GRABBED = 1;
    private static final String LOG_TAG = "RotarySelector";
    public static final int NOTHING_GRABBED = 0;
    static final int OUTER_ROTARY_RADIUS_DIP = 390;
    public static final int RIGHT_HANDLE_GRABBED = 2;
    static final int ROTARY_STROKE_WIDTH_DIP = 83;
    static final int SNAP_BACK_ANIMATION_DURATION_MILLIS = 300;
    static final int SPIN_ANIMATION_DURATION_MILLIS = 800;
    public static final int VERTICAL = 1;
    private static final long VIBRATE_LONG = 20L;
    private static final long VIBRATE_SHORT = 20L;
    private static final boolean VISUAL_DEBUG;
    private boolean mAnimating = false;
    private int mAnimatingDeltaXEnd;
    private int mAnimatingDeltaXStart;
    private long mAnimationDuration;
    private long mAnimationStartTime;
    private Bitmap mArrowLongLeft;
    private Bitmap mArrowLongRight;
    final Matrix mArrowMatrix;
    private Bitmap mArrowShortLeftAndRight;
    private Bitmap mBackground;
    private int mBackgroundHeight;
    private int mBackgroundWidth;
    final Matrix mBgMatrix;
    private float mDensity;
    private Bitmap mDimple;
    private Bitmap mDimpleDim;
    private int mDimpleSpacing;
    private int mDimpleWidth;
    private int mDimplesOfFling;
    private int mEdgeTriggerThresh;
    private int mGrabbedState;
    private final int mInnerRadius;
    private DecelerateInterpolator mInterpolator;
    private Bitmap mLeftHandleIcon;
    private int mLeftHandleX;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private OnDialTriggerListener mOnDialTriggerListener;
    private int mOrientation;
    private final int mOuterRadius;
    private Paint mPaint;
    private Bitmap mRightHandleIcon;
    private int mRightHandleX;
    private int mRotaryOffsetX = 0;
    private boolean mTriggered;
    private VelocityTracker mVelocityTracker;
    private Vibrator mVibrator;

    public RotarySelector(Context context) {
        this(context, null);
    }

    public RotarySelector(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        DecelerateInterpolator decelerateInterpolator;
        Bitmap bitmap;
        Bitmap bitmap2;
        Bitmap bitmap3;
        Bitmap bitmap4;
        Bitmap bitmap5;
        Bitmap bitmap6;
        float f;
        int n9;
        Matrix matrix;
        Matrix matrix2;
        Paint paint;
        this.mPaint = paint = new Paint();
        this.mBgMatrix = matrix2 = new Matrix();
        this.mArrowMatrix = matrix = new Matrix();
        this.mGrabbedState = 0;
        this.mTriggered = false;
        this.mDimplesOfFling = 0;
        int[] nArray = R.styleable.RotarySelector;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mOrientation = n9 = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mDensity = f = this.getResources().getDisplayMetrics().density;
        this.mBackground = bitmap6 = this.getBitmapFor(17301990);
        this.mDimple = bitmap5 = this.getBitmapFor(17301991);
        this.mDimpleDim = bitmap4 = this.getBitmapFor(17301992);
        this.mArrowLongLeft = bitmap3 = this.getBitmapFor(17301982);
        this.mArrowLongRight = bitmap2 = this.getBitmapFor(17301985);
        this.mArrowShortLeftAndRight = bitmap = this.getBitmapFor(17301988);
        this.mInterpolator = decelerateInterpolator = new DecelerateInterpolator(1.0f);
        this.mEdgeTriggerThresh = n8 = (int)(this.mDensity * 100.0f);
        this.mDimpleWidth = n7 = this.mDimple.getWidth();
        this.mBackgroundWidth = n6 = this.mBackground.getWidth();
        this.mBackgroundHeight = n5 = this.mBackground.getHeight();
        this.mOuterRadius = n4 = (int)(this.mDensity * 390.0f);
        float f2 = this.mDensity;
        this.mInnerRadius = n3 = (int)(307.0f * f2);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mMinimumVelocity = n2 = viewConfiguration.getScaledMinimumFlingVelocity() * 2;
        this.mMaximumVelocity = n = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate(20L);
        if (this.mOnDialTriggerListener == null) {
            return;
        }
        this.mOnDialTriggerListener.onDialTrigger(this, n);
    }

    private void drawCentered(Bitmap bitmap, Canvas canvas, int n, int n2) {
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = n3 / 2;
        float f = n - n5;
        int n6 = n4 / 2;
        float f2 = n2 - n6;
        Paint paint = this.mPaint;
        canvas.drawBitmap(bitmap, f, f2, paint);
    }

    private Bitmap getBitmapFor(int n) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), n);
    }

    private int getYOnArc(int n, int n2, int n3, int n4) {
        int n5 = (n3 - n2) / 2;
        int n6 = n2 + n5;
        int n7 = n / 2 - n4;
        int n8 = n6 * n6;
        int n9 = n7 * n7;
        int n10 = (int)Math.sqrt(n8 - n9);
        return n6 - n10 + n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHoriz() {
        if (this.mOrientation != 0) return false;
        return true;
    }

    private void log(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    private void reset() {
        this.mAnimating = false;
        this.mRotaryOffsetX = 0;
        this.mDimplesOfFling = 0;
        this.setGrabbedState(0);
        this.mTriggered = false;
    }

    private void setGrabbedState(int n) {
        int n2 = this.mGrabbedState;
        if (n != n2) {
            return;
        }
        this.mGrabbedState = n;
        if (this.mOnDialTriggerListener == null) {
            return;
        }
        OnDialTriggerListener onDialTriggerListener = this.mOnDialTriggerListener;
        int n3 = this.mGrabbedState;
        onDialTriggerListener.onGrabbedStateChange(this, n3);
    }

    private void startAnimation(int n, int n2, int n3) {
        long l;
        long l2;
        this.mAnimating = true;
        this.mAnimationStartTime = l2 = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = l = (long)n3;
        this.mAnimatingDeltaXStart = n;
        this.mAnimatingDeltaXEnd = n2;
        this.setGrabbedState(0);
        this.mDimplesOfFling = 0;
        this.invalidate();
    }

    private void startAnimationWithVelocity(int n, int n2, int n3) {
        long l;
        long l2;
        this.mAnimating = true;
        this.mAnimationStartTime = l2 = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = l = (long)((n2 - n) * 1000 / n3);
        this.mAnimatingDeltaXStart = n;
        this.mAnimatingDeltaXEnd = n2;
        this.setGrabbedState(0);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAnimation() {
        int n;
        long l = AnimationUtils.currentAnimationTimeMillis();
        long l2 = this.mAnimationStartTime;
        long l3 = l - l2;
        long l4 = this.mAnimationDuration - l3;
        int n2 = this.mAnimatingDeltaXStart;
        int n3 = this.mAnimatingDeltaXEnd;
        int n4 = n2 - n3;
        boolean bl = n4 < 0;
        if (l4 <= 0L) {
            this.reset();
            return;
        }
        DecelerateInterpolator decelerateInterpolator = this.mInterpolator;
        float f = l3;
        float f2 = this.mAnimationDuration;
        float f3 = f / f2;
        float f4 = decelerateInterpolator.getInterpolation(f3);
        float f5 = n4;
        float f6 = 1.0f - f4;
        int n5 = (int)(f5 * f6);
        this.mRotaryOffsetX = n = this.mAnimatingDeltaXEnd + n5;
        if (this.mDimplesOfFling > 0) {
            int n6;
            int n7;
            int n8;
            int n9;
            if (!bl && (n9 = this.mRotaryOffsetX) < (n8 = this.mDimpleSpacing * -3)) {
                int n10;
                int n11 = this.mRotaryOffsetX;
                int n12 = this.mDimplesOfFling;
                int n13 = this.mDimpleSpacing;
                int n14 = n12 * n13;
                this.mRotaryOffsetX = n10 = n11 + n14;
            } else if (bl && (n7 = this.mRotaryOffsetX) > (n6 = this.mDimpleSpacing * 3)) {
                int n15;
                int n16 = this.mRotaryOffsetX;
                int n17 = this.mDimplesOfFling;
                int n18 = this.mDimpleSpacing;
                int n19 = n17 * n18;
                this.mRotaryOffsetX = n15 = n16 - n19;
            }
        }
        this.invalidate();
    }

    private void vibrate(long l) {
        synchronized (this) {
            if (this.mVibrator == null) {
                Vibrator vibrator;
                this.mVibrator = vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        int n2;
        int n3;
        int n4;
        super.onDraw(canvas);
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (this.mAnimating) {
            this.updateAnimation();
        }
        Bitmap bitmap = this.mBackground;
        Matrix matrix = this.mBgMatrix;
        Paint paint = this.mPaint;
        Canvas canvas2 = canvas;
        Bitmap bitmap2 = bitmap;
        Matrix matrix2 = matrix;
        Paint paint2 = paint;
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        this.mArrowMatrix.reset();
        switch (this.mGrabbedState) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("invalid mGrabbedState: ");
                int n7 = this.mGrabbedState;
                String string2 = stringBuilder.append(n7).toString();
                throw new IllegalStateException(string2);
            }
            case 1: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    boolean bl = this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    Matrix matrix3 = this.mArrowMatrix;
                    float f = n6;
                    boolean bl2 = matrix3.postTranslate(0.0f, f);
                }
                Bitmap bitmap3 = this.mArrowLongLeft;
                Matrix matrix4 = this.mArrowMatrix;
                Paint paint3 = this.mPaint;
                Canvas canvas3 = canvas;
                Bitmap bitmap4 = bitmap3;
                Matrix matrix5 = matrix4;
                Paint paint4 = paint3;
                canvas3.drawBitmap(bitmap4, matrix5, paint4);
                break;
            }
            case 2: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    boolean bl = this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    Matrix matrix6 = this.mArrowMatrix;
                    float f = this.mBackgroundWidth - n6 + n6;
                    boolean bl3 = matrix6.postTranslate(0.0f, f);
                }
                Bitmap bitmap5 = this.mArrowLongRight;
                Matrix matrix7 = this.mArrowMatrix;
                Paint paint5 = this.mPaint;
                Canvas canvas4 = canvas;
                Bitmap bitmap6 = bitmap5;
                Matrix matrix8 = matrix7;
                Paint paint6 = paint5;
                canvas4.drawBitmap(bitmap6, matrix8, paint6);
            }
            case 0: 
        }
        int n8 = this.mBackgroundHeight;
        int n9 = this.isHoriz() ? n6 - n8 : n5 - n8;
        int n10 = this.mLeftHandleX;
        int n11 = this.mRotaryOffsetX;
        int n12 = n10 + n11;
        int n13 = this.mBackgroundWidth;
        int n14 = this.mInnerRadius;
        int n15 = this.mOuterRadius;
        RotarySelector rotarySelector = this;
        int n16 = n13;
        int n17 = n14;
        int n18 = n15;
        int n19 = n12;
        int n20 = rotarySelector.getYOnArc(n16, n17, n18, n19);
        int n21 = this.isHoriz() ? n12 : n20 + n9;
        int n22 = this.isHoriz() ? n20 + n9 : n6 - n12;
        int n23 = this.mGrabbedState;
        int n24 = 2;
        if (n23 != n24) {
            Bitmap bitmap7 = this.mDimple;
            RotarySelector rotarySelector2 = this;
            Bitmap bitmap8 = bitmap7;
            Canvas canvas5 = canvas;
            int n25 = n21;
            int n26 = n22;
            rotarySelector2.drawCentered(bitmap8, canvas5, n25, n26);
            Bitmap bitmap9 = this.mLeftHandleIcon;
            RotarySelector rotarySelector3 = this;
            Bitmap bitmap10 = bitmap9;
            Canvas canvas6 = canvas;
            int n27 = n21;
            int n28 = n22;
            rotarySelector3.drawCentered(bitmap10, canvas6, n27, n28);
        } else {
            Bitmap bitmap11 = this.mDimpleDim;
            RotarySelector rotarySelector4 = this;
            Bitmap bitmap12 = bitmap11;
            Canvas canvas7 = canvas;
            int n29 = n21;
            int n30 = n22;
            rotarySelector4.drawCentered(bitmap12, canvas7, n29, n30);
        }
        if (this.isHoriz()) {
            int n31 = n5 / 2;
            int n32 = this.mRotaryOffsetX;
            n4 = n31 + n32;
        } else {
            int n33 = n6 / 2;
            int n34 = this.mRotaryOffsetX;
            n4 = n33 + n34;
        }
        int n35 = this.mBackgroundWidth;
        int n36 = this.mInnerRadius;
        int n37 = this.mOuterRadius;
        RotarySelector rotarySelector5 = this;
        int n38 = n35;
        int n39 = n36;
        int n40 = n37;
        int n41 = n4;
        int n42 = rotarySelector5.getYOnArc(n38, n39, n40, n41);
        if (this.isHoriz()) {
            Bitmap bitmap13 = this.mDimpleDim;
            int n43 = n42 + n9;
            RotarySelector rotarySelector6 = this;
            Bitmap bitmap14 = bitmap13;
            Canvas canvas8 = canvas;
            int n44 = n4;
            int n45 = n43;
            rotarySelector6.drawCentered(bitmap14, canvas8, n44, n45);
        } else {
            Bitmap bitmap15 = this.mDimpleDim;
            int n46 = n42 + n9;
            int n47 = n6 - n4;
            RotarySelector rotarySelector7 = this;
            Bitmap bitmap16 = bitmap15;
            Canvas canvas9 = canvas;
            int n48 = n46;
            int n49 = n47;
            rotarySelector7.drawCentered(bitmap16, canvas9, n48, n49);
        }
        int n50 = this.mRightHandleX;
        int n51 = this.mRotaryOffsetX;
        int n52 = n50 + n51;
        int n53 = this.mBackgroundWidth;
        int n54 = this.mInnerRadius;
        int n55 = this.mOuterRadius;
        RotarySelector rotarySelector8 = this;
        int n56 = n53;
        int n57 = n54;
        int n58 = n55;
        int n59 = n52;
        int n60 = rotarySelector8.getYOnArc(n56, n57, n58, n59);
        int n61 = this.isHoriz() ? n52 : n60 + n9;
        int n62 = this.isHoriz() ? n60 + n9 : n6 - n52;
        int n63 = this.mGrabbedState;
        int n64 = 1;
        if (n63 != n64) {
            Bitmap bitmap17 = this.mDimple;
            RotarySelector rotarySelector9 = this;
            Bitmap bitmap18 = bitmap17;
            Canvas canvas10 = canvas;
            int n65 = n61;
            int n66 = n62;
            rotarySelector9.drawCentered(bitmap18, canvas10, n65, n66);
            Bitmap bitmap19 = this.mRightHandleIcon;
            RotarySelector rotarySelector10 = this;
            Bitmap bitmap20 = bitmap19;
            Canvas canvas11 = canvas;
            int n67 = n61;
            int n68 = n62;
            rotarySelector10.drawCentered(bitmap20, canvas11, n67, n68);
        } else {
            Bitmap bitmap21 = this.mDimpleDim;
            RotarySelector rotarySelector11 = this;
            Bitmap bitmap22 = bitmap21;
            Canvas canvas12 = canvas;
            int n69 = n61;
            int n70 = n62;
            rotarySelector11.drawCentered(bitmap22, canvas12, n69, n70);
        }
        int n71 = this.mRotaryOffsetX;
        int n72 = this.mLeftHandleX;
        int n73 = n71 + n72;
        int n74 = this.mDimpleSpacing;
        int n75 = n73 - n74;
        int n76 = this.mDimpleWidth / 2;
        while ((n3 = n75) > (n2 = (n = -n76))) {
            int n77 = this.mBackgroundWidth;
            int n78 = this.mInnerRadius;
            int n79 = this.mOuterRadius;
            RotarySelector rotarySelector12 = this;
            int n80 = n77;
            int n81 = n78;
            int n82 = n79;
            int n83 = n75;
            n60 = rotarySelector12.getYOnArc(n80, n81, n82, n83);
            if (this.isHoriz()) {
                Bitmap bitmap23 = this.mDimpleDim;
                int n84 = n60 + n9;
                RotarySelector rotarySelector13 = this;
                Bitmap bitmap24 = bitmap23;
                Canvas canvas13 = canvas;
                int n85 = n75;
                int n86 = n84;
                rotarySelector13.drawCentered(bitmap24, canvas13, n85, n86);
            } else {
                Bitmap bitmap25 = this.mDimpleDim;
                int n87 = n60 + n9;
                int n88 = n6 - n75;
                RotarySelector rotarySelector14 = this;
                Bitmap bitmap26 = bitmap25;
                Canvas canvas14 = canvas;
                int n89 = n87;
                int n90 = n88;
                rotarySelector14.drawCentered(bitmap26, canvas14, n89, n90);
            }
            int n91 = this.mDimpleSpacing;
            n75 -= n91;
        }
        int n92 = this.mRotaryOffsetX;
        int n93 = this.mRightHandleX;
        int n94 = n92 + n93;
        int n95 = this.mDimpleSpacing;
        int n96 = n94 + n95;
        int n97 = this.mRight + n76;
        while (n96 < n97) {
            int n98 = this.mBackgroundWidth;
            int n99 = this.mInnerRadius;
            int n100 = this.mOuterRadius;
            RotarySelector rotarySelector15 = this;
            int n101 = n98;
            int n102 = n99;
            int n103 = n100;
            int n104 = n96;
            n60 = rotarySelector15.getYOnArc(n101, n102, n103, n104);
            if (this.isHoriz()) {
                Bitmap bitmap27 = this.mDimpleDim;
                int n105 = n60 + n9;
                RotarySelector rotarySelector16 = this;
                Bitmap bitmap28 = bitmap27;
                Canvas canvas15 = canvas;
                int n106 = n96;
                int n107 = n105;
                rotarySelector16.drawCentered(bitmap28, canvas15, n106, n107);
            } else {
                Bitmap bitmap29 = this.mDimpleDim;
                int n108 = n60 + n9;
                int n109 = n6 - n96;
                RotarySelector rotarySelector17 = this;
                Bitmap bitmap30 = bitmap29;
                Canvas canvas16 = canvas;
                int n110 = n108;
                int n111 = n109;
                rotarySelector17.drawCentered(bitmap30, canvas16, n110, n111);
            }
            int n112 = this.mDimpleSpacing;
            n96 += n112;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.isHoriz() ? View.MeasureSpec.getSize(n) : View.MeasureSpec.getSize(n2);
        float f = this.mDensity;
        int n4 = (int)(6.0f * f);
        int n5 = this.mArrowShortLeftAndRight.getHeight();
        int n6 = this.mBackgroundHeight + n5 - n4;
        if (this.isHoriz()) {
            this.setMeasuredDimension(n3, n6);
            return;
        }
        this.setMeasuredDimension(n6, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        super.onSizeChanged(n, n2, n3, n4);
        float f = this.mDensity;
        int n8 = (int)(9.0f * f);
        this.mLeftHandleX = n7 = this.mDimpleWidth / 2 + n8;
        int n9 = this.isHoriz() ? n : n2;
        int n10 = n9 - n8;
        int n11 = this.mDimpleWidth / 2;
        this.mRightHandleX = n6 = n10 - n11;
        int n12 = n9 / 2;
        int n13 = this.mLeftHandleX;
        this.mDimpleSpacing = n5 = n12 - n13;
        this.mBgMatrix.setTranslate(0.0f, 0.0f);
        if (!this.isHoriz()) {
            int n14 = this.mBackgroundHeight;
            int n15 = n - n14;
            boolean bl = this.mBgMatrix.preRotate(-90.0f, 0.0f, 0.0f);
            Matrix matrix = this.mBgMatrix;
            float f2 = n15;
            float f3 = n2;
            boolean bl2 = matrix.postTranslate(f2, f3);
            return;
        }
        Matrix matrix = this.mBgMatrix;
        int n16 = this.mBackgroundHeight;
        float f4 = n2 - n16;
        boolean bl = matrix.postTranslate(0.0f, f4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n;
        if (this.mAnimating) {
            return true;
        }
        if (this.mVelocityTracker == null) {
            VelocityTracker velocityTracker;
            this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n2 = this.getHeight();
        if (this.isHoriz()) {
            n = (int)motionEvent.getX();
        } else {
            int n3 = (int)motionEvent.getY();
            n = n2 - n3;
        }
        int n4 = this.mDimpleWidth;
        switch (motionEvent.getAction()) {
            case 0: {
                int n5;
                int n6;
                this.mTriggered = false;
                if (this.mGrabbedState != 0) {
                    this.reset();
                    this.invalidate();
                }
                if (n < (n6 = this.mLeftHandleX + n4)) {
                    int n7;
                    int n8 = this.mLeftHandleX;
                    this.mRotaryOffsetX = n7 = n - n8;
                    this.setGrabbedState(1);
                    this.invalidate();
                    this.vibrate(20L);
                    return true;
                }
                int n9 = this.mRightHandleX - n4;
                if (n <= n9) return true;
                int n10 = this.mRightHandleX;
                this.mRotaryOffsetX = n5 = n - n10;
                this.setGrabbedState(2);
                this.invalidate();
                this.vibrate(20L);
                return true;
            }
            case 2: {
                int n11;
                int n12;
                if (this.mGrabbedState == 1) {
                    int n13;
                    int n14;
                    int n15 = this.mLeftHandleX;
                    this.mRotaryOffsetX = n14 = n - n15;
                    this.invalidate();
                    int n16 = this.isHoriz() ? this.getRight() : n2;
                    int n17 = this.mEdgeTriggerThresh;
                    int n18 = n16 - n17;
                    if (n < n18) return true;
                    if (this.mTriggered) return true;
                    this.mTriggered = true;
                    this.dispatchTriggerEvent(1);
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    float f = this.mMaximumVelocity;
                    velocityTracker.computeCurrentVelocity(1000, f);
                    int n19 = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                    int n20 = Math.max(this.mMinimumVelocity, n19);
                    int n21 = this.mDimpleSpacing;
                    int n22 = Math.abs(n20 / n21);
                    this.mDimplesOfFling = n13 = Math.max(8, n22);
                    int n23 = this.mLeftHandleX;
                    int n24 = n - n23;
                    int n25 = this.mDimplesOfFling;
                    int n26 = this.mDimpleSpacing;
                    int n27 = n25 * n26;
                    this.startAnimationWithVelocity(n24, n27, n20);
                    return true;
                }
                if (this.mGrabbedState != 2) return true;
                int n28 = this.mRightHandleX;
                this.mRotaryOffsetX = n12 = n - n28;
                this.invalidate();
                int n29 = this.mEdgeTriggerThresh;
                if (n > n29) return true;
                if (this.mTriggered) return true;
                this.mTriggered = true;
                this.dispatchTriggerEvent(2);
                VelocityTracker velocityTracker = this.mVelocityTracker;
                float f = this.mMaximumVelocity;
                velocityTracker.computeCurrentVelocity(1000, f);
                int n30 = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                int n31 = Math.min(-this.mMinimumVelocity, n30);
                int n32 = this.mDimpleSpacing;
                int n33 = Math.abs(n31 / n32);
                this.mDimplesOfFling = n11 = Math.max(8, n33);
                int n34 = this.mRightHandleX;
                int n35 = n - n34;
                int n36 = this.mDimplesOfFling;
                int n37 = this.mDimpleSpacing;
                int n38 = -(n36 * n37);
                this.startAnimationWithVelocity(n35, n38, n31);
                return true;
            }
            case 1: {
                int n39;
                int n40;
                if (this.mGrabbedState == 1 && Math.abs(n - (n40 = this.mLeftHandleX)) > 5) {
                    int n41 = this.mLeftHandleX;
                    int n42 = n - n41;
                    this.startAnimation(n42, 0, 300);
                } else if (this.mGrabbedState == 2 && Math.abs(n - (n39 = this.mRightHandleX)) > 5) {
                    int n43 = this.mRightHandleX;
                    int n44 = n - n43;
                    this.startAnimation(n44, 0, 300);
                }
                this.mRotaryOffsetX = 0;
                this.setGrabbedState(0);
                this.invalidate();
                if (this.mVelocityTracker == null) return true;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                return true;
            }
            case 3: {
                this.reset();
                this.invalidate();
                if (this.mVelocityTracker == null) return true;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                return true;
            }
        }
        return true;
    }

    public void setLeftHandleResource(int n) {
        if (n != 0) {
            Bitmap bitmap;
            this.mLeftHandleIcon = bitmap = this.getBitmapFor(n);
        }
        this.invalidate();
    }

    public void setOnDialTriggerListener(OnDialTriggerListener onDialTriggerListener) {
        this.mOnDialTriggerListener = onDialTriggerListener;
    }

    public void setRightHandleResource(int n) {
        if (n != 0) {
            Bitmap bitmap;
            this.mRightHandleIcon = bitmap = this.getBitmapFor(n);
        }
        this.invalidate();
    }

    public static interface OnDialTriggerListener {
        public static final int LEFT_HANDLE = 1;
        public static final int RIGHT_HANDLE = 2;

        public void onDialTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

