/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.R;

public class SlidingTab
extends ViewGroup {
    private static final int ANIM_DURATION = 250;
    private static final int ANIM_TARGET_TIME = 500;
    private static final boolean DBG = false;
    private static final int HORIZONTAL = 0;
    private static final String LOG_TAG = "SlidingTab";
    private static final float THRESHOLD = 0.6666667f;
    private static final int TRACKING_MARGIN = 50;
    private static final int VERTICAL = 1;
    private static final long VIBRATE_LONG = 40L;
    private static final long VIBRATE_SHORT = 30L;
    private boolean mAnimating;
    private final Animation.AnimationListener mAnimationDoneListener;
    private Slider mCurrentSlider;
    private float mDensity;
    private int mGrabbedState = 0;
    private boolean mHoldLeftOnTransition = true;
    private boolean mHoldRightOnTransition = true;
    private Slider mLeftSlider;
    private OnTriggerListener mOnTriggerListener;
    private int mOrientation;
    private Slider mOtherSlider;
    private Slider mRightSlider;
    private float mThreshold;
    private Rect mTmpRect;
    private boolean mTracking;
    private boolean mTriggered = false;
    private Vibrator mVibrator;

    public SlidingTab(Context context) {
        this(context, null);
    }

    public SlidingTab(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Slider slider;
        Slider slider2;
        float f;
        int n;
        Rect rect;
        Animation.AnimationListener animationListener;
        this.mAnimationDoneListener = animationListener = new Animation.AnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                SlidingTab.this.onAnimationDone();
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }

            @Override
            public void onAnimationStart(Animation animation) {
            }
        };
        this.mTmpRect = rect = new Rect();
        int[] nArray = R.styleable.SlidingTab;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mOrientation = n = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mDensity = f = this.getResources().getDisplayMetrics().density;
        this.mLeftSlider = slider2 = new Slider(this, 17302017, 17302000, 17302031);
        this.mRightSlider = slider = new Slider(this, 17302026, 17302009, 17302031);
    }

    static /* synthetic */ boolean access$202(SlidingTab slidingTab, boolean bl) {
        slidingTab.mAnimating = bl;
        return bl;
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate(40L);
        if (this.mOnTriggerListener == null) {
            return;
        }
        this.mOnTriggerListener.onTrigger(this, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHorizontal() {
        if (this.mOrientation != 0) return false;
        return true;
    }

    private void log(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveHandle(float f, float f2) {
        ImageView imageView = this.mCurrentSlider.tab;
        TextView textView = this.mCurrentSlider.text;
        if (this.isHorizontal()) {
            int n = (int)f;
            int n2 = imageView.getLeft();
            int n3 = n - n2;
            int n4 = imageView.getWidth() / 2;
            int n5 = n3 - n4;
            imageView.offsetLeftAndRight(n5);
            textView.offsetLeftAndRight(n5);
        } else {
            int n = (int)f2;
            int n6 = imageView.getTop();
            int n7 = n - n6;
            int n8 = imageView.getHeight() / 2;
            int n9 = n7 - n8;
            imageView.offsetTopAndBottom(n9);
            textView.offsetTopAndBottom(n9);
        }
        this.invalidate();
    }

    private void onAnimationDone() {
        this.resetView();
        this.mAnimating = false;
    }

    private void resetView() {
        this.mLeftSlider.reset(false);
        this.mRightSlider.reset(false);
    }

    private void setGrabbedState(int n) {
        int n2 = this.mGrabbedState;
        if (n != n2) {
            return;
        }
        this.mGrabbedState = n;
        if (this.mOnTriggerListener == null) {
            return;
        }
        OnTriggerListener onTriggerListener = this.mOnTriggerListener;
        int n3 = this.mGrabbedState;
        onTriggerListener.onGrabbedStateChange(this, n3);
    }

    private void vibrate(long l) {
        synchronized (this) {
            if (this.mVibrator == null) {
                Vibrator vibrator;
                this.mVibrator = vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(l);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean withinView(float f, float f2, View view) {
        if (this.isHorizontal() && f2 > -50.0f) {
            float f3 = view.getHeight() + 50;
            if (f2 < f3) return true;
        }
        if (this.isHorizontal()) return false;
        if (!(f > -50.0f)) return false;
        float f4 = view.getWidth() + 50;
        if (!(f < f4)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        if (this.mAnimating) {
            return false;
        }
        ImageView imageView = this.mLeftSlider.tab;
        Rect rect = this.mTmpRect;
        imageView.getHitRect(rect);
        Rect rect2 = this.mTmpRect;
        int n2 = (int)f;
        int n3 = (int)f2;
        boolean bl = rect2.contains(n2, n3);
        ImageView imageView2 = this.mRightSlider.tab;
        Rect rect3 = this.mTmpRect;
        imageView2.getHitRect(rect3);
        Rect rect4 = this.mTmpRect;
        int n4 = (int)f;
        int n5 = (int)f2;
        boolean bl2 = rect4.contains(n4, n5);
        if (!(this.mTracking || bl || bl2)) {
            return false;
        }
        switch (n) {
            default: {
                return true;
            }
            case 0: {
                this.mTracking = true;
                this.mTriggered = false;
                this.vibrate(30L);
                if (bl) {
                    Slider slider;
                    Slider slider2;
                    this.mCurrentSlider = slider2 = this.mLeftSlider;
                    this.mOtherSlider = slider = this.mRightSlider;
                    float f3 = this.isHorizontal() ? 0.6666667f : 0.3333333f;
                    this.mThreshold = f3;
                    this.setGrabbedState(1);
                } else {
                    Slider slider;
                    Slider slider3;
                    this.mCurrentSlider = slider3 = this.mRightSlider;
                    this.mOtherSlider = slider = this.mLeftSlider;
                    float f4 = this.isHorizontal() ? 0.3333333f : 0.6666667f;
                    this.mThreshold = f4;
                    this.setGrabbedState(2);
                }
                this.mCurrentSlider.setState(1);
                this.mCurrentSlider.showTarget();
                this.mOtherSlider.hide();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            return;
        }
        Slider slider = this.mLeftSlider;
        int n5 = this.isHorizontal() ? 0 : 3;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        slider.layout(n6, n7, n8, n9, n5);
        Slider slider2 = this.mRightSlider;
        int n10 = this.isHorizontal() ? 1 : 2;
        int n11 = n;
        int n12 = n2;
        int n13 = n3;
        int n14 = n4;
        slider2.layout(n11, n12, n13, n14, n10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5 = View.MeasureSpec.getMode(n);
        int n6 = View.MeasureSpec.getSize(n);
        int n7 = View.MeasureSpec.getMode(n2);
        int n8 = View.MeasureSpec.getSize(n2);
        if (n5 == 0 || n7 == 0) {
            String string2 = "SlidingTab cannot have UNSPECIFIED MeasureSpec(wspec=" + n5 + ", hspec=" + n7 + ")";
            RuntimeException runtimeException = new RuntimeException("SlidingTabstack:");
            int n9 = Log.e(LOG_TAG, string2, runtimeException);
        }
        this.mLeftSlider.measure();
        this.mRightSlider.measure();
        int n10 = this.mLeftSlider.getTabWidth();
        int n11 = this.mRightSlider.getTabWidth();
        int n12 = this.mLeftSlider.getTabHeight();
        int n13 = this.mRightSlider.getTabHeight();
        if (this.isHorizontal()) {
            int n14 = n10 + n11;
            n4 = Math.max(n6, n14);
            n3 = Math.max(n12, n13);
        } else {
            n4 = Math.max(n10, n13);
            int n15 = n12 + n13;
            n3 = Math.max(n8, n15);
        }
        this.setMeasuredDimension(n4, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mTracking) {
            int n = motionEvent.getAction();
            float f = motionEvent.getX();
            float f2 = motionEvent.getY();
            switch (n) {
                case 2: {
                    if (this.withinView(f, f2, this)) {
                        Slider slider;
                        Slider slider2;
                        Slider slider3;
                        Slider slider4;
                        this.moveHandle(f, f2);
                        float f3 = this.isHorizontal() ? f : f2;
                        float f4 = this.mThreshold;
                        int n2 = this.isHorizontal() ? this.getWidth() : this.getHeight();
                        float f5 = n2;
                        float f6 = f4 * f5;
                        boolean bl = this.isHorizontal() ? ((slider4 = this.mCurrentSlider) == (slider3 = this.mLeftSlider) ? f3 > f6 : f3 < f6) : ((slider2 = this.mCurrentSlider) == (slider = this.mLeftSlider) ? f3 < f6 : f3 > f6);
                        if (this.mTriggered || !bl) break;
                        this.mTriggered = true;
                        this.mTracking = false;
                        this.mCurrentSlider.setState(2);
                        Slider slider5 = this.mCurrentSlider;
                        Slider slider6 = this.mLeftSlider;
                        boolean bl2 = slider5 == slider6;
                        int n3 = bl2 ? 1 : 2;
                        this.dispatchTriggerEvent(n3);
                        boolean bl3 = bl2 ? this.mHoldLeftOnTransition : this.mHoldRightOnTransition;
                        this.startAnimating(bl3);
                        this.setGrabbedState(0);
                        break;
                    }
                }
                case 1: 
                case 3: {
                    this.mTracking = false;
                    this.mTriggered = false;
                    this.mOtherSlider.show(true);
                    this.mCurrentSlider.reset(false);
                    this.mCurrentSlider.hideTarget();
                    this.mCurrentSlider = null;
                    this.mOtherSlider = null;
                    this.setGrabbedState(0);
                }
            }
        }
        if (this.mTracking) return true;
        if (!super.onTouchEvent(motionEvent)) return false;
        return true;
    }

    public void reset(boolean bl) {
        this.mLeftSlider.reset(bl);
        this.mRightSlider.reset(bl);
        if (bl) {
            return;
        }
        this.mAnimating = false;
    }

    public void setHoldAfterTrigger(boolean bl, boolean bl2) {
        this.mHoldLeftOnTransition = bl;
        this.mHoldRightOnTransition = bl2;
    }

    public void setLeftHintText(int n) {
        if (!this.isHorizontal()) {
            return;
        }
        this.mLeftSlider.setHintText(n);
    }

    public void setLeftTabResources(int n, int n2, int n3, int n4) {
        this.mLeftSlider.setIcon(n);
        this.mLeftSlider.setTarget(n2);
        this.mLeftSlider.setBarBackgroundResource(n3);
        this.mLeftSlider.setTabBackgroundResource(n4);
        this.mLeftSlider.updateDrawableStates();
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        this.mOnTriggerListener = onTriggerListener;
    }

    public void setRightHintText(int n) {
        if (!this.isHorizontal()) {
            return;
        }
        this.mRightSlider.setHintText(n);
    }

    public void setRightTabResources(int n, int n2, int n3, int n4) {
        this.mRightSlider.setIcon(n);
        this.mRightSlider.setTarget(n2);
        this.mRightSlider.setBarBackgroundResource(n3);
        this.mRightSlider.setTabBackgroundResource(n4);
        this.mRightSlider.updateDrawableStates();
    }

    @Override
    public void setVisibility(int n) {
        int n2 = this.getVisibility();
        if (n != n2 && n == 4) {
            this.reset(false);
        }
        super.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void startAnimating(boolean bl) {
        2 var47_46;
        TranslateAnimation translateAnimation;
        TranslateAnimation translateAnimation2;
        int n;
        int n2;
        boolean bl2;
        this.mAnimating = bl2 = true;
        Slider slider = this.mCurrentSlider;
        Slider slider2 = this.mOtherSlider;
        if (this.isHorizontal()) {
            int n3 = slider.tab.getRight();
            int n4 = slider.tab.getWidth();
            int n5 = slider.tab.getLeft();
            int n6 = this.getWidth();
            int n7 = bl ? 0 : n4;
            Slider slider3 = slider;
            Slider slider4 = this.mRightSlider;
            Slider slider5 = slider4;
            n2 = slider3 == slider5 ? -(n3 + n6 - n7) : n6 - n5 + n6 - n7;
            n = 0;
        } else {
            int n8 = slider.tab.getTop();
            int n9 = slider.tab.getBottom();
            int n10 = slider.tab.getHeight();
            int n11 = this.getHeight();
            int n12 = bl ? 0 : n10;
            n2 = 0;
            Slider slider6 = slider;
            Slider slider7 = this.mRightSlider;
            Slider slider8 = slider7;
            n = slider6 == slider8 ? n8 + n11 - n12 : -(n11 - n9 + n11 - n12);
        }
        float f = n2;
        float f2 = n;
        TranslateAnimation translateAnimation3 = translateAnimation2;
        float f3 = 0.0f;
        float f4 = f;
        float f5 = 0.0f;
        float f6 = f2;
        translateAnimation3(f3, f4, f5, f6);
        TranslateAnimation translateAnimation4 = translateAnimation2;
        long l = 250L;
        translateAnimation4.setDuration(l);
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        TranslateAnimation translateAnimation5 = translateAnimation2;
        LinearInterpolator linearInterpolator2 = linearInterpolator;
        translateAnimation5.setInterpolator(linearInterpolator2);
        TranslateAnimation translateAnimation6 = translateAnimation2;
        boolean bl3 = true;
        translateAnimation6.setFillAfter(bl3);
        float f7 = n2;
        float f8 = n;
        TranslateAnimation translateAnimation7 = translateAnimation;
        float f9 = 0.0f;
        float f10 = f7;
        float f11 = 0.0f;
        float f12 = f8;
        translateAnimation7(f9, f10, f11, f12);
        TranslateAnimation translateAnimation8 = translateAnimation;
        long l2 = 250L;
        translateAnimation8.setDuration(l2);
        LinearInterpolator linearInterpolator3 = new LinearInterpolator();
        TranslateAnimation translateAnimation9 = translateAnimation;
        LinearInterpolator linearInterpolator4 = linearInterpolator3;
        translateAnimation9.setInterpolator(linearInterpolator4);
        TranslateAnimation translateAnimation10 = translateAnimation;
        boolean bl4 = true;
        translateAnimation10.setFillAfter(bl4);
        2 var48_47 = var47_46;
        SlidingTab slidingTab = this;
        boolean bl5 = bl;
        int n13 = n2;
        int n14 = n;
        var48_47(bl5, n13, n14);
        TranslateAnimation translateAnimation11 = translateAnimation2;
        2 var54_53 = var47_46;
        translateAnimation11.setAnimationListener(var54_53);
        slider.hideTarget();
        Slider slider9 = slider;
        TranslateAnimation translateAnimation12 = translateAnimation2;
        TranslateAnimation translateAnimation13 = translateAnimation;
        slider9.startAnimation(translateAnimation12, translateAnimation13);
    }

    private static class Slider {
        public static final int ALIGN_BOTTOM = 3;
        public static final int ALIGN_LEFT = 0;
        public static final int ALIGN_RIGHT = 1;
        public static final int ALIGN_TOP = 2;
        public static final int ALIGN_UNKNOWN = 4;
        private static final int STATE_ACTIVE = 2;
        private static final int STATE_NORMAL = 0;
        private static final int STATE_PRESSED = 1;
        private int alignment = 4;
        private int alignment_value;
        private int currentState = 0;
        private final ImageView tab;
        private final ImageView target;
        private final TextView text;

        Slider(ViewGroup viewGroup, int n, int n2, int n3) {
            ImageView imageView;
            TextView textView;
            ImageView imageView2;
            Context context = viewGroup.getContext();
            this.tab = imageView2 = new ImageView(context);
            this.tab.setBackgroundResource(n);
            ImageView imageView3 = this.tab;
            ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER;
            imageView3.setScaleType(scaleType);
            ImageView imageView4 = this.tab;
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            imageView4.setLayoutParams(layoutParams);
            Context context2 = viewGroup.getContext();
            TextView textView2 = this.text = (textView = new TextView(context2));
            ViewGroup.LayoutParams layoutParams2 = new ViewGroup.LayoutParams(-1, -1);
            textView2.setLayoutParams(layoutParams2);
            this.text.setBackgroundResource(n2);
            TextView textView3 = this.text;
            Context context3 = viewGroup.getContext();
            textView3.setTextAppearance(context3, 16973970);
            Context context4 = viewGroup.getContext();
            this.target = imageView = new ImageView(context4);
            this.target.setImageResource(n3);
            ImageView imageView5 = this.target;
            ImageView.ScaleType scaleType2 = ImageView.ScaleType.CENTER;
            imageView5.setScaleType(scaleType2);
            ImageView imageView6 = this.target;
            ViewGroup.LayoutParams layoutParams3 = new ViewGroup.LayoutParams(-1, -1);
            imageView6.setLayoutParams(layoutParams3);
            this.target.setVisibility(4);
            ImageView imageView7 = this.target;
            viewGroup.addView(imageView7);
            ImageView imageView8 = this.tab;
            viewGroup.addView(imageView8);
            TextView textView4 = this.text;
            viewGroup.addView(textView4);
        }

        public int getTabHeight() {
            return this.tab.getMeasuredHeight();
        }

        public int getTabWidth() {
            return this.tab.getMeasuredWidth();
        }

        /*
         * Enabled aggressive block sorting
         */
        void hide() {
            int n;
            int n2;
            boolean bl = this.alignment == 0 || this.alignment == 1;
            if (bl) {
                if (this.alignment == 0) {
                    int n3 = this.alignment_value;
                    int n4 = this.tab.getRight();
                    n2 = n3 - n4;
                } else {
                    int n5 = this.alignment_value;
                    int n6 = this.tab.getLeft();
                    n2 = n5 - n6;
                }
            } else {
                n2 = 0;
            }
            if (bl) {
                n = 0;
            } else if (this.alignment == 2) {
                int n7 = this.alignment_value;
                int n8 = this.tab.getBottom();
                n = n7 - n8;
            } else {
                int n9 = this.alignment_value;
                int n10 = this.tab.getTop();
                n = n9 - n10;
            }
            float f = n2;
            float f2 = n;
            TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, f, 0.0f, f2);
            translateAnimation.setDuration(250L);
            translateAnimation.setFillAfter(true);
            this.tab.startAnimation(translateAnimation);
            this.text.startAnimation(translateAnimation);
            this.target.setVisibility(4);
        }

        public void hideTarget() {
            this.target.clearAnimation();
            this.target.setVisibility(4);
        }

        void layout(int n, int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            int n8;
            int n9;
            this.alignment = n9 = n5;
            Drawable drawable2 = this.tab.getBackground();
            int n10 = drawable2.getIntrinsicWidth();
            int n11 = drawable2.getIntrinsicHeight();
            Drawable drawable3 = this.target.getDrawable();
            int n12 = drawable3.getIntrinsicWidth();
            int n13 = drawable3.getIntrinsicHeight();
            int n14 = n3 - n;
            int n15 = n4 - n2;
            float f = n14;
            int n16 = (int)(0.6666667f * f) - n12;
            int n17 = n10 / 2;
            int n18 = n16 + n17;
            float f2 = n14;
            int n19 = (int)(0.3333333f * f2);
            int n20 = n10 / 2;
            int n21 = n19 - n20;
            int n22 = (n14 - n10) / 2;
            int n23 = n22 + n10;
            if (n5 == 0 || (n8 = n5) == (n7 = 1)) {
                int n24;
                int n25 = (n15 - n13) / 2;
                int n26 = n25 + n13;
                int n27 = (n15 - n11) / 2;
                int n28 = (n15 + n11) / 2;
                if (n5 == 0) {
                    int n29;
                    ImageView imageView = this.tab;
                    int n30 = 0;
                    int n31 = n27;
                    int n32 = n10;
                    int n33 = n28;
                    imageView.layout(n30, n31, n32, n33);
                    TextView textView = this.text;
                    int n34 = 0 - n14;
                    TextView textView2 = textView;
                    int n35 = n34;
                    int n36 = n27;
                    int n37 = 0;
                    int n38 = n28;
                    textView2.layout(n35, n36, n37, n38);
                    this.text.setGravity(5);
                    ImageView imageView2 = this.target;
                    int n39 = n18 + n12;
                    ImageView imageView3 = imageView2;
                    int n40 = n18;
                    int n41 = n25;
                    int n42 = n39;
                    int n43 = n26;
                    imageView3.layout(n40, n41, n42, n43);
                    this.alignment_value = n29 = n;
                    return;
                }
                ImageView imageView = this.tab;
                int n44 = n14 - n10;
                ImageView imageView4 = imageView;
                int n45 = n44;
                int n46 = n27;
                int n47 = n14;
                int n48 = n28;
                imageView4.layout(n45, n46, n47, n48);
                TextView textView = this.text;
                int n49 = n14 + n14;
                TextView textView3 = textView;
                int n50 = n14;
                int n51 = n27;
                int n52 = n49;
                int n53 = n28;
                textView3.layout(n50, n51, n52, n53);
                ImageView imageView5 = this.target;
                int n54 = n21 + n12;
                ImageView imageView6 = imageView5;
                int n55 = n21;
                int n56 = n25;
                int n57 = n54;
                int n58 = n26;
                imageView6.layout(n55, n56, n57, n58);
                this.text.setGravity(48);
                this.alignment_value = n24 = n3;
                return;
            }
            int n59 = (n14 - n12) / 2;
            int n60 = (n14 + n12) / 2;
            float f3 = n15;
            int n61 = (int)(0.6666667f * f3);
            int n62 = n11 / 2;
            int n63 = n61 + n62 - n13;
            float f4 = n15;
            int n64 = (int)(0.3333333f * f4);
            int n65 = n11 / 2;
            int n66 = n64 - n65;
            int n67 = n5;
            int n68 = 2;
            if (n67 == n68) {
                int n69;
                ImageView imageView = this.tab;
                int n70 = n22;
                int n71 = 0;
                int n72 = n23;
                int n73 = n11;
                imageView.layout(n70, n71, n72, n73);
                TextView textView = this.text;
                int n74 = 0 - n15;
                TextView textView4 = textView;
                int n75 = n22;
                int n76 = n74;
                int n77 = n23;
                int n78 = 0;
                textView4.layout(n75, n76, n77, n78);
                ImageView imageView7 = this.target;
                int n79 = n63 + n13;
                ImageView imageView8 = imageView7;
                int n80 = n59;
                int n81 = n63;
                int n82 = n60;
                int n83 = n79;
                imageView8.layout(n80, n81, n82, n83);
                this.alignment_value = n69 = n2;
                return;
            }
            ImageView imageView = this.tab;
            int n84 = n15 - n11;
            ImageView imageView9 = imageView;
            int n85 = n22;
            int n86 = n84;
            int n87 = n23;
            int n88 = n15;
            imageView9.layout(n85, n86, n87, n88);
            TextView textView = this.text;
            int n89 = n15 + n15;
            TextView textView5 = textView;
            int n90 = n22;
            int n91 = n15;
            int n92 = n23;
            int n93 = n89;
            textView5.layout(n90, n91, n92, n93);
            ImageView imageView10 = this.target;
            int n94 = n66 + n13;
            ImageView imageView11 = imageView10;
            int n95 = n59;
            int n96 = n66;
            int n97 = n60;
            int n98 = n94;
            imageView11.layout(n95, n96, n97, n98);
            this.alignment_value = n6 = n4;
        }

        public void measure() {
            ImageView imageView = this.tab;
            int n = View.MeasureSpec.makeMeasureSpec(0, 0);
            int n2 = View.MeasureSpec.makeMeasureSpec(0, 0);
            imageView.measure(n, n2);
            TextView textView = this.text;
            int n3 = View.MeasureSpec.makeMeasureSpec(0, 0);
            int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
            textView.measure(n3, n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        void reset(boolean bl) {
            int n;
            int n2;
            this.setState(0);
            this.text.setVisibility(0);
            TextView textView = this.text;
            Context context = this.text.getContext();
            textView.setTextAppearance(context, 16973970);
            this.tab.setVisibility(0);
            this.target.setVisibility(4);
            boolean bl2 = this.alignment == 0 || this.alignment == 1;
            if (bl2) {
                if (this.alignment == 0) {
                    int n3 = this.alignment_value;
                    int n4 = this.tab.getLeft();
                    n2 = n3 - n4;
                } else {
                    int n5 = this.alignment_value;
                    int n6 = this.tab.getRight();
                    n2 = n5 - n6;
                }
            } else {
                n2 = 0;
            }
            if (bl2) {
                n = 0;
            } else if (this.alignment == 2) {
                int n7 = this.alignment_value;
                int n8 = this.tab.getTop();
                n = n7 - n8;
            } else {
                int n9 = this.alignment_value;
                int n10 = this.tab.getBottom();
                n = n9 - n10;
            }
            if (bl) {
                float f = n2;
                float f2 = n;
                TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, f, 0.0f, f2);
                translateAnimation.setDuration(250L);
                translateAnimation.setFillAfter(false);
                this.text.startAnimation(translateAnimation);
                this.tab.startAnimation(translateAnimation);
                return;
            }
            if (bl2) {
                this.text.offsetLeftAndRight(n2);
                this.tab.offsetLeftAndRight(n2);
            } else {
                this.text.offsetTopAndBottom(n);
                this.tab.offsetTopAndBottom(n);
            }
            this.text.clearAnimation();
            this.tab.clearAnimation();
            this.target.clearAnimation();
        }

        void setBarBackgroundResource(int n) {
            this.text.setBackgroundResource(n);
        }

        void setHintText(int n) {
            this.text.setText(n);
        }

        void setIcon(int n) {
            this.tab.setImageResource(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setState(int n) {
            TextView textView = this.text;
            boolean bl = n == 1;
            textView.setPressed(bl);
            ImageView imageView = this.tab;
            boolean bl2 = n == 1;
            imageView.setPressed(bl2);
            if (n == 2) {
                int[] nArray = new int[]{16842914};
                if (this.text.getBackground().isStateful()) {
                    boolean bl3 = this.text.getBackground().setState(nArray);
                }
                if (this.tab.getBackground().isStateful()) {
                    boolean bl4 = this.tab.getBackground().setState(nArray);
                }
                TextView textView2 = this.text;
                Context context = this.text.getContext();
                textView2.setTextAppearance(context, 16973971);
            } else {
                TextView textView3 = this.text;
                Context context = this.text.getContext();
                textView3.setTextAppearance(context, 16973970);
            }
            this.currentState = n;
        }

        void setTabBackgroundResource(int n) {
            this.tab.setBackgroundResource(n);
        }

        void setTarget(int n) {
            this.target.setImageResource(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        void show(boolean bl) {
            this.text.setVisibility(0);
            this.tab.setVisibility(0);
            if (!bl) {
                return;
            }
            boolean bl2 = this.alignment == 0 || this.alignment == 1;
            int n = bl2 ? (this.alignment == 0 ? this.tab.getWidth() : -this.tab.getWidth()) : 0;
            int n2 = bl2 ? 0 : (this.alignment == 2 ? this.tab.getHeight() : -this.tab.getHeight());
            float f = -n;
            float f2 = -n2;
            TranslateAnimation translateAnimation = new TranslateAnimation(f, 0.0f, f2, 0.0f);
            translateAnimation.setDuration(250L);
            this.tab.startAnimation(translateAnimation);
            this.text.startAnimation(translateAnimation);
        }

        void showTarget() {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration(500L);
            this.target.startAnimation(alphaAnimation);
            this.target.setVisibility(0);
        }

        public void startAnimation(Animation animation, Animation animation2) {
            this.tab.startAnimation(animation);
            this.text.startAnimation(animation2);
        }

        public void updateDrawableStates() {
            int n = this.currentState;
            this.setState(n);
        }
    }

    public static interface OnTriggerListener {
        public static final int LEFT_HANDLE = 1;
        public static final int NO_HANDLE = 0;
        public static final int RIGHT_HANDLE = 2;

        public void onGrabbedStateChange(View var1, int var2);

        public void onTrigger(View var1, int var2);
    }
}

