/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class TextProgressBar
extends RelativeLayout
implements Chronometer.OnChronometerTickListener {
    static final int CHRONOMETER_ID = 16908308;
    static final int PROGRESSBAR_ID = 16908301;
    public static final String TAG = "TextProgressBar";
    Chronometer mChronometer = null;
    boolean mChronometerFollow = false;
    int mChronometerGravity = 0;
    int mDuration = -1;
    long mDurationBase = 65535L;
    ProgressBar mProgressBar = null;

    public TextProgressBar(Context context) {
        super(context);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        ProgressBar progressBar;
        super.addView(view, n, layoutParams);
        int n2 = view.getId();
        if (n2 == 16908308 && view instanceof Chronometer) {
            int n3;
            Chronometer chronometer;
            this.mChronometer = chronometer = (Chronometer)view;
            this.mChronometer.setOnChronometerTickListener(this);
            boolean bl = layoutParams.width == -1;
            this.mChronometerFollow = bl;
            this.mChronometerGravity = n3 = this.mChronometer.getGravity() & 7;
            return;
        }
        if (n2 != 16908301) {
            return;
        }
        if (!(view instanceof ProgressBar)) {
            return;
        }
        this.mProgressBar = progressBar = (ProgressBar)view;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onChronometerTick(Chronometer chronometer) {
        long l;
        if (this.mProgressBar == null) {
            throw new RuntimeException("Expecting child ProgressBar with id 'android.R.id.progress'");
        }
        long l2 = SystemClock.elapsedRealtime();
        if (l2 >= (l = this.mDurationBase)) {
            this.mChronometer.stop();
        }
        int n = (int)(this.mDurationBase - l2);
        ProgressBar progressBar = this.mProgressBar;
        int n2 = this.mDuration - n;
        progressBar.setProgress(n2);
        if (!this.mChronometerFollow) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mProgressBar.getLayoutParams();
        int n3 = this.mProgressBar.getWidth();
        int n4 = layoutParams.leftMargin;
        int n5 = layoutParams.rightMargin;
        int n6 = n4 + n5;
        int n7 = n3 - n6;
        int n8 = this.mProgressBar.getProgress() * n7;
        int n9 = this.mProgressBar.getMax();
        int n10 = n8 / n9;
        int n11 = layoutParams.leftMargin;
        int n12 = n10 + n11;
        int n13 = 0;
        int n14 = this.mChronometer.getWidth();
        if (this.mChronometerGravity == 5) {
            n13 = -n14;
        } else if (this.mChronometerGravity == 1) {
            n13 = -(n14 / 2);
        }
        int n15 = n12 + n13;
        int n16 = layoutParams.rightMargin;
        int n17 = n7 - n16 - n14;
        int n18 = layoutParams.leftMargin;
        if (n15 < n18) {
            n15 = layoutParams.leftMargin;
        } else if (n15 > n17) {
            n15 = n17;
        }
        ((RelativeLayout.LayoutParams)this.mChronometer.getLayoutParams()).leftMargin = n15;
        this.mChronometer.requestLayout();
    }

    @RemotableViewMethod
    public void setDurationBase(long l) {
        int n;
        this.mDurationBase = l;
        if (this.mProgressBar == null || this.mChronometer == null) {
            throw new RuntimeException("Expecting child ProgressBar with id 'android.R.id.progress' and Chronometer id 'android.R.id.text1'");
        }
        long l2 = this.mChronometer.getBase();
        this.mDuration = n = (int)(l - l2);
        if (this.mDuration <= 0) {
            this.mDuration = 1;
        }
        ProgressBar progressBar = this.mProgressBar;
        int n2 = this.mDuration;
        progressBar.setMax(n2);
    }
}

