/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.SipProfile;
import android.util.Log;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

class SipHelper {
    private static final boolean DEBUG = true;
    private static final String TAG = SipHelper.class.getSimpleName();
    private AddressFactory mAddressFactory;
    private HeaderFactory mHeaderFactory;
    private MessageFactory mMessageFactory;
    private SipProvider mSipProvider;
    private SipStack mSipStack;

    public SipHelper(SipStack sipStack, SipProvider sipProvider) throws PeerUnavailableException {
        MessageFactory messageFactory;
        HeaderFactory headerFactory;
        AddressFactory addressFactory;
        this.mSipStack = sipStack;
        this.mSipProvider = sipProvider;
        SipFactory sipFactory = SipFactory.getInstance();
        this.mAddressFactory = addressFactory = sipFactory.createAddressFactory();
        this.mHeaderFactory = headerFactory = sipFactory.createHeaderFactory();
        this.mMessageFactory = messageFactory = sipFactory.createMessageFactory();
    }

    private CSeqHeader createCSeqHeader(String string2) throws ParseException, InvalidArgumentException {
        long l = (long)(Math.random() * 10000.0);
        return this.mHeaderFactory.createCSeqHeader(l, string2);
    }

    private CallIdHeader createCallIdHeader() {
        return this.mSipProvider.getNewCallId();
    }

    private ContactHeader createContactHeader(SipProfile sipProfile) throws ParseException, SipException {
        ListeningPoint listeningPoint = this.getListeningPoint();
        String string2 = sipProfile.getUserName();
        String string3 = sipProfile.getProtocol();
        SipURI sipURI = this.createSipUri(string2, string3, listeningPoint);
        Address address = this.mAddressFactory.createAddress((URI)sipURI);
        String string4 = sipProfile.getDisplayName();
        address.setDisplayName(string4);
        return this.mHeaderFactory.createContactHeader(address);
    }

    private FromHeader createFromHeader(SipProfile sipProfile, String string2) throws ParseException {
        HeaderFactory headerFactory = this.mHeaderFactory;
        Address address = sipProfile.getSipAddress();
        return headerFactory.createFromHeader(address, string2);
    }

    private MaxForwardsHeader createMaxForwardsHeader() throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(70);
    }

    private MaxForwardsHeader createMaxForwardsHeader(int n) throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(n);
    }

    private Request createRequest(String string2, SipProfile sipProfile, String string3) throws ParseException, SipException {
        FromHeader fromHeader = this.createFromHeader(sipProfile, string3);
        ToHeader toHeader = this.createToHeader(sipProfile);
        AddressFactory addressFactory = this.mAddressFactory;
        String string4 = sipProfile.getUriString();
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = sipProfile.getUserName();
        String string6 = stringBuilder.append(string5).append("@").toString();
        String string7 = string4.replaceFirst(string6, "");
        SipURI sipURI = addressFactory.createSipURI(string7);
        List<ViaHeader> list = this.createViaHeaders();
        CallIdHeader callIdHeader = this.createCallIdHeader();
        CSeqHeader cSeqHeader = this.createCSeqHeader(string2);
        MaxForwardsHeader maxForwardsHeader = this.createMaxForwardsHeader();
        MessageFactory messageFactory = this.mMessageFactory;
        String string8 = string2;
        Request request = messageFactory.createRequest((URI)sipURI, string8, callIdHeader, cSeqHeader, fromHeader, toHeader, list, maxForwardsHeader);
        Header header = this.mHeaderFactory.createHeader("User-Agent", "SIPAUA/0.1.001");
        request.addHeader(header);
        return request;
    }

    private SipURI createSipUri(String string2, String string3, ListeningPoint listeningPoint) throws ParseException {
        AddressFactory addressFactory = this.mAddressFactory;
        String string4 = listeningPoint.getIPAddress();
        SipURI sipURI = addressFactory.createSipURI(string2, string4);
        try {
            int n = listeningPoint.getPort();
            sipURI.setPort(n);
            sipURI.setTransportParam(string3);
            return sipURI;
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new RuntimeException(invalidArgumentException);
        }
    }

    private ToHeader createToHeader(SipProfile sipProfile) throws ParseException {
        return this.createToHeader(sipProfile, null);
    }

    private ToHeader createToHeader(SipProfile sipProfile, String string2) throws ParseException {
        HeaderFactory headerFactory = this.mHeaderFactory;
        Address address = sipProfile.getSipAddress();
        return headerFactory.createToHeader(address, string2);
    }

    private List<ViaHeader> createViaHeaders() throws ParseException, SipException {
        ArrayList<ViaHeader> arrayList = new ArrayList<ViaHeader>(1);
        ListeningPoint listeningPoint = this.getListeningPoint();
        HeaderFactory headerFactory = this.mHeaderFactory;
        String string2 = listeningPoint.getIPAddress();
        int n = listeningPoint.getPort();
        String string3 = listeningPoint.getTransport();
        ViaHeader viaHeader = headerFactory.createViaHeader(string2, n, string3, null);
        viaHeader.setRPort();
        boolean bl = arrayList.add(viaHeader);
        return arrayList;
    }

    private ContactHeader createWildcardContactHeader() {
        ContactHeader contactHeader = this.mHeaderFactory.createContactHeader();
        contactHeader.setWildCard();
        return contactHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCallId(EventObject eventObject) {
        if (eventObject == null) {
            return null;
        }
        if (eventObject instanceof RequestEvent) {
            return SipHelper.getCallId((Message)((RequestEvent)eventObject).getRequest());
        }
        if (eventObject instanceof ResponseEvent) {
            return SipHelper.getCallId((Message)((ResponseEvent)eventObject).getResponse());
        }
        if (eventObject instanceof DialogTerminatedEvent) {
            Dialog dialog = ((DialogTerminatedEvent)eventObject).getDialog();
            return SipHelper.getCallId(((DialogTerminatedEvent)eventObject).getDialog());
        }
        if (eventObject instanceof TransactionTerminatedEvent) {
            ServerTransaction serverTransaction;
            TransactionTerminatedEvent transactionTerminatedEvent = (TransactionTerminatedEvent)eventObject;
            if (transactionTerminatedEvent.isServerTransaction()) {
                serverTransaction = transactionTerminatedEvent.getServerTransaction();
                return SipHelper.getCallId((Transaction)serverTransaction);
            }
            serverTransaction = transactionTerminatedEvent.getClientTransaction();
            return SipHelper.getCallId((Transaction)serverTransaction);
        }
        Object object = eventObject.getSource();
        if (object instanceof Transaction) {
            return SipHelper.getCallId((Transaction)object);
        }
        if (!(object instanceof Dialog)) return "";
        return SipHelper.getCallId((Dialog)object);
    }

    private static String getCallId(Dialog dialog) {
        return dialog.getCallId().getCallId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCallId(Transaction transaction) {
        if (transaction == null) return "";
        return SipHelper.getCallId((Message)transaction.getRequest());
    }

    private static String getCallId(Message message) {
        return ((CallIdHeader)message.getHeader("Call-ID")).getCallId();
    }

    private ListeningPoint getListeningPoint() throws SipException {
        ListeningPoint[] listeningPointArray;
        ListeningPoint listeningPoint = this.mSipProvider.getListeningPoint("UDP");
        if (listeningPoint == null) {
            listeningPoint = this.mSipProvider.getListeningPoint("TCP");
        }
        if (listeningPoint == null && (listeningPointArray = this.mSipProvider.getListeningPoints()) != null && listeningPointArray.length > 0) {
            listeningPoint = listeningPointArray[0];
        }
        if (listeningPoint == null) {
            throw new SipException("no listening point is available");
        }
        return listeningPoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServerTransaction getServerTransaction(RequestEvent requestEvent) throws SipException {
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        if (serverTransaction != null) return serverTransaction;
        Request request = requestEvent.getRequest();
        return this.mSipProvider.getNewServerTransaction(request);
    }

    public ClientTransaction handleChallenge(ResponseEvent responseEvent, AccountManager accountManager) throws SipException {
        SipStackExt sipStackExt = (SipStackExt)this.mSipStack;
        HeaderFactory headerFactory = this.mHeaderFactory;
        AuthenticationHelper authenticationHelper = sipStackExt.getAuthenticationHelper(accountManager, headerFactory);
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Response response = responseEvent.getResponse();
        SipProvider sipProvider = this.mSipProvider;
        ClientTransaction clientTransaction2 = authenticationHelper.handleChallenge(response, clientTransaction, sipProvider, 5);
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("send request with challenge response: ");
        Request request = clientTransaction2.getRequest();
        String string3 = stringBuilder.append(request).toString();
        int n = Log.d(string2, string3);
        clientTransaction2.sendRequest();
        return clientTransaction2;
    }

    public void sendBye(Dialog dialog) throws SipException {
        Request request = dialog.createRequest("BYE");
        String string2 = TAG;
        String string3 = "send BYE: " + request;
        int n = Log.d(string2, string3);
        ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
        dialog.sendRequest(clientTransaction);
    }

    public void sendCancel(ClientTransaction clientTransaction) throws SipException {
        Request request = clientTransaction.createCancel();
        String string2 = TAG;
        String string3 = "send CANCEL: " + request;
        int n = Log.d(string2, string3);
        this.mSipProvider.getNewClientTransaction(request).sendRequest();
    }

    public ClientTransaction sendInvite(SipProfile sipProfile, SipProfile sipProfile2, String string2, String string3) throws SipException {
        try {
            SipHelper sipHelper = this;
            SipProfile sipProfile3 = sipProfile;
            String string4 = string3;
            FromHeader fromHeader = sipHelper.createFromHeader(sipProfile3, string4);
            SipHelper sipHelper2 = this;
            SipProfile sipProfile4 = sipProfile2;
            ToHeader toHeader = sipHelper2.createToHeader(sipProfile4);
            SipURI sipURI = sipProfile2.getUri();
            List<ViaHeader> list = this.createViaHeaders();
            CallIdHeader callIdHeader = this.createCallIdHeader();
            CSeqHeader cSeqHeader = this.createCSeqHeader("INVITE");
            MaxForwardsHeader maxForwardsHeader = this.createMaxForwardsHeader();
            Request request = this.mMessageFactory.createRequest((URI)sipURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, list, maxForwardsHeader);
            ContactHeader contactHeader = this.createContactHeader(sipProfile);
            request.addHeader((Header)contactHeader);
            ContentTypeHeader contentTypeHeader = this.mHeaderFactory.createContentTypeHeader("application", "sdp");
            Request request2 = request;
            String string5 = string2;
            ContentTypeHeader contentTypeHeader2 = contentTypeHeader;
            request2.setContent((Object)string5, contentTypeHeader2);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            String string6 = TAG;
            String string7 = "send INVITE: " + request;
            int n = Log.d(string6, string7);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInvite()", (Throwable)parseException);
        }
    }

    public void sendInviteAck(ResponseEvent responseEvent, Dialog dialog) throws SipException {
        long l = ((CSeqHeader)responseEvent.getResponse().getHeader("CSeq")).getSeqNumber();
        Request request = dialog.createAck(l);
        String string2 = TAG;
        String string3 = "send ACK: " + request;
        int n = Log.d(string2, string3);
        dialog.sendAck(request);
    }

    public void sendInviteBusyHere(RequestEvent requestEvent, ServerTransaction serverTransaction) throws SipException {
        try {
            TransactionState transactionState;
            TransactionState transactionState2;
            Request request = requestEvent.getRequest();
            Response response = this.mMessageFactory.createResponse(486, request);
            if (serverTransaction == null) {
                serverTransaction = this.getServerTransaction(requestEvent);
            }
            if ((transactionState2 = serverTransaction.getState()) == (transactionState = TransactionState.COMPLETED)) {
                return;
            }
            String string2 = TAG;
            String string3 = "send BUSY HERE: " + response;
            int n = Log.d(string2, string3);
            serverTransaction.sendResponse(response);
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteBusyHere()", (Throwable)parseException);
        }
    }

    public ServerTransaction sendInviteOk(RequestEvent requestEvent, SipProfile sipProfile, String string2, ServerTransaction serverTransaction) throws SipException {
        try {
            TransactionState transactionState;
            TransactionState transactionState2;
            Request request = requestEvent.getRequest();
            Response response = this.mMessageFactory.createResponse(200, request);
            ContactHeader contactHeader = this.createContactHeader(sipProfile);
            response.addHeader((Header)contactHeader);
            ContentTypeHeader contentTypeHeader = this.mHeaderFactory.createContentTypeHeader("application", "sdp");
            response.setContent((Object)string2, contentTypeHeader);
            if (serverTransaction == null) {
                serverTransaction = this.getServerTransaction(requestEvent);
            }
            if ((transactionState2 = serverTransaction.getState()) != (transactionState = TransactionState.COMPLETED)) {
                String string3 = TAG;
                String string4 = "send OK: " + response;
                int n = Log.d(string3, string4);
                serverTransaction.sendResponse(response);
            }
            return serverTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteOk()", (Throwable)parseException);
        }
    }

    public void sendInviteRequestTerminated(Request request, ServerTransaction serverTransaction) throws SipException {
        try {
            Response response = this.mMessageFactory.createResponse(487, request);
            String string2 = TAG;
            String string3 = "send response: " + response;
            int n = Log.d(string2, string3);
            serverTransaction.sendResponse(response);
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteRequestTerminated()", (Throwable)parseException);
        }
    }

    public ClientTransaction sendKeepAlive(SipProfile sipProfile, String string2) throws SipException {
        try {
            Request request = this.createRequest("OPTIONS", sipProfile, string2);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (Exception exception) {
            throw new SipException("sendKeepAlive()", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientTransaction sendRegister(SipProfile sipProfile, String string2, int n) throws SipException {
        try {
            Request request = this.createRequest("REGISTER", sipProfile, string2);
            if (n == 0) {
                ContactHeader contactHeader = this.createWildcardContactHeader();
                request.addHeader((Header)contactHeader);
            } else {
                ContactHeader contactHeader = this.createContactHeader(sipProfile);
                request.addHeader((Header)contactHeader);
            }
            ExpiresHeader expiresHeader = this.mHeaderFactory.createExpiresHeader(n);
            request.addHeader((Header)expiresHeader);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendRegister()", (Throwable)parseException);
        }
    }

    public ClientTransaction sendReinvite(Dialog dialog, String string2) throws SipException {
        try {
            Request request = dialog.createRequest("INVITE");
            ContentTypeHeader contentTypeHeader = this.mHeaderFactory.createContentTypeHeader("application", "sdp");
            request.setContent((Object)string2, contentTypeHeader);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            String string3 = TAG;
            String string4 = "send RE-INVITE: " + request;
            int n = Log.d(string3, string4);
            dialog.sendRequest(clientTransaction);
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendReinvite()", (Throwable)parseException);
        }
    }

    public void sendResponse(RequestEvent requestEvent, int n) throws SipException {
        try {
            MessageFactory messageFactory = this.mMessageFactory;
            Request request = requestEvent.getRequest();
            Response response = messageFactory.createResponse(n, request);
            String string2 = TAG;
            String string3 = "send response: " + response;
            int n2 = Log.d(string2, string3);
            this.getServerTransaction(requestEvent).sendResponse(response);
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendResponse()", (Throwable)parseException);
        }
    }

    public ServerTransaction sendRinging(RequestEvent requestEvent, String string2) throws SipException {
        try {
            Request request = requestEvent.getRequest();
            ServerTransaction serverTransaction = this.getServerTransaction(requestEvent);
            Response response = this.mMessageFactory.createResponse(180, request);
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag(string2);
            response.addHeader((Header)toHeader);
            String string3 = TAG;
            String string4 = "send RINGING: " + response;
            int n = Log.d(string3, string4);
            serverTransaction.sendResponse(response);
            return serverTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendRinging()", (Throwable)parseException);
        }
    }
}

