/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSessionAdapter;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.server.sip.SipSessionGroup;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.sip.SipException;

public final class SipService
extends ISipService.Stub {
    private static final boolean DEBUG = false;
    static final boolean DEBUGV = false;
    private static final boolean DEBUG_TIMER = false;
    private static final int EXPIRY_TIME = 3600;
    private static final int MIN_EXPIRY_TIME = 60;
    private static final int SHORT_EXPIRY_TIME = 10;
    static final String TAG = "SipService";
    private boolean mConnected;
    private ConnectivityReceiver mConnectivityReceiver;
    private Context mContext;
    private MyExecutor mExecutor;
    private String mLocalIp;
    private SipWakeLock mMyWakeLock;
    private String mNetworkType;
    private Map<String, ISipSession> mPendingSessions;
    private Map<String, SipSessionGroupExt> mSipGroups;
    private WakeupTimer mTimer;
    private boolean mWifiEnabled;
    private WifiManager.WifiLock mWifiLock;
    private boolean mWifiOnly;
    private WifiScanProcess mWifiScanProcess;
    private BroadcastReceiver mWifiStateReceiver;

    private SipService(Context context) {
        boolean bl;
        WakeupTimer wakeupTimer;
        SipWakeLock sipWakeLock;
        ConnectivityReceiver connectivityReceiver;
        BroadcastReceiver broadcastReceiver;
        HashMap<String, SipSessionGroupExt> hashMap = new HashMap<String, SipSessionGroupExt>();
        this.mSipGroups = hashMap;
        HashMap<String, ISipSession> hashMap2 = new HashMap<String, ISipSession>();
        this.mPendingSessions = hashMap2;
        this.mWifiStateReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if (!"android.net.wifi.WIFI_STATE_CHANGED".equals(string2)) {
                    return;
                }
                int n = intent.getIntExtra("wifi_state", 4);
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    switch (n) {
                        case 3: {
                            boolean bl = SipService.access$102(SipService.this, true);
                            if (SipService.this.anyOpenedToReceiveCalls()) {
                                SipService.this.grabWifiLock();
                            }
                        }
                        default: {
                            break;
                        }
                        case 1: {
                            boolean bl = SipService.access$102(SipService.this, false);
                            SipService.this.releaseWifiLock();
                        }
                    }
                    return;
                }
            }
        };
        this.mContext = context;
        this.mConnectivityReceiver = connectivityReceiver = new ConnectivityReceiver();
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mMyWakeLock = sipWakeLock = new SipWakeLock(powerManager);
        this.mTimer = wakeupTimer = new WakeupTimer(context);
        this.mWifiOnly = bl = SipManager.isSipWifiOnly(context);
    }

    static /* synthetic */ boolean access$102(SipService sipService, boolean bl) {
        sipService.mWifiEnabled = bl;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPendingSession(ISipSession iSipSession) {
        synchronized (this) {
            try {
                this.cleanUpPendingSessions();
                Map<String, ISipSession> map = this.mPendingSessions;
                String string2 = iSipSession.getCallId();
                ISipSession iSipSession2 = map.put(string2, iSipSession);
                return;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(TAG, "addPendingSession()", remoteException);
                return;
            }
            finally {
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anyOpenedToReceiveCalls() {
        Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!iterator.next().isOpenedToReceiveCalls());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean callingSelf(SipSessionGroupExt sipSessionGroupExt, SipSessionGroup.SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            boolean bl;
            SipSessionGroupExt sipSessionGroupExt2;
            String string2 = sipSessionImpl.getCallId();
            Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((sipSessionGroupExt2 = iterator.next()) == sipSessionGroupExt || !(bl = sipSessionGroupExt2.containsSession(string2)));
            return true;
        }
    }

    private void cleanUpPendingSessions() throws RemoteException {
        Set<Map.Entry<String, ISipSession>> set = this.mPendingSessions.entrySet();
        Map.Entry[] entryArray = new Map.Entry[this.mPendingSessions.size()];
        Map.Entry[] entryArray2 = set.toArray(entryArray);
        int n = entryArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = entryArray2[n2];
            if (((ISipSession)entry.getValue()).getState() != 3) {
                Map<String, ISipSession> map = this.mPendingSessions;
                Object k = entry.getKey();
                ISipSession iSipSession = map.remove(k);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SipSessionGroupExt createGroup(SipProfile sipProfile) throws SipException {
        String string2 = sipProfile.getUriString();
        SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
        if (sipSessionGroupExt == null) {
            sipSessionGroupExt = new SipSessionGroupExt(sipProfile, null, null);
            SipSessionGroupExt sipSessionGroupExt2 = this.mSipGroups.put(string2, sipSessionGroupExt);
            this.notifyProfileAdded(sipProfile);
            return sipSessionGroupExt;
        } else {
            if (this.isCallerCreator(sipSessionGroupExt)) return sipSessionGroupExt;
            throw new SipException("only creator can access the profile");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SipSessionGroupExt createGroup(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) throws SipException {
        String string2 = sipProfile.getUriString();
        SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
        if (sipSessionGroupExt != null) {
            if (!this.isCallerCreator(sipSessionGroupExt)) {
                throw new SipException("only creator can access the profile");
            }
            sipSessionGroupExt.setIncomingCallPendingIntent(pendingIntent);
            sipSessionGroupExt.setListener(iSipSessionListener);
            return sipSessionGroupExt;
        }
        sipSessionGroupExt = new SipSessionGroupExt(sipProfile, pendingIntent, iSipSessionListener);
        SipSessionGroupExt sipSessionGroupExt2 = this.mSipGroups.put(string2, sipSessionGroupExt);
        this.notifyProfileAdded(sipProfile);
        return sipSessionGroupExt;
    }

    private static Looper createLooper() {
        HandlerThread handlerThread = new HandlerThread("SipService.Executor");
        handlerThread.start();
        return handlerThread.getLooper();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String determineLocalIp() {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            InetAddress inetAddress = InetAddress.getByName("192.168.1.1");
            datagramSocket.connect(inetAddress, 80);
            String string2 = datagramSocket.getLocalAddress().getHostAddress();
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private MyExecutor getExecutor() {
        if (this.mExecutor == null) {
            MyExecutor myExecutor;
            this.mExecutor = myExecutor = new MyExecutor();
        }
        return this.mExecutor;
    }

    private void grabWifiLock() {
        WifiManager.WifiLock wifiLock;
        if (this.mWifiLock != null) {
            return;
        }
        this.mWifiLock = wifiLock = ((WifiManager)this.mContext.getSystemService("wifi")).createWifiLock(1, TAG);
        this.mWifiLock.acquire();
        if (this.mConnected) {
            return;
        }
        this.startWifiScanner();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCallerCreator(SipSessionGroupExt sipSessionGroupExt) {
        int n;
        int n2 = sipSessionGroupExt.getLocalProfile().getCallingUid();
        if (n2 == (n = Binder.getCallingUid())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCallerCreatorOrRadio(SipSessionGroupExt sipSessionGroupExt) {
        if (this.isCallerRadio()) return true;
        if (!this.isCallerCreator(sipSessionGroupExt)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCallerRadio() {
        if (Binder.getCallingUid() != 1001) return false;
        return true;
    }

    private void notifyProfileAdded(SipProfile sipProfile) {
        Intent intent = new Intent("com.android.phone.SIP_ADD_PHONE");
        String string2 = sipProfile.getUriString();
        Intent intent2 = intent.putExtra("android:localSipUri", string2);
        this.mContext.sendBroadcast(intent);
    }

    private void notifyProfileRemoved(SipProfile sipProfile) {
        Intent intent = new Intent("com.android.phone.SIP_REMOVE_PHONE");
        String string2 = sipProfile.getUriString();
        Intent intent2 = intent.putExtra("android:localSipUri", string2);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onConnectivityChanged(String string2, boolean bl) {
        synchronized (this) {
            block17: {
                boolean bl2;
                String string3 = this.mNetworkType;
                boolean bl3 = bl2 = string2.equals(string3);
                if (bl3 || bl) {
                    boolean bl4;
                    block16: {
                        String string4 = this.mNetworkType;
                        boolean bl5 = "WIFI".equalsIgnoreCase(string4);
                        bl2 = "WIFI".equalsIgnoreCase(string2);
                        bl4 = bl2;
                        if (bl4 && !bl || bl5 && !bl3) {
                            boolean bl6 = true;
                        } else {
                            boolean bl7 = false;
                        }
                        if (bl4 && bl) {
                            boolean bl8 = true;
                        } else {
                            boolean bl9 = false;
                        }
                        try {
                            String string5;
                            Iterator<SipSessionGroupExt> iterator;
                            boolean bl10 = this.mConnected;
                            this.mNetworkType = string2;
                            this.mConnected = bl;
                            if (bl10) {
                                this.mLocalIp = null;
                                iterator = this.mSipGroups.values().iterator();
                                while (iterator.hasNext()) {
                                    iterator.next().onConnectivityChanged(false);
                                }
                            }
                            if (!bl) break block16;
                            this.mLocalIp = string5 = this.determineLocalIp();
                            iterator = this.mSipGroups.values().iterator();
                            while (iterator.hasNext()) {
                                iterator.next().onConnectivityChanged(true);
                            }
                        }
                        catch (SipException sipException) {
                            int n = Log.e(TAG, "onConnectivityChanged()", sipException);
                            break block17;
                        }
                        if (bl4 && this.mWifiLock != null) {
                            this.stopWifiScanner();
                        }
                        break block17;
                    }
                    this.mMyWakeLock.reset();
                    if (bl4 && this.mWifiLock != null) {
                        this.startWifiScanner();
                    }
                }
            }
            return;
        }
    }

    private void registerReceivers() {
        Context context = this.mContext;
        ConnectivityReceiver connectivityReceiver = this.mConnectivityReceiver;
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        Intent intent = context.registerReceiver(connectivityReceiver, intentFilter);
        Context context2 = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mWifiStateReceiver;
        IntentFilter intentFilter2 = new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED");
        Intent intent2 = context2.registerReceiver(broadcastReceiver, intentFilter2);
    }

    private void releaseWifiLock() {
        if (this.mWifiLock == null) {
            return;
        }
        this.mWifiLock.release();
        this.mWifiLock = null;
        this.stopWifiScanner();
    }

    public static void start(Context context) {
        if (!SipManager.isApiSupported(context)) {
            return;
        }
        SipService sipService = new SipService(context);
        ServiceManager.addService("sip", sipService);
        Intent intent = new Intent("android.net.sip.SIP_SERVICE_UP");
        context.sendBroadcast(intent);
    }

    private void startWifiScanner() {
        synchronized (this) {
            if (this.mWifiScanProcess == null) {
                WifiScanProcess wifiScanProcess;
                this.mWifiScanProcess = wifiScanProcess = new WifiScanProcess();
            }
            this.mWifiScanProcess.start();
            return;
        }
    }

    private void stopWifiScanner() {
        synchronized (this) {
            if (this.mWifiScanProcess != null) {
                this.mWifiScanProcess.stop();
            }
            return;
        }
    }

    private void unregisterReceivers() {
        Context context = this.mContext;
        ConnectivityReceiver connectivityReceiver = this.mConnectivityReceiver;
        context.unregisterReceiver(connectivityReceiver);
        Context context2 = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mWifiStateReceiver;
        context2.unregisterReceiver(broadcastReceiver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(String string2) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
            if (sipSessionGroupExt != null) {
                if (!this.isCallerCreatorOrRadio(sipSessionGroupExt)) {
                    int n = Log.w(TAG, "only creator or radio can close this profile");
                } else {
                    SipSessionGroupExt sipSessionGroupExt2 = this.mSipGroups.remove(string2);
                    SipProfile sipProfile = sipSessionGroupExt2.getLocalProfile();
                    this.notifyProfileRemoved(sipProfile);
                    sipSessionGroupExt2.close();
                    if (!this.anyOpenedToReceiveCalls()) {
                        this.releaseWifiLock();
                        this.mMyWakeLock.reset();
                    }
                    if (this.mSipGroups.isEmpty()) {
                        this.unregisterReceivers();
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISipSession createSession(SipProfile sipProfile, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                int n = Binder.getCallingUid();
                sipProfile.setCallingUid(n);
                boolean bl = this.mConnected;
                if (bl) break block5;
                return null;
            }
            try {
                ISipSession iSipSession = this.createGroup(sipProfile).createSession(iSipSessionListener);
                return iSipSession;
            }
            catch (SipException sipException) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SipProfile[] getListOfProfiles() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            boolean bl = this.isCallerRadio();
            ArrayList<SipProfile> arrayList = new ArrayList<SipProfile>();
            Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SipProfile[] sipProfileArray = new SipProfile[arrayList.size()];
                    return arrayList.toArray(sipProfileArray);
                }
                SipSessionGroupExt sipSessionGroupExt = iterator.next();
                if (!bl && !this.isCallerCreator(sipSessionGroupExt)) continue;
                SipProfile sipProfile = sipSessionGroupExt.getLocalProfile();
                boolean bl2 = arrayList.add(sipProfile);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISipSession getPendingSession(String string2) {
        synchronized (this) {
            block6: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                if (string2 != null) break block6;
                return null;
            }
            ISipSession iSipSession = this.mPendingSessions.get(string2);
            return iSipSession;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpened(String string2) {
        synchronized (this) {
            SipSessionGroupExt sipSessionGroupExt;
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                sipSessionGroupExt = this.mSipGroups.get(string2);
                if (sipSessionGroupExt != null) break block5;
                return false;
            }
            if (this.isCallerCreatorOrRadio(sipSessionGroupExt)) {
                return true;
            }
            int n = Log.w(TAG, "only creator or radio can query on the profile");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRegistered(String string2) {
        synchronized (this) {
            SipSessionGroupExt sipSessionGroupExt;
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                sipSessionGroupExt = this.mSipGroups.get(string2);
                if (sipSessionGroupExt != null) break block5;
                return false;
            }
            if (this.isCallerCreatorOrRadio(sipSessionGroupExt)) {
                return sipSessionGroupExt.isRegistered();
            }
            int n = Log.w(TAG, "only creator or radio can query on the profile");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void open(SipProfile sipProfile) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            int n = Binder.getCallingUid();
            sipProfile.setCallingUid(n);
            try {
                boolean bl = this.mSipGroups.isEmpty();
                SipSessionGroupExt sipSessionGroupExt = this.createGroup(sipProfile);
                if (bl && !this.mSipGroups.isEmpty()) {
                    this.registerReceivers();
                }
                return;
            }
            catch (SipException sipException) {
                try {
                    int n2 = Log.e(TAG, "openToMakeCalls()", sipException);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open3(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            block8: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                int n = Binder.getCallingUid();
                sipProfile.setCallingUid(n);
                if (pendingIntent == null) {
                    int n2 = Log.w(TAG, "incomingCallPendingIntent cannot be null; the profile is not opened");
                } else {
                    try {
                        boolean bl = this.mSipGroups.isEmpty();
                        SipSessionGroupExt sipSessionGroupExt = this.createGroup(sipProfile, pendingIntent, iSipSessionListener);
                        if (bl && !this.mSipGroups.isEmpty()) {
                            this.registerReceivers();
                        }
                        if (!sipProfile.getAutoRegistration()) break block8;
                        sipSessionGroupExt.openToReceiveCalls();
                        if (this.mWifiEnabled) {
                            this.grabWifiLock();
                        }
                    }
                    catch (SipException sipException) {
                        int n3 = Log.e(TAG, "openToReceiveCalls()", sipException);
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRegistrationListener(String string2, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
            if (sipSessionGroupExt != null) {
                if (this.isCallerCreator(sipSessionGroupExt)) {
                    sipSessionGroupExt.setListener(iSipSessionListener);
                } else {
                    int n = Log.w(TAG, "only creator can set listener on the profile");
                }
            }
            return;
        }
    }

    private class MyExecutor
    extends Handler {
        MyExecutor() {
            Looper looper = SipService.createLooper();
            super(looper);
        }

        /*
         * Unable to fully structure code
         */
        private void executeInternal(Runnable var1_1) {
            try {
                var1_1.run();
            }
            catch (Throwable var3_3) {
                try {
                    var4_4 = "run task: " + var1_1;
                    var5_5 = Log.e("SipService", var4_4, var3_3);
                }
                catch (Throwable var6_6) {
                    SipService.access$700(SipService.this).release(var1_1);
                    throw var6_6;
                }
                var2_2 = SipService.access$700(SipService.this);
                ** continue;
            }
            var2_2 = SipService.access$700(SipService.this);
lbl4:
            // 2 sources

            while (true) {
                var2_2.release(var1_1);
                return;
            }
        }

        void execute(Runnable runnable) {
            SipService.this.mMyWakeLock.acquire(runnable);
            Message.obtain(this, 0, runnable).sendToTarget();
        }

        @Override
        public void handleMessage(Message message) {
            if (message.obj instanceof Runnable) {
                Runnable runnable = (Runnable)message.obj;
                this.executeInternal(runnable);
                return;
            }
            String string2 = "can't handle msg: " + message;
            int n = Log.w(SipService.TAG, string2);
        }
    }

    private static class MyEventComparator
    implements Comparator<MyEvent> {
        private MyEventComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(MyEvent myEvent, MyEvent myEvent2) {
            if (myEvent == myEvent2) {
                return 0;
            }
            int n = myEvent.mMaxPeriod;
            int n2 = myEvent2.mMaxPeriod;
            int n3 = n - n2;
            if (n3 != 0) return n3;
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (this != object) return false;
            return true;
        }
    }

    private static class MyEvent {
        Runnable mCallback;
        long mLastTriggerTime;
        int mMaxPeriod;
        int mPeriod;
        long mTriggerTime;

        MyEvent(int n, Runnable runnable, long l) {
            this.mMaxPeriod = n;
            this.mPeriod = n;
            this.mCallback = runnable;
            this.mLastTriggerTime = l;
        }

        private String toString(Object object) {
            String string2 = object.toString();
            int n = string2.indexOf("$");
            if (n > 0) {
                int n2 = n + 1;
                string2 = string2.substring(n2);
            }
            return string2;
        }

        public String toString() {
            String string2 = super.toString();
            int n = string2.indexOf("@");
            String string3 = string2.substring(n);
            StringBuilder stringBuilder = new StringBuilder().append(string3).append(":");
            int n2 = this.mPeriod / 1000;
            StringBuilder stringBuilder2 = stringBuilder.append(n2).append(":");
            int n3 = this.mMaxPeriod / 1000;
            StringBuilder stringBuilder3 = stringBuilder2.append(n3).append(":");
            Runnable runnable = this.mCallback;
            String string4 = this.toString(runnable);
            return stringBuilder3.append(string4).toString();
        }
    }

    class WakeupTimer
    extends BroadcastReceiver {
        private static final String TAG = "_SIP.WkTimer_";
        private static final String TRIGGER_TIME = "TriggerTime";
        private AlarmManager mAlarmManager;
        private Context mContext;
        private TreeSet<MyEvent> mEventQueue;
        private PendingIntent mPendingIntent;

        public WakeupTimer(Context context) {
            AlarmManager alarmManager;
            MyEventComparator myEventComparator = new MyEventComparator();
            TreeSet<MyEvent> treeSet = new TreeSet<MyEvent>(myEventComparator);
            this.mEventQueue = treeSet;
            this.mContext = context;
            this.mAlarmManager = alarmManager = (AlarmManager)context.getSystemService("alarm");
            String string2 = this.getAction();
            IntentFilter intentFilter = new IntentFilter(string2);
            Intent intent = context.registerReceiver(this, intentFilter);
        }

        private void cancelAlarm() {
            AlarmManager alarmManager = this.mAlarmManager;
            PendingIntent pendingIntent = this.mPendingIntent;
            alarmManager.cancel(pendingIntent);
            this.mPendingIntent = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void execute(long l) {
            synchronized (this) {
                block7: {
                    boolean bl;
                    if (this.stopped() || (bl = this.mEventQueue.isEmpty())) break block7;
                    Iterator<MyEvent> iterator = this.mEventQueue.iterator();
                    while (true) {
                        long l2;
                        long l3;
                        MyEvent myEvent;
                        block9: {
                            block8: {
                                if (!iterator.hasNext()) break block8;
                                myEvent = iterator.next();
                                if (myEvent.mTriggerTime == l) break block9;
                            }
                            this.scheduleNext();
                            break;
                        }
                        myEvent.mLastTriggerTime = l3 = myEvent.mTriggerTime;
                        long l4 = myEvent.mTriggerTime;
                        long l5 = myEvent.mPeriod;
                        myEvent.mTriggerTime = l2 = l4 + l5;
                        MyExecutor myExecutor = SipService.this.getExecutor();
                        Runnable runnable = myEvent.mCallback;
                        myExecutor.execute(runnable);
                    }
                }
                return;
            }
        }

        private String getAction() {
            return this.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void insertEvent(MyEvent myEvent) {
            long l = SystemClock.elapsedRealtime();
            if (this.mEventQueue.isEmpty()) {
                long l2;
                myEvent.mTriggerTime = l2 = (long)myEvent.mPeriod + l;
                boolean bl = this.mEventQueue.add(myEvent);
                return;
            }
            MyEvent myEvent2 = this.mEventQueue.first();
            int n = myEvent2.mPeriod;
            int n2 = myEvent.mMaxPeriod;
            if (n <= n2) {
                long l3;
                int n3;
                myEvent.mPeriod = n3 = myEvent.mMaxPeriod / n * n;
                int n4 = myEvent.mMaxPeriod;
                int n5 = (int)(myEvent2.mTriggerTime - l);
                int n6 = (n4 - n5) / n * n;
                long l4 = myEvent2.mTriggerTime;
                long l5 = n6;
                myEvent.mTriggerTime = l3 = l4 + l5;
                boolean bl = this.mEventQueue.add(myEvent);
                return;
            }
            long l6 = myEvent.mPeriod;
            long l7 = l + l6;
            if (myEvent2.mTriggerTime < l7) {
                long l8;
                long l9;
                myEvent.mTriggerTime = l9 = myEvent2.mTriggerTime;
                long l10 = myEvent.mLastTriggerTime;
                long l11 = myEvent.mPeriod;
                myEvent.mLastTriggerTime = l8 = l10 - l11;
            } else {
                myEvent.mTriggerTime = l7;
            }
            boolean bl = this.mEventQueue.add(myEvent);
            this.recalculatePeriods();
        }

        private void printQueue() {
            int n = 0;
            for (MyEvent myEvent : this.mEventQueue) {
                StringBuilder stringBuilder = new StringBuilder().append("     ").append(myEvent).append(": scheduled at ");
                long l = myEvent.mTriggerTime;
                String string2 = this.showTime(l);
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": last at ");
                long l2 = myEvent.mLastTriggerTime;
                String string3 = this.showTime(l2);
                String string4 = stringBuilder2.append(string3).toString();
                int n2 = Log.d(TAG, string4);
                if (++n < 5) continue;
            }
            if (this.mEventQueue.size() > n) {
                int n3 = Log.d(TAG, "     .....");
                return;
            }
            if (n != 0) {
                return;
            }
            int n4 = Log.d(TAG, "     <empty>");
        }

        private void recalculatePeriods() {
            if (this.mEventQueue.isEmpty()) {
                return;
            }
            MyEvent myEvent = this.mEventQueue.first();
            int n = myEvent.mMaxPeriod;
            long l = myEvent.mTriggerTime;
            for (MyEvent myEvent2 : this.mEventQueue) {
                long l2;
                int n2;
                myEvent2.mPeriod = n2 = myEvent2.mMaxPeriod / n * n;
                long l3 = myEvent2.mLastTriggerTime;
                long l4 = myEvent2.mMaxPeriod;
                myEvent2.mTriggerTime = l2 = (long)((int)(l3 + l4 - l) / n * n) + l;
            }
            Comparator<MyEvent> comparator = this.mEventQueue.comparator();
            TreeSet<MyEvent> treeSet = new TreeSet<MyEvent>(comparator);
            TreeSet<MyEvent> treeSet2 = this.mEventQueue;
            boolean bl = treeSet.addAll(treeSet2);
            this.mEventQueue.clear();
            this.mEventQueue = treeSet;
        }

        private void scheduleNext() {
            PendingIntent pendingIntent;
            if (this.stopped()) {
                return;
            }
            if (this.mEventQueue.isEmpty()) {
                return;
            }
            if (this.mPendingIntent != null) {
                throw new RuntimeException("pendingIntent is not null!");
            }
            MyEvent myEvent = this.mEventQueue.first();
            String string2 = this.getAction();
            Intent intent = new Intent(string2);
            long l = myEvent.mTriggerTime;
            Intent intent2 = intent.putExtra(TRIGGER_TIME, l);
            this.mPendingIntent = pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
            AlarmManager alarmManager = this.mAlarmManager;
            long l2 = myEvent.mTriggerTime;
            alarmManager.set(2, l2, pendingIntent);
        }

        private String showTime(long l) {
            int n = (int)(l % 1000L);
            int n2 = (int)(l / 1000L);
            int n3 = n2 / 60;
            int n4 = n2 % 60;
            Object[] objectArray = new Object[3];
            Integer n5 = n3;
            objectArray[0] = n5;
            Integer n6 = n4;
            objectArray[1] = n6;
            Integer n7 = n;
            objectArray[2] = n7;
            return String.format("%d.%d.%d", objectArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean stopped() {
            synchronized (this) {
                if (this.mEventQueue != null) return false;
                int n = Log.w(TAG, "Timer stopped");
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void cancel(Runnable runnable) {
            synchronized (this) {
                boolean bl;
                if (!this.stopped() && !(bl = this.mEventQueue.isEmpty())) {
                    MyEvent myEvent = this.mEventQueue.first();
                    Iterator<MyEvent> iterator = this.mEventQueue.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().mCallback != runnable) continue;
                        iterator.remove();
                    }
                    if (this.mEventQueue.isEmpty()) {
                        this.cancelAlarm();
                    } else if (this.mEventQueue.first() != myEvent) {
                        long l;
                        int n;
                        this.cancelAlarm();
                        MyEvent myEvent2 = this.mEventQueue.first();
                        myEvent2.mPeriod = n = myEvent2.mMaxPeriod;
                        long l2 = myEvent2.mLastTriggerTime;
                        long l3 = myEvent2.mPeriod;
                        myEvent2.mTriggerTime = l = l2 + l3;
                        this.recalculatePeriods();
                        this.scheduleNext();
                    }
                }
                return;
            }
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (this.getAction().equals(string2) && intent.getExtras().containsKey(TRIGGER_TIME)) {
                this.mPendingIntent = null;
                long l = intent.getLongExtra(TRIGGER_TIME, 65535L);
                this.execute(l);
                return;
            }
            String string3 = "unrecognized intent: " + intent;
            int n = Log.d(TAG, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(int n, Runnable runnable) {
            synchronized (this) {
                block8: {
                    boolean bl = this.stopped();
                    if (!bl) break block8;
                    return;
                }
                long l = SystemClock.elapsedRealtime();
                MyEvent myEvent = new MyEvent(n, runnable, l);
                this.insertEvent(myEvent);
                if (this.mEventQueue.first() == myEvent) {
                    if (this.mEventQueue.size() > 1) {
                        this.cancelAlarm();
                    }
                    this.scheduleNext();
                }
                long l2 = myEvent.mTriggerTime;
                return;
            }
        }

        public void stop() {
            synchronized (this) {
                this.mContext.unregisterReceiver(this);
                if (this.mPendingIntent != null) {
                    AlarmManager alarmManager = this.mAlarmManager;
                    PendingIntent pendingIntent = this.mPendingIntent;
                    alarmManager.cancel(pendingIntent);
                    this.mPendingIntent = null;
                }
                this.mEventQueue.clear();
                this.mEventQueue = null;
                return;
            }
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private MyTimerTask mTask;
        private Timer mTimer;

        private ConnectivityReceiver() {
            Timer timer;
            this.mTimer = timer = new Timer();
        }

        static /* synthetic */ MyTimerTask access$1902(ConnectivityReceiver connectivityReceiver, MyTimerTask myTimerTask) {
            connectivityReceiver.mTask = myTimerTask;
            return myTimerTask;
        }

        private NetworkInfo getActiveNetworkInfo() {
            return ((ConnectivityManager)SipService.this.mContext.getSystemService("connectivity")).getActiveNetworkInfo();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void onChanged(String string2, boolean bl) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (bl) {
                    MyTimerTask myTimerTask;
                    if (this.mTask != null) {
                        boolean bl2 = this.mTask.cancel();
                        SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                        MyTimerTask myTimerTask2 = this.mTask;
                        sipWakeLock.release(myTimerTask2);
                    }
                    this.mTask = myTimerTask = new MyTimerTask(string2, bl);
                    Timer timer = this.mTimer;
                    MyTimerTask myTimerTask3 = this.mTask;
                    timer.schedule((TimerTask)myTimerTask3, 2000L);
                    SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                    MyTimerTask myTimerTask4 = this.mTask;
                    sipWakeLock.acquire(myTimerTask4);
                } else {
                    if (this.mTask != null && this.mTask.mNetworkType.equals(string2)) {
                        boolean bl3 = this.mTask.cancel();
                        SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                        MyTimerTask myTimerTask = this.mTask;
                        sipWakeLock.release(myTimerTask);
                    }
                    SipService.this.onConnectivityChanged(string2, false);
                }
                return;
            }
        }

        private void onReceiveInternal(Context context, Intent intent) {
            int n;
            int n2;
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return;
            }
            NetworkInfo networkInfo = (NetworkInfo)bundle.get("networkInfo");
            String string2 = networkInfo.getTypeName();
            NetworkInfo.State state = networkInfo.getState();
            if (SipService.this.mWifiOnly && networkInfo.getType() != 1) {
                return;
            }
            NetworkInfo networkInfo2 = this.getActiveNetworkInfo();
            NetworkInfo.State state2 = NetworkInfo.State.CONNECTED;
            if (state == state2 && networkInfo2 != null && (n2 = networkInfo2.getType()) != (n = networkInfo.getType())) {
                return;
            }
            NetworkInfo.State state3 = NetworkInfo.State.CONNECTED;
            if (state == state3) {
                this.onChanged(string2, true);
                return;
            }
            NetworkInfo.State state4 = NetworkInfo.State.DISCONNECTED;
            if (state != state4) {
                return;
            }
            this.onChanged(string2, false);
        }

        @Override
        public void onReceive(final Context context, final Intent intent) {
            MyExecutor myExecutor = SipService.this.getExecutor();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ConnectivityReceiver connectivityReceiver = ConnectivityReceiver.this;
                    Context context2 = context;
                    Intent intent2 = intent;
                    connectivityReceiver.onReceiveInternal(context2, intent2);
                }
            };
            myExecutor.execute(runnable);
        }

        private class MyTimerTask
        extends TimerTask {
            private boolean mConnected;
            private String mNetworkType;

            public MyTimerTask(String string2, boolean bl) {
                this.mNetworkType = string2;
                this.mConnected = bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void realRun() {
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    if (ConnectivityReceiver.this.mTask == this) {
                        MyTimerTask myTimerTask = ConnectivityReceiver.access$1902(ConnectivityReceiver.this, null);
                        SipService sipService2 = SipService.this;
                        String string2 = this.mNetworkType;
                        boolean bl = this.mConnected;
                        sipService2.onConnectivityChanged(string2, bl);
                        SipService.this.mMyWakeLock.release(this);
                        return;
                    }
                    String string3 = SipService.TAG;
                    StringBuilder stringBuilder = new StringBuilder().append("  unexpected task: ");
                    String string4 = this.mNetworkType;
                    StringBuilder stringBuilder2 = stringBuilder.append(string4);
                    String string5 = this.mConnected ? " CONNECTED" : "DISCONNECTED";
                    String string6 = stringBuilder2.append(string5).toString();
                    int n = Log.w(string3, string6);
                    SipService.this.mMyWakeLock.release(this);
                    return;
                }
            }

            @Override
            public void run() {
                MyExecutor myExecutor = SipService.this.getExecutor();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MyTimerTask.this.realRun();
                    }
                };
                myExecutor.execute(runnable);
            }
        }
    }

    private class AutoRegistrationProcess
    extends SipSessionAdapter
    implements Runnable {
        private int mBackoff;
        private int mErrorCode;
        private String mErrorMessage;
        private long mExpiryTime;
        private KeepAliveProcess mKeepAliveProcess;
        private SipSessionListenerProxy mProxy;
        private boolean mRegistered;
        private boolean mRunning;
        private SipSessionGroup.SipSessionImpl mSession;

        private AutoRegistrationProcess() {
            SipSessionListenerProxy sipSessionListenerProxy;
            this.mProxy = sipSessionListenerProxy = new SipSessionListenerProxy();
            this.mBackoff = 1;
            this.mRunning = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int backoffDuration() {
            int n;
            int n2 = this.mBackoff * 10;
            if (n2 > 3600) {
                return 3600;
            }
            this.mBackoff = n = this.mBackoff * 2;
            return n2;
        }

        private String getAction() {
            return this.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isBehindNAT(String string2) {
            try {
                byte[] byArray = InetAddress.getByName(string2).getAddress();
                if (byArray[0] == 10) return true;
                if ((byArray[0] & 0xFF) == 172) {
                    if ((byArray[1] & 0xF0) == 16) return true;
                }
                if ((byArray[0] & 0xFF) != 192) return false;
                byte by = byArray[1];
                if ((by & 0xFF) != 168) return false;
                return true;
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = "isBehindAT()" + string2;
                int n = Log.e(SipService.TAG, string3, unknownHostException);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean notCurrentSession(ISipSession iSipSession) {
            SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
            if (iSipSession != sipSessionImpl) {
                ((SipSessionGroup.SipSessionImpl)iSipSession).setListener(null);
                SipService.this.mMyWakeLock.release(iSipSession);
                return true;
            }
            if (this.mRunning) return false;
            return true;
        }

        private void restart(int n) {
            SipService.this.mTimer.cancel(this);
            WakeupTimer wakeupTimer = SipService.this.mTimer;
            int n2 = n * 1000;
            wakeupTimer.set(n2, this);
        }

        private void restartLater() {
            this.mRegistered = false;
            int n = this.backoffDuration();
            this.restart(n);
            if (this.mKeepAliveProcess == null) {
                return;
            }
            this.mKeepAliveProcess.stop();
            this.mKeepAliveProcess = null;
        }

        public boolean isRegistered() {
            return this.mRegistered;
        }

        @Override
        public void onRegistering(ISipSession iSipSession) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mRegistered = false;
                this.mProxy.onRegistering(iSipSession);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistrationDone(ISipSession iSipSession, int n) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mProxy.onRegistrationDone(iSipSession, n);
                if (n > 0) {
                    long l;
                    this.mSession.clearReRegisterRequired();
                    long l2 = SystemClock.elapsedRealtime();
                    long l3 = n * 1000;
                    this.mExpiryTime = l = l2 + l3;
                    if (!this.mRegistered) {
                        this.mRegistered = true;
                        if ((n += -60) < 60) {
                            n = 60;
                        }
                        this.restart(n);
                        String string2 = SipService.this.mLocalIp;
                        if (this.isBehindNAT(string2) || this.mSession.getLocalProfile().getSendKeepAlive()) {
                            if (this.mKeepAliveProcess == null) {
                                KeepAliveProcess keepAliveProcess;
                                SipService sipService2 = SipService.this;
                                SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                                this.mKeepAliveProcess = keepAliveProcess = sipService2.new KeepAliveProcess(sipSessionImpl);
                            }
                            this.mKeepAliveProcess.start();
                        }
                    }
                    SipService.this.mMyWakeLock.release(iSipSession);
                } else {
                    boolean bl;
                    this.mRegistered = bl = false;
                    this.mExpiryTime = 65535L;
                    this.run();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistrationFailed(ISipSession iSipSession, int n, String string2) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                switch (n) {
                    default: {
                        this.restartLater();
                        break;
                    }
                    case -12: 
                    case -8: {
                        this.stop();
                    }
                }
                this.mErrorCode = n;
                this.mErrorMessage = string2;
                this.mProxy.onRegistrationFailed(iSipSession, n, string2);
                SipService.this.mMyWakeLock.release(iSipSession);
                return;
            }
        }

        @Override
        public void onRegistrationTimeout(ISipSession iSipSession) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mErrorCode = -1;
                this.mProxy.onRegistrationTimeout(iSipSession);
                this.restartLater();
                SipService.this.mMyWakeLock.release(iSipSession);
                return;
            }
        }

        @Override
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                this.mErrorCode = 0;
                this.mErrorMessage = null;
                if (SipService.this.mConnected) {
                    SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                    SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                    sipWakeLock.acquire(sipSessionImpl);
                    this.mSession.register(3600);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setListener(ISipSessionListener iSipSessionListener) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                block11: {
                    int n;
                    block12: {
                        block13: {
                            this.mProxy.setListener(iSipSessionListener);
                            try {
                                n = this.mSession == null ? 0 : this.mSession.getState();
                                if (n == 1 || n == 2) {
                                    SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                                    SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                                    sipSessionListenerProxy.onRegistering(sipSessionImpl);
                                    break block11;
                                }
                                if (this.mRegistered) {
                                    long l = this.mExpiryTime;
                                    long l2 = SystemClock.elapsedRealtime();
                                    int n2 = (int)(l - l2);
                                    SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                                    SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                                    sipSessionListenerProxy.onRegistrationDone(sipSessionImpl, n2);
                                }
                                if (this.mErrorCode == 0) break block12;
                                if (this.mErrorCode != -1) break block13;
                                SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                                SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                                sipSessionListenerProxy.onRegistrationTimeout(sipSessionImpl);
                                break block11;
                            }
                            catch (Throwable throwable) {
                                String string2 = "setListener(): " + throwable;
                                int n3 = Log.w(SipService.TAG, string2);
                            }
                            break block11;
                        }
                        SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                        SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                        int n4 = this.mErrorCode;
                        String string3 = this.mErrorMessage;
                        sipSessionListenerProxy.onRegistrationFailed(sipSessionImpl, n4, string3);
                        break block11;
                    }
                    if (!SipService.this.mConnected) {
                        SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                        SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                        sipSessionListenerProxy.onRegistrationFailed(sipSessionImpl, 65526, "no data connection");
                    } else if (!this.mRunning) {
                        SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                        SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                        sipSessionListenerProxy.onRegistrationFailed(sipSessionImpl, -1, "registration not running");
                    } else {
                        SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                        SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
                        String string4 = String.valueOf(n);
                        sipSessionListenerProxy.onRegistrationFailed(sipSessionImpl, 65527, string4);
                    }
                }
                return;
            }
        }

        public void start(SipSessionGroup sipSessionGroup) {
            SipSessionGroup.SipSessionImpl sipSessionImpl;
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            this.mBackoff = 1;
            this.mSession = sipSessionImpl = (SipSessionGroup.SipSessionImpl)sipSessionGroup.createSession(this);
            if (this.mSession == null) {
                return;
            }
            SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
            SipSessionGroup.SipSessionImpl sipSessionImpl2 = this.mSession;
            sipWakeLock.acquire(sipSessionImpl2);
            this.mSession.unregister();
        }

        public void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
            SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession;
            sipWakeLock.release(sipSessionImpl);
            if (this.mSession != null) {
                this.mSession.setListener(null);
                if (SipService.this.mConnected && this.mRegistered) {
                    this.mSession.unregister();
                }
            }
            SipService.this.mTimer.cancel(this);
            if (this.mKeepAliveProcess != null) {
                this.mKeepAliveProcess.stop();
                this.mKeepAliveProcess = null;
            }
            this.mRegistered = false;
            ISipSessionListener iSipSessionListener = this.mProxy.getListener();
            this.setListener(iSipSessionListener);
        }
    }

    private class KeepAliveProcess
    implements Runnable {
        private static final int INTERVAL = 10;
        private static final String TAG = "\\KEEPALIVE/";
        private boolean mRunning = false;
        private SipSessionGroup.SipSessionImpl mSession;

        public KeepAliveProcess(SipSessionGroup.SipSessionImpl sipSessionImpl) {
            this.mSession = sipSessionImpl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                SipSessionGroup.SipSessionImpl sipSessionImpl;
                if (!this.mRunning) {
                    return;
                }
                SipSessionGroup.SipSessionImpl sipSessionImpl2 = sipSessionImpl = this.mSession.duplicate();
                try {
                    sipSessionImpl2.sendKeepAlive();
                    if (sipSessionImpl2.isReRegisterRequired()) {
                        SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                        SipSessionGroup.SipSessionImpl sipSessionImpl3 = this.mSession;
                        sipWakeLock.acquire(sipSessionImpl3);
                        this.mSession.register(3600);
                    }
                }
                catch (Throwable throwable) {
                    String string2 = "keepalive error: " + throwable;
                    int n = Log.w(TAG, string2);
                }
                return;
            }
        }

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(10000, this);
        }

        public void stop() {
            this.mRunning = false;
            this.mSession = null;
            SipService.this.mTimer.cancel(this);
        }
    }

    private class WifiScanProcess
    implements Runnable {
        private static final int INTERVAL = 60;
        private static final String TAG = "\\WIFI_SCAN/";
        private boolean mRunning = false;
        private WifiManager mWifiManager;

        WifiScanProcess() {
            WifiManager wifiManager;
            this.mWifiManager = wifiManager = (WifiManager)SipService.this.mContext.getSystemService("wifi");
        }

        @Override
        public void run() {
            boolean bl = this.mWifiManager.startScanActive();
        }

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(60000, this);
        }

        public void stop() {
            this.mRunning = false;
            SipService.this.mTimer.cancel(this);
        }
    }

    private class SipSessionGroupExt
    extends SipSessionAdapter {
        private AutoRegistrationProcess mAutoRegistration;
        private PendingIntent mIncomingCallPendingIntent;
        private boolean mOpenedToReceiveCalls;
        private SipSessionGroup mSipGroup;

        public SipSessionGroupExt(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) throws SipException {
            SipSessionGroup sipSessionGroup;
            AutoRegistrationProcess autoRegistrationProcess;
            SipService sipService2 = SipService.this;
            this.mAutoRegistration = autoRegistrationProcess = sipService2.new AutoRegistrationProcess();
            String string2 = sipProfile.getPassword();
            SipProfile sipProfile2 = this.duplicate(sipProfile);
            String string3 = SipService.this.mLocalIp;
            this.mSipGroup = sipSessionGroup = this.createSipSessionGroup(string3, sipProfile2, string2);
            this.mIncomingCallPendingIntent = pendingIntent;
            this.mAutoRegistration.setListener(iSipSessionListener);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private SipSessionGroup createSipSessionGroup(String string2, SipProfile sipProfile, String string3) throws SipException {
            try {
                SipWakeLock sipWakeLock = SipService.this.mMyWakeLock;
                return new SipSessionGroup(string2, sipProfile, string3, sipWakeLock);
            }
            catch (IOException iOException) {
                int n = Log.w(SipService.TAG, "createSipSessionGroup(): network disconnected?");
                if (string2 != null) {
                    return this.createSipSessionGroup(null, sipProfile, string3);
                }
                int n2 = Log.wtf(SipService.TAG, "impossible! recursive!");
                throw new RuntimeException("createSipSessionGroup");
            }
        }

        private SipProfile duplicate(SipProfile sipProfile) {
            try {
                SipProfile sipProfile2 = new SipProfile.Builder(sipProfile).setPassword("*").build();
                return sipProfile2;
            }
            catch (Exception exception) {
                int n = Log.wtf(SipService.TAG, "duplicate()", exception);
                throw new RuntimeException("duplicate profile", exception);
            }
        }

        private String getUri() {
            return this.mSipGroup.getLocalProfileUri();
        }

        private void resetGroup(String string2) throws SipException {
            try {
                this.mSipGroup.reset(string2);
                return;
            }
            catch (IOException iOException) {
                int n = Log.w(SipService.TAG, "resetGroup(): network disconnected?");
                if (string2 != null) {
                    this.resetGroup(null);
                    return;
                }
                int n2 = Log.wtf(SipService.TAG, "impossible!");
                throw new RuntimeException("resetGroup");
            }
        }

        public void close() {
            this.mOpenedToReceiveCalls = false;
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        public boolean containsSession(String string2) {
            return this.mSipGroup.containsSession(string2);
        }

        public ISipSession createSession(ISipSessionListener iSipSessionListener) {
            return this.mSipGroup.createSession(iSipSessionListener);
        }

        public SipProfile getLocalProfile() {
            return this.mSipGroup.getLocalProfile();
        }

        public boolean isOpenedToReceiveCalls() {
            return this.mOpenedToReceiveCalls;
        }

        public boolean isRegistered() {
            return this.mAutoRegistration.isRegistered();
        }

        public void onConnectivityChanged(boolean bl) throws SipException {
            this.mSipGroup.onConnectivityChanged();
            if (bl) {
                String string2 = SipService.this.mLocalIp;
                this.resetGroup(string2);
                if (!this.mOpenedToReceiveCalls) {
                    return;
                }
                this.openToReceiveCalls();
                return;
            }
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        @Override
        public void onError(ISipSession iSipSession, int n, String string2) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRinging(ISipSession iSipSession, SipProfile sipProfile, String string2) {
            SipSessionGroup.SipSessionImpl sipSessionImpl = (SipSessionGroup.SipSessionImpl)iSipSession;
            SipService sipService = SipService.this;
            synchronized (sipService) {
                try {
                    if (!this.isRegistered() || SipService.this.callingSelf(this, sipSessionImpl)) {
                        sipSessionImpl.endCall();
                        return;
                    }
                    SipService.this.addPendingSession(sipSessionImpl);
                    Intent intent = SipManager.createIncomingCallBroadcast(sipSessionImpl.getCallId(), string2);
                    PendingIntent pendingIntent = this.mIncomingCallPendingIntent;
                    Context context = SipService.this.mContext;
                    pendingIntent.send(context, 101, intent);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    int n = Log.w(SipService.TAG, "pendingIntent is canceled, drop incoming call");
                    sipSessionImpl.endCall();
                }
                return;
            }
        }

        public void openToReceiveCalls() throws SipException {
            this.mOpenedToReceiveCalls = true;
            if (!SipService.this.mConnected) {
                return;
            }
            this.mSipGroup.openToReceiveCalls(this);
            AutoRegistrationProcess autoRegistrationProcess = this.mAutoRegistration;
            SipSessionGroup sipSessionGroup = this.mSipGroup;
            autoRegistrationProcess.start(sipSessionGroup);
        }

        public void setIncomingCallPendingIntent(PendingIntent pendingIntent) {
            this.mIncomingCallPendingIntent = pendingIntent;
        }

        public void setListener(ISipSessionListener iSipSessionListener) {
            this.mAutoRegistration.setListener(iSipSessionListener);
        }
    }
}

