/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.net.sip.SipSession;
import android.text.TextUtils;
import android.util.Log;
import com.android.server.sip.SipHelper;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.message.SIPMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramSocket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;

class SipSessionGroup
implements SipListener {
    private static final String ANONYMOUS = "anonymous";
    private static final int CANCEL_CALL_TIMER = 3;
    private static final EventObject CONTINUE_CALL;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_PING = false;
    private static final EventObject DEREGISTER;
    private static final EventObject END_CALL;
    private static final int EXPIRY_TIME = 3600;
    private static final EventObject HOLD_CALL;
    private static final String TAG = "SipSession";
    private static final String THREAD_POOL_SIZE = "1";
    private static final long WAKE_LOCK_HOLDING_TIME = 500L;
    private SipSessionImpl mCallReceiverSession;
    private String mLocalIp;
    private final SipProfile mLocalProfile;
    private final String mPassword;
    private Map<String, SipSessionImpl> mSessionMap;
    private SipHelper mSipHelper;
    private SipStack mSipStack;
    private SipWakeLock mWakeLock;

    static {
        DEREGISTER = new EventObject("Deregister");
        END_CALL = new EventObject("End call");
        HOLD_CALL = new EventObject("Hold call");
        CONTINUE_CALL = new EventObject("Continue call");
    }

    public SipSessionGroup(String string2, SipProfile sipProfile, String string3, SipWakeLock sipWakeLock) throws SipException, IOException {
        HashMap<String, SipSessionImpl> hashMap = new HashMap<String, SipSessionImpl>();
        this.mSessionMap = hashMap;
        this.mLocalProfile = sipProfile;
        this.mPassword = string3;
        this.mWakeLock = sipWakeLock;
        this.reset(string2);
    }

    private void addSipSession(SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            this.removeSipSession(sipSessionImpl);
            String string2 = sipSessionImpl.getCallId();
            SipSessionImpl sipSessionImpl2 = this.mSessionMap.put(string2, sipSessionImpl);
            if (SipSessionGroup.isLoggable(sipSessionImpl)) {
                String string3 = "+++  add a session with key:  '" + string2 + "'";
                int n = Log.d(TAG, string3);
                for (String string4 : this.mSessionMap.keySet()) {
                    StringBuilder stringBuilder = new StringBuilder().append("  ").append(string4).append(": ");
                    SipSessionImpl sipSessionImpl3 = this.mSessionMap.get(string4);
                    String string5 = stringBuilder.append(sipSessionImpl3).toString();
                    int n2 = Log.d(TAG, string5);
                }
            }
            return;
        }
    }

    private static int allocateLocalPort() throws SipException {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            int n = datagramSocket.getLocalPort();
            datagramSocket.close();
            return n;
        }
        catch (IOException iOException) {
            throw new SipException("allocateLocalPort()", (Throwable)iOException);
        }
    }

    private static SipProfile createPeerProfile(Request request) throws SipException {
        try {
            Address address = ((FromHeader)request.getHeader("From")).getAddress();
            SipURI sipURI = (SipURI)address.getURI();
            String string2 = sipURI.getUser();
            if (string2 == null) {
                string2 = ANONYMOUS;
            }
            int n = sipURI.getPort();
            String string3 = sipURI.getHost();
            SipProfile.Builder builder = new SipProfile.Builder(string2, string3);
            String string4 = address.getDisplayName();
            SipProfile.Builder builder2 = builder.setDisplayName(string4);
            if (n > 0) {
                SipProfile.Builder builder3 = builder2.setPort(n);
            }
            SipProfile sipProfile = builder2.build();
            return sipProfile;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SipException("createPeerProfile()", (Throwable)illegalArgumentException);
        }
        catch (ParseException parseException) {
            throw new SipException("createPeerProfile()", (Throwable)parseException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean expectResponse(int n, String string2, EventObject eventObject) {
        if (!(eventObject instanceof ResponseEvent)) return false;
        Response response = ((ResponseEvent)eventObject).getResponse();
        if (response.getStatusCode() == n) return false;
        String string3 = SipSessionGroup.getCseqMethod((Message)response);
        return string2.equalsIgnoreCase(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean expectResponse(String string2, EventObject eventObject) {
        if (!(eventObject instanceof ResponseEvent)) return false;
        String string3 = SipSessionGroup.getCseqMethod((Message)((ResponseEvent)eventObject).getResponse());
        return string2.equalsIgnoreCase(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String extractContent(Message message) {
        byte[] byArray = message.getRawContent();
        if (byArray == null) return null;
        try {
            if (!(message instanceof SIPMessage)) return new String(byArray, "UTF-8");
            return ((SIPMessage)message).getMessageContent();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    private static String getCseqMethod(Message message) {
        return ((CSeqHeader)message.getHeader("CSeq")).getMethod();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SipSessionImpl getSipSession(EventObject eventObject) {
        synchronized (this) {
            String string2 = SipHelper.getCallId(eventObject);
            SipSessionImpl sipSessionImpl = this.mSessionMap.get(string2);
            if (sipSessionImpl != null && SipSessionGroup.isLoggable(sipSessionImpl)) {
                String string3 = "session key from event: " + string2;
                int n = Log.d(TAG, string3);
                int n2 = Log.d(TAG, "active sessions:");
                for (String string4 : this.mSessionMap.keySet()) {
                    StringBuilder stringBuilder = new StringBuilder().append(" ...").append(string4).append(": ");
                    SipSessionImpl sipSessionImpl2 = this.mSessionMap.get(string4);
                    String string5 = stringBuilder.append(sipSessionImpl2).toString();
                    int n3 = Log.d(TAG, string5);
                }
            }
            if (sipSessionImpl == null) return this.mCallReceiverSession;
            return sipSessionImpl;
        }
    }

    private String getStackName() {
        StringBuilder stringBuilder = new StringBuilder().append("stack");
        long l = System.currentTimeMillis();
        return stringBuilder.append(l).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLoggable(SipSessionImpl sipSessionImpl) {
        if (sipSessionImpl == null) return true;
        switch (sipSessionImpl.mState) {
            default: {
                return true;
            }
            case 9: 
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLoggable(SipSessionImpl sipSessionImpl, EventObject eventObject) {
        if (!SipSessionGroup.isLoggable(sipSessionImpl)) {
            return false;
        }
        if (eventObject == null) {
            return false;
        }
        if (eventObject instanceof OptionsCommand) {
            return false;
        }
        if (eventObject instanceof ResponseEvent) {
            Header header = ((ResponseEvent)eventObject).getResponse().getHeader("CSeq");
            if (!"OPTIONS".equals(header)) return true;
            return false;
        }
        if (!(eventObject instanceof RequestEvent)) return false;
        return true;
    }

    private static boolean isLoggable(EventObject eventObject) {
        return SipSessionGroup.isLoggable(null, eventObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRequestEvent(String string2, EventObject eventObject) {
        try {
            if (!(eventObject instanceof RequestEvent)) return false;
            String string3 = ((RequestEvent)eventObject).getRequest().getMethod();
            boolean bl = string2.equals(string3);
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String log(EventObject eventObject) {
        if (eventObject instanceof RequestEvent) {
            return ((RequestEvent)eventObject).getRequest().toString();
        }
        if (!(eventObject instanceof ResponseEvent)) return eventObject.toString();
        return ((ResponseEvent)eventObject).getResponse().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(EventObject eventObject) {
        synchronized (this) {
            SipSessionImpl sipSessionImpl;
            SipSessionImpl sipSessionImpl2 = sipSessionImpl = this.getSipSession(eventObject);
            try {
                boolean bl = SipSessionGroup.isLoggable(sipSessionImpl2, eventObject);
                boolean bl2 = sipSessionImpl2 != null && sipSessionImpl2.process(eventObject);
                if (bl && bl2) {
                    StringBuilder stringBuilder = new StringBuilder().append("new state after: ");
                    String string2 = SipSession.State.toString(sipSessionImpl2.mState);
                    String string3 = stringBuilder.append(string2).toString();
                    int n = Log.d(TAG, string3);
                }
            }
            catch (Throwable throwable) {
                String string4 = "event process error: " + eventObject;
                int n = Log.w(TAG, string4, throwable);
                sipSessionImpl2.onError(throwable);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeSipSession(SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            SipSessionImpl sipSessionImpl2 = this.mCallReceiverSession;
            if (sipSessionImpl != sipSessionImpl2) {
                String string2 = sipSessionImpl.getCallId();
                SipSessionImpl sipSessionImpl3 = this.mSessionMap.remove(string2);
                if (sipSessionImpl3 != null && sipSessionImpl3 != sipSessionImpl) {
                    String string3 = "session " + sipSessionImpl + " is not associated with key '" + string2 + "'";
                    int n = Log.w(TAG, string3);
                    SipSessionImpl sipSessionImpl4 = this.mSessionMap.put(string2, sipSessionImpl3);
                    for (Map.Entry entry : this.mSessionMap.entrySet()) {
                        if (entry.getValue() != sipSessionImpl3) continue;
                        string2 = (String)entry.getKey();
                        SipSessionImpl sipSessionImpl5 = this.mSessionMap.remove(string2);
                    }
                }
                if (sipSessionImpl3 != null && SipSessionGroup.isLoggable(sipSessionImpl3)) {
                    String string4 = "remove session " + sipSessionImpl + " @key '" + string2 + "'";
                    int n = Log.d(TAG, string4);
                    for (String string5 : this.mSessionMap.keySet()) {
                        StringBuilder stringBuilder = new StringBuilder().append("  ").append(string5).append(": ");
                        SipSessionImpl sipSessionImpl6 = this.mSessionMap.get(string5);
                        String string6 = stringBuilder.append(sipSessionImpl6).toString();
                        int n2 = Log.d(TAG, string6);
                    }
                }
            }
            return;
        }
    }

    public void close() {
        synchronized (this) {
            StringBuilder stringBuilder = new StringBuilder().append(" close stack for ");
            String string2 = this.mLocalProfile.getUriString();
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.d(TAG, string3);
            this.onConnectivityChanged();
            this.mSessionMap.clear();
            this.closeToNotReceiveCalls();
            if (this.mSipStack != null) {
                this.mSipStack.stop();
                this.mSipStack = null;
                this.mSipHelper = null;
            }
            return;
        }
    }

    public void closeToNotReceiveCalls() {
        synchronized (this) {
            this.mCallReceiverSession = null;
            return;
        }
    }

    boolean containsSession(String string2) {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = this.mSessionMap.containsKey(string2);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISipSession createSession(ISipSessionListener iSipSessionListener) {
        if (!this.isClosed()) return new SipSessionImpl(iSipSessionListener);
        return null;
    }

    public SipProfile getLocalProfile() {
        return this.mLocalProfile;
    }

    public String getLocalProfileUri() {
        return this.mLocalProfile.getUriString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        synchronized (this) {
            SipStack sipStack = this.mSipStack;
            if (sipStack != null) return false;
            return true;
        }
    }

    void onConnectivityChanged() {
        synchronized (this) {
            Collection<SipSessionImpl> collection = this.mSessionMap.values();
            SipSessionImpl[] sipSessionImplArray = new SipSessionImpl[this.mSessionMap.size()];
            SipSessionImpl[] sipSessionImplArray2 = collection.toArray(sipSessionImplArray);
            int n = sipSessionImplArray2.length;
            for (int i = 0; i < n; ++i) {
                sipSessionImplArray2[i].onError(65526, "data connection lost");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openToReceiveCalls(ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            if (this.mCallReceiverSession == null) {
                SipSessionCallReceiverImpl sipSessionCallReceiverImpl = new SipSessionCallReceiverImpl(iSipSessionListener);
                this.mCallReceiverSession = sipSessionCallReceiverImpl;
            } else {
                this.mCallReceiverSession.setListener(iSipSessionListener);
            }
            return;
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.process((EventObject)dialogTerminatedEvent);
    }

    public void processIOException(IOExceptionEvent iOExceptionEvent) {
        this.process((EventObject)iOExceptionEvent);
    }

    public void processRequest(RequestEvent requestEvent) {
        if (SipSessionGroup.isRequestEvent("INVITE", (EventObject)requestEvent)) {
            StringBuilder stringBuilder = new StringBuilder().append("<<<<< got INVITE, thread:");
            Thread thread = Thread.currentThread();
            String string2 = stringBuilder.append(thread).toString();
            int n = Log.d(TAG, string2);
            this.mWakeLock.acquire(500L);
        }
        this.process((EventObject)requestEvent);
    }

    public void processResponse(ResponseEvent responseEvent) {
        this.process((EventObject)responseEvent);
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        this.process((EventObject)timeoutEvent);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        this.process((EventObject)transactionTerminatedEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reset(String string2) throws SipException, IOException {
        synchronized (this) {
            this.mLocalIp = string2;
            if (string2 != null) {
                String string3;
                SipStack sipStack;
                SipProfile sipProfile = this.mLocalProfile;
                SipFactory sipFactory = SipFactory.getInstance();
                Properties properties = new Properties();
                String string4 = this.getStackName();
                Object object = properties.setProperty("javax.sip.STACK_NAME", string4);
                Object object2 = properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", THREAD_POOL_SIZE);
                String string5 = sipProfile.getProxyAddress();
                if (!TextUtils.isEmpty(string5)) {
                    String string6 = "outboundProxy is " + string5;
                    int n = Log.v(TAG, string6);
                    StringBuilder stringBuilder = new StringBuilder().append(string5).append(":");
                    int n2 = sipProfile.getPort();
                    StringBuilder stringBuilder2 = stringBuilder.append(n2).append("/");
                    String string7 = sipProfile.getProtocol();
                    String string8 = stringBuilder2.append(string7).toString();
                    Object object3 = properties.setProperty("javax.sip.OUTBOUND_PROXY", string8);
                }
                this.mSipStack = sipStack = sipFactory.createSipStack(properties);
                try {
                    SipHelper sipHelper;
                    int n = SipSessionGroup.allocateLocalPort();
                    String string9 = sipProfile.getProtocol();
                    ListeningPoint listeningPoint = sipStack.createListeningPoint(string2, n, string9);
                    SipProvider sipProvider = sipStack.createSipProvider(listeningPoint);
                    sipProvider.addSipListener((SipListener)this);
                    this.mSipHelper = sipHelper = new SipHelper(sipStack, sipProvider);
                    StringBuilder stringBuilder = new StringBuilder().append(" start stack for ");
                    String string10 = sipProfile.getUriString();
                    string3 = stringBuilder.append(string10).toString();
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    String string11 = invalidArgumentException.getMessage();
                    throw new IOException(string11);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    throw new SipException("SipSessionGroup constructor", (Throwable)tooManyListenersException);
                }
                int n = Log.d(TAG, string3);
                sipStack.start();
                this.mCallReceiverSession = null;
                this.mSessionMap.clear();
            }
            return;
        }
    }

    private class MakeCallCommand
    extends EventObject {
        private String mSessionDescription;
        private int mTimeout;

        public MakeCallCommand(SipProfile sipProfile, String string2) {
            this(sipProfile, string2, -1);
        }

        public MakeCallCommand(SipProfile sipProfile, String string2, int n) {
            super(sipProfile);
            this.mSessionDescription = string2;
            this.mTimeout = n;
        }

        public SipProfile getPeerProfile() {
            return (SipProfile)this.getSource();
        }

        public String getSessionDescription() {
            return this.mSessionDescription;
        }

        public int getTimeout() {
            return this.mTimeout;
        }
    }

    private class RegisterCommand
    extends EventObject {
        private int mDuration;

        public RegisterCommand(int n) {
            super(SipSessionGroup.this);
            this.mDuration = n;
        }

        public int getDuration() {
            return this.mDuration;
        }
    }

    private class OptionsCommand
    extends EventObject {
        public OptionsCommand() {
            super(SipSessionGroup.this);
        }
    }

    class SipSessionImpl
    extends ISipSession.Stub {
        int mAuthenticationRetryCount;
        ClientTransaction mClientTransaction;
        Dialog mDialog;
        boolean mInCall;
        RequestEvent mInviteReceived;
        SipProfile mPeerProfile;
        String mPeerSessionDescription;
        SipSessionListenerProxy mProxy;
        int mRPort;
        boolean mReRegisterFlag;
        ServerTransaction mServerTransaction;
        int mState;
        SessionTimer mTimer;

        public SipSessionImpl(ISipSessionListener iSipSessionListener) {
            SipSessionListenerProxy sipSessionListenerProxy;
            this.mProxy = sipSessionListenerProxy = new SipSessionListenerProxy();
            this.mState = 0;
            this.mReRegisterFlag = false;
            this.setListener(iSipSessionListener);
        }

        private void cancelSessionTimer() {
            if (this.mTimer == null) {
                return;
            }
            this.mTimer.cancel();
            this.mTimer = null;
        }

        private String createErrorMessage(Response response) {
            Object[] objectArray = new Object[2];
            String string2 = response.getReasonPhrase();
            objectArray[0] = string2;
            Integer n = response.getStatusCode();
            objectArray[1] = n;
            return String.format("%s (%d)", objectArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean crossDomainAuthenticationRequired(Response response) {
            String string2;
            String string3;
            String string4 = this.getRealmFromResponse(response);
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = SipSessionGroup.this.mLocalProfile.getSipDomain().trim()).equals(string2 = string4.trim())) return false;
            return true;
        }

        private void doCommandAsync(final EventObject eventObject) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        SipSessionImpl sipSessionImpl = SipSessionImpl.this;
                        EventObject eventObject2 = eventObject;
                        sipSessionImpl.processCommand(eventObject2);
                        return;
                    }
                    catch (Throwable throwable) {
                        StringBuilder stringBuilder = new StringBuilder().append("command error: ");
                        EventObject eventObject3 = eventObject;
                        String string2 = stringBuilder.append(eventObject3).toString();
                        int n = Log.w(SipSessionGroup.TAG, string2, throwable);
                        SipSessionImpl.this.onError(throwable);
                        return;
                    }
                }
            };
            new Thread(runnable, "SipSessionAsyncCmdThread").start();
        }

        private void endCallNormally() {
            this.reset();
            this.mProxy.onCallEnded(this);
        }

        private void endCallOnBusy() {
            this.reset();
            this.mProxy.onCallBusy(this);
        }

        private void endCallOnError(int n, String string2) {
            this.reset();
            this.mProxy.onError(this, n, string2);
        }

        private void establishCall() {
            this.mState = 8;
            this.mInCall = true;
            this.cancelSessionTimer();
            SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
            String string2 = this.mPeerSessionDescription;
            sipSessionListenerProxy.onCallEstablished(this, string2);
        }

        private AccountManager getAccountManager() {
            return new AccountManager(){

                public UserCredentials getCredentials(ClientTransaction clientTransaction, String string2) {
                    return new UserCredentials(){

                        public String getPassword() {
                            return SipSessionGroup.this.mPassword;
                        }

                        public String getSipDomain() {
                            return SipSessionGroup.this.mLocalProfile.getSipDomain();
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public String getUserName() {
                            String string2 = SipSessionGroup.this.mLocalProfile.getAuthUserName();
                            if (TextUtils.isEmpty(string2)) return SipSessionGroup.this.mLocalProfile.getUserName();
                            return string2;
                        }
                    };
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getErrorCode(int n) {
            switch (n) {
                default: {
                    if (n >= 500) return -1;
                    return -1;
                }
                case 403: 
                case 404: 
                case 406: 
                case 410: 
                case 480: 
                case 488: {
                    return -1;
                }
                case 414: 
                case 484: 
                case 485: {
                    return -1;
                }
                case 408: {
                    return -1;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getErrorCode(Throwable throwable) {
            String string2 = throwable.getMessage();
            if (throwable instanceof UnknownHostException) {
                return 65524;
            }
            if (!(throwable instanceof IOException)) return -1;
            return -1;
        }

        private int getExpiryTime(Response response) {
            ExpiresHeader expiresHeader;
            int n = 3600;
            ExpiresHeader expiresHeader2 = (ExpiresHeader)response.getHeader("Expires");
            if (expiresHeader2 != null) {
                n = expiresHeader2.getExpires();
            }
            if ((expiresHeader = (ExpiresHeader)response.getHeader("Min-Expires")) != null) {
                int n2 = expiresHeader.getExpires();
                n = Math.max(n, n2);
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getNonceFromResponse(Response response) {
            WWWAuthenticate wWWAuthenticate = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wWWAuthenticate != null) {
                return wWWAuthenticate.getNonce();
            }
            ProxyAuthenticate proxyAuthenticate = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            if (proxyAuthenticate != null) return proxyAuthenticate.getNonce();
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getRPortFromResponse(Response response) {
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            if (viaHeader != null) return viaHeader.getRPort();
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getRealmFromResponse(Response response) {
            WWWAuthenticate wWWAuthenticate = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wWWAuthenticate != null) {
                return wWWAuthenticate.getRealm();
            }
            ProxyAuthenticate proxyAuthenticate = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            if (proxyAuthenticate != null) return proxyAuthenticate.getRealm();
            return null;
        }

        private Throwable getRootCause(Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            while (throwable2 != null) {
                throwable = throwable2;
                throwable2 = throwable.getCause();
            }
            return throwable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Transaction getTransaction() {
            if (this.mClientTransaction != null) {
                return this.mClientTransaction;
            }
            if (this.mServerTransaction == null) return null;
            return this.mServerTransaction;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean handleAuthentication(ResponseEvent responseEvent) throws SipException {
            Response response = responseEvent.getResponse();
            if (this.getNonceFromResponse(response) == null) {
                this.onError(-1, "server does not provide challenge");
                return false;
            }
            if (this.mAuthenticationRetryCount < 2) {
                int n;
                Dialog dialog;
                ClientTransaction clientTransaction;
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                AccountManager accountManager = this.getAccountManager();
                this.mClientTransaction = clientTransaction = sipHelper.handleChallenge(responseEvent, accountManager);
                this.mDialog = dialog = this.mClientTransaction.getDialog();
                this.mAuthenticationRetryCount = n = this.mAuthenticationRetryCount + 1;
                if (!SipSessionGroup.isLoggable(this, (EventObject)responseEvent)) return true;
                StringBuilder stringBuilder = new StringBuilder().append("   authentication retry count=");
                int n2 = this.mAuthenticationRetryCount;
                String string2 = stringBuilder.append(n2).toString();
                int n3 = Log.d(SipSessionGroup.TAG, string2);
                return true;
            }
            if (this.crossDomainAuthenticationRequired(response)) {
                String string3 = this.getRealmFromResponse(response);
                this.onError(65525, string3);
                return false;
            }
            this.onError(-1, "incorrect username or password");
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean inCall(EventObject eventObject) throws SipException {
            ClientTransaction clientTransaction;
            if (END_CALL == eventObject) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                Dialog dialog = this.mDialog;
                sipHelper.sendBye(dialog);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("INVITE", eventObject)) {
                String string2;
                RequestEvent requestEvent;
                this.mState = 3;
                this.mInviteReceived = requestEvent = (RequestEvent)eventObject;
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                Request request = requestEvent.getRequest();
                this.mPeerSessionDescription = string2 = sipSessionGroup.extractContent((Message)request);
                this.mServerTransaction = null;
                SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                SipProfile sipProfile = this.mPeerProfile;
                String string3 = this.mPeerSessionDescription;
                sipSessionListenerProxy.onRinging(this, sipProfile, string3);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("BYE", eventObject)) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = (RequestEvent)eventObject;
                sipHelper.sendResponse(requestEvent, 200);
                this.endCallNormally();
                return true;
            }
            if (!(eventObject instanceof MakeCallCommand)) return false;
            this.mState = 5;
            SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
            Dialog dialog = this.mDialog;
            String string4 = ((MakeCallCommand)eventObject).getSessionDescription();
            this.mClientTransaction = clientTransaction = sipHelper.sendReinvite(dialog, string4);
            int n = ((MakeCallCommand)eventObject).getTimeout();
            this.startSessionTimer(n);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean incomingCall(EventObject eventObject) throws SipException {
            if (eventObject instanceof MakeCallCommand) {
                ServerTransaction serverTransaction;
                this.mState = 4;
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = this.mInviteReceived;
                SipProfile sipProfile = SipSessionGroup.this.mLocalProfile;
                String string2 = ((MakeCallCommand)eventObject).getSessionDescription();
                ServerTransaction serverTransaction2 = this.mServerTransaction;
                this.mServerTransaction = serverTransaction = sipHelper.sendInviteOk(requestEvent, sipProfile, string2, serverTransaction2);
                int n = ((MakeCallCommand)eventObject).getTimeout();
                this.startSessionTimer(n);
                return true;
            }
            if (END_CALL == eventObject) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = this.mInviteReceived;
                ServerTransaction serverTransaction = this.mServerTransaction;
                sipHelper.sendInviteBusyHere(requestEvent, serverTransaction);
                this.endCallNormally();
                return true;
            }
            if (!SipSessionGroup.isRequestEvent("CANCEL", eventObject)) return false;
            RequestEvent requestEvent = (RequestEvent)eventObject;
            SipSessionGroup.this.mSipHelper.sendResponse(requestEvent, 200);
            SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
            Request request = this.mInviteReceived.getRequest();
            ServerTransaction serverTransaction = this.mServerTransaction;
            sipHelper.sendInviteRequestTerminated(request, serverTransaction);
            this.endCallNormally();
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean incomingCallToInCall(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isRequestEvent("ACK", eventObject)) {
                this.establishCall();
                return true;
            }
            if (!SipSessionGroup.isRequestEvent("CANCEL", eventObject)) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isCurrentTransaction(TransactionTerminatedEvent transactionTerminatedEvent) {
            Object object;
            Object object2 = transactionTerminatedEvent.isServerTransaction() ? this.mServerTransaction : this.mClientTransaction;
            if (object2 != (object = transactionTerminatedEvent.isServerTransaction() ? transactionTerminatedEvent.getServerTransaction() : transactionTerminatedEvent.getClientTransaction()) && this.mState != 9) {
                StringBuilder stringBuilder = new StringBuilder().append("not the current transaction; current=");
                String string2 = this.toString((Transaction)object2);
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", target=");
                String string3 = this.toString((Transaction)object);
                String string4 = stringBuilder2.append(string3).toString();
                int n = Log.d(SipSessionGroup.TAG, string4);
                return false;
            }
            if (object2 == null) return true;
            StringBuilder stringBuilder = new StringBuilder().append("transaction terminated: ");
            String string5 = this.toString((Transaction)object2);
            String string6 = stringBuilder.append(string5).toString();
            int n = Log.d(SipSessionGroup.TAG, string6);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean keepAliveProcess(EventObject eventObject) throws SipException {
            if (eventObject instanceof OptionsCommand) {
                Dialog dialog;
                ClientTransaction clientTransaction;
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                SipProfile sipProfile = SipSessionGroup.this.mLocalProfile;
                String string2 = this.generateTag();
                this.mClientTransaction = clientTransaction = sipHelper.sendKeepAlive(sipProfile, string2);
                this.mDialog = dialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                return true;
            }
            if (!(eventObject instanceof ResponseEvent)) return false;
            return this.parseOptionsResult(eventObject);
        }

        private void onError(int n, String string2) {
            this.cancelSessionTimer();
            switch (this.mState) {
                default: {
                    this.endCallOnError(n, string2);
                    return;
                }
                case 1: 
                case 2: 
            }
            this.onRegistrationFailed(n, string2);
        }

        private void onError(Throwable throwable) {
            Throwable throwable2 = this.getRootCause(throwable);
            int n = this.getErrorCode(throwable2);
            String string2 = throwable2.toString();
            this.onError(n, string2);
        }

        private void onError(Response response) {
            int n = response.getStatusCode();
            if (!this.mInCall && n == 486) {
                this.endCallOnBusy();
                return;
            }
            int n2 = this.getErrorCode(n);
            String string2 = this.createErrorMessage(response);
            this.onError(n2, string2);
        }

        private void onRegistrationDone(int n) {
            this.reset();
            this.mProxy.onRegistrationDone(this, n);
        }

        private void onRegistrationFailed(int n, String string2) {
            this.reset();
            this.mProxy.onRegistrationFailed(this, n, string2);
        }

        private void onRegistrationFailed(Throwable throwable) {
            Throwable throwable2 = this.getRootCause(throwable);
            int n = this.getErrorCode(throwable2);
            String string2 = throwable2.toString();
            this.onRegistrationFailed(n, string2);
        }

        private void onRegistrationFailed(Response response) {
            int n = response.getStatusCode();
            int n2 = this.getErrorCode(n);
            String string2 = this.createErrorMessage(response);
            this.onRegistrationFailed(n2, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean outgoingCall(EventObject eventObject) throws SipException {
            if (SipSessionGroup.expectResponse("INVITE", eventObject)) {
                ResponseEvent responseEvent = (ResponseEvent)eventObject;
                Response response = responseEvent.getResponse();
                int n = response.getStatusCode();
                switch (n) {
                    default: {
                        if (n < 400) break;
                        this.onError(response);
                        return true;
                    }
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: {
                        if (this.mState != 5) return true;
                        this.mState = 6;
                        this.cancelSessionTimer();
                        this.mProxy.onRingingBack(this);
                        return true;
                    }
                    case 200: {
                        String string2;
                        SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                        Dialog dialog = this.mDialog;
                        sipHelper.sendInviteAck(responseEvent, dialog);
                        this.mPeerSessionDescription = string2 = SipSessionGroup.this.extractContent((Message)response);
                        this.establishCall();
                        return true;
                    }
                    case 401: 
                    case 407: {
                        if (!this.handleAuthentication(responseEvent)) return true;
                        SipSessionGroup.this.addSipSession(this);
                        return true;
                    }
                    case 491: {
                        return true;
                    }
                }
                if (n < 300) return true;
                return false;
            }
            if (END_CALL == eventObject) {
                this.mState = 7;
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                ClientTransaction clientTransaction = this.mClientTransaction;
                sipHelper.sendCancel(clientTransaction);
                this.startSessionTimer(3);
                return true;
            }
            if (!SipSessionGroup.isRequestEvent("INVITE", eventObject)) return false;
            RequestEvent requestEvent = (RequestEvent)eventObject;
            SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            sipHelper.sendInviteBusyHere(requestEvent, serverTransaction);
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private boolean outgoingCallToReady(EventObject var1_1) throws SipException {
            block11: {
                block8: {
                    block10: {
                        block9: {
                            if (!(var1_1 instanceof ResponseEvent)) break block8;
                            var2_2 = ((ResponseEvent)var1_1).getResponse();
                            var3_3 = var2_2.getStatusCode();
                            if (!SipSessionGroup.access$1900("CANCEL", var1_1)) break block9;
                            if (var3_3 == 200) {
                                var4_4 = true;
lbl7:
                                // 4 sources

                                return var4_4;
                            }
                            ** GOTO lbl-1000
                        }
                        if (!SipSessionGroup.access$1900("INVITE", var1_1)) break block10;
                        switch (var3_3) {
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (var3_3 >= 400) {
                                    this.onError(var2_2);
                                    var4_4 = true;
                                    break;
                                }
                                break block11;
                            }
                            case 200: {
                                var5_5 = this.outgoingCall(var1_1);
                                var4_4 = true;
                                break;
                            }
                            case 487: {
                                this.endCallNormally();
                                var4_4 = true;
                                break;
                            }
                        }
                        ** GOTO lbl7
                    }
                    var4_4 = false;
                    ** GOTO lbl7
                }
                if (var1_1 instanceof TransactionTerminatedEvent) {
                    var6_6 = new SipException("timed out");
                    this.onError(var6_6);
                }
            }
            var4_4 = false;
            ** while (true)
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean parseOptionsResult(EventObject eventObject) {
            if (!SipSessionGroup.expectResponse("OPTIONS", eventObject)) {
                return false;
            }
            Response response = ((ResponseEvent)eventObject).getResponse();
            int n = this.getRPortFromResponse(response);
            if (n != -1) {
                if (this.mRPort == 0) {
                    this.mRPort = n;
                }
                if (this.mRPort != n) {
                    this.mReRegisterFlag = true;
                    Object[] objectArray = new Object[2];
                    Integer n2 = this.mRPort;
                    objectArray[0] = n2;
                    Integer n3 = n;
                    objectArray[1] = n3;
                    String string2 = String.format("rport is changed: %d <> %d", objectArray);
                    int n4 = Log.w(SipSessionGroup.TAG, string2);
                    this.mRPort = n;
                }
            } else {
                int n5 = Log.w(SipSessionGroup.TAG, "peer did not respond rport");
            }
            this.reset();
            return true;
        }

        private void processCommand(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(eventObject)) {
                String string2 = "process cmd: " + eventObject;
                int n = Log.d(SipSessionGroup.TAG, string2);
            }
            if (this.process(eventObject)) {
                return;
            }
            String string3 = "cannot initiate a new transaction to execute: " + eventObject;
            this.onError(65527, string3);
        }

        private void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            Dialog dialog = this.mDialog;
            Dialog dialog2 = dialogTerminatedEvent.getDialog();
            if (dialog == dialog2) {
                SipException sipException = new SipException("dialog terminated");
                this.onError(sipException);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("not the current dialog; current=");
            Dialog dialog3 = this.mDialog;
            StringBuilder stringBuilder2 = stringBuilder.append(dialog3).append(", terminated=");
            Dialog dialog4 = dialogTerminatedEvent.getDialog();
            String string2 = stringBuilder2.append(dialog4).toString();
            int n = Log.d(SipSessionGroup.TAG, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean processExceptions(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isRequestEvent("BYE", eventObject)) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = (RequestEvent)eventObject;
                sipHelper.sendResponse(requestEvent, 200);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("CANCEL", eventObject)) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = (RequestEvent)eventObject;
                sipHelper.sendResponse(requestEvent, 481);
                return true;
            }
            if (eventObject instanceof TransactionTerminatedEvent) {
                TransactionTerminatedEvent transactionTerminatedEvent = (TransactionTerminatedEvent)eventObject;
                if (!this.isCurrentTransaction(transactionTerminatedEvent)) return false;
                if (eventObject instanceof TimeoutEvent) {
                    TimeoutEvent timeoutEvent = (TimeoutEvent)eventObject;
                    this.processTimeout(timeoutEvent);
                    return true;
                }
                TransactionTerminatedEvent transactionTerminatedEvent2 = (TransactionTerminatedEvent)eventObject;
                this.processTransactionTerminated(transactionTerminatedEvent2);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("OPTIONS", eventObject)) {
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                RequestEvent requestEvent = (RequestEvent)eventObject;
                sipHelper.sendResponse(requestEvent, 200);
                return true;
            }
            if (!(eventObject instanceof DialogTerminatedEvent)) return false;
            DialogTerminatedEvent dialogTerminatedEvent = (DialogTerminatedEvent)eventObject;
            this.processDialogTerminated(dialogTerminatedEvent);
            return true;
        }

        private void processTimeout(TimeoutEvent timeoutEvent) {
            int n = Log.d(SipSessionGroup.TAG, "processing Timeout...");
            switch (this.mState) {
                default: {
                    int n2 = Log.d(SipSessionGroup.TAG, "   do nothing");
                    return;
                }
                case 1: 
                case 2: {
                    this.reset();
                    this.mProxy.onRegistrationTimeout(this);
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    String string2 = timeoutEvent.toString();
                    this.onError(-1, string2);
                    return;
                }
                case 9: 
            }
            this.reset();
            this.mReRegisterFlag = true;
        }

        private void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            switch (this.mState) {
                default: {
                    String string2 = "Transaction terminated early: " + this;
                    int n = Log.d(SipSessionGroup.TAG, string2);
                    this.onError(-1, "transaction terminated");
                    return;
                }
                case 0: 
                case 8: 
            }
            int n = Log.d(SipSessionGroup.TAG, "Transaction terminated; do nothing");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean readyForCall(EventObject eventObject) throws SipException {
            Dialog dialog;
            ClientTransaction clientTransaction;
            if (eventObject instanceof MakeCallCommand) {
                Dialog dialog2;
                ClientTransaction clientTransaction2;
                SipProfile sipProfile;
                this.mState = 5;
                MakeCallCommand makeCallCommand = (MakeCallCommand)eventObject;
                this.mPeerProfile = sipProfile = makeCallCommand.getPeerProfile();
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                SipProfile sipProfile2 = SipSessionGroup.this.mLocalProfile;
                SipProfile sipProfile3 = this.mPeerProfile;
                String string2 = makeCallCommand.getSessionDescription();
                String string3 = this.generateTag();
                this.mClientTransaction = clientTransaction2 = sipHelper.sendInvite(sipProfile2, sipProfile3, string2, string3);
                this.mDialog = dialog2 = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                int n = makeCallCommand.getTimeout();
                this.startSessionTimer(n);
                this.mProxy.onCalling(this);
                return true;
            }
            if (eventObject instanceof RegisterCommand) {
                Dialog dialog3;
                ClientTransaction clientTransaction3;
                this.mState = 1;
                int n = ((RegisterCommand)eventObject).getDuration();
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                SipProfile sipProfile = SipSessionGroup.this.mLocalProfile;
                String string4 = this.generateTag();
                this.mClientTransaction = clientTransaction3 = sipHelper.sendRegister(sipProfile, string4, n);
                this.mDialog = dialog3 = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.mProxy.onRegistering(this);
                return true;
            }
            if (DEREGISTER != eventObject) return false;
            this.mState = 2;
            SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
            SipProfile sipProfile = SipSessionGroup.this.mLocalProfile;
            String string5 = this.generateTag();
            this.mClientTransaction = clientTransaction = sipHelper.sendRegister(sipProfile, string5, 0);
            this.mDialog = dialog = this.mClientTransaction.getDialog();
            SipSessionGroup.this.addSipSession(this);
            this.mProxy.onRegistering(this);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean registeringToReady(EventObject eventObject) throws SipException {
            if (!SipSessionGroup.expectResponse("REGISTER", eventObject)) return false;
            ResponseEvent responseEvent = (ResponseEvent)eventObject;
            Response response = responseEvent.getResponse();
            int n = response.getStatusCode();
            switch (n) {
                default: {
                    if (n < 500) return false;
                    this.onRegistrationFailed(response);
                    return true;
                }
                case 200: {
                    int n2;
                    if (this.mState == 1) {
                        Response response2 = ((ResponseEvent)eventObject).getResponse();
                        n2 = this.getExpiryTime(response2);
                    } else {
                        n2 = -1;
                    }
                    this.onRegistrationDone(n2);
                    return true;
                }
                case 401: 
                case 407: {
                    boolean bl = this.handleAuthentication(responseEvent);
                    return true;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void reset() {
            this.mInCall = false;
            SipSessionGroup.this.removeSipSession(this);
            this.mPeerProfile = null;
            this.mState = 0;
            this.mInviteReceived = null;
            this.mPeerSessionDescription = null;
            this.mRPort = 0;
            this.mAuthenticationRetryCount = 0;
            if (this.mDialog != null) {
                this.mDialog.delete();
            }
            this.mDialog = null;
            try {
                if (this.mServerTransaction != null) {
                    this.mServerTransaction.terminate();
                }
            }
            catch (ObjectInUseException objectInUseException) {}
            this.mServerTransaction = null;
            try {
                if (this.mClientTransaction != null) {
                    this.mClientTransaction.terminate();
                }
            }
            catch (ObjectInUseException objectInUseException) {}
            this.mClientTransaction = null;
            this.cancelSessionTimer();
        }

        private void startSessionTimer(int n) {
            SessionTimer sessionTimer;
            if (n <= 0) {
                return;
            }
            this.mTimer = sessionTimer = new SessionTimer();
            this.mTimer.start(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        private String toString(Transaction transaction) {
            if (transaction == null) {
                return "null";
            }
            Request request = transaction.getRequest();
            Dialog dialog = transaction.getDialog();
            CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
            String string2 = "req=%s,%s,s=%s,ds=%s,";
            Object[] objectArray = new Object[4];
            String string3 = request.getMethod();
            objectArray[0] = string3;
            Long l = cSeqHeader.getSeqNumber();
            objectArray[1] = l;
            TransactionState transactionState = transaction.getState();
            objectArray[2] = transactionState;
            int n = 3;
            String string4 = dialog == null ? "-" : dialog.getState();
            objectArray[n] = string4;
            return String.format(string2, objectArray);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void answerCall(String string2, int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                try {
                    SipSessionGroup sipSessionGroup2 = SipSessionGroup.this;
                    SipProfile sipProfile = this.mPeerProfile;
                    MakeCallCommand makeCallCommand = sipSessionGroup2.new MakeCallCommand(sipProfile, string2, n);
                    this.processCommand(makeCallCommand);
                }
                catch (SipException sipException) {
                    this.onError(sipException);
                }
                return;
            }
        }

        @Override
        public void changeCall(String string2, int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                SipSessionGroup sipSessionGroup2 = SipSessionGroup.this;
                SipProfile sipProfile = this.mPeerProfile;
                MakeCallCommand makeCallCommand = sipSessionGroup2.new MakeCallCommand(sipProfile, string2, n);
                this.doCommandAsync(makeCallCommand);
                return;
            }
        }

        public void clearReRegisterRequired() {
            this.mReRegisterFlag = false;
        }

        SipSessionImpl duplicate() {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            ISipSessionListener iSipSessionListener = this.mProxy.getListener();
            return sipSessionGroup.new SipSessionImpl(iSipSessionListener);
        }

        @Override
        public void endCall() {
            EventObject eventObject = END_CALL;
            this.doCommandAsync(eventObject);
        }

        protected String generateTag() {
            return String.valueOf((long)(Math.random() * 4.294967296E9));
        }

        @Override
        public String getCallId() {
            return SipHelper.getCallId(this.getTransaction());
        }

        @Override
        public String getLocalIp() {
            return SipSessionGroup.this.mLocalIp;
        }

        @Override
        public SipProfile getLocalProfile() {
            return SipSessionGroup.this.mLocalProfile;
        }

        @Override
        public SipProfile getPeerProfile() {
            return this.mPeerProfile;
        }

        @Override
        public int getState() {
            return this.mState;
        }

        @Override
        public boolean isInCall() {
            return this.mInCall;
        }

        public boolean isReRegisterRequired() {
            return this.mReRegisterFlag;
        }

        @Override
        public void makeCall(SipProfile sipProfile, String string2, int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            MakeCallCommand makeCallCommand = sipSessionGroup.new MakeCallCommand(sipProfile, string2, n);
            this.doCommandAsync(makeCallCommand);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean process(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(this, eventObject)) {
                StringBuilder stringBuilder = new StringBuilder().append(" ~~~~~   ").append(this).append(": ");
                String string2 = SipSession.State.toString(this.mState);
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": processing ");
                String string3 = SipSessionGroup.log(eventObject);
                String string4 = stringBuilder2.append(string3).toString();
                int n = Log.d(SipSessionGroup.TAG, string4);
            }
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                boolean bl;
                if (SipSessionGroup.this.isClosed()) {
                    return false;
                }
                Dialog dialog = null;
                if (eventObject instanceof RequestEvent) {
                    dialog = ((RequestEvent)eventObject).getDialog();
                } else if (eventObject instanceof ResponseEvent) {
                    dialog = ((ResponseEvent)eventObject).getDialog();
                }
                if (dialog != null) {
                    this.mDialog = dialog;
                }
                switch (this.mState) {
                    default: {
                        bl = false;
                        break;
                    }
                    case 1: 
                    case 2: {
                        bl = this.registeringToReady(eventObject);
                        break;
                    }
                    case 9: {
                        bl = this.keepAliveProcess(eventObject);
                        break;
                    }
                    case 0: {
                        bl = this.readyForCall(eventObject);
                        break;
                    }
                    case 3: {
                        bl = this.incomingCall(eventObject);
                        break;
                    }
                    case 4: {
                        bl = this.incomingCallToInCall(eventObject);
                        break;
                    }
                    case 5: 
                    case 6: {
                        bl = this.outgoingCall(eventObject);
                        break;
                    }
                    case 7: {
                        bl = this.outgoingCallToReady(eventObject);
                        break;
                    }
                    case 8: {
                        boolean bl2;
                        bl = bl2 = this.inCall(eventObject);
                    }
                }
                if (bl) return true;
                if (!this.processExceptions(eventObject)) return false;
                return true;
            }
        }

        @Override
        public void register(int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            RegisterCommand registerCommand = sipSessionGroup.new RegisterCommand(n);
            this.doCommandAsync(registerCommand);
        }

        public void sendKeepAlive() {
            this.mState = 9;
            try {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                OptionsCommand optionsCommand = sipSessionGroup.new OptionsCommand();
                this.processCommand(optionsCommand);
                int n = 0;
                while (true) {
                    int n2;
                    if (n >= 15 || 9 != (n2 = this.mState)) {
                        int n3 = this.mState;
                        if (9 != n3) {
                            return;
                        }
                        this.reset();
                        int n4 = Log.w(SipSessionGroup.TAG, "no response from ping");
                        return;
                    }
                    Thread.sleep(200L);
                    ++n;
                }
            }
            catch (SipException sipException) {
                int n = Log.e(SipSessionGroup.TAG, "sendKeepAlive failed", sipException);
                return;
            }
            catch (InterruptedException interruptedException) {
                int n = Log.e(SipSessionGroup.TAG, "sendKeepAlive interrupted", interruptedException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setListener(ISipSessionListener iSipSessionListener) {
            SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
            ISipSessionListener iSipSessionListener2 = iSipSessionListener instanceof SipSessionListenerProxy ? ((SipSessionListenerProxy)iSipSessionListener).getListener() : iSipSessionListener;
            sipSessionListenerProxy.setListener(iSipSessionListener2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            try {
                String string2 = super.toString();
                StringBuilder stringBuilder = new StringBuilder();
                int n = string2.indexOf("@");
                String string3 = string2.substring(n);
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(":");
                String string4 = SipSession.State.toString(this.mState);
                String string5 = stringBuilder2.append(string4).toString();
                return string5;
            }
            catch (Throwable throwable) {
                return super.toString();
            }
        }

        @Override
        public void unregister() {
            EventObject eventObject = DEREGISTER;
            this.doCommandAsync(eventObject);
        }

        class SessionTimer {
            private boolean mRunning = true;

            SessionTimer() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void sleep(int n) {
                synchronized (this) {
                    long l = n * 1000;
                    try {
                        this.wait(l);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        int n2 = Log.e(SipSessionGroup.TAG, "session timer interrupted!");
                        return;
                    }
                    finally {
                    }
                }
            }

            private void timeout() {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    SipSessionImpl.this.onError(-1, "Session timed out!");
                    return;
                }
            }

            void cancel() {
                synchronized (this) {
                    this.mRunning = false;
                    this.notify();
                    return;
                }
            }

            void start(final int n) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SessionTimer sessionTimer = SessionTimer.this;
                        int n2 = n;
                        sessionTimer.sleep(n2);
                        if (!SessionTimer.this.mRunning) {
                            return;
                        }
                        SessionTimer.this.timeout();
                    }
                };
                new Thread(runnable, "SipSessionTimerThread").start();
            }
        }
    }

    private class SipSessionCallReceiverImpl
    extends SipSessionImpl {
        public SipSessionCallReceiverImpl(ISipSessionListener iSipSessionListener) {
            super(iSipSessionListener);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean process(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(this, eventObject)) {
                StringBuilder stringBuilder = new StringBuilder().append(" ~~~~~   ").append(this).append(": ");
                String string2 = SipSession.State.toString(this.mState);
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": processing ");
                String string3 = SipSessionGroup.log(eventObject);
                String string4 = stringBuilder2.append(string3).toString();
                int n = Log.d(SipSessionGroup.TAG, string4);
            }
            if (SipSessionGroup.isRequestEvent("INVITE", eventObject)) {
                String string5;
                SipProfile sipProfile;
                Dialog dialog;
                ServerTransaction serverTransaction;
                RequestEvent requestEvent = (RequestEvent)eventObject;
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
                SipSessionImpl sipSessionImpl = sipSessionGroup.new SipSessionImpl(sipSessionListenerProxy);
                sipSessionImpl.mState = 3;
                SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
                String string6 = this.generateTag();
                sipSessionImpl.mServerTransaction = serverTransaction = sipHelper.sendRinging(requestEvent, string6);
                sipSessionImpl.mDialog = dialog = sipSessionImpl.mServerTransaction.getDialog();
                sipSessionImpl.mInviteReceived = requestEvent;
                sipSessionImpl.mPeerProfile = sipProfile = SipSessionGroup.createPeerProfile(requestEvent.getRequest());
                SipSessionGroup sipSessionGroup2 = SipSessionGroup.this;
                Request request = requestEvent.getRequest();
                sipSessionImpl.mPeerSessionDescription = string5 = sipSessionGroup2.extractContent((Message)request);
                SipSessionGroup.this.addSipSession(sipSessionImpl);
                SipSessionListenerProxy sipSessionListenerProxy2 = this.mProxy;
                SipProfile sipProfile2 = sipSessionImpl.mPeerProfile;
                String string7 = sipSessionImpl.mPeerSessionDescription;
                sipSessionListenerProxy2.onRinging(sipSessionImpl, sipProfile2, string7);
                return true;
            }
            if (!SipSessionGroup.isRequestEvent("OPTIONS", eventObject)) return false;
            SipHelper sipHelper = SipSessionGroup.this.mSipHelper;
            RequestEvent requestEvent = (RequestEvent)eventObject;
            sipHelper.sendResponse(requestEvent, 200);
            return true;
        }
    }
}

