/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms;

import java.util.ArrayList;

public class ContentType {
    public static final String APP_DRM_CONTENT = "application/vnd.oma.drm.content";
    public static final String APP_DRM_MESSAGE = "application/vnd.oma.drm.message";
    public static final String APP_SMIL = "application/smil";
    public static final String APP_WAP_XHTML = "application/vnd.wap.xhtml+xml";
    public static final String APP_XHTML = "application/xhtml+xml";
    public static final String AUDIO_3GPP = "audio/3gpp";
    public static final String AUDIO_AAC = "audio/aac";
    public static final String AUDIO_AMR = "audio/amr";
    public static final String AUDIO_IMELODY = "audio/imelody";
    public static final String AUDIO_MID = "audio/mid";
    public static final String AUDIO_MIDI = "audio/midi";
    public static final String AUDIO_MP3 = "audio/mp3";
    public static final String AUDIO_MP4 = "audio/mp4";
    public static final String AUDIO_MPEG = "audio/mpeg";
    public static final String AUDIO_MPEG3 = "audio/mpeg3";
    public static final String AUDIO_MPG = "audio/mpg";
    public static final String AUDIO_OGG = "application/ogg";
    public static final String AUDIO_UNSPECIFIED = "audio/*";
    public static final String AUDIO_X_MID = "audio/x-mid";
    public static final String AUDIO_X_MIDI = "audio/x-midi";
    public static final String AUDIO_X_MP3 = "audio/x-mp3";
    public static final String AUDIO_X_MPEG = "audio/x-mpeg";
    public static final String AUDIO_X_MPEG3 = "audio/x-mpeg3";
    public static final String AUDIO_X_MPG = "audio/x-mpg";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_JPG = "image/jpg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_UNSPECIFIED = "image/*";
    public static final String IMAGE_WBMP = "image/vnd.wap.wbmp";
    public static final String MMS_GENERIC = "application/vnd.wap.mms-generic";
    public static final String MMS_MESSAGE = "application/vnd.wap.mms-message";
    public static final String MULTIPART_ALTERNATIVE = "application/vnd.wap.multipart.alternative";
    public static final String MULTIPART_MIXED = "application/vnd.wap.multipart.mixed";
    public static final String MULTIPART_RELATED = "application/vnd.wap.multipart.related";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_VCALENDAR = "text/x-vCalendar";
    public static final String TEXT_VCARD = "text/x-vCard";
    public static final String VIDEO_3G2 = "video/3gpp2";
    public static final String VIDEO_3GPP = "video/3gpp";
    public static final String VIDEO_H263 = "video/h263";
    public static final String VIDEO_MP4 = "video/mp4";
    public static final String VIDEO_UNSPECIFIED = "video/*";
    private static final ArrayList<String> sSupportedAudioTypes;
    private static final ArrayList<String> sSupportedContentTypes;
    private static final ArrayList<String> sSupportedImageTypes;
    private static final ArrayList<String> sSupportedVideoTypes;

    static {
        sSupportedContentTypes = new ArrayList();
        sSupportedImageTypes = new ArrayList();
        sSupportedAudioTypes = new ArrayList();
        sSupportedVideoTypes = new ArrayList();
        boolean bl = sSupportedContentTypes.add(TEXT_PLAIN);
        boolean bl2 = sSupportedContentTypes.add(TEXT_HTML);
        boolean bl3 = sSupportedContentTypes.add(TEXT_VCALENDAR);
        boolean bl4 = sSupportedContentTypes.add(TEXT_VCARD);
        boolean bl5 = sSupportedContentTypes.add(IMAGE_JPEG);
        boolean bl6 = sSupportedContentTypes.add(IMAGE_GIF);
        boolean bl7 = sSupportedContentTypes.add(IMAGE_WBMP);
        boolean bl8 = sSupportedContentTypes.add(IMAGE_PNG);
        boolean bl9 = sSupportedContentTypes.add(IMAGE_JPG);
        boolean bl10 = sSupportedContentTypes.add(AUDIO_AAC);
        boolean bl11 = sSupportedContentTypes.add(AUDIO_AMR);
        boolean bl12 = sSupportedContentTypes.add(AUDIO_IMELODY);
        boolean bl13 = sSupportedContentTypes.add(AUDIO_MID);
        boolean bl14 = sSupportedContentTypes.add(AUDIO_MIDI);
        boolean bl15 = sSupportedContentTypes.add(AUDIO_MP3);
        boolean bl16 = sSupportedContentTypes.add(AUDIO_MPEG3);
        boolean bl17 = sSupportedContentTypes.add(AUDIO_MPEG);
        boolean bl18 = sSupportedContentTypes.add(AUDIO_MPG);
        boolean bl19 = sSupportedContentTypes.add(AUDIO_X_MID);
        boolean bl20 = sSupportedContentTypes.add(AUDIO_X_MIDI);
        boolean bl21 = sSupportedContentTypes.add(AUDIO_X_MP3);
        boolean bl22 = sSupportedContentTypes.add(AUDIO_X_MPEG3);
        boolean bl23 = sSupportedContentTypes.add(AUDIO_X_MPEG);
        boolean bl24 = sSupportedContentTypes.add(AUDIO_X_MPG);
        boolean bl25 = sSupportedContentTypes.add(AUDIO_3GPP);
        boolean bl26 = sSupportedContentTypes.add(AUDIO_OGG);
        boolean bl27 = sSupportedContentTypes.add(VIDEO_3GPP);
        boolean bl28 = sSupportedContentTypes.add(VIDEO_3G2);
        boolean bl29 = sSupportedContentTypes.add(VIDEO_H263);
        boolean bl30 = sSupportedContentTypes.add(VIDEO_MP4);
        boolean bl31 = sSupportedContentTypes.add(APP_SMIL);
        boolean bl32 = sSupportedContentTypes.add(APP_WAP_XHTML);
        boolean bl33 = sSupportedContentTypes.add(APP_XHTML);
        boolean bl34 = sSupportedContentTypes.add(APP_DRM_CONTENT);
        boolean bl35 = sSupportedContentTypes.add(APP_DRM_MESSAGE);
        boolean bl36 = sSupportedImageTypes.add(IMAGE_JPEG);
        boolean bl37 = sSupportedImageTypes.add(IMAGE_GIF);
        boolean bl38 = sSupportedImageTypes.add(IMAGE_WBMP);
        boolean bl39 = sSupportedImageTypes.add(IMAGE_PNG);
        boolean bl40 = sSupportedImageTypes.add(IMAGE_JPG);
        boolean bl41 = sSupportedAudioTypes.add(AUDIO_AAC);
        boolean bl42 = sSupportedAudioTypes.add(AUDIO_AMR);
        boolean bl43 = sSupportedAudioTypes.add(AUDIO_IMELODY);
        boolean bl44 = sSupportedAudioTypes.add(AUDIO_MID);
        boolean bl45 = sSupportedAudioTypes.add(AUDIO_MIDI);
        boolean bl46 = sSupportedAudioTypes.add(AUDIO_MP3);
        boolean bl47 = sSupportedAudioTypes.add(AUDIO_MPEG3);
        boolean bl48 = sSupportedAudioTypes.add(AUDIO_MPEG);
        boolean bl49 = sSupportedAudioTypes.add(AUDIO_MPG);
        boolean bl50 = sSupportedAudioTypes.add(AUDIO_MP4);
        boolean bl51 = sSupportedAudioTypes.add(AUDIO_X_MID);
        boolean bl52 = sSupportedAudioTypes.add(AUDIO_X_MIDI);
        boolean bl53 = sSupportedAudioTypes.add(AUDIO_X_MP3);
        boolean bl54 = sSupportedAudioTypes.add(AUDIO_X_MPEG3);
        boolean bl55 = sSupportedAudioTypes.add(AUDIO_X_MPEG);
        boolean bl56 = sSupportedAudioTypes.add(AUDIO_X_MPG);
        boolean bl57 = sSupportedAudioTypes.add(AUDIO_3GPP);
        boolean bl58 = sSupportedAudioTypes.add(AUDIO_OGG);
        boolean bl59 = sSupportedVideoTypes.add(VIDEO_3GPP);
        boolean bl60 = sSupportedVideoTypes.add(VIDEO_3G2);
        boolean bl61 = sSupportedVideoTypes.add(VIDEO_H263);
        boolean bl62 = sSupportedVideoTypes.add(VIDEO_MP4);
    }

    private ContentType() {
    }

    public static ArrayList<String> getAudioTypes() {
        return (ArrayList)sSupportedAudioTypes.clone();
    }

    public static ArrayList<String> getImageTypes() {
        return (ArrayList)sSupportedImageTypes.clone();
    }

    public static ArrayList<String> getSupportedTypes() {
        return (ArrayList)sSupportedContentTypes.clone();
    }

    public static ArrayList<String> getVideoTypes() {
        return (ArrayList)sSupportedVideoTypes.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAudioType(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("audio/")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDrmType(String string2) {
        if (string2 == null) return false;
        if (string2.equals(APP_DRM_CONTENT)) return true;
        if (!string2.equals(APP_DRM_MESSAGE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isImageType(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("image/")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupportedAudioType(String string2) {
        if (!ContentType.isAudioType(string2)) return false;
        if (!ContentType.isSupportedType(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupportedImageType(String string2) {
        if (!ContentType.isImageType(string2)) return false;
        if (!ContentType.isSupportedType(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupportedType(String string2) {
        if (string2 == null) return false;
        if (!sSupportedContentTypes.contains(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupportedVideoType(String string2) {
        if (!ContentType.isVideoType(string2)) return false;
        if (!ContentType.isSupportedType(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTextType(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("text/")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUnspecified(String string2) {
        if (string2 == null) return false;
        if (!string2.endsWith("*")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVideoType(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("video/")) return false;
        return true;
    }
}

