/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

public class Base64 {
    static final int BASELENGTH = 255;
    static final int FOURBYTE = 4;
    static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];

    static {
        for (int i = 0; i < 255; ++i) {
            Base64.base64Alphabet[i] = -1;
        }
        for (int i = 90; i >= 65; i += -1) {
            byte by;
            byte[] byArray = base64Alphabet;
            byArray[i] = by = (byte)(i - 65);
        }
        for (int i = 122; i >= 97; i += -1) {
            byte by;
            byte[] byArray = base64Alphabet;
            byArray[i] = by = (byte)(i - 97 + 26);
        }
        for (int i = 57; i >= 48; i += -1) {
            byte by;
            byte[] byArray = base64Alphabet;
            byArray[i] = by = (byte)(i - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] decodeBase64(byte[] byArray) {
        int n;
        byte[] byArray2 = Base64.discardNonBase64(byArray);
        if (byArray2.length == 0) {
            return new byte[0];
        }
        int n2 = byArray2.length / 4;
        int n3 = 0;
        int n4 = byArray2.length;
        while (byArray2[n = n4 - 1] == 61) {
            int n5 = n4 + -1;
            if (n5 != null) continue;
            return new byte[0];
        }
        byte[] byArray3 = new byte[n4 - n2];
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n6 * 4;
            int n8 = n7 + 2;
            byte by = byArray2[n8];
            int n9 = n7 + 3;
            byte by2 = byArray2[n9];
            byte[] byArray4 = base64Alphabet;
            byte by3 = byArray2[n7];
            byte by4 = byArray4[by3];
            byte[] byArray5 = base64Alphabet;
            int n10 = n7 + 1;
            byte by5 = byArray2[n10];
            byte by6 = byArray5[by5];
            if (by != 61 && by2 != 61) {
                byte by7;
                byte by8;
                byte by9;
                byte by10 = base64Alphabet[by];
                byte by11 = base64Alphabet[by2];
                int n11 = by4 << 2;
                int n12 = by6 >> 4;
                byArray3[n3] = by9 = (byte)(n11 | n12);
                int n13 = n3 + 1;
                int n14 = (by6 & 0xF) << 4;
                int n15 = by10 >> 2 & 0xF;
                byArray3[n13] = by8 = (byte)(n14 | n15);
                int n16 = n3 + 2;
                byArray3[n16] = by7 = (byte)(by10 << 6 | by11);
            } else if (by == 61) {
                byte by12;
                int n17 = by4 << 2;
                int n18 = by6 >> 4;
                byArray3[n3] = by12 = (byte)(n17 | n18);
            } else if (by2 == 61) {
                byte by13;
                byte by14;
                byte by15 = base64Alphabet[by];
                int n19 = by4 << 2;
                int n20 = by6 >> 4;
                byArray3[n3] = by14 = (byte)(n19 | n20);
                int n21 = n3 + 1;
                int n22 = (by6 & 0xF) << 4;
                int n23 = by15 >> 2 & 0xF;
                byArray3[n21] = by13 = (byte)(n22 | n23);
            }
            n3 += 3;
            int n24 = n6 + 1;
        }
        return byArray3;
    }

    static byte[] discardNonBase64(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i = 0; i < (n = byArray.length); ++i) {
            byte by;
            if (!Base64.isBase64(byArray[i])) continue;
            int n3 = n2 + 1;
            byArray2[n2] = by = byArray[i];
            n2 = n3;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isBase64(byte by) {
        if (by == 61) {
            return true;
        }
        if (base64Alphabet[by] != -1) return true;
        return false;
    }
}

