/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.util.Log;
import com.google.android.mms.pdu.CharacterSets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class EncodedStringValue
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final String TAG = "EncodedStringValue";
    private int mCharacterSet;
    private byte[] mData;

    public EncodedStringValue(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        this.mCharacterSet = n;
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = this.mData = byArray2;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n2);
    }

    public EncodedStringValue(String string2) {
        try {
            byte[] byArray = string2.getBytes("utf-8");
            this.mData = byArray;
            this.mCharacterSet = 106;
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = Log.e(TAG, "Default encoding must be supported.", unsupportedEncodingException);
            return;
        }
    }

    public EncodedStringValue(byte[] byArray) {
        this(106, byArray);
    }

    public static String concat(EncodedStringValue[] encodedStringValueArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = encodedStringValueArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            String string2 = encodedStringValueArray[i].getString();
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            if (i >= n) continue;
            StringBuilder stringBuilder3 = stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncodedStringValue copy(EncodedStringValue encodedStringValue) {
        if (encodedStringValue == null) {
            return null;
        }
        int n = encodedStringValue.mCharacterSet;
        byte[] byArray = encodedStringValue.mData;
        return new EncodedStringValue(n, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncodedStringValue[] encodeStrings(String[] stringArray) {
        int n = stringArray.length;
        if (n <= 0) return null;
        EncodedStringValue[] encodedStringValueArray = new EncodedStringValue[n];
        int n2 = 0;
        while (n2 < n) {
            EncodedStringValue encodedStringValue;
            String string2 = stringArray[n2];
            encodedStringValueArray[n2] = encodedStringValue = new EncodedStringValue(string2);
            ++n2;
        }
        return encodedStringValueArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncodedStringValue[] extract(String string2) {
        int n;
        String[] stringArray = string2.split(";");
        ArrayList<EncodedStringValue> arrayList = new ArrayList<EncodedStringValue>();
        for (int i = 0; i < (n = stringArray.length); ++i) {
            if (stringArray[i].length() <= 0) continue;
            String string3 = stringArray[i];
            EncodedStringValue encodedStringValue = new EncodedStringValue(string3);
            boolean bl = arrayList.add(encodedStringValue);
        }
        int n2 = arrayList.size();
        if (n2 <= 0) return null;
        EncodedStringValue[] encodedStringValueArray = new EncodedStringValue[n2];
        return arrayList.toArray(encodedStringValueArray);
    }

    public void appendTextString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Text-string is null.");
        }
        if (this.mData == null) {
            byte[] byArray2 = new byte[byArray.length];
            byte[] byArray3 = this.mData = byArray2;
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray3, 0, n);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray4 = this.mData;
            byteArrayOutputStream.write(byArray4);
            byteArrayOutputStream.write(byArray);
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            this.mData = byArray5;
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new NullPointerException("appendTextString: failed when write a new Text-string");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        int n = this.mData.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.mData, 0, byArray, 0, n);
        try {
            int n2 = this.mCharacterSet;
            EncodedStringValue encodedStringValue = new EncodedStringValue(n2, byArray);
            return encodedStringValue;
        }
        catch (Exception exception) {
            String string2 = "failed to clone an EncodedStringValue: " + this;
            int n3 = Log.e(TAG, string2);
            exception.printStackTrace();
            String string3 = exception.getMessage();
            throw new CloneNotSupportedException(string3);
        }
    }

    public int getCharacterSet() {
        return this.mCharacterSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString() {
        if (this.mCharacterSet == 0) {
            byte[] byArray = this.mData;
            return new String(byArray);
        }
        try {
            String string2 = CharacterSets.getMimeName(this.mCharacterSet);
            byte[] byArray = this.mData;
            return new String(byArray, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byte[] byArray = this.mData;
                return new String(byArray, "iso-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byte[] byArray = this.mData;
                return new String(byArray);
            }
        }
    }

    public byte[] getTextString() {
        byte[] byArray = new byte[this.mData.length];
        byte[] byArray2 = this.mData;
        int n = this.mData.length;
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public void setCharacterSet(int n) {
        this.mCharacterSet = n;
    }

    public void setTextString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = this.mData = byArray2;
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EncodedStringValue[] split(String string2) {
        int n;
        String[] stringArray = this.getString().split(string2);
        EncodedStringValue[] encodedStringValueArray = new EncodedStringValue[stringArray.length];
        int n2 = 0;
        while (n2 < (n = encodedStringValueArray.length)) {
            try {
                EncodedStringValue encodedStringValue;
                int n3 = this.mCharacterSet;
                byte[] byArray = stringArray[n2].getBytes();
                encodedStringValueArray[n2] = encodedStringValue = new EncodedStringValue(n3, byArray);
                ++n2;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return encodedStringValueArray;
    }
}

