/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduContentTypes;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.SendReq;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PduComposer {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int END_STRING_FLAG = 0;
    private static final int LENGTH_QUOTE = 31;
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int PDU_COMPOSER_BLOCK_SIZE = 1024;
    private static final int PDU_COMPOSE_CONTENT_ERROR = 1;
    private static final int PDU_COMPOSE_FIELD_NOT_SET = 2;
    private static final int PDU_COMPOSE_FIELD_NOT_SUPPORTED = 3;
    private static final int PDU_COMPOSE_SUCCESS = 0;
    private static final int PDU_EMAIL_ADDRESS_TYPE = 2;
    private static final int PDU_IPV4_ADDRESS_TYPE = 3;
    private static final int PDU_IPV6_ADDRESS_TYPE = 4;
    private static final int PDU_PHONE_NUMBER_ADDRESS_TYPE = 1;
    private static final int PDU_UNKNOWN_ADDRESS_TYPE = 5;
    private static final int QUOTED_STRING_FLAG = 34;
    static final String REGEXP_EMAIL_ADDRESS_TYPE = "[a-zA-Z| ]*\\<{0,1}[a-zA-Z| ]+@{1}[a-zA-Z| ]+\\.{1}[a-zA-Z| ]+\\>{0,1}";
    static final String REGEXP_IPV4_ADDRESS_TYPE = "[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}";
    static final String REGEXP_IPV6_ADDRESS_TYPE = "[a-fA-F]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}";
    static final String REGEXP_PHONE_NUMBER_ADDRESS_TYPE = "\\+?[0-9|\\.|\\-]+";
    private static final int SHORT_INTEGER_MAX = 127;
    static final String STRING_IPV4_ADDRESS_TYPE = "/TYPE=IPV4";
    static final String STRING_IPV6_ADDRESS_TYPE = "/TYPE=IPV6";
    static final String STRING_PHONE_NUMBER_ADDRESS_TYPE = "/TYPE=PLMN";
    private static final int TEXT_MAX = 127;
    private static HashMap<String, Integer> mContentTypeMap;
    protected ByteArrayOutputStream mMessage = null;
    private GenericPdu mPdu = null;
    private PduHeaders mPduHeader = null;
    protected int mPosition = 0;
    private final ContentResolver mResolver;
    private BufferStack mStack = null;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !PduComposer.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        mContentTypeMap = null;
        mContentTypeMap = new HashMap();
        int n = 0;
        int n2;
        while (n < (n2 = PduContentTypes.contentTypes.length)) {
            HashMap<String, Integer> hashMap = mContentTypeMap;
            String string2 = PduContentTypes.contentTypes[n];
            Integer n3 = n;
            Integer n4 = hashMap.put(string2, n3);
            ++n;
        }
        return;
    }

    public PduComposer(Context context, GenericPdu genericPdu) {
        ByteArrayOutputStream byteArrayOutputStream;
        BufferStack bufferStack;
        PduHeaders pduHeaders;
        ContentResolver contentResolver;
        this.mPdu = genericPdu;
        this.mResolver = contentResolver = context.getContentResolver();
        this.mPduHeader = pduHeaders = genericPdu.getPduHeaders();
        this.mStack = bufferStack = new BufferStack();
        this.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
        this.mPosition = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EncodedStringValue appendAddressType(EncodedStringValue encodedStringValue) {
        EncodedStringValue encodedStringValue2;
        int n;
        block4: {
            try {
                n = PduComposer.checkAddressType(encodedStringValue.getString());
                encodedStringValue2 = EncodedStringValue.copy(encodedStringValue);
                if (1 != n) {
                    byte[] byArray = STRING_PHONE_NUMBER_ADDRESS_TYPE.getBytes();
                    encodedStringValue2.appendTextString(byArray);
                    return encodedStringValue2;
                }
                if (3 == n) break block4;
                byte[] byArray = STRING_IPV4_ADDRESS_TYPE.getBytes();
                encodedStringValue2.appendTextString(byArray);
                return encodedStringValue2;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        if (4 == n) return encodedStringValue2;
        byte[] byArray = STRING_IPV6_ADDRESS_TYPE.getBytes();
        encodedStringValue2.appendTextString(byArray);
        return encodedStringValue2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int appendHeader(int n) {
        switch (n) {
            default: {
                return 3;
            }
            case 141: {
                this.appendOctet(n);
                PduHeaders pduHeaders = this.mPduHeader;
                int n2 = n;
                int n3 = pduHeaders.getOctet(n2);
                if (n3 == 0) {
                    PduComposer pduComposer = this;
                    int n4 = 18;
                    pduComposer.appendShortInteger(n4);
                    return 0;
                }
                PduComposer pduComposer = this;
                int n5 = n3;
                pduComposer.appendShortInteger(n5);
                return 0;
            }
            case 139: 
            case 152: {
                PduHeaders pduHeaders = this.mPduHeader;
                int n6 = n;
                byte[] byArray = pduHeaders.getTextString(n6);
                if (byArray == null) {
                    return 2;
                }
                this.appendOctet(n);
                PduComposer pduComposer = this;
                byte[] byArray2 = byArray;
                pduComposer.appendTextString(byArray2);
                return 0;
            }
            case 129: 
            case 130: 
            case 151: {
                int n7;
                int n8;
                int n9;
                PduHeaders pduHeaders = this.mPduHeader;
                int n10 = n;
                EncodedStringValue[] encodedStringValueArray = pduHeaders.getEncodedStringValues(n10);
                if (encodedStringValueArray == null) {
                    return 2;
                }
                int n11 = 0;
                while ((n9 = ++n11) < (n8 = (n7 = encodedStringValueArray.length))) {
                    PduComposer pduComposer = this;
                    EncodedStringValue encodedStringValue = encodedStringValueArray[n11];
                    EncodedStringValue encodedStringValue2 = encodedStringValue;
                    EncodedStringValue encodedStringValue3 = pduComposer.appendAddressType(encodedStringValue2);
                    if (encodedStringValue3 == null) {
                        return 1;
                    }
                    this.appendOctet(n);
                    PduComposer pduComposer2 = this;
                    EncodedStringValue encodedStringValue4 = encodedStringValue3;
                    pduComposer2.appendEncodedString(encodedStringValue4);
                }
                return 0;
            }
            case 137: {
                byte[] byArray;
                this.appendOctet(n);
                PduHeaders pduHeaders = this.mPduHeader;
                int n12 = n;
                EncodedStringValue encodedStringValue = pduHeaders.getEncodedStringValue(n12);
                if (encodedStringValue == null || TextUtils.isEmpty(encodedStringValue.getString()) || new String(byArray = encodedStringValue.getTextString()).equals("insert-address-token")) {
                    PduComposer pduComposer = this;
                    int n13 = 1;
                    pduComposer.append(n13);
                    PduComposer pduComposer3 = this;
                    int n14 = 129;
                    pduComposer3.append(n14);
                    return 0;
                }
                this.mStack.newbuf();
                PositionMarker positionMarker = this.mStack.mark();
                PduComposer pduComposer = this;
                int n15 = 128;
                pduComposer.append(n15);
                PduComposer pduComposer4 = this;
                EncodedStringValue encodedStringValue5 = encodedStringValue;
                EncodedStringValue encodedStringValue6 = pduComposer4.appendAddressType(encodedStringValue5);
                if (encodedStringValue6 == null) {
                    return 1;
                }
                PduComposer pduComposer5 = this;
                EncodedStringValue encodedStringValue7 = encodedStringValue6;
                pduComposer5.appendEncodedString(encodedStringValue7);
                int n16 = positionMarker.getLength();
                this.mStack.pop();
                long l = n16;
                PduComposer pduComposer6 = this;
                long l2 = l;
                pduComposer6.appendValueLength(l2);
                this.mStack.copy();
                return 0;
            }
            case 134: 
            case 143: 
            case 144: 
            case 145: 
            case 149: 
            case 155: {
                PduHeaders pduHeaders = this.mPduHeader;
                int n17 = n;
                int n18 = pduHeaders.getOctet(n17);
                if (n18 == 0) {
                    return 2;
                }
                this.appendOctet(n);
                PduComposer pduComposer = this;
                int n19 = n18;
                pduComposer.appendOctet(n19);
                return 0;
            }
            case 133: {
                PduHeaders pduHeaders = this.mPduHeader;
                int n20 = n;
                long l = pduHeaders.getLongInteger(n20);
                if (65535L == l) {
                    return 2;
                }
                this.appendOctet(n);
                PduComposer pduComposer = this;
                long l3 = l;
                pduComposer.appendDateValue(l3);
                return 0;
            }
            case 150: {
                PduHeaders pduHeaders = this.mPduHeader;
                int n21 = n;
                EncodedStringValue encodedStringValue = pduHeaders.getEncodedStringValue(n21);
                if (encodedStringValue == null) {
                    return 2;
                }
                this.appendOctet(n);
                PduComposer pduComposer = this;
                EncodedStringValue encodedStringValue8 = encodedStringValue;
                pduComposer.appendEncodedString(encodedStringValue8);
                return 0;
            }
            case 138: {
                PduHeaders pduHeaders = this.mPduHeader;
                int n22 = n;
                byte[] byArray = pduHeaders.getTextString(n22);
                if (byArray == null) {
                    return 2;
                }
                this.appendOctet(n);
                byte[] byArray3 = "advertisement".getBytes();
                byte[] byArray4 = byArray;
                byte[] byArray5 = byArray3;
                if (Arrays.equals(byArray4, byArray5)) {
                    PduComposer pduComposer = this;
                    int n23 = 129;
                    pduComposer.appendOctet(n23);
                    return 0;
                }
                byte[] byArray6 = byArray;
                byte[] byArray7 = "auto".getBytes();
                byte[] byArray8 = byArray7;
                if (Arrays.equals(byArray6, byArray8)) {
                    PduComposer pduComposer = this;
                    int n24 = 131;
                    pduComposer.appendOctet(n24);
                    return 0;
                }
                byte[] byArray9 = byArray;
                byte[] byArray10 = "personal".getBytes();
                byte[] byArray11 = byArray10;
                if (Arrays.equals(byArray9, byArray11)) {
                    PduComposer pduComposer = this;
                    int n25 = 128;
                    pduComposer.appendOctet(n25);
                    return 0;
                }
                byte[] byArray12 = byArray;
                byte[] byArray13 = "informational".getBytes();
                byte[] byArray14 = byArray13;
                if (Arrays.equals(byArray12, byArray14)) {
                    PduComposer pduComposer = this;
                    int n26 = 130;
                    pduComposer.appendOctet(n26);
                    return 0;
                }
                PduComposer pduComposer = this;
                byte[] byArray15 = byArray;
                pduComposer.appendTextString(byArray15);
                return 0;
            }
            case 136: 
        }
        PduHeaders pduHeaders = this.mPduHeader;
        int n27 = n;
        long l = pduHeaders.getLongInteger(n27);
        if (65535L == l) {
            return 2;
        }
        this.appendOctet(n);
        this.mStack.newbuf();
        PositionMarker positionMarker = this.mStack.mark();
        PduComposer pduComposer = this;
        int n28 = 129;
        pduComposer.append(n28);
        PduComposer pduComposer7 = this;
        long l4 = l;
        pduComposer7.appendLongInteger(l4);
        int n29 = positionMarker.getLength();
        this.mStack.pop();
        long l5 = n29;
        PduComposer pduComposer8 = this;
        long l6 = l5;
        pduComposer8.appendValueLength(l6);
        this.mStack.copy();
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int checkAddressType(String string2) {
        if (string2 == null) {
            return 5;
        }
        if (string2.matches(REGEXP_IPV4_ADDRESS_TYPE)) {
            return 3;
        }
        if (string2.matches(REGEXP_PHONE_NUMBER_ADDRESS_TYPE)) {
            return 1;
        }
        if (string2.matches(REGEXP_EMAIL_ADDRESS_TYPE)) {
            return 2;
        }
        if (!string2.matches(REGEXP_IPV6_ADDRESS_TYPE)) return 5;
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int makeAckInd() {
        if (this.mMessage == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(133);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        int n = this.appendHeader(145);
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int makeMessageBody() {
        block27: {
            block26: {
                this.mStack.newbuf();
                var1_1 = this.mStack.mark();
                var3_3 = this.mPduHeader.getTextString(132);
                var4_4 = var2_2;
                var5_5 = var3_3;
                var4_4(var5_5);
                var6_6 = PduComposer.mContentTypeMap;
                var7_7 = var2_2;
                var8_8 = var6_6.get(var7_7);
                if (var8_8 == null) {
                    return 1;
                }
                var10_10 = var8_8;
                var11_11 = this;
                var12_12 = var10_10;
                var11_11.appendShortInteger(var12_12);
                var13_13 = ((SendReq)this.mPdu).getBody();
                if (var13_13 == null || var13_13.getPartsNum() == 0) {
                    var14_14 = this;
                    var15_15 = 0L;
                    var14_14.appendUintvarInteger(var15_15);
                    this.mStack.pop();
                    this.mStack.copy();
                    return 0;
                }
                var17_16 = 0;
                try {
                    var18_17 = var13_13;
                    var19_18 = var17_16;
                    var20_19 = var18_17.getPart(var19_18);
                    var21_20 = var20_19.getContentId();
                    if (var21_20 == null) break block26;
                    var22_21 = this;
                    var23_22 = 138;
                    var22_21.appendOctet(var23_22);
                    var24_23 = var21_20[0];
                    var26_24 = var24_23 = 60;
                    if (var24_23 == var26_24) ** GOTO lbl-1000
                    var27_25 = var21_20.length - 1;
                    var28_26 = var21_20[var27_25];
                    var30_27 = var28_26 = 62;
                    if (var28_26 != var30_27) {
                        var31_28 = this;
                        var32_29 = var21_20;
                        var31_28.appendTextString(var32_29);
                    }
                    ** GOTO lbl-1000
                }
                catch (ArrayIndexOutOfBoundsException v0) {
                    v0.printStackTrace();
                    ** GOTO lbl58
                }
            }
lbl50:
            // 2 sources

            while (true) {
                var33_37 = this;
                var34_38 = 137;
                var33_37.appendOctet(var34_38);
                var35_39 = var20_19.getContentType();
                var36_40 = this;
                var37_41 = var35_39;
                var36_40.appendTextString(var37_41);
lbl58:
                // 2 sources

                var38_42 = var1_1.getLength();
                this.mStack.pop();
                var39_43 = var38_42;
                var41_44 = this;
                var42_45 = var39_43;
                var41_44.appendValueLength(var42_45);
                this.mStack.copy();
                var44_46 = var13_13.getPartsNum();
                var45_47 = var44_46;
                var47_48 = this;
                var48_49 = var45_47;
                var47_48.appendUintvarInteger(var48_49);
                var50_50 = 0;
lbl71:
                // 2 sources

                while (true) {
                    var52_52 = var44_46;
                    if ((var51_51 = ++var50_50) >= var52_52) {
                        return 0;
                    }
                    var53_53 = var13_13;
                    var54_54 = var50_50;
                    var20_19 = var53_53.getPart(var54_54);
                    this.mStack.newbuf();
                    var55_55 = this.mStack.mark();
                    this.mStack.newbuf();
                    var56_56 = this.mStack.mark();
                    var57_57 = var20_19.getContentType();
                    if (var57_57 == null) {
                        return 1;
                    }
                    break block27;
                    break;
                }
                break;
            }
lbl-1000:
            // 2 sources

            {
                var58_31 = new StringBuilder().append("<");
                var60_33 = var59_32;
                var61_34 = var21_20;
                var60_33(var61_34);
                var62_35 = var58_31.append(var59_32).append(">").toString();
                var63_36 = this;
                var64_30 = var62_35;
                var63_36.appendTextString(var64_30);
                ** continue;
            }
        }
        var65_58 = PduComposer.mContentTypeMap;
        var67_60 = var66_59;
        var68_61 = var57_57;
        var67_60(var68_61);
        var69_62 = var65_58.get(var66_59);
        if (var69_62 == null) {
            var70_63 = this;
            var71_64 = var57_57;
            var70_63.appendTextString(var71_64);
        } else {
            var73_66 = var69_62;
            var74_67 = this;
            var75_68 = var73_66;
            var74_67.appendShortInteger(var75_68);
        }
        if ((var72_65 = var20_19.getName()) == null && (var72_65 = var20_19.getFilename()) == null && (var72_65 = var20_19.getContentLocation()) == null) {
            return 1;
        }
        var76_69 = this;
        var77_70 = 133;
        var76_69.appendOctet(var77_70);
        var78_71 = this;
        var79_72 = var72_65;
        var78_71.appendTextString(var79_72);
        var80_73 = var20_19.getCharset();
        if (var80_73 != 0) {
            var81_74 = this;
            var82_75 = 129;
            var81_74.appendOctet(var82_75);
            var83_76 = this;
            var84_77 = var80_73;
            var83_76.appendShortInteger(var84_77);
        }
        var85_78 = var56_56.getLength();
        this.mStack.pop();
        var86_79 = var85_78;
        var88_80 = this;
        var89_82 = var86_79;
        var88_80.appendValueLength(var89_82);
        this.mStack.copy();
        var91_83 = var20_19.getContentId();
        if (var91_83 != null) {
            var92_84 = this;
            var93_86 = 192;
            var92_84.appendOctet(var93_86);
            var94_87 = var91_83[0];
            var88_81 = 60;
            var96_88 = var94_87;
            if (var88_81 != var96_88 && (var92_85 = 62) != (var100_91 = (var98_90 = var91_83[var97_89 = var91_83.length - 1]))) {
                var101_92 = this;
                var102_93 = var91_83;
                var101_92.appendQuotedString(var102_93);
            } else {
                var119_110 = new StringBuilder().append("<");
                var121_112 = var120_111;
                var122_113 = var91_83;
                var121_112(var122_113);
                var123_114 = var119_110.append(var120_111).append(">").toString();
                var124_115 = this;
                var125_116 = var123_114;
                var124_115.appendQuotedString(var125_116);
            }
        }
        if ((var103_94 = var20_19.getContentLocation()) != null) {
            var104_95 = this;
            var105_96 = 142;
            var104_95.appendOctet(var105_96);
            var106_97 = this;
            var107_98 = var103_94;
            var106_97.appendTextString(var107_98);
        }
        var108_99 = var55_55.getLength();
        var109_100 = 0;
        var110_101 = var20_19.getData();
        if (var110_101 != null) {
            var111_102 = var110_101.length;
            var112_103 = this;
            var113_104 = var110_101;
            var114_105 = 0;
            var115_106 = var111_102;
            var112_103.arraycopy(var113_104, var114_105, var115_106);
            var109_100 = var110_101.length;
        } else {
            var126_117 = 1024;
            try {
                var127_118 = new byte[var126_117];
                var128_119 = this.mResolver;
                var129_120 = var20_19.getDataUri();
                var130_121 = var128_119.openInputStream(var129_120);
                while ((var132_123 = (var131_122 = var130_121.read(var127_118))) != (var126_117 = 65535)) {
                    var134_124 = this.mMessage;
                    var135_125 = var127_118;
                    var136_126 = 0;
                    var137_127 = var131_122;
                    var134_124.write(var135_125, var136_126, var137_127);
                    this.mPosition = var138_128 = this.mPosition + var131_122;
                    var109_100 += var131_122;
                }
            }
            catch (FileNotFoundException var139_135) {
                return 1;
            }
            catch (IOException var140_136) {
                return 1;
            }
            catch (RuntimeException var141_137) {
                return 1;
            }
        }
        if ((var117_108 = var109_100) != (var118_109 = (var116_107 = var55_55.getLength() - var108_99))) {
            throw new RuntimeException("BUG: Length sanity check failed");
        }
        this.mStack.pop();
        var142_129 = var108_99;
        var144_130 = this;
        var145_131 = var142_129;
        var144_130.appendUintvarInteger(var145_131);
        var147_132 = var109_100;
        var149_133 = this;
        var150_134 = var147_132;
        var149_133.appendUintvarInteger(var150_134);
        this.mStack.copy();
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int makeNotifyResp() {
        if (this.mMessage == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(131);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(149) == 0) return 0;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int makeReadRecInd() {
        if (this.mMessage == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(135);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(139) != 0) {
            return 1;
        }
        if (this.appendHeader(151) != 0) {
            return 1;
        }
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        int n = this.appendHeader(133);
        if (this.appendHeader(155) == 0) return 0;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int makeSendReqPdu() {
        if (this.mMessage == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(128);
        this.appendOctet(152);
        byte[] byArray = this.mPduHeader.getTextString(152);
        if (byArray == null) {
            throw new IllegalArgumentException("Transaction-ID is null.");
        }
        this.appendTextString(byArray);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        int n = this.appendHeader(133);
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        boolean bl = false;
        if (this.appendHeader(151) != 1) {
            bl = true;
        }
        if (this.appendHeader(130) != 1) {
            bl = true;
        }
        if (this.appendHeader(129) != 1) {
            bl = true;
        }
        if (!bl) {
            return 1;
        }
        int n2 = this.appendHeader(150);
        int n3 = this.appendHeader(138);
        int n4 = this.appendHeader(136);
        int n5 = this.appendHeader(143);
        int n6 = this.appendHeader(134);
        int n7 = this.appendHeader(144);
        this.appendOctet(132);
        int n8 = this.makeMessageBody();
        return 0;
    }

    protected void append(int n) {
        int n2;
        this.mMessage.write(n);
        this.mPosition = n2 = this.mPosition + 1;
    }

    protected void appendDateValue(long l) {
        this.appendLongInteger(l);
    }

    protected void appendEncodedString(EncodedStringValue encodedStringValue) {
        if (!$assertionsDisabled && encodedStringValue == null) {
            throw new AssertionError();
        }
        int n = encodedStringValue.getCharacterSet();
        byte[] byArray = encodedStringValue.getTextString();
        if (byArray == null) {
            return;
        }
        this.mStack.newbuf();
        PositionMarker positionMarker = this.mStack.mark();
        this.appendShortInteger(n);
        this.appendTextString(byArray);
        int n2 = positionMarker.getLength();
        this.mStack.pop();
        long l = n2;
        this.appendValueLength(l);
        this.mStack.copy();
    }

    protected void appendLongInteger(long l) {
        int n;
        long l2 = l;
        for (n = 0; l2 != 0L && n < 8; l2 >>>= 8, ++n) {
        }
        this.appendShortLength(n);
        int n2 = (n - 1) * 8;
        int n3 = 0;
        while (n3 < n) {
            int n4 = (int)(l >>> n2 & 0xFFL);
            this.append(n4);
            n2 -= 8;
            ++n3;
        }
        return;
    }

    protected void appendOctet(int n) {
        this.append(n);
    }

    protected void appendQuotedString(String string2) {
        byte[] byArray = string2.getBytes();
        this.appendQuotedString(byArray);
    }

    protected void appendQuotedString(byte[] byArray) {
        this.append(34);
        int n = byArray.length;
        this.arraycopy(byArray, 0, n);
        this.append(0);
    }

    protected void appendShortInteger(int n) {
        int n2 = (n | 0x80) & 0xFF;
        this.append(n2);
    }

    protected void appendShortLength(int n) {
        this.append(n);
    }

    protected void appendTextString(String string2) {
        byte[] byArray = string2.getBytes();
        this.appendTextString(byArray);
    }

    protected void appendTextString(byte[] byArray) {
        if ((byArray[0] & 0xFF) > 127) {
            this.append(127);
        }
        int n = byArray.length;
        this.arraycopy(byArray, 0, n);
        this.append(0);
    }

    protected void appendUintvarInteger(long l) {
        long l2 = 127L;
        int n = 0;
        while (true) {
            if (n >= 5 || l < l2) {
                while (n > 0) {
                    int n2 = n * 7;
                    long l3 = l >>> n2 & 0x7FL;
                    int n3 = (int)((0x80L | l3) & 0xFFL);
                    this.append(n3);
                    n += -1;
                }
                break;
            }
            l2 = l2 << 7 | 0x7FL;
            ++n;
        }
        int n4 = (int)(l & 0x7FL);
        this.append(n4);
    }

    protected void appendValueLength(long l) {
        if (l < 31L) {
            int n = (int)l;
            this.appendShortLength(n);
            return;
        }
        this.append(31);
        this.appendUintvarInteger(l);
    }

    protected void arraycopy(byte[] byArray, int n, int n2) {
        int n3;
        this.mMessage.write(byArray, n, n2);
        this.mPosition = n3 = this.mPosition + n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] make() {
        switch (this.mPdu.getMessageType()) {
            default: {
                return null;
            }
            case 128: {
                if (this.makeSendReqPdu() == 0) return this.mMessage.toByteArray();
                return null;
            }
            case 131: {
                if (this.makeNotifyResp() == 0) return this.mMessage.toByteArray();
                return null;
            }
            case 133: {
                if (this.makeAckInd() == 0) return this.mMessage.toByteArray();
                return null;
            }
            case 135: {
                if (this.makeReadRecInd() == 0) return this.mMessage.toByteArray();
                return null;
            }
        }
    }

    private class BufferStack {
        private LengthRecordNode stack = null;
        int stackSize = 0;
        private LengthRecordNode toCopy = null;

        private BufferStack() {
        }

        void copy() {
            PduComposer pduComposer = PduComposer.this;
            byte[] byArray = this.toCopy.currentMessage.toByteArray();
            int n = this.toCopy.currentPosition;
            pduComposer.arraycopy(byArray, 0, n);
            this.toCopy = null;
        }

        PositionMarker mark() {
            PduComposer pduComposer = PduComposer.this;
            PositionMarker positionMarker = pduComposer.new PositionMarker();
            int n = PduComposer.this.mPosition;
            int n2 = PositionMarker.access$402(positionMarker, n);
            int n3 = this.stackSize;
            int n4 = PositionMarker.access$502(positionMarker, n3);
            return positionMarker;
        }

        void newbuf() {
            ByteArrayOutputStream byteArrayOutputStream;
            int n;
            LengthRecordNode lengthRecordNode;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream2;
            if (this.toCopy != null) {
                throw new RuntimeException("BUG: Invalid newbuf() before copy()");
            }
            LengthRecordNode lengthRecordNode2 = new LengthRecordNode();
            lengthRecordNode2.currentMessage = byteArrayOutputStream2 = PduComposer.this.mMessage;
            lengthRecordNode2.currentPosition = n2 = PduComposer.this.mPosition;
            lengthRecordNode2.next = lengthRecordNode = this.stack;
            this.stack = lengthRecordNode2;
            this.stackSize = n = this.stackSize + 1;
            PduComposer pduComposer = PduComposer.this;
            pduComposer.mMessage = byteArrayOutputStream = new ByteArrayOutputStream();
            PduComposer.this.mPosition = 0;
        }

        void pop() {
            int n;
            LengthRecordNode lengthRecordNode;
            LengthRecordNode lengthRecordNode2;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = PduComposer.this.mMessage;
            int n3 = PduComposer.this.mPosition;
            PduComposer pduComposer = PduComposer.this;
            pduComposer.mMessage = byteArrayOutputStream = this.stack.currentMessage;
            PduComposer pduComposer2 = PduComposer.this;
            pduComposer2.mPosition = n2 = this.stack.currentPosition;
            this.toCopy = lengthRecordNode2 = this.stack;
            this.stack = lengthRecordNode = this.stack.next;
            this.stackSize = n = this.stackSize - 1;
            this.toCopy.currentMessage = byteArrayOutputStream2;
            this.toCopy.currentPosition = n3;
        }
    }

    private class PositionMarker {
        private int c_pos;
        private int currentStackSize;

        private PositionMarker() {
        }

        static /* synthetic */ int access$402(PositionMarker positionMarker, int n) {
            positionMarker.c_pos = n;
            return n;
        }

        static /* synthetic */ int access$502(PositionMarker positionMarker, int n) {
            positionMarker.currentStackSize = n;
            return n;
        }

        int getLength() {
            int n = this.currentStackSize;
            int n2 = ((PduComposer)PduComposer.this).mStack.stackSize;
            if (n != n2) {
                throw new RuntimeException("BUG: Invalid call to getLength()");
            }
            int n3 = PduComposer.this.mPosition;
            int n4 = this.c_pos;
            return n3 - n4;
        }
    }

    private static class LengthRecordNode {
        ByteArrayOutputStream currentMessage = null;
        public int currentPosition = 0;
        public LengthRecordNode next = null;

        private LengthRecordNode() {
        }
    }
}

