/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.util.Log;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.Base64;
import com.google.android.mms.pdu.CharacterSets;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduContentTypes;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.QuotedPrintable;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendConf;
import com.google.android.mms.pdu.SendReq;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class PduParser {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final boolean DEBUG = false;
    private static final int END_STRING_FLAG = 0;
    private static final int LENGTH_QUOTE = 31;
    private static final boolean LOCAL_LOGV = false;
    private static final String LOG_TAG = "PduParser";
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int QUOTE = 127;
    private static final int QUOTED_STRING_FLAG = 34;
    private static final int SHORT_INTEGER_MAX = 127;
    private static final int SHORT_LENGTH_MAX = 30;
    private static final int TEXT_MAX = 127;
    private static final int TEXT_MIN = 32;
    private static final int THE_FIRST_PART = 0;
    private static final int THE_LAST_PART = 1;
    private static final int TYPE_QUOTED_STRING = 1;
    private static final int TYPE_TEXT_STRING = 0;
    private static final int TYPE_TOKEN_STRING = 2;
    private static byte[] mStartParam;
    private static byte[] mTypeParam;
    private PduBody mBody = null;
    private PduHeaders mHeaders = null;
    private ByteArrayInputStream mPduDataStream = null;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !PduParser.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        mTypeParam = null;
        mStartParam = null;
    }

    public PduParser(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        this.mPduDataStream = byteArrayInputStream = new ByteArrayInputStream(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean checkMandatoryHeader(PduHeaders pduHeaders) {
        if (pduHeaders == null) {
            return false;
        }
        int n = pduHeaders.getOctet(140);
        if (pduHeaders.getOctet(141) == 0) {
            return false;
        }
        switch (n) {
            default: {
                return false;
            }
            case 128: {
                if (pduHeaders.getTextString(132) == null) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) return true;
                return false;
            }
            case 129: {
                if (pduHeaders.getOctet(146) == 0) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) return true;
                return false;
            }
            case 130: {
                if (pduHeaders.getTextString(131) == null) {
                    return false;
                }
                long l = pduHeaders.getLongInteger(136);
                if (65535L == l) {
                    return false;
                }
                if (pduHeaders.getTextString(138) == null) {
                    return false;
                }
                long l2 = pduHeaders.getLongInteger(142);
                if (65535L == l2) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) return true;
                return false;
            }
            case 131: {
                if (pduHeaders.getOctet(149) == 0) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) return true;
                return false;
            }
            case 132: {
                if (pduHeaders.getTextString(132) == null) {
                    return false;
                }
                long l = pduHeaders.getLongInteger(133);
                if (65535L != l) return true;
                return false;
            }
            case 134: {
                long l = pduHeaders.getLongInteger(133);
                if (65535L == l) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(149) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) return true;
                return false;
            }
            case 133: {
                if (pduHeaders.getTextString(152) != null) return true;
                return false;
            }
            case 136: {
                long l = pduHeaders.getLongInteger(133);
                if (65535L == l) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(155) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) return true;
                return false;
            }
            case 135: {
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(155) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) return true;
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int checkPartPosition(PduPart pduPart) {
        boolean bl;
        byte[] byArray;
        if (!$assertionsDisabled && pduPart == null) {
            throw new AssertionError();
        }
        if (mTypeParam == null && mStartParam == null) {
            return 1;
        }
        if (mStartParam != null && (byArray = pduPart.getContentId()) != null && !(bl = Arrays.equals(mStartParam, byArray))) {
            return 0;
        }
        if (mTypeParam == null) return 1;
        byte[] byArray2 = pduPart.getContentType();
        if (byArray2 == null) return 1;
        boolean bl2 = Arrays.equals(mTypeParam, byArray2);
        if (true == bl2) return 1;
        return 0;
    }

    protected static int extractByteValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        return n & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static byte[] getWapString(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n2) {
            throw new AssertionError();
        }
        while (-1 != n2 && n2 != 0) {
            if (n == 2) {
                if (PduParser.isTokenCharacter(n2)) {
                    byteArrayOutputStream.write(n2);
                }
            } else if (PduParser.isText(n2)) {
                byteArrayOutputStream.write(n2);
            }
            n2 = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 != n2) {
                throw new AssertionError();
            }
        }
        if (byteArrayOutputStream.size() <= 0) return null;
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isText(int n) {
        if (n >= 32) {
            if (n <= 126) return true;
        }
        if (n >= 128 && n <= 255) {
            return true;
        }
        switch (n) {
            default: {
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isTokenCharacter(int n) {
        if (n < 33) return false;
        if (n > 126) {
            return false;
        }
        switch (n) {
            default: {
                return true;
            }
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: 
        }
        return false;
    }

    private static void log(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static byte[] parseContentType(ByteArrayInputStream byteArrayInputStream, HashMap<Integer, Object> hashMap) {
        byte[] byArray;
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byte[] byArray2 = null;
        byteArrayInputStream.mark(1);
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        byteArrayInputStream.reset();
        int n2 = n & 0xFF;
        if (n2 < 32) {
            int n3;
            int n4;
            byte[] byArray3;
            n = PduParser.parseValueLength(byteArrayInputStream);
            int n5 = byteArrayInputStream.available();
            byteArrayInputStream.mark(1);
            int n6 = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 != n6) {
                throw new AssertionError();
            }
            byteArrayInputStream.reset();
            n2 = n6 & 0xFF;
            if (n2 >= 32 && n2 <= 127) {
                byArray2 = PduParser.parseWapString(byteArrayInputStream, 0);
            } else {
                int n7;
                if (n2 <= 127) {
                    int n8 = Log.e(LOG_TAG, "Corrupt content-type");
                    byte[] byArray4 = PduContentTypes.contentTypes[0].getBytes();
                    int n9 = n6;
                    byte[] byArray5 = byArray2;
                    byArray3 = byArray4;
                    byte[] byArray6 = byArray5;
                    return byArray3;
                }
                int n10 = PduParser.parseShortInteger(byteArrayInputStream);
                if (n10 < (n7 = PduContentTypes.contentTypes.length)) {
                    byArray2 = PduContentTypes.contentTypes[n10].getBytes();
                } else {
                    byteArrayInputStream.reset();
                    byArray2 = PduParser.parseWapString(byteArrayInputStream, 0);
                }
            }
            if ((n2 = n - (n4 = n5 - (n3 = byteArrayInputStream.available()))) > 0) {
                Integer n11 = n2;
                PduParser.parseContentTypeParams(byteArrayInputStream, hashMap, n11);
            }
            if (n2 < 0) {
                int n12 = Log.e(LOG_TAG, "Corrupt MMS message");
                byte[] byArray7 = PduContentTypes.contentTypes[0].getBytes();
                int n13 = n6;
                byte[] byArray8 = byArray2;
                byArray3 = byArray7;
                byte[] byArray9 = byArray8;
                return byArray3;
            }
            int n14 = n6;
            byArray = byArray2;
            return byArray;
        } else if (n2 <= 127) {
            byArray = PduParser.parseWapString(byteArrayInputStream, 0);
            int n15 = n;
            return byArray;
        } else {
            String[] stringArray = PduContentTypes.contentTypes;
            int n16 = PduParser.parseShortInteger(byteArrayInputStream);
            byArray = stringArray[n16].getBytes();
            int n17 = n;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void parseContentTypeParams(ByteArrayInputStream byteArrayInputStream, HashMap<Integer, Object> hashMap, Integer n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        int n2 = byteArrayInputStream.available();
        int n3 = n;
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            block22: {
                int n6 = byteArrayInputStream.read();
                if (!$assertionsDisabled && -1 != n6) {
                    throw new AssertionError();
                }
                n3 += -1;
                switch (n6) {
                    default: {
                        int n7 = PduParser.skipWapValue(byteArrayInputStream, n3);
                        if (-1 == n7) break;
                        int n8 = Log.e(LOG_TAG, "Corrupt Content-Type");
                        n5 = n4;
                        break block22;
                    }
                    case 131: 
                    case 137: {
                        byteArrayInputStream.mark(1);
                        int n9 = PduParser.extractByteValue(byteArrayInputStream);
                        byteArrayInputStream.reset();
                        if (n9 > 127) {
                            int n10;
                            int n11 = PduParser.parseShortInteger(byteArrayInputStream);
                            if (n11 < (n10 = PduContentTypes.contentTypes.length)) {
                                byte[] byArray = PduContentTypes.contentTypes[n11].getBytes();
                                Integer n12 = 131;
                                Object object = hashMap.put(n12, byArray);
                            }
                        } else {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                            if (byArray != null && hashMap != null) {
                                Integer n13 = 131;
                                Object object = hashMap.put(n13, byArray);
                            }
                        }
                        n5 = byteArrayInputStream.available();
                        int n14 = n;
                        int n15 = n2 - n5;
                        n3 = n14 - n15;
                        break block22;
                    }
                    case 138: 
                    case 153: {
                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                        if (byArray != null && hashMap != null) {
                            Integer n16 = 153;
                            Object object = hashMap.put(n16, byArray);
                        }
                        n5 = byteArrayInputStream.available();
                        int n17 = n;
                        int n18 = n2 - n5;
                        n3 = n17 - n18;
                        break block22;
                    }
                    case 129: {
                        byteArrayInputStream.mark(1);
                        int n19 = PduParser.extractByteValue(byteArrayInputStream);
                        byteArrayInputStream.reset();
                        if (n19 > 32 && n19 < 127 || n19 == 0) {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                            try {
                                int n20 = CharacterSets.getMibEnumValue(new String(byArray));
                                Integer n21 = 129;
                                Integer n22 = n20;
                                Object object = hashMap.put(n21, n22);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                String string2 = Arrays.toString(byArray);
                                int n23 = Log.e(LOG_TAG, string2, unsupportedEncodingException);
                                Integer n24 = 129;
                                Integer n25 = 0;
                                Object object = hashMap.put(n24, n25);
                            }
                        } else {
                            int n26 = (int)PduParser.parseIntegerValue(byteArrayInputStream);
                            if (hashMap != null) {
                                Integer n27 = 129;
                                Integer n28 = n26;
                                Object object = hashMap.put(n27, n28);
                            }
                        }
                        n5 = byteArrayInputStream.available();
                        int n29 = n;
                        int n30 = n2 - n5;
                        n3 = n29 - n30;
                        break block22;
                    }
                    case 133: 
                    case 151: {
                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                        if (byArray != null && hashMap != null) {
                            Integer n31 = 151;
                            Object object = hashMap.put(n31, byArray);
                        }
                        n5 = byteArrayInputStream.available();
                        int n32 = n;
                        int n33 = n2 - n5;
                        n3 = n32 - n33;
                        break block22;
                    }
                }
                n3 = 0;
                n5 = n4;
            }
            n4 = n5;
        }
        if (n3 == 0) {
            return;
        }
        int n34 = Log.e(LOG_TAG, "Corrupt Content-Type");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static EncodedStringValue parseEncodedStringValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n = 0;
        int n2 = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n2) {
            throw new AssertionError();
        }
        int n3 = n2 & 0xFF;
        byteArrayInputStream.reset();
        if (n3 < 32) {
            int n4 = PduParser.parseValueLength(byteArrayInputStream);
            n = PduParser.parseShortInteger(byteArrayInputStream);
        }
        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
        EncodedStringValue encodedStringValue = new EncodedStringValue(byArray);
        if (n == 0) return encodedStringValue;
        try {
            EncodedStringValue encodedStringValue2 = new EncodedStringValue(n, byArray);
            return encodedStringValue2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static long parseIntegerValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        byteArrayInputStream.reset();
        if (n <= 127) return PduParser.parseLongInteger(byteArrayInputStream);
        return PduParser.parseShortInteger(byteArrayInputStream);
    }

    protected static long parseLongInteger(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        int n2 = n & 0xFF;
        if (n2 > 8) {
            throw new RuntimeException("Octet count greater than 8 and I can't represent that!");
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            n = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 != n) {
                throw new AssertionError();
            }
            long l2 = l << 8;
            long l3 = n & 0xFF;
            l = l2 + l3;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static boolean parsePartHeaders(ByteArrayInputStream byteArrayInputStream, PduPart pduPart, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pduPart == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        int n2 = byteArrayInputStream.available();
        int n3 = n;
        int n4 = 0;
        int n5 = n3;
        while (true) {
            int n6;
            int n7;
            block25: {
                block29: {
                    int n8;
                    block28: {
                        boolean bl;
                        block26: {
                            int n9;
                            block27: {
                                if (n5 <= 0) break block26;
                                n9 = byteArrayInputStream.read();
                                if (!$assertionsDisabled && -1 != n9) {
                                    throw new AssertionError();
                                }
                                n5 += -1;
                                if (n9 <= 127) break block27;
                                switch (n9) {
                                    default: {
                                        int n10 = PduParser.skipWapValue(byteArrayInputStream, n5);
                                        if (-1 == n10) break;
                                        int n11 = Log.e(LOG_TAG, "Corrupt Part headers");
                                        bl = false;
                                        int n12 = n5;
                                        return bl;
                                    }
                                    case 142: {
                                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                                        if (byArray != null) {
                                            pduPart.setContentLocation(byArray);
                                        }
                                        n7 = byteArrayInputStream.available();
                                        int n13 = n2 - n7;
                                        n6 = n - n13;
                                        break block25;
                                    }
                                    case 192: {
                                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 1);
                                        if (byArray != null) {
                                            pduPart.setContentId(byArray);
                                        }
                                        n7 = byteArrayInputStream.available();
                                        int n14 = n2 - n7;
                                        n6 = n - n14;
                                        break block25;
                                    }
                                    case 174: 
                                    case 197: {
                                        int n15 = PduParser.parseValueLength(byteArrayInputStream);
                                        byteArrayInputStream.mark(1);
                                        int n16 = byteArrayInputStream.available();
                                        n4 = byteArrayInputStream.read();
                                        if (n4 == 128) {
                                            byte[] byArray = PduPart.DISPOSITION_FROM_DATA;
                                            pduPart.setContentDisposition(byArray);
                                        } else if (n4 == 129) {
                                            byte[] byArray = PduPart.DISPOSITION_ATTACHMENT;
                                            pduPart.setContentDisposition(byArray);
                                        } else if (n4 == 130) {
                                            byte[] byArray = PduPart.DISPOSITION_INLINE;
                                            pduPart.setContentDisposition(byArray);
                                        } else {
                                            byteArrayInputStream.reset();
                                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                                            pduPart.setContentDisposition(byArray);
                                        }
                                        if (n16 - (n8 = byteArrayInputStream.available()) >= n15) break block28;
                                        int n17 = byteArrayInputStream.read();
                                        if (n17 == 152) {
                                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                                            pduPart.setFilename(byArray);
                                        }
                                        if (n16 - (n4 = byteArrayInputStream.available()) < n15) {
                                            int n18 = n16 - n4;
                                            int n19 = n15 - n18;
                                            byte[] byArray = new byte[n19];
                                            int n20 = byteArrayInputStream.read(byArray, 0, n19);
                                        }
                                        int n21 = n17;
                                        int n22 = n4;
                                        break block29;
                                    }
                                }
                                n6 = 0;
                                n7 = n4;
                                break block25;
                            }
                            if (n9 >= 32 && n9 <= 127) {
                                byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                                byte[] byArray2 = PduParser.parseWapString(byteArrayInputStream, 0);
                                String string2 = new String(byArray);
                                boolean bl2 = "Content-Transfer-Encoding".equalsIgnoreCase(string2);
                                if (!bl2) {
                                    pduPart.setContentTransferEncoding(byArray2);
                                }
                                n7 = byteArrayInputStream.available();
                                int n23 = n2 - n7;
                                n6 = n - n23;
                                break block25;
                            } else {
                                int n24 = PduParser.skipWapValue(byteArrayInputStream, n5);
                                if (-1 != n24) {
                                    int n25 = Log.e(LOG_TAG, "Corrupt Part headers");
                                    bl = false;
                                    int n26 = n5;
                                    return bl;
                                }
                                n6 = 0;
                                n7 = n4;
                            }
                            break block25;
                        }
                        if (n5 != 0) {
                            int n27 = Log.e(LOG_TAG, "Corrupt Part headers");
                            bl = false;
                            int n28 = n5;
                            return bl;
                        }
                        bl = true;
                        int n29 = n5;
                        return bl;
                    }
                    int n30 = n8;
                    int n31 = n4;
                }
                n7 = byteArrayInputStream.available();
                int n32 = n2 - n7;
                n6 = n - n32;
            }
            n4 = n7;
            int n33 = n6;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected static PduBody parseParts(ByteArrayInputStream var0) {
        block12: {
            if (var0 == null) {
                var1_1 = null;
lbl3:
                // 6 sources

                return var1_1;
            }
            var2_2 = PduParser.parseUnsignedInt(var0);
            var3_3 = new PduBody();
            block1: for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
                block18: {
                    block16: {
                        block13: {
                            block19: {
                                block17: {
                                    block11: {
                                        block10: {
                                            block15: {
                                                block14: {
                                                    var5_5 /* !! */  = PduParser.parseUnsignedInt(var0);
                                                    var6_6 = PduParser.parseUnsignedInt(var0);
                                                    var7_7 = new PduPart();
                                                    var8_8 = var0.available();
                                                    if (var8_8 > 0) break block14;
                                                    var1_1 = null;
                                                    ** GOTO lbl3
                                                }
                                                var9_9 = new HashMap<Integer, Object>();
                                                var10_10 = PduParser.parseContentType(var0, var9_9);
                                                if (var10_10 == null) break block15;
                                                var7_7.setContentType(var10_10);
lbl20:
                                                // 2 sources

                                                while (true) {
                                                    var11_11 = 151;
                                                    var12_12 = (byte[])var9_9.get(var11_11);
                                                    if (var12_12 != null) {
                                                        var7_7.setName(var12_12);
                                                    }
                                                    if ((var14_14 = (Integer)var9_9.get(var13_13 = Integer.valueOf(129))) != null) {
                                                        var15_15 = var14_14;
                                                        var7_7.setCharset(var15_15);
                                                    }
                                                    if ((var18_18 = var5_5 /* !! */  - (var17_17 = var8_8 - (var16_16 = var0.available()))) <= 0) break block10;
                                                    if (PduParser.parsePartHeaders(var0, var7_7, var18_18)) break block11;
                                                    var1_1 = null;
                                                    ** GOTO lbl3
                                                    break;
                                                }
                                            }
                                            var19_19 = PduContentTypes.contentTypes[0].getBytes();
                                            var7_7.setContentType(var19_19);
                                            ** continue;
                                        }
                                        if (var18_18 >= 0) break block11;
                                        var1_1 = null;
                                        ** GOTO lbl3
                                    }
                                    if (var7_7.getContentLocation() == null && var7_7.getName() == null && var7_7.getFilename() == null && var7_7.getContentId() == null) {
                                        var20_20 = Long.toOctalString(System.currentTimeMillis()).getBytes();
                                        var7_7.setContentLocation(var20_20);
                                    }
                                    if (var6_6 <= 0) break block16;
                                    var5_5 /* !! */  = (int)new byte[var6_6];
                                    var21_21 = var7_7.getContentType();
                                    var22_22 = new String(var21_21);
                                    var23_23 = var0.read((byte[])var5_5 /* !! */ , 0, var6_6);
                                    if (!var22_22.equalsIgnoreCase("application/vnd.wap.multipart.alternative")) break block17;
                                    var24_24 = PduParser.parseParts(new ByteArrayInputStream((byte[])var5_5 /* !! */ )).getPart(0);
lbl51:
                                    // 2 sources

                                    while (PduParser.checkPartPosition(var24_24) == 0) {
                                        var3_3.addPart(0, var24_24);
lbl53:
                                        // 2 sources

                                        continue block1;
                                    }
                                    break block18;
                                }
                                var25_25 = var7_7.getContentTransferEncoding();
                                if (var25_25 == null) break block12;
                                var26_26 = new String(var25_25);
                                if (!var26_26.equalsIgnoreCase("base64")) break block19;
                                var27_27 /* !! */  = (int)Base64.decodeBase64((byte[])var5_5 /* !! */ );
lbl62:
                                // 3 sources

                                while (true) {
                                    if (var27_27 /* !! */  != null) break block13;
                                    PduParser.log("Decode part data error!");
                                    var1_1 = null;
                                    ** GOTO lbl3
                                    break;
                                }
                            }
                            if (!var26_26.equalsIgnoreCase("quoted-printable")) break block12;
                            var27_27 /* !! */  = (int)QuotedPrintable.decodeQuotedPrintable((byte[])var5_5 /* !! */ );
                            ** GOTO lbl62
                        }
                        var7_7.setData((byte[])var27_27 /* !! */ );
                    }
                    var24_24 = var7_7;
                    ** GOTO lbl51
                }
                var28_28 = var3_3.addPart(var24_24);
                ** continue;
            }
            var1_1 = var3_3;
            ** while (true)
        }
        var27_27 /* !! */  = var5_5 /* !! */ ;
        ** while (true)
    }

    protected static int parseShortInteger(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        return n & 0x7F;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int parseUnsignedInt(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = 0;
        int n2 = byteArrayInputStream.read();
        if (n2 == -1) {
            return n2;
        }
        while ((n2 & 0x80) != 0) {
            int n3 = n << 7;
            int n4 = n2 & 0x7F;
            n = n3 | n4;
            n2 = byteArrayInputStream.read();
            if (n2 != -1) continue;
            return n2;
        }
        int n5 = n << 7;
        int n6 = n2 & 0x7F;
        return n5 | n6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int parseValueLength(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n) {
            throw new AssertionError();
        }
        int n2 = n & 0xFF;
        if (n2 <= 30) {
            return n2;
        }
        if (n2 != 31) throw new RuntimeException("Value length > LENGTH_QUOTE!");
        return PduParser.parseUnsignedInt(byteArrayInputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static byte[] parseWapString(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n2 = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 != n2) {
            throw new AssertionError();
        }
        if (1 != n && 34 != n2) {
            byteArrayInputStream.mark(1);
            return PduParser.getWapString(byteArrayInputStream, n);
        }
        if (n == 0 && 127 != n2) {
            byteArrayInputStream.mark(1);
            return PduParser.getWapString(byteArrayInputStream, n);
        }
        byteArrayInputStream.reset();
        return PduParser.getWapString(byteArrayInputStream, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int skipWapValue(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[n];
        int n2 = byteArrayInputStream.read(byArray, 0, n);
        if (n2 >= n) return n2;
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GenericPdu parse() {
        PduHeaders pduHeaders;
        void var1_2;
        if (this.mPduDataStream == null) {
            return var1_2;
        }
        ByteArrayInputStream byteArrayInputStream = this.mPduDataStream;
        this.mHeaders = pduHeaders = this.parseHeaders(byteArrayInputStream);
        if (this.mHeaders == null) {
            return var1_2;
        }
        int n = this.mHeaders.getOctet(140);
        if (!PduParser.checkMandatoryHeader(this.mHeaders)) {
            PduParser.log("check mandatory headers failed!");
            return var1_2;
        }
        if (128 == n || 132 != n) {
            PduBody pduBody;
            this.mBody = pduBody = PduParser.parseParts(this.mPduDataStream);
            if (this.mBody == null) {
                return var1_2;
            }
        }
        switch (n) {
            default: {
                PduParser.log("Parser doesn't support this message type in this version!");
                return var1_2;
            }
            case 128: {
                PduHeaders pduHeaders2 = this.mHeaders;
                PduBody pduBody = this.mBody;
                SendReq sendReq = new SendReq(pduHeaders2, pduBody);
                return var1_2;
            }
            case 129: {
                PduHeaders pduHeaders3 = this.mHeaders;
                SendConf sendConf = new SendConf(pduHeaders3);
                return var1_2;
            }
            case 130: {
                PduHeaders pduHeaders4 = this.mHeaders;
                NotificationInd notificationInd = new NotificationInd(pduHeaders4);
                return var1_2;
            }
            case 131: {
                PduHeaders pduHeaders5 = this.mHeaders;
                NotifyRespInd notifyRespInd = new NotifyRespInd(pduHeaders5);
                return var1_2;
            }
            case 132: {
                PduHeaders pduHeaders6 = this.mHeaders;
                PduBody pduBody = this.mBody;
                RetrieveConf retrieveConf = new RetrieveConf(pduHeaders6, pduBody);
                byte[] byArray = retrieveConf.getContentType();
                if (byArray == null) {
                    return var1_2;
                }
                String string2 = new String(byArray);
                if (!string2.equals("application/vnd.wap.multipart.mixed") && !string2.equals("application/vnd.wap.multipart.related") && !string2.equals("application/vnd.wap.multipart.alternative")) return var1_2;
                RetrieveConf retrieveConf2 = retrieveConf;
                return var1_2;
            }
            case 134: {
                PduHeaders pduHeaders7 = this.mHeaders;
                DeliveryInd deliveryInd = new DeliveryInd(pduHeaders7);
                return var1_2;
            }
            case 133: {
                PduHeaders pduHeaders8 = this.mHeaders;
                AcknowledgeInd acknowledgeInd = new AcknowledgeInd(pduHeaders8);
                return var1_2;
            }
            case 136: {
                PduHeaders pduHeaders9 = this.mHeaders;
                ReadOrigInd readOrigInd = new ReadOrigInd(pduHeaders9);
                return var1_2;
            }
            case 135: 
        }
        PduHeaders pduHeaders10 = this.mHeaders;
        ReadRecInd readRecInd = new ReadRecInd(pduHeaders10);
        return var1_2;
    }

    /*
     * Exception decompiling
     */
    protected PduHeaders parseHeaders(ByteArrayInputStream var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 14[TRYBLOCK] [21, 22 : 1794->1827)] java.lang.NullPointerException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

