/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.net.Uri;
import java.util.HashMap;
import java.util.Map;

public class PduPart {
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    static final byte[] DISPOSITION_ATTACHMENT;
    static final byte[] DISPOSITION_FROM_DATA;
    static final byte[] DISPOSITION_INLINE;
    public static final String P_7BIT = "7bit";
    public static final String P_8BIT = "8bit";
    public static final String P_BASE64 = "base64";
    public static final String P_BINARY = "binary";
    public static final int P_CHARSET = 129;
    public static final int P_COMMENT = 155;
    public static final int P_CONTENT_DISPOSITION = 197;
    public static final int P_CONTENT_ID = 192;
    public static final int P_CONTENT_LOCATION = 142;
    public static final int P_CONTENT_TRANSFER_ENCODING = 200;
    public static final int P_CONTENT_TYPE = 145;
    public static final int P_CREATION_DATE = 147;
    public static final int P_CT_MR_TYPE = 137;
    public static final int P_DEP_COMMENT = 140;
    public static final int P_DEP_CONTENT_DISPOSITION = 174;
    public static final int P_DEP_DOMAIN = 141;
    public static final int P_DEP_FILENAME = 134;
    public static final int P_DEP_NAME = 133;
    public static final int P_DEP_PATH = 143;
    public static final int P_DEP_START = 138;
    public static final int P_DEP_START_INFO = 139;
    public static final int P_DIFFERENCES = 135;
    public static final int P_DISPOSITION_ATTACHMENT = 129;
    public static final int P_DISPOSITION_FROM_DATA = 128;
    public static final int P_DISPOSITION_INLINE = 130;
    public static final int P_DOMAIN = 156;
    public static final int P_FILENAME = 152;
    public static final int P_LEVEL = 130;
    public static final int P_MAC = 146;
    public static final int P_MAX_AGE = 142;
    public static final int P_MODIFICATION_DATE = 148;
    public static final int P_NAME = 151;
    public static final int P_PADDING = 136;
    public static final int P_PATH = 157;
    public static final int P_Q = 128;
    public static final String P_QUOTED_PRINTABLE = "quoted-printable";
    public static final int P_READ_DATE = 149;
    public static final int P_SEC = 145;
    public static final int P_SECURE = 144;
    public static final int P_SIZE = 150;
    public static final int P_START = 153;
    public static final int P_START_INFO = 154;
    public static final int P_TYPE = 131;
    private static final String TAG = "PduPart";
    private byte[] mPartData = null;
    private Map<Integer, Object> mPartHeader = null;
    private Uri mUri = null;

    static {
        DISPOSITION_FROM_DATA = "from-data".getBytes();
        DISPOSITION_ATTACHMENT = "attachment".getBytes();
        DISPOSITION_INLINE = "inline".getBytes();
    }

    public PduPart() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        this.mPartHeader = hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generateLocation() {
        Integer n;
        Map<Integer, Object> map;
        Map<Integer, Object> map2 = this.mPartHeader;
        Integer n2 = 151;
        byte[] byArray = (byte[])map2.get(n2);
        if (byArray == null && (byArray = (byte[])(map = this.mPartHeader).get(n = Integer.valueOf(152))) == null) {
            Map<Integer, Object> map3 = this.mPartHeader;
            Integer n3 = 142;
            byArray = (byte[])map3.get(n3);
        }
        if (byArray != null) return new String(byArray);
        Map<Integer, Object> map4 = this.mPartHeader;
        Integer n4 = 192;
        byte[] byArray2 = (byte[])map4.get(n4);
        StringBuilder stringBuilder = new StringBuilder().append("cid:");
        String string2 = new String(byArray2);
        return stringBuilder.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCharset() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 129;
        Integer n2 = (Integer)map.get(n);
        if (n2 != null) return n2;
        return 0;
    }

    public byte[] getContentDisposition() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 197;
        return (byte[])map.get(n);
    }

    public byte[] getContentId() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 192;
        return (byte[])map.get(n);
    }

    public byte[] getContentLocation() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 142;
        return (byte[])map.get(n);
    }

    public byte[] getContentTransferEncoding() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 200;
        return (byte[])map.get(n);
    }

    public byte[] getContentType() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 145;
        return (byte[])map.get(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getData() {
        if (this.mPartData == null) {
            return null;
        }
        byte[] byArray = new byte[this.mPartData.length];
        byte[] byArray2 = this.mPartData;
        int n = this.mPartData.length;
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public Uri getDataUri() {
        return this.mUri;
    }

    public byte[] getFilename() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 152;
        return (byte[])map.get(n);
    }

    public byte[] getName() {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 151;
        return (byte[])map.get(n);
    }

    public void setCharset(int n) {
        Map<Integer, Object> map = this.mPartHeader;
        Integer n2 = 129;
        Integer n3 = n;
        Object object = map.put(n2, n3);
    }

    public void setContentDisposition(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-disposition");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 197;
        Object object = map.put(n, byArray);
    }

    public void setContentId(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Content-Id may not be null or empty.");
        }
        if (byArray.length > 1 && (char)byArray[0] == '<' && (char)byArray[n = byArray.length - 1] == '>') {
            Map<Integer, Object> map = this.mPartHeader;
            Integer n2 = 192;
            Object object = map.put(n2, byArray);
            return;
        }
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 60;
        int n3 = byArray2.length - 1;
        byArray2[n3] = 62;
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, n4);
        Map<Integer, Object> map = this.mPartHeader;
        Integer n5 = 192;
        Object object = map.put(n5, byArray2);
    }

    public void setContentLocation(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-location");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 142;
        Object object = map.put(n, byArray);
    }

    public void setContentTransferEncoding(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-transfer-encoding");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 200;
        Object object = map.put(n, byArray);
    }

    public void setContentType(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-type");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 145;
        Object object = map.put(n, byArray);
    }

    public void setData(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = this.mPartData = byArray2;
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
    }

    public void setDataUri(Uri uri) {
        this.mUri = uri;
    }

    public void setFilename(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-id");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 152;
        Object object = map.put(n, byArray);
    }

    public void setName(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null content-id");
        }
        Map<Integer, Object> map = this.mPartHeader;
        Integer n = 151;
        Object object = map.put(n, byArray);
    }
}

