/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.SendReq;
import com.google.android.mms.util.PduCache;
import com.google.android.mms.util.PduCacheEntry;
import com.google.android.mms.util.SqliteWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PduPersister {
    private static final int[] ADDRESS_FIELDS = new int[]{129, 130, 137, 151};
    private static final HashMap<Integer, Integer> CHARSET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> CHARSET_COLUMN_NAME_MAP;
    private static final boolean DEBUG = false;
    private static final long DUMMY_THREAD_ID = Long.MAX_VALUE;
    private static final HashMap<Integer, Integer> ENCODED_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> ENCODED_STRING_COLUMN_NAME_MAP;
    private static final boolean LOCAL_LOGV = false;
    private static final HashMap<Integer, Integer> LONG_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> LONG_COLUMN_NAME_MAP;
    private static final HashMap<Uri, Integer> MESSAGE_BOX_MAP;
    private static final HashMap<Integer, Integer> OCTET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> OCTET_COLUMN_NAME_MAP;
    private static final int PART_COLUMN_CHARSET = 1;
    private static final int PART_COLUMN_CONTENT_DISPOSITION = 2;
    private static final int PART_COLUMN_CONTENT_ID = 3;
    private static final int PART_COLUMN_CONTENT_LOCATION = 4;
    private static final int PART_COLUMN_CONTENT_TYPE = 5;
    private static final int PART_COLUMN_FILENAME = 6;
    private static final int PART_COLUMN_ID = 0;
    private static final int PART_COLUMN_NAME = 7;
    private static final int PART_COLUMN_TEXT = 8;
    private static final String[] PART_PROJECTION;
    private static final PduCache PDU_CACHE_INSTANCE;
    private static final int PDU_COLUMN_CONTENT_CLASS = 11;
    private static final int PDU_COLUMN_CONTENT_LOCATION = 5;
    private static final int PDU_COLUMN_CONTENT_TYPE = 6;
    private static final int PDU_COLUMN_DATE = 21;
    private static final int PDU_COLUMN_DELIVERY_REPORT = 12;
    private static final int PDU_COLUMN_DELIVERY_TIME = 22;
    private static final int PDU_COLUMN_EXPIRY = 23;
    private static final int PDU_COLUMN_ID = 0;
    private static final int PDU_COLUMN_MESSAGE_BOX = 1;
    private static final int PDU_COLUMN_MESSAGE_CLASS = 7;
    private static final int PDU_COLUMN_MESSAGE_ID = 8;
    private static final int PDU_COLUMN_MESSAGE_SIZE = 24;
    private static final int PDU_COLUMN_MESSAGE_TYPE = 13;
    private static final int PDU_COLUMN_MMS_VERSION = 14;
    private static final int PDU_COLUMN_PRIORITY = 15;
    private static final int PDU_COLUMN_READ_REPORT = 16;
    private static final int PDU_COLUMN_READ_STATUS = 17;
    private static final int PDU_COLUMN_REPORT_ALLOWED = 18;
    private static final int PDU_COLUMN_RESPONSE_TEXT = 9;
    private static final int PDU_COLUMN_RETRIEVE_STATUS = 19;
    private static final int PDU_COLUMN_RETRIEVE_TEXT = 3;
    private static final int PDU_COLUMN_RETRIEVE_TEXT_CHARSET = 26;
    private static final int PDU_COLUMN_STATUS = 20;
    private static final int PDU_COLUMN_SUBJECT = 4;
    private static final int PDU_COLUMN_SUBJECT_CHARSET = 25;
    private static final int PDU_COLUMN_THREAD_ID = 2;
    private static final int PDU_COLUMN_TRANSACTION_ID = 10;
    private static final String[] PDU_PROJECTION;
    public static final int PROC_STATUS_COMPLETED = 3;
    public static final int PROC_STATUS_PERMANENTLY_FAILURE = 2;
    public static final int PROC_STATUS_TRANSIENT_FAILURE = 1;
    private static final String TAG = "PduPersister";
    public static final String TEMPORARY_DRM_OBJECT_URI = "content://mms/9223372036854775807/part";
    private static final HashMap<Integer, Integer> TEXT_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> TEXT_STRING_COLUMN_NAME_MAP;
    private static PduPersister sPersister;
    private final ContentResolver mContentResolver;
    private final Context mContext;

    static {
        String[] stringArray = new String[]{"_id", "msg_box", "thread_id", "retr_txt", "sub", "ct_l", "ct_t", "m_cls", "m_id", "resp_txt", "tr_id", "ct_cls", "d_rpt", "m_type", "v", "pri", "rr", "read_status", "rpt_a", "retr_st", "st", "date", "d_tm", "exp", "m_size", "sub_cs", "retr_txt_cs"};
        PDU_PROJECTION = stringArray;
        String[] stringArray2 = new String[]{"_id", "chset", "cd", "cid", "cl", "ct", "fn", "name", "text"};
        PART_PROJECTION = stringArray2;
        HashMap<Uri, Integer> hashMap = MESSAGE_BOX_MAP = new HashMap();
        Uri uri = Telephony.Mms.Inbox.CONTENT_URI;
        Integer n = 1;
        Integer n2 = hashMap.put(uri, n);
        HashMap<Uri, Integer> hashMap2 = MESSAGE_BOX_MAP;
        Uri uri2 = Telephony.Mms.Sent.CONTENT_URI;
        Integer n3 = 2;
        Integer n4 = hashMap2.put(uri2, n3);
        HashMap<Uri, Integer> hashMap3 = MESSAGE_BOX_MAP;
        Uri uri3 = Telephony.Mms.Draft.CONTENT_URI;
        Integer n5 = 3;
        Integer n6 = hashMap3.put(uri3, n5);
        HashMap<Uri, Integer> hashMap4 = MESSAGE_BOX_MAP;
        Uri uri4 = Telephony.Mms.Outbox.CONTENT_URI;
        Integer n7 = 4;
        Integer n8 = hashMap4.put(uri4, n7);
        HashMap<Integer, Integer> hashMap5 = CHARSET_COLUMN_INDEX_MAP = new HashMap();
        Integer n9 = 150;
        Integer n10 = 25;
        Integer n11 = hashMap5.put(n9, n10);
        HashMap<Integer, Integer> hashMap6 = CHARSET_COLUMN_INDEX_MAP;
        Integer n12 = 154;
        Integer n13 = 26;
        Integer n14 = hashMap6.put(n12, n13);
        HashMap<Integer, String> hashMap7 = CHARSET_COLUMN_NAME_MAP = new HashMap();
        Integer n15 = 150;
        String string2 = hashMap7.put(n15, "sub_cs");
        HashMap<Integer, String> hashMap8 = CHARSET_COLUMN_NAME_MAP;
        Integer n16 = 154;
        String string3 = hashMap8.put(n16, "retr_txt_cs");
        HashMap<Integer, Integer> hashMap9 = ENCODED_STRING_COLUMN_INDEX_MAP = new HashMap();
        Integer n17 = 154;
        Integer n18 = 3;
        Integer n19 = hashMap9.put(n17, n18);
        HashMap<Integer, Integer> hashMap10 = ENCODED_STRING_COLUMN_INDEX_MAP;
        Integer n20 = 150;
        Integer n21 = 4;
        Integer n22 = hashMap10.put(n20, n21);
        HashMap<Integer, String> hashMap11 = ENCODED_STRING_COLUMN_NAME_MAP = new HashMap();
        Integer n23 = 154;
        String string4 = hashMap11.put(n23, "retr_txt");
        HashMap<Integer, String> hashMap12 = ENCODED_STRING_COLUMN_NAME_MAP;
        Integer n24 = 150;
        String string5 = hashMap12.put(n24, "sub");
        HashMap<Integer, Integer> hashMap13 = TEXT_STRING_COLUMN_INDEX_MAP = new HashMap();
        Integer n25 = 131;
        Integer n26 = 5;
        Integer n27 = hashMap13.put(n25, n26);
        HashMap<Integer, Integer> hashMap14 = TEXT_STRING_COLUMN_INDEX_MAP;
        Integer n28 = 132;
        Integer n29 = 6;
        Integer n30 = hashMap14.put(n28, n29);
        HashMap<Integer, Integer> hashMap15 = TEXT_STRING_COLUMN_INDEX_MAP;
        Integer n31 = 138;
        Integer n32 = 7;
        Integer n33 = hashMap15.put(n31, n32);
        HashMap<Integer, Integer> hashMap16 = TEXT_STRING_COLUMN_INDEX_MAP;
        Integer n34 = 139;
        Integer n35 = 8;
        Integer n36 = hashMap16.put(n34, n35);
        HashMap<Integer, Integer> hashMap17 = TEXT_STRING_COLUMN_INDEX_MAP;
        Integer n37 = 147;
        Integer n38 = 9;
        Integer n39 = hashMap17.put(n37, n38);
        HashMap<Integer, Integer> hashMap18 = TEXT_STRING_COLUMN_INDEX_MAP;
        Integer n40 = 152;
        Integer n41 = 10;
        Integer n42 = hashMap18.put(n40, n41);
        HashMap<Integer, String> hashMap19 = TEXT_STRING_COLUMN_NAME_MAP = new HashMap();
        Integer n43 = 131;
        String string6 = hashMap19.put(n43, "ct_l");
        HashMap<Integer, String> hashMap20 = TEXT_STRING_COLUMN_NAME_MAP;
        Integer n44 = 132;
        String string7 = hashMap20.put(n44, "ct_t");
        HashMap<Integer, String> hashMap21 = TEXT_STRING_COLUMN_NAME_MAP;
        Integer n45 = 138;
        String string8 = hashMap21.put(n45, "m_cls");
        HashMap<Integer, String> hashMap22 = TEXT_STRING_COLUMN_NAME_MAP;
        Integer n46 = 139;
        String string9 = hashMap22.put(n46, "m_id");
        HashMap<Integer, String> hashMap23 = TEXT_STRING_COLUMN_NAME_MAP;
        Integer n47 = 147;
        String string10 = hashMap23.put(n47, "resp_txt");
        HashMap<Integer, String> hashMap24 = TEXT_STRING_COLUMN_NAME_MAP;
        Integer n48 = 152;
        String string11 = hashMap24.put(n48, "tr_id");
        HashMap<Integer, Integer> hashMap25 = OCTET_COLUMN_INDEX_MAP = new HashMap();
        Integer n49 = 186;
        Integer n50 = 11;
        Integer n51 = hashMap25.put(n49, n50);
        HashMap<Integer, Integer> hashMap26 = OCTET_COLUMN_INDEX_MAP;
        Integer n52 = 134;
        Integer n53 = 12;
        Integer n54 = hashMap26.put(n52, n53);
        HashMap<Integer, Integer> hashMap27 = OCTET_COLUMN_INDEX_MAP;
        Integer n55 = 140;
        Integer n56 = 13;
        Integer n57 = hashMap27.put(n55, n56);
        HashMap<Integer, Integer> hashMap28 = OCTET_COLUMN_INDEX_MAP;
        Integer n58 = 141;
        Integer n59 = 14;
        Integer n60 = hashMap28.put(n58, n59);
        HashMap<Integer, Integer> hashMap29 = OCTET_COLUMN_INDEX_MAP;
        Integer n61 = 143;
        Integer n62 = 15;
        Integer n63 = hashMap29.put(n61, n62);
        HashMap<Integer, Integer> hashMap30 = OCTET_COLUMN_INDEX_MAP;
        Integer n64 = 144;
        Integer n65 = 16;
        Integer n66 = hashMap30.put(n64, n65);
        HashMap<Integer, Integer> hashMap31 = OCTET_COLUMN_INDEX_MAP;
        Integer n67 = 155;
        Integer n68 = 17;
        Integer n69 = hashMap31.put(n67, n68);
        HashMap<Integer, Integer> hashMap32 = OCTET_COLUMN_INDEX_MAP;
        Integer n70 = 145;
        Integer n71 = 18;
        Integer n72 = hashMap32.put(n70, n71);
        HashMap<Integer, Integer> hashMap33 = OCTET_COLUMN_INDEX_MAP;
        Integer n73 = 153;
        Integer n74 = 19;
        Integer n75 = hashMap33.put(n73, n74);
        HashMap<Integer, Integer> hashMap34 = OCTET_COLUMN_INDEX_MAP;
        Integer n76 = 149;
        Integer n77 = 20;
        Integer n78 = hashMap34.put(n76, n77);
        HashMap<Integer, String> hashMap35 = OCTET_COLUMN_NAME_MAP = new HashMap();
        Integer n79 = 186;
        String string12 = hashMap35.put(n79, "ct_cls");
        HashMap<Integer, String> hashMap36 = OCTET_COLUMN_NAME_MAP;
        Integer n80 = 134;
        String string13 = hashMap36.put(n80, "d_rpt");
        HashMap<Integer, String> hashMap37 = OCTET_COLUMN_NAME_MAP;
        Integer n81 = 140;
        String string14 = hashMap37.put(n81, "m_type");
        HashMap<Integer, String> hashMap38 = OCTET_COLUMN_NAME_MAP;
        Integer n82 = 141;
        String string15 = hashMap38.put(n82, "v");
        HashMap<Integer, String> hashMap39 = OCTET_COLUMN_NAME_MAP;
        Integer n83 = 143;
        String string16 = hashMap39.put(n83, "pri");
        HashMap<Integer, String> hashMap40 = OCTET_COLUMN_NAME_MAP;
        Integer n84 = 144;
        String string17 = hashMap40.put(n84, "rr");
        HashMap<Integer, String> hashMap41 = OCTET_COLUMN_NAME_MAP;
        Integer n85 = 155;
        String string18 = hashMap41.put(n85, "read_status");
        HashMap<Integer, String> hashMap42 = OCTET_COLUMN_NAME_MAP;
        Integer n86 = 145;
        String string19 = hashMap42.put(n86, "rpt_a");
        HashMap<Integer, String> hashMap43 = OCTET_COLUMN_NAME_MAP;
        Integer n87 = 153;
        String string20 = hashMap43.put(n87, "retr_st");
        HashMap<Integer, String> hashMap44 = OCTET_COLUMN_NAME_MAP;
        Integer n88 = 149;
        String string21 = hashMap44.put(n88, "st");
        HashMap<Integer, Integer> hashMap45 = LONG_COLUMN_INDEX_MAP = new HashMap();
        Integer n89 = 133;
        Integer n90 = 21;
        Integer n91 = hashMap45.put(n89, n90);
        HashMap<Integer, Integer> hashMap46 = LONG_COLUMN_INDEX_MAP;
        Integer n92 = 135;
        Integer n93 = 22;
        Integer n94 = hashMap46.put(n92, n93);
        HashMap<Integer, Integer> hashMap47 = LONG_COLUMN_INDEX_MAP;
        Integer n95 = 136;
        Integer n96 = 23;
        Integer n97 = hashMap47.put(n95, n96);
        HashMap<Integer, Integer> hashMap48 = LONG_COLUMN_INDEX_MAP;
        Integer n98 = 142;
        Integer n99 = 24;
        Integer n100 = hashMap48.put(n98, n99);
        HashMap<Integer, String> hashMap49 = LONG_COLUMN_NAME_MAP = new HashMap();
        Integer n101 = 133;
        String string22 = hashMap49.put(n101, "date");
        HashMap<Integer, String> hashMap50 = LONG_COLUMN_NAME_MAP;
        Integer n102 = 135;
        String string23 = hashMap50.put(n102, "d_tm");
        HashMap<Integer, String> hashMap51 = LONG_COLUMN_NAME_MAP;
        Integer n103 = 136;
        String string24 = hashMap51.put(n103, "exp");
        HashMap<Integer, String> hashMap52 = LONG_COLUMN_NAME_MAP;
        Integer n104 = 142;
        String string25 = hashMap52.put(n104, "m_size");
        PDU_CACHE_INSTANCE = PduCache.getInstance();
    }

    private PduPersister(Context context) {
        ContentResolver contentResolver;
        this.mContext = context;
        this.mContentResolver = contentResolver = context.getContentResolver();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getByteArrayFromPartColumn(Cursor cursor, int n) {
        if (cursor.isNull(n)) return null;
        return PduPersister.getBytes(cursor.getString(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getBytes(String string2) {
        try {
            byte[] byArray = string2.getBytes("iso-8859-1");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = Log.e(TAG, "ISO_8859_1 must be supported!", unsupportedEncodingException);
            return new byte[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer getIntegerFromPartColumn(Cursor cursor, int n) {
        if (cursor.isNull(n)) return null;
        return cursor.getInt(n);
    }

    public static PduPersister getPduPersister(Context context) {
        Context context2;
        if (sPersister == null || !context.equals(context2 = PduPersister.sPersister.mContext)) {
            sPersister = new PduPersister(context);
        }
        return sPersister;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAddress(long l, PduHeaders pduHeaders) {
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri = Uri.parse("content://mms/" + l + "/addr");
        String[] stringArray = new String[]{"address", "charset", "type"};
        String[] stringArray2 = null;
        String string2 = null;
        Cursor cursor = SqliteWrapper.query(context, contentResolver, uri, stringArray, null, stringArray2, string2);
        if (cursor == null) {
            return;
        }
        try {
            block8: while (cursor.moveToNext()) {
                String string3 = cursor.getString(0);
                if (TextUtils.isEmpty(string3)) continue;
                int n = cursor.getInt(2);
                switch (n) {
                    default: {
                        String string4 = "Unknown address type: " + n;
                        int n2 = Log.e(TAG, string4);
                        continue block8;
                    }
                    case 137: {
                        int n3 = cursor.getInt(1);
                        byte[] byArray = PduPersister.getBytes(string3);
                        EncodedStringValue encodedStringValue = new EncodedStringValue(n3, byArray);
                        pduHeaders.setEncodedStringValue(encodedStringValue, n);
                        continue block8;
                    }
                    case 129: 
                    case 130: 
                    case 151: 
                }
                int n4 = cursor.getInt(1);
                byte[] byArray = PduPersister.getBytes(string3);
                EncodedStringValue encodedStringValue = new EncodedStringValue(n4, byArray);
                pduHeaders.appendEncodedStringValue(encodedStringValue, n);
            }
            return;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Exception decompiling
     */
    private PduPart[] loadParts(long var1_1) throws MmsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 717->725)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void persistAddress(long l, int n, EncodedStringValue[] encodedStringValueArray) {
        ContentValues contentValues = new ContentValues(3);
        EncodedStringValue[] encodedStringValueArray2 = encodedStringValueArray;
        int n2 = encodedStringValueArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            EncodedStringValue encodedStringValue = encodedStringValueArray2[n3];
            contentValues.clear();
            String string2 = PduPersister.toIsoString(encodedStringValue.getTextString());
            contentValues.put("address", string2);
            Integer n4 = encodedStringValue.getCharacterSet();
            contentValues.put("charset", n4);
            Integer n5 = n;
            contentValues.put("type", n5);
            Uri uri = Uri.parse("content://mms/" + l + "/addr");
            Context context = this.mContext;
            ContentResolver contentResolver = this.mContentResolver;
            Uri uri2 = SqliteWrapper.insert(context, contentResolver, uri, contentValues);
            ++n3;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistData(PduPart var1_1, Uri var2_2, String var3_3) throws MmsException {
        block29: {
            var4_4 = null;
            var5_5 = null;
            try {
                try {
                    var6_6 = var1_1.getData();
                    if ("text/plain".equals(var3_3) || "application/smil".equals(var3_3) || "text/html".equals(var3_3)) {
                        var7_7 = new ContentValues();
                        var8_8 = new EncodedStringValue(var6_6).getString();
                        var7_7.put("text", var8_8);
                        if (this.mContentResolver.update(var2_2, var7_7, null, null) != 1) {
                            var9_9 = new StringBuilder().append("unable to update ");
                            var10_10 = var2_2.toString();
                            var11_11 = var9_9.append(var10_10).toString();
                            throw new MmsException(var11_11);
                        }
                        break block29;
                    }
                }
                catch (FileNotFoundException var12_12) {
                    var13_14 = Log.e("PduPersister", "Failed to open Input/Output stream.", var12_12);
                    throw new MmsException(var12_12);
                }
            }
            catch (Throwable var14_15) {
                block30: {
                    if (var4_4 != null) {
                        ** try [egrp 2[TRYBLOCK] [4 : 164->169)] { 
lbl23:
                        // 1 sources

                        break block30;
                    } else lbl-1000:
                    // 3 sources

                    {
                        while (true) {
                            if (var5_5 == null) throw var14_15;
                            var5_5.close();
                            throw var14_15;
                            break;
                        }
                    }
lbl29:
                    // 1 sources

                    catch (IOException var32_33) {
                        var33_34 = "IOException while closing: " + var4_4;
                        var34_35 = Log.e("PduPersister", var33_34, var32_33);
                        ** GOTO lbl-1000
                    }
                    catch (IOException var12_13) {
                        var25_26 = Log.e("PduPersister", "Failed to read/write data.", var12_13);
                        throw new MmsException(var12_13);
                    }
                }
                var4_4.close();
                ** continue;
                catch (IOException var35_36) {
                    var36_37 = "IOException while closing: " + var5_5;
                    var37_38 = Log.e("PduPersister", var36_37, var35_36);
                    throw var14_15;
                }
            }
            {
                var4_4 = this.mContentResolver.openOutputStream(var2_2);
                if (var6_6 != null) ** GOTO lbl-1000
                var15_16 = var1_1.getDataUri();
                if (var15_16 != null && var15_16 != var2_2) ** GOTO lbl-1000
                var16_17 = Log.w("PduPersister", "Can't find data for this part.");
                if (var4_4 == null) return;
            }
            try {
                var4_4.close();
                return;
            }
            catch (IOException var17_18) {
                var18_19 = "IOException while closing: " + var4_4;
                var19_20 = Log.e("PduPersister", var18_19, var17_18);
                return;
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = this.mContentResolver.openInputStream(var15_16);
                var23_24 = new byte[256];
                while ((var24_25 = var5_5.read(var23_24)) != -1) {
                    var4_4.write(var23_24, 0, var24_25);
                }
                break block29;
            }
lbl-1000:
            // 1 sources

            {
                var4_4.write(var6_6);
            }
        }
        if (var4_4 != null) {
            var4_4.close();
        }
lbl67:
        // 4 sources

        while (true) {
            if (var5_5 == null) {
                return;
            }
            try {
                var5_5.close();
                return;
            }
            catch (IOException var26_27) {
                var27_28 = "IOException while closing: " + var5_5;
                var28_29 = Log.e("PduPersister", var27_28, var26_27);
                return;
            }
            break;
        }
        catch (IOException var29_30) {
            var30_31 = "IOException while closing: " + var4_4;
            var31_32 = Log.e("PduPersister", var30_31, var29_30);
            ** continue;
        }
    }

    private void setEncodedStringValueToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        String string2 = cursor.getString(n);
        if (string2 == null) {
            return;
        }
        if (string2.length() <= 0) {
            return;
        }
        HashMap<Integer, Integer> hashMap = CHARSET_COLUMN_INDEX_MAP;
        Integer n3 = n2;
        int n4 = hashMap.get(n3);
        int n5 = cursor.getInt(n4);
        byte[] byArray = PduPersister.getBytes(string2);
        EncodedStringValue encodedStringValue = new EncodedStringValue(n5, byArray);
        pduHeaders.setEncodedStringValue(encodedStringValue, n2);
    }

    private void setLongToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        if (cursor.isNull(n)) {
            return;
        }
        long l = cursor.getLong(n);
        pduHeaders.setLongInteger(l, n2);
    }

    private void setOctetToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) throws InvalidHeaderValueException {
        if (cursor.isNull(n)) {
            return;
        }
        int n3 = cursor.getInt(n);
        pduHeaders.setOctet(n3, n2);
    }

    private void setTextStringToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        String string2 = cursor.getString(n);
        if (string2 == null) {
            return;
        }
        byte[] byArray = PduPersister.getBytes(string2);
        pduHeaders.setTextString(byArray, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toIsoString(byte[] byArray) {
        try {
            return new String(byArray, "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = Log.e(TAG, "ISO_8859_1 must be supported!", unsupportedEncodingException);
            return "";
        }
    }

    private void updateAddress(long l, int n, EncodedStringValue[] encodedStringValueArray) {
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri = Uri.parse("content://mms/" + l + "/addr");
        String string2 = "type=" + n;
        int n2 = SqliteWrapper.delete(context, contentResolver, uri, string2, null);
        this.persistAddress(l, n, encodedStringValueArray);
    }

    private void updatePart(Uri uri, PduPart pduPart) throws MmsException {
        ContentValues contentValues = new ContentValues(7);
        int n = pduPart.getCharset();
        if (n != 0) {
            Integer n2 = n;
            contentValues.put("chset", n2);
        }
        if (pduPart.getContentType() != null) {
            Uri uri2;
            String string2 = PduPersister.toIsoString(pduPart.getContentType());
            contentValues.put("ct", string2);
            if (pduPart.getFilename() != null) {
                byte[] byArray = pduPart.getFilename();
                String string3 = new String(byArray);
                contentValues.put("fn", string3);
            }
            if (pduPart.getName() != null) {
                byte[] byArray = pduPart.getName();
                String string4 = new String(byArray);
                contentValues.put("name", string4);
            }
            if (pduPart.getContentDisposition() != null) {
                String string5 = PduPersister.toIsoString(pduPart.getContentDisposition());
                contentValues.put("cd", string5);
            }
            if (pduPart.getContentId() != null) {
                String string6 = PduPersister.toIsoString(pduPart.getContentId());
                contentValues.put("cid", string6);
            }
            if (pduPart.getContentLocation() != null) {
                String string7 = PduPersister.toIsoString(pduPart.getContentLocation());
                contentValues.put("cl", string7);
            }
            Context context = this.mContext;
            ContentResolver contentResolver = this.mContentResolver;
            Uri uri3 = uri;
            String[] stringArray = null;
            int n3 = SqliteWrapper.update(context, contentResolver, uri3, contentValues, null, stringArray);
            if (pduPart.getData() == null && uri == (uri2 = pduPart.getDataUri())) {
                return;
            }
            this.persistData(pduPart, uri, string2);
            return;
        }
        throw new MmsException("MIME type of the part must be set.");
    }

    public Cursor getPendingMessages(long l) {
        String string2;
        Uri.Builder builder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
        Uri.Builder builder2 = builder.appendQueryParameter("protocol", "mms");
        String string3 = String.valueOf(10);
        String[] stringArray = new String[]{string3, string2 = String.valueOf(l)};
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri = builder.build();
        return SqliteWrapper.query(context, contentResolver, uri, null, "err_type < ? AND due_time <= ?", stringArray, "due_time");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenericPdu load(Uri var1_1) throws MmsException {
        var2_2 = PduPersister.PDU_CACHE_INSTANCE;
        var3_3 = var1_1;
        var4_4 = (PduCacheEntry)var2_2.get(var3_3);
        if (var4_4 != null) {
            return var4_4.getPdu();
        }
        var6_6 = this.mContext;
        var7_7 = this.mContentResolver;
        var8_8 = PduPersister.PDU_PROJECTION;
        var9_9 = var1_1;
        var10_10 = SqliteWrapper.query(var6_6, var7_7, var9_9, var8_8, null, null, null);
        var11_11 = new PduHeaders();
        var12_12 = ContentUris.parseId(var1_1);
        if (var10_10 == null) ** GOTO lbl16
        try {
            block28: {
                if (var10_10.getCount() == 1 && var10_10.moveToFirst()) break block28;
lbl16:
                // 2 sources

                var14_13 = new StringBuilder().append("Bad uri: ");
                var15_14 = var1_1;
                var16_15 = var14_13.append(var15_14).toString();
                throw new MmsException(var16_15);
            }
            var18_17 = 1;
            var19_18 = var10_10.getInt(var18_17);
            var20_19 = var10_10.getLong(2);
            for (Map.Entry<Integer, Integer> var23_21 : PduPersister.ENCODED_STRING_COLUMN_INDEX_MAP.entrySet()) {
                var24_22 = var23_21.getValue();
                var25_23 = var23_21.getKey();
                var26_24 = this;
                var27_25 = var10_10;
                var28_26 = var24_22;
                var29_27 = var11_11;
                var30_28 = var25_23;
                var26_24.setEncodedStringValueToHeaders(var27_25, var28_26, var29_27, var30_28);
            }
            for (Map.Entry<Integer, Integer> var31_29 : PduPersister.TEXT_STRING_COLUMN_INDEX_MAP.entrySet()) {
                var32_30 = var31_29.getValue();
                var33_31 = var31_29.getKey();
                var34_32 = this;
                var35_33 = var10_10;
                var36_34 = var32_30;
                var37_35 = var11_11;
                var38_36 = var33_31;
                var34_32.setTextStringToHeaders(var35_33, var36_34, var37_35, var38_36);
            }
            for (Map.Entry<Integer, Integer> var39_37 : PduPersister.OCTET_COLUMN_INDEX_MAP.entrySet()) {
                var40_38 = var39_37.getValue();
                var41_39 = var39_37.getKey();
                var42_40 = this;
                var43_41 = var10_10;
                var44_42 = var40_38;
                var45_43 = var11_11;
                var46_44 = var41_39;
                var42_40.setOctetToHeaders(var43_41, var44_42, var45_43, var46_44);
            }
            for (Map.Entry<Integer, Integer> var47_45 : PduPersister.LONG_COLUMN_INDEX_MAP.entrySet()) {
                var48_46 = var47_45.getValue();
                var49_47 = var47_45.getKey();
                var50_48 = this;
                var51_49 = var10_10;
                var52_50 = var48_46;
                var53_51 = var11_11;
                var54_52 = var49_47;
                var50_48.setLongToHeaders(var51_49, var52_50, var53_51, var54_52);
            }
        }
        finally {
            if (var10_10 != null) {
                var10_10.close();
            }
        }
        if (var12_12 == 65535L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        var55_53 = this;
        var56_54 = var12_12;
        var58_55 = var11_11;
        var55_53.loadAddress(var56_54, var58_55);
        var59_56 = var11_11;
        var60_57 = 140;
        var61_58 = var59_56.getOctet(var60_57);
        var62_59 = new PduBody();
        var63_60 = var61_58;
        var61_58 = 132;
        if ((var63_60 == var61_58 || (var65_61 = var61_58) == (var63_60 = 128)) && (var70_64 = (var67_62 = this).loadParts(var68_63 = var12_12)) != null) {
            var71_65 = var70_64.length;
            var72_66 = 0;
            while ((var73_67 = ++var72_66) < (var74_68 = var71_65)) {
                var75_69 = var70_64[var72_66];
                var76_70 = var62_59.addPart(var75_69);
            }
        }
        switch (var61_58) {
            default: {
                var77_71 = new StringBuilder().append("Unrecognized PDU type: ");
                var78_72 = Integer.toHexString(var61_58);
                var79_73 = var77_71.append(var78_72).toString();
                throw new MmsException(var79_73);
            }
            case 130: {
                var81_75 /* !! */  = var80_74 /* !! */ ;
                var82_76 = var11_11;
                var81_75 /* !! */ (var82_76);
                ** GOTO lbl136
            }
            case 134: {
                var93_86 /* !! */  = var80_74 /* !! */ ;
                var94_87 = var11_11;
                var93_86 /* !! */ (var94_87);
                ** GOTO lbl136
            }
            case 136: {
                var95_88 /* !! */  = var80_74 /* !! */ ;
                var96_89 = var11_11;
                var95_88 /* !! */ (var96_89);
                ** GOTO lbl136
            }
            case 132: {
                var97_90 /* !! */  = var80_74 /* !! */ ;
                var98_91 = var11_11;
                var99_92 = var62_59;
                var97_90 /* !! */ (var98_91, var99_92);
                ** GOTO lbl136
            }
            case 128: {
                var100_93 /* !! */  = var80_74 /* !! */ ;
                var101_94 = var11_11;
                var102_95 = var62_59;
                var100_93 /* !! */ (var101_94, var102_95);
                ** GOTO lbl136
            }
            case 133: {
                var103_96 /* !! */  = var80_74 /* !! */ ;
                var104_97 = var11_11;
                var103_96 /* !! */ (var104_97);
                ** GOTO lbl136
            }
            case 131: {
                var105_98 /* !! */  = var80_74 /* !! */ ;
                var106_99 = var11_11;
                var105_98 /* !! */ (var106_99);
                ** GOTO lbl136
            }
            case 135: {
                var107_100 /* !! */  = var80_74 /* !! */ ;
                var108_101 = var11_11;
                var107_100 /* !! */ (var108_101);
lbl136:
                // 8 sources

                var84_78 = var83_77;
                var85_79 /* !! */  = var80_74 /* !! */ ;
                var86_80 = var19_18;
                var87_81 = var20_19;
                var84_78(var85_79 /* !! */ , var86_80, var87_81);
                var89_82 = PduPersister.PDU_CACHE_INSTANCE;
                var90_83 = var1_1;
                var91_84 = var83_77;
                var92_85 = var89_82.put(var90_83, var91_84);
                return var80_74 /* !! */ ;
            }
            case 129: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
        }
        var109_102 = new StringBuilder().append("Unsupported PDU type: ");
        var110_103 = Integer.toHexString(var61_58);
        var111_104 = var109_102.append(var110_103).toString();
        throw new MmsException(var111_104);
    }

    public Uri move(Uri uri, Uri uri2) throws MmsException {
        long l = ContentUris.parseId(uri);
        if (l == 65535L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        Integer n = MESSAGE_BOX_MAP.get(uri2);
        if (n == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("msg_box", n);
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri3 = uri;
        String[] stringArray = null;
        int n2 = SqliteWrapper.update(context, contentResolver, uri3, contentValues, null, stringArray);
        return ContentUris.withAppendedId(uri2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Uri persist(GenericPdu genericPdu, Uri uri) throws MmsException {
        ContentValues contentValues;
        Uri uri2;
        ContentResolver contentResolver;
        ContentResolver contentResolver2;
        Context context;
        Context context2;
        Uri uri3;
        PduBody pduBody;
        EncodedStringValue[] encodedStringValueArray;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (uri == null) {
            throw new MmsException("Uri may not be null.");
        }
        HashMap<Uri, Integer> hashMap = MESSAGE_BOX_MAP;
        Uri uri4 = uri;
        if (hashMap.get(uri4) == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        PduCache pduCache = PDU_CACHE_INSTANCE;
        Uri uri5 = uri;
        PduCacheEntry pduCacheEntry = pduCache.purge(uri5);
        PduHeaders pduHeaders = genericPdu.getPduHeaders();
        ContentValues contentValues2 = new ContentValues();
        Iterator<Map.Entry<Integer, String>> iterator = ENCODED_STRING_COLUMN_NAME_MAP.entrySet().iterator();
        while (iterator.hasNext()) {
            PduHeaders pduHeaders2 = pduHeaders;
            Map.Entry<Integer, String> entry = iterator.next();
            int n7 = entry.getKey();
            int n8 = n7;
            EncodedStringValue encodedStringValue = pduHeaders2.getEncodedStringValue(n8);
            if (encodedStringValue == null) continue;
            HashMap<Integer, String> hashMap2 = CHARSET_COLUMN_NAME_MAP;
            Integer n9 = n7;
            String string2 = hashMap2.get(n9);
            String string3 = entry.getValue();
            String string4 = PduPersister.toIsoString(encodedStringValue.getTextString());
            contentValues2.put(string3, string4);
            Integer n10 = encodedStringValue.getCharacterSet();
            ContentValues contentValues3 = contentValues2;
            String string5 = string2;
            Integer n11 = n10;
            contentValues3.put(string5, n11);
        }
        Iterator<Map.Entry<Integer, String>> iterator2 = TEXT_STRING_COLUMN_NAME_MAP.entrySet().iterator();
        while (iterator2.hasNext()) {
            PduHeaders pduHeaders3 = pduHeaders;
            Map.Entry<Integer, String> entry = iterator2.next();
            int n12 = entry.getKey();
            int n13 = n12;
            byte[] byArray = pduHeaders3.getTextString(n13);
            if (byArray == null) continue;
            String string6 = entry.getValue();
            String string7 = PduPersister.toIsoString(byArray);
            contentValues2.put(string6, string7);
        }
        Iterator<Map.Entry<Integer, String>> iterator3 = OCTET_COLUMN_NAME_MAP.entrySet().iterator();
        while (iterator3.hasNext()) {
            PduHeaders pduHeaders4 = pduHeaders;
            Map.Entry<Integer, String> entry = iterator3.next();
            int n14 = entry.getKey();
            int n15 = n14;
            int n16 = pduHeaders4.getOctet(n15);
            if (n16 == 0) continue;
            String string8 = entry.getValue();
            Integer n17 = n16;
            contentValues2.put(string8, n17);
        }
        Iterator<Map.Entry<Integer, String>> iterator4 = LONG_COLUMN_NAME_MAP.entrySet().iterator();
        while (iterator4.hasNext()) {
            PduHeaders pduHeaders5 = pduHeaders;
            Map.Entry<Integer, String> entry = iterator4.next();
            int n18 = entry.getKey();
            int n19 = n18;
            long l = pduHeaders5.getLongInteger(n19);
            if (l == 65535L) continue;
            String string9 = entry.getValue();
            Long l2 = l;
            contentValues2.put(string9, l2);
        }
        int n20 = ADDRESS_FIELDS.length;
        HashMap<Integer, EncodedStringValue[]> hashMap3 = new HashMap<Integer, EncodedStringValue[]>(n20);
        int[] nArray = ADDRESS_FIELDS;
        int n21 = nArray.length;
        int n22 = 0;
        while ((n6 = ++n22) < (n5 = n21)) {
            int n23 = nArray[n22];
            EncodedStringValue[] encodedStringValueArray2 = null;
            if (n23 == 137) {
                PduHeaders pduHeaders6 = pduHeaders;
                int n24 = n23;
                EncodedStringValue encodedStringValue = pduHeaders6.getEncodedStringValue(n24);
                if (encodedStringValue != null) {
                    encodedStringValueArray2 = new EncodedStringValue[]{encodedStringValue};
                }
            } else {
                PduHeaders pduHeaders7 = pduHeaders;
                int n25 = n23;
                encodedStringValueArray2 = pduHeaders7.getEncodedStringValues(n25);
            }
            Integer n26 = n23;
            EncodedStringValue[] encodedStringValueArray3 = hashMap3.put(n26, encodedStringValueArray2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        long l = Long.MAX_VALUE;
        int n27 = genericPdu.getMessageType();
        int n28 = n27;
        if (n28 == (n27 = 130) || (n4 = n27) == (n3 = 132) || (n2 = n27) == (n = 128)) {
            encodedStringValueArray = null;
            switch (n27) {
                case 130: 
                case 132: {
                    Integer n29 = 137;
                    encodedStringValueArray = (EncodedStringValue[])hashMap3.get(n29);
                    break;
                }
                case 128: {
                    Integer n30 = 151;
                    encodedStringValueArray = (EncodedStringValue[])hashMap3.get(n30);
                }
            }
            if (encodedStringValueArray != null) {
                int n31;
                int n32;
                nArray = encodedStringValueArray;
                n21 = nArray.length;
                n22 = 0;
                while ((n32 = ++n22) < (n31 = n21)) {
                    int n33 = nArray[n22];
                    if (n33 == null) continue;
                    String string10 = n33.getString();
                    HashSet<String> hashSet2 = hashSet;
                    String string11 = string10;
                    boolean bl = hashSet2.add(string11);
                }
            }
            Context context3 = this.mContext;
            HashSet<String> hashSet3 = hashSet;
            l = Telephony.Threads.getOrCreateThreadId(context3, hashSet3);
        }
        Long l3 = l;
        contentValues2.put("thread_id", l3);
        long l4 = System.currentTimeMillis();
        if (genericPdu instanceof MultimediaMessagePdu && (pduBody = ((MultimediaMessagePdu)genericPdu).getBody()) != null) {
            int n34;
            int n35;
            int n36 = pduBody.getPartsNum();
            int n37 = 0;
            while ((n35 = n37) < (n34 = n36)) {
                PduBody pduBody2 = pduBody;
                int n38 = n37++;
                PduPart pduPart = pduBody2.getPart(n38);
                PduPersister pduPersister = this;
                PduPart pduPart2 = pduPart;
                long l5 = l4;
                Uri uri6 = pduPersister.persistPart(pduPart2, l5);
            }
        }
        if ((uri3 = SqliteWrapper.insert(context2 = (context = this.mContext), contentResolver2 = (contentResolver = this.mContentResolver), uri2 = uri, contentValues = contentValues2)) == null) {
            throw new MmsException("persist() failed: return null.");
        }
        long l6 = ContentUris.parseId(uri3);
        ContentValues contentValues4 = new ContentValues(1);
        Long l7 = l6;
        contentValues4.put("mid", l7);
        Context context4 = this.mContext;
        ContentResolver contentResolver3 = this.mContentResolver;
        StringBuilder stringBuilder = new StringBuilder().append("content://mms/");
        long l8 = l4;
        Uri uri7 = Uri.parse(stringBuilder.append(l8).append("/part").toString());
        int n39 = SqliteWrapper.update(context4, contentResolver3, uri7, contentValues4, null, null);
        StringBuilder stringBuilder2 = new StringBuilder();
        Uri uri8 = uri;
        StringBuilder stringBuilder3 = stringBuilder2.append(uri8).append("/");
        long l9 = l6;
        Uri uri9 = Uri.parse(stringBuilder3.append(l9).toString());
        int[] nArray2 = ADDRESS_FIELDS;
        int n40 = nArray2.length;
        int n41 = 0;
        int n42;
        int n43;
        while ((n43 = ++n41) < (n42 = n40)) {
            int n44 = nArray2[n41];
            Integer n45 = n44;
            encodedStringValueArray = (EncodedStringValue[])hashMap3.get(n45);
            if (encodedStringValueArray == null) continue;
            PduPersister pduPersister = this;
            long l10 = l6;
            int n46 = n44;
            EncodedStringValue[] encodedStringValueArray4 = encodedStringValueArray;
            pduPersister.persistAddress(l10, n46, encodedStringValueArray4);
        }
        return uri9;
    }

    public Uri persistPart(PduPart pduPart, long l) throws MmsException {
        Uri uri;
        String string2;
        Uri uri2 = Uri.parse("content://mms/" + l + "/part");
        ContentValues contentValues = new ContentValues(8);
        int n = pduPart.getCharset();
        if (n != 0) {
            Integer n2 = n;
            contentValues.put("chset", n2);
        }
        if (pduPart.getContentType() != null) {
            ContentResolver contentResolver;
            Context context;
            string2 = PduPersister.toIsoString(pduPart.getContentType());
            contentValues.put("ct", string2);
            if ("application/smil".equals(string2)) {
                Integer n3 = -1;
                contentValues.put("seq", n3);
            }
            if (pduPart.getFilename() != null) {
                byte[] byArray = pduPart.getFilename();
                String string3 = new String(byArray);
                contentValues.put("fn", string3);
            }
            if (pduPart.getName() != null) {
                byte[] byArray = pduPart.getName();
                String string4 = new String(byArray);
                contentValues.put("name", string4);
            }
            if (pduPart.getContentDisposition() != null) {
                String string5 = PduPersister.toIsoString(pduPart.getContentDisposition());
                contentValues.put("cd", string5);
            }
            if (pduPart.getContentId() != null) {
                String string6 = PduPersister.toIsoString(pduPart.getContentId());
                contentValues.put("cid", string6);
            }
            if (pduPart.getContentLocation() != null) {
                String string7 = PduPersister.toIsoString(pduPart.getContentLocation());
                contentValues.put("cl", string7);
            }
            if ((uri = SqliteWrapper.insert(context = this.mContext, contentResolver = this.mContentResolver, uri2, contentValues)) == null) {
                throw new MmsException("Failed to persist part, return null.");
            }
        } else {
            throw new MmsException("MIME type of the part must be set.");
        }
        this.persistData(pduPart, uri, string2);
        pduPart.setDataUri(uri);
        return uri;
    }

    public void release() {
        Uri uri = Uri.parse(TEMPORARY_DRM_OBJECT_URI);
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        int n = SqliteWrapper.delete(context, contentResolver, uri, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public void updateHeaders(Uri var1_1, SendReq var2_2) {
        block16: {
            block15: {
                var3_3 = PduPersister.PDU_CACHE_INSTANCE;
                var4_4 = var1_1;
                var5_5 = var3_3.purge(var4_4);
                var6_6 = new ContentValues(10);
                var7_7 = var2_2.getContentType();
                if (var7_7 != null) {
                    var8_8 = PduPersister.toIsoString(var7_7);
                    var6_6.put("ct_t", var8_8);
                }
                if ((var9_9 = var2_2.getDate()) != 65535L) {
                    var11_10 = var9_9;
                    var6_6.put("date", var11_10);
                }
                if ((var12_11 = var2_2.getDeliveryReport()) != 0) {
                    var13_12 = var12_11;
                    var6_6.put("d_rpt", var13_12);
                }
                if ((var14_13 = var2_2.getExpiry()) != 65535L) {
                    var16_14 = var14_13;
                    var6_6.put("exp", var16_14);
                }
                if ((var17_15 = var2_2.getMessageClass()) != null) {
                    var18_16 = PduPersister.toIsoString(var17_15);
                    var6_6.put("m_cls", var18_16);
                }
                if ((var19_17 = var2_2.getPriority()) != 0) {
                    var20_18 = var19_17;
                    var6_6.put("pri", var20_18);
                }
                if ((var21_19 = var2_2.getReadReport()) != 0) {
                    var22_20 = var21_19;
                    var6_6.put("rr", var22_20);
                }
                if ((var23_21 = var2_2.getTransactionId()) != null) {
                    var24_22 = PduPersister.toIsoString(var23_21);
                    var6_6.put("tr_id", var24_22);
                }
                if ((var25_23 = var2_2.getSubject()) != null) {
                    var26_24 = PduPersister.toIsoString(var25_23.getTextString());
                    var6_6.put("sub", var26_24);
                    var27_25 = var25_23.getCharacterSet();
                    var6_6.put("sub_cs", var27_25);
lbl35:
                    // 2 sources

                    while (true) {
                        var28_26 = var2_2.getMessageSize();
                        if (var28_26 > 0L) {
                            var30_27 = var28_26;
                            var6_6.put("m_size", var30_27);
                        }
                        var31_28 = var2_2.getPduHeaders();
                        var32_29 = new HashSet<String>();
                        var33_30 = PduPersister.ADDRESS_FIELDS;
                        var34_31 = var33_30.length;
                        var35_32 = 0;
                        block1: while ((var36_33 = ++var35_32) < (var37_34 = var34_31)) {
                            var38_35 = var33_30[var35_32];
                            var39_36 = null;
                            if (var38_35 != 137) break block15;
                            var40_37 = var31_28;
                            var41_38 = var38_35;
                            var42_39 = var40_37.getEncodedStringValue(var41_38);
                            if (var42_39 != null) {
                                var39_36 = new EncodedStringValue[]{var42_39};
                            }
lbl54:
                            // 4 sources

                            while (var39_36 != null) {
                                var43_40 = ContentUris.parseId(var1_1);
                                var45_41 = this;
                                var46_42 = var43_40;
                                var48_43 = var38_35;
                                var49_44 = var39_36;
                                var45_41.updateAddress(var46_42, var48_43, var49_44);
                                if (var38_35 != 151) continue block1;
                                var50_45 = var39_36;
                                var51_46 = var50_45.length;
                                var52_47 = 0;
                                while ((var53_48 = ++var52_47) < (var54_49 = var51_46)) {
                                    var42_39 = var50_45[var52_47];
                                    if (var42_39 == null) continue;
                                    var55_50 = var42_39.getString();
                                    var56_51 = var32_29;
                                    var57_52 = var55_50;
                                    var58_53 = var56_51.add(var57_52);
                                }
                                continue block1;
                            }
                        }
                        break block16;
                        break;
                    }
                }
                var6_6.put("sub", "");
                ** while (true)
            }
            var59_54 = var31_28;
            var60_55 = var38_35;
            var39_36 = var59_54.getEncodedStringValues(var60_55);
            ** GOTO lbl54
        }
        var61_56 = this.mContext;
        var62_57 = var32_29;
        var63_58 = Telephony.Threads.getOrCreateThreadId(var61_56, var62_57);
        var6_6.put("thread_id", var63_58);
        var64_59 = this.mContext;
        var65_60 = this.mContentResolver;
        var66_61 = var1_1;
        var67_62 = SqliteWrapper.update(var64_59, var65_60, var66_61, var6_6, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateParts(Uri uri, PduBody pduBody) throws MmsException {
        int n;
        PduCache pduCache = PDU_CACHE_INSTANCE;
        Uri uri2 = uri;
        PduCacheEntry pduCacheEntry = (PduCacheEntry)pduCache.get(uri2);
        if (pduCacheEntry != null) {
            MultimediaMessagePdu multimediaMessagePdu = (MultimediaMessagePdu)pduCacheEntry.getPdu();
            PduBody pduBody2 = pduBody;
            multimediaMessagePdu.setBody(pduBody2);
        }
        ArrayList<PduPart> arrayList = new ArrayList<PduPart>();
        HashMap<Uri, PduPart> hashMap = new HashMap<Uri, PduPart>();
        int n2 = pduBody.getPartsNum();
        StringBuilder stringBuilder = new StringBuilder().append('(');
        for (int i = 0; i < n2; ++i) {
            int n3;
            PduBody pduBody3 = pduBody;
            int n4 = i;
            PduPart pduPart = pduBody3.getPart(n4);
            Uri uri3 = pduPart.getDataUri();
            if (uri3 == null || !uri3.getAuthority().startsWith("mms")) {
                boolean bl = arrayList.add(pduPart);
                continue;
            }
            PduPart pduPart2 = hashMap.put(uri3, pduPart);
            int n5 = stringBuilder.length();
            if (n5 > (n3 = 1)) {
                StringBuilder stringBuilder2 = stringBuilder;
                String string2 = " AND ";
                StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            }
            StringBuilder stringBuilder4 = stringBuilder;
            String string3 = "_id";
            StringBuilder stringBuilder5 = stringBuilder4.append(string3);
            StringBuilder stringBuilder6 = stringBuilder;
            String string4 = "!=";
            StringBuilder stringBuilder7 = stringBuilder6.append(string4);
            String string5 = uri3.getLastPathSegment();
            StringBuilder stringBuilder8 = stringBuilder;
            String string6 = string5;
            DatabaseUtils.appendEscapedSQLString(stringBuilder8, string6);
        }
        StringBuilder stringBuilder9 = stringBuilder;
        char c = ')';
        StringBuilder stringBuilder10 = stringBuilder9.append(c);
        long l = ContentUris.parseId(uri);
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        StringBuilder stringBuilder11 = new StringBuilder();
        Uri uri4 = Telephony.Mms.CONTENT_URI;
        StringBuilder stringBuilder12 = stringBuilder11.append(uri4).append("/");
        long l2 = l;
        Uri uri5 = Uri.parse(stringBuilder12.append(l2).append("/part").toString());
        int n6 = stringBuilder.length();
        String string7 = n6 > (n = 2) ? stringBuilder.toString() : null;
        int n7 = SqliteWrapper.delete(context, contentResolver, uri5, string7, null);
        for (PduPart pduPart : arrayList) {
            PduPersister pduPersister = this;
            PduPart pduPart3 = pduPart;
            long l3 = l;
            Uri uri6 = pduPersister.persistPart(pduPart3, l3);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Uri uri7 = (Uri)entry.getKey();
            PduPart pduPart = (PduPart)entry.getValue();
            this.updatePart(uri7, pduPart);
        }
        return;
    }
}

