/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.util.Log;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduHeaders;

public class SendReq
extends MultimediaMessagePdu {
    private static final String TAG = "SendReq";

    public SendReq() {
        try {
            this.setMessageType(128);
            this.setMmsVersion(18);
            byte[] byArray = "application/vnd.wap.multipart.related".getBytes();
            this.setContentType(byArray);
            byte[] byArray2 = "insert-address-token".getBytes();
            EncodedStringValue encodedStringValue = new EncodedStringValue(byArray2);
            this.setFrom(encodedStringValue);
            byte[] byArray3 = this.generateTransactionId();
            this.setTransactionId(byArray3);
            return;
        }
        catch (InvalidHeaderValueException invalidHeaderValueException) {
            int n = Log.e(TAG, "Unexpected InvalidHeaderValueException.", invalidHeaderValueException);
            throw new RuntimeException(invalidHeaderValueException);
        }
    }

    SendReq(PduHeaders pduHeaders) {
        super(pduHeaders);
    }

    SendReq(PduHeaders pduHeaders, PduBody pduBody) {
        super(pduHeaders, pduBody);
    }

    public SendReq(byte[] byArray, EncodedStringValue encodedStringValue, int n, byte[] byArray2) throws InvalidHeaderValueException {
        this.setMessageType(128);
        this.setContentType(byArray);
        this.setFrom(encodedStringValue);
        this.setMmsVersion(n);
        this.setTransactionId(byArray2);
    }

    private byte[] generateTransactionId() {
        StringBuilder stringBuilder = new StringBuilder().append("T");
        String string2 = Long.toHexString(System.currentTimeMillis());
        return stringBuilder.append(string2).toString().getBytes();
    }

    public void addBcc(EncodedStringValue encodedStringValue) {
        this.mPduHeaders.appendEncodedStringValue(encodedStringValue, 129);
    }

    public void addCc(EncodedStringValue encodedStringValue) {
        this.mPduHeaders.appendEncodedStringValue(encodedStringValue, 130);
    }

    public EncodedStringValue[] getBcc() {
        return this.mPduHeaders.getEncodedStringValues(129);
    }

    public EncodedStringValue[] getCc() {
        return this.mPduHeaders.getEncodedStringValues(130);
    }

    public byte[] getContentType() {
        return this.mPduHeaders.getTextString(132);
    }

    public int getDeliveryReport() {
        return this.mPduHeaders.getOctet(134);
    }

    public long getExpiry() {
        return this.mPduHeaders.getLongInteger(136);
    }

    public byte[] getMessageClass() {
        return this.mPduHeaders.getTextString(138);
    }

    public long getMessageSize() {
        return this.mPduHeaders.getLongInteger(142);
    }

    public int getReadReport() {
        return this.mPduHeaders.getOctet(144);
    }

    public byte[] getTransactionId() {
        return this.mPduHeaders.getTextString(152);
    }

    public void setBcc(EncodedStringValue[] encodedStringValueArray) {
        this.mPduHeaders.setEncodedStringValues(encodedStringValueArray, 129);
    }

    public void setCc(EncodedStringValue[] encodedStringValueArray) {
        this.mPduHeaders.setEncodedStringValues(encodedStringValueArray, 130);
    }

    public void setContentType(byte[] byArray) {
        this.mPduHeaders.setTextString(byArray, 132);
    }

    public void setDeliveryReport(int n) throws InvalidHeaderValueException {
        this.mPduHeaders.setOctet(n, 134);
    }

    public void setExpiry(long l) {
        this.mPduHeaders.setLongInteger(l, 136);
    }

    public void setMessageClass(byte[] byArray) {
        this.mPduHeaders.setTextString(byArray, 138);
    }

    public void setMessageSize(long l) {
        this.mPduHeaders.setLongInteger(l, 142);
    }

    public void setReadReport(int n) throws InvalidHeaderValueException {
        this.mPduHeaders.setOctet(n, 144);
    }

    public void setTo(EncodedStringValue[] encodedStringValueArray) {
        this.mPduHeaders.setEncodedStringValues(encodedStringValueArray, 151);
    }

    public void setTransactionId(byte[] byArray) {
        this.mPduHeaders.setTextString(byArray, 152);
    }
}

