/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util;

import java.util.HashMap;

public abstract class AbstractCache<K, V> {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MAX_CACHED_ITEMS = 500;
    private static final String TAG = "AbstractCache";
    private final HashMap<K, CacheEntry<V>> mCacheMap;

    protected AbstractCache() {
        HashMap hashMap = new HashMap();
        this.mCacheMap = hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V get(K k) {
        V v;
        CacheEntry<V> cacheEntry;
        if (k != null && (cacheEntry = this.mCacheMap.get(k)) != null) {
            int n;
            cacheEntry.hit = n = cacheEntry.hit + 1;
            v = cacheEntry.value;
            return v;
        }
        v = null;
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V purge(K k) {
        V v;
        CacheEntry<V> cacheEntry = this.mCacheMap.remove(k);
        if (cacheEntry != null) {
            v = cacheEntry.value;
            return v;
        }
        v = null;
        return v;
    }

    public void purgeAll() {
        this.mCacheMap.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean put(K k, V v) {
        if (this.mCacheMap.size() >= 500) {
            return false;
        }
        if (k == null) return false;
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.value = v;
        CacheEntry cacheEntry2 = this.mCacheMap.put(k, cacheEntry);
        return true;
    }

    public int size() {
        return this.mCacheMap.size();
    }

    private static class CacheEntry<V> {
        int hit;
        V value;

        private CacheEntry() {
        }
    }
}

