/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util;

import android.content.ContentUris;
import android.content.UriMatcher;
import android.net.Uri;
import android.provider.Telephony;
import com.google.android.mms.util.AbstractCache;
import com.google.android.mms.util.PduCacheEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class PduCache
extends AbstractCache<Uri, PduCacheEntry> {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final HashMap<Integer, Integer> MATCH_TO_MSGBOX_ID_MAP;
    private static final int MMS_ALL = 0;
    private static final int MMS_ALL_ID = 1;
    private static final int MMS_CONVERSATION = 10;
    private static final int MMS_CONVERSATION_ID = 11;
    private static final int MMS_DRAFTS = 6;
    private static final int MMS_DRAFTS_ID = 7;
    private static final int MMS_INBOX = 2;
    private static final int MMS_INBOX_ID = 3;
    private static final int MMS_OUTBOX = 8;
    private static final int MMS_OUTBOX_ID = 9;
    private static final int MMS_SENT = 4;
    private static final int MMS_SENT_ID = 5;
    private static final String TAG = "PduCache";
    private static final UriMatcher URI_MATCHER;
    private static PduCache sInstance;
    private final HashMap<Integer, HashSet<Uri>> mMessageBoxes;
    private final HashMap<Long, HashSet<Uri>> mThreads;

    static {
        URI_MATCHER = new UriMatcher(-1);
        URI_MATCHER.addURI("mms", null, 0);
        URI_MATCHER.addURI("mms", "#", 1);
        URI_MATCHER.addURI("mms", "inbox", 2);
        URI_MATCHER.addURI("mms", "inbox/#", 3);
        URI_MATCHER.addURI("mms", "sent", 4);
        URI_MATCHER.addURI("mms", "sent/#", 5);
        URI_MATCHER.addURI("mms", "drafts", 6);
        URI_MATCHER.addURI("mms", "drafts/#", 7);
        URI_MATCHER.addURI("mms", "outbox", 8);
        URI_MATCHER.addURI("mms", "outbox/#", 9);
        URI_MATCHER.addURI("mms-sms", "conversations", 10);
        URI_MATCHER.addURI("mms-sms", "conversations/#", 11);
        HashMap<Integer, Integer> hashMap = MATCH_TO_MSGBOX_ID_MAP = new HashMap();
        Integer n = 2;
        Integer n2 = 1;
        Integer n3 = hashMap.put(n, n2);
        HashMap<Integer, Integer> hashMap2 = MATCH_TO_MSGBOX_ID_MAP;
        Integer n4 = 4;
        Integer n5 = 2;
        Integer n6 = hashMap2.put(n4, n5);
        HashMap<Integer, Integer> hashMap3 = MATCH_TO_MSGBOX_ID_MAP;
        Integer n7 = 6;
        Integer n8 = 3;
        Integer n9 = hashMap3.put(n7, n8);
        HashMap<Integer, Integer> hashMap4 = MATCH_TO_MSGBOX_ID_MAP;
        Integer n10 = 8;
        Integer n11 = 4;
        Integer n12 = hashMap4.put(n10, n11);
    }

    private PduCache() {
        HashMap hashMap = new HashMap();
        this.mMessageBoxes = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mThreads = hashMap2;
    }

    public static final PduCache getInstance() {
        synchronized (PduCache.class) {
            if (sInstance == null) {
                sInstance = new PduCache();
            }
            PduCache pduCache = sInstance;
            return pduCache;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Uri normalizeKey(Uri uri) {
        switch (URI_MATCHER.match(uri)) {
            default: {
                return null;
            }
            case 1: {
                Uri uri2 = uri;
                return uri2;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
        }
        String string2 = uri.getLastPathSegment();
        return Uri.withAppendedPath(Telephony.Mms.CONTENT_URI, string2);
    }

    private void purgeByMessageBox(Integer n) {
        if (n == null) {
            return;
        }
        HashSet<Uri> hashSet = this.mMessageBoxes.remove(n);
        if (hashSet == null) {
            return;
        }
        Iterator<Uri> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Uri uri = iterator.next();
            PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
            if (pduCacheEntry == null) continue;
            this.removeFromThreads(uri, pduCacheEntry);
        }
        return;
    }

    private void purgeByThreadId(long l) {
        HashMap<Long, HashSet<Uri>> hashMap = this.mThreads;
        Long l2 = l;
        HashSet<Uri> hashSet = hashMap.remove(l2);
        if (hashSet == null) {
            return;
        }
        Iterator<Uri> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Uri uri = iterator.next();
            PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
            if (pduCacheEntry == null) continue;
            this.removeFromMessageBoxes(uri, pduCacheEntry);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PduCacheEntry purgeSingleEntry(Uri uri) {
        PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
        if (pduCacheEntry == null) return null;
        this.removeFromThreads(uri, pduCacheEntry);
        this.removeFromMessageBoxes(uri, pduCacheEntry);
        return pduCacheEntry;
    }

    private void removeFromMessageBoxes(Uri uri, PduCacheEntry pduCacheEntry) {
        HashMap<Long, HashSet<Uri>> hashMap = this.mThreads;
        Integer n = pduCacheEntry.getMessageBox();
        HashSet<Uri> hashSet = hashMap.get(n);
        if (hashSet == null) {
            return;
        }
        boolean bl = hashSet.remove(uri);
    }

    private void removeFromThreads(Uri uri, PduCacheEntry pduCacheEntry) {
        HashMap<Long, HashSet<Uri>> hashMap = this.mThreads;
        Long l = pduCacheEntry.getThreadId();
        HashSet<Uri> hashSet = hashMap.get(l);
        if (hashSet == null) {
            return;
        }
        boolean bl = hashSet.remove(uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PduCacheEntry purge(Uri uri) {
        synchronized (this) {
            int n;
            int n2 = n = URI_MATCHER.match(uri);
            switch (n2) {
                default: {
                    return null;
                }
                case 1: {
                    return this.purgeSingleEntry(uri);
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    String string2 = uri.getLastPathSegment();
                    Uri uri2 = Uri.withAppendedPath(Telephony.Mms.CONTENT_URI, string2);
                    return this.purgeSingleEntry(uri2);
                }
                case 0: 
                case 10: {
                    this.purgeAll();
                    return null;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    HashMap<Integer, Integer> hashMap = MATCH_TO_MSGBOX_ID_MAP;
                    Integer n3 = n2;
                    Integer n4 = hashMap.get(n3);
                    this.purgeByMessageBox(n4);
                    return null;
                }
                case 11: {
                    long l = ContentUris.parseId(uri);
                    this.purgeByThreadId(l);
                    return null;
                }
            }
        }
    }

    @Override
    public void purgeAll() {
        synchronized (this) {
            super.purgeAll();
            this.mMessageBoxes.clear();
            this.mThreads.clear();
            return;
        }
    }

    @Override
    public boolean put(Uri uri, PduCacheEntry pduCacheEntry) {
        synchronized (this) {
            Uri uri2;
            boolean bl;
            long l;
            Long l2;
            HashMap<Long, HashSet<Uri>> hashMap;
            HashSet<Uri> hashSet;
            int n = pduCacheEntry.getMessageBox();
            HashMap<Integer, HashSet<Uri>> hashMap2 = this.mMessageBoxes;
            Integer n2 = n;
            HashSet<Uri> hashSet2 = hashMap2.get(n2);
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
                HashMap<Integer, HashSet<Uri>> hashMap3 = this.mMessageBoxes;
                Integer n3 = n;
                HashSet<Uri> hashSet3 = hashMap3.put(n3, hashSet2);
            }
            if ((hashSet = (hashMap = this.mThreads).get(l2 = Long.valueOf(l = pduCacheEntry.getThreadId()))) == null) {
                hashSet = new HashSet();
                HashMap<Long, HashSet<Uri>> hashMap4 = this.mThreads;
                Long l3 = l;
                HashSet<Uri> hashSet4 = hashMap4.put(l3, hashSet);
            }
            if (bl = super.put(uri2 = this.normalizeKey(uri), pduCacheEntry)) {
                boolean bl2 = hashSet2.add(uri2);
                boolean bl3 = hashSet.add(uri2);
            }
            return bl;
        }
    }
}

