/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMessageParser {
    public static final String musicNote = "\u266b ";
    private HashMap<Character, Format> formatStart;
    private int nextChar;
    private int nextClass;
    private boolean parseAcronyms;
    private boolean parseFormatting;
    private boolean parseMeText;
    private boolean parseMusic;
    private boolean parseSmilies;
    private boolean parseUrls;
    private ArrayList<Part> parts;
    private String text;
    private ArrayList<Token> tokens;

    public AbstractMessageParser(String string2) {
        AbstractMessageParser abstractMessageParser = this;
        String string3 = string2;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        abstractMessageParser(string3, true, bl, bl2, bl3, bl4, bl5);
    }

    public AbstractMessageParser(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.text = string2;
        this.nextChar = 0;
        this.nextClass = 10;
        ArrayList arrayList = new ArrayList();
        this.parts = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.tokens = arrayList2;
        HashMap hashMap = new HashMap();
        this.formatStart = hashMap;
        this.parseSmilies = bl;
        this.parseAcronyms = bl2;
        this.parseFormatting = bl3;
        this.parseUrls = bl4;
        this.parseMusic = bl5;
        this.parseMeText = bl6;
    }

    private void addToken(Token token) {
        boolean bl = this.tokens.add(token);
    }

    private void addURLToken(String string2, String string3) {
        Token token = AbstractMessageParser.tokenForUrl(string2, string3);
        this.addToken(token);
    }

    private void buildParts(String string2) {
        int n;
        for (int i = 0; i < (n = this.tokens.size()); ++i) {
            Token token = this.tokens.get(i);
            if (token.isMedia() || this.parts.size() == 0 || this.lastPart().isMedia()) {
                ArrayList<Part> arrayList = this.parts;
                Part part = new Part();
                boolean bl = arrayList.add(part);
            }
            this.lastPart().add(token);
        }
        if (this.parts.size() <= 0) {
            return;
        }
        this.parts.get(0).setMeText(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCharClass(int n) {
        int n2;
        if (n < 0) return 0;
        if (this.text.length() <= n) {
            return 0;
        }
        char c = this.text.charAt(n);
        if (Character.isWhitespace(c)) {
            return 1;
        }
        if (Character.isLetter(c)) {
            return 2;
        }
        if (Character.isDigit(c)) {
            return 3;
        }
        if (!AbstractMessageParser.isPunctuation(c)) return 4;
        this.nextClass = n2 = this.nextClass + 1;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDomainChar(char c) {
        if (c == '-') return true;
        if (Character.isLetter(c)) return true;
        if (!Character.isDigit(c)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFormatChar(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '*': 
            case '^': 
            case '_': 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPunctuation(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '!': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '?': 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSmileyBreak(char c, char c2) {
        switch (c) {
            default: {
                return false;
            }
            case '$': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': 
            case '}': 
            case '~': 
        }
        switch (c2) {
            default: {
                return false;
            }
            case '#': 
            case '$': 
            case '%': 
            case '*': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case '^': 
            case '~': 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSmileyBreak(int n) {
        char c;
        if (n <= 0) return false;
        int n2 = this.text.length();
        if (n >= n2) return false;
        String string2 = this.text;
        int n3 = n - 1;
        char c2 = string2.charAt(n3);
        if (!AbstractMessageParser.isSmileyBreak(c2, c = this.text.charAt(n))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isURLBreak(int n) {
        int n2 = n - 1;
        switch (this.getCharClass(n2)) {
            default: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDomain(String string2) {
        String string3;
        TrieNode trieNode = this.getResources().getDomainSuffixes();
        if (!AbstractMessageParser.matches(trieNode, string3 = AbstractMessageParser.reverse(string2))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWordBreak(int n) {
        int n2;
        int n3 = n - 1;
        int n4 = this.getCharClass(n3);
        if (n4 == (n2 = this.getCharClass(n))) return false;
        return true;
    }

    private Part lastPart() {
        ArrayList<Part> arrayList = this.parts;
        int n = this.parts.size() - 1;
        return arrayList.get(n);
    }

    private static TrieNode longestMatch(TrieNode trieNode, AbstractMessageParser abstractMessageParser, int n) {
        return AbstractMessageParser.longestMatch(trieNode, abstractMessageParser, n, false);
    }

    private static TrieNode longestMatch(TrieNode trieNode, AbstractMessageParser abstractMessageParser, int n, boolean bl) {
        int n2 = n;
        TrieNode trieNode2 = null;
        while (true) {
            int n3;
            block8: {
                block7: {
                    int n4;
                    if (n2 >= (n4 = abstractMessageParser.getRawText().length())) break block7;
                    String string2 = abstractMessageParser.getRawText();
                    n3 = n2 + 1;
                    char c = string2.charAt(n2);
                    if ((trieNode = trieNode.getChild(c)) != null) break block8;
                    int n5 = n3;
                }
                return trieNode2;
            }
            if (trieNode.exists()) {
                if (abstractMessageParser.isWordBreak(n3)) {
                    trieNode2 = trieNode;
                    n2 = n3;
                    continue;
                }
                if (bl && abstractMessageParser.isSmileyBreak(n3)) {
                    trieNode2 = trieNode;
                    n2 = n3;
                    continue;
                }
            }
            n2 = n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matches(TrieNode trieNode, String string2) {
        int n;
        int n2 = 0;
        while (n2 < (n = string2.length())) {
            int n3 = n2 + 1;
            char c = string2.charAt(n2);
            if ((trieNode = trieNode.getChild(c)) == null) {
                int n4 = n3;
                return false;
            }
            if (trieNode.exists()) {
                boolean bl = true;
                int n5 = n3;
                return bl;
            }
            n2 = n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseAcronym() {
        int n;
        int n2;
        if (!this.parseAcronyms) {
            return false;
        }
        TrieNode trieNode = this.getResources().getAcronyms();
        TrieNode trieNode2 = AbstractMessageParser.longestMatch(trieNode, this, n2 = this.nextChar);
        if (trieNode2 == null) {
            return false;
        }
        String string2 = trieNode2.getText();
        String string3 = trieNode2.getValue();
        Acronym acronym = new Acronym(string2, string3);
        this.addToken(acronym);
        int n3 = this.nextChar;
        int n4 = trieNode2.getText().length();
        this.nextChar = n = n3 + n4;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseFormatting() {
        int n;
        int n2;
        if (!this.parseFormatting) {
            return false;
        }
        for (n2 = this.nextChar; n2 < (n = this.text.length()) && AbstractMessageParser.isFormatChar(this.text.charAt(n2)); ++n2) {
        }
        int n3 = this.nextChar;
        if (n2 == n3) return false;
        if (!this.isWordBreak(n2)) {
            return false;
        }
        LinkedHashMap<Character, Boolean> linkedHashMap = new LinkedHashMap<Character, Boolean>();
        for (int i = this.nextChar; i < n2; ++i) {
            char c = this.text.charAt(i);
            Character c2 = Character.valueOf(c);
            if (linkedHashMap.containsKey(c2)) {
                Format format = new Format(c, false);
                this.addToken(format);
                continue;
            }
            Format format = this.formatStart.get(c2);
            if (format != null) {
                format.setMatched(true);
                Format format2 = this.formatStart.remove(c2);
                Boolean bl = Boolean.TRUE;
                Boolean bl2 = linkedHashMap.put(c2, bl);
                continue;
            }
            Format format3 = new Format(c, true);
            Format format4 = this.formatStart.put(c2, format3);
            this.addToken(format3);
            Boolean bl = Boolean.FALSE;
            Boolean bl3 = linkedHashMap.put(c2, bl);
        }
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (true) {
            Boolean bl;
            if (!iterator.hasNext()) {
                this.nextChar = n2;
                return true;
            }
            Character c = (Character)iterator.next();
            Object v = linkedHashMap.get(c);
            if (v != (bl = Boolean.TRUE)) continue;
            char c3 = c.charValue();
            Format format = new Format(c3, false);
            format.setMatched(true);
            this.addToken(format);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseMusicTrack() {
        int n;
        if (!this.parseMusic) return false;
        if (!this.text.startsWith(musicNote)) return false;
        String string2 = this.text;
        int n2 = musicNote.length();
        String string3 = string2.substring(n2);
        MusicTrack musicTrack = new MusicTrack(string3);
        this.addToken(musicTrack);
        this.nextChar = n = this.text.length();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseSmiley() {
        int n;
        int n2;
        if (!this.parseSmilies) {
            return false;
        }
        TrieNode trieNode = this.getResources().getSmileys();
        TrieNode trieNode2 = AbstractMessageParser.longestMatch(trieNode, this, n2 = this.nextChar, true);
        if (trieNode2 == null) {
            return false;
        }
        int n3 = this.nextChar - 1;
        int n4 = this.getCharClass(n3);
        int n5 = this.nextChar;
        int n6 = trieNode2.getText().length();
        int n7 = n5 + n6;
        int n8 = this.getCharClass(n7);
        if (n4 == 2 || n4 == 3) {
            if (n8 == 2) return false;
            if (n8 == 3) {
                return false;
            }
        }
        String string2 = trieNode2.getText();
        Smiley smiley = new Smiley(string2);
        this.addToken(smiley);
        int n9 = this.nextChar;
        int n10 = trieNode2.getText().length();
        this.nextChar = n = n9 + n10;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseText() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.nextChar;
        do {
            int n3;
            String string2 = this.text;
            int n4 = this.nextChar;
            this.nextChar = n3 = n4 + 1;
            char c = string2.charAt(n4);
            switch (c) {
                default: {
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder3 = stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder4 = stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder5 = stringBuilder.append("&amp;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder6 = stringBuilder.append("&quot;");
                    break;
                }
                case '\'': {
                    StringBuilder stringBuilder7 = stringBuilder.append("&apos;");
                    break;
                }
                case '\n': {
                    StringBuilder stringBuilder8 = stringBuilder.append("<br>");
                }
            }
        } while (!this.isWordBreak(n = this.nextChar));
        String string3 = this.text;
        int n5 = this.nextChar;
        String string4 = string3.substring(n2, n5);
        String string5 = stringBuilder.toString();
        Html html = new Html(string4, string5);
        this.addToken(html);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseURL() {
        boolean bl;
        String string2;
        int n;
        int n2;
        block20: {
            block22: {
                char c;
                block23: {
                    block21: {
                        int n3;
                        int n4;
                        String string3;
                        block19: {
                            char c2;
                            int n5;
                            if (!this.parseUrls) return false;
                            int n6 = this.nextChar;
                            if (!this.isURLBreak(n6)) {
                                return false;
                            }
                            for (n2 = n = this.nextChar; n2 < (n5 = this.text.length()) && this.isDomainChar(c2 = this.text.charAt(n2)); ++n2) {
                            }
                            string2 = "";
                            bl = false;
                            int n7 = this.text.length();
                            if (n2 != n7) {
                                return false;
                            }
                            if (this.text.charAt(n2) != ':') break block19;
                            String string4 = this.text;
                            int n8 = this.nextChar;
                            String string5 = string4.substring(n8, n2);
                            if (!this.getResources().getSchemes().contains(string5)) {
                                return false;
                            }
                            break block20;
                        }
                        if (this.text.charAt(n2) != '.') {
                            return false;
                        }
                        while (true) {
                            int n9;
                            if (n2 >= (n9 = this.text.length()) || (c = this.text.charAt(n2)) != '.' && !this.isDomainChar(c)) {
                                String string6 = this.text;
                                int n10 = this.nextChar;
                                String string7 = string6.substring(n10, n2);
                                if (this.isValidDomain(string7)) break;
                                return false;
                            }
                            ++n2;
                        }
                        int n11 = n2 + 1;
                        int n12 = this.text.length();
                        if (n11 < n12 && this.text.charAt(n2) == ':' && Character.isDigit((string3 = this.text).charAt(n4 = n2 + 1))) {
                            int n13;
                            ++n2;
                            while (n2 < (n13 = this.text.length()) && Character.isDigit(this.text.charAt(n2))) {
                                ++n2;
                            }
                        }
                        if (n2 == (n3 = this.text.length())) break block21;
                        bl = true;
                        break block22;
                    }
                    c = this.text.charAt(n2);
                    if (c != '?') break block23;
                    int n14 = n2 + 1;
                    int n15 = this.text.length();
                    if (n14 != n15) {
                        bl = true;
                        break block22;
                    } else {
                        String string8 = this.text;
                        int n16 = n2 + 1;
                        char c3 = string8.charAt(n16);
                        if (Character.isWhitespace(c3) || AbstractMessageParser.isPunctuation(c3)) {
                            bl = true;
                        }
                    }
                    break block22;
                }
                if (AbstractMessageParser.isPunctuation(c)) {
                    bl = true;
                } else if (Character.isWhitespace(c)) {
                    bl = true;
                } else if (c != '/' && c != '#') {
                    return false;
                }
            }
            string2 = "http://";
        }
        if (!bl) {
            int n17;
            while (n2 < (n17 = this.text.length()) && !Character.isWhitespace(this.text.charAt(n2))) {
                ++n2;
            }
        }
        String string9 = this.text.substring(n, n2);
        String string10 = string2 + string9;
        this.addURLToken(string10, string9);
        this.nextChar = n2;
        return true;
    }

    protected static String reverse(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string2.length() - 1; i >= 0; i += -1) {
            char c = string2.charAt(i);
            StringBuilder stringBuilder2 = stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Token tokenForUrl(String string2, String string3) {
        void var2_3;
        if (string2 == null) {
            return var2_3;
        }
        Video video = Video.matchURL(string2, string3);
        if (video != null) {
            Video video2 = video;
            return var2_3;
        }
        YouTubeVideo youTubeVideo = YouTubeVideo.matchURL(string2, string3);
        if (youTubeVideo != null) {
            YouTubeVideo youTubeVideo2 = youTubeVideo;
            return var2_3;
        }
        Photo photo = Photo.matchURL(string2, string3);
        if (photo != null) {
            Photo photo2 = photo;
            return var2_3;
        }
        FlickrPhoto flickrPhoto = FlickrPhoto.matchURL(string2, string3);
        if (flickrPhoto != null) {
            FlickrPhoto flickrPhoto2 = flickrPhoto;
            return var2_3;
        }
        Link link = new Link(string2, string3);
        return var2_3;
    }

    public final Part getPart(int n) {
        return this.parts.get(n);
    }

    public final int getPartCount() {
        return this.parts.size();
    }

    public final List<Part> getParts() {
        return this.parts;
    }

    public final String getRawText() {
        return this.text;
    }

    protected abstract Resources getResources();

    public void parse() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.parseMusicTrack()) {
            this.buildParts(null);
            return;
        }
        String string2 = null;
        if (this.parseMeText && this.text.startsWith("/me") && this.text.length() > 3 && Character.isWhitespace(this.text.charAt(3))) {
            String string3;
            string2 = this.text.substring(0, 4);
            this.text = string3 = this.text.substring(4);
        }
        boolean bl = false;
        while ((n4 = this.nextChar) < (n3 = this.text.length())) {
            int n5;
            int n6 = this.nextChar;
            if (!(this.isWordBreak(n6) || bl && this.isSmileyBreak(n5 = this.nextChar))) {
                throw new AssertionError((Object)"last chunk did not end at word break");
            }
            if (this.parseSmiley()) {
                bl = true;
                continue;
            }
            bl = false;
            if (this.parseAcronym() || this.parseURL() || this.parseFormatting()) continue;
            this.parseText();
        }
        for (int i = 0; i < (n2 = this.tokens.size()); ++i) {
            int n7;
            ArrayList<Token> arrayList;
            int n8;
            int n9;
            int n10;
            ArrayList<Token> arrayList2;
            if (!this.tokens.get(i).isMedia()) continue;
            if (i > 0 && (arrayList2 = this.tokens).get(n10 = i - 1) instanceof Html) {
                ArrayList<Token> arrayList3 = this.tokens;
                int n11 = i - 1;
                ((Html)arrayList3.get(n11)).trimLeadingWhitespace();
            }
            if ((n9 = i + 1) >= (n8 = this.tokens.size()) || !((arrayList = this.tokens).get(n7 = i + 1) instanceof Html)) continue;
            ArrayList<Token> arrayList4 = this.tokens;
            int n12 = i + 1;
            ((Html)arrayList4.get(n12)).trimTrailingWhitespace();
        }
        for (int i = 0; i < (n = this.tokens.size()); ++i) {
            if (!this.tokens.get(i).isHtml() || this.tokens.get(i).toHtml(true).length() != 0) continue;
            Token token = this.tokens.remove(i);
            i += -1;
        }
        this.buildParts(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Part> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = iterator.next();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append("<p>");
            for (Token token : part.getTokens()) {
                if (token.isHtml()) {
                    String string2 = token.toHtml(bl);
                    StringBuilder stringBuilder3 = stringBuilder.append(string2);
                } else {
                    int[] nArray = 1.$SwitchMap$com$google$android$util$AbstractMessageParser$Token$Type;
                    int n = token.getType().ordinal();
                    switch (nArray[n]) {
                        default: {
                            StringBuilder stringBuilder4 = new StringBuilder().append("unknown token type: ");
                            Token.Type type = token.getType();
                            String string3 = stringBuilder4.append((Object)type).toString();
                            throw new AssertionError((Object)string3);
                        }
                        case 1: {
                            StringBuilder stringBuilder5 = stringBuilder.append("<a href=\"");
                            String string4 = ((Link)token).getURL();
                            StringBuilder stringBuilder6 = stringBuilder.append(string4);
                            StringBuilder stringBuilder7 = stringBuilder.append("\">");
                            String string5 = token.getRawText();
                            StringBuilder stringBuilder8 = stringBuilder.append(string5);
                            StringBuilder stringBuilder9 = stringBuilder.append("</a>");
                            break;
                        }
                        case 2: {
                            String string6 = token.getRawText();
                            StringBuilder stringBuilder10 = stringBuilder.append(string6);
                            break;
                        }
                        case 3: {
                            String string7 = token.getRawText();
                            StringBuilder stringBuilder11 = stringBuilder.append(string7);
                            break;
                        }
                        case 4: {
                            String string8 = ((MusicTrack)token).getTrack();
                            StringBuilder stringBuilder12 = stringBuilder.append(string8);
                            break;
                        }
                        case 5: {
                            StringBuilder stringBuilder13 = stringBuilder.append("<a href=\"");
                            Video video = (Video)token;
                            String string9 = Video.getURL(((Video)token).getDocID());
                            StringBuilder stringBuilder14 = stringBuilder.append(string9);
                            StringBuilder stringBuilder15 = stringBuilder.append("\">");
                            String string10 = token.getRawText();
                            StringBuilder stringBuilder16 = stringBuilder.append(string10);
                            StringBuilder stringBuilder17 = stringBuilder.append("</a>");
                            break;
                        }
                        case 6: {
                            StringBuilder stringBuilder18 = stringBuilder.append("<a href=\"");
                            YouTubeVideo youTubeVideo = (YouTubeVideo)token;
                            String string11 = YouTubeVideo.getURL(((YouTubeVideo)token).getDocID());
                            StringBuilder stringBuilder19 = stringBuilder.append(string11);
                            StringBuilder stringBuilder20 = stringBuilder.append("\">");
                            String string12 = token.getRawText();
                            StringBuilder stringBuilder21 = stringBuilder.append(string12);
                            StringBuilder stringBuilder22 = stringBuilder.append("</a>");
                            break;
                        }
                        case 7: {
                            StringBuilder stringBuilder23 = stringBuilder.append("<a href=\"");
                            String string13 = ((Photo)token).getUser();
                            String string14 = ((Photo)token).getAlbum();
                            String string15 = Photo.getAlbumURL(string13, string14);
                            StringBuilder stringBuilder24 = stringBuilder.append(string15);
                            StringBuilder stringBuilder25 = stringBuilder.append("\">");
                            String string16 = token.getRawText();
                            StringBuilder stringBuilder26 = stringBuilder.append(string16);
                            StringBuilder stringBuilder27 = stringBuilder.append("</a>");
                            break;
                        }
                        case 8: {
                            Photo photo = (Photo)token;
                            StringBuilder stringBuilder28 = stringBuilder.append("<a href=\"");
                            String string17 = ((FlickrPhoto)token).getUrl();
                            StringBuilder stringBuilder29 = stringBuilder.append(string17);
                            StringBuilder stringBuilder30 = stringBuilder.append("\">");
                            String string18 = token.getRawText();
                            StringBuilder stringBuilder31 = stringBuilder.append(string18);
                            StringBuilder stringBuilder32 = stringBuilder.append("</a>");
                        }
                    }
                }
                if (!token.controlCaps()) continue;
                bl = token.setCaps();
            }
            StringBuilder stringBuilder33 = stringBuilder.append("</p>\n");
        }
        return stringBuilder.toString();
    }

    public static class Part {
        private String meText;
        private ArrayList<Token> tokens;

        public Part() {
            ArrayList arrayList = new ArrayList();
            this.tokens = arrayList;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getPartType() {
            if (this.isMedia()) {
                return "d";
            }
            if (this.meText == null) return "";
            return "m";
        }

        public void add(Token token) {
            if (this.isMedia()) {
                throw new AssertionError((Object)"media ");
            }
            boolean bl = this.tokens.add(token);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Token getMediaToken() {
            if (!this.isMedia()) return null;
            return this.tokens.get(0);
        }

        public String getRawText() {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.meText != null) {
                String string2 = this.meText;
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
            }
            for (int i = 0; i < (n = this.tokens.size()); ++i) {
                String string3 = this.tokens.get(i).getRawText();
                StringBuilder stringBuilder3 = stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }

        public ArrayList<Token> getTokens() {
            return this.tokens;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String getType(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = bl ? "s" : "r";
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            String string3 = this.getPartType();
            return stringBuilder2.append(string3).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isMedia() {
            if (this.tokens.size() != 1) return false;
            if (!this.tokens.get(0).isMedia()) return false;
            return true;
        }

        public void setMeText(String string2) {
            this.meText = string2;
        }
    }

    public static class TrieNode {
        private final HashMap<Character, TrieNode> children;
        private String text;
        private String value;

        public TrieNode() {
            this("");
        }

        public TrieNode(String string2) {
            HashMap hashMap = new HashMap();
            this.children = hashMap;
            this.text = string2;
        }

        public static void addToTrie(TrieNode trieNode, String string2, String string3) {
            int n;
            int n2 = 0;
            while (n2 < (n = string2.length())) {
                int n3 = n2 + 1;
                char c = string2.charAt(n2);
                trieNode = trieNode.getOrCreateChild(c);
                n2 = n3;
            }
            trieNode.setValue(string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean exists() {
            if (this.value == null) return false;
            return true;
        }

        public TrieNode getChild(char c) {
            HashMap<Character, TrieNode> hashMap = this.children;
            Character c2 = Character.valueOf(c);
            return hashMap.get(c2);
        }

        public TrieNode getOrCreateChild(char c) {
            Character c2 = Character.valueOf(c);
            TrieNode trieNode = this.children.get(c2);
            if (trieNode == null) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.text;
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                String string3 = String.valueOf(c);
                String string4 = stringBuilder2.append(string3).toString();
                trieNode = new TrieNode(string4);
                TrieNode trieNode2 = this.children.put(c2, trieNode);
            }
            return trieNode;
        }

        public final String getText() {
            return this.text;
        }

        public final String getValue() {
            return this.value;
        }

        public void setValue(String string2) {
            this.value = string2;
        }
    }

    public static class Format
    extends Token {
        private char ch;
        private boolean matched;
        private boolean start;

        public Format(char c, boolean bl) {
            Token.Type type = Token.Type.FORMAT;
            String string2 = String.valueOf(c);
            super(type, string2);
            this.ch = c;
            this.start = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getFormatEnd(char c) {
            switch (c) {
                default: {
                    String string2 = "unknown format '" + c + "'";
                    throw new AssertionError((Object)string2);
                }
                case '*': {
                    return "</b>";
                }
                case '_': {
                    return "</i>";
                }
                case '^': {
                    return "</font></b>";
                }
                case '\"': 
            }
            return "\u201d</font>";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getFormatStart(char c) {
            switch (c) {
                default: {
                    String string2 = "unknown format '" + c + "'";
                    throw new AssertionError((Object)string2);
                }
                case '*': {
                    return "<b>";
                }
                case '_': {
                    return "<i>";
                }
                case '^': {
                    return "<b><font color=\"#005FFF\">";
                }
                case '\"': 
            }
            return "<font color=\"#999999\">\u201c";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean controlCaps() {
            if (this.ch != '^') return false;
            return true;
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        @Override
        public boolean setCaps() {
            return this.start;
        }

        public void setMatched(boolean bl) {
            this.matched = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toHtml(boolean bl) {
            if (this.matched) {
                if (this.start) {
                    char c = this.ch;
                    return this.getFormatStart(c);
                }
                char c = this.ch;
                return this.getFormatEnd(c);
            }
            if (this.ch != '\"') return String.valueOf(this.ch);
            return "&quot;";
        }
    }

    public static class Acronym
    extends Token {
        private String value;

        public Acronym(String string2, String string3) {
            Token.Type type = Token.Type.ACRONYM;
            super(type, string2);
            this.value = string3;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = this.getRawText();
            boolean bl = list.add(string2);
            String string3 = this.getValue();
            boolean bl2 = list.add(string3);
            return list;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class Smiley
    extends Token {
        public Smiley(String string2) {
            Token.Type type = Token.Type.SMILEY;
            super(type, string2);
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = this.getRawText();
            boolean bl = list.add(string2);
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class FlickrPhoto
    extends Token {
        private static final Pattern GROUPING_PATTERN;
        private static final String SETS = "sets";
        private static final String TAGS = "tags";
        private static final Pattern URL_PATTERN;
        private String grouping;
        private String groupingId;
        private String photo;
        private String user;

        static {
            URL_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/?([^/?#&]+)?/?.*");
            GROUPING_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/(tags|sets)/([^/?#&]+)/?");
        }

        /*
         * Enabled aggressive block sorting
         */
        public FlickrPhoto(String string2, String string3, String string4, String string5, String string6) {
            Token.Type type = Token.Type.FLICKR;
            super(type, string6);
            if (TAGS.equals(string2)) {
                this.user = null;
                this.photo = null;
                this.grouping = TAGS;
                this.groupingId = string3;
                return;
            }
            this.user = string2;
            String string7 = !"show".equals(string3) ? string3 : null;
            this.photo = string7;
            this.grouping = string4;
            this.groupingId = string5;
        }

        public static String getPhotoURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/" + string3;
        }

        public static String getRssUrl(String string2) {
            return null;
        }

        public static String getTagsURL(String string2) {
            return "http://flickr.com/photos/tags/" + string2;
        }

        public static String getUserSetsURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/sets/" + string3;
        }

        public static String getUserTagsURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/tags/" + string3;
        }

        public static String getUserURL(String string2) {
            return "http://flickr.com/photos/" + string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static FlickrPhoto matchURL(String string2, String string3) {
            Matcher matcher = GROUPING_PATTERN.matcher(string2);
            if (matcher.matches()) {
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                String string6 = matcher.group(3);
                String string7 = string3;
                return new FlickrPhoto(string4, null, string5, string6, string7);
            }
            matcher = URL_PATTERN.matcher(string2);
            if (!matcher.matches()) return null;
            String string8 = matcher.group(1);
            String string9 = matcher.group(2);
            String string10 = null;
            String string11 = null;
            String string12 = string3;
            return new FlickrPhoto(string8, string9, string10, string11, string12);
        }

        public String getGrouping() {
            return this.grouping;
        }

        public String getGroupingId() {
            return this.groupingId;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = this.getUrl();
            boolean bl = list.add(string2);
            String string3 = this.getUser() != null ? this.getUser() : "";
            boolean bl2 = list.add(string3);
            String string4 = this.getPhoto() != null ? this.getPhoto() : "";
            boolean bl3 = list.add(string4);
            String string5 = this.getGrouping() != null ? this.getGrouping() : "";
            boolean bl4 = list.add(string5);
            String string6 = this.getGroupingId() != null ? this.getGroupingId() : "";
            boolean bl5 = list.add(string6);
            return list;
        }

        public String getPhoto() {
            return this.photo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getUrl() {
            String string2 = this.grouping;
            if (SETS.equals(string2)) {
                String string3 = this.user;
                String string4 = this.groupingId;
                return FlickrPhoto.getUserSetsURL(string3, string4);
            }
            String string5 = this.grouping;
            if (TAGS.equals(string5)) {
                if (this.user == null) return FlickrPhoto.getTagsURL(this.groupingId);
                String string6 = this.user;
                String string7 = this.groupingId;
                return FlickrPhoto.getUserTagsURL(string6, string7);
            }
            if (this.photo == null) return FlickrPhoto.getUserURL(this.user);
            String string8 = this.user;
            String string9 = this.photo;
            return FlickrPhoto.getPhotoURL(string8, string9);
        }

        public String getUser() {
            return this.user;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class Photo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("http://picasaweb.google.com/([^/?#&]+)/+((?!searchbrowse)[^/?#&]+)(?:/|/photo)?(?:\\?[^#]*)?(?:#(.*))?");
        private String album;
        private String photo;
        private String user;

        public Photo(String string2, String string3, String string4, String string5) {
            Token.Type type = Token.Type.PHOTO;
            super(type, string5);
            this.user = string2;
            this.album = string3;
            this.photo = string4;
        }

        public static String getAlbumURL(String string2, String string3) {
            return "http://picasaweb.google.com/" + string2 + "/" + string3;
        }

        public static String getPhotoURL(String string2, String string3, String string4) {
            return "http://picasaweb.google.com/" + string2 + "/" + string3 + "/photo#" + string4;
        }

        public static String getRssUrl(String string2) {
            return "http://picasaweb.google.com/data/feed/api/user/" + string2 + "?category=album&alt=rss";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Photo matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (!matcher.matches()) return null;
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            return new Photo(string4, string5, string6, string3);
        }

        public String getAlbum() {
            return this.album;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = Photo.getRssUrl(this.getUser());
            boolean bl = list.add(string2);
            String string3 = this.getUser();
            String string4 = this.getAlbum();
            String string5 = Photo.getAlbumURL(string3, string4);
            boolean bl2 = list.add(string5);
            if (this.getPhoto() != null) {
                String string6 = this.getUser();
                String string7 = this.getAlbum();
                String string8 = this.getPhoto();
                String string9 = Photo.getPhotoURL(string6, string7, string8);
                boolean bl3 = list.add(string9);
                return list;
            }
            String string10 = null;
            boolean bl4 = list.add(string10);
            return list;
        }

        public String getPhoto() {
            return this.photo;
        }

        public String getUser() {
            return this.user;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class YouTubeVideo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://(?:[a-z0-9]+\\.)?youtube\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/watch\\?.*\\bv=([-_a-zA-Z0-9=]+).*");
        private String docid;

        public YouTubeVideo(String string2, String string3) {
            Token.Type type = Token.Type.YOUTUBE_VIDEO;
            super(type, string3);
            this.docid = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getPrefixedURL(boolean bl, String string2, String string3, String string4) {
            String string5 = "";
            if (bl) {
                string5 = "http://";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string4 == null) {
                string4 = "";
                return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
            }
            if (string4.length() <= 0) return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
            string4 = string4 + "&";
            return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
        }

        public static String getRssUrl(String string2) {
            return "http://youtube.com/watch?v=" + string2;
        }

        public static String getURL(String string2) {
            return YouTubeVideo.getURL(string2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getURL(String string2, String string3) {
            if (string3 == null) {
                string3 = "";
                return "http://youtube.com/watch?" + string3 + "v=" + string2;
            }
            if (string3.length() <= 0) return "http://youtube.com/watch?" + string3 + "v=" + string2;
            string3 = string3 + "&";
            return "http://youtube.com/watch?" + string3 + "v=" + string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static YouTubeVideo matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (!matcher.matches()) return null;
            String string4 = matcher.group(1);
            return new YouTubeVideo(string4, string3);
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = YouTubeVideo.getRssUrl(this.docid);
            boolean bl = list.add(string2);
            String string3 = YouTubeVideo.getURL(this.docid);
            boolean bl2 = list.add(string3);
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class Video
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://video\\.google\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/videoplay\\?.*?\\bdocid=(-?\\d+).*");
        private String docid;

        public Video(String string2, String string3) {
            Token.Type type = Token.Type.GOOGLE_VIDEO;
            super(type, string3);
            this.docid = string2;
        }

        public static String getRssUrl(String string2) {
            return "http://video.google.com/videofeed?type=docid&output=rss&sourceid=gtalk&docid=" + string2;
        }

        public static String getURL(String string2) {
            return Video.getURL(string2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getURL(String string2, String string3) {
            if (string3 == null) {
                string3 = "";
                return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
            }
            if (string3.length() <= 0) return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
            string3 = string3 + "&";
            return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Video matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (!matcher.matches()) return null;
            String string4 = matcher.group(1);
            return new Video(string4, string3);
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = Video.getRssUrl(this.docid);
            boolean bl = list.add(string2);
            String string3 = Video.getURL(this.docid);
            boolean bl2 = list.add(string3);
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class Link
    extends Token {
        private String url;

        public Link(String string2, String string3) {
            Token.Type type = Token.Type.LINK;
            super(type, string3);
            this.url = string2;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = this.getURL();
            boolean bl = list.add(string2);
            String string3 = this.getRawText();
            boolean bl2 = list.add(string3);
            return list;
        }

        public String getURL() {
            return this.url;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class MusicTrack
    extends Token {
        private String track;

        public MusicTrack(String string2) {
            Token.Type type = Token.Type.MUSIC;
            super(type, string2);
            this.track = string2;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            String string2 = this.getTrack();
            boolean bl = list.add(string2);
            return list;
        }

        public String getTrack() {
            return this.track;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class Html
    extends Token {
        private String html;

        public Html(String string2, String string3) {
            Token.Type type = Token.Type.HTML;
            super(type, string2);
            this.html = string3;
        }

        private static String trimLeadingWhitespace(String string2) {
            int n;
            int n2;
            for (n2 = 0; n2 < (n = string2.length()) && Character.isWhitespace(string2.charAt(n2)); ++n2) {
            }
            return string2.substring(n2);
        }

        public static String trimTrailingWhitespace(String string2) {
            int n;
            int n2;
            for (n2 = string2.length(); n2 > 0 && Character.isWhitespace(string2.charAt(n = n2 - 1)); n2 += -1) {
            }
            return string2.substring(0, n2);
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toHtml(boolean bl) {
            if (!bl) return this.html;
            return this.html.toUpperCase();
        }

        public void trimLeadingWhitespace() {
            String string2;
            String string3;
            this.text = string3 = Html.trimLeadingWhitespace(this.text);
            this.html = string2 = Html.trimLeadingWhitespace(this.html);
        }

        public void trimTrailingWhitespace() {
            String string2;
            String string3;
            this.text = string3 = Html.trimTrailingWhitespace(this.text);
            this.html = string2 = Html.trimTrailingWhitespace(this.html);
        }
    }

    public static abstract class Token {
        protected String text;
        protected Type type;

        protected Token(Type type, String string2) {
            this.type = type;
            this.text = string2;
        }

        public boolean controlCaps() {
            return false;
        }

        public List<String> getInfo() {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = this.getType().toString();
            boolean bl = arrayList.add(string2);
            return arrayList;
        }

        public String getRawText() {
            return this.text;
        }

        public Type getType() {
            return this.type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isArray() {
            if (this.isHtml()) return false;
            return true;
        }

        public abstract boolean isHtml();

        public boolean isMedia() {
            return false;
        }

        public boolean setCaps() {
            return false;
        }

        public String toHtml(boolean bl) {
            throw new AssertionError((Object)"not html");
        }

        public static final class Type
        extends Enum<Type> {
            private static final /* synthetic */ Type[] $VALUES;
            public static final /* enum */ Type ACRONYM;
            public static final /* enum */ Type FLICKR;
            public static final /* enum */ Type FORMAT;
            public static final /* enum */ Type GOOGLE_VIDEO;
            public static final /* enum */ Type HTML;
            public static final /* enum */ Type LINK;
            public static final /* enum */ Type MUSIC;
            public static final /* enum */ Type PHOTO;
            public static final /* enum */ Type SMILEY;
            public static final /* enum */ Type YOUTUBE_VIDEO;
            private String stringRep;

            static {
                HTML = new Type("html");
                FORMAT = new Type("format");
                LINK = new Type("l");
                SMILEY = new Type("e");
                ACRONYM = new Type("a");
                MUSIC = new Type("m");
                GOOGLE_VIDEO = new Type("v");
                YOUTUBE_VIDEO = new Type("yt");
                PHOTO = new Type("p");
                FLICKR = new Type("f");
                Type type = HTML;
                Type type2 = FORMAT;
                Type type3 = LINK;
                Type type4 = SMILEY;
                Type type5 = ACRONYM;
                Type type6 = MUSIC;
                Type type7 = GOOGLE_VIDEO;
                Type type8 = YOUTUBE_VIDEO;
                Type type9 = PHOTO;
                Type type10 = FLICKR;
                Type[] typeArray = new Type[]{type, type2, type3, type4, type5, type6, type7, type8, type9, type10};
                $VALUES = typeArray;
            }

            private Type(String string3) {
                this.stringRep = string3;
            }

            public static Type valueOf(String string2) {
                return Enum.valueOf(Type.class, string2);
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public String toString() {
                return this.stringRep;
            }
        }
    }

    public static interface Resources {
        public TrieNode getAcronyms();

        public TrieNode getDomainSuffixes();

        public Set<String> getSchemes();

        public TrieNode getSmileys();
    }
}

