/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorCache;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.GrantCredentialsPermissionActivity;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.telephony.ITelephony;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AccountManagerService
extends IAccountManager.Stub
implements RegisteredServicesCacheListener<AuthenticatorDescription> {
    private static final Intent ACCOUNTS_CHANGED_INTENT;
    private static final String ACCOUNTS_ID = "_id";
    private static final String ACCOUNTS_NAME = "name";
    private static final String ACCOUNTS_PASSWORD = "password";
    private static final String ACCOUNTS_TYPE = "type";
    private static final String ACCOUNTS_TYPE_COUNT = "count(type)";
    private static final String[] ACCOUNT_NAME_TYPE_PROJECTION;
    private static final String[] ACCOUNT_TYPE_COUNT_PROJECTION;
    private static final String AUTHTOKENS_ACCOUNTS_ID = "accounts_id";
    private static final String AUTHTOKENS_AUTHTOKEN = "authtoken";
    private static final String AUTHTOKENS_ID = "_id";
    private static final String AUTHTOKENS_TYPE = "type";
    private static final String COUNT_OF_MATCHING_GRANTS = "SELECT COUNT(*) FROM grants, accounts WHERE accounts_id=_id AND uid=? AND auth_token_type=? AND name=? AND type=?";
    private static final String DATABASE_NAME = "accounts.db";
    private static final int DATABASE_VERSION = 4;
    private static final Account[] EMPTY_ACCOUNT_ARRAY;
    private static final String EXTRAS_ACCOUNTS_ID = "accounts_id";
    private static final String EXTRAS_ID = "_id";
    private static final String EXTRAS_KEY = "key";
    private static final String EXTRAS_VALUE = "value";
    private static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    private static final String GRANTS_ACCOUNTS_ID = "accounts_id";
    private static final String GRANTS_AUTH_TOKEN_TYPE = "auth_token_type";
    private static final String GRANTS_GRANTEE_UID = "uid";
    private static final int MESSAGE_TIMED_OUT = 3;
    private static final String META_KEY = "key";
    private static final String META_VALUE = "value";
    private static final String NO_BROADCAST_FLAG = "nobroadcast";
    private static final String TABLE_ACCOUNTS = "accounts";
    private static final String TABLE_AUTHTOKENS = "authtokens";
    private static final String TABLE_EXTRAS = "extras";
    private static final String TABLE_GRANTS = "grants";
    private static final String TABLE_META = "meta";
    private static final String TAG = "AccountManagerService";
    private static final int TIMEOUT_DELAY_MS = 60000;
    private static final boolean isDebuggableMonkeyBuild;
    private static AtomicReference<AccountManagerService> sThis;
    private final AccountAuthenticatorCache mAuthenticatorCache;
    private final Context mContext;
    private final HashMap<Pair<Pair<Account, String>, Integer>, Integer> mCredentialsPermissionNotificationIds;
    private final MessageHandler mMessageHandler;
    private HandlerThread mMessageThread;
    private final AtomicInteger mNotificationIds;
    private final DatabaseHelper mOpenHelper;
    private final LinkedHashMap<String, Session> mSessions = new LinkedHashMap();
    private final HashMap<Account, Integer> mSigninRequiredNotificationIds;
    private final SimWatcher mSimWatcher;

    static {
        ACCOUNT_NAME_TYPE_PROJECTION = new String[]{"_id", ACCOUNTS_NAME, "type"};
        ACCOUNT_TYPE_COUNT_PROJECTION = new String[]{"type", ACCOUNTS_TYPE_COUNT};
        sThis = new AtomicReference();
        isDebuggableMonkeyBuild = SystemProperties.getBoolean("ro.monkey", false);
        EMPTY_ACCOUNT_ARRAY = new Account[0];
        ACCOUNTS_CHANGED_INTENT = new Intent("android.accounts.LOGIN_ACCOUNTS_CHANGED");
        ACCOUNTS_CHANGED_INTENT.setFlags(0x10000000);
    }

    public AccountManagerService(Context context) {
        this.mNotificationIds = new AtomicInteger(1);
        this.mCredentialsPermissionNotificationIds = new HashMap();
        this.mSigninRequiredNotificationIds = new HashMap();
        this.mContext = context;
        this.mOpenHelper = new DatabaseHelper(this.mContext);
        this.mMessageThread = new HandlerThread(TAG);
        this.mMessageThread.start();
        this.mMessageHandler = new MessageHandler(this.mMessageThread.getLooper());
        this.mAuthenticatorCache = new AccountAuthenticatorCache(this.mContext);
        this.mAuthenticatorCache.setListener(this, null);
        this.mSimWatcher = new SimWatcher(this.mContext);
        sThis.set(this);
        this.validateAccounts();
    }

    static /* synthetic */ Integer access$700(AccountManagerService accountManagerService, Account account) {
        return accountManagerService.getSigninRequiredNotificationId(account);
    }

    static /* synthetic */ void access$800(AccountManagerService accountManagerService, int n) {
        accountManagerService.cancelNotification(n);
    }

    private void cancelNotification(int n) {
        long l = AccountManagerService.clearCallingIdentity();
        try {
            ((NotificationManager)this.mContext.getSystemService("notification")).cancel(n);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    private void checkAuthenticateAccountsPermission(Account account) {
        this.checkBinderPermission("android.permission.AUTHENTICATE_ACCOUNTS");
        this.checkCallingUidAgainstAuthenticator(account);
    }

    private void checkBinderPermission(String ... stringArray) {
        int n = Binder.getCallingUid();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            if (this.mContext.checkCallingOrSelfPermission(string2) != 0) continue;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "caller uid " + n + " has " + string2);
            }
            return;
        }
        String string3 = "caller uid " + n + " lacks any of " + TextUtils.join((CharSequence)",", stringArray);
        Log.w(TAG, string3);
        throw new SecurityException(string3);
    }

    private void checkCallingUidAgainstAuthenticator(Account account) {
        int n = Binder.getCallingUid();
        if (account == null || !this.hasAuthenticatorUid(account.type, n)) {
            String string2 = "caller uid " + n + " is different than the authenticator's uid";
            Log.w(TAG, string2);
            throw new SecurityException(string2);
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "caller uid " + n + " is the same as the authenticator's uid");
        }
    }

    private void checkManageAccountsOrUseCredentialsPermissions() {
        this.checkBinderPermission("android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS");
    }

    private void checkManageAccountsPermission() {
        this.checkBinderPermission("android.permission.MANAGE_ACCOUNTS");
    }

    private void checkReadAccountsPermission() {
        this.checkBinderPermission("android.permission.GET_ACCOUNTS");
    }

    private void createNoCredentialsPermissionNotification(Account account, Intent intent) {
        int n = intent.getIntExtra(GRANTS_GRANTEE_UID, -1);
        String string2 = intent.getStringExtra("authTokenType");
        intent.getStringExtra("authTokenLabel");
        Notification notification = new Notification(17301642, null, 0L);
        Context context = this.mContext;
        Object[] objectArray = new Object[]{account.name};
        String string3 = context.getString(17040224, objectArray);
        int n2 = string3.indexOf(10);
        String string4 = string3.substring(0, n2);
        String string5 = string3.substring(n2 + 1);
        notification.setLatestEventInfo(this.mContext, string4, string5, PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000));
        ((NotificationManager)this.mContext.getSystemService("notification")).notify(this.getCredentialPermissionNotificationId(account, string2, n), notification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNotification(Account account, CharSequence charSequence, Intent intent) {
        long l = AccountManagerService.clearCallingIdentity();
        try {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "doNotification: " + charSequence + " intent:" + intent);
            }
            if (intent.getComponent() != null && GrantCredentialsPermissionActivity.class.getName().equals(intent.getComponent().getClassName())) {
                this.createNoCredentialsPermissionNotification(account, intent);
                return;
            }
            Integer n = this.getSigninRequiredNotificationId(account);
            intent.addCategory(String.valueOf(n));
            Notification notification = new Notification(17301642, null, 0L);
            String string2 = ((Object)this.mContext.getText(17039624)).toString();
            Context context = this.mContext;
            Object[] objectArray = new Object[]{account.name};
            notification.setLatestEventInfo(context, String.format(string2, objectArray), charSequence, PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000));
            ((NotificationManager)this.mContext.getSystemService("notification")).notify(n, notification);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getAccountId(SQLiteDatabase sQLiteDatabase, Account account) {
        String[] stringArray = new String[]{"_id"};
        String[] stringArray2 = new String[]{account.name, account.type};
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, "name=? AND type=?", stringArray2, null, null, null);
        try {
            long l;
            long l2 = cursor.moveToNext() ? (l = cursor.getLong(0)) : -1L;
            return l2;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getCredentialPermissionNotificationId(Account account, String string2, int n) {
        HashMap<Pair<Pair<Account, String>, Integer>, Integer> hashMap = this.mCredentialsPermissionNotificationIds;
        synchronized (hashMap) {
            Pair<Pair<Account, String>, Integer> pair = new Pair<Pair<Account, String>, Integer>(new Pair<Account, String>(account, string2), n);
            Integer n2 = this.mCredentialsPermissionNotificationIds.get(pair);
            if (n2 == null) {
                n2 = this.mNotificationIds.incrementAndGet();
                this.mCredentialsPermissionNotificationIds.put(pair, n2);
            }
            return n2;
        }
    }

    private static String getDatabaseName() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return Environment.getSystemSecureDirectory().getPath() + File.separator + DATABASE_NAME;
        }
        return DATABASE_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getExtrasId(SQLiteDatabase sQLiteDatabase, long l, String string2) {
        Cursor cursor = sQLiteDatabase.query(TABLE_EXTRAS, new String[]{"_id"}, "accounts_id=" + l + " AND " + "key" + "=?", new String[]{string2}, null, null, null);
        try {
            long l2;
            long l3 = cursor.moveToNext() ? (l2 = cursor.getLong(0)) : -1L;
            return l3;
        }
        finally {
            cursor.close();
        }
    }

    private String getMetaValue(String string2) {
        Cursor cursor = this.mOpenHelper.getReadableDatabase().query(TABLE_META, new String[]{"value"}, "key=?", new String[]{string2}, null, null, null);
        try {
            if (cursor.moveToNext()) {
                String string3 = cursor.getString(0);
                return string3;
            }
            return null;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getSigninRequiredNotificationId(Account account) {
        HashMap<Account, Integer> hashMap = this.mSigninRequiredNotificationIds;
        synchronized (hashMap) {
            Integer n = this.mSigninRequiredNotificationIds.get(account);
            if (n == null) {
                n = this.mNotificationIds.incrementAndGet();
                this.mSigninRequiredNotificationIds.put(account, n);
            }
            return n;
        }
    }

    public static AccountManagerService getSingleton() {
        return sThis.get();
    }

    private boolean hasAuthenticatorUid(String string2, int n) {
        for (RegisteredServicesCache.ServiceInfo serviceInfo : this.mAuthenticatorCache.getAllServices()) {
            if (!((AuthenticatorDescription)serviceInfo.type).type.equals(string2)) continue;
            return serviceInfo.uid == n || this.mContext.getPackageManager().checkSignatures(serviceInfo.uid, n) == 0;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasExplicitlyGrantedPermission(Account account, String string2) {
        if (Binder.getCallingUid() == 1000) {
            return true;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{String.valueOf(Binder.getCallingUid()), string2, account.name, account.type};
        if (DatabaseUtils.longForQuery(sQLiteDatabase, COUNT_OF_MATCHING_GRANTS, stringArray) != 0L) {
            return true;
        }
        boolean bl = false;
        if (bl) return bl;
        if (!isDebuggableMonkeyBuild) return bl;
        Log.d(TAG, "no credentials permission for usage of " + account + ", " + string2 + " by uid " + Binder.getCallingUid() + " but ignoring since this is a monkey build");
        return true;
    }

    private boolean inSystemImage(int n) {
        for (String string2 : this.mContext.getPackageManager().getPackagesForUid(n)) {
            try {
                int n2 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.flags;
                if ((n2 & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertAccountIntoDatabase(Account account, String string2, Bundle bundle) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        if (account == null) {
            return false;
        }
        try {
            boolean bl;
            boolean bl2 = account.type.equals(GOOGLE_ACCOUNT_TYPE);
            boolean bl3 = false;
            if (bl2) {
                bl3 = bundle.getBoolean(NO_BROADCAST_FLAG, false);
                bundle.remove(NO_BROADCAST_FLAG);
            }
            String[] stringArray = new String[]{account.name, account.type};
            if (DatabaseUtils.longForQuery(sQLiteDatabase, "select count(*) from accounts WHERE name=? AND type=?", stringArray) > 0L) {
                bl = false;
                return bl;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put(ACCOUNTS_NAME, account.name);
            contentValues.put("type", account.type);
            contentValues.put(ACCOUNTS_PASSWORD, string2);
            long l = sQLiteDatabase.insert(TABLE_ACCOUNTS, ACCOUNTS_NAME, contentValues);
            if (l < 0L) {
                bl = false;
                return bl;
            }
            if (bundle != null) {
                for (String string3 : bundle.keySet()) {
                    if (this.insertExtra(sQLiteDatabase, l, string3, bundle.getString(string3)) >= 0L) continue;
                    bl = false;
                    return bl;
                }
            } else {
                sQLiteDatabase.setTransactionSuccessful();
                if (!bl3) {
                    this.sendAccountsChangedBroadcast();
                }
                bl = true;
            }
            return bl;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private long insertExtra(SQLiteDatabase sQLiteDatabase, long l, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", string2);
        contentValues.put("accounts_id", l);
        contentValues.put("value", string3);
        return sQLiteDatabase.insert(TABLE_EXTRAS, "key", contentValues);
    }

    private void invalidateAuthToken(SQLiteDatabase sQLiteDatabase, String string2, String string3) {
        if (string3 == null || string2 == null) {
            return;
        }
        Cursor cursor = sQLiteDatabase.rawQuery("SELECT authtokens._id, accounts.name, authtokens.type FROM accounts JOIN authtokens ON accounts._id = accounts_id WHERE authtoken = ? AND accounts.type = ?", new String[]{string3, string2});
        try {
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                cursor.getString(1);
                cursor.getString(2);
                sQLiteDatabase.delete(TABLE_AUTHTOKENS, "_id=" + l, null);
            }
        }
        finally {
            cursor.close();
        }
    }

    private Intent newGrantCredentialsPermissionIntent(Account account, int n, AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3) {
        Intent intent = new Intent(this.mContext, GrantCredentialsPermissionActivity.class);
        intent.addCategory(String.valueOf(this.getCredentialPermissionNotificationId(account, string2, n)));
        intent.putExtra("account", account);
        intent.putExtra("authTokenType", string2);
        intent.putExtra("response", accountAuthenticatorResponse);
        intent.putExtra(GRANTS_GRANTEE_UID, n);
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onResult(IAccountManagerResponse iAccountManagerResponse, Bundle bundle) {
        try {
            iAccountManagerResponse.onResult(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            if (!Log.isLoggable(TAG, 2)) return;
            Log.v(TAG, "failure while notifying response", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean permissionIsGranted(Account account, String string2, int n) {
        boolean bl = this.inSystemImage(n);
        boolean bl2 = account != null && this.hasAuthenticatorUid(account.type, n);
        boolean bl3 = account != null && this.hasExplicitlyGrantedPermission(account, string2);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "checkGrantsOrCallingUidAgainstAuthenticator: caller uid " + n + ", account " + account + ": is authenticator? " + bl2 + ", has explicit permission? " + bl3);
        }
        return bl2 || bl3 || bl;
    }

    private String readPasswordFromDatabase(Account account) {
        if (account == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{ACCOUNTS_PASSWORD};
        String[] stringArray2 = new String[]{account.name, account.type};
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, "name=? AND type=?", stringArray2, null, null, null);
        try {
            if (cursor.moveToNext()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
        finally {
            cursor.close();
        }
    }

    private String readUserDataFromDatabase(Account account, String string2) {
        if (account == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{"value"};
        String[] stringArray2 = new String[]{account.name, account.type, string2};
        Cursor cursor = sQLiteDatabase.query(TABLE_EXTRAS, stringArray, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND key=?", stringArray2, null, null, null);
        try {
            if (cursor.moveToNext()) {
                String string3 = cursor.getString(0);
                return string3;
            }
            return null;
        }
        finally {
            cursor.close();
        }
    }

    private void removeAccount(Account account) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        String[] stringArray = new String[]{account.name, account.type};
        sQLiteDatabase.delete(TABLE_ACCOUNTS, "name=? AND type=?", stringArray);
        this.sendAccountsChangedBroadcast();
    }

    private boolean saveAuthTokenToDatabase(Account account, String string2, String string3) {
        long l;
        SQLiteDatabase sQLiteDatabase;
        block6: {
            if (account == null || string2 == null) {
                return false;
            }
            this.cancelNotification(this.getSigninRequiredNotificationId(account));
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            l = this.getAccountId(sQLiteDatabase, account);
            if (l >= 0L) break block6;
            sQLiteDatabase.endTransaction();
            return false;
        }
        try {
            sQLiteDatabase.delete(TABLE_AUTHTOKENS, "accounts_id=" + l + " AND " + "type" + "=?", new String[]{string2});
            ContentValues contentValues = new ContentValues();
            contentValues.put("accounts_id", l);
            contentValues.put("type", string2);
            contentValues.put(AUTHTOKENS_AUTHTOKEN, string3);
            if (sQLiteDatabase.insert(TABLE_AUTHTOKENS, AUTHTOKENS_AUTHTOKEN, contentValues) >= 0L) {
                sQLiteDatabase.setTransactionSuccessful();
                return true;
            }
            return false;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private static boolean scanArgs(String[] stringArray, String string2) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void sendAccountsChangedBroadcast() {
        this.mContext.sendBroadcast(ACCOUNTS_CHANGED_INTENT);
    }

    private void setMetaValue(String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", string2);
        contentValues.put("value", string3);
        this.mOpenHelper.getWritableDatabase().replace(TABLE_META, "key", contentValues);
    }

    private void setPasswordInDB(Account account, String string2) {
        SQLiteDatabase sQLiteDatabase;
        block5: {
            if (account == null) {
                return;
            }
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            ContentValues contentValues = new ContentValues();
            contentValues.put(ACCOUNTS_PASSWORD, string2);
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l < 0L) break block5;
            String[] stringArray = new String[]{String.valueOf(l)};
            sQLiteDatabase.update(TABLE_ACCOUNTS, contentValues, "_id=?", stringArray);
            sQLiteDatabase.delete(TABLE_AUTHTOKENS, "accounts_id=?", stringArray);
            sQLiteDatabase.setTransactionSuccessful();
        }
        this.sendAccountsChangedBroadcast();
        return;
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private void validateAccounts() {
        boolean bl = false;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, new String[]{"_id", "type", ACCOUNTS_NAME}, null, null, null, null, null);
        block2: while (true) {
            try {
                while (cursor.moveToNext()) {
                    long l = cursor.getLong(0);
                    String string2 = cursor.getString(1);
                    String string3 = cursor.getString(2);
                    if (this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(string2)) != null) continue;
                    Log.d(TAG, "deleting account " + string3 + " because type " + string2 + " no longer has a registered authenticator");
                    sQLiteDatabase.delete(TABLE_ACCOUNTS, "_id=" + l, null);
                    bl = true;
                    continue block2;
                }
                break;
            }
            catch (Throwable throwable) {
                cursor.close();
                if (bl) {
                    this.sendAccountsChangedBroadcast();
                }
                throw throwable;
            }
        }
        cursor.close();
        if (bl) {
            this.sendAccountsChangedBroadcast();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeUserdataIntoDatabase(Account account, String string2, String string3) {
        SQLiteDatabase sQLiteDatabase;
        block8: {
            if (account == null || string2 == null) {
                return;
            }
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            try {
                long l = this.getAccountId(sQLiteDatabase, account);
                if (l < 0L) break block8;
                long l2 = this.getExtrasId(sQLiteDatabase, l, string2);
                if (l2 < 0L) {
                    if (this.insertExtra(sQLiteDatabase, l, string2, string3) < 0L) break block8;
                } else {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("value", string3);
                    int n = sQLiteDatabase.update(TABLE_EXTRAS, contentValues, "_id=" + l2, null);
                    if (1 != n) break block8;
                }
                sQLiteDatabase.setTransactionSuccessful();
                {
                }
            }
            catch (Throwable throwable) {
                sQLiteDatabase.endTransaction();
                throw throwable;
            }
        }
        sQLiteDatabase.endTransaction();
    }

    @Override
    public boolean addAccount(Account account, String string2, Bundle bundle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            boolean bl = this.insertAccountIntoDatabase(account, string2, bundle);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void addAcount(IAccountManagerResponse iAccountManagerResponse, final String string2, final String string3, final String[] stringArray, boolean bl, final Bundle bundle) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new Session(iAccountManagerResponse, string2, bl, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, string3, stringArray, bundle);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected String toDebugString(long l) {
                    String string22;
                    StringBuilder stringBuilder = new StringBuilder().append(super.toDebugString(l)).append(", addAccount").append(", accountType ").append(string2).append(", requiredFeatures ");
                    if (stringArray != null) {
                        string22 = TextUtils.join((CharSequence)",", stringArray);
                        return stringBuilder.append(string22).toString();
                    }
                    string22 = null;
                    return stringBuilder.append(string22).toString();
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            this.setPasswordInDB(account, null);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void confirmCredentials(IAccountManagerResponse iAccountManagerResponse, final Account account, final Bundle bundle, boolean bl) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new Session(iAccountManagerResponse, account.type, bl, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.confirmCredentials(this, account, bundle);
                }

                @Override
                protected String toDebugString(long l) {
                    return super.toDebugString(l) + ", confirmCredentials" + ", " + account;
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        boolean bl = AccountManagerService.scanArgs(stringArray, "--checkin") || AccountManagerService.scanArgs(stringArray, "-c");
        if (!bl) {
            Account[] accountArray = this.getAccountsByType(null);
            printWriter.println("Accounts: " + accountArray.length);
            for (Account account : accountArray) {
                printWriter.println("  " + account);
            }
            printWriter.println();
            LinkedHashMap<String, Session> linkedHashMap = this.mSessions;
            synchronized (linkedHashMap) {
                long l = SystemClock.elapsedRealtime();
                printWriter.println("Active Sessions: " + this.mSessions.size());
                for (Session session : this.mSessions.values()) {
                    printWriter.println("  " + session.toDebugString(l));
                }
            }
            printWriter.println();
            this.mAuthenticatorCache.dump(fileDescriptor, printWriter, stringArray);
            return;
        } else {
            Cursor cursor = this.mOpenHelper.getReadableDatabase().query(TABLE_ACCOUNTS, ACCOUNT_TYPE_COUNT_PROJECTION, null, null, "type", null, null);
            try {
                while (cursor.moveToNext()) {
                    printWriter.println(cursor.getString(0) + "," + cursor.getString(1));
                }
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            if (cursor == null) return;
            cursor.close();
            return;
        }
    }

    @Override
    public void editProperties(IAccountManagerResponse iAccountManagerResponse, final String string2, boolean bl) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new Session(iAccountManagerResponse, string2, bl, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.editProperties(this, this.mAccountType);
                }

                @Override
                protected String toDebugString(long l) {
                    return super.toDebugString(l) + ", editProperties" + ", accountType " + string2;
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    String getAccountLabel(String string2) {
        RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo = this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(string2));
        if (serviceInfo == null) {
            throw new IllegalArgumentException("unknown account type: " + string2);
        }
        try {
            Context context = this.mContext.createPackageContext(((AuthenticatorDescription)serviceInfo.type).packageName, 0);
            return context.getString(((AuthenticatorDescription)serviceInfo.type).labelId);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException("unknown account type: " + string2);
        }
    }

    @Override
    public Account[] getAccounts(String string2) {
        this.checkReadAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            Account[] accountArray = this.getAccountsByType(string2);
            return accountArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getAccountsByFeatures(IAccountManagerResponse var1_1, String var2_2, String[] var3_3) {
        block12: {
            if (var1_1 == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (var2_2 == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.checkReadAccountsPermission();
            if (var3_3 == null || var2_2 != null) break block12;
            if (var1_1 == null) ** GOTO lbl10
            var1_1.onError(7, "type is null");
lbl10:
            // 2 sources

            return;
        }
        var4_4 = AccountManagerService.clearCallingIdentity();
        if (var3_3 == null) ** GOTO lbl16
        try {
            block13: {
                if (var3_3.length != 0) break block13;
lbl16:
                // 2 sources

                var7_5 = this.getAccountsByType(var2_2);
                var8_6 = new Bundle();
                var8_6.putParcelableArray("accounts", var7_5);
                this.onResult(var1_1, var8_6);
lbl20:
                // 2 sources

                return;
            }
            new GetAccountsByTypeAndFeatureSession(var1_1, var2_2, var3_3).bind();
            ** continue;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(var4_4);
        }
        catch (RemoteException var9_8) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account[] getAccountsByType(String string2) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String string3 = string2 == null ? null : "type=?";
        String[] stringArray = string2 == null ? null : new String[]{string2};
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, ACCOUNT_NAME_TYPE_PROJECTION, string3, stringArray, null, null, null);
        int n = 0;
        try {
            Account[] accountArray = new Account[cursor.getCount()];
            while (cursor.moveToNext()) {
                accountArray[n] = new Account(cursor.getString(1), cursor.getString(2));
                ++n;
            }
            return accountArray;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getAuthToken(IAccountManagerResponse var1_1, final Account var2_2, final String var3_3, final boolean var4_4, boolean var5_5, final Bundle var6_6) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (var3_3 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkBinderPermission(new String[]{"android.permission.USE_CREDENTIALS"});
        var7_7 = Binder.getCallingUid();
        var8_8 = this.permissionIsGranted(var2_2, var3_3, var7_7);
        var9_9 = AccountManagerService.clearCallingIdentity();
        if (!var8_8) ** GOTO lbl22
        try {
            var12_10 = this.readAuthTokenFromDatabase(var2_2, var3_3);
            if (var12_10 != null) {
                var13_11 = new Bundle();
                var13_11.putString("authtoken", var12_10);
                var13_11.putString("authAccount", var2_2.name);
                var13_11.putString("accountType", var2_2.type);
                this.onResult(var1_1, var13_11);
lbl20:
                // 2 sources

                return;
            }
lbl22:
            // 3 sources

            new Session(var1_1, var2_2.type, var5_5, false){

                @Override
                public void onResult(Bundle bundle) {
                    if (bundle != null) {
                        Intent intent;
                        if (bundle.containsKey("authTokenLabelKey")) {
                            Intent intent2 = AccountManagerService.this.newGrantCredentialsPermissionIntent(var2_2, var7_7, new AccountAuthenticatorResponse((IAccountAuthenticatorResponse)this), var3_3, bundle.getString("authTokenLabelKey"));
                            Bundle bundle2 = new Bundle();
                            bundle2.putParcelable("intent", intent2);
                            this.onResult(bundle2);
                            return;
                        }
                        String string2 = bundle.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                        if (string2 != null) {
                            String string3 = bundle.getString("authAccount");
                            String string4 = bundle.getString("accountType");
                            if (TextUtils.isEmpty(string4) || TextUtils.isEmpty(string3)) {
                                this.onError(5, "the type and name should not be empty");
                                return;
                            }
                            AccountManagerService.this.saveAuthTokenToDatabase(new Account(string3, string4), var3_3, string2);
                        }
                        if ((intent = (Intent)bundle.getParcelable("intent")) != null && var4_4) {
                            AccountManagerService.this.doNotification(var2_2, bundle.getString("authFailedMessage"), intent);
                        }
                    }
                    super.onResult(bundle);
                }

                @Override
                public void run() throws RemoteException {
                    if (!var8_8) {
                        this.mAuthenticator.getAuthTokenLabel(this, var3_3);
                        return;
                    }
                    this.mAuthenticator.getAuthToken(this, var2_2, var3_3, var6_6);
                }

                @Override
                protected String toDebugString(long l) {
                    if (var6_6 != null) {
                        var6_6.keySet();
                    }
                    return super.toDebugString(l) + ", getAuthToken" + ", " + var2_2 + ", authTokenType " + var3_3 + ", loginOptions " + var6_6 + ", notifyOnAuthFailure " + var4_4;
                }
            }.bind();
            ** continue;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(var9_9);
        }
    }

    void getAuthTokenLabel(IAccountManagerResponse iAccountManagerResponse, final Account account, final String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkBinderPermission("android.permission.USE_CREDENTIALS");
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new Session(iAccountManagerResponse, account.type, false, false){

                @Override
                public void onResult(Bundle bundle) {
                    if (bundle != null) {
                        String string22 = bundle.getString("authTokenLabelKey");
                        Bundle bundle2 = new Bundle();
                        bundle2.putString("authTokenLabelKey", string22);
                        super.onResult(bundle2);
                        return;
                    }
                    super.onResult(bundle);
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.getAuthTokenLabel(this, string2);
                }

                @Override
                protected String toDebugString(long l) {
                    return super.toDebugString(l) + ", getAuthTokenLabel" + ", " + account + ", authTokenType " + string2;
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public AuthenticatorDescription[] getAuthenticatorTypes() {
        long l = AccountManagerService.clearCallingIdentity();
        Collection collection = this.mAuthenticatorCache.getAllServices();
        AuthenticatorDescription[] authenticatorDescriptionArray = new AuthenticatorDescription[collection.size()];
        int n = 0;
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                authenticatorDescriptionArray[n] = (AuthenticatorDescription)iterator.next().type;
                ++n;
            }
        }
        catch (Throwable throwable) {
            AccountManagerService.restoreCallingIdentity(l);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(l);
        return authenticatorDescriptionArray;
    }

    @Override
    public String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string2 = this.readPasswordFromDatabase(account);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public String getUserData(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string3 = this.readUserDataFromDatabase(account, string2);
            return string3;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public void grantAppPermission(Account account, String string2, int n) {
        SQLiteDatabase sQLiteDatabase;
        block5: {
            if (account == null || string2 == null) {
                Log.e(TAG, "grantAppPermission: called with invalid arguments", new Exception());
                return;
            }
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l < 0L) break block5;
            ContentValues contentValues = new ContentValues();
            contentValues.put("accounts_id", l);
            contentValues.put(GRANTS_AUTH_TOKEN_TYPE, string2);
            contentValues.put(GRANTS_GRANTEE_UID, n);
            sQLiteDatabase.insert(TABLE_GRANTS, "accounts_id", contentValues);
            sQLiteDatabase.setTransactionSuccessful();
        }
        this.cancelNotification(this.getCredentialPermissionNotificationId(account, string2, n));
        return;
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public void hasFeatures(IAccountManagerResponse iAccountManagerResponse, Account account, String[] stringArray) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("features is null");
        }
        this.checkReadAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new TestFeaturesSession(iAccountManagerResponse, account, stringArray).bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void invalidateAuthToken(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("authToken is null");
        }
        this.checkManageAccountsOrUseCredentialsPermissions();
        long l = AccountManagerService.clearCallingIdentity();
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            this.invalidateAuthToken(sQLiteDatabase, string2, string3);
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            sQLiteDatabase.endTransaction();
            throw throwable;
        }
        try {
            sQLiteDatabase.endTransaction();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public IBinder onBind(Intent intent) {
        return this.asBinder();
    }

    @Override
    public void onServiceChanged(AuthenticatorDescription authenticatorDescription, boolean bl) {
        boolean bl2 = false;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        String[] stringArray = new String[]{"_id", "type", ACCOUNTS_NAME};
        String[] stringArray2 = new String[]{authenticatorDescription.type};
        Cursor cursor = sQLiteDatabase.query(TABLE_ACCOUNTS, stringArray, "type=?", stringArray2, null, null, null);
        while (true) {
            try {
                if (!cursor.moveToNext()) break;
                long l = cursor.getLong(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Log.d(TAG, "deleting account " + string3 + " because type " + string2 + " no longer has a registered authenticator");
                sQLiteDatabase.delete(TABLE_ACCOUNTS, "_id=" + l, null);
                bl2 = true;
            }
            catch (Throwable throwable) {
                cursor.close();
                if (bl2) {
                    this.sendAccountsChangedBroadcast();
                }
                throw throwable;
            }
        }
        cursor.close();
        if (bl2) {
            this.sendAccountsChangedBroadcast();
        }
    }

    @Override
    public String peekAuthToken(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            String string3 = this.readAuthTokenFromDatabase(account, string2);
            return string3;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public String readAuthTokenFromDatabase(Account account, String string2) {
        if (account == null || string2 == null) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        String[] stringArray = new String[]{AUTHTOKENS_AUTHTOKEN};
        String[] stringArray2 = new String[]{account.name, account.type, string2};
        Cursor cursor = sQLiteDatabase.query(TABLE_AUTHTOKENS, stringArray, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND type=?", stringArray2, null, null, null);
        try {
            if (cursor.moveToNext()) {
                String string3 = cursor.getString(0);
                return string3;
            }
            return null;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void removeAccount(IAccountManagerResponse iAccountManagerResponse, Account account) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new RemoveAccountSession(iAccountManagerResponse, account).bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public void revokeAppPermission(Account account, String string2, int n) {
        SQLiteDatabase sQLiteDatabase;
        block5: {
            if (account == null || string2 == null) {
                Log.e(TAG, "revokeAppPermission: called with invalid arguments", new Exception());
                return;
            }
            sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            long l = this.getAccountId(sQLiteDatabase, account);
            if (l < 0L) break block5;
            String[] stringArray = new String[]{String.valueOf(l), string2, String.valueOf(n)};
            sQLiteDatabase.delete(TABLE_GRANTS, "accounts_id=? AND auth_token_type=? AND uid=?", stringArray);
            sQLiteDatabase.setTransactionSuccessful();
        }
        this.cancelNotification(this.getCredentialPermissionNotificationId(account, string2, n));
        return;
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public void setAuthToken(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            this.saveAuthTokenToDatabase(account, string2, string3);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setPassword(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        try {
            this.setPasswordInDB(account, string2);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setUserData(Account account, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long l = AccountManagerService.clearCallingIdentity();
        if (account == null) {
            return;
        }
        if (account.type.equals(GOOGLE_ACCOUNT_TYPE) && string2.equals("broadcast")) {
            this.sendAccountsChangedBroadcast();
            return;
        }
        try {
            this.writeUserdataIntoDatabase(account, string2, string3);
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void updateCredentials(IAccountManagerResponse iAccountManagerResponse, final Account account, final String string2, boolean bl, final Bundle bundle) {
        if (iAccountManagerResponse == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkManageAccountsPermission();
        long l = AccountManagerService.clearCallingIdentity();
        try {
            new Session(iAccountManagerResponse, account.type, bl, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.updateCredentials(this, account, string2, bundle);
                }

                @Override
                protected String toDebugString(long l) {
                    if (bundle != null) {
                        bundle.keySet();
                    }
                    return super.toDebugString(l) + ", updateCredentials" + ", " + account + ", authTokenType " + string2 + ", loginOptions " + bundle;
                }
            }.bind();
            return;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(l);
        }
    }

    public class AuthTokenKey {
        public final Account mAccount;
        public final String mAuthTokenType;
        private final int mHashCode;

        public AuthTokenKey(Account account, String string2) {
            this.mAccount = account;
            this.mAuthTokenType = string2;
            this.mHashCode = this.computeHashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int computeHashCode() {
            int n;
            int cfr_ignored_0 = 17 * 31;
            int n2 = 31 * (527 + this.mAccount.hashCode());
            if (this.mAuthTokenType == null) {
                n = 0;
                return n2 + n;
            }
            n = this.mAuthTokenType.hashCode();
            return n2 + n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AuthTokenKey)) {
                return false;
            }
            AuthTokenKey authTokenKey = (AuthTokenKey)object;
            if (!this.mAccount.equals(authTokenKey.mAccount)) {
                return false;
            }
            if (this.mAuthTokenType == null) {
                return authTokenKey.mAuthTokenType == null;
            }
            return this.mAuthTokenType.equals(authTokenKey.mAuthTokenType);
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, AccountManagerService.getDatabaseName(), null, 4);
        }

        private void createAccountsDeletionTrigger(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL(" CREATE TRIGGER accountsDelete DELETE ON accounts BEGIN   DELETE FROM authtokens     WHERE accounts_id=OLD._id ;   DELETE FROM extras     WHERE accounts_id=OLD._id ;   DELETE FROM grants     WHERE accounts_id=OLD._id ; END");
        }

        private void createGrantsTable(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE grants (  accounts_id INTEGER NOT NULL, auth_token_type STRING NOT NULL,  uid INTEGER NOT NULL,  UNIQUE (accounts_id,auth_token_type,uid))");
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE accounts ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, type TEXT NOT NULL, password TEXT, UNIQUE(name,type))");
            sQLiteDatabase.execSQL("CREATE TABLE authtokens (  _id INTEGER PRIMARY KEY AUTOINCREMENT,  accounts_id INTEGER NOT NULL, type TEXT NOT NULL,  authtoken TEXT,  UNIQUE (accounts_id,type))");
            this.createGrantsTable(sQLiteDatabase);
            sQLiteDatabase.execSQL("CREATE TABLE extras ( _id INTEGER PRIMARY KEY AUTOINCREMENT, accounts_id INTEGER, key TEXT NOT NULL, value TEXT, UNIQUE(accounts_id,key))");
            sQLiteDatabase.execSQL("CREATE TABLE meta ( key TEXT PRIMARY KEY NOT NULL, value TEXT)");
            this.createAccountsDeletionTrigger(sQLiteDatabase);
        }

        @Override
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "opened database accounts.db");
            }
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.e(AccountManagerService.TAG, "upgrade from version " + n + " to version " + n2);
            if (n == 1) {
                ++n;
            }
            if (n == 2) {
                this.createGrantsTable(sQLiteDatabase);
                sQLiteDatabase.execSQL("DROP TRIGGER accountsDelete");
                this.createAccountsDeletionTrigger(sQLiteDatabase);
                ++n;
            }
            if (n == 3) {
                sQLiteDatabase.execSQL("UPDATE accounts SET type = 'com.google' WHERE type == 'com.google.GAIA'");
                int cfr_ignored_0 = n + 1;
            }
        }
    }

    private class GetAccountsByTypeAndFeatureSession
    extends Session {
        private volatile Account[] mAccountsOfType;
        private volatile ArrayList<Account> mAccountsWithFeatures;
        private volatile int mCurrentAccount;
        private final String[] mFeatures;

        public GetAccountsByTypeAndFeatureSession(IAccountManagerResponse iAccountManagerResponse, String string2, String[] stringArray) {
            super(iAccountManagerResponse, string2, false, true);
            this.mAccountsOfType = null;
            this.mAccountsWithFeatures = null;
            this.mCurrentAccount = 0;
            this.mFeatures = stringArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkAccount() {
            if (this.mCurrentAccount >= this.mAccountsOfType.length) {
                this.sendResult();
                return;
            }
            IAccountAuthenticator iAccountAuthenticator = this.mAuthenticator;
            if (iAccountAuthenticator == null) {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) return;
                Log.v(AccountManagerService.TAG, "checkAccount: aborting session since we are no longer connected to the authenticator, " + this.toDebugString());
                return;
            }
            try {
                iAccountAuthenticator.hasFeatures(this, this.mAccountsOfType[this.mCurrentAccount], this.mFeatures);
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        @Override
        public void onResult(Bundle bundle) {
            this.mNumResults = 1 + this.mNumResults;
            if (bundle == null) {
                this.onError(5, "null bundle");
                return;
            }
            if (bundle.getBoolean("booleanResult", false)) {
                this.mAccountsWithFeatures.add(this.mAccountsOfType[this.mCurrentAccount]);
            }
            this.mCurrentAccount = 1 + this.mCurrentAccount;
            this.checkAccount();
        }

        @Override
        public void run() throws RemoteException {
            this.mAccountsOfType = AccountManagerService.this.getAccountsByType(this.mAccountType);
            this.mAccountsWithFeatures = new ArrayList(this.mAccountsOfType.length);
            this.mCurrentAccount = 0;
            this.checkAccount();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sendResult() {
            IAccountManagerResponse iAccountManagerResponse = this.getResponseAndClose();
            if (iAccountManagerResponse == null) return;
            try {
                Parcelable[] parcelableArray = new Account[this.mAccountsWithFeatures.size()];
                for (int i = 0; i < parcelableArray.length; ++i) {
                    parcelableArray[i] = this.mAccountsWithFeatures.get(i);
                }
                Bundle bundle = new Bundle();
                bundle.putParcelableArray(AccountManagerService.TABLE_ACCOUNTS, parcelableArray);
                iAccountManagerResponse.onResult(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) return;
                Log.v(AccountManagerService.TAG, "failure while notifying response", remoteException);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected String toDebugString(long l) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append(super.toDebugString(l)).append(", getAccountsByTypeAndFeatures").append(", ");
            if (this.mFeatures != null) {
                string2 = TextUtils.join((CharSequence)",", this.mFeatures);
                return stringBuilder.append(string2).toString();
            }
            string2 = null;
            return stringBuilder.append(string2).toString();
        }
    }

    private class MessageHandler
    extends Handler {
        MessageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    throw new IllegalStateException("unhandled message: " + message.what);
                }
                case 3: 
            }
            ((Session)message.obj).onTimedOut();
        }
    }

    private class RemoveAccountSession
    extends Session {
        final Account mAccount;

        public RemoveAccountSession(IAccountManagerResponse iAccountManagerResponse, Account account) {
            super(iAccountManagerResponse, account.type, false, true);
            this.mAccount = account;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onResult(Bundle bundle) {
            if (bundle != null && bundle.containsKey("booleanResult") && !bundle.containsKey("intent")) {
                IAccountManagerResponse iAccountManagerResponse;
                boolean bl = bundle.getBoolean("booleanResult");
                if (bl) {
                    AccountManagerService.this.removeAccount(this.mAccount);
                }
                if ((iAccountManagerResponse = this.getResponseAndClose()) != null) {
                    Bundle bundle2 = new Bundle();
                    bundle2.putBoolean("booleanResult", bl);
                    try {
                        iAccountManagerResponse.onResult(bundle2);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            super.onResult(bundle);
        }

        @Override
        public void run() throws RemoteException {
            this.mAuthenticator.getAccountRemovalAllowed(this, this.mAccount);
        }

        @Override
        protected String toDebugString(long l) {
            return super.toDebugString(l) + ", removeAccount" + ", account " + this.mAccount;
        }
    }

    private abstract class Session
    extends IAccountAuthenticatorResponse.Stub
    implements IBinder.DeathRecipient,
    ServiceConnection {
        final String mAccountType;
        IAccountAuthenticator mAuthenticator = null;
        final long mCreationTime;
        final boolean mExpectActivityLaunch;
        private int mNumErrors = 0;
        private int mNumRequestContinued = 0;
        public int mNumResults = 0;
        IAccountManagerResponse mResponse;
        private final boolean mStripAuthTokenFromResult;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Session(IAccountManagerResponse iAccountManagerResponse, String string2, boolean bl, boolean bl2) {
            if (iAccountManagerResponse == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.mStripAuthTokenFromResult = bl2;
            this.mResponse = iAccountManagerResponse;
            this.mAccountType = string2;
            this.mExpectActivityLaunch = bl;
            this.mCreationTime = SystemClock.elapsedRealtime();
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                AccountManagerService.this.mSessions.put(this.toString(), this);
            }
            try {
                iAccountManagerResponse.asBinder().linkToDeath(this, 0);
                return;
            }
            catch (RemoteException remoteException) {
                this.mResponse = null;
                this.binderDied();
                return;
            }
        }

        private boolean bindToAuthenticator(String string2) {
            RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo = AccountManagerService.this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(string2));
            if (serviceInfo == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "there is no authenticator for " + string2 + ", bailing out");
                }
                return false;
            }
            Intent intent = new Intent();
            intent.setAction("android.accounts.AccountAuthenticator");
            intent.setComponent(serviceInfo.componentName);
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "performing bindService to " + serviceInfo.componentName);
            }
            if (!AccountManagerService.this.mContext.bindService(intent, this, 1)) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "bindService to " + serviceInfo.componentName + " failed");
                }
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void close() {
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            // MONITORENTER : linkedHashMap
            if (AccountManagerService.this.mSessions.remove(this.toString()) == null) {
                // MONITOREXIT : linkedHashMap
                return;
            }
            // MONITOREXIT : linkedHashMap
            if (this.mResponse != null) {
                this.mResponse.asBinder().unlinkToDeath(this, 0);
                this.mResponse = null;
            }
            this.cancelTimeout();
            this.unbind();
        }

        private void unbind() {
            if (this.mAuthenticator != null) {
                this.mAuthenticator = null;
                AccountManagerService.this.mContext.unbindService(this);
            }
        }

        void bind() {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "initiating bind to authenticator type " + this.mAccountType);
            }
            if (!this.bindToAuthenticator(this.mAccountType)) {
                Log.d(AccountManagerService.TAG, "bind attempt failed for " + this.toDebugString());
                this.onError(1, "bind failure");
            }
        }

        @Override
        public void binderDied() {
            this.mResponse = null;
            this.close();
        }

        public void cancelTimeout() {
            AccountManagerService.this.mMessageHandler.removeMessages(3, this);
        }

        IAccountManagerResponse getResponseAndClose() {
            if (this.mResponse == null) {
                return null;
            }
            IAccountManagerResponse iAccountManagerResponse = this.mResponse;
            this.close();
            return iAccountManagerResponse;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onError(int n, String string2) {
            IAccountManagerResponse iAccountManagerResponse;
            this.mNumErrors = 1 + this.mNumErrors;
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "Session.onError: " + n + ", " + string2);
            }
            if ((iAccountManagerResponse = this.getResponseAndClose()) != null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "Session.onError: responding");
                }
                try {
                    iAccountManagerResponse.onError(n, string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable(AccountManagerService.TAG, 2)) return;
                    Log.v(AccountManagerService.TAG, "Session.onError: caught RemoteException while responding", remoteException);
                    return;
                }
            } else {
                if (!Log.isLoggable(AccountManagerService.TAG, 2)) return;
                Log.v(AccountManagerService.TAG, "Session.onError: already closed");
                return;
            }
        }

        @Override
        public void onRequestContinued() {
            this.mNumRequestContinued = 1 + this.mNumRequestContinued;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onResult(Bundle var1_1) {
            block8: {
                block9: {
                    this.mNumResults = 1 + this.mNumResults;
                    if (var1_1 != null && !TextUtils.isEmpty(var1_1.getString("authtoken"))) {
                        var5_2 = var1_1.getString("authAccount");
                        var6_3 = var1_1.getString("accountType");
                        if (!TextUtils.isEmpty(var5_2) && !TextUtils.isEmpty(var6_3)) {
                            var7_4 = new Account(var5_2, var6_3);
                            AccountManagerService.access$800(AccountManagerService.this, AccountManagerService.access$700(AccountManagerService.this, var7_4));
                        }
                    }
                    if (!this.mExpectActivityLaunch || var1_1 == null || !var1_1.containsKey("intent")) break block9;
                    var2_5 = this.mResponse;
lbl10:
                    // 2 sources

                    while (true) {
                        if (var2_5 == null) ** GOTO lbl15
                        if (var1_1 != null) break block8;
                        var2_5.onError(5, "null bundle returned");
lbl15:
                        // 3 sources

                        return;
                        break;
                    }
                }
                var2_5 = this.getResponseAndClose();
                ** while (true)
            }
            try {
                if (this.mStripAuthTokenFromResult) {
                    var1_1.remove("authtoken");
                }
                var2_5.onResult(var1_1);
                return;
            }
            catch (RemoteException var3_6) {
                if (!Log.isLoggable("AccountManagerService", 2)) ** continue;
                Log.v("AccountManagerService", "failure while notifying response", var3_6);
                return;
            }
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            this.mAuthenticator = IAccountAuthenticator.Stub.asInterface(iBinder);
            try {
                this.run();
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            this.mAuthenticator = null;
            if (this.getResponseAndClose() != null) {
                this.onError(1, "disconnected");
            }
        }

        public void onTimedOut() {
            if (this.getResponseAndClose() != null) {
                this.onError(1, "timeout");
            }
        }

        public abstract void run() throws RemoteException;

        public void scheduleTimeout() {
            AccountManagerService.this.mMessageHandler.sendMessageDelayed(AccountManagerService.this.mMessageHandler.obtainMessage(3, this), 60000L);
        }

        protected String toDebugString() {
            return this.toDebugString(SystemClock.elapsedRealtime());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected String toDebugString(long l) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder().append("Session: expectLaunch ").append(this.mExpectActivityLaunch).append(", connected ");
            if (this.mAuthenticator != null) {
                bl = true;
                return stringBuilder.append(bl).append(", stats (").append(this.mNumResults).append("/").append(this.mNumRequestContinued).append("/").append(this.mNumErrors).append(")").append(", lifetime ").append((double)(l - this.mCreationTime) / 1000.0).toString();
            }
            bl = false;
            return stringBuilder.append(bl).append(", stats (").append(this.mNumResults).append("/").append(this.mNumRequestContinued).append("/").append(this.mNumErrors).append(")").append(", lifetime ").append((double)(l - this.mCreationTime) / 1000.0).toString();
        }
    }

    private class SimWatcher
    extends BroadcastReceiver {
        public SimWatcher(Context context) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SIM_STATE_CHANGED");
            intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
            context.registerReceiver(this, intentFilter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            SQLiteDatabase sQLiteDatabase;
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                Log.w(AccountManagerService.TAG, "failed to get TelephonyManager");
                return;
            }
            String string2 = telephonyManager.getSubscriberId();
            if (TextUtils.isEmpty(string2)) return;
            String string3 = AccountManagerService.this.getMetaValue("imsi");
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "current IMSI=" + string2 + "; stored IMSI=" + string3);
            }
            if (string2.equals(string3)) return;
            if (telephonyManager.getPhoneType() == 2) {
                boolean bl;
                IBinder iBinder = ServiceManager.checkService("phone");
                if (iBinder == null) {
                    Log.w(AccountManagerService.TAG, "call to checkService(TELEPHONY_SERVICE) failed");
                    return;
                }
                ITelephony iTelephony = ITelephony.Stub.asInterface(iBinder);
                if (iTelephony == null) {
                    Log.w(AccountManagerService.TAG, "failed to get ITelephony interface");
                    return;
                }
                try {
                    boolean bl2;
                    bl = bl2 = iTelephony.getCdmaNeedsProvisioning();
                }
                catch (RemoteException remoteException) {
                    Log.w(AccountManagerService.TAG, "exception while checking provisioning", remoteException);
                    bl = true;
                }
                if (bl) {
                    if (!Log.isLoggable(AccountManagerService.TAG, 2)) return;
                    Log.v(AccountManagerService.TAG, "current IMSI=" + string2 + " (needs provisioning); stored IMSI=" + string3);
                    return;
                }
            }
            if (!string2.equals(string3) && !TextUtils.isEmpty(string3)) {
                Log.w(AccountManagerService.TAG, "wiping all passwords and authtokens because IMSI changed (stored=" + string3 + ", current=" + string2 + ")");
                sQLiteDatabase = AccountManagerService.this.mOpenHelper.getWritableDatabase();
                sQLiteDatabase.beginTransaction();
                sQLiteDatabase.execSQL("DELETE from authtokens");
                sQLiteDatabase.execSQL("UPDATE accounts SET password = ''");
                AccountManagerService.this.sendAccountsChangedBroadcast();
                sQLiteDatabase.setTransactionSuccessful();
            }
            AccountManagerService.this.setMetaValue("imsi", string2);
            return;
            finally {
                sQLiteDatabase.endTransaction();
            }
        }
    }

    private class TestFeaturesSession
    extends Session {
        private final Account mAccount;
        private final String[] mFeatures;

        public TestFeaturesSession(IAccountManagerResponse iAccountManagerResponse, Account account, String[] stringArray) {
            super(iAccountManagerResponse, account.type, false, true);
            this.mFeatures = stringArray;
            this.mAccount = account;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onResult(Bundle var1_1) {
            block2: {
                var2_2 = this.getResponseAndClose();
                if (var2_2 == null) break block2;
                if (var1_1 != null) ** GOTO lbl7
                try {
                    this.onError(5, "null bundle");
                    return;
lbl7:
                    // 1 sources

                    var3_3 = new Bundle();
                    var3_3.putBoolean("booleanResult", var1_1.getBoolean("booleanResult", false));
                    var2_2.onResult(var3_3);
                    return;
                }
                catch (RemoteException var4_4) {
                    if (!Log.isLoggable("AccountManagerService", 2)) break block2;
                    Log.v("AccountManagerService", "failure while notifying response", var4_4);
                }
            }
        }

        @Override
        public void run() throws RemoteException {
            try {
                this.mAuthenticator.hasFeatures(this, this.mAccount, this.mFeatures);
                return;
            }
            catch (RemoteException remoteException) {
                this.onError(1, "remote exception");
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected String toDebugString(long l) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append(super.toDebugString(l)).append(", hasFeatures").append(", ").append(this.mAccount).append(", ");
            if (this.mFeatures != null) {
                string2 = TextUtils.join((CharSequence)",", this.mFeatures);
                return stringBuilder.append(string2).toString();
            }
            string2 = null;
            return stringBuilder.append(string2).toString();
        }
    }
}

