/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerResponse;
import android.app.ListActivity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class ChooseAccountActivity
extends ListActivity {
    private static final String TAG = "AccountManager";
    private AccountManagerResponse mAccountManagerResponse = null;
    private Parcelable[] mAccounts = null;
    private Bundle mResult;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finish() {
        if (this.mAccountManagerResponse != null) {
            if (this.mResult != null) {
                this.mAccountManagerResponse.onResult(this.mResult);
            } else {
                this.mAccountManagerResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mAccounts = this.getIntent().getParcelableArrayExtra("accounts");
        this.mAccountManagerResponse = (AccountManagerResponse)this.getIntent().getParcelableExtra("accountManagerResponse");
        if (this.mAccounts == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        String[] stringArray = new String[this.mAccounts.length];
        for (int i = 0; i < this.mAccounts.length; ++i) {
            stringArray[i] = ((Account)this.mAccounts[i]).name;
        }
        this.setListAdapter(new ArrayAdapter<String>((Context)this, 17367043, stringArray));
        this.getListView().setTextFilterEnabled(true);
    }

    @Override
    protected void onListItemClick(ListView listView, View view, int n, long l) {
        Account account = (Account)this.mAccounts[n];
        Log.d(TAG, "selected account " + account);
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", account.name);
        bundle.putString("accountType", account.type);
        this.mResult = bundle;
        this.finish();
    }
}

