/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManagerService;
import android.accounts.IAccountManagerResponse;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

public class GrantCredentialsPermissionActivity
extends Activity
implements View.OnClickListener {
    public static final String EXTRAS_ACCOUNT = "account";
    public static final String EXTRAS_ACCOUNT_TYPE_LABEL = "accountTypeLabel";
    public static final String EXTRAS_AUTH_TOKEN_LABEL = "authTokenLabel";
    public static final String EXTRAS_AUTH_TOKEN_TYPE = "authTokenType";
    public static final String EXTRAS_PACKAGES = "application";
    public static final String EXTRAS_REQUESTING_UID = "uid";
    public static final String EXTRAS_RESPONSE = "response";
    private final AccountManagerService accountManagerService = AccountManagerService.getSingleton();
    private Account mAccount;
    private String mAuthTokenType;
    protected LayoutInflater mInflater;
    private Bundle mResultBundle = null;
    private int mUid;

    private View newPackageView(String string2) {
        View view = this.mInflater.inflate(17367109, null);
        ((TextView)view.findViewById(16908798)).setText(string2);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finish() {
        AccountAuthenticatorResponse accountAuthenticatorResponse = (AccountAuthenticatorResponse)this.getIntent().getParcelableExtra(EXTRAS_RESPONSE);
        if (accountAuthenticatorResponse != null) {
            if (this.mResultBundle != null) {
                accountAuthenticatorResponse.onResult(this.mResultBundle);
            } else {
                accountAuthenticatorResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case 16908716: {
                this.accountManagerService.grantAppPermission(this.mAccount, this.mAuthTokenType, this.mUid);
                Intent intent = new Intent();
                intent.putExtra("retry", true);
                this.setResult(-1, intent);
                this.setAccountAuthenticatorResult(intent.getExtras());
            }
            default: {
                break;
            }
            case 16908717: {
                this.accountManagerService.revokeAppPermission(this.mAccount, this.mAuthTokenType, this.mUid);
                this.setResult(0);
            }
        }
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onCreate(Bundle bundle) {
        this.requestWindowFeature(1);
        super.onCreate(bundle);
        this.setContentView(17367078);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Bundle bundle2 = this.getIntent().getExtras();
        this.mAccount = (Account)bundle2.getParcelable(EXTRAS_ACCOUNT);
        this.mAuthTokenType = bundle2.getString(EXTRAS_AUTH_TOKEN_TYPE);
        this.mUid = bundle2.getInt(EXTRAS_REQUESTING_UID);
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(this.mUid);
        if (this.mAccount == null || this.mAuthTokenType == null || stringArray == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        String string2 = this.accountManagerService.getAccountLabel(this.mAccount.type);
        final TextView textView = (TextView)this.findViewById(16908713);
        textView.setVisibility(8);
        IAccountManagerResponse.Stub stub = new IAccountManagerResponse.Stub(){

            @Override
            public void onError(int n, String string2) {
            }

            @Override
            public void onResult(Bundle bundle) {
                final String string2 = bundle.getString("authTokenLabelKey");
                if (!TextUtils.isEmpty(string2)) {
                    GrantCredentialsPermissionActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!GrantCredentialsPermissionActivity.this.isFinishing()) {
                                textView.setText(string2);
                                textView.setVisibility(0);
                            }
                        }
                    });
                }
            }
        };
        this.accountManagerService.getAuthTokenLabel(stub, this.mAccount, this.mAuthTokenType);
        this.findViewById(16908716).setOnClickListener(this);
        this.findViewById(16908717).setOnClickListener(this);
        LinearLayout linearLayout = (LinearLayout)this.findViewById(16908709);
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            String string3;
            if (n2 >= n) {
                ((TextView)this.findViewById(16908712)).setText(this.mAccount.name);
                ((TextView)this.findViewById(16908711)).setText(string2);
                return;
            }
            String string4 = stringArray[n2];
            try {
                String string5;
                string3 = string5 = ((Object)packageManager.getApplicationLabel(packageManager.getApplicationInfo(string4, 0))).toString();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                string3 = string4;
            }
            linearLayout.addView(this.newPackageView(string3));
            ++n2;
        }
    }

    public final void setAccountAuthenticatorResult(Bundle bundle) {
        this.mResultBundle = bundle;
    }
}

