/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AuthenticatorDescription;
import android.accounts.IAccountManagerResponse;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IAccountManager
extends IInterface {
    public boolean addAccount(Account var1, String var2, Bundle var3) throws RemoteException;

    public void addAcount(IAccountManagerResponse var1, String var2, String var3, String[] var4, boolean var5, Bundle var6) throws RemoteException;

    public void clearPassword(Account var1) throws RemoteException;

    public void confirmCredentials(IAccountManagerResponse var1, Account var2, Bundle var3, boolean var4) throws RemoteException;

    public void editProperties(IAccountManagerResponse var1, String var2, boolean var3) throws RemoteException;

    public Account[] getAccounts(String var1) throws RemoteException;

    public void getAccountsByFeatures(IAccountManagerResponse var1, String var2, String[] var3) throws RemoteException;

    public void getAuthToken(IAccountManagerResponse var1, Account var2, String var3, boolean var4, boolean var5, Bundle var6) throws RemoteException;

    public AuthenticatorDescription[] getAuthenticatorTypes() throws RemoteException;

    public String getPassword(Account var1) throws RemoteException;

    public String getUserData(Account var1, String var2) throws RemoteException;

    public void hasFeatures(IAccountManagerResponse var1, Account var2, String[] var3) throws RemoteException;

    public void invalidateAuthToken(String var1, String var2) throws RemoteException;

    public String peekAuthToken(Account var1, String var2) throws RemoteException;

    public void removeAccount(IAccountManagerResponse var1, Account var2) throws RemoteException;

    public void setAuthToken(Account var1, String var2, String var3) throws RemoteException;

    public void setPassword(Account var1, String var2) throws RemoteException;

    public void setUserData(Account var1, String var2, String var3) throws RemoteException;

    public void updateCredentials(IAccountManagerResponse var1, Account var2, String var3, boolean var4, Bundle var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccountManager {
        private static final String DESCRIPTOR = "android.accounts.IAccountManager";
        static final int TRANSACTION_addAccount = 7;
        static final int TRANSACTION_addAcount = 16;
        static final int TRANSACTION_clearPassword = 13;
        static final int TRANSACTION_confirmCredentials = 19;
        static final int TRANSACTION_editProperties = 18;
        static final int TRANSACTION_getAccounts = 4;
        static final int TRANSACTION_getAccountsByFeatures = 6;
        static final int TRANSACTION_getAuthToken = 15;
        static final int TRANSACTION_getAuthenticatorTypes = 3;
        static final int TRANSACTION_getPassword = 1;
        static final int TRANSACTION_getUserData = 2;
        static final int TRANSACTION_hasFeatures = 5;
        static final int TRANSACTION_invalidateAuthToken = 9;
        static final int TRANSACTION_peekAuthToken = 10;
        static final int TRANSACTION_removeAccount = 8;
        static final int TRANSACTION_setAuthToken = 11;
        static final int TRANSACTION_setPassword = 12;
        static final int TRANSACTION_setUserData = 14;
        static final int TRANSACTION_updateCredentials = 17;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccountManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IAccountManager) {
                return (IAccountManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string2 = this.getPassword(account);
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string3 = this.getUserData(account, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAuthenticatorTypes();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAccounts(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.hasFeatures(iAccountManagerResponse, account, parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getAccountsByFeatures(IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder()), parcel.readString(), parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string4 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.addAccount(account, string4, bundle);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.removeAccount(iAccountManagerResponse, account);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.invalidateAuthToken(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string5 = this.peekAuthToken(account, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.setAuthToken(account, parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.setPassword(account, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.clearPassword(account);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    this.setUserData(account, parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string6 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.getAuthToken(iAccountManagerResponse, account, string6, bl, bl2, bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    String string7 = parcel.readString();
                    String string8 = parcel.readString();
                    String[] stringArray = parcel.createStringArray();
                    boolean bl = parcel.readInt() != 0;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.addAcount(iAccountManagerResponse, string7, string8, stringArray, bl, bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
                    String string9 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.updateCredentials(iAccountManagerResponse, account, string9, bl, bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
                    String string10 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.editProperties(iAccountManagerResponse, string10, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            IAccountManagerResponse iAccountManagerResponse = IAccountManagerResponse.Stub.asInterface(parcel.readStrongBinder());
            Account account = parcel.readInt() != 0 ? Account.CREATOR.createFromParcel(parcel) : null;
            Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
            boolean bl = parcel.readInt() != 0;
            this.confirmCredentials(iAccountManagerResponse, account, bundle, bl);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IAccountManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addAccount(Account account, String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addAcount(IAccountManagerResponse iAccountManagerResponse, String string2, String string3, String[] stringArray, boolean bl, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeStringArray(stringArray);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void clearPassword(Account account) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void confirmCredentials(IAccountManagerResponse iAccountManagerResponse, Account account, Bundle bundle, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n = bl ? 1 : 0;
                parcel.writeInt(n);
                this.mRemote.transact(19, parcel, parcel2, 0);
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void editProperties(IAccountManagerResponse iAccountManagerResponse, String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public Account[] getAccounts(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    Account[] accountArray = parcel2.createTypedArray(Account.CREATOR);
                    return accountArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getAccountsByFeatures(IAccountManagerResponse iAccountManagerResponse, String string2, String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getAuthToken(IAccountManagerResponse iAccountManagerResponse, Account account, String string2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    int n2 = bl2 ? 1 : 0;
                    parcel.writeInt(n2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public AuthenticatorDescription[] getAuthenticatorTypes() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    AuthenticatorDescription[] authenticatorDescriptionArray = parcel2.createTypedArray(AuthenticatorDescription.CREATOR);
                    return authenticatorDescriptionArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getPassword(Account account) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getUserData(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void hasFeatures(IAccountManagerResponse iAccountManagerResponse, Account account, String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void invalidateAuthToken(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String peekAuthToken(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeAccount(IAccountManagerResponse iAccountManagerResponse, Account account) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAuthToken(Account account, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setPassword(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setUserData(Account account, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateCredentials(IAccountManagerResponse iAccountManagerResponse, Account account, String string2, boolean bl, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccountManagerResponse != null ? iAccountManagerResponse.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

