/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerProxy;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.text.TextUtils;
import java.util.List;

public abstract class ActivityManagerNative
extends Binder
implements IActivityManager {
    private static IActivityManager gDefault;
    static boolean sSystemReady;

    static {
        sSystemReady = false;
    }

    public ActivityManagerNative() {
        this.attachInterface(this, "android.app.IActivityManager");
    }

    public static IActivityManager asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IActivityManager iActivityManager = (IActivityManager)iBinder.queryLocalInterface("android.app.IActivityManager");
        if (iActivityManager != null) {
            return iActivityManager;
        }
        return new ActivityManagerProxy(iBinder);
    }

    public static void broadcastStickyIntent(Intent intent, String string2) {
        try {
            ActivityManagerNative.getDefault().broadcastIntent(null, intent, null, null, -1, null, null, null, false, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static IActivityManager getDefault() {
        if (gDefault != null) {
            return gDefault;
        }
        gDefault = ActivityManagerNative.asInterface(ServiceManager.getService("activity"));
        return gDefault;
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityManagerNative.getDefault().testIsSystemReady();
        }
        return sSystemReady;
    }

    public static void noteWakeupAlarm(PendingIntent pendingIntent) {
        try {
            ActivityManagerNative.getDefault().noteWakeupAlarm(pendingIntent.getTarget());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        switch (n) {
            default: {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            case 3: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string2 = parcel.readString();
                Uri[] uriArray = parcel.createTypedArray(Uri.CREATOR);
                int n3 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string3 = parcel.readString();
                int n4 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = parcel.readInt() != 0;
                int n5 = this.startActivity(iApplicationThread, intent, string2, uriArray, n3, iBinder, string3, n4, bl, bl2);
                parcel2.writeNoException();
                parcel2.writeInt(n5);
                return true;
            }
            case 105: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string4 = parcel.readString();
                Uri[] uriArray = parcel.createTypedArray(Uri.CREATOR);
                int n6 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string5 = parcel.readString();
                int n7 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl3 = parcel.readInt() != 0;
                IActivityManager.WaitResult waitResult = this.startActivityAndWait(iApplicationThread, intent, string4, uriArray, n6, iBinder, string5, n7, bl, bl3);
                parcel2.writeNoException();
                waitResult.writeToParcel(parcel2, 0);
                return true;
            }
            case 107: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string6 = parcel.readString();
                Uri[] uriArray = parcel.createTypedArray(Uri.CREATOR);
                int n8 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                String string7 = parcel.readString();
                int n9 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl4 = parcel.readInt() != 0;
                int n10 = this.startActivityWithConfig(iApplicationThread, intent, string6, uriArray, n8, iBinder, string7, n9, bl, bl4, Configuration.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                parcel2.writeInt(n10);
                return true;
            }
            case 100: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                IntentSender intentSender = IntentSender.CREATOR.createFromParcel(parcel);
                int n11 = parcel.readInt();
                Intent intent = null;
                if (n11 != 0) {
                    intent = Intent.CREATOR.createFromParcel(parcel);
                }
                int n12 = this.startActivityIntentSender(iApplicationThread, intentSender, intent, parcel.readString(), parcel.readStrongBinder(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n12);
                return true;
            }
            case 67: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.startNextMatchingActivity(parcel.readStrongBinder(), Intent.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                int n13 = bl ? 1 : 0;
                parcel2.writeInt(n13);
                return true;
            }
            case 11: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n14 = parcel.readInt();
                int n15 = parcel.readInt();
                Intent intent = null;
                if (n15 != 0) {
                    intent = Intent.CREATOR.createFromParcel(parcel);
                }
                boolean bl = this.finishActivity(iBinder, n14, intent);
                parcel2.writeNoException();
                int n16 = bl ? 1 : 0;
                parcel2.writeInt(n16);
                return true;
            }
            case 32: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishSubActivity(parcel.readStrongBinder(), parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 106: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.willActivityBeVisible(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n17 = bl ? 1 : 0;
                parcel2.writeInt(n17);
                return true;
            }
            case 12: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                IBinder iBinder2 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder2 != null ? IIntentReceiver.Stub.asInterface(iBinder2) : null;
                IntentFilter intentFilter = IntentFilter.CREATOR.createFromParcel(parcel);
                String string8 = parcel.readString();
                Intent intent = this.registerReceiver(iApplicationThread, iIntentReceiver, intentFilter, string8);
                parcel2.writeNoException();
                if (intent != null) {
                    parcel2.writeInt(1);
                    intent.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 13: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                if (iBinder == null) {
                    return true;
                }
                this.unregisterReceiver(IIntentReceiver.Stub.asInterface(iBinder));
                parcel2.writeNoException();
                return true;
            }
            case 14: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string9 = parcel.readString();
                IBinder iBinder3 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder3 != null ? IIntentReceiver.Stub.asInterface(iBinder3) : null;
                int n18 = parcel.readInt();
                String string10 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                String string11 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl5 = parcel.readInt() != 0;
                int n19 = this.broadcastIntent(iApplicationThread, intent, string9, iIntentReceiver, n18, string10, bundle, string11, bl, bl5);
                parcel2.writeNoException();
                parcel2.writeInt(n19);
                return true;
            }
            case 15: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                this.unbroadcastIntent(iApplicationThread, intent);
                parcel2.writeNoException();
                return true;
            }
            case 16: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n20 = parcel.readInt();
                String string12 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                boolean bl = parcel.readInt() != 0;
                if (iBinder != null) {
                    this.finishReceiver(iBinder, n20, string12, bundle, bl);
                }
                parcel2.writeNoException();
                return true;
            }
            case 17: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                if (iApplicationThread != null) {
                    this.attachApplication(iApplicationThread);
                }
                parcel2.writeNoException();
                return true;
            }
            case 18: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n21 = parcel.readInt();
                Configuration configuration = null;
                if (n21 != 0) {
                    configuration = Configuration.CREATOR.createFromParcel(parcel);
                }
                if (iBinder != null) {
                    this.activityIdle(iBinder, configuration);
                }
                parcel2.writeNoException();
                return true;
            }
            case 19: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityPaused(parcel.readStrongBinder(), parcel.readBundle());
                parcel2.writeNoException();
                return true;
            }
            case 20: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Bitmap bitmap = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
                CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                this.activityStopped(iBinder, bitmap, charSequence);
                parcel2.writeNoException();
                return true;
            }
            case 62: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityDestroyed(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 21: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                String string13 = iBinder != null ? this.getCallingPackage(iBinder) : null;
                parcel2.writeNoException();
                parcel2.writeString(string13);
                return true;
            }
            case 22: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.getCallingActivity(parcel.readStrongBinder());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 23: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n22 = parcel.readInt();
                int n23 = parcel.readInt();
                IBinder iBinder = parcel.readStrongBinder();
                IThumbnailReceiver iThumbnailReceiver = iBinder != null ? IThumbnailReceiver.Stub.asInterface(iBinder) : null;
                List list = this.getTasks(n22, n23, iThumbnailReceiver);
                parcel2.writeNoException();
                int n24 = list != null ? list.size() : -1;
                parcel2.writeInt(n24);
                int n25 = 0;
                while (n25 < n24) {
                    ((ActivityManager.RunningTaskInfo)list.get(n25)).writeToParcel(parcel2, 0);
                    ++n25;
                }
                return true;
            }
            case 60: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RecentTaskInfo> list = this.getRecentTasks(parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 81: {
                parcel.enforceInterface("android.app.IActivityManager");
                List list = this.getServices(parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                int n26 = list != null ? list.size() : -1;
                parcel2.writeInt(n26);
                int n27 = 0;
                while (n27 < n26) {
                    ((ActivityManager.RunningServiceInfo)list.get(n27)).writeToParcel(parcel2, 0);
                    ++n27;
                }
                return true;
            }
            case 77: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.ProcessErrorStateInfo> list = this.getProcessesInErrorState();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 83: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningAppProcessInfo> list = this.getRunningAppProcesses();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 108: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ApplicationInfo> list = this.getRunningExternalApplications();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 24: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.moveTaskToFront(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 25: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.moveTaskToBack(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 75: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                boolean bl6 = this.moveActivityTaskToBack(iBinder, bl);
                parcel2.writeNoException();
                int n28 = bl6 ? 1 : 0;
                parcel2.writeInt(n28);
                return true;
            }
            case 26: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.moveTaskBackwards(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 27: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                int n29 = iBinder != null ? this.getTaskForActivity(iBinder, bl) : -1;
                parcel2.writeNoException();
                parcel2.writeInt(n29);
                return true;
            }
            case 39: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishOtherInstances(parcel.readStrongBinder(), ComponentName.readFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 28: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Bitmap bitmap = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
                CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                this.reportThumbnail(iBinder, bitmap, charSequence);
                parcel2.writeNoException();
                return true;
            }
            case 29: {
                parcel.enforceInterface("android.app.IActivityManager");
                IActivityManager.ContentProviderHolder contentProviderHolder = this.getContentProvider(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readString());
                parcel2.writeNoException();
                if (contentProviderHolder != null) {
                    parcel2.writeInt(1);
                    contentProviderHolder.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 30: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.publishContentProviders(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.createTypedArrayList(IActivityManager.ContentProviderHolder.CREATOR));
                parcel2.writeNoException();
                return true;
            }
            case 69: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.removeContentProvider(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 33: {
                parcel.enforceInterface("android.app.IActivityManager");
                PendingIntent pendingIntent = this.getRunningServiceControlPanel(ComponentName.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                PendingIntent.writePendingIntentOrNullToParcel(pendingIntent, parcel2);
                return true;
            }
            case 34: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.startService(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Intent.CREATOR.createFromParcel(parcel), parcel.readString());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 35: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n30 = this.stopService(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Intent.CREATOR.createFromParcel(parcel), parcel.readString());
                parcel2.writeNoException();
                parcel2.writeInt(n30);
                return true;
            }
            case 48: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.stopServiceToken(ComponentName.readFromParcel(parcel), parcel.readStrongBinder(), parcel.readInt());
                parcel2.writeNoException();
                int n31 = bl ? 1 : 0;
                parcel2.writeInt(n31);
                return true;
            }
            case 74: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                IBinder iBinder = parcel.readStrongBinder();
                int n32 = parcel.readInt();
                int n33 = parcel.readInt();
                Notification notification = null;
                if (n33 != 0) {
                    notification = Notification.CREATOR.createFromParcel(parcel);
                }
                boolean bl = parcel.readInt() != 0;
                this.setServiceForeground(componentName, iBinder, n32, notification, bl);
                parcel2.writeNoException();
                return true;
            }
            case 36: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string14 = parcel.readString();
                IBinder iBinder4 = parcel.readStrongBinder();
                int n34 = parcel.readInt();
                int n35 = this.bindService(iApplicationThread, iBinder, intent, string14, IServiceConnection.Stub.asInterface(iBinder4), n34);
                parcel2.writeNoException();
                parcel2.writeInt(n35);
                return true;
            }
            case 37: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.unbindService(IServiceConnection.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n36 = bl ? 1 : 0;
                parcel2.writeInt(n36);
                return true;
            }
            case 38: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.publishService(parcel.readStrongBinder(), Intent.CREATOR.createFromParcel(parcel), parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 72: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                boolean bl = parcel.readInt() != 0;
                this.unbindFinished(iBinder, intent, bl);
                parcel2.writeNoException();
                return true;
            }
            case 61: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.serviceDoneExecuting(parcel.readStrongBinder(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 44: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.startInstrumentation(ComponentName.readFromParcel(parcel), parcel.readString(), parcel.readInt(), parcel.readBundle(), IInstrumentationWatcher.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n37 = bl ? 1 : 0;
                parcel2.writeInt(n37);
                return true;
            }
            case 45: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishInstrumentation(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readBundle());
                parcel2.writeNoException();
                return true;
            }
            case 46: {
                parcel.enforceInterface("android.app.IActivityManager");
                Configuration configuration = this.getConfiguration();
                parcel2.writeNoException();
                configuration.writeToParcel(parcel2, 0);
                return true;
            }
            case 47: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.updateConfiguration(Configuration.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 70: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setRequestedOrientation(parcel.readStrongBinder(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 71: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n38 = this.getRequestedOrientation(parcel.readStrongBinder());
                parcel2.writeNoException();
                parcel2.writeInt(n38);
                return true;
            }
            case 49: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.getActivityClassForToken(parcel.readStrongBinder());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 50: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                parcel2.writeNoException();
                parcel2.writeString(this.getPackageForToken(iBinder));
                return true;
            }
            case 63: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n39 = parcel.readInt();
                String string15 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string16 = parcel.readString();
                int n40 = parcel.readInt();
                Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                IIntentSender iIntentSender = this.getIntentSender(n39, string15, iBinder, string16, n40, intent, parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                IBinder iBinder5 = iIntentSender != null ? iIntentSender.asBinder() : null;
                parcel2.writeStrongBinder(iBinder5);
                return true;
            }
            case 64: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.cancelIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 65: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string17 = this.getPackageForIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                parcel2.writeString(string17);
                return true;
            }
            case 51: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setProcessLimit(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 52: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n41 = this.getProcessLimit();
                parcel2.writeNoException();
                parcel2.writeInt(n41);
                return true;
            }
            case 73: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n42 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                this.setProcessForeground(iBinder, n42, bl);
                parcel2.writeNoException();
                return true;
            }
            case 53: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n43 = this.checkPermission(parcel.readString(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n43);
                return true;
            }
            case 54: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n44 = this.checkUriPermission(Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n44);
                return true;
            }
            case 78: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.clearApplicationUserData(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n45 = bl ? 1 : 0;
                parcel2.writeInt(n45);
                return true;
            }
            case 55: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.grantUriPermission(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readString(), Uri.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 56: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.revokeUriPermission(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Uri.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 58: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                boolean bl = parcel.readInt() != 0;
                this.showWaitingForDebugger(iApplicationThread, bl);
                parcel2.writeNoException();
                return true;
            }
            case 76: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                this.getMemoryInfo(memoryInfo);
                parcel2.writeNoException();
                memoryInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 4: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unhandledBack();
                parcel2.writeNoException();
                return true;
            }
            case 5: {
                parcel.enforceInterface("android.app.IActivityManager");
                ParcelFileDescriptor parcelFileDescriptor = this.openContentUri(Uri.parse(parcel.readString()));
                parcel2.writeNoException();
                if (parcelFileDescriptor != null) {
                    parcel2.writeInt(1);
                    parcelFileDescriptor.writeToParcel(parcel2, 1);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 40: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.goingToSleep();
                parcel2.writeNoException();
                return true;
            }
            case 41: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.wakingUp();
                parcel2.writeNoException();
                return true;
            }
            case 42: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string18 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl7 = parcel.readInt() != 0;
                this.setDebugApp(string18, bl, bl7);
                parcel2.writeNoException();
                return true;
            }
            case 43: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = parcel.readInt() != 0;
                this.setAlwaysFinish(bl);
                parcel2.writeNoException();
                return true;
            }
            case 57: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setActivityController(IActivityController.Stub.asInterface(parcel.readStrongBinder()));
                return true;
            }
            case 66: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.enterSafeMode();
                parcel2.writeNoException();
                return true;
            }
            case 68: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.noteWakeupAlarm(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 80: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.killPids(parcel.createIntArray(), parcel.readString());
                parcel2.writeNoException();
                int n46 = bl ? 1 : 0;
                parcel2.writeInt(n46);
                return true;
            }
            case 1: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.startRunning(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 2: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
                this.handleApplicationCrash(iBinder, crashInfo);
                parcel2.writeNoException();
                return true;
            }
            case 102: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                String string19 = parcel.readString();
                ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
                boolean bl = this.handleApplicationWtf(iBinder, string19, crashInfo);
                parcel2.writeNoException();
                int n47 = bl ? 1 : 0;
                parcel2.writeInt(n47);
                return true;
            }
            case 110: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n48 = parcel.readInt();
                StrictMode.ViolationInfo violationInfo = new StrictMode.ViolationInfo(parcel);
                this.handleApplicationStrictModeViolation(iBinder, n48, violationInfo);
                parcel2.writeNoException();
                return true;
            }
            case 59: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.signalPersistentProcesses(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 103: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killBackgroundProcesses(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 79: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.forceStopPackage(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 84: {
                parcel.enforceInterface("android.app.IActivityManager");
                ConfigurationInfo configurationInfo = this.getDeviceConfigurationInfo();
                parcel2.writeNoException();
                configurationInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 86: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string20 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                String string21 = parcel.readString();
                ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? parcel.readFileDescriptor() : null;
                boolean bl8 = this.profileControl(string20, bl, string21, parcelFileDescriptor);
                parcel2.writeNoException();
                int n49 = bl8 ? 1 : 0;
                parcel2.writeInt(n49);
                return true;
            }
            case 87: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.shutdown(parcel.readInt());
                parcel2.writeNoException();
                int n50 = bl ? 1 : 0;
                parcel2.writeInt(n50);
                return true;
            }
            case 88: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.stopAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 89: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.resumeAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 85: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = this.peekService(Intent.CREATOR.createFromParcel(parcel), parcel.readString());
                parcel2.writeNoException();
                parcel2.writeStrongBinder(iBinder);
                return true;
            }
            case 90: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.bindBackupAgent(ApplicationInfo.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                int n51 = bl ? 1 : 0;
                parcel2.writeInt(n51);
                return true;
            }
            case 91: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.backupAgentCreated(parcel.readString(), parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 92: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unbindBackupAgent(ApplicationInfo.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 93: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.registerActivityWatcher(IActivityWatcher.Stub.asInterface(parcel.readStrongBinder()));
                return true;
            }
            case 94: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unregisterActivityWatcher(IActivityWatcher.Stub.asInterface(parcel.readStrongBinder()));
                return true;
            }
            case 95: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n52 = parcel.readInt();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string22 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string23 = parcel.readString();
                int n53 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                int n54 = this.startActivityInPackage(n52, intent, string22, iBinder, string23, n53, bl);
                parcel2.writeNoException();
                parcel2.writeInt(n54);
                return true;
            }
            case 96: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killApplicationWithUid(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 97: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.closeSystemDialogs(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 98: {
                parcel.enforceInterface("android.app.IActivityManager");
                Parcelable[] parcelableArray = this.getProcessMemoryInfo(parcel.createIntArray());
                parcel2.writeNoException();
                parcel2.writeTypedArray(parcelableArray, 1);
                return true;
            }
            case 99: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killApplicationProcess(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 101: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.overridePendingTransition(parcel.readStrongBinder(), parcel.readString(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 104: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isUserAMonkey();
                parcel2.writeNoException();
                int n55 = bl ? 1 : 0;
                parcel2.writeInt(n55);
                return true;
            }
            case 109: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishHeavyWeightApp();
                parcel2.writeNoException();
                return true;
            }
            case 114: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.crashApplication(parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 115: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string24 = this.getProviderMimeType(Uri.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                parcel2.writeString(string24);
                return true;
            }
            case 116: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = this.newUriPermissionOwner(parcel.readString());
                parcel2.writeNoException();
                parcel2.writeStrongBinder(iBinder);
                return true;
            }
            case 117: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.grantUriPermissionFromOwner(parcel.readStrongBinder(), parcel.readInt(), parcel.readString(), Uri.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 118: 
        }
        parcel.enforceInterface("android.app.IActivityManager");
        IBinder iBinder = parcel.readStrongBinder();
        if (parcel.readInt() != 0) {
            Uri.CREATOR.createFromParcel(parcel);
        }
        this.revokeUriPermissionFromOwner(iBinder, null, parcel.readInt());
        parcel2.writeNoException();
        return true;
    }
}

