/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.IAlarmManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.KeyguardManager;
import android.app.LoadedApk;
import android.app.NotificationManager;
import android.app.QueuedWork;
import android.app.ReceiverRestrictedContext;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.IThrottleManager;
import android.net.ThrottleManager;
import android.net.Uri;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiManager;
import android.nfc.NfcManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.os.storage.StorageManager;
import android.telephony.TelephonyManager;
import android.text.ClipboardManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.xmlpull.v1.XmlPullParserException;

class ContextImpl
extends Context {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_ICONS = false;
    private static final String[] EMPTY_FILE_LIST;
    private static final String TAG = "ApplicationContext";
    private static AlarmManager sAlarmManager;
    private static ConnectivityManager sConnectivityManager;
    private static long sInstanceCount;
    private static LocationManager sLocationManager;
    private static PowerManager sPowerManager;
    private static final HashMap<String, SharedPreferencesImpl> sSharedPrefs;
    private static final Object sSync;
    private static ThrottleManager sThrottleManager;
    private static WifiManager sWifiManager;
    private AccountManager mAccountManager;
    private ActivityManager mActivityManager = null;
    private IBinder mActivityToken = null;
    private AudioManager mAudioManager;
    private File mCacheDir;
    private ClipboardManager mClipboardManager = null;
    private ApplicationContentResolver mContentResolver;
    private File mDatabasesDir;
    private DevicePolicyManager mDevicePolicyManager = null;
    private DownloadManager mDownloadManager = null;
    private DropBoxManager mDropBoxManager = null;
    private File mExternalCacheDir;
    private File mExternalFilesDir;
    private File mFilesDir;
    private LayoutInflater mLayoutInflater = null;
    ActivityThread mMainThread;
    private NfcManager mNfcManager = null;
    private NotificationManager mNotificationManager = null;
    private Context mOuterContext;
    LoadedApk mPackageInfo;
    private PackageManager mPackageManager;
    private File mPreferencesDir;
    private Context mReceiverRestrictedContext = null;
    private Resources mResources;
    private boolean mRestricted;
    private SearchManager mSearchManager = null;
    private SensorManager mSensorManager = null;
    private StatusBarManager mStatusBarManager = null;
    private StorageManager mStorageManager = null;
    private final Object mSync = new Object();
    private TelephonyManager mTelephonyManager = null;
    private Resources.Theme mTheme = null;
    private int mThemeResource = 0;
    private UiModeManager mUiModeManager = null;
    private Vibrator mVibrator = null;
    private WallpaperManager mWallpaperManager = null;

    static {
        sSync = new Object();
        sSharedPrefs = new HashMap();
        sInstanceCount = 0L;
        EMPTY_FILE_LIST = new String[0];
    }

    ContextImpl() {
        this.mOuterContext = this;
    }

    public ContextImpl(ContextImpl contextImpl) {
        sInstanceCount = 1L + sInstanceCount;
        this.mPackageInfo = contextImpl.mPackageInfo;
        this.mResources = contextImpl.mResources;
        this.mMainThread = contextImpl.mMainThread;
        this.mContentResolver = contextImpl.mContentResolver;
        this.mOuterContext = this;
    }

    static DropBoxManager createDropBoxManager() {
        return new DropBoxManager(IDropBoxManagerService.Stub.asInterface(ServiceManager.getService("dropbox")));
    }

    static ContextImpl createSystemContext(ActivityThread activityThread) {
        ContextImpl contextImpl = new ContextImpl();
        contextImpl.init(Resources.getSystem(), activityThread);
        return contextImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforce(String string2, int n, boolean bl, int n2, String string3) {
        String string4;
        if (n == 0) return;
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string3 != null ? string3 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string5);
        if (bl) {
            string4 = "Neither user " + n2 + " nor current process has ";
            throw new SecurityException(stringBuilder2.append(string4).append(string2).append(".").toString());
        }
        string4 = "User " + n2 + " does not have ";
        throw new SecurityException(stringBuilder2.append(string4).append(string2).append(".").toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforceForUri(int n, int n2, boolean bl, int n3, Uri uri, String string2) {
        String string3;
        if (n2 == 0) return;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string2 != null ? string2 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        if (bl) {
            string3 = "Neither user " + n3 + " nor current process has ";
            throw new SecurityException(stringBuilder2.append(string3).append(this.uriModeFlagToString(n)).append(" permission on ").append(uri).append(".").toString());
        }
        string3 = "User " + n3 + " does not have ";
        throw new SecurityException(stringBuilder2.append(string3).append(this.uriModeFlagToString(n)).append(" permission on ").append(uri).append(".").toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccountManager getAccountManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAccountManager != null) return this.mAccountManager;
            this.mAccountManager = new AccountManager((Context)this, IAccountManager.Stub.asInterface(ServiceManager.getService("account")));
            return this.mAccountManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActivityManager getActivityManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityManager == null) {
                this.mActivityManager = new ActivityManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
            return this.mActivityManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AlarmManager getAlarmManager() {
        Object object = sSync;
        synchronized (object) {
            if (sAlarmManager == null) {
                sAlarmManager = new AlarmManager(IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm")));
            }
            return sAlarmManager;
        }
    }

    private AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = new AudioManager((Context)this);
        }
        return this.mAudioManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClipboardManager getClipboardManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mClipboardManager == null) {
                this.mClipboardManager = new ClipboardManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
            return this.mClipboardManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectivityManager getConnectivityManager() {
        Object object = sSync;
        synchronized (object) {
            if (sConnectivityManager == null) {
                sConnectivityManager = new ConnectivityManager(IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")));
            }
            return sConnectivityManager;
        }
    }

    private File getDataDirFile() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getDataDirFile();
        }
        throw new RuntimeException("Not supported in system context");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                this.mDatabasesDir = new File(this.getDataDirFile(), "databases");
            }
            if (!this.mDatabasesDir.getPath().equals("databases")) return this.mDatabasesDir;
            this.mDatabasesDir = new File("/data/system");
            return this.mDatabasesDir;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DevicePolicyManager getDevicePolicyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDevicePolicyManager == null) {
                this.mDevicePolicyManager = DevicePolicyManager.create((Context)this, (Handler)this.mMainThread.getHandler());
            }
            return this.mDevicePolicyManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadManager getDownloadManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDownloadManager == null) {
                this.mDownloadManager = new DownloadManager(this.getContentResolver(), this.getPackageName());
            }
            return this.mDownloadManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DropBoxManager getDropBoxManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDropBoxManager == null) {
                this.mDropBoxManager = ContextImpl.createDropBoxManager();
            }
            return this.mDropBoxManager;
        }
    }

    public static long getInstanceCount() {
        return sInstanceCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocationManager getLocationManager() {
        Object object = sSync;
        synchronized (object) {
            if (sLocationManager == null) {
                sLocationManager = new LocationManager(ILocationManager.Stub.asInterface(ServiceManager.getService("location")));
            }
            return sLocationManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NfcManager getNfcManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNfcManager == null) {
                this.mNfcManager = new NfcManager((Context)this);
            }
            return this.mNfcManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NotificationManager getNotificationManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNotificationManager == null) {
                this.mNotificationManager = new NotificationManager((Context)new ContextThemeWrapper(this.getOuterContext(), 16973835), this.mMainThread.getHandler());
            }
            return this.mNotificationManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PowerManager getPowerManager() {
        Object object = sSync;
        synchronized (object) {
            if (sPowerManager == null) {
                sPowerManager = new PowerManager(IPowerManager.Stub.asInterface(ServiceManager.getService("power")), this.mMainThread.getHandler());
            }
            return sPowerManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir != null) return this.mPreferencesDir;
            this.mPreferencesDir = new File(this.getDataDirFile(), "shared_prefs");
            return this.mPreferencesDir;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchManager getSearchManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSearchManager == null) {
                this.mSearchManager = new SearchManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
            return this.mSearchManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SensorManager getSensorManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSensorManager == null) {
                this.mSensorManager = new SensorManager(this.mMainThread.getHandler().getLooper());
            }
            return this.mSensorManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageManager getStorageManager() {
        Object object = this.mSync;
        synchronized (object) {
            StorageManager storageManager = this.mStorageManager;
            if (storageManager == null) {
                try {
                    this.mStorageManager = new StorageManager(this.mMainThread.getHandler().getLooper());
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Failed to create StorageManager", remoteException);
                    this.mStorageManager = null;
                }
            }
            return this.mStorageManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TelephonyManager getTelephonyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mTelephonyManager == null) {
                this.mTelephonyManager = new TelephonyManager(this.getOuterContext());
            }
            return this.mTelephonyManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ThrottleManager getThrottleManager() {
        Object object = sSync;
        synchronized (object) {
            if (sThrottleManager == null) {
                sThrottleManager = new ThrottleManager(IThrottleManager.Stub.asInterface(ServiceManager.getService("throttle")));
            }
            return sThrottleManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UiModeManager getUiModeManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUiModeManager == null) {
                this.mUiModeManager = new UiModeManager();
            }
            return this.mUiModeManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vibrator getVibrator() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVibrator == null) {
                this.mVibrator = new Vibrator();
            }
            return this.mVibrator;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WallpaperManager getWallpaperManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mWallpaperManager == null) {
                this.mWallpaperManager = new WallpaperManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
            return this.mWallpaperManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WifiManager getWifiManager() {
        Object object = sSync;
        synchronized (object) {
            if (sWifiManager == null) {
                sWifiManager = new WifiManager(IWifiManager.Stub.asInterface(ServiceManager.getService("wifi")), this.mMainThread.getHandler());
            }
            return sWifiManager;
        }
    }

    private static File makeBackupFile(File file) {
        return new File(file.getPath() + ".bak");
    }

    private File makeFilename(File file, String string2) {
        if (string2.indexOf(File.separatorChar) < 0) {
            return new File(file, string2);
        }
        throw new IllegalArgumentException("File " + string2 + " contains a path separator");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent registerReceiverInternal(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler, Context context) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, true);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, context, handler, null, true).getIIntentReceiver();
            }
        }
        try {
            return ActivityManagerNative.getDefault().registerReceiver(this.mMainThread.getApplicationThread(), iIntentReceiver, intentFilter, string2);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void setFilePermissionsFromMode(String string2, int n, int n2) {
        int n3 = n2 | 0x1B0;
        if ((n & 1) != 0) {
            n3 |= 4;
        }
        if ((n & 2) != 0) {
            n3 |= 2;
        }
        FileUtils.setPermissions(string2, n3, -1, -1);
    }

    private String uriModeFlagToString(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown permission mode flags: " + n);
            }
            case 3: {
                return "read and write";
            }
            case 1: {
                return "read";
            }
            case 2: 
        }
        return "write";
    }

    /*
     * Enabled aggressive block sorting
     */
    private File validateFilePath(String string2, boolean bl) {
        File file;
        File file2;
        if (string2.charAt(0) == File.separatorChar) {
            file2 = new File(string2.substring(0, string2.lastIndexOf(File.separatorChar)));
            file = new File(file2, string2.substring(string2.lastIndexOf(File.separatorChar)));
        } else {
            file2 = this.getDatabasesDir();
            file = this.makeFilename(file2, string2);
        }
        if (bl && !file2.isDirectory() && file2.mkdir()) {
            FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
        }
        return file;
    }

    @Override
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n) {
        int n2;
        block4: {
            if (this.mPackageInfo != null) {
                IServiceConnection iServiceConnection = this.mPackageInfo.getServiceDispatcher(serviceConnection, this.getOuterContext(), this.mMainThread.getHandler(), n);
                try {
                    n2 = ActivityManagerNative.getDefault().bindService(this.mMainThread.getApplicationThread(), this.getActivityToken(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), iServiceConnection, n);
                    if (n2 >= 0) break block4;
                }
                catch (RemoteException remoteException) {
                    return false;
                }
                throw new SecurityException("Not allowed to bind to service " + intent);
            }
            throw new RuntimeException("Not supported in system context");
        }
        return n2 != 0;
    }

    @Override
    public int checkCallingOrSelfPermission(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(string2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int n) {
        return this.checkUriPermission(uri, Binder.getCallingPid(), Binder.getCallingUid(), n);
    }

    @Override
    public int checkCallingPermission(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int n = Binder.getCallingPid();
        if (n != Process.myPid()) {
            return this.checkPermission(string2, n, Binder.getCallingUid());
        }
        return -1;
    }

    @Override
    public int checkCallingUriPermission(Uri uri, int n) {
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int n2 = Binder.getCallingPid();
        if (n2 != Process.myPid()) {
            return this.checkUriPermission(uri, n2, Binder.getCallingUid(), n);
        }
        return -1;
    }

    @Override
    public int checkPermission(String string2, int n, int n2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            int n3 = ActivityManagerNative.getDefault().checkPermission(string2, n, n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) {
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            int n4 = ActivityManagerNative.getDefault().checkUriPermission(uri, n, n2, n3);
            return n4;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    @Override
    public int checkUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3) {
        if ((n3 & 1) != 0 && (string2 == null || this.checkPermission(string2, n, n2) == 0)) {
            return 0;
        }
        if ((n3 & 2) != 0 && (string3 == null || this.checkPermission(string3, n, n2) == 0)) {
            return 0;
        }
        if (uri != null) {
            return this.checkUriPermission(uri, n, n2, n3);
        }
        return -1;
    }

    @Override
    public void clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Context createPackageContext(String string2, int n) throws PackageManager.NameNotFoundException {
        if (string2.equals("system") || string2.equals("android")) {
            return new ContextImpl(this.mMainThread.getSystemContext());
        }
        LoadedApk loadedApk = this.mMainThread.getPackageInfo(string2, n);
        if (loadedApk != null) {
            ContextImpl contextImpl = new ContextImpl();
            boolean bl = (n & 4) == 4;
            contextImpl.mRestricted = bl;
            contextImpl.init(loadedApk, null, this.mMainThread, this.mResources);
            if (contextImpl.mResources != null) {
                return contextImpl;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + string2 + " not found");
    }

    @Override
    public String[] databaseList() {
        String[] stringArray = this.getDatabasesDir().list();
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_FILE_LIST;
    }

    @Override
    public boolean deleteDatabase(String string2) {
        try {
            boolean bl = this.validateFilePath(string2, false).delete();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean deleteFile(String string2) {
        return this.makeFilename(this.getFilesDir(), string2).delete();
    }

    @Override
    public void enforceCallingOrSelfPermission(String string2, String string3) {
        this.enforce(string2, this.checkCallingOrSelfPermission(string2), true, Binder.getCallingUid(), string3);
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int n, String string2) {
        this.enforceForUri(n, this.checkCallingOrSelfUriPermission(uri, n), true, Binder.getCallingUid(), uri, string2);
    }

    @Override
    public void enforceCallingPermission(String string2, String string3) {
        this.enforce(string2, this.checkCallingPermission(string2), false, Binder.getCallingUid(), string3);
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int n, String string2) {
        this.enforceForUri(n, this.checkCallingUriPermission(uri, n), false, Binder.getCallingUid(), uri, string2);
    }

    @Override
    public void enforcePermission(String string2, int n, int n2, String string3) {
        this.enforce(string2, this.checkPermission(string2, n, n2), false, n2, string3);
    }

    @Override
    public void enforceUriPermission(Uri uri, int n, int n2, int n3, String string2) {
        this.enforceForUri(n3, this.checkUriPermission(uri, n, n2, n3), false, n2, uri, string2);
    }

    @Override
    public void enforceUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3, String string4) {
        this.enforceForUri(n3, this.checkUriPermission(uri, string2, string3, n, n2, n3), false, n2, uri, string4);
    }

    @Override
    public String[] fileList() {
        String[] stringArray = this.getFilesDir().list();
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_FILE_LIST;
    }

    final IBinder getActivityToken() {
        return this.mActivityToken;
    }

    @Override
    public Context getApplicationContext() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplication();
        }
        return this.mMainThread.getApplication();
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(this.getDataDirFile(), "cache");
            }
            if (!this.mCacheDir.exists()) {
                if (!this.mCacheDir.mkdirs()) {
                    Log.w(TAG, "Unable to create cache directory");
                    return null;
                }
                FileUtils.setPermissions(this.mCacheDir.getPath(), 505, -1, -1);
            }
            return this.mCacheDir;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String string2) {
        return this.validateFilePath(string2, false);
    }

    @Override
    public File getDir(String string2, int n) {
        String string3 = "app_" + string2;
        File file = this.makeFilename(this.getDataDirFile(), string3);
        if (!file.exists()) {
            file.mkdir();
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 505);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getExternalCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl;
            if (this.mExternalCacheDir == null) {
                this.mExternalCacheDir = Environment.getExternalStorageAppCacheDirectory((String)this.getPackageName());
            }
            if (bl = this.mExternalCacheDir.exists()) return this.mExternalCacheDir;
            try {
                new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
            }
            catch (IOException iOException) {}
            if (this.mExternalCacheDir.mkdirs()) return this.mExternalCacheDir;
            Log.w(TAG, "Unable to create external cache directory");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getExternalFilesDir(String string2) {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl;
            if (this.mExternalFilesDir == null) {
                this.mExternalFilesDir = Environment.getExternalStorageAppFilesDirectory((String)this.getPackageName());
            }
            if (!(bl = this.mExternalFilesDir.exists())) {
                try {
                    new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
                }
                catch (IOException iOException) {}
                if (!this.mExternalFilesDir.mkdirs()) {
                    Log.w(TAG, "Unable to create external files directory");
                    return null;
                }
            }
            if (string2 == null) {
                return this.mExternalFilesDir;
            }
            File file = new File(this.mExternalFilesDir, string2);
            if (file.exists()) return file;
            if (file.mkdirs()) return file;
            Log.w(TAG, "Unable to create external media directory " + file);
            return null;
        }
    }

    @Override
    public File getFileStreamPath(String string2) {
        return this.makeFilename(this.getFilesDir(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                this.mFilesDir = new File(this.getDataDirFile(), "files");
            }
            if (this.mFilesDir.exists()) return this.mFilesDir;
            if (!this.mFilesDir.mkdirs()) {
                Log.w(TAG, "Unable to create files directory");
                return null;
            }
            FileUtils.setPermissions(this.mFilesDir.getPath(), 505, -1, -1);
            return this.mFilesDir;
        }
    }

    @Override
    public Looper getMainLooper() {
        return this.mMainThread.getLooper();
    }

    final Context getOuterContext() {
        return this.mOuterContext;
    }

    @Override
    public String getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public PackageManager getPackageManager() {
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        if (iPackageManager != null) {
            ApplicationPackageManager applicationPackageManager = new ApplicationPackageManager(this, iPackageManager);
            this.mPackageManager = applicationPackageManager;
            return applicationPackageManager;
        }
        return null;
    }

    @Override
    public String getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public String getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    final Context getReceiverRestrictedContext() {
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        ReceiverRestrictedContext receiverRestrictedContext = new ReceiverRestrictedContext(this.getOuterContext());
        this.mReceiverRestrictedContext = receiverRestrictedContext;
        return receiverRestrictedContext;
    }

    @Override
    public Resources getResources() {
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SharedPreferences getSharedPreferences(String string2, int n) {
        boolean bl;
        File file;
        SharedPreferencesImpl sharedPreferencesImpl;
        HashMap<String, SharedPreferencesImpl> hashMap = sSharedPrefs;
        synchronized (hashMap) {
            sharedPreferencesImpl = sSharedPrefs.get(string2);
            if (sharedPreferencesImpl != null && !sharedPreferencesImpl.hasFileChangedUnexpectedly()) {
                return sharedPreferencesImpl;
            }
            file = this.getSharedPrefsFile(string2);
            bl = false;
            if (sharedPreferencesImpl == null) {
                sharedPreferencesImpl = new SharedPreferencesImpl(file, n, null);
                sSharedPrefs.put(string2, sharedPreferencesImpl);
                bl = true;
            }
        }
        synchronized (sharedPreferencesImpl) {
            if (bl && sharedPreferencesImpl.isLoaded()) {
                return sharedPreferencesImpl;
            }
            File file2 = ContextImpl.makeBackupFile(file);
            if (file2.exists()) {
                file.delete();
                file2.renameTo(file);
            }
            if (file.exists() && !file.canRead()) {
                Log.w(TAG, "Attempt to read preferences file " + file + " without permission");
            }
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            boolean bl2 = FileUtils.getFileStatus(file.getPath(), fileStatus);
            HashMap hashMap2 = null;
            if (bl2) {
                boolean bl3 = file.canRead();
                hashMap2 = null;
                if (bl3) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        hashMap2 = XmlUtils.readMapXml(fileInputStream);
                        fileInputStream.close();
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        Log.w(TAG, "getSharedPreferences", xmlPullParserException);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.w(TAG, "getSharedPreferences", fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        Log.w(TAG, "getSharedPreferences", iOException);
                    }
                }
            }
            sharedPreferencesImpl.replace(hashMap2, fileStatus);
            return sharedPreferencesImpl;
        }
    }

    public File getSharedPrefsFile(String string2) {
        return this.makeFilename(this.getPreferencesDir(), string2 + ".xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getSystemService(String string2) {
        if ("window".equals(string2)) {
            return WindowManagerImpl.getDefault();
        }
        if ("layout_inflater".equals(string2)) {
            Object object = this.mSync;
            synchronized (object) {
                LayoutInflater layoutInflater;
                LayoutInflater layoutInflater2 = this.mLayoutInflater;
                if (layoutInflater2 != null) {
                    return layoutInflater2;
                }
                this.mLayoutInflater = layoutInflater = PolicyManager.makeNewLayoutInflater(this.getOuterContext());
                return layoutInflater;
            }
        }
        if ("activity".equals(string2)) {
            return this.getActivityManager();
        }
        if ("input_method".equals(string2)) {
            return InputMethodManager.getInstance((Context)this);
        }
        if ("alarm".equals(string2)) {
            return this.getAlarmManager();
        }
        if ("account".equals(string2)) {
            return this.getAccountManager();
        }
        if ("power".equals(string2)) {
            return this.getPowerManager();
        }
        if ("connectivity".equals(string2)) {
            return this.getConnectivityManager();
        }
        if ("throttle".equals(string2)) {
            return this.getThrottleManager();
        }
        if ("wifi".equals(string2)) {
            return this.getWifiManager();
        }
        if ("notification".equals(string2)) {
            return this.getNotificationManager();
        }
        if ("keyguard".equals(string2)) {
            return new KeyguardManager();
        }
        if ("accessibility".equals(string2)) {
            return AccessibilityManager.getInstance((Context)this);
        }
        if ("location".equals(string2)) {
            return this.getLocationManager();
        }
        if ("search".equals(string2)) {
            return this.getSearchManager();
        }
        if ("sensor".equals(string2)) {
            return this.getSensorManager();
        }
        if ("storage".equals(string2)) {
            return this.getStorageManager();
        }
        if ("vibrator".equals(string2)) {
            return this.getVibrator();
        }
        if ("statusbar".equals(string2)) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mStatusBarManager != null) return this.mStatusBarManager;
                this.mStatusBarManager = new StatusBarManager(this.getOuterContext());
                return this.mStatusBarManager;
            }
        }
        if ("audio".equals(string2)) {
            return this.getAudioManager();
        }
        if ("phone".equals(string2)) {
            return this.getTelephonyManager();
        }
        if ("clipboard".equals(string2)) {
            return this.getClipboardManager();
        }
        if ("wallpaper".equals(string2)) {
            return this.getWallpaperManager();
        }
        if ("dropbox".equals(string2)) {
            return this.getDropBoxManager();
        }
        if ("device_policy".equals(string2)) {
            return this.getDevicePolicyManager();
        }
        if ("uimode".equals(string2)) {
            return this.getUiModeManager();
        }
        if ("download".equals(string2)) {
            return this.getDownloadManager();
        }
        if (!"nfc".equals(string2)) return null;
        return this.getNfcManager();
    }

    @Override
    public Resources.Theme getTheme() {
        if (this.mTheme == null) {
            if (this.mThemeResource == 0) {
                this.mThemeResource = 16973829;
            }
            this.mTheme = this.mResources.newTheme();
            this.mTheme.applyStyle(this.mThemeResource, true);
        }
        return this.mTheme;
    }

    @Override
    public Drawable getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    @Override
    public void grantUriPermission(String string2, Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().grantUriPermission(this.mMainThread.getApplicationThread(), string2, uri, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void init(LoadedApk loadedApk, IBinder iBinder, ActivityThread activityThread) {
        this.init(loadedApk, iBinder, activityThread, null);
    }

    final void init(LoadedApk loadedApk, IBinder iBinder, ActivityThread activityThread, Resources resources) {
        this.mPackageInfo = loadedApk;
        this.mResources = this.mPackageInfo.getResources(activityThread);
        if (this.mResources != null && resources != null && resources.getCompatibilityInfo().applicationScale != this.mResources.getCompatibilityInfo().applicationScale) {
            this.mResources = activityThread.getTopLevelResources(this.mPackageInfo.getResDir(), resources.getCompatibilityInfo().copy());
        }
        this.mMainThread = activityThread;
        this.mContentResolver = new ApplicationContentResolver(this, activityThread);
        this.setActivityToken(iBinder);
    }

    final void init(Resources resources, ActivityThread activityThread) {
        this.mPackageInfo = null;
        this.mResources = resources;
        this.mMainThread = activityThread;
        this.mContentResolver = new ApplicationContentResolver(this, activityThread);
    }

    @Override
    public boolean isRestricted() {
        return this.mRestricted;
    }

    @Override
    public FileInputStream openFileInput(String string2) throws FileNotFoundException {
        return new FileInputStream(this.makeFilename(this.getFilesDir(), string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileOutputStream openFileOutput(String string2, int n) throws FileNotFoundException {
        boolean bl = (0x8000 & n) != 0;
        File file = this.makeFilename(this.getFilesDir(), string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = file.getParentFile();
            file2.mkdir();
            FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
            return fileOutputStream;
        }
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
        File file = this.validateFilePath(string2, true);
        SQLiteDatabase sQLiteDatabase = SQLiteDatabase.openOrCreateDatabase(file, cursorFactory);
        ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
        return sQLiteDatabase;
    }

    @Override
    public Drawable peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    final void performFinalCleanup(String string2, String string3) {
        this.mPackageInfo.removeContextRegistrations(this.getOuterContext(), string2, string3);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return this.registerReceiver(broadcastReceiver, intentFilter, null, null);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        return this.registerReceiverInternal(broadcastReceiver, intentFilter, string2, handler, this.getOuterContext());
    }

    @Override
    public void removeStickyBroadcast(Intent intent) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (string2 != null) {
            Intent intent2 = new Intent(intent);
            intent2.setDataAndType(intent2.getData(), string2);
            intent = intent2;
        }
        try {
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void revokeUriPermission(Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().revokeUriPermission(this.mMainThread.getApplicationThread(), uri, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void scheduleFinalCleanup(String string2, String string3) {
        this.mMainThread.scheduleContextCleanup(this, string2, string3);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, false, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcast(Intent intent, String string2) {
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, false, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2) {
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, true, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string4 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string4, iIntentReceiver, n, string3, bundle, string2, true, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendStickyBroadcast(Intent intent) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, false, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, iIntentReceiver, n, string2, bundle, null, true, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void setActivityToken(IBinder iBinder) {
        this.mActivityToken = iBinder;
    }

    final void setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    @Override
    public void setTheme(int n) {
        this.mThemeResource = n;
    }

    @Override
    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    @Override
    public void setWallpaper(InputStream inputStream) throws IOException {
        this.getWallpaperManager().setStream(inputStream);
    }

    @Override
    public void startActivity(Intent intent) {
        if ((0x10000000 & intent.getFlags()) == 0) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivity(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intent, -1);
    }

    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, Bundle bundle) {
        try {
            boolean bl = ActivityManagerNative.getDefault().startInstrumentation(componentName, string2, 0, bundle, null);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startIntentSender(IntentSender var1_1, Intent var2_2, int var3_3, int var4_4, int var5_5) throws IntentSender.SendIntentException {
        var6_6 = null;
        if (var2_2 == null) ** GOTO lbl5
        try {
            var6_6 = var2_2.resolveTypeIfNeeded(this.getContentResolver());
lbl5:
            // 2 sources

            if ((var8_7 = ActivityManagerNative.getDefault().startActivityIntentSender(this.mMainThread.getApplicationThread(), var1_1, var2_2, var6_6, null, null, 0, var3_3, var4_4)) != -6) ** GOTO lbl10
        }
        catch (RemoteException var7_8) {
            return;
        }
        throw new IntentSender.SendIntentException();
lbl10:
        // 1 sources

        Instrumentation.checkStartActivityResult((int)var8_7, null);
    }

    @Override
    public ComponentName startService(Intent intent) {
        ComponentName componentName;
        block4: {
            try {
                componentName = ActivityManagerNative.getDefault().startService(this.mMainThread.getApplicationThread(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()));
                if (componentName == null) break block4;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            if (componentName.getPackageName().equals("!")) {
                throw new SecurityException("Not allowed to start service " + intent + " without permission " + componentName.getClassName());
            }
        }
        return componentName;
    }

    @Override
    public boolean stopService(Intent intent) {
        int n;
        block3: {
            try {
                n = ActivityManagerNative.getDefault().stopService(this.mMainThread.getApplicationThread(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()));
                if (n >= 0) break block3;
            }
            catch (RemoteException remoteException) {
                return false;
            }
            throw new SecurityException("Not allowed to stop service " + intent);
        }
        return n != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbindService(ServiceConnection serviceConnection) {
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        IServiceConnection iServiceConnection = this.mPackageInfo.forgetServiceDispatcher(this.getOuterContext(), serviceConnection);
        try {
            ActivityManagerNative.getDefault().unbindService(iServiceConnection);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        IIntentReceiver iIntentReceiver = this.mPackageInfo.forgetReceiverDispatcher(this.getOuterContext(), broadcastReceiver);
        try {
            ActivityManagerNative.getDefault().unregisterReceiver(iIntentReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static final class ApplicationContentResolver
    extends ContentResolver {
        private final ActivityThread mMainThread;

        public ApplicationContentResolver(Context context, ActivityThread activityThread) {
            super(context);
            this.mMainThread = activityThread;
        }

        protected IContentProvider acquireExistingProvider(Context context, String string2) {
            return this.mMainThread.acquireExistingProvider(context, string2);
        }

        protected IContentProvider acquireProvider(Context context, String string2) {
            return this.mMainThread.acquireProvider(context, string2);
        }

        public boolean releaseProvider(IContentProvider iContentProvider) {
            return this.mMainThread.releaseProvider(iContentProvider);
        }
    }

    static final class ApplicationPackageManager
    extends PackageManager {
        private static HashMap<ResourceName, WeakReference<Drawable>> sIconCache;
        private static HashMap<ResourceName, WeakReference<CharSequence>> sStringCache;
        private static final Object sSync;
        int mCachedSafeMode = -1;
        private final ContextImpl mContext;
        private final IPackageManager mPM;

        static {
            sSync = new Object();
            sIconCache = new HashMap();
            sStringCache = new HashMap();
        }

        ApplicationPackageManager(ContextImpl contextImpl, IPackageManager iPackageManager) {
            this.mContext = contextImpl;
            this.mPM = iPackageManager;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static void configurationChanged() {
            Object object = sSync;
            synchronized (object) {
                sIconCache.clear();
                sStringCache.clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Drawable getCachedIcon(ResourceName resourceName) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<Drawable> weakReference = sIconCache.get(resourceName);
                if (weakReference != null) {
                    Drawable drawable2 = (Drawable)weakReference.get();
                    if (drawable2 != null) {
                        return drawable2;
                    }
                    sIconCache.remove(resourceName);
                }
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CharSequence getCachedString(ResourceName resourceName) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<CharSequence> weakReference = sStringCache.get(resourceName);
                if (weakReference != null) {
                    CharSequence charSequence = (CharSequence)weakReference.get();
                    if (charSequence != null) {
                        return charSequence;
                    }
                    sStringCache.remove(resourceName);
                }
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static final void handlePackageBroadcast(int n, String[] stringArray, boolean bl) {
            boolean bl2 = false;
            if (n == 1) {
                bl2 = true;
            }
            if (stringArray != null && stringArray.length > 0) {
                boolean bl3 = false;
                for (String string2 : stringArray) {
                    Object object = sSync;
                    synchronized (object) {
                        if (sIconCache.size() > 0) {
                            Iterator<ResourceName> iterator = sIconCache.keySet().iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.next().packageName.equals(string2)) continue;
                                iterator.remove();
                                bl3 = true;
                            }
                        }
                        if (sStringCache.size() > 0) {
                            Iterator<ResourceName> iterator = sStringCache.keySet().iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.next().packageName.equals(string2)) continue;
                                iterator.remove();
                                bl3 = true;
                            }
                        }
                    }
                }
                if (bl3 || bl) {
                    if (!bl2) {
                        ActivityThread.currentActivityThread().scheduleGcIdler();
                        return;
                    }
                    Runtime.getRuntime().gc();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void putCachedIcon(ResourceName resourceName, Drawable drawable2) {
            Object object = sSync;
            synchronized (object) {
                sIconCache.put(resourceName, new WeakReference<Drawable>(drawable2));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void putCachedString(ResourceName resourceName, CharSequence charSequence) {
            Object object = sSync;
            synchronized (object) {
                sStringCache.put(resourceName, new WeakReference<CharSequence>(charSequence));
                return;
            }
        }

        @Override
        public void addPackageToPreferred(String string2) {
            try {
                this.mPM.addPackageToPreferred(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public boolean addPermission(PermissionInfo permissionInfo) {
            try {
                boolean bl = this.mPM.addPermission(permissionInfo);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public boolean addPermissionAsync(PermissionInfo permissionInfo) {
            try {
                boolean bl = this.mPM.addPermissionAsync(permissionInfo);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
            try {
                this.mPM.addPreferredActivity(intentFilter, n, componentNameArray, componentName);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] canonicalToCurrentPackageNames(String[] stringArray) {
            try {
                String[] stringArray2 = this.mPM.canonicalToCurrentPackageNames(stringArray);
                return stringArray2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkPermission(String string2, String string3) {
            try {
                int n = this.mPM.checkPermission(string2, string3);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkSignatures(int n, int n2) {
            try {
                int n3 = this.mPM.checkUidSignatures(n, n2);
                return n3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int checkSignatures(String string2, String string3) {
            try {
                int n = this.mPM.checkSignatures(string2, string3);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.clearApplicationUserData(string2, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void clearPackagePreferredActivities(String string2) {
            try {
                this.mPM.clearPackagePreferredActivities(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] currentToCanonicalPackageNames(String[] stringArray) {
            try {
                String[] stringArray2 = this.mPM.currentToCanonicalPackageNames(stringArray);
                return stringArray2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.deleteApplicationCacheFiles(string2, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void deletePackage(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n) {
            try {
                this.mPM.deletePackage(string2, iPackageDeleteObserver, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void freeStorage(long l, IntentSender intentSender) {
            try {
                this.mPM.freeStorage(l, intentSender);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void freeStorageAndNotify(long l, IPackageDataObserver iPackageDataObserver) {
            try {
                this.mPM.freeStorageAndNotify(l, iPackageDataObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public Drawable getActivityIcon(ComponentName componentName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(componentName, 0).loadIcon(this);
        }

        @Override
        public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                return this.getActivityIcon(intent.getComponent());
            }
            ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
            if (resolveInfo != null) {
                return resolveInfo.activityInfo.loadIcon(this);
            }
            throw new PackageManager.NameNotFoundException(intent.toURI());
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo activityInfo = this.mPM.getActivityInfo(componentName, n);
                if (activityInfo != null) {
                    return activityInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(componentName.toString());
        }

        @Override
        public Drawable getActivityLogo(ComponentName componentName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(componentName, 0).loadLogo(this);
        }

        @Override
        public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                return this.getActivityLogo(intent.getComponent());
            }
            ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
            if (resolveInfo != null) {
                return resolveInfo.activityInfo.loadLogo(this);
            }
            throw new PackageManager.NameNotFoundException(intent.toUri(0));
        }

        @Override
        public List<PermissionGroupInfo> getAllPermissionGroups(int n) {
            try {
                List<PermissionGroupInfo> list = this.mPM.getAllPermissionGroups(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int getApplicationEnabledSetting(String string2) {
            try {
                int n = this.mPM.getApplicationEnabledSetting(string2);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public Drawable getApplicationIcon(ApplicationInfo applicationInfo) {
            return applicationInfo.loadIcon(this);
        }

        @Override
        public Drawable getApplicationIcon(String string2) throws PackageManager.NameNotFoundException {
            return this.getApplicationIcon(this.getApplicationInfo(string2, 0));
        }

        @Override
        public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                ApplicationInfo applicationInfo = this.mPM.getApplicationInfo(string2, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
            return applicationInfo.loadLabel(this);
        }

        @Override
        public Drawable getApplicationLogo(ApplicationInfo applicationInfo) {
            return applicationInfo.loadLogo(this);
        }

        @Override
        public Drawable getApplicationLogo(String string2) throws PackageManager.NameNotFoundException {
            return this.getApplicationLogo(this.getApplicationInfo(string2, 0));
        }

        @Override
        public int getComponentEnabledSetting(ComponentName componentName) {
            try {
                int n = this.mPM.getComponentEnabledSetting(componentName);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public Drawable getDefaultActivityIcon() {
            return Resources.getSystem().getDrawable(17301651);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable getDrawable(String string2, int n, ApplicationInfo applicationInfo) {
            ResourceName resourceName = new ResourceName(string2, n);
            Drawable drawable2 = this.getCachedIcon(resourceName);
            if (drawable2 != null) {
                return drawable2;
            }
            if (applicationInfo == null) {
                ApplicationInfo applicationInfo2;
                applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 0);
            }
            Drawable drawable3 = this.getResourcesForApplication(applicationInfo).getDrawable(n);
            this.putCachedIcon(resourceName, drawable3);
            return drawable3;
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w("PackageManager", "Failure retrieving resources for" + applicationInfo.packageName);
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
                return null;
            }
        }

        @Override
        public List<ApplicationInfo> getInstalledApplications(int n) {
            try {
                List<ApplicationInfo> list = this.mPM.getInstalledApplications(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<PackageInfo> getInstalledPackages(int n) {
            try {
                List<PackageInfo> list = this.mPM.getInstalledPackages(n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public String getInstallerPackageName(String string2) {
            try {
                String string3 = this.mPM.getInstallerPackageName(string2);
                return string3;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        @Override
        public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                InstrumentationInfo instrumentationInfo = this.mPM.getInstrumentationInfo(componentName, n);
                if (instrumentationInfo != null) {
                    return instrumentationInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(componentName.toString());
        }

        @Override
        public Intent getLaunchIntentForPackage(String string2) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.INFO");
            intent.setPackage(string2);
            ResolveInfo resolveInfo = this.resolveActivity(intent, 0);
            if (resolveInfo == null) {
                intent.removeCategory("android.intent.category.INFO");
                intent.addCategory("android.intent.category.LAUNCHER");
                intent.setPackage(string2);
                resolveInfo = this.resolveActivity(intent, 0);
            }
            if (resolveInfo == null) {
                return null;
            }
            Intent intent2 = new Intent("android.intent.action.MAIN");
            intent2.setClassName(string2, resolveInfo.activityInfo.name);
            intent2.setFlags(0x10000000);
            return intent2;
        }

        @Override
        public String getNameForUid(int n) {
            try {
                String string2 = this.mPM.getNameForUid(n);
                return string2;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public int[] getPackageGids(String string2) throws PackageManager.NameNotFoundException {
            block5: {
                int[] nArray;
                block4: {
                    try {
                        nArray = this.mPM.getPackageGids(string2);
                        if (nArray == null) break block4;
                    }
                    catch (RemoteException remoteException) {
                        throw new RuntimeException("Package manager has died", remoteException);
                    }
                    int n = nArray.length;
                    if (n <= 0) break block5;
                }
                return nArray;
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PackageInfo packageInfo = this.mPM.getPackageInfo(string2, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        public void getPackageSizeInfo(String string2, IPackageStatsObserver iPackageStatsObserver) {
            try {
                this.mPM.getPackageSizeInfo(string2, iPackageStatsObserver);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public String[] getPackagesForUid(int n) {
            try {
                String[] stringArray = this.mPM.getPackagesForUid(n);
                return stringArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PermissionGroupInfo permissionGroupInfo = this.mPM.getPermissionGroupInfo(string2, n);
                if (permissionGroupInfo != null) {
                    return permissionGroupInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public PermissionInfo getPermissionInfo(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                PermissionInfo permissionInfo = this.mPM.getPermissionInfo(string2, n);
                if (permissionInfo != null) {
                    return permissionInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) {
            try {
                int n = this.mPM.getPreferredActivities(list, list2, string2);
                return n;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public List<PackageInfo> getPreferredPackages(int n) {
            try {
                List<PackageInfo> list = this.mPM.getPreferredPackages(n);
                return list;
            }
            catch (RemoteException remoteException) {
                return new ArrayList<PackageInfo>();
            }
        }

        @Override
        public ProviderInfo getProviderInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ProviderInfo providerInfo = this.mPM.getProviderInfo(componentName, n);
                if (providerInfo != null) {
                    return providerInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(componentName.toString());
        }

        @Override
        public ActivityInfo getReceiverInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo activityInfo = this.mPM.getReceiverInfo(componentName, n);
                if (activityInfo != null) {
                    return activityInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(componentName.toString());
        }

        @Override
        public Resources getResourcesForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
            return this.getResourcesForApplication(this.getActivityInfo((ComponentName)componentName, (int)0).applicationInfo);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
            if (applicationInfo.packageName.equals("system")) {
                return this.mContext.mMainThread.getSystemContext().getResources();
            }
            ActivityThread activityThread = this.mContext.mMainThread;
            String string2 = applicationInfo.uid == Process.myUid() ? applicationInfo.sourceDir : applicationInfo.publicSourceDir;
            Resources resources = activityThread.getTopLevelResources(string2, this.mContext.mPackageInfo);
            if (resources != null) {
                return resources;
            }
            throw new PackageManager.NameNotFoundException("Unable to open " + applicationInfo.publicSourceDir);
        }

        @Override
        public Resources getResourcesForApplication(String string2) throws PackageManager.NameNotFoundException {
            return this.getResourcesForApplication(this.getApplicationInfo(string2, 0));
        }

        @Override
        public ServiceInfo getServiceInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
            try {
                ServiceInfo serviceInfo = this.mPM.getServiceInfo(componentName, n);
                if (serviceInfo != null) {
                    return serviceInfo;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(componentName.toString());
        }

        @Override
        public FeatureInfo[] getSystemAvailableFeatures() {
            try {
                FeatureInfo[] featureInfoArray = this.mPM.getSystemAvailableFeatures();
                return featureInfoArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public String[] getSystemSharedLibraryNames() {
            try {
                String[] stringArray = this.mPM.getSystemSharedLibraryNames();
                return stringArray;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CharSequence getText(String string2, int n, ApplicationInfo applicationInfo) {
            ResourceName resourceName = new ResourceName(string2, n);
            CharSequence charSequence = this.getCachedString(resourceName);
            if (charSequence != null) {
                return charSequence;
            }
            if (applicationInfo == null) {
                ApplicationInfo applicationInfo2;
                applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 0);
            }
            CharSequence charSequence2 = this.getResourcesForApplication(applicationInfo).getText(n);
            this.putCachedString(resourceName, charSequence2);
            return charSequence2;
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w("PackageManager", "Failure retrieving resources for" + applicationInfo.packageName);
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
                return null;
            }
        }

        public int getUidForSharedUser(String string2) throws PackageManager.NameNotFoundException {
            try {
                int n = this.mPM.getUidForSharedUser(string2);
                if (n != -1) {
                    return n;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException("No shared userid for user:" + string2);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XmlResourceParser getXml(String string2, int n, ApplicationInfo applicationInfo) {
            if (applicationInfo == null) {
                ApplicationInfo applicationInfo2;
                applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 0);
            }
            return this.getResourcesForApplication(applicationInfo).getXml(n);
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w("PackageManager", "Failure retrieving resources for" + applicationInfo.packageName);
                return null;
            }
        }

        @Override
        public boolean hasSystemFeature(String string2) {
            try {
                boolean bl = this.mPM.hasSystemFeature(string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        public void installPackage(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2) {
            try {
                this.mPM.installPackage(uri, iPackageInstallObserver, n, string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isSafeMode() {
            try {
                int n;
                if (this.mCachedSafeMode < 0) {
                    int n2 = this.mPM.isSafeMode() ? 1 : 0;
                    this.mCachedSafeMode = n2;
                }
                return (n = this.mCachedSafeMode) != 0;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        public void movePackage(String string2, IPackageMoveObserver iPackageMoveObserver, int n) {
            try {
                this.mPM.movePackage(string2, iPackageMoveObserver, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int n) {
            try {
                List<ResolveInfo> list = this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) {
            try {
                List<ProviderInfo> list = this.mPM.queryContentProviders(string2, n, n2);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<InstrumentationInfo> queryInstrumentation(String string2, int n) {
            try {
                List<InstrumentationInfo> list = this.mPM.queryInstrumentation(string2, n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivities(Intent intent, int n) {
            try {
                List<ResolveInfo> list = this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, Intent intent, int n) {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            String[] stringArray = null;
            if (intentArray != null) {
                int n2 = intentArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string2;
                    Intent intent2 = intentArray[i];
                    if (intent2 == null || (string2 = intent2.resolveTypeIfNeeded(contentResolver)) == null) continue;
                    if (stringArray == null) {
                        stringArray = new String[n2];
                    }
                    stringArray[i] = string2;
                }
            }
            try {
                List<ResolveInfo> list = this.mPM.queryIntentActivityOptions(componentName, intentArray, stringArray, intent, intent.resolveTypeIfNeeded(contentResolver), n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentServices(Intent intent, int n) {
            try {
                List<ResolveInfo> list = this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n);
                return list;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws PackageManager.NameNotFoundException {
            try {
                List<PermissionInfo> list = this.mPM.queryPermissionsByGroup(string2, n);
                if (list != null) {
                    return list;
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            throw new PackageManager.NameNotFoundException(string2);
        }

        @Override
        public void removePackageFromPreferred(String string2) {
            try {
                this.mPM.removePackageFromPreferred(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void removePermission(String string2) {
            try {
                this.mPM.removePermission(string2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
            try {
                this.mPM.replacePreferredActivity(intentFilter, n, componentNameArray, componentName);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public ResolveInfo resolveActivity(Intent intent, int n) {
            try {
                ResolveInfo resolveInfo = this.mPM.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n);
                return resolveInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public ProviderInfo resolveContentProvider(String string2, int n) {
            try {
                ProviderInfo providerInfo = this.mPM.resolveContentProvider(string2, n);
                return providerInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public ResolveInfo resolveService(Intent intent, int n) {
            try {
                ResolveInfo resolveInfo = this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n);
                return resolveInfo;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
        }

        @Override
        public void setApplicationEnabledSetting(String string2, int n, int n2) {
            try {
                this.mPM.setApplicationEnabledSetting(string2, n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void setComponentEnabledSetting(ComponentName componentName, int n, int n2) {
            try {
                this.mPM.setComponentEnabledSetting(componentName, n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        private static final class ResourceName {
            final int iconId;
            final String packageName;

            ResourceName(ApplicationInfo applicationInfo, int n) {
                this(applicationInfo.packageName, n);
            }

            ResourceName(ComponentInfo componentInfo, int n) {
                this(componentInfo.applicationInfo.packageName, n);
            }

            ResourceName(ResolveInfo resolveInfo, int n) {
                this(resolveInfo.activityInfo.applicationInfo.packageName, n);
            }

            ResourceName(String string2, int n) {
                this.packageName = string2;
                this.iconId = n;
            }

            /*
             * Enabled aggressive block sorting
             */
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ResourceName resourceName = (ResourceName)object;
                if (this.iconId != resourceName.iconId) {
                    return false;
                }
                return !(this.packageName != null ? !this.packageName.equals(resourceName.packageName) : resourceName.packageName != null);
            }

            public int hashCode() {
                return 31 * this.packageName.hashCode() + this.iconId;
            }

            public String toString() {
                return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
            }
        }
    }

    private static final class SharedPreferencesImpl
    implements SharedPreferences {
        private static final Object mContent = new Object();
        private final File mBackupFile;
        private int mDiskWritesInFlight = 0;
        private final File mFile;
        private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners;
        private boolean mLoaded = false;
        private Map<String, Object> mMap;
        private final int mMode;
        private long mStatSize;
        private long mStatTimestamp;
        private final Object mWritingToDiskLock = new Object();

        /*
         * Enabled aggressive block sorting
         */
        SharedPreferencesImpl(File file, int n, Map hashMap) {
            this.mFile = file;
            this.mBackupFile = ContextImpl.makeBackupFile(file);
            this.mMode = n;
            boolean bl = hashMap != null;
            this.mLoaded = bl;
            HashMap<String, Object> hashMap2 = hashMap != null ? hashMap : new HashMap();
            this.mMap = hashMap2;
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            if (FileUtils.getFileStatus(file.getPath(), fileStatus)) {
                this.mStatTimestamp = fileStatus.mtime;
            }
            this.mListeners = new WeakHashMap();
        }

        static /* synthetic */ int access$308(SharedPreferencesImpl sharedPreferencesImpl) {
            int n = sharedPreferencesImpl.mDiskWritesInFlight;
            sharedPreferencesImpl.mDiskWritesInFlight = n + 1;
            return n;
        }

        static /* synthetic */ int access$310(SharedPreferencesImpl sharedPreferencesImpl) {
            int n = sharedPreferencesImpl.mDiskWritesInFlight;
            sharedPreferencesImpl.mDiskWritesInFlight = n - 1;
            return n;
        }

        static /* synthetic */ Map access$402(SharedPreferencesImpl sharedPreferencesImpl, Map map) {
            sharedPreferencesImpl.mMap = map;
            return map;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static FileOutputStream createFileOutputStream(File file) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                return fileOutputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                File file2 = file.getParentFile();
                if (!file2.mkdir()) {
                    Log.e(ContextImpl.TAG, "Couldn't create directory for SharedPreferences file " + file);
                    return null;
                }
                FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    return fileOutputStream;
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    Log.e(ContextImpl.TAG, "Couldn't create SharedPreferences file " + file, fileNotFoundException2);
                    return null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void enqueueDiskWrite(final MemoryCommitResult memoryCommitResult, final Runnable runnable) {
            Runnable runnable2 = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                    // MONITORENTER : object
                    SharedPreferencesImpl.this.writeToFile(memoryCommitResult);
                    // MONITOREXIT : object
                    SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                    // MONITORENTER : sharedPreferencesImpl
                    SharedPreferencesImpl.access$310(SharedPreferencesImpl.this);
                    // MONITOREXIT : sharedPreferencesImpl
                    if (runnable == null) return;
                    runnable.run();
                }
            };
            boolean bl = runnable == null;
            if (bl) {
                // MONITORENTER : this
                boolean bl2 = this.mDiskWritesInFlight == 1;
                // MONITOREXIT : this
                if (bl2) {
                    runnable2.run();
                    return;
                }
            }
            QueuedWork.singleThreadExecutor().execute(runnable2);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeToFile(MemoryCommitResult memoryCommitResult) {
            block16: {
                if (this.mFile.exists()) {
                    if (!memoryCommitResult.changesMade) {
                        memoryCommitResult.setDiskWriteResult(true);
                        return;
                    }
                    if (!this.mBackupFile.exists()) {
                        if (!this.mFile.renameTo(this.mBackupFile)) {
                            Log.e(ContextImpl.TAG, "Couldn't rename file " + this.mFile + " to backup file " + this.mBackupFile);
                            memoryCommitResult.setDiskWriteResult(false);
                            return;
                        }
                    } else {
                        this.mFile.delete();
                    }
                }
                FileOutputStream fileOutputStream = SharedPreferencesImpl.createFileOutputStream(this.mFile);
                if (fileOutputStream == null) {
                    memoryCommitResult.setDiskWriteResult(false);
                    return;
                }
                XmlUtils.writeMapXml(memoryCommitResult.mapToWriteToDisk, fileOutputStream);
                FileUtils.sync(fileOutputStream);
                fileOutputStream.close();
                ContextImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
                FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
                if (!FileUtils.getFileStatus(this.mFile.getPath(), fileStatus)) break block16;
                synchronized (this) {
                    this.mStatTimestamp = fileStatus.mtime;
                    this.mStatSize = fileStatus.size;
                }
            }
            try {
                this.mBackupFile.delete();
                memoryCommitResult.setDiskWriteResult(true);
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                block17: {
                    Log.w(ContextImpl.TAG, "writeToFile: Got exception:", xmlPullParserException);
                    break block17;
                    catch (IOException iOException) {
                        Log.w(ContextImpl.TAG, "writeToFile: Got exception:", iOException);
                    }
                }
                if (this.mFile.exists() && !this.mFile.delete()) {
                    Log.e(ContextImpl.TAG, "Couldn't clean up partially-written file " + this.mFile);
                }
                memoryCommitResult.setDiskWriteResult(false);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean contains(String string2) {
            synchronized (this) {
                return this.mMap.containsKey(string2);
            }
        }

        @Override
        public SharedPreferences.Editor edit() {
            return new EditorImpl();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<String, ?> getAll() {
            synchronized (this) {
                return new HashMap<String, Object>(this.mMap);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean getBoolean(String string2, boolean bl) {
            synchronized (this) {
                Boolean bl2 = (Boolean)this.mMap.get(string2);
                if (bl2 == null) return bl;
                return bl2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public float getFloat(String string2, float f) {
            synchronized (this) {
                Float f2 = (Float)this.mMap.get(string2);
                if (f2 == null) return f;
                return f2.floatValue();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getInt(String string2, int n) {
            synchronized (this) {
                Integer n2 = (Integer)this.mMap.get(string2);
                if (n2 == null) return n;
                return n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long getLong(String string2, long l) {
            synchronized (this) {
                Long l2 = (Long)this.mMap.get(string2);
                if (l2 == null) return l;
                return l2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getString(String string2, String string3) {
            synchronized (this) {
                String string4 = (String)this.mMap.get(string2);
                if (string4 == null) return string3;
                return string4;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasFileChangedUnexpectedly() {
            synchronized (this) {
                if (this.mDiskWritesInFlight > 0) {
                    return false;
                }
            }
            FileUtils.FileStatus fileStatus = new FileUtils.FileStatus();
            if (!FileUtils.getFileStatus(this.mFile.getPath(), fileStatus)) {
                return true;
            }
            synchronized (this) {
                if (this.mStatTimestamp != fileStatus.mtime) return true;
                if (this.mStatSize == fileStatus.size) return false;
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isLoaded() {
            synchronized (this) {
                return this.mLoaded;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            synchronized (this) {
                this.mListeners.put(onSharedPreferenceChangeListener, mContent);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void replace(Map map, FileUtils.FileStatus fileStatus) {
            synchronized (this) {
                this.mLoaded = true;
                if (map != null) {
                    this.mMap = map;
                }
                if (fileStatus != null) {
                    this.mStatTimestamp = fileStatus.mtime;
                    this.mStatSize = fileStatus.size;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            synchronized (this) {
                this.mListeners.remove(onSharedPreferenceChangeListener);
                return;
            }
        }

        public final class EditorImpl
        implements SharedPreferences.Editor {
            private boolean mClear = false;
            private final Map<String, Object> mModified = Maps.newHashMap();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private MemoryCommitResult commitToMemory() {
                MemoryCommitResult memoryCommitResult = new MemoryCommitResult();
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                synchronized (sharedPreferencesImpl) {
                    if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                        SharedPreferencesImpl.access$402(SharedPreferencesImpl.this, new HashMap(SharedPreferencesImpl.this.mMap));
                    }
                    memoryCommitResult.mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                    SharedPreferencesImpl.access$308(SharedPreferencesImpl.this);
                    boolean bl = SharedPreferencesImpl.this.mListeners.size() > 0;
                    if (bl) {
                        memoryCommitResult.keysModified = new ArrayList<String>();
                        memoryCommitResult.listeners = new HashSet(SharedPreferencesImpl.this.mListeners.keySet());
                    }
                    synchronized (this) {
                        if (this.mClear) {
                            if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                                memoryCommitResult.changesMade = true;
                                SharedPreferencesImpl.this.mMap.clear();
                            }
                            this.mClear = false;
                        }
                        Iterator<Map.Entry<String, Object>> iterator = this.mModified.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.mModified.clear();
                                return memoryCommitResult;
                            }
                            Map.Entry<String, Object> entry = iterator.next();
                            String string2 = entry.getKey();
                            Object object = entry.getValue();
                            if (object == this) {
                                if (!SharedPreferencesImpl.this.mMap.containsKey(string2)) continue;
                                SharedPreferencesImpl.this.mMap.remove(string2);
                            } else {
                                Object v;
                                if (SharedPreferencesImpl.this.mMap.containsKey(string2) && (v = SharedPreferencesImpl.this.mMap.get(string2)) != null && v.equals(object)) continue;
                                SharedPreferencesImpl.this.mMap.put(string2, object);
                            }
                            memoryCommitResult.changesMade = true;
                            if (!bl) continue;
                            memoryCommitResult.keysModified.add(string2);
                        }
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            private void notifyListeners(final MemoryCommitResult memoryCommitResult) {
                if (memoryCommitResult.listeners != null && memoryCommitResult.keysModified != null && memoryCommitResult.keysModified.size() != 0) {
                    if (Looper.myLooper() != Looper.getMainLooper()) {
                        ActivityThread.sMainThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                EditorImpl.this.notifyListeners(memoryCommitResult);
                            }
                        });
                        return;
                    }
                    for (int i = memoryCommitResult.keysModified.size() - 1; i >= 0; --i) {
                        String string2 = memoryCommitResult.keysModified.get(i);
                        for (SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener : memoryCommitResult.listeners) {
                            if (onSharedPreferenceChangeListener == null) continue;
                            onSharedPreferenceChangeListener.onSharedPreferenceChanged(SharedPreferencesImpl.this, string2);
                        }
                    }
                }
            }

            @Override
            public void apply() {
                final MemoryCommitResult memoryCommitResult = this.commitToMemory();
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            memoryCommitResult.writtenToDiskLatch.await();
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                };
                QueuedWork.add(runnable);
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        QueuedWork.remove(runnable);
                    }
                };
                SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, runnable2);
                this.notifyListeners(memoryCommitResult);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor clear() {
                synchronized (this) {
                    this.mClear = true;
                    return this;
                }
            }

            @Override
            public boolean commit() {
                MemoryCommitResult memoryCommitResult = this.commitToMemory();
                SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, null);
                try {
                    memoryCommitResult.writtenToDiskLatch.await();
                    this.notifyListeners(memoryCommitResult);
                    return memoryCommitResult.writeToDiskResult;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor putBoolean(String string2, boolean bl) {
                synchronized (this) {
                    this.mModified.put(string2, bl);
                    return this;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor putFloat(String string2, float f) {
                synchronized (this) {
                    this.mModified.put(string2, Float.valueOf(f));
                    return this;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor putInt(String string2, int n) {
                synchronized (this) {
                    this.mModified.put(string2, n);
                    return this;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor putLong(String string2, long l) {
                synchronized (this) {
                    this.mModified.put(string2, l);
                    return this;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor putString(String string2, String string3) {
                synchronized (this) {
                    this.mModified.put(string2, string3);
                    return this;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SharedPreferences.Editor remove(String string2) {
                synchronized (this) {
                    this.mModified.put(string2, this);
                    return this;
                }
            }
        }

        private static class MemoryCommitResult {
            public boolean changesMade;
            public List<String> keysModified;
            public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
            public Map<?, ?> mapToWriteToDisk;
            public volatile boolean writeToDiskResult = false;
            public final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);

            private MemoryCommitResult() {
            }

            public void setDiskWriteResult(boolean bl) {
                this.writeToDiskResult = bl;
                this.writtenToDiskLatch.countDown();
            }
        }
    }
}

