/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ServiceConnectionLeaked;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

final class LoadedApk {
    private final ActivityThread mActivityThread;
    private final String mAppDir;
    private Application mApplication;
    private final ApplicationInfo mApplicationInfo;
    private final ClassLoader mBaseClassLoader;
    private ClassLoader mClassLoader;
    int mClientCount = 0;
    CompatibilityInfo mCompatibilityInfo;
    private final String mDataDir;
    private final File mDataDirFile;
    private final boolean mIncludeCode;
    private final String mLibDir;
    final String mPackageName;
    private final HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers = new HashMap();
    private final String mResDir;
    Resources mResources;
    private final boolean mSecurityViolation;
    private final HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> mServices;
    private final String[] mSharedLibraries;
    private final HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> mUnboundServices;
    private final HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    public LoadedApk(ActivityThread activityThread, ApplicationInfo applicationInfo, ActivityThread activityThread2, ClassLoader classLoader, boolean bl, boolean bl2) {
        this.mServices = new HashMap();
        this.mUnboundServices = new HashMap();
        this.mActivityThread = activityThread;
        this.mApplicationInfo = applicationInfo;
        this.mPackageName = applicationInfo.packageName;
        this.mAppDir = applicationInfo.sourceDir;
        String string2 = applicationInfo.uid == Process.myUid() ? applicationInfo.sourceDir : applicationInfo.publicSourceDir;
        this.mResDir = string2;
        this.mSharedLibraries = applicationInfo.sharedLibraryFiles;
        this.mDataDir = applicationInfo.dataDir;
        File file = this.mDataDir != null ? new File(this.mDataDir) : null;
        this.mDataDirFile = file;
        this.mLibDir = applicationInfo.nativeLibraryDir;
        this.mBaseClassLoader = classLoader;
        this.mSecurityViolation = bl;
        this.mIncludeCode = bl2;
        this.mCompatibilityInfo = new CompatibilityInfo(applicationInfo);
        if (this.mAppDir == null) {
            if (ActivityThread.mSystemContext == null) {
                ActivityThread.mSystemContext = ContextImpl.createSystemContext(activityThread2);
                ActivityThread.mSystemContext.getResources().updateConfiguration(activityThread2.getConfiguration(), activityThread2.getDisplayMetricsLocked(false));
            }
            this.mClassLoader = ActivityThread.mSystemContext.getClassLoader();
            this.mResources = ActivityThread.mSystemContext.getResources();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public LoadedApk(ActivityThread activityThread, String string2, Context context, ApplicationInfo applicationInfo) {
        this.mServices = new HashMap();
        this.mUnboundServices = new HashMap();
        this.mActivityThread = activityThread;
        ApplicationInfo applicationInfo2 = applicationInfo != null ? applicationInfo : new ApplicationInfo();
        this.mApplicationInfo = applicationInfo2;
        this.mApplicationInfo.packageName = string2;
        this.mPackageName = string2;
        this.mAppDir = null;
        this.mResDir = null;
        this.mSharedLibraries = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mClassLoader = context.getClassLoader();
        this.mResources = context.getResources();
        this.mCompatibilityInfo = new CompatibilityInfo(this.mApplicationInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String combineLibs(String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder(300);
        boolean bl = true;
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(':');
                }
                stringBuilder.append(string2);
            }
        }
        boolean bl2 = !bl;
        if (stringArray2 != null) {
            for (String string3 : stringArray2) {
                if (bl2 && ArrayUtils.contains(stringArray, string3)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(':');
                }
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }

    private static String[] getLibrariesFor(String string2) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = ActivityThread.getPackageManager().getApplicationInfo(string2, 1024);
            if (applicationInfo == null) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)remoteException);
        }
        return applicationInfo.sharedLibraryFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeJavaContextClassLoader() {
        boolean bl;
        PackageInfo packageInfo;
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        try {
            packageInfo = iPackageManager.getPackageInfo(this.mPackageName, 0);
            bl = packageInfo.sharedUserId != null;
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)remoteException);
        }
        boolean bl2 = packageInfo.applicationInfo != null && !this.mPackageName.equals(packageInfo.applicationInfo.processName);
        boolean bl3 = bl || bl2;
        ClassLoader classLoader = bl3 ? new WarningContextClassLoader() : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver broadcastReceiver) {
        HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverDispatcher receiverDispatcher;
            ReceiverDispatcher receiverDispatcher2;
            HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap2 = this.mReceivers.get(context);
            if (hashMap2 != null && (receiverDispatcher2 = hashMap2.get(broadcastReceiver)) != null) {
                hashMap2.remove(broadcastReceiver);
                if (hashMap2.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (!broadcastReceiver.getDebugUnregister()) return receiverDispatcher2.getIIntentReceiver();
                HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap3 = this.mUnregisteredReceivers.get(context);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap();
                    this.mUnregisteredReceivers.put(context, hashMap3);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Originally unregistered here:");
                illegalArgumentException.fillInStackTrace();
                receiverDispatcher2.setUnregisterLocation(illegalArgumentException);
                hashMap3.put(broadcastReceiver, receiverDispatcher2);
                return receiverDispatcher2.getIIntentReceiver();
            }
            HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap4 = this.mUnregisteredReceivers.get(context);
            if (hashMap4 != null && (receiverDispatcher = hashMap4.get(broadcastReceiver)) != null) {
                RuntimeException runtimeException = receiverDispatcher.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + broadcastReceiver + " that was already unregistered", runtimeException);
            }
            if (context != null) throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
            throw new IllegalStateException("Unbinding Receiver " + broadcastReceiver + " from Context that is no longer in use: " + context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection serviceConnection) {
        HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> hashMap = this.mServices;
        synchronized (hashMap) {
            ServiceDispatcher serviceDispatcher;
            ServiceDispatcher serviceDispatcher2;
            HashMap<ServiceConnection, ServiceDispatcher> hashMap2 = this.mServices.get(context);
            if (hashMap2 != null && (serviceDispatcher2 = hashMap2.get(serviceConnection)) != null) {
                hashMap2.remove(serviceConnection);
                serviceDispatcher2.doForget();
                if (hashMap2.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((2 & serviceDispatcher2.getFlags()) == 0) return serviceDispatcher2.getIServiceConnection();
                HashMap<ServiceConnection, ServiceDispatcher> hashMap3 = this.mUnboundServices.get(context);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap();
                    this.mUnboundServices.put(context, hashMap3);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Originally unbound here:");
                illegalArgumentException.fillInStackTrace();
                serviceDispatcher2.setUnbindLocation(illegalArgumentException);
                hashMap3.put(serviceConnection, serviceDispatcher2);
                return serviceDispatcher2.getIServiceConnection();
            }
            HashMap<ServiceConnection, ServiceDispatcher> hashMap4 = this.mUnboundServices.get(context);
            if (hashMap4 != null && (serviceDispatcher = hashMap4.get(serviceConnection)) != null) {
                RuntimeException runtimeException = serviceDispatcher.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + serviceConnection + " that was already unbound", runtimeException);
            }
            if (context != null) throw new IllegalArgumentException("Service not registered: " + serviceConnection);
            throw new IllegalStateException("Unbinding Service " + serviceConnection + " from Context that is no longer in use: " + context);
        }
    }

    public String getAppDir() {
        return this.mAppDir;
    }

    Application getApplication() {
        return this.mApplication;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public AssetManager getAssets(ActivityThread activityThread) {
        return this.getResources(activityThread).getAssets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader() {
        synchronized (this) {
            block9: {
                String[] stringArray;
                String string2;
                block11: {
                    String string3;
                    String string4;
                    String string5;
                    block10: {
                        if (this.mClassLoader != null) {
                            return this.mClassLoader;
                        }
                        if (!this.mIncludeCode || this.mPackageName.equals("android")) break block9;
                        string2 = this.mAppDir;
                        string5 = this.mActivityThread.mInstrumentationAppDir;
                        string4 = this.mActivityThread.mInstrumentationAppPackage;
                        string3 = this.mActivityThread.mInstrumentedAppDir;
                        if (this.mAppDir.equals(string5)) break block10;
                        boolean bl = this.mAppDir.equals(string3);
                        stringArray = null;
                        if (!bl) break block11;
                    }
                    string2 = string5 + ":" + string3;
                    boolean bl = string3.equals(string5);
                    stringArray = null;
                    if (!bl) {
                        stringArray = LoadedApk.getLibrariesFor(string4);
                    }
                }
                if (this.mSharedLibraries != null || stringArray != null) {
                    string2 = LoadedApk.combineLibs(this.mSharedLibraries, stringArray) + ':' + string2;
                }
                this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader(string2, this.mLibDir, this.mBaseClassLoader);
                this.initializeJavaContextClassLoader();
                return this.mClassLoader;
            }
            this.mClassLoader = this.mBaseClassLoader == null ? ClassLoader.getSystemClassLoader() : this.mBaseClassLoader;
            return this.mClassLoader;
        }
    }

    public String getDataDir() {
        return this.mDataDir;
    }

    public File getDataDirFile() {
        return this.mDataDirFile;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
        HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap2;
            ReceiverDispatcher receiverDispatcher;
            HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap3;
            block13: {
                void var10_14;
                block14: {
                    ReceiverDispatcher receiverDispatcher2;
                    HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap4 = null;
                    if (bl && (hashMap4 = this.mReceivers.get(context)) != null) {
                        ReceiverDispatcher receiverDispatcher3 = hashMap4.get(broadcastReceiver);
                        hashMap3 = hashMap4;
                        receiverDispatcher2 = receiverDispatcher3;
                    } else {
                        hashMap3 = hashMap4;
                        receiverDispatcher2 = null;
                    }
                    if (receiverDispatcher2 == null) {
                        receiverDispatcher = new ReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, bl);
                        if (!bl) return receiverDispatcher.getIIntentReceiver();
                        if (hashMap3 != null) break block13;
                        hashMap2 = new HashMap();
                        this.mReceivers.put(context, hashMap2);
                    }
                    try {
                        receiverDispatcher2.validate(context, handler);
                    }
                    catch (Throwable throwable) {
                    }
                    receiverDispatcher = receiverDispatcher2;
                    return receiverDispatcher.getIIntentReceiver();
                    break block14;
                    finally {
                    }
                }
                throw var10_14;
            }
            hashMap2 = hashMap3;
            hashMap2.put(broadcastReceiver, receiverDispatcher);
            return receiverDispatcher.getIIntentReceiver();
        }
    }

    public String getResDir() {
        return this.mResDir;
    }

    public Resources getResources(ActivityThread activityThread) {
        if (this.mResources == null) {
            this.mResources = activityThread.getTopLevelResources(this.mResDir, this);
        }
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IServiceConnection getServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
        HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> hashMap = this.mServices;
        synchronized (hashMap) {
            ServiceDispatcher serviceDispatcher;
            ServiceDispatcher serviceDispatcher2;
            HashMap<ServiceConnection, ServiceDispatcher> hashMap2 = this.mServices.get(context);
            ServiceDispatcher serviceDispatcher3 = hashMap2 != null ? (serviceDispatcher2 = hashMap2.get(serviceConnection)) : null;
            if (serviceDispatcher3 == null) {
                block8: {
                    serviceDispatcher = new ServiceDispatcher(serviceConnection, context, handler, n);
                    if (hashMap2 != null) break block8;
                    hashMap2 = new HashMap();
                    this.mServices.put(context, hashMap2);
                }
                hashMap2.put(serviceConnection, serviceDispatcher);
                return serviceDispatcher.getIServiceConnection();
            }
            try {
                serviceDispatcher3.validate(context, handler);
                serviceDispatcher = serviceDispatcher3;
            }
            catch (Throwable throwable) {
            }
            return serviceDispatcher.getIServiceConnection();
            throw throwable;
        }
    }

    public boolean isSecurityViolation() {
        return this.mSecurityViolation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Application makeApplication(boolean bl, Instrumentation instrumentation) {
        Application application;
        block6: {
            if (this.mApplication != null) {
                return this.mApplication;
            }
            application = null;
            String string2 = this.mApplicationInfo.className;
            if (bl || string2 == null) {
                string2 = "android.app.Application";
            }
            try {
                ClassLoader classLoader = this.getClassLoader();
                ContextImpl contextImpl = new ContextImpl();
                contextImpl.init(this, null, this.mActivityThread);
                application = this.mActivityThread.mInstrumentation.newApplication(classLoader, string2, contextImpl);
                contextImpl.setOuterContext(application);
            }
            catch (Exception exception) {
                if (this.mActivityThread.mInstrumentation.onException(application, exception)) break block6;
                throw new RuntimeException("Unable to instantiate application " + string2 + ": " + exception.toString(), exception);
            }
        }
        this.mActivityThread.mAllApplications.add(application);
        this.mApplication = application;
        if (instrumentation == null) return application;
        try {
            instrumentation.callApplicationOnCreate(application);
            return application;
        }
        catch (Exception exception) {
            if (instrumentation.onException(application, exception)) return application;
            throw new RuntimeException("Unable to create application " + application.getClass().getName() + ": " + exception.toString(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeContextRegistrations(Context context, String string2, String string3) {
        HashMap<BroadcastReceiver, ReceiverDispatcher> hashMap = this.mReceivers.remove(context);
        if (hashMap != null) {
            for (ReceiverDispatcher receiverDispatcher : hashMap.values()) {
                IntentReceiverLeaked intentReceiverLeaked = new IntentReceiverLeaked(string3 + " " + string2 + " has leaked IntentReceiver " + receiverDispatcher.getIntentReceiver() + " that was " + "originally registered here. Are you missing a " + "call to unregisterReceiver()?");
                intentReceiverLeaked.setStackTrace(receiverDispatcher.getLocation().getStackTrace());
                Slog.e("ActivityThread", intentReceiverLeaked.getMessage(), intentReceiverLeaked);
                try {
                    ActivityManagerNative.getDefault().unregisterReceiver(receiverDispatcher.getIIntentReceiver());
                }
                catch (RemoteException remoteException) {}
            }
        }
        this.mUnregisteredReceivers.remove(context);
        HashMap<ServiceConnection, ServiceDispatcher> hashMap2 = this.mServices.remove(context);
        if (hashMap2 != null) {
            for (ServiceDispatcher serviceDispatcher : hashMap2.values()) {
                ServiceConnectionLeaked serviceConnectionLeaked = new ServiceConnectionLeaked(string3 + " " + string2 + " has leaked ServiceConnection " + serviceDispatcher.getServiceConnection() + " that was originally bound here");
                serviceConnectionLeaked.setStackTrace(serviceDispatcher.getLocation().getStackTrace());
                Slog.e("ActivityThread", serviceConnectionLeaked.getMessage(), serviceConnectionLeaked);
                try {
                    ActivityManagerNative.getDefault().unbindService(serviceDispatcher.getIServiceConnection());
                }
                catch (RemoteException remoteException) {}
                serviceDispatcher.doForget();
            }
        }
        this.mUnboundServices.remove(context);
    }

    static final class ReceiverDispatcher {
        final Handler mActivityThread;
        final Context mContext;
        final IIntentReceiver.Stub mIIntentReceiver;
        final Instrumentation mInstrumentation;
        final IntentReceiverLeaked mLocation;
        final BroadcastReceiver mReceiver;
        final boolean mRegistered;
        RuntimeException mUnregisterLocation;

        /*
         * Enabled aggressive block sorting
         */
        ReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
            if (handler == null) {
                throw new NullPointerException("Handler must not be null");
            }
            boolean bl2 = !bl;
            this.mIIntentReceiver = new InnerReceiver(this, bl2);
            this.mReceiver = broadcastReceiver;
            this.mContext = context;
            this.mActivityThread = handler;
            this.mInstrumentation = instrumentation;
            this.mRegistered = bl;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        IIntentReceiver getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        BroadcastReceiver getIntentReceiver() {
            return this.mReceiver;
        }

        IntentReceiverLeaked getLocation() {
            return this.mLocation;
        }

        RuntimeException getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2) {
            Args args = new Args();
            Args.access$102(args, intent);
            Args.access$202(args, n);
            Args.access$302(args, string2);
            Args.access$402(args, bundle);
            Args.access$502(args, bl);
            Args.access$602(args, bl2);
            if (this.mActivityThread.post(args) || !this.mRegistered || !bl) return;
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            try {
                iActivityManager.finishReceiver(this.mIIntentReceiver, args.mCurCode, args.mCurData, args.mCurMap, false);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void setUnregisterLocation(RuntimeException runtimeException) {
            this.mUnregisterLocation = runtimeException;
        }

        void validate(Context context, Handler handler) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != handler) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + handler + ")");
            }
        }

        final class Args
        implements Runnable {
            private int mCurCode;
            private String mCurData;
            private Intent mCurIntent;
            private Bundle mCurMap;
            private boolean mCurOrdered;
            private boolean mCurSticky;

            Args() {
            }

            static /* synthetic */ Intent access$102(Args args, Intent intent) {
                args.mCurIntent = intent;
                return intent;
            }

            static /* synthetic */ int access$202(Args args, int n) {
                args.mCurCode = n;
                return n;
            }

            static /* synthetic */ String access$302(Args args, String string2) {
                args.mCurData = string2;
                return string2;
            }

            static /* synthetic */ Bundle access$402(Args args, Bundle bundle) {
                args.mCurMap = bundle;
                return bundle;
            }

            static /* synthetic */ boolean access$502(Args args, boolean bl) {
                args.mCurOrdered = bl;
                return bl;
            }

            static /* synthetic */ boolean access$602(Args args, boolean bl) {
                args.mCurSticky = bl;
                return bl;
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                IActivityManager iActivityManager;
                BroadcastReceiver broadcastReceiver;
                block11: {
                    broadcastReceiver = ReceiverDispatcher.this.mReceiver;
                    iActivityManager = ActivityManagerNative.getDefault();
                    Intent intent = this.mCurIntent;
                    this.mCurIntent = null;
                    if (broadcastReceiver == null) {
                        if (!ReceiverDispatcher.this.mRegistered) return;
                        if (!this.mCurOrdered) return;
                        iActivityManager.finishReceiver(ReceiverDispatcher.this.mIIntentReceiver, this.mCurCode, this.mCurData, this.mCurMap, false);
                        return;
                    }
                    try {
                        ClassLoader classLoader = ReceiverDispatcher.this.mReceiver.getClass().getClassLoader();
                        intent.setExtrasClassLoader(classLoader);
                        if (this.mCurMap != null) {
                            this.mCurMap.setClassLoader(classLoader);
                        }
                        broadcastReceiver.setOrderedHint(true);
                        broadcastReceiver.setResult(this.mCurCode, this.mCurData, this.mCurMap);
                        broadcastReceiver.clearAbortBroadcast();
                        broadcastReceiver.setOrderedHint(this.mCurOrdered);
                        broadcastReceiver.setInitialStickyHint(this.mCurSticky);
                        broadcastReceiver.onReceive(ReceiverDispatcher.this.mContext, intent);
                    }
                    catch (Exception exception) {
                        if (ReceiverDispatcher.this.mRegistered && this.mCurOrdered) {
                            try {
                                iActivityManager.finishReceiver(ReceiverDispatcher.this.mIIntentReceiver, this.mCurCode, this.mCurData, this.mCurMap, false);
                            }
                            catch (RemoteException remoteException) {}
                        }
                        if (ReceiverDispatcher.this.mInstrumentation == null) throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, exception);
                        if (ReceiverDispatcher.this.mInstrumentation.onException(ReceiverDispatcher.this.mReceiver, exception)) break block11;
                        throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, exception);
                    }
                }
                if (!ReceiverDispatcher.this.mRegistered) return;
                if (!this.mCurOrdered) return;
                try {
                    iActivityManager.finishReceiver(ReceiverDispatcher.this.mIIntentReceiver, broadcastReceiver.getResultCode(), broadcastReceiver.getResultData(), broadcastReceiver.getResultExtras(false), broadcastReceiver.getAbortBroadcast());
                    return;
                }
                catch (RemoteException remoteException) {
                    return;
                }
                catch (RemoteException remoteException) {
                    return;
                }
            }
        }

        static final class InnerReceiver
        extends IIntentReceiver.Stub {
            final WeakReference<ReceiverDispatcher> mDispatcher;
            final ReceiverDispatcher mStrongRef;

            /*
             * Enabled aggressive block sorting
             */
            InnerReceiver(ReceiverDispatcher receiverDispatcher, boolean bl) {
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(receiverDispatcher);
                ReceiverDispatcher receiverDispatcher2 = bl ? receiverDispatcher : null;
                this.mStrongRef = receiverDispatcher2;
            }

            @Override
            public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2) {
                ReceiverDispatcher receiverDispatcher = (ReceiverDispatcher)this.mDispatcher.get();
                if (receiverDispatcher != null) {
                    receiverDispatcher.performReceive(intent, n, string2, bundle, bl, bl2);
                    return;
                }
                IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                try {
                    iActivityManager.finishReceiver(this, n, string2, bundle, false);
                    return;
                }
                catch (RemoteException remoteException) {
                    Slog.w("ActivityThread", "Couldn't finish broadcast to unregistered receiver");
                    return;
                }
            }
        }
    }

    static final class ServiceDispatcher {
        private final HashMap<ComponentName, ConnectionInfo> mActiveConnections = new HashMap();
        private final Handler mActivityThread;
        private final ServiceConnection mConnection;
        private final Context mContext;
        private boolean mDied;
        private final int mFlags;
        private final InnerConnection mIServiceConnection = new InnerConnection(this);
        private final ServiceConnectionLeaked mLocation;
        private RuntimeException mUnbindLocation;

        ServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
            this.mConnection = serviceConnection;
            this.mContext = context;
            this.mActivityThread = handler;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = n;
        }

        public void connected(ComponentName componentName, IBinder iBinder) {
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(componentName, iBinder, 0));
                return;
            }
            this.doConnected(componentName, iBinder);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void death(ComponentName componentName, IBinder iBinder) {
            // MONITORENTER : this
            this.mDied = true;
            ConnectionInfo connectionInfo = this.mActiveConnections.remove(componentName);
            if (connectionInfo == null || connectionInfo.binder != iBinder) {
                // MONITOREXIT : this
                return;
            }
            connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
            // MONITOREXIT : this
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(componentName, iBinder, 1));
                return;
            }
            this.doDeath(componentName, iBinder);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doConnected(ComponentName componentName, IBinder iBinder) {
            // MONITORENTER : this
            ConnectionInfo connectionInfo = this.mActiveConnections.get(componentName);
            if (connectionInfo != null && connectionInfo.binder == iBinder) {
                // MONITOREXIT : this
                return;
            }
            if (iBinder != null) {
                this.mDied = false;
                ConnectionInfo connectionInfo2 = new ConnectionInfo();
                connectionInfo2.binder = iBinder;
                connectionInfo2.deathMonitor = new DeathMonitor(componentName, iBinder);
                try {
                    iBinder.linkToDeath(connectionInfo2.deathMonitor, 0);
                    this.mActiveConnections.put(componentName, connectionInfo2);
                }
                catch (RemoteException remoteException) {
                    this.mActiveConnections.remove(componentName);
                    // MONITOREXIT : this
                    return;
                }
            } else {
                this.mActiveConnections.remove(componentName);
            }
            if (connectionInfo != null) {
                connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
            }
            // MONITOREXIT : this
            if (connectionInfo != null) {
                this.mConnection.onServiceDisconnected(componentName);
            }
            if (iBinder == null) return;
            this.mConnection.onServiceConnected(componentName, iBinder);
        }

        public void doDeath(ComponentName componentName, IBinder iBinder) {
            this.mConnection.onServiceDisconnected(componentName);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doForget() {
            synchronized (this) {
                Iterator<ConnectionInfo> iterator = this.mActiveConnections.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.mActiveConnections.clear();
                        return;
                    }
                    ConnectionInfo connectionInfo = iterator.next();
                    connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
                }
            }
        }

        int getFlags() {
            return this.mFlags;
        }

        IServiceConnection getIServiceConnection() {
            return this.mIServiceConnection;
        }

        ServiceConnectionLeaked getLocation() {
            return this.mLocation;
        }

        ServiceConnection getServiceConnection() {
            return this.mConnection;
        }

        RuntimeException getUnbindLocation() {
            return this.mUnbindLocation;
        }

        void setUnbindLocation(RuntimeException runtimeException) {
            this.mUnbindLocation = runtimeException;
        }

        void validate(Context context, Handler handler) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != handler) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + handler + ")");
            }
        }

        private static class ConnectionInfo {
            IBinder binder;
            IBinder.DeathRecipient deathMonitor;

            private ConnectionInfo() {
            }
        }

        private final class DeathMonitor
        implements IBinder.DeathRecipient {
            final ComponentName mName;
            final IBinder mService;

            DeathMonitor(ComponentName componentName, IBinder iBinder) {
                this.mName = componentName;
                this.mService = iBinder;
            }

            @Override
            public void binderDied() {
                ServiceDispatcher.this.death(this.mName, this.mService);
            }
        }

        private static class InnerConnection
        extends IServiceConnection.Stub {
            final WeakReference<ServiceDispatcher> mDispatcher;

            InnerConnection(ServiceDispatcher serviceDispatcher) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(serviceDispatcher);
            }

            @Override
            public void connected(ComponentName componentName, IBinder iBinder) throws RemoteException {
                ServiceDispatcher serviceDispatcher = (ServiceDispatcher)this.mDispatcher.get();
                if (serviceDispatcher != null) {
                    serviceDispatcher.connected(componentName, iBinder);
                }
            }
        }

        private final class RunConnection
        implements Runnable {
            final int mCommand;
            final ComponentName mName;
            final IBinder mService;

            RunConnection(ComponentName componentName, IBinder iBinder, int n) {
                this.mName = componentName;
                this.mService = iBinder;
                this.mCommand = n;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                if (this.mCommand == 0) {
                    ServiceDispatcher.this.doConnected(this.mName, this.mService);
                    return;
                } else {
                    if (this.mCommand != 1) return;
                    ServiceDispatcher.this.doDeath(this.mName, this.mService);
                    return;
                }
            }
        }
    }

    private static class WarningContextClassLoader
    extends ClassLoader {
        private static boolean warned = false;

        private WarningContextClassLoader() {
        }

        private void warn(String string2) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + string2 + ": " + "The class loader returned by " + "Thread.getContextClassLoader() may fail for processes " + "that host multiple applications. You should explicitly " + "specify a context class loader. For example: " + "Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        @Override
        public void clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }

        @Override
        public URL getResource(String string2) {
            this.warn("getResource");
            return this.getParent().getResource(string2);
        }

        @Override
        public InputStream getResourceAsStream(String string2) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(string2);
        }

        @Override
        public Enumeration<URL> getResources(String string2) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(string2);
        }

        @Override
        public Class<?> loadClass(String string2) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(string2);
        }

        @Override
        public void setClassAssertionStatus(String string2, boolean bl) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(string2, bl);
        }

        @Override
        public void setDefaultAssertionStatus(boolean bl) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(bl);
        }

        @Override
        public void setPackageAssertionStatus(String string2, boolean bl) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(string2, bl);
        }
    }
}

