/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class QueuedWork {
    private static final ConcurrentLinkedQueue<Runnable> sPendingWorkFinishers = new ConcurrentLinkedQueue();
    private static ExecutorService sSingleThreadExecutor = null;

    public static void add(Runnable runnable) {
        sPendingWorkFinishers.add(runnable);
    }

    public static void remove(Runnable runnable) {
        sPendingWorkFinishers.remove(runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExecutorService singleThreadExecutor() {
        synchronized (QueuedWork.class) {
            if (sSingleThreadExecutor != null) return sSingleThreadExecutor;
            sSingleThreadExecutor = Executors.newSingleThreadExecutor();
            return sSingleThreadExecutor;
        }
    }

    public static void waitToFinish() {
        Runnable runnable;
        while ((runnable = sPendingWorkFinishers.poll()) != null) {
            runnable.run();
        }
    }
}

