/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.PendingIntent;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.app.SuggestionsAdapter;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SearchDialog
extends Dialog
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    private static final boolean DBG = false;
    private static final boolean DBG_LOG_TIMING = false;
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final String INSTANCE_KEY_APPDATA = "data";
    private static final String INSTANCE_KEY_COMPONENT = "comp";
    private static final String INSTANCE_KEY_STORED_APPDATA = "sData";
    private static final String INSTANCE_KEY_USER_QUERY = "uQry";
    private static final String LOG_TAG = "SearchDialog";
    private static final boolean REWRITE_QUERIES = true;
    private static final int SEARCH_PLATE_LEFT_PADDING_GLOBAL = 12;
    private static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private Context mActivityContext;
    private ImageView mAppIcon;
    private Bundle mAppSearchData;
    private TextView mBadgeLabel;
    View.OnKeyListener mButtonsKeyListener;
    private BroadcastReceiver mConfChangeListener;
    private Button mGoButton;
    View.OnClickListener mGoButtonClickListener;
    private String mInitialQuery;
    private AtomicLong mLastLogTime;
    private ComponentName mLaunchComponent;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache = new WeakHashMap();
    private SearchAutoComplete mSearchAutoComplete;
    private int mSearchAutoCompleteImeOptions;
    private SearchManager mSearchManager;
    private View mSearchPlate;
    private SearchableInfo mSearchable;
    private SuggestionsAdapter mSuggestionsAdapter;
    View.OnKeyListener mTextKeyListener;
    private TextWatcher mTextWatcher;
    private String mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    private ImageButton mVoiceButton;
    View.OnClickListener mVoiceButtonClickListener;
    private final Intent mVoiceWebSearchIntent;
    private Drawable mWorkingSpinner;

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, 16973988);
        this.mConfChangeListener = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                    SearchDialog.this.onConfigurationChanged();
                }
            }
        };
        this.mTextWatcher = new TextWatcher(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void afterTextChanged(Editable editable) {
                int n;
                if (SearchDialog.this.mSearchable == null || !SearchDialog.this.mSearchable.autoUrlDetect() || SearchDialog.this.mSearchAutoComplete.isPerformingCompletion() || (n = 2 | 0xFFFFFF00 & SearchDialog.this.mSearchAutoComplete.getImeOptions()) == SearchDialog.this.mSearchAutoCompleteImeOptions) {
                    return;
                }
                SearchDialog.access$902(SearchDialog.this, n);
                SearchDialog.this.mSearchAutoComplete.setImeOptions(n);
                SearchDialog.this.mSearchAutoComplete.setInputType(SearchDialog.this.mSearchAutoComplete.getInputType());
            }

            @Override
            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                if (SearchDialog.this.mSearchable == null) {
                    return;
                }
                if (!SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                    SearchDialog searchDialog = SearchDialog.this;
                    String string2 = charSequence == null ? "" : ((Object)charSequence).toString();
                    SearchDialog.access$202(searchDialog, string2);
                }
                SearchDialog.this.updateWidgetState();
                SearchDialog searchDialog = SearchDialog.this;
                boolean bl = SearchDialog.this.mSearchAutoComplete.isEmpty() || SearchDialog.this.isBrowserSearch() && SearchDialog.this.mInitialQuery.equals(SearchDialog.this.mUserQuery) || SearchDialog.this.mAppSearchData != null && SearchDialog.this.mAppSearchData.getBoolean("android.search.CONTEXT_IS_VOICE");
                searchDialog.updateVoiceButton(bl);
            }
        };
        this.mButtonsKeyListener = new View.OnKeyListener(){

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (SearchDialog.this.mSearchable == null) {
                    return false;
                }
                if (!keyEvent.isSystem() && n != 19 && n != 21 && n != 22 && n != 23 && SearchDialog.this.mSearchAutoComplete.requestFocus()) {
                    return SearchDialog.this.mSearchAutoComplete.dispatchKeyEvent(keyEvent);
                }
                return false;
            }
        };
        this.mGoButtonClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                if (SearchDialog.this.mSearchable == null) {
                    return;
                }
                SearchDialog.this.launchQuerySearch();
            }
        };
        this.mVoiceButtonClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onClick(View view) {
                block6: {
                    if (SearchDialog.this.mSearchable == null) {
                        return;
                    }
                    SearchableInfo searchableInfo = SearchDialog.this.mSearchable;
                    try {
                        if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                            Intent intent = SearchDialog.this.createVoiceWebSearchIntent(SearchDialog.this.mVoiceWebSearchIntent, searchableInfo);
                            SearchDialog.this.getContext().startActivity(intent);
                            break block6;
                        }
                        if (searchableInfo.getVoiceSearchLaunchRecognizer()) {
                            Intent intent = SearchDialog.this.createVoiceAppSearchIntent(SearchDialog.this.mVoiceAppSearchIntent, searchableInfo);
                            SearchDialog.this.getContext().startActivity(intent);
                        }
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.w(SearchDialog.LOG_TAG, "Could not find voice search activity");
                    }
                }
                SearchDialog.this.dismiss();
            }
        };
        this.mTextKeyListener = new View.OnKeyListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                SearchableInfo.ActionKeyInfo actionKeyInfo;
                if (SearchDialog.this.mSearchable == null) {
                    return false;
                }
                if (SearchDialog.this.mSearchAutoComplete.isPopupShowing() && SearchDialog.this.mSearchAutoComplete.getListSelection() != -1) {
                    return SearchDialog.this.onSuggestionsKey(view, n, keyEvent);
                }
                if (SearchDialog.this.mSearchAutoComplete.isEmpty()) return false;
                if (n == 66 && keyEvent.getAction() == 1) {
                    view.cancelLongPress();
                    if (SearchDialog.this.mSearchable.autoUrlDetect() && (0xFF & SearchDialog.this.mSearchAutoCompleteImeOptions) == 2) {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(SearchDialog.this.fixUrl(SearchDialog.this.mSearchAutoComplete.getText().toString())));
                        intent.setFlags(0x10000000);
                        SearchDialog.this.launchIntent(intent);
                        return true;
                    }
                    SearchDialog.this.launchQuerySearch();
                    return true;
                }
                if (keyEvent.getAction() != 0 || (actionKeyInfo = SearchDialog.this.mSearchable.findActionKey(n)) == null || actionKeyInfo.getQueryActionMsg() == null) return false;
                SearchDialog.this.launchQuerySearch(n, actionKeyInfo.getQueryActionMsg());
                return true;
            }
        };
        this.mLastLogTime = new AtomicLong(SystemClock.uptimeMillis());
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mSearchManager = searchManager;
    }

    static /* synthetic */ String access$202(SearchDialog searchDialog, String string2) {
        searchDialog.mUserQuery = string2;
        return string2;
    }

    static /* synthetic */ int access$902(SearchDialog searchDialog, int n) {
        searchDialog.mSearchAutoCompleteImeOptions = n;
        return n;
    }

    private void closeSuggestionsAdapter() {
        this.mSearchAutoComplete.setAdapter(null);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.close();
        }
        this.mSuggestionsAdapter = null;
    }

    private void createContentView() {
        this.setContentView(17367130);
        ((SearchBar)this.findViewById(16908814)).setSearchDialog(this);
        this.mBadgeLabel = (TextView)this.findViewById(0x1020210);
        this.mSearchAutoComplete = (SearchAutoComplete)this.findViewById(16908819);
        this.mAppIcon = (ImageView)this.findViewById(0x1020212);
        this.mGoButton = (Button)this.findViewById(16908820);
        this.mVoiceButton = (ImageButton)this.findViewById(16908821);
        this.mSearchPlate = this.findViewById(16908815);
        this.mWorkingSpinner = this.getContext().getResources().getDrawable(17302137);
        this.mSearchAutoComplete.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mWorkingSpinner, null);
        this.setWorking(false);
        this.mSearchAutoComplete.addTextChangedListener(this.mTextWatcher);
        this.mSearchAutoComplete.setOnKeyListener(this.mTextKeyListener);
        this.mSearchAutoComplete.setOnItemClickListener(this);
        this.mSearchAutoComplete.setOnItemSelectedListener(this);
        this.mGoButton.setOnClickListener(this.mGoButtonClickListener);
        this.mGoButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mVoiceButton.setOnClickListener(this.mVoiceButtonClickListener);
        this.mVoiceButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, String string5, int n, String string6) {
        Intent intent = new Intent(string2);
        intent.addFlags(0x10000000);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (string4 != null) {
            intent.putExtra("query", string4);
        }
        if (string3 != null) {
            intent.putExtra("intent_extra_data_key", string3);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (n != 0) {
            intent.putExtra("action_key", n);
            intent.putExtra("action_msg", string6);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent createIntentFromSuggestion(Cursor cursor, int n, String string2) {
        Uri uri;
        String string3;
        String string4;
        String string5;
        try {
            string5 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_action");
            if ("android.search.action.ZILCH".equals(string5)) {
                return null;
            }
            if (string5 == null) {
                string5 = this.mSearchable.getSuggestIntentAction();
            }
        }
        catch (RuntimeException runtimeException) {
            int n2;
            try {
                int n3;
                n2 = n3 = cursor.getPosition();
            }
            catch (RuntimeException runtimeException2) {
                n2 = -1;
            }
            Log.w(LOG_TAG, "Search Suggestions cursor at row " + n2 + " returned exception" + runtimeException.toString());
            return null;
        }
        if (string5 == null) {
            string5 = "android.intent.action.SEARCH";
        }
        if ((string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) == null) {
            string4 = this.mSearchable.getSuggestIntentData();
        }
        if (string4 != null && (string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data_id")) != null) {
            string4 = string4 + "/" + Uri.encode(string3);
        }
        Uri uri2 = string4 == null ? null : (uri = Uri.parse(string4));
        String string6 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_component");
        String string7 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        return this.createIntent(string5, uri2, SuggestionsAdapter.getColumnString(cursor, "suggest_intent_extra_data"), string7, string6, n, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceAppSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        ComponentName componentName = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.getContext(), 0, intent2, 0x40000000);
        Bundle bundle = new Bundle();
        if (this.mAppSearchData != null) {
            bundle.putBundle("app_data", this.mAppSearchData);
        }
        Intent intent3 = new Intent(intent);
        String string2 = "free_form";
        int n = 1;
        Resources resources = this.mActivityContext.getResources();
        if (searchableInfo.getVoiceLanguageModeId() != 0) {
            string2 = resources.getString(searchableInfo.getVoiceLanguageModeId());
        }
        int n2 = searchableInfo.getVoicePromptTextId();
        String string3 = null;
        if (n2 != 0) {
            string3 = resources.getString(searchableInfo.getVoicePromptTextId());
        }
        int n3 = searchableInfo.getVoiceLanguageId();
        String string4 = null;
        if (n3 != 0) {
            string4 = resources.getString(searchableInfo.getVoiceLanguageId());
        }
        if (searchableInfo.getVoiceMaxResults() != 0) {
            n = searchableInfo.getVoiceMaxResults();
        }
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string2);
        intent3.putExtra("android.speech.extra.PROMPT", string3);
        intent3.putExtra("android.speech.extra.LANGUAGE", string4);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", n);
        String string5 = componentName == null ? null : componentName.flattenToShortString();
        intent3.putExtra("calling_package", string5);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pendingIntent);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceWebSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName componentName = searchableInfo.getSearchActivity();
        String string2 = componentName == null ? null : componentName.flattenToShortString();
        intent2.putExtra("calling_package", string2);
        return intent2;
    }

    private void dbgLogTiming(String string2) {
        long l = SystemClock.uptimeMillis();
        long l2 = l - this.mLastLogTime.getAndSet(l);
        Log.d(LOG_TAG, l + " (+" + l2 + ") ticks for Search keystroke in " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doShow(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        if (!this.show(componentName, bundle)) {
            return false;
        }
        String string3 = string2 == null ? "" : string2;
        this.mInitialQuery = string3;
        this.setUserQuery(string2);
        if (bl) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String fixUrl(String string2) {
        if (string2.startsWith("http://")) return string2;
        if (string2.startsWith("https://")) {
            return string2;
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            string2 = string2.startsWith("http:/") || string2.startsWith("https:/") ? string2.replaceFirst("/", "//") : string2.replaceFirst(":", "://");
        }
        if (string2.indexOf("://") != -1) return string2;
        return "http://" + string2;
    }

    private static String getActionKeyMessage(Cursor cursor, SearchableInfo.ActionKeyInfo actionKeyInfo) {
        String string2 = actionKeyInfo.getSuggestActionMsgColumn();
        String string3 = null;
        if (string2 != null) {
            string3 = SuggestionsAdapter.getColumnString(cursor, string2);
        }
        if (string3 == null) {
            string3 = actionKeyInfo.getSuggestActionMsg();
        }
        return string3;
    }

    private boolean isBrowserSearch() {
        return this.mLaunchComponent.flattenToShortString().startsWith("com.android.browser/");
    }

    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean isOutOfBounds(View view, MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        int n3 = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return n < -n3 || n2 < -n3 || n > n3 + view.getWidth() || n2 > n3 + view.getHeight();
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            Log.i(LOG_TAG, "Starting (as ourselves) " + intent.toURI());
            this.getContext().startActivity(intent);
            this.dismiss();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onSuggestionsKey(View view, int n, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (keyEvent.getAction() == 0) {
            String string2;
            Cursor cursor;
            int n2;
            if (n == 66 || n == 84) {
                return this.launchSuggestion(this.mSearchAutoComplete.getListSelection());
            }
            if (n == 21 || n == 22) {
                int n3 = n == 21 ? 0 : this.mSearchAutoComplete.length();
                this.mSearchAutoComplete.setSelection(n3);
                this.mSearchAutoComplete.setListSelection(0);
                this.mSearchAutoComplete.clearListSelection();
                this.mSearchAutoComplete.ensureImeVisible(true);
                return true;
            }
            if (n == 19 && this.mSearchAutoComplete.getListSelection() == 0) {
                this.restoreUserQuery();
                return false;
            }
            SearchableInfo.ActionKeyInfo actionKeyInfo = this.mSearchable.findActionKey(n);
            if (actionKeyInfo != null && (actionKeyInfo.getSuggestActionMsg() != null || actionKeyInfo.getSuggestActionMsgColumn() != null) && (n2 = this.mSearchAutoComplete.getListSelection()) != -1 && (cursor = this.mSuggestionsAdapter.getCursor()).moveToPosition(n2) && (string2 = SearchDialog.getActionKeyMessage(cursor, actionKeyInfo)) != null && string2.length() > 0) {
                return this.launchSuggestion(n2, n, string2);
            }
        }
        return false;
    }

    private void restoreUserQuery() {
        this.setQuery(this.mUserQuery);
    }

    private void rewriteQueryFromSuggestion(int n) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor == null) {
            return;
        }
        if (cursor.moveToPosition(n)) {
            CharSequence charSequence = this.mSuggestionsAdapter.convertToString(cursor);
            if (charSequence != null) {
                this.setQuery(charSequence);
                return;
            }
            this.restoreUserQuery();
            return;
        }
        Log.w(LOG_TAG, "Bad suggestion position: " + n);
        this.restoreUserQuery();
    }

    private void setBrowserApplicationId(Intent intent) {
        String string2;
        Uri uri = intent.getData();
        if ("android.intent.action.VIEW".equals(intent.getAction()) && uri != null && (string2 = uri.getScheme()) != null && string2.startsWith("http")) {
            intent.putExtra("com.android.browser.application_id", uri.toString());
        }
    }

    private void setQuery(CharSequence charSequence) {
        this.mSearchAutoComplete.setText(charSequence, false);
        if (charSequence != null) {
            this.mSearchAutoComplete.setSelection(charSequence.length());
        }
    }

    private void setUserQuery(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.mUserQuery = string2;
        this.mSearchAutoComplete.setText(string2);
        this.mSearchAutoComplete.setSelection(string2.length());
    }

    private boolean show(ComponentName componentName, Bundle bundle) {
        this.mSearchable = ((SearchManager)this.mContext.getSystemService("search")).getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = bundle;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.show();
        }
        this.updateUI();
        return true;
    }

    private void updateQueryHint() {
        if (this.isShowing()) {
            SearchableInfo searchableInfo = this.mSearchable;
            String string2 = null;
            if (searchableInfo != null) {
                int n = this.mSearchable.getHintId();
                string2 = null;
                if (n != 0) {
                    string2 = this.mActivityContext.getString(n);
                }
            }
            this.mSearchAutoComplete.setHint(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSearchAppIcon() {
        Drawable drawable2;
        if (this.isBrowserSearch()) {
            this.mAppIcon.setImageResource(0);
            this.mAppIcon.setVisibility(8);
            this.mSearchPlate.setPadding(12, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
            return;
        }
        PackageManager packageManager = this.getContext().getPackageManager();
        try {
            Drawable drawable3;
            drawable2 = drawable3 = packageManager.getApplicationIcon(packageManager.getActivityInfo((ComponentName)this.mLaunchComponent, (int)0).applicationInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            drawable2 = packageManager.getDefaultActivityIcon();
            Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
        }
        this.mAppIcon.setImageDrawable(drawable2);
        this.mAppIcon.setVisibility(0);
        this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
    }

    private void updateSearchAutoComplete() {
        this.closeSuggestionsAdapter();
        this.mSearchAutoComplete.setDropDownAnimationStyle(0);
        this.mSearchAutoComplete.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(true);
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mSearchAutoComplete.setAdapter(this.mSuggestionsAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSearchBadge() {
        Drawable drawable2;
        int n = 8;
        String string2 = null;
        if (this.mSearchable.useBadgeIcon()) {
            drawable2 = this.mActivityContext.getResources().getDrawable(this.mSearchable.getIconId());
            n = 0;
        } else {
            boolean bl = this.mSearchable.useBadgeLabel();
            drawable2 = null;
            string2 = null;
            if (bl) {
                string2 = ((Object)this.mActivityContext.getResources().getText(this.mSearchable.getLabelId())).toString();
                drawable2 = null;
                n = 0;
            }
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.mBadgeLabel.setText(string2);
        this.mBadgeLabel.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSearchButton() {
        Drawable drawable2;
        String string2 = null;
        int n = this.mSearchable.getSearchButtonText();
        if (this.isBrowserSearch()) {
            drawable2 = this.getContext().getResources().getDrawable(17301897);
        } else if (n != 0) {
            string2 = this.mActivityContext.getResources().getString(n);
            drawable2 = null;
        } else {
            drawable2 = this.getContext().getResources().getDrawable(0x1080188);
            string2 = null;
        }
        this.mGoButton.setText(string2);
        this.mGoButton.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
    }

    private void updateUI() {
        block6: {
            block5: {
                if (this.mSearchable == null) break block5;
                this.mDecor.setVisibility(0);
                this.updateSearchAutoComplete();
                this.updateSearchButton();
                this.updateSearchAppIcon();
                this.updateSearchBadge();
                this.updateQueryHint();
                this.updateVoiceButton(TextUtils.isEmpty(this.mUserQuery));
                int n = this.mSearchable.getInputType();
                if ((n & 0xF) == 1) {
                    n &= 0xFFFEFFFF;
                    if (this.mSearchable.getSuggestAuthority() != null) {
                        n |= 0x10000;
                    }
                }
                this.mSearchAutoComplete.setInputType(n);
                this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
                this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
                if (!this.mSearchable.getVoiceSearchEnabled()) break block6;
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            }
            return;
        }
        this.mSearchAutoComplete.setPrivateImeOptions(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateVoiceButton(boolean bl) {
        int n = 8;
        if ((this.mAppSearchData == null || !this.mAppSearchData.getBoolean("android.search.DISABLE_VOICE_SEARCH", false)) && this.mSearchable.getVoiceSearchEnabled() && bl) {
            Intent intent;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                intent = this.mVoiceWebSearchIntent;
            } else {
                boolean bl2 = this.mSearchable.getVoiceSearchLaunchRecognizer();
                intent = null;
                if (bl2) {
                    intent = this.mVoiceAppSearchIntent;
                }
            }
            if (intent != null && this.getContext().getPackageManager().resolveActivity(intent, 65536) != null) {
                n = 0;
            }
        }
        this.mVoiceButton.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateWidgetState() {
        boolean bl = !this.mSearchAutoComplete.isEmpty();
        if (!this.isBrowserSearch()) {
            this.mGoButton.setEnabled(bl);
            this.mGoButton.setFocusable(bl);
            return;
        }
        if (bl && !this.mInitialQuery.equals(this.mUserQuery)) {
            this.mSearchAutoComplete.setBackgroundResource(17302297);
            this.mGoButton.setVisibility(0);
            this.mGoButton.setEnabled(true);
            this.mGoButton.setFocusable(true);
            return;
        }
        this.mSearchAutoComplete.setBackgroundResource(17302299);
        this.mGoButton.setVisibility(8);
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    protected void launchQuerySearch(int n, String string2) {
        this.launchIntent(this.createIntent("android.intent.action.SEARCH", null, null, this.mSearchAutoComplete.getText().toString(), null, n, string2));
    }

    protected boolean launchSuggestion(int n) {
        return this.launchSuggestion(n, 0, null);
    }

    protected boolean launchSuggestion(int n, int n2, String string2) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor != null && cursor.moveToPosition(n)) {
            this.launchIntent(this.createIntentFromSuggestion(cursor, n2, string2));
            return true;
        }
        return false;
    }

    @Override
    public void onBackPressed() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null && inputMethodManager.isFullscreenMode() && inputMethodManager.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    public void onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchButton();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            this.updateQueryHint();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.ensureImeVisible(true);
            }
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Window window = this.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.width = -1;
        layoutParams.height = -1;
        layoutParams.gravity = 55;
        layoutParams.softInputMode = 16;
        window.setAttributes(layoutParams);
        this.setCanceledOnTouchOutside(true);
    }

    void onDataSetChanged() {
        if (this.mSearchAutoComplete != null && this.mSuggestionsAdapter != null) {
            this.mSearchAutoComplete.onFilterComplete(this.mSuggestionsAdapter.getCount());
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        this.launchSuggestion(n);
    }

    @Override
    public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
        this.rewriteQueryFromSuggestion(n);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKeyInfo = this.mSearchable.findActionKey(n);
        if (actionKeyInfo != null && actionKeyInfo.getQueryActionMsg() != null) {
            this.launchQuerySearch(n, actionKeyInfo.getQueryActionMsg());
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    @Override
    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        block3: {
            block2: {
                if (bundle == null) break block2;
                ComponentName componentName = (ComponentName)bundle.getParcelable(INSTANCE_KEY_COMPONENT);
                Bundle bundle2 = bundle.getBundle(INSTANCE_KEY_APPDATA);
                if (!this.doShow(bundle.getString(INSTANCE_KEY_USER_QUERY), false, componentName, bundle2)) break block3;
            }
            return;
        }
    }

    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, intentFilter);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.closeSuggestionsAdapter();
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
        this.mInitialQuery = null;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, motionEvent)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setListSelection(int n) {
        this.mSearchAutoComplete.setListSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWorking(boolean bl) {
        Drawable drawable2 = this.mWorkingSpinner;
        int n = bl ? 255 : 0;
        drawable2.setAlpha(n);
        this.mWorkingSpinner.setVisible(bl, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    public boolean show(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        boolean bl2 = this.doShow(string2, bl, componentName, bundle);
        if (bl2) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return bl2;
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        private int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        private boolean isEmpty() {
            return TextUtils.getTrimmedLength(this.getText()) == 0;
        }

        @Override
        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }

        @Override
        public void onWindowFocusChanged(boolean bl) {
            super.onWindowFocusChanged(bl);
            if (bl) {
                ((InputMethodManager)this.getContext().getSystemService("input_method")).showSoftInput(this, 0);
                if (SearchDialog.isLandscapeMode(this.getContext())) {
                    this.ensureImeVisible(true);
                }
            }
        }

        @Override
        public void performCompletion() {
        }

        @Override
        protected void replaceText(CharSequence charSequence) {
        }

        @Override
        public void setThreshold(int n) {
            super.setThreshold(n);
            this.mThreshold = n;
        }
    }

    public static class SearchBar
    extends LinearLayout {
        private SearchDialog mSearchDialog;

        public SearchBar(Context context) {
            super(context);
        }

        public SearchBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        @Override
        public boolean dispatchKeyEventPreIme(KeyEvent keyEvent) {
            KeyEvent.DispatcherState dispatcherState;
            if (this.mSearchDialog != null && keyEvent.getKeyCode() == 4 && (dispatcherState = this.getKeyDispatcherState()) != null) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    dispatcherState.startTracking(keyEvent, this);
                    return true;
                }
                if (keyEvent.getAction() == 1 && !keyEvent.isCanceled() && dispatcherState.isTracking(keyEvent)) {
                    this.mSearchDialog.onBackPressed();
                    return true;
                }
            }
            return super.dispatchKeyEventPreIme(keyEvent);
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }
    }
}

