/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.statusbar.IStatusBarService;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 1;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE_NOTIFICATION_ALERTS = 4;
    public static final int DISABLE_NOTIFICATION_ICONS = 2;
    public static final int DISABLE_NOTIFICATION_TICKER = 8;
    private Context mContext;
    private IStatusBarService mService;
    private IBinder mToken = new Binder();

    StatusBarManager(Context context) {
        this.mContext = context;
        this.mService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
    }

    public void collapse() {
        try {
            this.mService.collapse();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void disable(int n) {
        try {
            this.mService.disable(n, this.mToken, this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void expand() {
        try {
            this.mService.expand();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void removeIcon(String string2) {
        try {
            this.mService.removeIcon(string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setIcon(String string2, int n, int n2) {
        try {
            this.mService.setIcon(string2, this.mContext.getPackageName(), n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setIconVisibility(String string2, boolean bl) {
        try {
            this.mService.setIconVisibility(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }
}

