/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SearchDialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter {
    private static final boolean DBG = false;
    private static final long DELETE_KEY_POST_DELAY = 500L;
    private static final String LOG_TAG = "SuggestionsAdapter";
    static final int NONE = -1;
    private static final int QUERY_LIMIT = 50;
    private int mBackgroundColorCol;
    private SparseArray<Drawable.ConstantState> mBackgroundsCache;
    private boolean mClosed = false;
    private int mIconName1Col;
    private int mIconName2Col;
    private WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private Context mProviderContext;
    private SearchDialog mSearchDialog;
    private SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    private SearchableInfo mSearchable;
    private final Runnable mStartSpinnerRunnable;
    private final Runnable mStopSpinnerRunnable;
    private int mText1Col;
    private int mText2Col;
    private int mText2UrlCol;
    private ColorStateList mUrlColor;

    public SuggestionsAdapter(Context context, SearchDialog searchDialog, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, 17367132, null, true);
        this.mSearchDialog = searchDialog;
        this.mSearchable = searchableInfo;
        Context context2 = this.mSearchable.getActivityContext(this.mContext);
        this.mProviderContext = this.mSearchable.getProviderContext(this.mContext, context2);
        this.mOutsideDrawablesCache = weakHashMap;
        this.mBackgroundsCache = new SparseArray();
        this.mStartSpinnerRunnable = new Runnable(){

            @Override
            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(true);
            }
        };
        this.mStopSpinnerRunnable = new Runnable(){

            @Override
            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(false);
            }
        };
        this.getFilter().setDelayer(new Filter.Delayer(){
            private int mPreviousLength = 0;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long getPostingDelay(CharSequence charSequence) {
                if (charSequence == null) {
                    return 0L;
                }
                long l = charSequence.length() < this.mPreviousLength ? 500L : 0L;
                this.mPreviousLength = charSequence.length();
                return l;
            }
        });
    }

    private Drawable checkIconCache(String string2) {
        Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
        if (constantState == null) {
            return null;
        }
        return constantState.newDrawable();
    }

    private CharSequence formatUrl(CharSequence charSequence) {
        if (this.mUrlColor == null) {
            TypedValue typedValue = new TypedValue();
            this.mContext.getTheme().resolveAttribute(16843367, typedValue, true);
            this.mUrlColor = this.mContext.getResources().getColorStateList(typedValue.resourceId);
        }
        SpannableString spannableString = new SpannableString(charSequence);
        spannableString.setSpan(new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, charSequence.length(), 33);
        return spannableString;
    }

    private Drawable getActivityIcon(ComponentName componentName) {
        ActivityInfo activityInfo;
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(LOG_TAG, nameNotFoundException.toString());
            return null;
        }
        int n = activityInfo.getIconResource();
        if (n == 0) {
            return null;
        }
        Drawable drawable2 = packageManager.getDrawable(componentName.getPackageName(), n, activityInfo.applicationInfo);
        if (drawable2 == null) {
            Log.w(LOG_TAG, "Invalid icon resource " + n + " for " + componentName.flattenToShortString());
            return null;
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getActivityIconWithCache(ComponentName componentName) {
        String string2 = componentName.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(string2)) {
            Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
            if (constantState == null) {
                return null;
            }
            return constantState.newDrawable(this.mProviderContext.getResources());
        }
        Drawable drawable2 = this.getActivityIcon(componentName);
        Drawable.ConstantState constantState = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(string2, constantState);
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String string2) {
        return SuggestionsAdapter.getStringOrNull(cursor, cursor.getColumnIndex(string2));
    }

    private Drawable getDefaultIcon1(Cursor cursor) {
        Drawable drawable2;
        String string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_component");
        if (string2 != null) {
            ComponentName componentName = ComponentName.unflattenFromString(string2);
            if (componentName != null) {
                Drawable drawable3 = this.getActivityIconWithCache(componentName);
                if (drawable3 != null) {
                    return drawable3;
                }
            } else {
                Log.w(LOG_TAG, "Bad component name: " + string2);
            }
        }
        if ((drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity())) != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getDrawable(Uri uri) {
        InputStream inputStream;
        block13: {
            try {
                if ("android.resource".equals(uri.getScheme())) {
                    ContentResolver.OpenResourceIdResult openResourceIdResult = this.mProviderContext.getContentResolver().getResourceId(uri);
                    try {
                        return openResourceIdResult.r.getDrawable(openResourceIdResult.id);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        throw new FileNotFoundException("Resource does not exist: " + uri);
                    }
                }
                inputStream = this.mProviderContext.getContentResolver().openInputStream(uri);
                if (inputStream != null) break block13;
                throw new FileNotFoundException("Failed to open " + uri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w(LOG_TAG, "Icon not found: " + uri + ", " + fileNotFoundException.getMessage());
                return null;
            }
        }
        Drawable drawable2 = Drawable.createFromStream(inputStream, null);
        {
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e(LOG_TAG, "Error closing icon stream for " + uri, iOException);
                    throw throwable;
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return drawable2;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "Error closing icon stream for " + uri, iOException);
            return drawable2;
        }
    }

    private Drawable getDrawableFromResourceValue(String string2) {
        String string3;
        int n;
        block6: {
            if (string2 == null || string2.length() == 0 || "0".equals(string2)) {
                return null;
            }
            n = Integer.parseInt(string2);
            string3 = "android.resource://" + this.mProviderContext.getPackageName() + "/" + n;
            Drawable drawable2 = this.checkIconCache(string3);
            if (drawable2 == null) break block6;
            return drawable2;
        }
        try {
            Drawable drawable3 = this.mProviderContext.getResources().getDrawable(n);
            this.storeInIconCache(string3, drawable3);
            return drawable3;
        }
        catch (NumberFormatException numberFormatException) {
            Drawable drawable4 = this.checkIconCache(string2);
            if (drawable4 != null) {
                return drawable4;
            }
            Drawable drawable5 = this.getDrawable(Uri.parse(string2));
            this.storeInIconCache(string2, drawable5);
            return drawable5;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w(LOG_TAG, "Icon resource not found: " + string2);
            return null;
        }
    }

    private Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col < 0) {
            return null;
        }
        Drawable drawable2 = this.getDrawableFromResourceValue(cursor.getString(this.mIconName1Col));
        if (drawable2 != null) {
            return drawable2;
        }
        return this.getDefaultIcon1(cursor);
    }

    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col < 0) {
            return null;
        }
        return this.getDrawableFromResourceValue(cursor.getString(this.mIconName2Col));
    }

    private Drawable getItemBackground(int n) {
        if (n == 0) {
            return null;
        }
        Drawable.ConstantState constantState = this.mBackgroundsCache.get(n);
        if (constantState != null) {
            return constantState.newDrawable(this.mProviderContext.getResources());
        }
        ColorDrawable colorDrawable = new ColorDrawable(0);
        ColorDrawable colorDrawable2 = new ColorDrawable(n);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A1}, colorDrawable);
        stateListDrawable.addState(new int[]{16842919}, colorDrawable);
        stateListDrawable.addState(new int[0], colorDrawable2);
        this.mBackgroundsCache.put(n, stateListDrawable.getConstantState());
        return stateListDrawable;
    }

    private static String getStringOrNull(Cursor cursor, int n) {
        if (n == -1) {
            return null;
        }
        try {
            String string2 = cursor.getString(n);
            return string2;
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "unexpected error retrieving valid column from cursor, did the remote process die?", exception);
            return null;
        }
    }

    private void setViewDrawable(ImageView imageView, Drawable drawable2) {
        imageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            imageView.setVisibility(8);
            return;
        }
        imageView.setVisibility(0);
        drawable2.setVisible(false, false);
        drawable2.setVisible(true, false);
    }

    private void setViewText(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        if (TextUtils.isEmpty(charSequence)) {
            textView.setVisibility(8);
            return;
        }
        textView.setVisibility(0);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(string2, drawable2.getConstantState());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSpinnerState(Cursor cursor) {
        Bundle bundle = cursor != null ? cursor.getExtras() : null;
        if (bundle != null && bundle.getBoolean("in_progress")) {
            this.mSearchDialog.getWindow().getDecorView().post(this.mStartSpinnerRunnable);
            return;
        }
        this.mSearchDialog.getWindow().getDecorView().post(this.mStopSpinnerRunnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache childViewCache = (ChildViewCache)view.getTag();
        int n = this.mBackgroundColorCol;
        int n2 = 0;
        if (n != -1) {
            n2 = cursor.getInt(this.mBackgroundColorCol);
        }
        view.setBackgroundDrawable(this.getItemBackground(n2));
        if (childViewCache.mText1 != null) {
            String string2 = SuggestionsAdapter.getStringOrNull(cursor, this.mText1Col);
            this.setViewText(childViewCache.mText1, string2);
        }
        if (childViewCache.mText2 != null) {
            String string3 = SuggestionsAdapter.getStringOrNull(cursor, this.mText2UrlCol);
            CharSequence charSequence = string3 != null ? this.formatUrl(string3) : SuggestionsAdapter.getStringOrNull(cursor, this.mText2Col);
            if (TextUtils.isEmpty(charSequence)) {
                if (childViewCache.mText1 != null) {
                    childViewCache.mText1.setSingleLine(false);
                    childViewCache.mText1.setMaxLines(2);
                }
            } else if (childViewCache.mText1 != null) {
                childViewCache.mText1.setSingleLine(true);
                childViewCache.mText1.setMaxLines(1);
            }
            this.setViewText(childViewCache.mText2, charSequence);
        }
        if (childViewCache.mIcon1 != null) {
            this.setViewDrawable(childViewCache.mIcon1, this.getIcon1(cursor));
        }
        if (childViewCache.mIcon2 != null) {
            this.setViewDrawable(childViewCache.mIcon2, this.getIcon2(cursor));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeCursor(Cursor cursor) {
        if (this.mClosed) {
            Log.w(LOG_TAG, "Tried to change cursor after adapter was closed.");
            if (cursor == null) return;
            cursor.close();
            return;
        }
        try {
            super.changeCursor(cursor);
            if (cursor == null) return;
            this.mText1Col = cursor.getColumnIndex("suggest_text_1");
            this.mText2Col = cursor.getColumnIndex("suggest_text_2");
            this.mText2UrlCol = cursor.getColumnIndex("suggest_text_2_url");
            this.mIconName1Col = cursor.getColumnIndex("suggest_icon_1");
            this.mIconName2Col = cursor.getColumnIndex("suggest_icon_2");
            this.mBackgroundColorCol = cursor.getColumnIndex("suggest_background_color");
            return;
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "error changing cursor and caching columns", exception);
            return;
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        String string2;
        String string3;
        if (cursor == null) {
            return null;
        }
        String string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (string4 != null) {
            return string4;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return string3;
        }
        if (this.mSearchable.shouldRewriteQueryFromText() && (string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1")) != null) {
            return string2;
        }
        return null;
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        try {
            View view2 = super.getView(n, view, viewGroup);
            return view2;
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Search suggestions cursor threw exception.", runtimeException);
            View view3 = this.newView(this.mContext, this.mCursor, viewGroup);
            if (view3 != null) {
                ((ChildViewCache)view3.getTag()).mText1.setText(runtimeException.toString());
            }
            return view3;
        }
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        View view = super.newView(context, cursor, viewGroup);
        view.setTag(new ChildViewCache(view));
        return view;
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mSearchDialog.onDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    @Override
    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        String string2 = charSequence == null ? "" : ((Object)charSequence).toString();
        this.mSearchDialog.getWindow().getDecorView().post(this.mStartSpinnerRunnable);
        try {
            Cursor cursor = this.mSearchManager.getSuggestions(this.mSearchable, string2, 50);
            if (cursor != null) {
                cursor.getCount();
                return cursor;
            }
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Search suggestions query threw an exception.", runtimeException);
        }
        this.mSearchDialog.getWindow().getDecorView().post(this.mStopSpinnerRunnable);
        return null;
    }

    private static final class ChildViewCache {
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final TextView mText1;
        public final TextView mText2;

        public ChildViewCache(View view) {
            this.mText1 = (TextView)view.findViewById(16908308);
            this.mText2 = (TextView)view.findViewById(16908309);
            this.mIcon1 = (ImageView)view.findViewById(16908295);
            this.mIcon2 = (ImageView)view.findViewById(16908296);
        }
    }
}

