/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public final class BluetoothAudioGateway {
    private static final boolean DBG = false;
    public static final int DEFAULT_HF_AG_CHANNEL = 10;
    public static final int DEFAULT_HS_AG_CHANNEL = 11;
    public static final int MSG_INCOMING_HANDSFREE_CONNECTION = 101;
    public static final int MSG_INCOMING_HEADSET_CONNECTION = 100;
    private static final int SELECT_WAIT_TIMEOUT = 1000;
    private static final String TAG = "BT Audio Gateway";
    private final BluetoothAdapter mAdapter;
    private Handler mCallback;
    private Thread mConnectThead;
    private String mConnectingHandsfreeAddress;
    private int mConnectingHandsfreeRfcommChannel;
    private int mConnectingHandsfreeSocketFd;
    private String mConnectingHeadsetAddress;
    private int mConnectingHeadsetRfcommChannel;
    private int mConnectingHeadsetSocketFd;
    private int mHandsfreeAgRfcommChannel = -1;
    private int mHeadsetAgRfcommChannel = -1;
    private volatile boolean mInterrupted;
    private int mNativeData;
    private int mTimeoutRemainingMs;

    static {
        BluetoothAudioGateway.classInitNative();
    }

    public BluetoothAudioGateway(BluetoothAdapter bluetoothAdapter) {
        this(bluetoothAdapter, 10, 11);
    }

    public BluetoothAudioGateway(BluetoothAdapter bluetoothAdapter, int n, int n2) {
        this.mAdapter = bluetoothAdapter;
        this.mHandsfreeAgRfcommChannel = n;
        this.mHeadsetAgRfcommChannel = n2;
        this.initializeNativeDataNative();
    }

    static /* synthetic */ boolean access$002(BluetoothAudioGateway bluetoothAudioGateway, boolean bl) {
        bluetoothAudioGateway.mInterrupted = bl;
        return bl;
    }

    static /* synthetic */ int access$102(BluetoothAudioGateway bluetoothAudioGateway, int n) {
        bluetoothAudioGateway.mConnectingHeadsetRfcommChannel = n;
        return n;
    }

    static /* synthetic */ int access$202(BluetoothAudioGateway bluetoothAudioGateway, int n) {
        bluetoothAudioGateway.mConnectingHandsfreeRfcommChannel = n;
        return n;
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native void initializeNativeDataNative();

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    private native boolean setUpListeningSocketsNative();

    private native void tearDownListeningSocketsNative();

    private native boolean waitForHandsfreeConnectNative(int var1);

    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean start(Handler handler) {
        synchronized (this) {
            block4: {
                if (this.mConnectThead != null) return true;
                this.mCallback = handler;
                this.mConnectThead = new Thread(TAG){

                    @Override
                    public void run() {
                        while (!BluetoothAudioGateway.this.mInterrupted) {
                            BluetoothAudioGateway.access$102(BluetoothAudioGateway.this, -1);
                            BluetoothAudioGateway.access$202(BluetoothAudioGateway.this, -1);
                            if (!BluetoothAudioGateway.this.waitForHandsfreeConnectNative(1000)) {
                                if (BluetoothAudioGateway.this.mTimeoutRemainingMs <= 0) continue;
                                try {
                                    Log.i(BluetoothAudioGateway.TAG, "select thread timed out, but " + BluetoothAudioGateway.this.mTimeoutRemainingMs + "ms of waiting remain.");
                                    Thread.sleep(BluetoothAudioGateway.this.mTimeoutRemainingMs);
                                }
                                catch (InterruptedException interruptedException) {
                                    Log.i(BluetoothAudioGateway.TAG, "select thread was interrupted (2), exiting");
                                    BluetoothAudioGateway.access$002(BluetoothAudioGateway.this, true);
                                }
                                continue;
                            }
                            Log.i(BluetoothAudioGateway.TAG, "connect notification!");
                            if (BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel >= 0) {
                                Log.i(BluetoothAudioGateway.TAG, "Incoming connection from headset " + BluetoothAudioGateway.this.mConnectingHeadsetAddress + " on channel " + BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel);
                                Message message = Message.obtain(BluetoothAudioGateway.this.mCallback);
                                message.what = 100;
                                message.obj = new IncomingConnectionInfo(BluetoothAudioGateway.this.mAdapter, BluetoothAudioGateway.this.mAdapter.getRemoteDevice(BluetoothAudioGateway.this.mConnectingHeadsetAddress), BluetoothAudioGateway.this.mConnectingHeadsetSocketFd, BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel);
                                message.sendToTarget();
                            }
                            if (BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel < 0) continue;
                            Log.i(BluetoothAudioGateway.TAG, "Incoming connection from handsfree " + BluetoothAudioGateway.this.mConnectingHandsfreeAddress + " on channel " + BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel);
                            Message message = Message.obtain();
                            message.setTarget(BluetoothAudioGateway.this.mCallback);
                            message.what = 101;
                            message.obj = new IncomingConnectionInfo(BluetoothAudioGateway.this.mAdapter, BluetoothAudioGateway.this.mAdapter.getRemoteDevice(BluetoothAudioGateway.this.mConnectingHandsfreeAddress), BluetoothAudioGateway.this.mConnectingHandsfreeSocketFd, BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel);
                            message.sendToTarget();
                        }
                    }
                };
                if (this.setUpListeningSocketsNative()) break block4;
                Log.e(TAG, "Could not set up listening socket, exiting");
                return false;
            }
            this.mInterrupted = false;
            this.mConnectThead.start();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        synchronized (this) {
            if (this.mConnectThead != null) {
                this.mInterrupted = true;
                try {
                    this.mConnectThead.interrupt();
                    this.mConnectThead.join();
                    this.mConnectThead = null;
                    this.mCallback = null;
                    this.tearDownListeningSocketsNative();
                }
                catch (InterruptedException interruptedException) {
                    Log.w(TAG, "Interrupted waiting for Connect Thread to join");
                }
            }
            return;
        }
    }

    public class IncomingConnectionInfo {
        public BluetoothAdapter mAdapter;
        public BluetoothDevice mRemoteDevice;
        public int mRfcommChan;
        public int mSocketFd;

        IncomingConnectionInfo(BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice, int n, int n2) {
            this.mAdapter = bluetoothAdapter;
            this.mRemoteDevice = bluetoothDevice;
            this.mSocketFd = n;
            this.mRfcommChan = n2;
        }
    }
}

