/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothPbap;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.server.BluetoothA2dpService;
import android.server.BluetoothService;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public final class BluetoothDeviceProfileState
extends HierarchicalStateMachine {
    private static final int AUTO_CONNECT_DELAY = 6000;
    public static final int AUTO_CONNECT_PROFILES = 101;
    public static final int CONNECT_A2DP_INCOMING = 4;
    public static final int CONNECT_A2DP_OUTGOING = 3;
    public static final int CONNECT_HFP_INCOMING = 2;
    public static final int CONNECT_HFP_OUTGOING = 1;
    public static final int CONNECT_OTHER_PROFILES = 103;
    private static final int CONNECT_OTHER_PROFILES_DELAY = 4000;
    private static final boolean DBG = false;
    public static final int DISCONNECT_A2DP_INCOMING = 8;
    public static final int DISCONNECT_A2DP_OUTGOING = 7;
    private static final int DISCONNECT_HFP_INCOMING = 6;
    public static final int DISCONNECT_HFP_OUTGOING = 5;
    public static final int DISCONNECT_PBAP_OUTGOING = 9;
    private static final String TAG = "BluetoothDeviceProfileState";
    public static final int TRANSITION_TO_STABLE = 102;
    public static final int UNPAIR = 100;
    private BluetoothA2dpService mA2dpService;
    private int mA2dpState;
    private BondedDevice mBondedDevice = new BondedDevice();
    private BroadcastReceiver mBroadcastReceiver;
    private Context mContext;
    private BluetoothDevice mDevice;
    private BluetoothHeadset mHeadsetService;
    private boolean mHeadsetServiceConnected;
    private int mHeadsetState;
    private IncomingA2dp mIncomingA2dp;
    private IncomingHandsfree mIncomingHandsfree;
    private OutgoingA2dp mOutgoingA2dp;
    private OutgoingHandsfree mOutgoingHandsfree = new OutgoingHandsfree();
    private BluetoothPbap mPbapService;
    private boolean mPbapServiceConnected;
    private BluetoothService mService;

    public BluetoothDeviceProfileState(Context context, String string2, BluetoothService bluetoothService, BluetoothA2dpService bluetoothA2dpService) {
        super(string2);
        this.mIncomingHandsfree = new IncomingHandsfree();
        this.mIncomingA2dp = new IncomingA2dp();
        this.mOutgoingA2dp = new OutgoingA2dp();
        this.mBroadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if (!((BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")).equals(BluetoothDeviceProfileState.this.mDevice)) return;
                if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                    intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", 0);
                    int n2 = intent.getIntExtra("android.bluetooth.headset.extra.DISCONNECT_INITIATOR", 1);
                    BluetoothDeviceProfileState.access$602(BluetoothDeviceProfileState.this, n);
                    if (n == 0 && n2 == 0) {
                        BluetoothDeviceProfileState.this.sendMessage(6);
                    }
                    if (n != 2 && n != 0) return;
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    return;
                }
                if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                    int n3 = intent.getIntExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", 0);
                    BluetoothDeviceProfileState.access$702(BluetoothDeviceProfileState.this, n);
                    if ((n3 == 2 || n3 == 4) && n == 0) {
                        BluetoothDeviceProfileState.this.sendMessage(8);
                    }
                    if (n != 2 && n != 0) return;
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    return;
                }
                if (!string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                    return;
                }
                BluetoothDeviceProfileState.this.sendMessage(102);
            }
        };
        this.mContext = context;
        this.mDevice = new BluetoothDevice(string2);
        this.mService = bluetoothService;
        this.mA2dpService = bluetoothA2dpService;
        this.addState(this.mBondedDevice);
        this.addState(this.mOutgoingHandsfree);
        this.addState(this.mIncomingHandsfree);
        this.addState(this.mIncomingA2dp);
        this.addState(this.mOutgoingA2dp);
        this.setInitialState(this.mBondedDevice);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, intentFilter);
        new HeadsetServiceListener();
        new PbapServiceListener();
    }

    static /* synthetic */ boolean access$1002(BluetoothDeviceProfileState bluetoothDeviceProfileState, boolean bl) {
        bluetoothDeviceProfileState.mHeadsetServiceConnected = bl;
        return bl;
    }

    static /* synthetic */ BluetoothPbap access$1102(BluetoothDeviceProfileState bluetoothDeviceProfileState, BluetoothPbap bluetoothPbap) {
        bluetoothDeviceProfileState.mPbapService = bluetoothPbap;
        return bluetoothPbap;
    }

    static /* synthetic */ boolean access$1202(BluetoothDeviceProfileState bluetoothDeviceProfileState, boolean bl) {
        bluetoothDeviceProfileState.mPbapServiceConnected = bl;
        return bl;
    }

    static /* synthetic */ int access$602(BluetoothDeviceProfileState bluetoothDeviceProfileState, int n) {
        bluetoothDeviceProfileState.mHeadsetState = n;
        return n;
    }

    static /* synthetic */ int access$702(BluetoothDeviceProfileState bluetoothDeviceProfileState, int n) {
        bluetoothDeviceProfileState.mA2dpState = n;
        return n;
    }

    static /* synthetic */ BluetoothHeadset access$802(BluetoothDeviceProfileState bluetoothDeviceProfileState, BluetoothHeadset bluetoothHeadset) {
        bluetoothDeviceProfileState.mHeadsetService = bluetoothHeadset;
        return bluetoothHeadset;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleConnectionOfOtherProfiles(int n) {
        switch (n) {
            case 2: {
                if (this.mA2dpService.getSinkPriority(this.mDevice) != 100 && this.mA2dpService.getSinkPriority(this.mDevice) != 1000) return;
                Message message = new Message();
                message.what = 103;
                message.arg1 = 3;
                this.sendMessageDelayed(message, 4000L);
                return;
            }
            default: {
                return;
            }
            case 4: {
                if (this.mHeadsetService.getPriority(this.mDevice) != 100 && this.mHeadsetService.getPriority(this.mDevice) != 1000) return;
                Message message = new Message();
                message.what = 103;
                message.arg1 = 1;
                this.sendMessageDelayed(message, 4000L);
                return;
            }
        }
    }

    private boolean isPhoneDocked(BluetoothDevice bluetoothDevice) {
        BluetoothDevice bluetoothDevice2;
        Intent intent = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
        return intent != null && intent.getIntExtra("android.intent.extra.DOCK_STATE", 0) != 0 && (bluetoothDevice2 = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null && bluetoothDevice.equals(bluetoothDevice2);
    }

    private void log(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cancelCommand(int n) {
        synchronized (this) {
            if (n == 1 && this.mHeadsetServiceConnected) {
                this.mHeadsetService.cancelConnectThread();
            }
            return;
        }
    }

    void deferProfileServiceMessage(int n) {
        synchronized (this) {
            Message message = new Message();
            message.what = n;
            this.deferMessage(message);
            return;
        }
    }

    BluetoothDevice getDevice() {
        return this.mDevice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processCommand(int n) {
        synchronized (this) {
            Log.i(TAG, "Processing command:" + n);
            switch (n) {
                default: {
                    Log.e(TAG, "Error: Unknown Command");
                    return false;
                }
                case 1: {
                    if (this.mHeadsetService == null) return false;
                    return this.mHeadsetService.connectHeadsetInternal(this.mDevice);
                }
                case 2: {
                    if (!this.mHeadsetServiceConnected) {
                        this.deferProfileServiceMessage(n);
                        return false;
                    } else {
                        if (this.mHeadsetState == 1) {
                            return this.mHeadsetService.acceptIncomingConnect(this.mDevice);
                        }
                        if (this.mHeadsetState != 0) return false;
                        this.handleConnectionOfOtherProfiles(n);
                        return this.mHeadsetService.createIncomingConnect(this.mDevice);
                    }
                }
                case 3: {
                    if (this.mA2dpService == null) return false;
                    return this.mA2dpService.connectSinkInternal(this.mDevice);
                }
                case 4: {
                    this.handleConnectionOfOtherProfiles(n);
                    return true;
                }
                case 5: {
                    if (!this.mHeadsetServiceConnected) {
                        this.deferProfileServiceMessage(n);
                        return false;
                    } else {
                        Message message = new Message();
                        message.what = 9;
                        this.deferMessage(message);
                        if (this.mHeadsetService.getPriority(this.mDevice) != 1000) return this.mHeadsetService.disconnectHeadsetInternal(this.mDevice);
                        this.mHeadsetService.setPriority(this.mDevice, 100);
                        return this.mHeadsetService.disconnectHeadsetInternal(this.mDevice);
                    }
                }
                case 7: {
                    if (this.mA2dpService == null) return false;
                    if (this.mA2dpService.getSinkPriority(this.mDevice) != 1000) return this.mA2dpService.disconnectSinkInternal(this.mDevice);
                    this.mA2dpService.setSinkPriority(this.mDevice, 100);
                    return this.mA2dpService.disconnectSinkInternal(this.mDevice);
                }
                case 9: {
                    if (this.mPbapServiceConnected) return this.mPbapService.disconnect();
                    this.deferProfileServiceMessage(n);
                    return false;
                }
                case 100: {
                    boolean bl = this.mService.removeBondInternal(this.mDevice.getAddress());
                    return bl;
                }
                case 6: {
                    return true;
                }
                case 8: 
            }
            return true;
        }
    }

    private class BondedDevice
    extends HierarchicalState {
        private BondedDevice() {
        }

        @Override
        protected void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering ACL Connected state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            Message message = new Message();
            message.copyFrom(BluetoothDeviceProfileState.this.getCurrentMessage());
            BluetoothDeviceProfileState.this.sendMessageAtFrontOfQueue(message);
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("ACL Connected State -> Processing Message: " + message.what);
            int n = 0;
            block12: do {
                switch (n == 0 ? message.what : n) {
                    default: {
                        return false;
                    }
                    case 1: 
                    case 5: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mOutgoingHandsfree);
                        n = 102;
                        continue block12;
                    }
                    case 2: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                        n = 102;
                        continue block12;
                    }
                    case 6: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                        n = 102;
                        continue block12;
                    }
                    case 3: 
                    case 7: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mOutgoingA2dp);
                        n = 102;
                        continue block12;
                    }
                    case 4: 
                    case 8: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                        n = 102;
                        continue block12;
                    }
                    case 9: {
                        BluetoothDeviceProfileState.this.processCommand(9);
                        n = 102;
                        continue block12;
                    }
                    case 100: {
                        if (BluetoothDeviceProfileState.this.mHeadsetState != 0) {
                            BluetoothDeviceProfileState.this.sendMessage(5);
                            BluetoothDeviceProfileState.this.deferMessage(message);
                            n = 102;
                            continue block12;
                        }
                        if (BluetoothDeviceProfileState.this.mA2dpState != 0) {
                            BluetoothDeviceProfileState.this.sendMessage(7);
                            BluetoothDeviceProfileState.this.deferMessage(message);
                            n = 102;
                            continue block12;
                        }
                        BluetoothDeviceProfileState.this.processCommand(100);
                        n = 102;
                        continue block12;
                    }
                    case 101: {
                        if (BluetoothDeviceProfileState.this.isPhoneDocked(BluetoothDeviceProfileState.this.mDevice)) return true;
                        if (!BluetoothDeviceProfileState.this.mHeadsetServiceConnected) {
                            BluetoothDeviceProfileState.this.deferMessage(message);
                        } else {
                            if (BluetoothDeviceProfileState.this.mHeadsetService.getPriority(BluetoothDeviceProfileState.this.mDevice) == 1000 && !BluetoothDeviceProfileState.this.mHeadsetService.isConnected(BluetoothDeviceProfileState.this.mDevice)) {
                                Log.i(BluetoothDeviceProfileState.TAG, "Headset:Auto Connect Profiles");
                                BluetoothDeviceProfileState.this.mHeadsetService.connectHeadset(BluetoothDeviceProfileState.this.mDevice);
                            }
                            if (BluetoothDeviceProfileState.this.mA2dpService == null) return true;
                            if (BluetoothDeviceProfileState.this.mA2dpService.getSinkPriority(BluetoothDeviceProfileState.this.mDevice) != 1000) return true;
                            if (BluetoothDeviceProfileState.this.mA2dpService.getConnectedSinks().length != 0) return true;
                            Log.i(BluetoothDeviceProfileState.TAG, "A2dp:Auto Connect Profiles");
                            BluetoothDeviceProfileState.this.mA2dpService.connectSink(BluetoothDeviceProfileState.this.mDevice);
                        }
                    }
                    case 102: {
                        return true;
                    }
                    case 103: 
                }
                break;
            } while (true);
            if (BluetoothDeviceProfileState.this.isPhoneDocked(BluetoothDeviceProfileState.this.mDevice)) return true;
            if (message.arg1 == 3) {
                if (BluetoothDeviceProfileState.this.mA2dpService == null) return true;
                if (BluetoothDeviceProfileState.this.mA2dpService.getConnectedSinks().length != 0) return true;
                Log.i(BluetoothDeviceProfileState.TAG, "A2dp:Connect Other Profiles");
                BluetoothDeviceProfileState.this.mA2dpService.connectSink(BluetoothDeviceProfileState.this.mDevice);
                return true;
            }
            if (message.arg1 != 1) return true;
            if (!BluetoothDeviceProfileState.this.mHeadsetServiceConnected) {
                BluetoothDeviceProfileState.this.deferMessage(message);
                return true;
            }
            if (BluetoothDeviceProfileState.this.mHeadsetService.isConnected(BluetoothDeviceProfileState.this.mDevice)) return true;
            Log.i(BluetoothDeviceProfileState.TAG, "Headset:Connect Other Profiles");
            BluetoothDeviceProfileState.this.mHeadsetService.connectHeadset(BluetoothDeviceProfileState.this.mDevice);
            return true;
        }
    }

    private class HeadsetServiceListener
    implements BluetoothHeadset.ServiceListener {
        public HeadsetServiceListener() {
            BluetoothDeviceProfileState.access$802(BluetoothDeviceProfileState.this, new BluetoothHeadset(BluetoothDeviceProfileState.this.mContext, this));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.access$1002(BluetoothDeviceProfileState.this, true);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceDisconnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.access$1002(BluetoothDeviceProfileState.this, false);
                return;
            }
        }
    }

    private class IncomingA2dp
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private IncomingA2dp() {
        }

        @Override
        protected void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering IncomingA2dp state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 4 && this.mCommand != 8) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: IncomingA2DP state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
            }
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("IncomingA2dp State->Processing Message: " + message.what);
            new Message();
            int n = 0;
            block10: do {
                switch (n == 0 ? message.what : n) {
                    default: {
                        return false;
                    }
                    case 1: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 4;
                        continue block10;
                    }
                    case 2: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 4;
                        continue block10;
                    }
                    case 3: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 4;
                        continue block10;
                    }
                    case 5: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 4;
                        continue block10;
                    }
                    case 7: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 4;
                        continue block10;
                    }
                    case 9: 
                    case 100: 
                    case 101: 
                    case 103: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                    }
                    case 4: 
                    case 6: 
                    case 8: {
                        return true;
                    }
                    case 102: 
                }
                break;
            } while (true);
            BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
            return true;
        }
    }

    private class IncomingHandsfree
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private IncomingHandsfree() {
        }

        @Override
        protected void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering IncomingHandsfree state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 2 && this.mCommand != 6) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: IncomingHandsfree state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
            }
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("IncomingHandsfree State -> Processing Message: " + message.what);
            int n = 0;
            block11: do {
                switch (n == 0 ? message.what : n) {
                    default: {
                        return false;
                    }
                    case 1: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 6;
                        continue block11;
                    }
                    case 2: {
                        Log.e(BluetoothDeviceProfileState.TAG, "Error: Incoming connection with a pending incoming connection");
                        n = 6;
                        continue block11;
                    }
                    case 4: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 6;
                        continue block11;
                    }
                    case 3: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 6;
                        continue block11;
                    }
                    case 5: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 6;
                        continue block11;
                    }
                    case 7: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 6;
                        continue block11;
                    }
                    case 9: 
                    case 100: 
                    case 101: 
                    case 103: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                    }
                    case 6: 
                    case 8: {
                        return true;
                    }
                    case 102: 
                }
                break;
            } while (true);
            BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
            return true;
        }
    }

    private class OutgoingA2dp
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private OutgoingA2dp() {
        }

        @Override
        protected void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering OutgoingA2dp state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 3 && this.mCommand != 7) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: OutgoingA2DP state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
            }
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("OutgoingA2dp State->Processing Message: " + message.what);
            Message message2 = new Message();
            int n = 0;
            block11: do {
                switch (n == 0 ? message.what : n) {
                    default: {
                        return false;
                    }
                    case 1: {
                        BluetoothDeviceProfileState.this.processCommand(1);
                        if (!this.mStatus) return true;
                        message2.what = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        n = 3;
                        continue block11;
                    }
                    case 2: {
                        BluetoothDeviceProfileState.this.processCommand(2);
                        if (!this.mStatus) return true;
                        message2.what = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        n = 3;
                        continue block11;
                    }
                    case 4: {
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                        n = 3;
                        continue block11;
                    }
                    case 5: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 3;
                        continue block11;
                    }
                    case 6: {
                        if (!this.mStatus) return true;
                        message2.what = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        n = 3;
                        continue block11;
                    }
                    case 7: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        n = 3;
                        continue block11;
                    }
                    case 9: 
                    case 100: 
                    case 101: 
                    case 103: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                    }
                    case 3: 
                    case 8: {
                        return true;
                    }
                    case 102: 
                }
                break;
            } while (true);
            BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
            return true;
        }
    }

    private class OutgoingHandsfree
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private OutgoingHandsfree() {
        }

        @Override
        protected void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering OutgoingHandsfree state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 1 && this.mCommand != 5) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: OutgoingHandsfree state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("OutgoingHandsfree State -> Processing Message: " + message.what);
            Message message2 = new Message();
            int n = message.what;
            switch (n) {
                default: {
                    return false;
                }
                case 1: {
                    if (n == this.mCommand) return true;
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 2: {
                    if (this.mCommand == 1) {
                        BluetoothDeviceProfileState.this.cancelCommand(1);
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                        return true;
                    }
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                    if (!this.mStatus) return true;
                    message2.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(message2);
                    return true;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 5: {
                    if (this.mCommand != 1) return true;
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    BluetoothDeviceProfileState.this.processCommand(5);
                    return true;
                }
                case 6: {
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    return true;
                }
                case 7: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 8: {
                    if (!this.mStatus) return true;
                    message2.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(message2);
                    return true;
                }
                case 9: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 102: 
            }
            BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
            return true;
        }
    }

    private class PbapServiceListener
    implements BluetoothPbap.ServiceListener {
        public PbapServiceListener() {
            BluetoothDeviceProfileState.access$1102(BluetoothDeviceProfileState.this, new BluetoothPbap(BluetoothDeviceProfileState.this.mContext, this));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.access$1202(BluetoothDeviceProfileState.this, true);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceDisconnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.access$1202(BluetoothDeviceProfileState.this, false);
                return;
            }
        }
    }
}

